/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.gui;

import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.impl.gui.MouseKeyboardSortingStrategy;
import ca.odell.glazedlists.impl.gui.MouseOnlySortingStrategy;
import ca.odell.glazedlists.impl.gui.SortingState;
import ca.odell.glazedlists.impl.sort.TableColumnComparator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.List;

public abstract class AbstractTableComparatorChooser {
    public static final Object SINGLE_COLUMN = new MouseOnlySortingStrategy(false);
    public static final Object MULTIPLE_COLUMN_MOUSE = new MouseOnlySortingStrategy(true);
    public static final Object MULTIPLE_COLUMN_KEYBOARD = new MouseKeyboardSortingStrategy();
    protected SortedList sortedList;
    private TableFormat tableFormat;
    protected Comparator sortedListComparator = null;
    protected final SortingState sortingState = new SortingState(this);

    protected AbstractTableComparatorChooser(SortedList sortedList, TableFormat tableFormat) {
        this.sortedList = sortedList;
        this.setTableFormat(tableFormat);
        this.sortingState.addPropertyChangeListener(new SortingStateListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildComparator() {
        Comparator rebuiltComparator = this.sortingState.buildComparator();
        this.sortedList.getReadWriteLock().writeLock().lock();
        try {
            this.sortedListComparator = rebuiltComparator;
            this.sortedList.setComparator(rebuiltComparator);
        }
        finally {
            this.sortedList.getReadWriteLock().writeLock().unlock();
        }
    }

    protected void setTableFormat(TableFormat tableFormat) {
        this.tableFormat = tableFormat;
        this.sortingState.rebuildColumns(tableFormat);
    }

    public List getComparatorsForColumn(int column) {
        return ((SortingState.SortingColumn)this.sortingState.getColumns().get(column)).getComparators();
    }

    public List getSortingColumns() {
        return this.sortingState.getSortingColumnIndexes();
    }

    public int getColumnComparatorIndex(int column) {
        return ((SortingState.SortingColumn)this.sortingState.getColumns().get(column)).getComparatorIndex();
    }

    public boolean isColumnReverse(int column) {
        return ((SortingState.SortingColumn)this.sortingState.getColumns().get(column)).isReverse();
    }

    public void appendComparator(int column, int comparatorIndex, boolean reverse) {
        this.sortingState.appendComparator(column, comparatorIndex, reverse);
        this.sortingState.fireSortingChanged();
    }

    public void clearComparator() {
        this.sortingState.clearComparators();
        this.sortingState.fireSortingChanged();
    }

    protected void redetectComparator(Comparator currentComparator) {
        this.sortedListComparator = currentComparator;
        this.sortingState.detectStateFromComparator(currentComparator);
    }

    protected int getSortingStyle(int column) {
        return ((SortingState.SortingColumn)this.sortingState.getColumns().get(column)).getSortingStyle();
    }

    public Comparator createComparatorForElement(Comparator comparatorForColumn, int column) {
        return new TableColumnComparator(this.tableFormat, column, comparatorForColumn);
    }

    public String toString() {
        return this.sortingState.toString();
    }

    public void fromString(String stringEncoded) {
        this.sortingState.fromString(stringEncoded);
        this.sortingState.fireSortingChanged();
    }

    public void dispose() {
        this.sortedList = null;
        this.tableFormat = null;
        this.sortedListComparator = null;
    }

    private class SortingStateListener
    implements PropertyChangeListener {
        private SortingStateListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AbstractTableComparatorChooser.this.rebuildComparator();
        }
    }
}

