/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: environment.cxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 22:40:41 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#if OSL_DEBUG_LEVEL == 0
#  ifndef NDEBUG
#    define NDEBUG
#  endif
#endif
#include <assert.h>

#include <stdio.h>

#include <osl/interlck.h>
#include <osl/conditn.h>
#include <osl/mutex.hxx>
#include <osl/thread.hxx>

#include <rtl/alloc.h>

#include <uno/environment.h>
#include <uno/lbnames.h>
#include <uno/mapping.hxx>
#include <uno/threadpool.h>

#include <com/sun/star/uno/Sequence.hxx>

#include <bridges/remote/proxy.hxx>
#include <bridges/remote/stub.hxx>
#include <bridges/remote/counter.hxx>
#include <bridges/remote/mapping.hxx>
#include <bridges/remote/helper.hxx>

#include "iothreads.hxx"
#include "conversion.h"


using namespace ::rtl;

namespace bridges_remote {

#if OSL_DEBUG_LEVEL > 1
static MyCounter thisCounter( "Remote Environment" );
#endif

// are we in static destructor ?
sal_Bool g_bStaticDestructorsCalled = sal_False;
struct StaticSingleton
{
	~StaticSingleton()
		{
			g_bStaticDestructorsCalled = sal_True;
		}
};
StaticSingleton singleton;

void SAL_CALL releaseStubs( uno_Environment *pEnvRemote )
{

	((remote_Context * ) pEnvRemote->pContext )->m_pBridgeImpl->m_bReleaseStubsCalled = sal_True;

	remote_Interface **ppInterfaces = 0;
	sal_Int32 nCount;
	pEnvRemote->pExtEnv->getRegisteredInterfaces( pEnvRemote->pExtEnv,
										 (void***)&ppInterfaces,
										 &nCount,
										 rtl_allocateMemory );

	sal_Int32 i;
	for( i  = 0 ; i < nCount ; i ++ )
	{
		if( ppInterfaces[i]->acquire == Uno2RemoteStub::thisAcquire )
		{
			// these are freed by the environment, so no release necessary
			pEnvRemote->pExtEnv->revokeInterface( pEnvRemote->pExtEnv, ppInterfaces[i] );
		}
		else
		{
			ppInterfaces[i]->release( ppInterfaces[i] );
		}
	}

	rtl_freeMemory( (void*) ppInterfaces );
}



struct RemoteEnvironment
{

	static void SAL_CALL thisDisposing( uno_Environment *pEnvRemote );
	static void SAL_CALL thisComputeObjectIdentifier( uno_ExtEnvironment *pEnvRemote,
													  rtl_uString **ppOid,
													  void *pInterface );
	static void SAL_CALL thisAcquireInterface( uno_ExtEnvironment * pEnvRemote ,
											   void *pInterface );
	static void SAL_CALL thisReleaseInterface( uno_ExtEnvironment * pEnvRemote,
											   void *pInterface);
	static void SAL_CALL thisDispose( uno_Environment *pEnvRemote );
};




void RemoteEnvironment::thisDispose( uno_Environment *pEnvRemote )
{
	remote_Context *pContext = (remote_Context *) pEnvRemote->pContext;

	// no tiding up in static destructor ( no need ).
	if( ! g_bStaticDestructorsCalled  && ! pContext->m_pBridgeImpl->m_bDisposed )
	{
		// TODO : not threadsafe
		// synchronization with dispatch methods needed !

		pContext->m_pBridgeImpl->m_bDisposed = sal_True;
		pContext->m_pConnection->close( pContext->m_pConnection );
		uno_threadpool_dispose(
			(uno_ThreadPool) ((iiop_BridgeImpl*)pContext->m_pBridgeImpl)->m_hThreadPool );

		if( 0 == pContext->m_pBridgeImpl->m_nRemoteThreads )
		{
			pContext->m_pBridgeImpl->m_allThreadsAreGone( pEnvRemote );
		}
	}
}


void RemoteEnvironment::thisDisposing( uno_Environment *pEnvRemote )
{
 	remote_Context *pContext = ( remote_Context * ) pEnvRemote->pContext;

	// inform remote counterpart, that we go down.
	sendCloseConnection( pEnvRemote );

	// close the connection
	pContext->m_pConnection->close( pContext->m_pConnection );

	iiop_BridgeImpl * pImpl = (iiop_BridgeImpl*) (pContext->m_pBridgeImpl);
	pImpl->m_pWriter->abort();

	if( osl_getThreadIdentifier(0) ==
		(oslThreadIdentifier) pImpl->m_pReader->getIdentifier() )
	{
		// This is the reader thread. Let the thread destroy itself
		pImpl->m_pReader->destroyYourself();
	}
	else
	{
		pImpl->m_pReader->join();
	}
	pImpl->m_pWriter->join();

	delete pImpl->m_pWriter;

	if( osl_getThreadIdentifier(0) !=
		(oslThreadIdentifier) pImpl->m_pReader->getIdentifier() )
	{
		// This is not the reader thread, so the thread object is deleted
		delete pImpl->m_pReader;
	}

	osl_destroyCondition( pImpl->m_cndCloseConnectionReceived );

	uno_threadpool_destroy( pImpl->m_hThreadPool );

	delete pImpl;

	pContext->dispose( pContext );
	pContext->aBase.release( (uno_Context * ) pContext );

#if OSL_DEBUG_LEVEL > 1
	thisCounter.release();
#endif
}

void RemoteEnvironment::thisComputeObjectIdentifier( uno_ExtEnvironment *pEnvRemote,
													 rtl_uString **ppOid ,
													 void *pInterface)
{
	// should never be called
	assert( 0  );
}

void RemoteEnvironment::thisAcquireInterface( uno_ExtEnvironment *pEnvRemote, void *pInterface )
{
	((remote_Interface *)pInterface)->acquire( ( remote_Interface *) pInterface );
}

void RemoteEnvironment::thisReleaseInterface( uno_ExtEnvironment *pEnvRemote, void *pInterface )
{
	((remote_Interface *)pInterface)->release( ( remote_Interface *) pInterface );
}

//##################################################################################################
extern "C" void SAL_CALL uno_initEnvironment(
	uno_Environment * pEnvRemote )
{
	// set C-virtual methods
	pEnvRemote->environmentDisposing = RemoteEnvironment::thisDisposing;
	pEnvRemote->pExtEnv->computeObjectIdentifier = RemoteEnvironment::thisComputeObjectIdentifier;
	pEnvRemote->pExtEnv->acquireInterface = RemoteEnvironment::thisAcquireInterface;
	pEnvRemote->pExtEnv->releaseInterface = RemoteEnvironment::thisReleaseInterface;
	pEnvRemote->dispose = RemoteEnvironment::thisDispose;

	remote_Context *pContext = ( remote_Context * ) pEnvRemote->pContext;
	pContext->aBase.acquire( ( uno_Context * )  pContext );
	pContext->getRemoteInstance = ::bridges_remote::remote_sendQueryInterface;

	// Initialize impl struct
	iiop_BridgeImpl *pImpl = new iiop_BridgeImpl;
	pContext->m_pBridgeImpl = pImpl;

	pImpl->m_hThreadPool = uno_threadpool_create();
	pImpl->m_allThreadsAreGone = releaseStubs;
	pImpl->m_sendRequest = sendRequestClientSide;
	pImpl->m_nRemoteThreads = 0;
	pImpl->m_cndCloseConnectionReceived = osl_createCondition();
	pImpl->m_nRequestId = 0;
	pImpl->m_bDisposed = sal_False;
	pImpl->m_bReleaseStubsCalled = sal_False;
	osl_resetCondition( pImpl->m_cndCloseConnectionReceived );

     // will need later an if OSL_DEBUG_LEVEL
	pImpl->m_pLogFile = 0;
	char *p = getenv( "PROT_REMOTE" );
	if( p )
	{
		pImpl->m_pLogFile = fopen( p , "w" );
	}

	// start reader and writer threads
	pImpl->m_pWriter = new OWriterThread( pContext->m_pConnection );
	pImpl->m_pWriter->create();

	pImpl->m_pReader = new OReaderThread(
		pContext->m_pConnection,
		dispatchRequestServerSide,
		pEnvRemote,
		pImpl->m_pWriter );
	pImpl->m_pReader->create();

#ifdef VERBOSE
	printf( "Initializing remote environment\n" );
#endif
#if OSL_DEBUG_LEVEL > 1
	thisCounter.acquire();
#endif
}


//##################################################################################################
extern "C" void SAL_CALL uno_ext_getMapping(
	uno_Mapping ** ppMapping,
	uno_Environment * pFrom,
	uno_Environment * pTo )
{
	assert( ppMapping && pFrom && pTo );
	if (ppMapping && pFrom && pTo)
	{
		if (*ppMapping)
			((*ppMapping)->release)( *ppMapping );
		RemoteMapping * pMapping = 0;

		::rtl::OUString sFromName = pFrom->pTypeName;
		::rtl::OUString sToName = pTo->pTypeName;
		::rtl::OUString sUno = OUString::createFromAscii( UNO_LB_UNO );
		::rtl::OUString sRemote = OUString::createFromAscii( "iiop" );
		if ( sFromName.equalsIgnoreAsciiCase( sRemote ) &&
			 sToName.equalsIgnoreAsciiCase( sUno ) )
		{
			pMapping =  new RemoteMapping( pTo, /* Uno */
										   pFrom, /*remote*/
										   RemoteMapping::remoteToUno,
										   OUString() );
		}
		else if ( sFromName.equalsIgnoreAsciiCase( sUno ) &&
				  sToName.equalsIgnoreAsciiCase( sRemote ) )
		{
			pMapping =  new RemoteMapping( pFrom ,
										   pTo ,
										   RemoteMapping::unoToRemote,
										   OUString() );
		}

		*ppMapping = (uno_Mapping * )pMapping;
		OUString dummy;
		uno_registerMapping( ppMapping ,
							 RemoteMapping::thisFree,
							 pFrom ,
							 pTo ,
							 dummy.pData );
	}
}

} // end namespace bridges_remote
