
package org.netbeans.modules.openoffice.wizard.nodes;

import java.beans.FeatureDescriptor;
import java.util.StringTokenizer;
import org.netbeans.modules.openoffice.wizard.panels.idl.BasePanel;
import org.netbeans.modules.openoffice.wizard.panels.idl.ValuePanel;
import org.netbeans.modules.openoffice.wizard.keys.NameKey;
import org.netbeans.modules.openoffice.wizard.keys.ValueKey;
import org.openide.nodes.AbstractNode;
import java.util.Vector;
import org.openide.nodes.Node;


public class ValueNode extends LeafNode
{

    
   private static final String ICON_BASE = "org/netbeans/modules/openoffice/wizard/ui/state_member";
   
   public ValueNode(ValueKey valuekey)
    {
        super(valuekey);
        setName(valuekey.getName());
        setIconBase("org/netbeans/modules/openoffice/wizard/ui/state_member");
    }

    public String generateSelf(int i)
    {
        String s = "";
        for(int j = 0; j < i; j++)
            s = s + "    ";

        ValueKey valuekey = (ValueKey)key;
        if(valuekey.isPublic())
            s = s + "public ";
        else
            s = s + "private ";
        s = s + valuekey.getType() + " " + valuekey.getName() + " ";
        String s1 = valuekey.getLength();
        if(s1 != null && s1.length() > 0)
        {
            for(StringTokenizer stringtokenizer = new StringTokenizer(s1, ","); stringtokenizer.hasMoreTokens();)
            {
                String s2 = stringtokenizer.nextToken().trim();
                s = s + "[" + s2 + "] ";
            }

        }
        s = s.substring(0, s.length() - 1) + ";\n";
        return s;
    }

    public BasePanel getEditPanel()
    {
        ValuePanel valuepanel = new ValuePanel();
        ValueKey valuekey = (ValueKey)key;
        valuepanel.setName(valuekey.getName());
        valuepanel.setType(valuekey.getType());
        valuepanel.setPublic(valuekey.isPublic());
        valuepanel.setLength(valuekey.getLength());
        return valuepanel;
    }

    public void reInit(BasePanel BasePanel)
    {
        if(BasePanel instanceof ValuePanel)
        {
            ValuePanel valuepanel = (ValuePanel)BasePanel;
            ValueKey valuekey = (ValueKey)key;
            String s = valuepanel.getName();
            String s1 = valuepanel.getType();
            String s2 = valuepanel.getLength();
            boolean flag = valuepanel.isPublic();
            if(!getName().equals(s))
            {
                setName(s);
                valuekey.setName(s);
            }
            if(!valuekey.getType().equals(s1))
                valuekey.setType(s1);
            if(!valuekey.getLength().equals(s2))
                valuekey.setLength(s2);
            valuekey.setPublic(flag);
        }
    }

   public void generateImports(Vector Imports1)
    {  
        Node anode[] = getChildren().getNodes();
        for(int l = 0; l < anode.length; l++)
        {
            ((BaseNode)anode[l]).generateImports(Imports1);
            
        }  
    }        
  
}
