/*
 * OOServiceClassPanel.java
 *
 * Created on August 2, 2002, 3:03 PM
 */

package org.netbeans.modules.openoffice.wizard.panels.service;

import javax.swing.JPanel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.openoffice.wizard.IDLInterface;
import org.netbeans.modules.openoffice.wizard.OOAddinData;
import org.netbeans.modules.openoffice.wizard.OOServiceData;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.src.Identifier;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.WizardDescriptor;


/**
 *
 * @author  Bertram Nolte
 */
public class OOServiceClassPanel extends JPanel implements DocumentListener,
WizardDescriptor.Panel {
    private boolean initialized;
    private OOServiceData data;
    private ArrayList changeListeners = new ArrayList(1);
    private boolean booleanIsValid = false;
    
    /** Creates new form OOServiceClassPanel */
    public OOServiceClassPanel() {
        initComponents();
        setName( NbBundle.getMessage( OOServiceClassPanel.class,
        "TITLE_WizardPanel" ) );
    }
    
    public OOServiceClassPanel(OOServiceData ooServiceData) {
        data = ooServiceData;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jlabelHeader = new javax.swing.JLabel();
        jtextfieldServiceName = new javax.swing.JTextField();
        jlabelServiceName = new javax.swing.JLabel();
        jtextfieldImplementationName = new javax.swing.JTextField();
        jlabelImplementationName = new javax.swing.JLabel();
        jtextfieldPackage = new javax.swing.JTextField();
        jlabelPackage = new javax.swing.JLabel();
        jtextfieldInterfaces = new javax.swing.JTextField();
        jlabelInterfaces = new javax.swing.JLabel();
        jbuttonInterfaces = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        setToolTipText("Setup Panel");
        setMinimumSize(new java.awt.Dimension(399, 242));
        setPreferredSize(new java.awt.Dimension(500, 330));
        jlabelHeader.setFont(new java.awt.Font("Dialog", 0, 12));
        jlabelHeader.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/service/Bundle").getString("TXT_DeclareDialog"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(jlabelHeader, gridBagConstraints);

        jtextfieldServiceName.setPreferredSize(null);
        // Is object an instance of OOAddinData?
        if ( data instanceof OOAddinData ) {
            // Set the default service name.
            jtextfieldServiceName.setText( "com.sun.star.sheet.addin.CalcAddins" );

            // The service name should not be editable.
            jtextfieldServiceName.setEditable( false );
        }
        else {
            // The service name should be editable.
            jtextfieldServiceName.setEditable( true );
        }

        initialized = true;

        jtextfieldServiceName.getDocument().addDocumentListener( this );

        jtextfieldServiceName.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jtextfieldServiceNameFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        add(jtextfieldServiceName, gridBagConstraints);

        jlabelServiceName.setFont(new java.awt.Font("Dialog", 0, 12));
        jlabelServiceName.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/service/Bundle").getString("LBL_ServiceName"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 1, 1, 1);
        add(jlabelServiceName, gridBagConstraints);

        jtextfieldImplementationName.setEditable(false);
        jtextfieldImplementationName.setPreferredSize(null);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        add(jtextfieldImplementationName, gridBagConstraints);

        jlabelImplementationName.setFont(new java.awt.Font("Dialog", 0, 12));
        jlabelImplementationName.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/service/Bundle").getString("LBL_Implementationname"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 1, 1, 1);
        add(jlabelImplementationName, gridBagConstraints);

        jtextfieldPackage.setEditable(false);
        jtextfieldPackage.setPreferredSize(null);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        add(jtextfieldPackage, gridBagConstraints);

        jlabelPackage.setFont(new java.awt.Font("Dialog", 0, 12));
        jlabelPackage.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/service/Bundle").getString("LBL_PackageName"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 1, 1, 1);
        add(jlabelPackage, gridBagConstraints);

        jtextfieldInterfaces.setEditable(false);
        jtextfieldInterfaces.setPreferredSize(null);
        jtextfieldInterfaces.getDocument().addDocumentListener( this );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        add(jtextfieldInterfaces, gridBagConstraints);

        jlabelInterfaces.setFont(new java.awt.Font("Dialog", 0, 12));
        jlabelInterfaces.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/service/Bundle").getString("LBL_InterfaceName"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 1, 1, 1);
        add(jlabelInterfaces, gridBagConstraints);

        jbuttonInterfaces.setText("...");
        jbuttonInterfaces.setToolTipText("Add and remove interfaces.");
        jbuttonInterfaces.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbuttonInterfacesActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        add(jbuttonInterfaces, gridBagConstraints);

    }//GEN-END:initComponents
        
    private void jtextfieldServiceNameFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_jtextfieldServiceNameFocusLost
        data.setServiceName( jtextfieldServiceName.getText() );
    }//GEN-LAST:event_jtextfieldServiceNameFocusLost
    
    private void jbuttonInterfacesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbuttonInterfacesActionPerformed
        OOInterfacePanel aPanel = new OOInterfacePanel( data );
        aPanel.display();
        Object NewInterfaces[] = aPanel.getInterfaces();
        jtextfieldInterfaces.setText( "" );
        Vector NewInterfaceName = new Vector();
        
        for ( int j = 0; j < NewInterfaces.length; j++ ) {
            jtextfieldInterfaces.setText( jtextfieldInterfaces.getText()
            + NewInterfaces[ j ].toString() + ";" );
            NewInterfaceName.add( NewInterfaces[ j ] );
            
        }
    }//GEN-LAST:event_jbuttonInterfacesActionPerformed
    
    /** Add a listener to changes of the panel's validity.
     * @param changeListener the listener to add
     * @see #isValid
     */
    public void addChangeListener( ChangeListener changeListener ) {
        if ( !changeListeners.contains( changeListener ) ) {
            changeListeners.add( changeListener );
        }
    }
    
    /** Remove a listener to changes of the panel's validity.
     * @param changeListener the listener to remove
     */
    public void removeChangeListener( ChangeListener changeListener ) {
        changeListeners.remove( changeListener );
    }

    /** Notifyes listeners that panel's validation changed */
    private void fireStateChanged() {
        for ( int i = 0; i < changeListeners.size(); i++ )
            ( ( ChangeListener ) changeListeners.get( i ) ).stateChanged(
                new ChangeEvent( this ) );
    }

    public java.awt.Component getComponent() {
        if ( !initialized ) {
            initialize();
        }
        
        return this;
    }
    
    public org.openide.util.HelpCtx getHelp() {
        return new HelpCtx( "org.netbeans.modules.openoffice.help.HOMEID" );
    }
    
    public void readSettings(Object obj) {
        if ( obj instanceof TemplateWizard ) {
            
            TemplateWizard templatewizard = ( TemplateWizard ) obj;
            DataObject dataobject = null;
            DataFolder datafolder = null;
            try {
                dataobject = templatewizard.getTemplate();
                data.setTarget( dataobject );
                datafolder = templatewizard.getTargetFolder();
                data.setTargetFolder( datafolder );
                data.setClassName( templatewizard.getTargetName() );
            }
            catch( IOException ioexception ) {
            }
            
            if ( dataobject == null || datafolder == null )
                throw new IllegalStateException(
                "Expected target folder and template, got null(s)" );
            
            jtextfieldPackage.setText( data.getPackage() );
        }
    }
    
    public void storeSettings(Object obj) {
    }
    
    private void initialize() {
        initComponents();
        setName( NbBundle.getMessage( OOServiceClassPanel.class,
        "TITLE_WizardPanel" ) );
    }
    
    public void addNotify() {
        jtextfieldImplementationName.setText( data.getClassName() );
        Identifier[] InterfaceNames = data.getInterfaces();
        jtextfieldInterfaces.setText( "" );
        for ( int b=0; b < InterfaceNames.length ; b++ ) {
            if ( b == 0 ) {
                jtextfieldInterfaces.setText( InterfaceNames[ b ].toString() );
            }
            else {
                jtextfieldInterfaces.setText( jtextfieldInterfaces.getText()
                + ";" + InterfaceNames[ b ].toString() );
            }
        }
        super.addNotify();
    }
    
    
    
    public void removeNotify() {
        super.removeNotify();
    }
    
    public boolean isValid() {
        return booleanIsValid;
    }
    
    public void changedUpdate(javax.swing.event.DocumentEvent documentEvent) {
        this.setValidity();
    }
    
    public void insertUpdate(javax.swing.event.DocumentEvent documentEvent) {
        this.setValidity();
    }
    
    public void removeUpdate(javax.swing.event.DocumentEvent documentEvent) {
        this.setValidity();
    }
    
    public void setValidity() {
        String stringServiceName = jtextfieldServiceName.getText();
        booleanIsValid = false;
        
        if ( !stringServiceName.trim().equals( "" ) ) {
            Vector vectorIDLInterfaces = data.getIDLInterfaces();
            
            for ( int intIndex = 0; intIndex < vectorIDLInterfaces.size();
            intIndex++ ) {
                String stringIDLFullName = ( ( IDLInterface )
                vectorIDLInterfaces.elementAt(
                intIndex ) ).getIdentifierName().getFullName();
                
                if ( ( !stringIDLFullName.equals( "com.sun.star.sheet.XAddin" ) )
                && ( !stringIDLFullName.equals( "com.sun.star.lang.XServiceName" ) )
                && ( !stringIDLFullName.equals( "com.sun.star.lang.XServiceInfo" ) )
                && ( !stringIDLFullName.equals( "com.sun.star.lang.XTypeProvider" ) )
                ) {
                    booleanIsValid = true;
                }
            }
        }
        
        fireStateChanged();
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField jtextfieldInterfaces;
    private javax.swing.JLabel jlabelHeader;
    private javax.swing.JLabel jlabelServiceName;
    private javax.swing.JTextField jtextfieldServiceName;
    private javax.swing.JLabel jlabelPackage;
    private javax.swing.JButton jbuttonInterfaces;
    private javax.swing.JLabel jlabelImplementationName;
    private javax.swing.JLabel jlabelInterfaces;
    private javax.swing.JTextField jtextfieldPackage;
    private javax.swing.JTextField jtextfieldImplementationName;
    // End of variables declaration//GEN-END:variables
    
}
