/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: userpaintoverlay.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:24:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SLIDESHOW_USERPAINTOVERLAY_HXX
#define _SLIDESHOW_USERPAINTOVERLAY_HXX

#ifndef BOOST_SHARED_PTR_HPP_INCLUDED
#include <boost/shared_ptr.hpp>
#endif

#ifndef _BGFX_POLYGON_B2DPOLYPOLYGON_HXX
#include <basegfx/polygon/b2dpolypolygon.hxx>
#endif

#include <unoview.hxx>
#include <eventmultiplexer.hxx>
#include <activitiesqueue.hxx>
#include <rgbcolor.hxx>


/* Definition of UserPaintOverlay class */

namespace presentation
{
    namespace internal
    {
        class PaintOverlayHandler;

		/** Slide overlay, which can be painted into by the user.

			This class registers itself at the EventMultiplexer,
			listening for mouse clicks and moves. When the mouse is
			dragged, a hand sketching in the selected color is shown.
		*/
		class UserPaintOverlay
		{
		public:
            /** Create a UserPaintOverlay

            	@param rStrokeColor
                Color to use for drawing

                @param nStrokeWidth
                Width of the stroked path
             */
			UserPaintOverlay( const RGBColor& 	rStrokeColor,
                              double		  	nStrokeWidth,
                              EventMultiplexer& rMultiplexer,
                              ActivitiesQueue&  rActivitiesQueue );
            ~UserPaintOverlay(); // outline because of shared_ptr with
                                 // forward-declared class

            bool addView( const UnoViewSharedPtr& rView );
			bool removeView( const UnoViewSharedPtr& rView );

		private:
            ::boost::shared_ptr<PaintOverlayHandler>	mpHandler;
            EventMultiplexer&							mrMultiplexer;
		};

        typedef ::boost::shared_ptr< UserPaintOverlay > UserPaintOverlaySharedPtr;
    }
}

#endif /* _SLIDESHOW_USERPAINTOVERLAY_HXX */
