/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: plight3d.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 22:41:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

//BFS01#ifndef _SVDPAGE_HXX
//BFS01#include "svdpage.hxx"
//BFS01#endif

//BFS01#ifndef _E3D_GLOBL3D_HXX
//BFS01#include "globl3d.hxx"
//BFS01#endif

//BFS01#ifndef _E3D_POLYOB3D_HXX
//BFS01#include "polyob3d.hxx"
//BFS01#endif

#ifndef _E3D_PLIGHT3D_HXX
#include "plight3d.hxx"
#endif

//BFS01TYPEINIT1(E3dPointLight, E3dLight);

/*************************************************************************
|*
|* E3dPointLight-Konstruktor
|*
\************************************************************************/

//BFS01E3dPointLight::E3dPointLight(const Vector3D& rPos, const Color& rColor,
//BFS01							 double fLightIntensity) :
//BFS01	E3dLight(rPos, rColor, fLightIntensity)
//BFS01{
//BFS01	CreateLightObj();
//BFS01}

/*************************************************************************
|*
|* E3dPointLight-Destruktor
|*
\************************************************************************/

//BFS01E3dPointLight::~E3dPointLight()
//BFS01{
//BFS01}

/*************************************************************************
|*
|* Identifier zurueckgeben
|*
\************************************************************************/

//BFS01UINT16 E3dPointLight::GetObjIdentifier() const
//BFS01{
//BFS01	return E3D_POINTLIGHT_ID;
//BFS01}

/*************************************************************************
|*
|* Lichtstaerke an uebergeben Punkt bestimmen und die akkumulierte
|* Punktfarbe berechnen
|*
\************************************************************************/

//BFS01FASTBOOL E3dPointLight::CalcLighting(Color& rNewColor,
//BFS01									 const Vector3D& rPnt,
//BFS01									 const Vector3D& rPntNormal,
//BFS01									 const Color& rPntColor)
//BFS01{
//BFS01	double fR = 0, fG = 0, fB = 0;
//BFS01
//BFS01	if ( IsOn() )
//BFS01	{
//BFS01		double fLight;
//BFS01		Vector3D aPntToLight = GetTransPosition() - rPnt;
//BFS01
//BFS01		aPntToLight.Normalize();
//BFS01		fLight = rPntNormal.Scalar(aPntToLight);
//BFS01
//BFS01		if ( fLight > 0 )
//BFS01		{
//BFS01			fR = fLight * GetRed();
//BFS01			fG = fLight * GetGreen();
//BFS01			fB = fLight * GetBlue();
//BFS01		}
//BFS01	}
//BFS01	return ImpCalcLighting(rNewColor, rPntColor, fR, fG, fB);
//BFS01}

/*************************************************************************
|*
|* Darstellung des Lichtobjekts in der Szene ein-/ausschalten
|*
\************************************************************************/

//BFS01void E3dPointLight::CreateLightObj()
//BFS01{
//BFS01	pSub->Clear();
//BFS01
//BFS01	if ( IsLightObjVisible() )
//BFS01	{
//BFS01		Vector3D aDiff(0.5,0,0);
//BFS01		Insert3DObj(new E3dPolyObj(GetPosition() - aDiff, GetPosition() + aDiff));
//BFS01		aDiff = Vector3D(0,0.5,0);
//BFS01		Insert3DObj(new E3dPolyObj(GetPosition() - aDiff, GetPosition() + aDiff));
//BFS01		aDiff = Vector3D(0,0,0.5);
//BFS01		Insert3DObj(new E3dPolyObj(GetPosition() - aDiff, GetPosition() + aDiff));
//BFS01		aDiff = Vector3D(0.35,0.35,0.35);
//BFS01		Insert3DObj(new E3dPolyObj(GetPosition() - aDiff, GetPosition() + aDiff));
//BFS01		aDiff = Vector3D(0.35,0.35,-0.35);
//BFS01		Insert3DObj(new E3dPolyObj(GetPosition() - aDiff, GetPosition() + aDiff));
//BFS01		aDiff = Vector3D(-0.35,0.35,-0.35);
//BFS01		Insert3DObj(new E3dPolyObj(GetPosition() - aDiff, GetPosition() + aDiff));
//BFS01		aDiff = Vector3D(-0.35,0.35,0.35);
//BFS01		Insert3DObj(new E3dPolyObj(GetPosition() - aDiff, GetPosition() + aDiff));
//BFS01	}
//BFS01}



