/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dosmsc.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:14:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <stdio.h>
#include <ctype.h>

#include "dosmsc.hxx"

//--------------------------------------------------------------------

static char sBuf[256];

//--------------------------------------------------------------------

struct dirent *readdir( DIR *pDir )
{
    int nOk;
    if ( pDir->p )
    {
        char *pCWD = getcwd( sBuf, sizeof( sBuf ) - 1 );

        // Bug in _dos_findfirst bei .\*.* ( fuer ihn == \*.* oder so )
        if ( strcmp( pDir->p, "." ) == 0 )
            // also *.* ohne was davor
            strcpy( sBuf, "*.*" );
        else
        {
            // *.* dahinter, ggf. mit "\\" abtrennen (falls nicht schon da)
            strcpy( sBuf, pDir->p );
            strcat( sBuf, "\\*.*" + ( *(sBuf + strlen( sBuf ) - 1 ) == '\\' ) );
        }
        nOk = !_dos_findfirst( sBuf, 0xFF&~_A_VOLID, &pDir->aDirEnt );
        pDir->p = NULL;
    }
    else
    {
        nOk = !_dos_findnext( &pDir->aDirEnt );
    }

#ifdef old
    if ( nOk )
        for ( char *p = pDir->aDirEnt.d_name; *p; p++ )
            if ( *p >= 'A' && *p <= 'Z' )
                *p = tolower( *p );
            else
                switch ( *p )
                {
                    case '': *p = ''; break;
                    case '': *p = ''; break;
                    case '': *p = ''; break;
                    case '': *p = ''; break;
                }
#endif

    return nOk ? &pDir->aDirEnt : NULL;
}

int closedir( DIR *pDir )
{
    if ( pDir )
        delete pDir;
    return (pDir != NULL);
}

DIR *opendir( const char* pPfad )
{
    DIR *pDir = new DIR;
    if ( pDir )
        pDir->p = (char*) pPfad;
    return pDir;
}

char *volumeid( const char* pPfad )
{
    static char sVolume[260];

    String aPfad( pPfad );
    aPfad.ToLower();
    aPfad.Cut( 2 );
    if ( aPfad != "a:" && aPfad != "b" )
    {
        // keine Meckerdialoge
        FSysFailOnErrorImpl();

#ifdef WIN
        struct dirent _near aDirEnt;
        // unter Windows koennen wir die Netzwerknamen auch leicht rausbekommen
        unsigned nLen = sizeof(sVolume);
        unsigned nErr = WNetGetConnection( (char*) pPfad, sVolume, &nLen );
        if ( nErr == WN_SUCCESS )
            return sVolume;
#else
        struct dirent aDirEnt;
#endif

        char* pMask = new char[ strlen( pPfad ) + 5 ];

        // *.* dahinter, ggf mit "\\" abtrennen (falls nicht schon da)
        strcpy( pMask, pPfad );
        strcat( pMask, "\\*.*" + ( *(pPfad + strlen( pPfad ) - 1 ) == '\\' ) );
        if ( !_dos_findfirst( pMask, _A_VOLID, &aDirEnt ) )
        {
            delete pMask;
            strcpy( sVolume, aDirEnt.d_name );
            return sVolume;
        }
        else
        {
            delete pMask;
            return NULL;
        }
    }

    return 0;
}

#include "dos.cxx"
