/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ucbserv.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 15:17:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HPP_
#include <com/sun/star/lang/XSingleServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_REGISTRY_XREGISTRYKEY_HPP_
#include <com/sun/star/registry/XRegistryKey.hpp>
#endif

#ifndef _UCB_HXX
#include "ucb.hxx"
#endif
#ifndef _UCBSTORE_HXX
#include "ucbstore.hxx"
#endif
#ifndef _UCBPROPS_HXX
#include "ucbprops.hxx"
#endif
#ifndef _PROVPROX_HXX
#include "provprox.hxx"
#endif

using namespace rtl;
using namespace com::sun::star::uno;
using namespace com::sun::star::lang;
using namespace com::sun::star::registry;

//=========================================================================
static sal_Bool writeInfo( void * pRegistryKey,
						   const OUString & rImplementationName,
   						   Sequence< OUString > const & rServiceNames )
{
	OUString aKeyName( OUString::createFromAscii( "/" ) );
	aKeyName += rImplementationName;
	aKeyName += OUString::createFromAscii( "/UNO/SERVICES" );

	Reference< XRegistryKey > xKey;
	try
	{
		xKey = static_cast< XRegistryKey * >(
									pRegistryKey )->createKey( aKeyName );
	}
	catch ( InvalidRegistryException const & )
	{
	}

	if ( !xKey.is() )
		return sal_False;

	sal_Bool bSuccess = sal_True;

	for ( sal_Int32 n = 0; n < rServiceNames.getLength(); ++n )
	{
		try
		{
			xKey->createKey( rServiceNames[ n ] );
		}
		catch ( InvalidRegistryException const & )
		{
			bSuccess = sal_False;
			break;
		}
	}
	return bSuccess;
}

//=========================================================================
extern "C" void SAL_CALL component_getImplementationEnvironment(
	const sal_Char ** ppEnvTypeName, uno_Environment ** ppEnv )
{
	*ppEnvTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME;
}

//=========================================================================
extern "C" sal_Bool SAL_CALL component_writeInfo(
	void * pServiceManager, void * pRegistryKey )
{
	return pRegistryKey &&

	//////////////////////////////////////////////////////////////////////
	// Universal Content Broker.
	//////////////////////////////////////////////////////////////////////

	writeInfo( pRegistryKey,
			   UniversalContentBroker::getImplementationName_Static(),
			   UniversalContentBroker::getSupportedServiceNames_Static() ) &&

	//////////////////////////////////////////////////////////////////////
	// UCB Store.
	//////////////////////////////////////////////////////////////////////

	writeInfo( pRegistryKey,
			   UcbStore::getImplementationName_Static(),
			   UcbStore::getSupportedServiceNames_Static() ) &&

	//////////////////////////////////////////////////////////////////////
	// UCB PropertiesManager.
	//////////////////////////////////////////////////////////////////////

	writeInfo( pRegistryKey,
			   UcbPropertiesManager::getImplementationName_Static(),
			   UcbPropertiesManager::getSupportedServiceNames_Static() ) &&

	//////////////////////////////////////////////////////////////////////
	// UCP Proxy Factory.
	//////////////////////////////////////////////////////////////////////

	writeInfo( pRegistryKey,
	   UcbContentProviderProxyFactory::getImplementationName_Static(),
	   UcbContentProviderProxyFactory::getSupportedServiceNames_Static() );
}

//=========================================================================
extern "C" void * SAL_CALL component_getFactory(
	const sal_Char * pImplName, void * pServiceManager, void * pRegistryKey )
{
	void * pRet = 0;

	Reference< XMultiServiceFactory > xSMgr(
			reinterpret_cast< XMultiServiceFactory * >( pServiceManager ) );
	Reference< XSingleServiceFactory > xFactory;

	//////////////////////////////////////////////////////////////////////
	// Universal Content Broker.
	//////////////////////////////////////////////////////////////////////

	if ( UniversalContentBroker::getImplementationName_Static().
				compareToAscii( pImplName ) == 0 )
	{
		xFactory = UniversalContentBroker::createServiceFactory( xSMgr );
	}

	//////////////////////////////////////////////////////////////////////
	// UCB Store.
	//////////////////////////////////////////////////////////////////////

	else if ( UcbStore::getImplementationName_Static().
				compareToAscii( pImplName ) == 0 )
	{
		xFactory = UcbStore::createServiceFactory( xSMgr );
	}

	//////////////////////////////////////////////////////////////////////
	// UCB PropertiesManager.
	//////////////////////////////////////////////////////////////////////

	else if ( UcbPropertiesManager::getImplementationName_Static().
				compareToAscii( pImplName ) == 0 )
	{
		xFactory = UcbPropertiesManager::createServiceFactory( xSMgr );
	}

	//////////////////////////////////////////////////////////////////////
	// UCP Proxy Factory.
	//////////////////////////////////////////////////////////////////////

	else if ( UcbContentProviderProxyFactory::getImplementationName_Static().
				compareToAscii( pImplName ) == 0 )
	{
		xFactory
			= UcbContentProviderProxyFactory::createServiceFactory( xSMgr );
	}

	//////////////////////////////////////////////////////////////////////

	if ( xFactory.is() )
	{
		xFactory->acquire();
		pRet = xFactory.get();
	}

	return pRet;
}

