/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fuslshow.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:50:02 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#ifndef _SD_FUSLSHOW_HXX
#define _SD_FUSLSHOW_HXX

#ifndef _COM_SUN_STAR_PRESENTATION_ANIMATIONEFFECT_HPP_
#include <com/sun/star/presentation/AnimationEffect.hpp>
#endif
#ifndef _COM_SUN_STAR_PRESENTATION_FADEEFFECT_HPP_
#include <com/sun/star/presentation/FadeEffect.hpp>
#endif
#ifndef _COM_SUN_STAR_PRESENTATION_ANIMATIONSPEED_HPP_
#include <com/sun/star/presentation/AnimationSpeed.hpp>
#endif

#include <svtools/lstner.hxx>
#ifndef _SVDPAGE_HXX //autogen
#include <bf_svx/svdpage.hxx>
#endif
#ifndef _TIME_HXX //autogen
#include <tools/time.hxx>
#endif
#ifndef _TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif
#ifndef _WRKWIN_HXX //autogen
#include <vcl/wrkwin.hxx>
#endif
#ifndef _IMAGE_HXX //autogen
#include <vcl/image.hxx>
#endif
#ifndef _SOUND_HXX //autogen
#include <vcl/sound.hxx>
#endif
#ifndef _SD_SHOWWIN_HXX
#include "showwin.hxx"
#endif
#ifndef _SD_FUPOOR_HXX
#include "fupoor.hxx"
#endif
#ifndef _SD_ANMDEF_HXX
#include "anmdef.hxx"
#endif
#ifndef _SD_ANMINFO_HXX
#include "anminfo.hxx"
#endif
#ifndef _SD_MOVEDEF_HXX
#include "movedef.hxx"
#endif
#ifndef _SD_FADEDEF_H
#include "fadedef.h"
#endif
class PushButton;
class Button;
class Sound;		   // fuer die, die Sound "rausdefiniert" haben 
class SvInPlaceClientMemberList;
class SfxItemSet;
class VirtualDevice;
class BitmapEx;
class SvtSaveOptions;
namespace binfilter {

class SdrTextObj;
class SdrRectObj;
class SdrGrafObj;
//STRIP001 class Fader;
//STRIP001 class SdBitmapMover;
class SdPage;
class OutlinerParaObject;
class SdrPaintInfoRec;
class ExtOutputDevice;
class DrawPortionInfo;
struct SdrPaintProcRec;
//STRIP001 class OutlinerInfo;
//STRIP001 class ShowView;
class SdrObject;
class SdrView;
class SdrAttrObj;
//STRIP001 class Marker;
class SdrAttrObj;
class SdCustomShow;

// -----------
// - Defines -
// -----------

#define PAGE_NO_END 		65535
#define PAGE_NO_SOFTEND		(PAGE_NO_END - 1)
#define PAGE_NO_PAUSE 		(PAGE_NO_SOFTEND - 1)
#define PAGE_NO_FIRSTDEF	PAGE_NO_PAUSE // immer mit anpassen

#define PEN_THICKNESS		100
#define SLIDESHOW_MAGIC		0x12345678
#define LASER_ALL_PARAS		0xffff
#define VDEV_TOLERANCE		2

#define OBJIS_GRAFANIM( _def_obj ) ( _def_obj->ISA( SdrGrafObj ) && ( (SdrGrafObj*) _def_obj )->IsAnimated() )
#define OBJIS_TEXTANIM( _def_obj ) ( _def_obj->ISA( SdrTextObj ) && ( (SdrTextObj*) _def_obj )->IsTextAnimated() )

// -----------------
// - AnimationMode -
// -----------------

enum AnimationMode
{
	ANIMATIONMODE_SHOW,
	ANIMATIONMODE_PREVIEW,
	ANIMATIONMODE_VIEW
};

// ----------------
// - PageFadeMode -
// ----------------

enum PageFadeMode
{
    PAGE_FADE_NORMAL = 0,
    PAGE_FADE_BLACK = 1,
    PAGE_FADE_WHITE = 2
};

// ------------------
// - SdAnimPageList -
// ------------------

//STRIP001 class SdAnimPageList : protected List
//STRIP001 {
//STRIP001 private:
//STRIP001 
//STRIP001 	USHORT		mnCurPagePos;
//STRIP001 	USHORT		mnNextPagePos;
//STRIP001 	USHORT		mnRealNextPagePos;
//STRIP001 	USHORT		mnPreparedPageNum;
//STRIP001 	BOOL		mbEndlessMode;
//STRIP001 	BOOL		mbPauseMode;
//STRIP001 	BOOL		mbSoftendMode;
//STRIP001 	sal_Int32	mnCurrentHidenPage;
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 				SdAnimPageList();
//STRIP001 				~SdAnimPageList();
//STRIP001 
//STRIP001 	void		SetEndlessMode( BOOL bSet ) { mbEndlessMode = bSet; }
//STRIP001 	BOOL		IsEndlessMode() const { return mbEndlessMode; }
//STRIP001 
//STRIP001 	void		SetPauseMode( BOOL bSet ) { mbPauseMode = bSet; }
//STRIP001 	BOOL		IsPauseMode() const { return mbPauseMode; }
//STRIP001 
//STRIP001 	void		SetSoftendMode( BOOL bSet ) { mbSoftendMode = bSet; }
//STRIP001 	BOOL		IsSoftendMode() const { return mbSoftendMode; }
//STRIP001 
//STRIP001 	void		InsertPageNum( USHORT nSdPageNum ) { Insert( (void*)(ULONG) nSdPageNum, LIST_APPEND ); }
//STRIP001 
//STRIP001 	USHORT		GetCurrentPageNum();
//STRIP001 	USHORT		GetNextPageNum();
//STRIP001 	USHORT		GetRealNextPageNum();
//STRIP001 
//STRIP001 	void		JumpToHidenPage( USHORT nHidenPageNum );
//STRIP001 
//STRIP001 	USHORT		GetFirstPageNum() { return Count() ? (USHORT)(ULONG) First() : PAGE_NO_END; }
//STRIP001 	USHORT		GetLastPageNum() { return Count() ? (USHORT)(ULONG) Last() : PAGE_NO_END; }
//STRIP001 
//STRIP001 	BOOL		IsPageNumIncluded( USHORT nSdPageNum );
//STRIP001 
//STRIP001 	USHORT		CalcNextPageNum( BOOL bForward );
//STRIP001 	BOOL		MakePageNumCurrent( USHORT nSdPageNum );
//STRIP001 
//STRIP001 	void		SetPreparedPageNum( USHORT nSdPageNum ) { mnPreparedPageNum = nSdPageNum; }
//STRIP001 	USHORT		GetPreparedPageNum() const { return mnPreparedPageNum; }
//STRIP001 
//STRIP001 	void		SetStartPage( USHORT nSdPageNum );
//STRIP001 };

// -------------------
// - SdSlowObjRecord -
// -------------------

//STRIP001 struct SdSlowObjRecord
//STRIP001 {
//STRIP001 	Point		aPos;
//STRIP001 	SdrAttrObj* pObject;
//STRIP001 	Image*		pImage;
//STRIP001 	BitmapEx*	pBmpEx;
//STRIP001 
//STRIP001 				SdSlowObjRecord() : pObject( NULL ), pImage( NULL ) {}
//STRIP001 				SdSlowObjRecord( SdrAttrObj* _pObject, const Point& _rPos ) :
//STRIP001 					aPos( _rPos ), pObject( _pObject ), pImage( NULL ), pBmpEx( NULL ) {}
//STRIP001 				~SdSlowObjRecord() { delete pImage; delete pBmpEx; }
//STRIP001 };

// ----------------
// - SdChangedObj -
// ----------------

//STRIP001 class SdChangedObj : public SfxListener
//STRIP001 {
//STRIP001 	virtual void 	SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
//STRIP001 								const SfxHint& rHint, const TypeId& rHintType );
//STRIP001 public:
//STRIP001 
//STRIP001 	SdrObject*		pObject;
//STRIP001 	Size			aMove;
//STRIP001 	BOOL			bPosChanged;
//STRIP001 	BOOL			bLayerChanged;
//STRIP001 	BOOL			bDeleted;
//STRIP001 	SdrLayerID		nLayer;
//STRIP001 
//STRIP001 					SdChangedObj() : pObject( NULL ), bPosChanged( FALSE ),
//STRIP001 									 bLayerChanged( FALSE ), bDeleted( FALSE ) {};
//STRIP001 					~SdChangedObj() {}
//STRIP001 };

// ----------------
// - SdShowStatus -
// ----------------

//STRIP001 struct SdShowStatus
//STRIP001 {
//STRIP001 	SdAnimationInfo*	pInfo;
//STRIP001 	BOOL				bShow;
//STRIP001 	BOOL				bIsShown;
//STRIP001 	BOOL				bDimmed;
//STRIP001 
//STRIP001 						SdShowStatus( SdAnimationInfo* _pInfo ) :
//STRIP001 							pInfo	( _pInfo ),
//STRIP001 							bShow	( _pInfo->bShow ),
//STRIP001 							bIsShown( _pInfo->bIsShown ),
//STRIP001 							bDimmed	( _pInfo->bDimmed ) {}
//STRIP001 };

// ---------------
// - FuSlideShow -
// ---------------

class FuSlideShow : public FuPoor
{
//STRIP001 private:
//STRIP001 
//STRIP001 	friend class SdMetaFile;
//STRIP001 
//STRIP001 	SfxItemSet*     pNewAttr;		            // die Argumente der Funktion
//STRIP001 	Timer			aTimer;
//STRIP001 	Timer			aEscapeTimer;
//STRIP001 	Fader*			pFader; 		            // fuer Seiten und Animationsobjekte
//STRIP001 	SdBitmapMover*	pMover; 		            // fuer Animationsobjekte
//STRIP001 	WorkWindow*		pWorkWindow;	            // Parent des sichtbaren Fensters
//STRIP001 	SdShowWindow*   pShowWindow;                // das sichtbare Fenster der Show
//STRIP001 	VirtualDevice*	pVDev;			            // zum Ueberblenden der Seiten
//STRIP001 	VirtualDevice*	pAnmVDev;		            // fuer Animationsobjekte
//STRIP001 	VirtualDevice*	pMskVDev;		            // fuer Animationsobjekte
//STRIP001 	ShowView*		pShowView;		            // ueber diese View zeichnet die Drawing Engine in pVDev
//STRIP001 	SvtSaveOptions*	pSaveOptions;	            // hold save options struct to avoid unwanted savings of modified state
//STRIP001 	List*			pCurAnmList;	            // Liste mit Animationsobj. der akt. Seite
//STRIP001 	List*			pNextAnmList;	            // dito fuer vorbereitete Seite
//STRIP001 	List*			pCurAnimGraphs;             // Listen mit animierten Grafiken
//STRIP001 	List*			pNextAnimGraphs;            
//STRIP001 	List*			pCurControls;	            // Listen mit Controls
//STRIP001 	List*			pNextControls;
//STRIP001 	List			aChangedList;	            // Liste mit Objecten, die geaendert wurden
//STRIP001 	SdrRectObj* 	pLayoutText;	            // zu animierender Gliederungstext
//STRIP001 	SdrRectObj* 	pLayoutClone;	            // Clone dieses Objekts
//STRIP001 	PolyPolygon*    pLayoutClip;                // Clipping fuer LayoutClone
//STRIP001 	BitmapEx*		pLayoutBmpEx;               // BitmapEx as Substitute for LayoutText
//STRIP001 	SdrRectObj*		pCompoundText;
//STRIP001 	BitmapEx*		pTopLayer;		            // TopLayer fuer Lasereffekt
//STRIP001 	Point           aLaserObjPos;               // Position des Objekts mit dem Lasereffekt
//STRIP001 	ULONG			nParaPos;		            // Position des naechsten darzustellenden Absatzes
//STRIP001 	ULONG			nDimPos;		            // Position des naechsten abzublendenden Absatzes
//STRIP001 	::com::sun::star::presentation::AnimationEffect eRandomLayout;  // der fuer die Gliederung gewaehlte Zufallseffekt (NONE --> nicht beachten)
//STRIP001 	Point			aCurTextOrigin; 		    // Textursprung des akt. Absatzes
//STRIP001 	Point			aCurTextOrigiWorld;	        // dito in Weltkoordinaten
//STRIP001 	SdrObject*      pDimObject;                 // abzublendendes Objekt (NULL moeglich)
//STRIP001 	SdrObject*      pHideObject;                // zu versteckendes Objekt (NULL moeglich)
//STRIP001 	Rectangle		aDimRect;		            // Position und Groesse zum Abblenden
//STRIP001 	Color			aDimColor;		            // Farbe fuers Abblenden
//STRIP001 	::com::sun::star::presentation::AnimationEffect eObjectEffect;	// Animationseffekt fuer das akt. Objekt
//STRIP001 	PushButton* 	pTimeButton;
//STRIP001 	Time			aSlideVisibleSince;         // Startzeitpunkt der Zeitnahme
//STRIP001 	Time            aLiveModeStartTime;         // Time, the live mode has been started
//STRIP001 	SdAnimPageList	aAnimPageList;
//STRIP001 	USHORT			nRestorePage;		        // Seite, die nach dem Beenden der Show wieder gezeigt werden soll
//STRIP001 	USHORT			nVisibleAffectingObjects;	// Anzahl der sichtbaren Objs, deren ClickAction die Seite beeinflussen
//STRIP001 	Point			aPageOrigin;		        // Ursprung des gezeigten Seitenbereichs
//STRIP001 	Size			aPageSize;			        // Groesse des gezeigten Seitenbereichs
//STRIP001     Size			aPresSize;		            // Size, die im Resize hereinkommt und fuer das asynchrone Resize benoetigt wird
//STRIP001 	ULONG			nPauseTimeout;
//STRIP001 	ULONG			nMouseClickSema;
//STRIP001 	AnimationMode   eAnimationMode;             // Show, Preview oder View
//STRIP001 	USHORT			nIgnoreInputSmph;	        // > 0 wenn Key-, Mouse- und Timerevents blockiert werden sollen
//STRIP001 	Point			aLastPos;
//STRIP001 	Point			aDownPos;
//STRIP001 	Bitmap* 		pTimeButtonBckgnd;	        // Hintergrund des Timing-Buttons
//STRIP001 	String			aCharBuffer;		        // zum Einsammeln von Ziffern (Dia per
//STRIP001 	Sound*			pSound;
//STRIP001 	Pointer 		aOldPointer;		        // falls zum Zeichnen gewechselt wurde
//STRIP001 	Pointer 		aPencil;			        // der Pointer zum Zeichnen
//STRIP001 	SdPage* 		pActualPage;		        // die gerade angezeigte Seite
//STRIP001 	SdMetaFile*		pMetaFile;			        // Metafile der aktuellen Seite
//STRIP001 	SdrObject*		pBckgndRect;		        // das Hintergrundobjekt
//STRIP001 	Rectangle		aAnimObjsBoundRect;         // umschliessendes Rechteck aller Animationsobjekte
//STRIP001 	List*			pSlowObjList;		        // Liste fuer SlowObjRecords (fuer Objekte, die zu langsam gezeichnet werden)
//STRIP001 	SvInPlaceClientMemberList* pClientList;
//STRIP001 	List*			pDrawModeWindows;	        // Liste mit Fenstern des Zeichentischs
//STRIP001 	SdWindow*		pOldActiveWindow;	        // aktives Fenster der ViewShell
//STRIP001 	OutlinerInfo*	pOutlInfo;
//STRIP001 	Link            aStarBASICGlobalErrorHdl;
//STRIP001 	ULONG           nMagic;
//STRIP001 	ULONG			nMasterPageCacheMode;
//STRIP001 	ULONG			nShellLockCount;
//STRIP001 	ULONG			nPushCount;
//STRIP001 	ULONG			nChildMask;
//STRIP001 	ULONG			nFadeInTime;		        // system time in milliseconds when this page faded in
//STRIP001 	ULONG			nStartShowEvt;
//STRIP001 	ULONG			nResizeEvt;
//STRIP001 	BOOL			bVDevEmpty : 1; 	        // ist das virtuelle Device pVDev leer?
//STRIP001 	BOOL            bFullBckgnd : 1;            // fuer PaintLayoutClone()
//STRIP001 	BOOL			bIsCompoundLayoutText : 1;	// wird nur innerhalb von AnimateLayoutText benoetigt, um den richtigen Effekt zu setzen
//STRIP001 	BOOL			bGridVisible : 1;		    // Zustand des Rasters der DrawView
//STRIP001     BOOL            bBordVisible : 1;
//STRIP001     BOOL            bPageBorderVisible : 1;
//STRIP001 	BOOL            bSetOnlineSpelling : 1;     // Muss OnlineSpelling wieder eingeschaltet werden?
//STRIP001 	BOOL			bTerminated : 1;
//STRIP001 	BOOL			bAnimationAllowed : 1;
//STRIP001 	BOOL			bDestroyed : 1;
//STRIP001 	BOOL			bReadyForNextInput : 1;
//STRIP001 	BOOL			bDesignMode : 1;
//STRIP001 	BOOL			bDirectionForward : 1;	    // Diareihenfolge vorwaerts?
//STRIP001 	BOOL			bManual : 1;			    // uebersteuert Einstellung am Dia
//STRIP001 	BOOL			bMouseVisible : 1;		    // Mauszeiger sichtbar
//STRIP001 	BOOL			bMouseAsPen : 1;		    // Zeichnen mit Maus moeglich
//STRIP001 	BOOL			bRehearseTimings : 1;	    // interaktive Zeitnahme
//STRIP001 	BOOL			bAlwaysOnTop : 1;		    // immer vor anderen Apps etc.
//STRIP001 	BOOL			bShowPauseLogo : 1;		    // immer vor anderen Apps etc.
//STRIP001 	BOOL			bMouseIsDrawing : 1;	    // Maus zeichnet gerade
//STRIP001 	BOOL			bAutoSaveSuppressed : 1;    	// wenn ein eingeschaltetes Autosave unterdrueckt wurde
//STRIP001 	BOOL			bPlayFull : 1;			    // Sound vollstaendig abspielen
//STRIP001 	BOOL			bTimerIntercepted : 1;	    // ein TimerCall wurde abgefangen
//STRIP001 	BOOL			bIVDsFound : 1; 		    // Initially Visible Disappearing Objs
//STRIP001 	BOOL			bNativeMode : 1;		    // TRUE: die Show bearbeitet Ereignisse, FALSE: weiterleiten an akt. Funktion
//STRIP001 	BOOL			bInitShowStatus : 1;	    // TRUE: PaintProc initialisiert Showstatus der Animationsinfos
//STRIP001 	BOOL			bDocChanged : 1;
//STRIP001 	BOOL			bLockedPages : 1;		    // Seite nicht bei Klick in die Flaeche wechseln
//STRIP001 	BOOL            bFullScreen : 1;            // True: ganzer Bildsch., False: Fenster
//STRIP001 	BOOL            bSoftEndReached : 1;        // show terminated normally
//STRIP001 
//STRIP001 	SdrObject*		mpDownObject;				// Stores the object the mouse was over on MouseButtonDown
//STRIP001 
//STRIP001 					DECL_LINK( StartShowHdl, void* );
//STRIP001 					DECL_LINK( ResizeHdl, void* );
//STRIP001 					DECL_LINK( DestroyHdl, void* );
//STRIP001 					DECL_LINK( PageTimeOutHdl, Timer* );
//STRIP001 					DECL_LINK( ObjectTimeOutHdl, Timer* );
//STRIP001 					DECL_LINK( TimeButtonTimeOutHdl, Timer* );
//STRIP001 					DECL_LINK( TimeButtonHdl, Button* );
//STRIP001 					DECL_LINK( EscapeHdl, Timer* );
//STRIP001 					DECL_LINK( SoundHasStoppedHdl, void * );
//STRIP001 					DECL_LINK( PaintProc, SdrPaintProcRec * );
//STRIP001 					DECL_LINK( DrawPortionHdl, DrawPortionInfo* );
//STRIP001 					DECL_LINK( ReadyForNextInputHdl, void* );
//STRIP001 
//STRIP001 	::com::sun::star::presentation::FadeEffect		EffectAToF(::com::sun::star::presentation::AnimationEffect eEffect);
//STRIP001 	MoveSpeed		SpeedAToM(::com::sun::star::presentation::AnimationSpeed eSpeed);
//STRIP001 	FadeSpeed		SpeedAToF(::com::sun::star::presentation::AnimationSpeed eSpeed);
//STRIP001 
//STRIP001 	::com::sun::star::presentation::AnimationEffect RandomAnimationEffect(BOOL bShow) const;
//STRIP001 
//STRIP001 	void			DoPageFade( PageFadeMode ePageFadeMode = PAGE_FADE_NORMAL );
//STRIP001 	void			StopShow();
//STRIP001 	ULONG			HideChildWindows();
//STRIP001 	void			ShowChildWindows( ULONG nShowMask );
//STRIP001 
//STRIP001 	void			FindSpecialObjects( const SdrPage* pPage, BOOL& rEnableOutput );
//STRIP001 	void			PrepareForPage( SdPage* pPage, BOOL bInitAnimObjs );
//STRIP001 	void			SetPaintModes(SdrView* pSourceView, SdrView* pTargetView, ExtOutputDevice* pXOut, SdrPaintInfoRec* pPaintInfoRec);
//STRIP001 
//STRIP001 	BOOL			Animate();
//STRIP001 	BOOL			AnimateLayoutText();
//STRIP001 	BOOL			AnimateObject(SdrObject* pSubstitute = NULL);
//STRIP001 	BOOL            CompoundEffect();
//STRIP001 
//STRIP001 	BOOL			Dim(SdrAttrObj* pObject, Point aPos, const Color& rDimColor);
//STRIP001 	void			DimLayoutParagraph();
//STRIP001 	void			DimParas(SdrTextObj* pTextObj, ULONG nFromPara, ULONG nToPara, Color* pColor = NULL);
//STRIP001 	void			CreateMarkerMetaFile( SdPage* pPage, BOOL bEnableOutput = FALSE );
//STRIP001 
//STRIP001 	void			StartSound(const String& rSound);
//STRIP001 
//STRIP001 	void			DeleteClientList();
//STRIP001 	BOOL			DoVerb(SdrObject* pObject, USHORT nVerb);
//STRIP001 	void			ShowPlugIns();
//STRIP001 
//STRIP001 	BOOL			IsAdvanceEvent(const Point& rDown, const Point& rUp) const;
//STRIP001 
//STRIP001 	BOOL			AffectsOwnPage(SdrObject* pObject);
//STRIP001 	BOOL			PerformAction(SdrObject* pActionObject);
//STRIP001 	BOOL			AnimateNamedObject(const String& rObjectName);
//STRIP001 	BOOL			HideOrVanishObject( SdrObject* pActionObject, BOOL bHide );
//STRIP001 
//STRIP001 	BOOL			IsSlowObj(SdrAttrObj* pObject) const;
//STRIP001 	BOOL			IsAlphaObj(SdrAttrObj* pObject) const;
//STRIP001 	BOOL			CreateSlowObjRecord(SdrAttrObj* pObject);
//STRIP001 	SdSlowObjRecord* GetSlowObjRecord(SdrAttrObj* pObject);
//STRIP001 	void			ClearSlowObjList();
//STRIP001 
//STRIP001 	BOOL			LaserEffect(SdrRectObj* pObject, USHORT nPara, const Point& rStart);
//STRIP001 
//STRIP001 	void			LockDrawViewShell();
//STRIP001 	void			UnlockDrawViewShell( BOOL bUnlockFull );
//STRIP001 
//STRIP001 	void			HandleError( const USHORT nStringId );
//STRIP001 	void			CreatePageList( BOOL bAll, BOOL bStartWithActualPage, const String& rPresPage );
//STRIP001 	void			ResortAnmList( List& rAnmList );
//STRIP001 
//STRIP001 	void			SetAnimationOwnerState( SdrView* pOwnerView, BOOL bShowIsOwner );
//STRIP001 	void			UpdateVDevWithAnimations();
//STRIP001 	void			DrawOrStartAnimation( SdrObject* pObj, OutputDevice* pOut, BOOL bStart, BOOL bTextObjs );
//STRIP001 
//STRIP001 	void			RepaintVDev( SdrPage* pRepaintPage, BOOL bOnlyMaster );
//STRIP001 	SdViewShell*	GetDrawViewShellForShow() const;
//STRIP001 
//STRIP001 	BOOL			CreateTopLayer( OutputDevice* pOut, const Marker& rStartMarker, const Marker& rEndMarker );
//STRIP001 	void			InitShowStatus( SdAnimationInfo* pInfo );
//STRIP001 	BitmapEx		CreateReplacement( SdrObject* pObj, ExtOutputDevice* pOut );
//STRIP001 	
//STRIP001 	static Color	GetVDevColor( const Color& rColor );
//STRIP001 
//STRIP001 	virtual			~FuSlideShow();

public:
//STRIP001 
//STRIP001 					TYPEINFO();
//STRIP001 
					FuSlideShow(SdViewShell* pViewSh, SdWindow* pWin, SdView* pView,SdDrawDocument* pDoc, SfxRequest& rReq):FuPoor(pViewSh, pWin, pView, pDoc, rReq) { DBG_ASSERT(0, "STRIP! FuSlideShow is deleted."); } //STRIP001 FuSlideShow(SdViewShell* pViewSh, SdWindow* pWin, SdView* pView,SdDrawDocument* pDoc, SfxRequest& rReq);
//STRIP001 	virtual void	Destroy( BOOL bDelete = TRUE );
//STRIP001 	
//STRIP001 					// Mouse- & Key-Events
	virtual BOOL	KeyInput(const KeyEvent& rKEvt);
//STRIP001 	virtual BOOL	MouseMove(const MouseEvent& rMEvt);
//STRIP001 	virtual BOOL	MouseButtonUp(const MouseEvent& rMEvt);
//STRIP001 	virtual BOOL	MouseButtonDown(const MouseEvent& rMEvt);
//STRIP001 	virtual BOOL	Command(const CommandEvent& rCEvt);
//STRIP001 	virtual BOOL	RequestHelp(const HelpEvent& rHEvt);
//STRIP001 	virtual void	Paint(const Rectangle& rRect, SdWindow* pWin);
//STRIP001 	virtual void	ReceiveRequest(SfxRequest& rReq);
//STRIP001 	virtual void	Activate(); // Function aktivieren
//STRIP001 	virtual void	Deactivate(); // Function deaktivieren
//STRIP001 
//STRIP001 	void			CreateLayoutClone();
//STRIP001 
//STRIP001 	void			JumpToPage( USHORT nNewPage );
//STRIP001 	void			JumpToBookmark(const String& rBookmark);
//STRIP001 	void			PaintDimmedObject( SdrAttrObj* pObject, OutputDevice* pOut, const Color& rDimColor, BOOL bIgnoreTransparency );
//STRIP001 	void			PaintLayoutClone(OutputDevice* pOut);
//STRIP001 
//STRIP001 	BOOL			AdjustAnmVDev( const Rectangle& rObjRect, const Color& rBackground );
//STRIP001 
//STRIP001 	void			StartShow();
//STRIP001 
//STRIP001 	void			SetFullScreen(BOOL bFlScr) { bFullScreen = bFlScr; }
//STRIP001 	BOOL			IsFullScreen() const { return bFullScreen; }
	BOOL			IsLivePresentation() const { DBG_BF_ASSERT(0, "STRIP"); return FALSE; } //STRIP001 BOOL			IsLivePresentation() const { return !bNativeMode; }
//STRIP001 	BOOL			IsDrawingPossible() const { return bMouseAsPen; }
//STRIP001 	BOOL			IsAlwaysOnTop() const { return bAlwaysOnTop; }
//STRIP001 	BOOL			IsAnimationAllowed() const { return bAnimationAllowed; }
//STRIP001 	BOOL			IsSoundPlaying() const { return( pSound && pSound->IsPlaying() ); }
//STRIP001 	BOOL			IsSoundPlayFull() const { return bPlayFull; }
//STRIP001 	ULONG			GetMasterPageCacheMode() const { return nMasterPageCacheMode; }
	AnimationMode   GetAnimationMode() const { DBG_BF_ASSERT(0, "STRIP"); return ANIMATIONMODE_SHOW;} //STRIP001 AnimationMode   GetAnimationMode() const { return eAnimationMode; }
//STRIP001 	SdrRectObj*		GetLayoutText() const { return pLayoutText; }
//STRIP001 	void			EndTextEdit(SdrTextObj* pTextObj);
//STRIP001 	USHORT			GetCurrentPage() { return aAnimPageList.GetCurrentPageNum(); }
//STRIP001 	USHORT			GetFirstPage() { return aAnimPageList.GetFirstPageNum(); }
//STRIP001 	USHORT			GetLastPage() { return aAnimPageList.GetLastPageNum(); }
//STRIP001 	BOOL			IsEndless() const { return aAnimPageList.IsEndlessMode(); }

	void			Terminate(){DBG_ASSERT(0, "STRIP! FuSlideShow is deleted.");} //STRIP001 void			Terminate();
//STRIP001 	BOOL			IsTerminated() const { return nMagic != SLIDESHOW_MAGIC; }

//STRIP001 	void			InitPageModify();

//STRIP001 	BOOL			Resize(const Size& rNewSize);
//STRIP001 	BOOL			IsInputLocked() const { return nIgnoreInputSmph > 0; }

//STRIP001 	void            SetAnimationMode(AnimationMode eMode, SdShowWindow* pWindow);
//STRIP001 	BOOL			AnimatePage();
//STRIP001 	BOOL			HideAndAnimateObject(SdrObject* pObject);
//STRIP001 	BOOL			HasAction(SdrObject* pObject);
//STRIP001 	SdrObject*		OverObject(const Point& rPos);
//STRIP001 	void			StopTextOrGraphicAnimation( SdrObject* pObject, BOOL bAll );

//STRIP001 	const SdShowWindow* GetShowWindow() const { return pShowWindow; }
//STRIP001 	ShowView*		GetShowView() const { return pShowView; }
//STRIP001 	SdPage*			GetActualPage() const { return pActualPage; }

//STRIP001 	void			Reschedule();
};

} //namespace binfilter
#endif		// _SD_FUSLSHOW_HXX
