/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_drviews3.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:36:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _EEITEMID_HXX
#include <bf_svx/eeitemid.hxx>
#endif

#ifndef _EEITEM_HXX //autogen
#include <bf_svx/eeitem.hxx>
#endif

// auto strip #ifndef _SVX_TSPTITEM_HXX //autogen
// auto strip #include <bf_svx/tstpitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_LRSPITEM_HXX //autogen
// auto strip #include <bf_svx/lrspitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_PROTITEM_HXX //autogen
// auto strip #include <bf_svx/protitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_FRMDIRITEM_HXX 
// auto strip #include <bf_svx/frmdiritem.hxx>
// auto strip #endif

// auto strip #ifndef _SVX_RULER_HXX
// auto strip #include <bf_svx/ruler.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_RULERITEM_HXX
// auto strip #include <bf_svx/rulritem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_ZOOMITEM_HXX
// auto strip #include <bf_svx/zoomitem.hxx>
// auto strip #endif
#ifndef _SVXIDS_HRC
#include <bf_svx/svxids.hrc>
#endif

// auto strip #ifndef _SVDPAGV_HXX //autogen
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #endif

#ifndef _SFXREQUEST_HXX //autogen
#include <bf_sfx2/request.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
// auto strip #ifndef _AEITEM_HXX //autogen
// auto strip #include <svtools/aeitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXENUMITEM_HXX //autogen
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif
#ifndef _SFXRECTITEM_HXX //autogen
#include <svtools/rectitem.hxx>
#endif
// auto strip #ifndef _SFXSTRITEM_HXX //autogen
// auto strip #include <svtools/stritem.hxx>
// auto strip #endif
#ifndef _SVDOOLE2_HXX //autogen
#include <bf_svx/svdoole2.hxx>
#endif
// auto strip #ifndef _SFXITEMPOOL_HXX //autogen
// auto strip #include <svtools/itempool.hxx>
// auto strip #endif
// auto strip #ifndef _SFXPTITEM_HXX //autogen
// auto strip #include <svtools/ptitem.hxx>
// auto strip #endif
#ifndef _SB_SBSTAR_HXX //autogen
#include <basic/sbstar.hxx>
#endif
// auto strip #ifndef _SB_SBERRORS_HXX //autogen
// auto strip #include <basic/sberrors.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_FMSHELL_HXX //autogen
// auto strip #include <bf_svx/fmshell.hxx>
// auto strip #endif

// auto strip #ifndef _SVX_F3DCHILD_HXX
// auto strip #include <bf_svx/f3dchild.hxx>
// auto strip #endif
#ifndef _SVX_FLOAT3D_HXX
#include <bf_svx/float3d.hxx>
#endif

// auto strip #ifndef _SD_OPTSITEM_HXX
// auto strip #include "optsitem.hxx"
// auto strip #endif

#include "app.hrc"
#include "glob.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"

// auto strip #include "sdundogr.hxx"
// auto strip #include "undopage.hxx"
// auto strip #include "glob.hxx"
// auto strip #include "app.hxx"
// auto strip #include "fupoor.hxx"
#include "fuslshow.hxx"
// auto strip #include "frmview.hxx"
// auto strip #include "sdpage.hxx"
#include "sdwindow.hxx"
#include "sdresid.hxx"
#include "drawview.hxx"
#include "drawdoc.hxx"
#include "drviewsh.hxx"
// auto strip #include "sdruler.hxx"
#include "docshell.hxx"
namespace binfilter {
//STRIP001 #include "preview.hxx"

#ifndef SO2_DECL_SVINPLACEOBJECT_DEFINED
#define SO2_DECL_SVINPLACEOBJECT_DEFINED
SO2_DECL_REF(SvInPlaceObject)
#endif



/*************************************************************************
|*
|* SfxRequests fuer Controller bearbeiten
|*
\************************************************************************/

/*N*/ void  SdDrawViewShell::ExecCtrl(SfxRequest& rReq)
/*N*/ {
/*N*/ 	// waehrend einer Diashow wird nichts ausser dem Seitenwechsel und dem
/*N*/ 	// Sprung zur Bookmark ausgefuehrt!
/*N*/ 	if (pFuActual &&
/*N*/ 		pFuActual->GetSlotID() == SID_PRESENTATION &&
/*N*/ 		rReq.GetSlot() != SID_SWITCHPAGE &&
/*N*/ 		rReq.GetSlot() != SID_JUMPTOMARK)
/*N*/ 		return;
/*N*/ 
/*N*/ 	CheckLineTo (rReq);
/*N*/ 
/*N*/     // End text edit mode for some requests.
/*N*/ 	USHORT nSlot = rReq.GetSlot();
/*N*/     switch (nSlot)
/*N*/     {
/*N*/ 		case SID_OUTPUT_QUALITY_COLOR:
/*N*/ 		case SID_OUTPUT_QUALITY_GRAYSCALE:
/*N*/ 		case SID_OUTPUT_QUALITY_BLACKWHITE:
/*N*/ 		case SID_OUTPUT_QUALITY_CONTRAST:
/*N*/ 		case SID_PREVIEW_QUALITY_COLOR:
/*N*/ 		case SID_PREVIEW_QUALITY_GRAYSCALE:
/*N*/ 		case SID_PREVIEW_QUALITY_BLACKWHITE:
/*N*/ 		case SID_PREVIEW_QUALITY_CONTRAST:
/*N*/             // Do nothing.
/*N*/             break;
/*N*/         default:
/*N*/             if ( pDrView->IsTextEdit() )
/*N*/             {
/*?*/                 pDrView->EndTextEdit();
/*N*/             }
/*N*/     }
/*N*/ 
/*N*/     //	USHORT nSlot = rReq.GetSlot();
/*N*/ 	switch (nSlot)
/*N*/ 	{
/*N*/ 		case SID_SWITCHPAGE:  // BASIC
/*N*/ 		{
/*N*/ 			BOOL bWasBasic = FALSE;
/*N*/ 
/*N*/ 			// Seitenwechsel in der Diashow abspielen
/*N*/ 			if (pFuSlideShow && rReq.GetArgs())
/*N*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SFX_REQUEST_ARG(rReq, pWhatPage, SfxUInt32Item, ID_VAL_WHATPAGE, FALSE);
//STRIP001 /*N*/ 				pFuSlideShow->JumpToPage((USHORT)pWhatPage->GetValue());
/*N*/ 			}
/*N*/ 			else
/*N*/ 			{
/*N*/ 				const SfxItemSet *pArgs = rReq.GetArgs ();
/*N*/ 				USHORT nSelectedPage;
/*N*/ 
/*N*/ 				if (! pArgs)
/*N*/ 				{
/*N*/ 					nSelectedPage = aTabControl.GetCurPageId() - 1;
/*N*/ 				}
/*N*/ 				else if (pArgs->Count () == 2)
/*N*/ 				{
/*?*/ 					SFX_REQUEST_ARG (rReq, pWhatPage, SfxUInt32Item, ID_VAL_WHATPAGE, FALSE);
/*?*/ 					SFX_REQUEST_ARG (rReq, pWhatKind, SfxUInt32Item, ID_VAL_WHATKIND, FALSE);
/*?*/ 
/*?*/ 					if (! CHECK_RANGE (PK_STANDARD, pWhatKind->GetValue (), PK_HANDOUT))
/*?*/ 					{
/*?*/ 						StarBASIC::FatalError (SbERR_BAD_PROP_VALUE);
/*?*/ 						rReq.Ignore ();
/*?*/ 						break;
/*?*/ 					}
/*?*/ 					else if (eEditMode != EM_MASTERPAGE)
/*?*/ 					{
/*?*/ 						if (! CHECK_RANGE (0, pWhatPage->GetValue (),
/*?*/ 							pDoc->GetSdPageCount ((PageKind) pWhatKind->GetValue ())))
/*?*/ 						{
/*?*/ 							StarBASIC::FatalError (SbERR_BAD_PROP_VALUE);
/*?*/ 							rReq.Ignore ();
/*?*/ 							break;
/*?*/ 						}
/*?*/ 
/*?*/ 						nSelectedPage = (short) pWhatPage->GetValue ();
/*?*/ 						ePageKind	  = (PageKind) pWhatKind->GetValue ();
/*?*/ 						bWasBasic	  = TRUE;
/*?*/ 					}
/*?*/ 				}
/*N*/ 				else
/*N*/ 				{
/*N*/ 					StarBASIC::FatalError (SbERR_WRONG_ARGS);
/*N*/ 					rReq.Ignore ();
/*N*/ 					break;
/*N*/ 				}
/*N*/ 

/*N*/ 				if( GetDocSh() && (GetDocSh()->GetCreateMode() == SFX_CREATE_MODE_EMBEDDED))
/*?*/ 					GetDocSh()->SetModified();
/*N*/ 
/*N*/ 				SwitchPage(nSelectedPage);
/*N*/ 
/*N*/ 				if (pFuActual && pFuActual->GetSlotID() == SID_BEZIER_EDIT)
/*?*/ 					GetViewFrame()->GetDispatcher()->Execute(SID_OBJECT_SELECT, SFX_CALLMODE_ASYNCHRON);

/*N*/ 				Invalidate();
/*N*/ 				InvalidateWindows();
/*N*/ 				rReq.Done ();
/*N*/ 			}
/*N*/ 			break;
/*N*/ 		}

/*N*/ 		case SID_SWITCHLAYER:  // BASIC
/*N*/ 		{
/*?*/ 			const SfxItemSet *pArgs = rReq.GetArgs ();
/*?*/ 			USHORT nCurPage = aLayerTab.GetCurPageId ();
/*?*/ 
/*?*/ 			if( pArgs && pArgs->Count () == 1)
/*?*/ 			{
/*?*/ 				SFX_REQUEST_ARG (rReq, pWhatLayer, SfxUInt32Item, ID_VAL_WHATLAYER, FALSE);
/*?*/ 				if( pWhatLayer )
/*?*/ 					nCurPage = (short) pWhatLayer->GetValue ();
/*?*/ 			}
/*?*/ 
/*?*/ 			pDrView->SetActiveLayer( aLayerTab.GetPageText(nCurPage) );
/*?*/ 			Invalidate();
/*?*/ 			rReq.Done ();
/*?*/ 
/*?*/ 			break;
/*?*/ 		}
/*?*/ 
/*?*/ 		case SID_PAGEMODE:	// BASIC
/*?*/ 		{
/*?*/ 
/*?*/ 			const SfxItemSet *pArgs = rReq.GetArgs ();
/*?*/ 
/*?*/ 			if ( pArgs && pArgs->Count () == 2)
/*?*/ 			{
/*?*/ 				SFX_REQUEST_ARG (rReq, pIsActive, SfxBoolItem, ID_VAL_ISACTIVE, FALSE);
/*?*/ 				SFX_REQUEST_ARG (rReq, pWhatKind, SfxUInt32Item, ID_VAL_WHATKIND, FALSE);
/*?*/ 
/*?*/ 				if (CHECK_RANGE (PK_STANDARD, pWhatKind->GetValue (), PK_HANDOUT))
/*?*/ 				{
/*?*/ 					bLayerMode = pIsActive->GetValue ();
/*?*/ 					ePageKind = (PageKind) pWhatKind->GetValue ();
/*?*/ 				}
/*?*/ 			}
/*?*/ 
/*?*/ 			// Default-Layer der Page einschalten
/*?*/ 			pDrView->SetActiveLayer( String( SdResId(STR_LAYER_LAYOUT) ) );
/*?*/ 
/*?*/ 			ChangeEditMode(EM_PAGE, bLayerMode);
/*?*/ 
/*?*/ 			Invalidate();
/*?*/ 			rReq.Done ();
/*?*/ 
/*?*/ 			break;
/*?*/ 		}
/*?*/ 
/*?*/ 		case SID_LAYERMODE:  // BASIC
/*?*/ 		{
/*?*/ 			const SfxItemSet *pArgs = rReq.GetArgs ();
/*?*/ 
/*?*/ 			if ( pArgs && pArgs->Count () == 2)
/*?*/ 			{
/*?*/ 				SFX_REQUEST_ARG (rReq, pWhatLayerMode, SfxBoolItem, ID_VAL_ISACTIVE, FALSE);
/*?*/ 				SFX_REQUEST_ARG (rReq, pWhatLayer, SfxUInt32Item, ID_VAL_WHATLAYER, FALSE);
/*?*/ 
/*?*/ 				if (CHECK_RANGE (EM_PAGE, pWhatLayer->GetValue (), EM_MASTERPAGE))
/*?*/ 				{
/*?*/ 					bLayerMode = pWhatLayerMode->GetValue ();
/*?*/ 					eEditMode = (EditMode) pWhatLayer->GetValue ();
/*?*/ 				}
/*?*/ 			}
/*?*/ 
/*?*/ 			ChangeEditMode(eEditMode, !bLayerMode);
/*?*/ 
/*?*/ 			Invalidate();
/*?*/ 			rReq.Done ();
/*?*/ 
/*?*/ 			break;
/*?*/ 		}
/*?*/ 
/*?*/ 		case SID_OBJECTRESIZE:
/*?*/ 		{
			/******************************************************************
			* Der Server moechte die Clientgrosse verandern
 			******************************************************************/
/*?*/ 			SfxInPlaceClient* pIPClient = GetIPClient();
/*?*/ 
/*?*/ 			if ( pIPClient && pIPClient->IsInPlaceActive() )
/*?*/ 			{
/*?*/ 				const SfxRectangleItem& rRect =
/*?*/ 					(SfxRectangleItem&)rReq.GetArgs()->Get(SID_OBJECTRESIZE);
/*?*/ 				Rectangle aRect( pWindow->PixelToLogic( rRect.GetValue() ) );
/*?*/ 
/*?*/ 				if ( pDrView->HasMarkedObj() )
/*?*/ 				{
/*?*/ 					const SdrMarkList& rMarkList = pDrView->GetMarkList();
/*?*/ 
/*?*/ 					if (rMarkList.GetMarkCount() == 1)
/*?*/ 					{
/*?*/ 						SdrMark* pMark = rMarkList.GetMark(0);
/*?*/ 						SdrObject* pObj = pMark->GetObj();
/*?*/ 
/*?*/ 						UINT16 nSdrObjKind = pObj->GetObjIdentifier();
/*?*/ 
/*?*/ 						if (pObj->GetObjInventor() == SdrInventor &&
/*?*/ 							pObj->GetObjIdentifier() == OBJ_OLE2)
/*?*/ 						{
/*?*/ 							SvInPlaceObjectRef aIPObj =
/*?*/ 							( (SdrOle2Obj*) pObj)->GetObjRef();
/*?*/ 
/*?*/ 							if ( aIPObj.Is() )
/*?*/ 							{
/*?*/ 								pObj->SetLogicRect(aRect);
/*?*/ 							}
/*?*/ 						}
/*?*/ 					}
/*?*/ 				}
/*?*/ 			}
/*?*/ 			rReq.Ignore ();
/*?*/ 			break;
/*?*/ 		}
/*?*/ 
/*?*/ 		case SID_RELOAD:
/*?*/ 		{
/*?*/ 			// #83951#
/*?*/ 			USHORT nId = Svx3DChildWindow::GetChildWindowId();
/*?*/ 			SfxChildWindow* pWindow = GetViewFrame()->GetChildWindow(nId);
/*?*/ 			if(pWindow)
/*?*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 Svx3DWin* p3DWin = (Svx3DWin*)(pWindow->GetWindow());
//STRIP001 /*?*/ 				if(p3DWin)
//STRIP001 /*?*/ 					p3DWin->DocumentReload();
/*?*/ 			}
/*?*/ 
/*?*/ 			// DER SLOT KANN IN DEN SFX VERSCHOBEN WERDEN
/*?*/ 			SFX_REQUEST_ARG(rReq, pForceReloadItem, SfxBoolItem, SID_NOCACHE, FALSE);
/*?*/ 			// Normale Weiterleitung an ViewFrame zur Ausfuehrung
/*?*/ 			GetViewFrame()->ExecuteSlot(rReq);
/*?*/ 
/*?*/ 			// Muss sofort beendet werden
/*?*/ 			return;
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_JUMPTOMARK:
/*?*/ 		{
/*?*/ 			if( rReq.GetArgs() )
/*?*/ 			{
/*?*/ 				SFX_REQUEST_ARG(rReq, pBookmark, SfxStringItem, SID_JUMPTOMARK, FALSE);
/*?*/ 
/*?*/ 				UniString sBookmark( INetURLObject::decode( pBookmark->GetValue(), '%', INetURLObject::DECODE_WITH_CHARSET ) );
/*?*/ 				if( sBookmark.Search( sal_Unicode('#') ) == 0 )
/*?*/ 					sBookmark = sBookmark.Copy( 1 );
/*?*/ 
/*?*/ 				if (pBookmark)
/*?*/ 				{
/*?*/ 					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if (pFuSlideShow)
//STRIP001 /*N*/ 					{
//STRIP001 /*N*/ 						pFuSlideShow->JumpToBookmark(sBookmark);
//STRIP001 /*N*/ 					}
//STRIP001 /*N*/ 					else
//STRIP001 /*N*/ 					{
//STRIP001 /*N*/ 						GotoBookmark( sBookmark );
//STRIP001 /*N*/ 					}
/*?*/ 				}
/*?*/ 			}
/*?*/ 			rReq.Done();
/*?*/ 			break;
/*?*/ 		}
/*?*/ 
/*?*/ 		case SID_OUTPUT_QUALITY_COLOR:
/*?*/ 		case SID_OUTPUT_QUALITY_GRAYSCALE:
/*?*/ 		case SID_OUTPUT_QUALITY_BLACKWHITE:
/*?*/ 		case SID_OUTPUT_QUALITY_CONTRAST:
/*?*/ 
/*?*/ 		case SID_PREVIEW_QUALITY_COLOR:
/*?*/ 		case SID_PREVIEW_QUALITY_GRAYSCALE:
/*?*/ 		case SID_PREVIEW_QUALITY_BLACKWHITE:
/*?*/ 		case SID_PREVIEW_QUALITY_CONTRAST:
/*?*/ 		{
/*?*/             DBG_BF_ASSERT(0, "STRIP"); //STRIP001 ExecReq( rReq );
/*?*/ 			break;
/*?*/ 		}
/*?*/ 
/*?*/ 		case SID_MAIL_SCROLLBODY_PAGEDOWN:
/*?*/ 		{
/*?*/             DBG_BF_ASSERT(0, "STRIP"); //STRIP001 ExecReq( rReq );
/*?*/ 			break;
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_ATTR_YEAR2000:
/*?*/ 		{
/*?*/ 			FmFormShell* pShell = (FmFormShell*) aShellTable.Get(RID_FORMLAYER_TOOLBOX);
/*?*/ 			if( pShell )
/*?*/ 			{
/*?*/ 				const SfxPoolItem* pItem;
/*?*/ 				if (rReq.GetArgs()->GetItemState(SID_ATTR_YEAR2000, TRUE, &pItem) == SFX_ITEM_SET)
/*?*/ 					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pShell->SetY2KState( ( (const SfxUInt16Item*) pItem )->GetValue() );
/*?*/ 			}
/*?*/ 
/*?*/ 			rReq.Done();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OPT_LOCALE_CHANGED:
/*?*/ 		{
/*?*/ 			pWindow->Invalidate();
/*?*/ 			UpdatePreview( pActualPage );
/*?*/ 			rReq.Done();
/*?*/ 		}
/*?*/ 
/*N*/ 		default:
/*N*/ 		break;
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* SfxRequests fuer Lineale bearbeiten
|*
\************************************************************************/

//STRIP001 void  SdDrawViewShell::ExecRuler(SfxRequest& rReq)
//STRIP001 {
//STRIP001 	// waehrend einer Diashow wird nichts ausgefuehrt!
//STRIP001 	if (pFuActual &&
//STRIP001 		pFuActual->GetSlotID() == SID_PRESENTATION)
//STRIP001 		return;
//STRIP001 
//STRIP001 	CheckLineTo (rReq);
//STRIP001 
//STRIP001 	const SfxItemSet* pArgs = rReq.GetArgs();
//STRIP001 	Point aPagePos = pWindow->GetViewOrigin();
//STRIP001 	Size aPageSize = pActualPage->GetSize();
//STRIP001 	Size aViewSize = pWindow->GetViewSize();
//STRIP001 	SdUndoGroup* pUndoGroup = NULL;
//STRIP001 
//STRIP001 	if ( rReq.GetSlot() == SID_ATTR_LONG_LRSPACE ||
//STRIP001 		 rReq.GetSlot() == SID_ATTR_LONG_ULSPACE )
//STRIP001 	{
//STRIP001 		pUndoGroup = new SdUndoGroup(pDoc);
//STRIP001 		String aString(SdResId(STR_UNDO_CHANGE_PAGEBORDER));
//STRIP001 		pUndoGroup->SetComment(aString);
//STRIP001 	}
//STRIP001 
//STRIP001 	switch ( rReq.GetSlot() )
//STRIP001 	{
//STRIP001 		case SID_ATTR_LONG_LRSPACE:
//STRIP001 		{
//STRIP001 			const SvxLongLRSpaceItem& rLRSpace = (const SvxLongLRSpaceItem&)
//STRIP001 					pArgs->Get(GetPool().GetWhich(SID_ATTR_LONG_LRSPACE));
//STRIP001 
//STRIP001 			if( pDrView->IsTextEdit() )
//STRIP001 			{
//STRIP001 				Point aPagePos = pWindow->GetViewOrigin();
//STRIP001 				Rectangle aRect = aMarkRect;
//STRIP001 				aRect.SetPos(aRect.TopLeft() + aPagePos);
//STRIP001 				aRect.Left()  = rLRSpace.GetLeft();
//STRIP001 				aRect.Right() = aViewSize.Width() - rLRSpace.GetRight();
//STRIP001 				aRect.SetPos(aRect.TopLeft() - aPagePos);
//STRIP001 				if ( aRect != aMarkRect)
//STRIP001 				{
//STRIP001 					pDrView->SetAllMarkedRect(aRect);
//STRIP001 					aMarkRect = pDrView->GetAllMarkedRect();
//STRIP001 					Invalidate( SID_RULER_OBJECT );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				long nLeft = Max(0L, rLRSpace.GetLeft() - aPagePos.X());
//STRIP001 				long nRight = Max(0L, rLRSpace.GetRight() + aPagePos.X() +
//STRIP001 								  	aPageSize.Width() - aViewSize.Width());
//STRIP001 
//STRIP001 				USHORT nPageCnt = pDoc->GetSdPageCount(ePageKind);
//STRIP001 
//STRIP001 				for (USHORT i = 0; i < nPageCnt; i++)
//STRIP001 				{
//STRIP001 					SdPage* pPage = pDoc->GetSdPage(i, ePageKind);
//STRIP001 					SdUndoAction* pUndo = new SdPageLRUndoAction(pDoc,
//STRIP001 											pPage,
//STRIP001 											pPage->GetLftBorder(),
//STRIP001 											pPage->GetRgtBorder(),
//STRIP001 											nLeft, nRight);
//STRIP001 					pUndoGroup->AddAction(pUndo);
//STRIP001 					pPage->SetLftBorder(nLeft);
//STRIP001 					pPage->SetRgtBorder(nRight);
//STRIP001 				}
//STRIP001 				nPageCnt = pDoc->GetMasterSdPageCount(ePageKind);
//STRIP001 
//STRIP001 				for (i = 0; i < nPageCnt; i++)
//STRIP001 				{
//STRIP001 					SdPage* pPage = pDoc->GetMasterSdPage(i, ePageKind);
//STRIP001 					SdUndoAction* pUndo = new SdPageLRUndoAction(pDoc,
//STRIP001 											pPage,
//STRIP001 											pPage->GetLftBorder(),
//STRIP001 											pPage->GetRgtBorder(),
//STRIP001 											nLeft, nRight);
//STRIP001 					pUndoGroup->AddAction(pUndo);
//STRIP001 					pPage->SetLftBorder(nLeft);
//STRIP001 					pPage->SetRgtBorder(nRight);
//STRIP001 				}
//STRIP001 				InvalidateWindows();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case SID_ATTR_LONG_ULSPACE:
//STRIP001 		{
//STRIP001             const SvxLongULSpaceItem& rULSpace = (const SvxLongULSpaceItem&)
//STRIP001                     pArgs->Get(GetPool().GetWhich(SID_ATTR_LONG_ULSPACE));
//STRIP001 
//STRIP001 			if( pDrView->IsTextEdit() )
//STRIP001 			{
//STRIP001 				Point aPagePos = pWindow->GetViewOrigin();
//STRIP001 				Rectangle aRect = aMarkRect;
//STRIP001 				aRect.SetPos(aRect.TopLeft() + aPagePos);
//STRIP001                 aRect.Top()  = rULSpace.GetUpper();
//STRIP001                 aRect.Bottom() = aViewSize.Height() - rULSpace.GetLower();
//STRIP001 				aRect.SetPos(aRect.TopLeft() - aPagePos);
//STRIP001 
//STRIP001                 if ( aRect != aMarkRect)
//STRIP001 				{
//STRIP001 					pDrView->SetAllMarkedRect(aRect);
//STRIP001 					aMarkRect = pDrView->GetAllMarkedRect();
//STRIP001 					Invalidate( SID_RULER_OBJECT );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001                 long nUpper = Max(0L, rULSpace.GetUpper() - aPagePos.Y());
//STRIP001                 long nLower = Max(0L, rULSpace.GetLower() + aPagePos.Y() +
//STRIP001                                       aPageSize.Height() - aViewSize.Height());
//STRIP001 
//STRIP001                 USHORT nPageCnt = pDoc->GetSdPageCount(ePageKind);
//STRIP001 
//STRIP001                 for (USHORT i = 0; i < nPageCnt; i++)
//STRIP001                 {
//STRIP001                     SdPage* pPage = pDoc->GetSdPage(i, ePageKind);
//STRIP001                     SdUndoAction* pUndo = new SdPageULUndoAction(pDoc,
//STRIP001                                             pPage,
//STRIP001                                             pPage->GetUppBorder(),
//STRIP001                                             pPage->GetLwrBorder(),
//STRIP001                                             nUpper, nLower);
//STRIP001                     pUndoGroup->AddAction(pUndo);
//STRIP001                     pPage->SetUppBorder(nUpper);
//STRIP001                     pPage->SetLwrBorder(nLower);
//STRIP001                 }
//STRIP001                 nPageCnt = pDoc->GetMasterSdPageCount(ePageKind);
//STRIP001 
//STRIP001                 for (i = 0; i < nPageCnt; i++)
//STRIP001                 {
//STRIP001                     SdPage* pPage = pDoc->GetMasterSdPage(i, ePageKind);
//STRIP001                     SdUndoAction* pUndo = new SdPageULUndoAction(pDoc,
//STRIP001                                             pPage,
//STRIP001                                             pPage->GetUppBorder(),
//STRIP001                                             pPage->GetLwrBorder(),
//STRIP001                                             nUpper, nLower);
//STRIP001                     pUndoGroup->AddAction(pUndo);
//STRIP001                     pPage->SetUppBorder(nUpper);
//STRIP001                     pPage->SetLwrBorder(nLower);
//STRIP001                 }
//STRIP001                 InvalidateWindows();
//STRIP001             }
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SID_RULER_OBJECT:
//STRIP001 		{
//STRIP001 			Point aPagePos = pWindow->GetViewOrigin();
//STRIP001 			Rectangle aRect = aMarkRect;
//STRIP001 			aRect.SetPos(aRect.TopLeft() + aPagePos);
//STRIP001 
//STRIP001 			const SvxObjectItem& rOI = (const SvxObjectItem&)
//STRIP001 					pArgs->Get(GetPool().GetWhich(SID_RULER_OBJECT));
//STRIP001 
//STRIP001 			if ( rOI.GetStartX() != rOI.GetEndX() )
//STRIP001 			{
//STRIP001 				aRect.Left()  = rOI.GetStartX();
//STRIP001 				aRect.Right() = rOI.GetEndX();
//STRIP001 			}
//STRIP001 			if ( rOI.GetStartY() != rOI.GetEndY() )
//STRIP001 			{
//STRIP001 				aRect.Top()    = rOI.GetStartY();
//STRIP001 				aRect.Bottom() = rOI.GetEndY();
//STRIP001 			}
//STRIP001 			aRect.SetPos(aRect.TopLeft() - aPagePos);
//STRIP001 			if ( aRect != aMarkRect)
//STRIP001 			{
//STRIP001 				pDrView->SetAllMarkedRect(aRect);
//STRIP001 				aMarkRect = pDrView->GetAllMarkedRect();
//STRIP001 				Invalidate( SID_RULER_OBJECT );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SID_ATTR_TABSTOP:
//STRIP001 		{
//STRIP001 			if( pDrView->IsTextEdit() )
//STRIP001 			{
//STRIP001 				const SvxTabStopItem& rItem = (const SvxTabStopItem&)
//STRIP001 							pArgs->Get( ITEMID_TABSTOP );
//STRIP001 
//STRIP001 				SfxItemSet aEditAttr( GetPool(), ITEMID_TABSTOP, ITEMID_TABSTOP );
//STRIP001 
//STRIP001 				aEditAttr.Put( rItem );
//STRIP001 				pDrView->SetAttributes( aEditAttr );
//STRIP001 
//STRIP001 				// #91081# Invalidate is missing here
//STRIP001 				Invalidate(SID_ATTR_TABSTOP);
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SID_ATTR_PARA_LRSPACE:
//STRIP001 		{
//STRIP001 			if( pDrView->IsTextEdit() )
//STRIP001 			{
//STRIP001 				USHORT nId = SID_ATTR_PARA_LRSPACE;
//STRIP001 				const SvxLRSpaceItem& rItem = (const SvxLRSpaceItem&)
//STRIP001 							pArgs->Get( nId );
//STRIP001 
//STRIP001 				SfxItemSet aEditAttr( GetPool(), ITEMID_LRSPACE, ITEMID_LRSPACE );
//STRIP001 
//STRIP001 				nId = ITEMID_LRSPACE;
//STRIP001 				SvxLRSpaceItem aLRSpaceItem( rItem.GetLeft(),
//STRIP001 						rItem.GetRight(), rItem.GetTxtLeft(),
//STRIP001 						rItem.GetTxtFirstLineOfst(), nId );
//STRIP001 				aEditAttr.Put( aLRSpaceItem );
//STRIP001 				pDrView->SetAttributes( aEditAttr );
//STRIP001 
//STRIP001 				// #92557# Invalidate is missing here
//STRIP001 				Invalidate(SID_ATTR_PARA_LRSPACE);
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if ( pUndoGroup )
//STRIP001 		// Undo Gruppe dem Undo Manager uebergeben
//STRIP001 		GetViewFrame()->GetObjectShell()->GetUndoManager()->
//STRIP001 											AddUndoAction(pUndoGroup);
//STRIP001 }

/*************************************************************************
|*
|* Statuswerte der Lineale bestimmen
|*
\************************************************************************/
//STRIP001 void  SdDrawViewShell::GetRulerState(SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	Point aOrigin;
//STRIP001 
//STRIP001 	if (pDrView->GetPageViewPvNum(0))
//STRIP001 	{
//STRIP001 		aOrigin = pDrView->GetPageViewPvNum(0)->GetPageOrigin();
//STRIP001 	}
//STRIP001 
//STRIP001 	Size aViewSize = pWindow->GetViewSize();
//STRIP001 
//STRIP001 	Point aPagePos = pWindow->GetViewOrigin();
//STRIP001 	Size aPageSize = pActualPage->GetSize();
//STRIP001 
//STRIP001 	Rectangle aRect(aPagePos, Point( aViewSize.Width() - (aPagePos.X() + aPageSize.Width()),
//STRIP001 	        	                     aViewSize.Height() - (aPagePos.Y() + aPageSize.Height())));
//STRIP001 
//STRIP001 	if( pDrView->IsTextEdit() )
//STRIP001 	{
//STRIP001 		Point aPnt1 = pWindow->GetWinViewPos();
//STRIP001 		Point aPnt2 = pWindow->GetViewOrigin();
//STRIP001 		Rectangle aMinMaxRect = Rectangle( aPnt1, Size(ULONG_MAX, ULONG_MAX) );
//STRIP001 		rSet.Put( SfxRectangleItem(SID_RULER_LR_MIN_MAX, aMinMaxRect) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		rSet.Put( SfxRectangleItem(SID_RULER_LR_MIN_MAX, aRect) );
//STRIP001 	}
//STRIP001 
//STRIP001     SvxLongLRSpaceItem aLRSpace(aPagePos.X() + pActualPage->GetLftBorder(),
//STRIP001 								aRect.Right() + pActualPage->GetRgtBorder(),
//STRIP001 								GetPool().GetWhich(SID_ATTR_LONG_LRSPACE));
//STRIP001 	SvxLongULSpaceItem aULSpace(aPagePos.Y() + pActualPage->GetUppBorder(),
//STRIP001 								aRect.Bottom() + pActualPage->GetLwrBorder(),
//STRIP001 								GetPool().GetWhich(SID_ATTR_LONG_ULSPACE));
//STRIP001 	rSet.Put(SvxPagePosSizeItem(Point(0,0) - aPagePos, aViewSize.Width(),
//STRIP001 													   aViewSize.Height()));
//STRIP001 	SfxPointItem aPointItem( SID_RULER_NULL_OFFSET, aPagePos + aOrigin );
//STRIP001 
//STRIP001 	SvxProtectItem aProtect( SID_RULER_PROTECT );
//STRIP001 
//STRIP001 	aMarkRect = pDrView->GetAllMarkedRect();
//STRIP001 
//STRIP001 	const sal_Bool bRTL = pDoc && pDoc->GetDefaultWritingMode() == ::com::sun::star::text::WritingMode_RL_TB;
//STRIP001 	rSet.Put(SfxBoolItem(SID_RULER_TEXT_RIGHT_TO_LEFT, bRTL));
//STRIP001 
//STRIP001 	if( pDrView->HasMarkedObj() )
//STRIP001 	{
//STRIP001 		if( pDrView->IsTextEdit() )
//STRIP001 		{
//STRIP001 			SdrObject* pObj = pDrView->GetMarkList().GetMark( 0 )->GetObj();
//STRIP001 			if( pObj->GetObjInventor() == SdrInventor)
//STRIP001 			{
//STRIP001 				SfxItemSet aEditAttr( pDoc->GetPool() );
//STRIP001 				pDrView->GetAttributes( aEditAttr );
//STRIP001 				if( aEditAttr.GetItemState( ITEMID_TABSTOP ) >= SFX_ITEM_AVAILABLE )
//STRIP001 				{
//STRIP001 					const SvxTabStopItem& rItem = (const SvxTabStopItem&) aEditAttr.Get( ITEMID_TABSTOP );
//STRIP001 					rSet.Put( rItem );
//STRIP001 
//STRIP001 					//Rectangle aRect = aMarkRect;
//STRIP001 
//STRIP001 					const SvxLRSpaceItem& rLRSpaceItem = (const SvxLRSpaceItem&) aEditAttr.Get( ITEMID_LRSPACE );
//STRIP001 					USHORT nId = SID_ATTR_PARA_LRSPACE;
//STRIP001 					SvxLRSpaceItem aLRSpaceItem( rLRSpaceItem.GetLeft(),
//STRIP001 							rLRSpaceItem.GetRight(), rLRSpaceItem.GetTxtLeft(),
//STRIP001 							rLRSpaceItem.GetTxtFirstLineOfst(), nId );
//STRIP001 					rSet.Put( aLRSpaceItem );
//STRIP001 
//STRIP001 					Point aPos( aPagePos + aMarkRect.TopLeft() );
//STRIP001 
//STRIP001 					if ( aEditAttr.GetItemState( SDRATTR_TEXT_LEFTDIST ) == SFX_ITEM_ON )
//STRIP001 					{
//STRIP001 						const SdrTextLeftDistItem& rTLDItem = (const SdrTextLeftDistItem&)
//STRIP001 															  aEditAttr.Get( SDRATTR_TEXT_LEFTDIST );
//STRIP001 						long nLD = rTLDItem.GetValue();
//STRIP001 						aPos.X() += nLD;
//STRIP001 					}
//STRIP001 
//STRIP001 					aPointItem.SetValue( aPos );
//STRIP001 
//STRIP001 					aLRSpace.SetLeft( aPagePos.X() + aMarkRect.Left() );
//STRIP001 
//STRIP001 					if ( aEditAttr.GetItemState( SDRATTR_TEXT_LEFTDIST ) == SFX_ITEM_ON )
//STRIP001 					{
//STRIP001 						const SdrTextLeftDistItem& rTLDItem = (const SdrTextLeftDistItem&)
//STRIP001 															  aEditAttr.Get( SDRATTR_TEXT_LEFTDIST );
//STRIP001 						long nLD = rTLDItem.GetValue();
//STRIP001 						aLRSpace.SetLeft( aLRSpace.GetLeft() + nLD );
//STRIP001 					}
//STRIP001 
//STRIP001 					aLRSpace.SetRight( aRect.Right() + aPageSize.Width() - aMarkRect.Right() );
//STRIP001 					aULSpace.SetUpper( aPagePos.Y() + aMarkRect.Top() );
//STRIP001 					aULSpace.SetLower( aRect.Bottom() + aPageSize.Height() - aMarkRect.Bottom() );
//STRIP001 
//STRIP001 					rSet.DisableItem( SID_RULER_OBJECT );
//STRIP001 
//STRIP001 					// Seitenraender werden gelocked
//STRIP001 					aProtect.SetSizeProtect( TRUE );
//STRIP001 					aProtect.SetPosProtect( TRUE );
//STRIP001 				}
//STRIP001 
//STRIP001 				if( aEditAttr.GetItemState( EE_PARA_WRITINGDIR ) >= SFX_ITEM_AVAILABLE )
//STRIP001 				{
//STRIP001 					const SvxFrameDirectionItem& rItem = (const SvxFrameDirectionItem&) aEditAttr.Get( EE_PARA_WRITINGDIR );
//STRIP001 
//STRIP001 					const sal_Bool bRTL = rItem.GetValue() == ::com::sun::star::text::WritingMode_RL_TB;
//STRIP001 					rSet.Put(SfxBoolItem(SID_RULER_TEXT_RIGHT_TO_LEFT, bRTL));
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			rSet.DisableItem( ITEMID_TABSTOP );
//STRIP001 			rSet.DisableItem( SID_RULER_TEXT_RIGHT_TO_LEFT );
//STRIP001 
//STRIP001 			if( pDrView->IsResizeAllowed(TRUE) )
//STRIP001 			{
//STRIP001 				Rectangle aRect = aMarkRect;
//STRIP001 
//STRIP001 				aRect.SetPos(aRect.TopLeft() + aPagePos);
//STRIP001 				SvxObjectItem aObjItem(aRect.Left(), aRect.Right(),
//STRIP001 									   aRect.Top(), aRect.Bottom());
//STRIP001 				rSet.Put(aObjItem);
//STRIP001 				rSet.DisableItem( ITEMID_TABSTOP );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				rSet.DisableItem( SID_RULER_OBJECT );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		rSet.DisableItem( SID_RULER_OBJECT );
//STRIP001 		rSet.DisableItem( ITEMID_TABSTOP );
//STRIP001 //		rSet.DisableItem( SID_RULER_TEXT_RIGHT_TO_LEFT );
//STRIP001 	}
//STRIP001 
//STRIP001 	rSet.Put( aLRSpace );
//STRIP001 	rSet.Put( aULSpace );
//STRIP001 
//STRIP001 	rSet.Put( aPointItem );
//STRIP001 	rSet.Put( aProtect );
//STRIP001 }

/*************************************************************************
|*
|* SfxRequests fuer StatusBar bearbeiten
|*
\************************************************************************/

//STRIP001 void  SdDrawViewShell::ExecStatusBar(SfxRequest& rReq)
//STRIP001 {
//STRIP001 	// waehrend einer Diashow wird nichts ausgefuehrt!
//STRIP001 	if (pFuActual &&
//STRIP001 		pFuActual->GetSlotID() == SID_PRESENTATION)
//STRIP001 		return;
//STRIP001 
//STRIP001 	CheckLineTo (rReq);
//STRIP001 
//STRIP001 	const SfxItemSet* pArgs = rReq.GetArgs();
//STRIP001 
//STRIP001 	switch ( rReq.GetSlot() )
//STRIP001 	{
//STRIP001 		case SID_ATTR_SIZE:
//STRIP001 		{
//STRIP001 			GetViewFrame()->GetDispatcher()->Execute( SID_ATTR_TRANSFORM, SFX_CALLMODE_ASYNCHRON );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_STATUS_LAYOUT:
//STRIP001 		{
//STRIP001 			GetViewFrame()->GetDispatcher()->Execute( SID_PRESENTATION_LAYOUT, SFX_CALLMODE_ASYNCHRON );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Status der Snap-Objekt-Eintraege im Popup setzen
|*
\************************************************************************/

//STRIP001 void  SdDrawViewShell::GetSnapItemState( SfxItemSet &rSet )
//STRIP001 {
//STRIP001 	SdrPageView* pPV;
//STRIP001 	Point	aMPos = pWindow->PixelToLogic(aMousePos);
//STRIP001 	USHORT	nHitLog = (USHORT) pWindow->PixelToLogic(Size(HITPIX,0)).Width();
//STRIP001 	USHORT	nHelpLine;
//STRIP001 
//STRIP001 	if ( pDrView->PickHelpLine(aMPos, nHitLog, *pWindow, nHelpLine, pPV) )
//STRIP001 	{
//STRIP001 		const SdrHelpLine& rHelpLine = (pPV->GetHelpLines())[nHelpLine];
//STRIP001 
//STRIP001 		if ( rHelpLine.GetKind() == SDRHELPLINE_POINT )
//STRIP001 		{
//STRIP001 			rSet.Put( SfxStringItem( SID_SET_SNAPITEM,
//STRIP001 								String( SdResId( STR_POPUP_EDIT_SNAPPOINT))) );
//STRIP001 			rSet.Put( SfxStringItem( SID_DELETE_SNAPITEM,
//STRIP001 								String( SdResId( STR_POPUP_DELETE_SNAPPOINT))) );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			rSet.Put( SfxStringItem( SID_SET_SNAPITEM,
//STRIP001 								String( SdResId( STR_POPUP_EDIT_SNAPLINE))) );
//STRIP001 			rSet.Put( SfxStringItem( SID_DELETE_SNAPITEM,
//STRIP001 								String( SdResId( STR_POPUP_DELETE_SNAPLINE))) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void SdDrawViewShell::AddWindow(SdWindow* pWin)
//STRIP001 {
//STRIP001 	pDrView->AddWin(pWin);
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void SdDrawViewShell::RemoveWindow(SdWindow* pWin)
//STRIP001 {
//STRIP001 	pDrView->DelWin(pWin);
//STRIP001 }


}
