/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_zoomlist.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:47:40 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVXIDS_HRC
#include <bf_svx/svxids.hrc>
#endif
// auto strip #ifndef _SFX_BINDINGS_HXX //autogen
// auto strip #include <bf_sfx2/bindings.hxx>
// auto strip #endif
// auto strip #ifndef _SFXVIEWFRM_HXX
// auto strip #include <bf_sfx2/viewfrm.hxx>
// auto strip #endif
// auto strip #ifndef _SFXVIEWSHELL_HXX
// auto strip #include <bf_sfx2/viewsh.hxx>
// auto strip #endif

#pragma hdrstop

#include "zoomlist.hxx"
namespace binfilter {

#define MAX_ENTRYS	10

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

/*N*/ ZoomList::ZoomList( SfxViewShell* pViewShell )
/*N*/ 	: List(),
/*N*/ 	pViewSh( pViewShell ),
/*N*/ 	nCurPos(0)
/*N*/ {
/*N*/ }


/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ ZoomList::~ZoomList()
/*N*/ {
/*N*/ #if ( defined GCC && defined C272 )
/*N*/ 	for (ULONG nCount=0; nCount<List::Count(); nCount++)
/*N*/ #else
/*N*/ 	for (ULONG nCount=0; nCount<Count(); nCount++)
/*N*/ #endif
/*N*/ 	{
/*N*/ 		// Ggf. ZoomRects loeschen
/*N*/ 		delete ((Rectangle*) GetObject(nCount));
/*N*/ 	}
/*N*/ }


/*************************************************************************
|*
|* Neues ZoomRect aufnehmen
|*
\************************************************************************/

//STRIP001 void ZoomList::InsertZoomRect(const Rectangle& rRect)
//STRIP001 {
//STRIP001 	ULONG nCount = Count();
//STRIP001 
//STRIP001 	if (nCount >= MAX_ENTRYS)
//STRIP001 	{
//STRIP001 		delete ((Rectangle*) GetObject(0));
//STRIP001 		Remove((ULONG) 0);
//STRIP001 	}
//STRIP001 	else if (nCount == 0)
//STRIP001 	{
//STRIP001 		nCurPos = 0;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nCurPos++;
//STRIP001 	}
//STRIP001 
//STRIP001 	Rectangle* pRect = new Rectangle(rRect);
//STRIP001 	Insert(pRect, nCurPos);
//STRIP001 
//STRIP001 	SfxBindings& rBindings = pViewSh->GetViewFrame()->GetBindings();
//STRIP001 	rBindings.Invalidate( SID_ZOOM_NEXT );
//STRIP001 	rBindings.Invalidate( SID_ZOOM_PREV );
//STRIP001 }


/*************************************************************************
|*
|* Aktuelles ZoomRect herausgeben
|*
\************************************************************************/

Rectangle ZoomList::GetCurrentZoomRect() const
{
	Rectangle aRect(*(Rectangle*) GetObject(nCurPos));
	return (aRect);
}

/*************************************************************************
|*
|* Naechstes ZoomRect herausgeben
|*
\************************************************************************/

//STRIP001 Rectangle ZoomList::GetNextZoomRect()
//STRIP001 {
//STRIP001 	nCurPos++;
//STRIP001 	ULONG nCount = Count();
//STRIP001 
//STRIP001 	if (nCount > 0 && nCurPos > nCount - 1)
//STRIP001 	{
//STRIP001 		nCurPos = nCount - 1;
//STRIP001 	}
//STRIP001 
//STRIP001 	SfxBindings& rBindings = pViewSh->GetViewFrame()->GetBindings();
//STRIP001 	rBindings.Invalidate( SID_ZOOM_NEXT );
//STRIP001 	rBindings.Invalidate( SID_ZOOM_PREV );
//STRIP001 
//STRIP001 	Rectangle aRect(*(Rectangle*) GetObject(nCurPos));
//STRIP001 	return (aRect);
//STRIP001 }

/*************************************************************************
|*
|* Letztes ZoomRect herausgeben
|*
\************************************************************************/

//STRIP001 Rectangle ZoomList::GetPreviousZoomRect()
//STRIP001 {
//STRIP001 	if (nCurPos > 0)
//STRIP001 	{
//STRIP001 		nCurPos--;
//STRIP001 	}
//STRIP001 
//STRIP001 	SfxBindings& rBindings = pViewSh->GetViewFrame()->GetBindings();
//STRIP001 	rBindings.Invalidate( SID_ZOOM_NEXT );
//STRIP001 	rBindings.Invalidate( SID_ZOOM_PREV );
//STRIP001 
//STRIP001 	Rectangle aRect(*(Rectangle*) GetObject(nCurPos));
//STRIP001 	return (aRect);
//STRIP001 }

/*************************************************************************
|*
|* Gibt es ein naechstes ZoomRect?
|*
\************************************************************************/

/*N*/ BOOL ZoomList::IsNextPossible() const
/*N*/ {
/*N*/ 	BOOL bPossible = FALSE;
/*N*/ 	ULONG nCount = Count();
/*N*/ 
/*N*/ 	if (nCount > 0 && nCurPos < nCount - 1)
/*N*/ 	{
/*N*/ 		bPossible = TRUE;
/*N*/ 	}
/*N*/ 
/*N*/ 	return (bPossible);
/*N*/ }

/*************************************************************************
|*
|* Gibt es ein vorheriges ZoomRect?
|*
\************************************************************************/

/*N*/ BOOL ZoomList::IsPreviousPossible() const
/*N*/ {
/*N*/ 	BOOL bPossible = FALSE;
/*N*/ 
/*N*/ 	if (nCurPos > 0)
/*N*/ 	{
/*N*/ 		bPossible = TRUE;
/*N*/ 	}
/*N*/ 
/*N*/ 	return (bPossible);
/*N*/ }


}
