/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_tbxchild.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:45:46 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef SOLARIS
// HACK: prevent conflict between STLPORT and Workshop headers on Solaris 8
#include <ctime>
#endif

#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

// auto strip #ifndef _COM_SUN_STAR_UTIL_XURLTRANSFORMER_HPP_
// auto strip #include <com/sun/star/util/XURLTransformer.hpp>
// auto strip #endif

// auto strip #ifndef _SFXINTITEM_HXX //autogen
// auto strip #include <svtools/intitem.hxx>
// auto strip #endif
// auto strip #ifndef INCLUDED_SVTOOLS_MISCOPT_HXX
// auto strip #include <svtools/miscopt.hxx>
// auto strip #endif
#include <svtools/imageitm.hxx>
// auto strip #include <svtools/eitem.hxx>
// auto strip #include <comphelper/processfactory.hxx>


#pragma hdrstop

#include "tbxchild.hxx"

#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif

#include "tbxmgr.hxx"
#include "dispatch.hxx"
// auto strip #include "tbxctrl.hxx"
// auto strip #include "resmgr.hxx"
// auto strip #include "app.hxx"
// auto strip #include "objface.hxx"
// auto strip #include "bindings.hxx"
// auto strip #include "workwin.hxx"
#include "viewfrm.hxx"
// auto strip #include "genlink.hxx"
// auto strip #include "tbxcust.hxx"
#include "toolbox.hrc"
// auto strip #include "mnumgr.hxx"
#include "tbxconf.hxx"
#include "msgpool.hxx"
#include "virtmenu.hxx"
// auto strip #include "childwin.hxx"
// auto strip #include "cfgmgr.hxx"
// auto strip #include "request.hxx"
// auto strip #include "objsh.hxx"
// auto strip #include "docfile.hxx"
// auto strip #ifndef _LEGACYBINFILTERMGR_HXX
// auto strip #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
// auto strip #endif
namespace binfilter {

using namespace rtl;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::frame;
using namespace ::com::sun::star::util;

/*N*/ class SfxToolBoxImageControl_Impl : public SfxControllerItem
/*N*/ {
/*N*/     SfxToolbox*         pToolBox;
/*N*/     long                lRotation;
/*N*/     BOOL                bIsMirrored;
/*N*/ 
/*N*/ protected:
/*N*/     virtual void        StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState );
/*N*/ public:
/*N*/                         SfxToolBoxImageControl_Impl( USHORT nSlotId, SfxBindings& rBindings, SfxToolbox* pBox )
/*N*/                             : SfxControllerItem( nSlotId, rBindings )
/*N*/                             , pToolBox( pBox )
/*N*/                             , lRotation( 0 )
/*N*/                             , bIsMirrored( FALSE )
/*N*/                         {}
/*N*/     void                Update();
/*N*/ };

/*N*/ void SfxToolBoxImageControl_Impl::StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ {
/*N*/     const SfxImageItem* pItem = PTR_CAST( SfxImageItem, pState );
/*N*/     if ( pItem )
/*N*/     {
/*N*/         lRotation = pItem->GetRotation();
/*N*/         bIsMirrored = pItem->IsMirrored();
/*N*/     }
/*N*/ 
/*N*/     Update();
/*N*/ }

/*N*/ void SfxToolBoxImageControl_Impl::Update()
/*N*/ {
/*N*/     SfxViewFrame* pViewFrame = GetBindings().GetDispatcher_Impl()->GetFrame();
/*N*/     SfxSlotPool& rPool = SFX_APP()->GetSlotPool( pViewFrame );
/*N*/     for (USHORT nPos = 0; nPos<pToolBox->GetItemCount(); nPos++)
/*N*/     {
/*N*/         USHORT nId = pToolBox->GetItemId( nPos );
/*N*/         const SfxSlot* pSlot = rPool.GetSlot( nId );
/*N*/         if ( pSlot && pSlot->IsMode( SFX_SLOT_IMAGEROTATION ) )
/*N*/         {
/*N*/             pToolBox->SetItemImageMirrorMode( nId, FALSE );
/*N*/             pToolBox->SetItemImageAngle( nId, lRotation );
/*N*/         }
/*N*/         if ( pSlot && pSlot->IsMode( SFX_SLOT_IMAGEREFLECTION ) )
/*N*/             pToolBox->SetItemImageMirrorMode( nId, bIsMirrored );
/*N*/     }
/*N*/ }

/*N*/ class SfxToolBox_Impl
/*N*/ {
/*N*/ public:
/*N*/     Timer                   aTimer;
/*N*/     Point                   aPos;
/*N*/     Point                   aFloatPos;
/*N*/     SfxToolBoxControl*      pControl;
//STRIP001 /*N*/     SfxPopupWindow*         pPopup;
/*N*/     SfxToolbox*             pToolBox;
/*N*/     SfxToolBoxImageControl_Impl*
/*N*/                             pImageControl;
/*N*/ 
/*N*/ 						SfxToolBox_Impl( SfxToolbox *pBox )
/*N*/ 							: pControl( 0 )
//STRIP001 /*N*/ 							, pPopup( 0 )
/*N*/                             , pImageControl( 0 )
/*N*/ 							, pToolBox( pBox )
/*N*/ 						{
/*N*/ 							aTimer.SetTimeout( 250 );
/*N*/ 							aTimer.SetTimeoutHdl( LINK( this, SfxToolBox_Impl, TimerHdl ) );
/*N*/ 						}
/*N*/ 
/*N*/ 	DECL_LINK(			PopupDeleted, void* );
/*N*/ 	DECL_LINK( 			TimerHdl, Timer* );
/*N*/ 	void				EndPopupMode();
/*N*/ };

/*N*/ IMPL_LINK( SfxToolBox_Impl, PopupDeleted, void*, pVoid )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 	pPopup = 0;
//STRIP001 /*?*/ 	pControl = 0;
/*?*/ 	return 0L;
/*N*/ }

/*N*/ IMPL_LINK( SfxToolBox_Impl, TimerHdl, Timer*, pTimer )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 	if ( !pControl )
//STRIP001 /*?*/ 		return 0L;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	pControl->GetBindings().ENTERREGISTRATIONS();
//STRIP001 /*?*/ 	pPopup = pControl->CreatePopupWindowCascading();
//STRIP001 /*?*/ 	pControl->GetBindings().LEAVEREGISTRATIONS();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	if ( pPopup )
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		pPopup->SetDeleteLink_Impl( LINK( this, SfxToolBox_Impl, PopupDeleted ) );
//STRIP001 /*?*/ 		Rectangle aRect = pToolBox->GetItemRect( pControl->GetId() );
//STRIP001 /*?*/ 		Point aPos;
//STRIP001 /*?*/         aPos = pPopup->GetParent()->
//STRIP001 /*?*/             OutputToScreenPixel( pPopup->GetParent()->AbsoluteScreenToOutputPixel( pToolBox->OutputToAbsoluteScreenPixel(aRect.TopLeft() ) ) );
//STRIP001 /*?*/ 		aRect.SetPos( aPos );
//STRIP001 /*?*/ 		pPopup->StartPopupMode( aRect, 0 );
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ 	else
//STRIP001 /*?*/ 		pControl = 0;
//STRIP001 /*?*/ 
/*?*/ 	return 0L;
/*N*/ }

/*N*/ void SfxToolBox_Impl::EndPopupMode()
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	DBG_ASSERT( pControl && pPopup, "EndPopupMode ohne Popup!" );
//STRIP001 	if ( !pPopup )
//STRIP001 	{
//STRIP001 		pControl = 0;
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	pPopup->SetDeleteLink_Impl( Link() );
//STRIP001 	pPopup->EndPopupMode();
//STRIP001 	pPopup = 0;
//STRIP001 	pControl = 0;
/*N*/ }

// Hilfsfunktion zum Umrechnen eines SfxChildAlignments in ein SV-WindowAlign
/*N*/ WindowAlign ConvertAlign_Impl( SfxChildAlignment eAlign )
/*N*/ {
/*N*/ 	switch ( eAlign )
/*N*/ 	{
/*N*/ 		case SFX_ALIGN_HIGHESTTOP:
/*N*/ 		case SFX_ALIGN_TOOLBOXTOP:
/*N*/ 		case SFX_ALIGN_LOWESTTOP:
/*N*/ 		case SFX_ALIGN_TOP:
/*N*/ 			return WINDOWALIGN_TOP;
/*N*/ 			break;
/*N*/ 
/*N*/ 		case SFX_ALIGN_LOWESTBOTTOM:
/*N*/ 		case SFX_ALIGN_BOTTOM:
/*N*/ 		case SFX_ALIGN_TOOLBOXBOTTOM:
/*N*/ 		case SFX_ALIGN_HIGHESTBOTTOM:
/*N*/ 			return WINDOWALIGN_BOTTOM;
/*N*/ 			break;
/*N*/ 
/*N*/ 		case SFX_ALIGN_FIRSTLEFT:
/*N*/ 		case SFX_ALIGN_LEFT:
/*N*/ 		case SFX_ALIGN_LASTLEFT:
/*N*/ 		case SFX_ALIGN_TOOLBOXLEFT:
/*N*/ 			return WINDOWALIGN_LEFT;
/*N*/ 			break;
/*N*/ 
/*N*/ 		case SFX_ALIGN_LASTRIGHT:
/*N*/ 		case SFX_ALIGN_RIGHT:
/*N*/ 		case SFX_ALIGN_FIRSTRIGHT:
/*N*/ 		case SFX_ALIGN_TOOLBOXRIGHT:
/*N*/ 			return WINDOWALIGN_RIGHT;
/*N*/ 			break;
/*N*/ 	}
/*N*/ 
/*N*/ 	DBG_ERROR("Toolboxalign im FloatingMode ?" );
/*N*/ 	return WINDOWALIGN_TOP;
/*N*/ }

/*N*/ SfxToolbox::~SfxToolbox()
/*N*/ {
/*N*/     delete pImp->pImageControl;
/*N*/ 	delete pImp;
/*N*/ }

/*N*/ SfxToolbox::SfxToolbox( SfxToolBoxManager &rMgr, Window *pParent, WinBits nBits ):
/*N*/ 	ToolBox( pParent, nBits ),
/*N*/ 	bEmpty(FALSE),
/*N*/ 	bConstructed(FALSE),
/*N*/ 	bHelpInitialized(FALSE),
/*N*/ 	bCopyCtor(FALSE),
/*N*/ 	pMgr( &rMgr ),
/*N*/ 	bActivated(FALSE),
/*N*/ 	bDeleteToolBox(FALSE),
/*N*/ 	bReconfigure(FALSE),
/*N*/ 	nPos(0xFFFF),
/*N*/ 	aLink( LINK( this, SfxToolbox, TimeHdl ) ),
/*N*/ 	nActivated(0)
/*N*/ {
/*N*/ 	Construct();
/*N*/ }

/*N*/ SfxToolbox::SfxToolbox( SfxToolBoxManager &rMgr, Window *pParent, ResId &rResId ):
/*N*/ 	ToolBox( pParent, rResId ),
/*N*/ 	bConstructed(FALSE),
/*N*/ 	bHelpInitialized(FALSE),
/*N*/ 	bCopyCtor(FALSE),
/*N*/ 	bEmpty(FALSE),
/*N*/ 	bWaitSuppressed(FALSE),
/*N*/ 	pMgr( &rMgr ),
/*N*/ 	bActivated(FALSE),
/*N*/ 	bDeleteToolBox(FALSE),
/*N*/ 	bReconfigure(FALSE),
/*N*/ 	nPos(0xFFFF),
/*N*/ 	aLink( LINK( this, SfxToolbox, TimeHdl ) ),
/*N*/ 	nActivated(0)
/*N*/ {
/*N*/ 	Construct();
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxToolbox::Construct()
/*N*/ {
/*N*/ 	pImp = new SfxToolBox_Impl( this );
/*N*/     pMgr->GetBindings().ENTERREGISTRATIONS();
/*N*/     pImp->pImageControl = new SfxToolBoxImageControl_Impl( SID_IMAGE_ORIENTATION, pMgr->GetBindings(), this );
/*N*/     pMgr->GetBindings().LEAVEREGISTRATIONS();
/*N*/ 	pControl = 0;
/*N*/ 	bMod1 = bMod2 = bShift = FALSE;
/*N*/ 	aTimer.SetTimeout( 250 );
/*N*/ 	aTimer.SetTimeoutHdl( LINK( this, SfxToolbox, TimeHdl ) );
/*N*/ 	aAsyncStoreCfgTimer.SetTimeout( 100 );
/*N*/ 	aAsyncStoreCfgTimer.SetTimeoutHdl( LINK( this, SfxToolbox, AsyncStoreCfgHdl ) );
/*N*/ 	pMgr->SetHiContrast( IsHiContrastMode() );
/*N*/ //    EnableDrop(TRUE);
/*N*/ }

//--------------------------------------------------------------------

/*?*/ IMPL_LINK( SfxToolbox, Delete, void *, pvoid )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	delete pMgr;
/*?*/ 	return 0;
/*?*/ }

//-------------------------------------------------------------------------

/*N*/ long SfxToolbox::Notify( NotifyEvent& rNEvt )
/*N*/ {
/*N*/ 	return ToolBox::Notify( rNEvt );
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ BOOL SfxToolbox::IsHiContrastMode()
/*N*/ {
/*N*/ 	Color aBackColor = GetBackground().GetColor();
/*N*/ 	if ( aBackColor.IsDark() )
/*N*/ 		return TRUE;
/*N*/ 	else
/*N*/ 		return FALSE;
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxToolbox::StateChanged( StateChangedType nType )
/*N*/ {
/*N*/ 	ToolBox::StateChanged( nType );
/*N*/ 
/*N*/ 	if ( nType == STATE_CHANGE_CONTROLBACKGROUND )
/*N*/ 	{
/*N*/ 		// Check if we need to get new images for normal/high contrast mode
/*?*/ 		CheckAndUpdateImages();
/*N*/ 	}
/*N*/ 	else if ( nType == STATE_CHANGE_TEXT )
/*N*/ 	{
/*N*/ 		// The physical toolbar changed its outlook and shows another logical toolbar!
/*N*/ 		// We have to set the correct high contrast mode on the new tbx manager.
/*N*/ 		pMgr->SetHiContrast( IsHiContrastMode() );
/*N*/ 	}
/*N*/ 	else if ( nType == STATE_CHANGE_INITSHOW && pMgr->GetType() == 558 ) // fullscreenbar
/*N*/ 	{
/*N*/ 		// This code is a special implementation for the fullscreenbar!!
/*N*/ 		if ( aFloatPos.X() == LONG_MAX && aFloatPos.Y() == LONG_MAX )
/*N*/ 		{
/*?*/ 			// Place the fullscreenbar to the right-bottom corner of the window
/*?*/ 			// if we don't have a user position!
/*?*/ 			Window*		pFloatWindow	= GetFloatingWindow();
/*?*/             // use absolute screen coordinates here, otherwise floating windows do not include their decoration
/*?*/ 			Rectangle   aRect			= pFloatWindow ? pFloatWindow->GetWindowExtentsRelative( NULL ) : GetWindowExtentsRelative( NULL );
/*?*/             Size        aSize( aRect.GetSize() );
/*?*/ 			Size		aWinSize		= GetParent()->GetSizePixel(); // the full screen size
/*?*/ 
/*?*/ 			Point	aNewPos( aWinSize.Width() - 1 - aSize.Width(),
/*?*/ 							 aWinSize.Height() - 1 - aSize.Height() );
/*?*/ 
/*?*/ 			const StyleSettings& rSettings = Application::GetSettings().GetStyleSettings();
/*?*/ 			long				 aDecoSize = rSettings.GetBorderSize();
/*?*/ 
/*?*/             Window* pParent = &(pMgr->GetBindings().GetDispatcher()->GetFrame()->GetWindow());
/*?*/             if ( pParent->IsScrollable() )
/*?*/                 aDecoSize += rSettings.GetScrollBarSize();
/*?*/ 
/*?*/ 			// Fullscreen mode does always show horz. and vertical scrollbar. Currently it is not possible
/*?*/ 			// to detect that a window shows it scrollbars. VCL limitation.
/*?*/ 			aNewPos.X() -= aDecoSize;
/*?*/ 			aNewPos.Y() -= aDecoSize;
/*?*/ 
/*?*/ 			SetPosPixel( GetParent()->AbsoluteScreenToOutputPixel( aNewPos ));
/*N*/ 		}
/*N*/ 	}
/*N*/ }

/*?*/ void SfxToolbox::DataChanged( const DataChangedEvent& rDCEvt )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	ToolBox::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	if ((( rDCEvt.GetType() == DATACHANGED_SETTINGS	)	||
//STRIP001 		( rDCEvt.GetType() == DATACHANGED_DISPLAY	))	&&
//STRIP001         ( rDCEvt.GetFlags() & SETTINGS_STYLE		))
//STRIP001 	{
//STRIP001 		// Check if we need to get new images for normal/high contrast mode
//STRIP001 		CheckAndUpdateImages();
//STRIP001 	}
//STRIP001 
//STRIP001     for ( USHORT nPos = 0; nPos<GetItemCount(); ++nPos )
//STRIP001 	{
//STRIP001         const USHORT nId = GetItemId(nPos);
//STRIP001         Window* pWindow = GetItemWindow( nId );
//STRIP001         if ( pWindow )
//STRIP001             pWindow->DataChanged( rDCEvt );
//STRIP001     }
//STRIP001 
//STRIP001     if ( !IsFloatingMode() )
//STRIP001     {
//STRIP001         Size aActSize( GetSizePixel() );
//STRIP001         Size aSize( CalcWindowSizePixel() );
//STRIP001         if ( IsHorizontal() )
//STRIP001             aSize.Width() = aActSize.Width();
//STRIP001         else
//STRIP001             aSize.Height() = aActSize.Height();
//STRIP001 
//STRIP001         SetSizePixel( aSize );
//STRIP001     }
/*?*/ }

//-------------------------------------------------------------------------

/*?*/ void SfxToolbox::CheckAndUpdateImages()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     BOOL bRefreshImages = FALSE;
//STRIP001 
//STRIP001     // Check if high contrast/normal mode have changed
//STRIP001 	if ( IsHiContrastMode() )
//STRIP001 	{
//STRIP001 		if ( !pMgr->IsHiContrast() )
//STRIP001 		{
//STRIP001             bRefreshImages = TRUE;
//STRIP001 			pMgr->SetHiContrast( TRUE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( pMgr->IsHiContrast() )
//STRIP001     {
//STRIP001         bRefreshImages = TRUE;
//STRIP001 	    pMgr->SetHiContrast( FALSE );
//STRIP001 	}
//STRIP001 	
//STRIP001     // Refresh images if requested
//STRIP001     if ( bRefreshImages )
//STRIP001         pMgr->RefreshImages_Impl();
/*?*/ }

//-------------------------------------------------------------------------

/*?*/ USHORT SfxToolbox::GetItemAt( const CommandEvent &rEvt )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
//STRIP001 	Point aMousePos = rEvt.GetMousePosPixel();
//STRIP001 	for (USHORT nPos = 0; nPos<GetItemCount(); nPos++)
//STRIP001 	{
//STRIP001 		USHORT nId = GetItemId( nPos );
//STRIP001 		Rectangle aItemRect( GetItemRect( nId ) );
//STRIP001 		if ( aItemRect.IsInside( aMousePos ) )
//STRIP001 			return nId;
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
/*?*/ }


//-------------------------------------------------------------------------

/*N*/ void SfxToolbox::MouseMove( const MouseEvent& rMEvt )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	Point aPos;
//STRIP001 	if ( GetParent()->GetType() == RSC_FLOATINGWINDOW
//STRIP001 		&& ((FloatingWindow*)GetParent())->IsInPopupMode() )
//STRIP001 	{
//STRIP001 		aPos = rMEvt.GetPosPixel();
//STRIP001 		USHORT nId = GetItemId( aPos );
//STRIP001 		pControl = pMgr->FindControl_Impl( nId );
//STRIP001 		if ( pControl )
//STRIP001 		{
//STRIP001 			SfxPopupWindowType eType = pControl->GetPopupWindowType();
//STRIP001 			if ( SFX_POPUPWINDOW_ONTIMEOUTANDMOVE == eType ||
//STRIP001 				 SFX_POPUPWINDOW_ONCLICKANDMOVE == eType )
//STRIP001 			{
//STRIP001 				// Es k"onnte ein kaskadierendes Popup angefordert werden
//STRIP001 				if ( !pImp->pControl || pImp->pControl->GetId() != nId )
//STRIP001 				{
//STRIP001 					// Id merken; wenn nach Ablauf des Timers der Mauszeiger
//STRIP001 					// immer noch auf dem Control steht, wird das Popup
//STRIP001 					// aufgeklappt
//STRIP001 					if ( pImp->pPopup )
//STRIP001 						pImp->EndPopupMode();
//STRIP001 
//STRIP001 					pImp->pControl = pControl;
//STRIP001 					pImp->aTimer.Start();
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pImp->pControl )
//STRIP001 	{
//STRIP001 		if ( pImp->pPopup )
//STRIP001 		{
//STRIP001 			// Das Popup ist offen; wenn der Mauszeiger ein anderes Control
//STRIP001 			// erreicht hat, wird das Popup geschlossen
//STRIP001 			BOOL bEnd = FALSE;
//STRIP001 
//STRIP001 			Rectangle aRect( pImp->pPopup->GetPosPixel(), pImp->pPopup->GetSizePixel() );
//STRIP001 
//STRIP001 			Point aScrPos = OutputToScreenPixel( aPos );
//STRIP001 			BOOL bOverPopup = aRect.IsInside( aScrPos );
//STRIP001 
//STRIP001 			if ( pControl && pImp->pControl != pControl && !bOverPopup )
//STRIP001 				bEnd = TRUE;
//STRIP001 			if ( bEnd )
//STRIP001 				pImp->EndPopupMode();
//STRIP001 		}
//STRIP001 		else if ( pImp->pControl != pControl )
//STRIP001 		{
//STRIP001 			// Bevor das Popup ge"offnet wurde, hat der Mauszeiger das
//STRIP001 			// Control verlassen
//STRIP001 			pImp->aTimer.Stop();
//STRIP001 			pImp->pControl = 0;
//STRIP001 		}
//STRIP001 
//STRIP001 		// Mausposition merken
//STRIP001 		pImp->aPos = aPos;
//STRIP001 	}
//STRIP001 
//STRIP001 	ToolBox::MouseMove( rMEvt );
//STRIP001 	return;
/*
	if ( SID_BROWSE_STOP == GetItemId( rMEvt.GetPosPixel() ) )
	{
		Application::LeaveWait();
		bWaitSuppressed = TRUE;
	}
	else if ( bWaitSuppressed )
		Application::EnterWait();
*/
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxToolbox::MouseButtonDown( const MouseEvent& rMEvt )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	// um im Click zu wissen, ob Ctrl gedr"uckt wurde
//STRIP001 /*N*/ 	bMod1 = rMEvt.IsMod1();
//STRIP001 /*N*/ 	bMod2 = rMEvt.IsMod2();
//STRIP001 /*N*/ 	bShift = rMEvt.IsShift();
//STRIP001 
//STRIP001 	// Es mu\s "uberpr"uft werden, ob die Toolbox konfigurierbar ist.
//STRIP001 	// Wenn nicht, wird der Handler der Basisklasse nur aufgerufen, wenn
//STRIP001 	// die Maus "uber einem Item steht, damit kein Docking erfolgt.
//STRIP001 /*N*/ 	BOOL bCancel = FALSE;
//STRIP001 /*N*/ 	Point aMousePos = rMEvt.GetPosPixel();
//STRIP001 /*N*/ 	if ( !IsCustomize() )
//STRIP001 /*N*/ 	{
//STRIP001 /*?*/ 		// Nicht konfigurierbare Toolbox
//STRIP001 /*?*/ 		bCancel = TRUE;
//STRIP001 /*?*/ 		for (USHORT nPos = 0; nPos<GetItemCount(); nPos++)
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			USHORT nId = GetItemId( nPos );
//STRIP001 /*?*/ 			Rectangle aItemRect( GetItemRect( nId ) );
//STRIP001 /*?*/ 			if ( aItemRect.IsInside( aMousePos ) )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				// Maus "uber Item
//STRIP001 /*?*/ 				bCancel = FALSE;
//STRIP001 /*?*/ 				break;
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 		}
//STRIP001 /*N*/ 	}
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 	if ( bCancel )
//STRIP001 /*N*/ 	{
//STRIP001 /*N*/ 		// Wenn nicht "uber einem Item, dann vielleicht "uber den Scroll-
//STRIP001 		// pfeilen ?
//STRIP001 
//STRIP001 /*?*/ 		Rectangle aRect = GetScrollRect();
//STRIP001 /*?*/ 		if ( aRect.IsInside( aMousePos ) )
//STRIP001 /*?*/ 			bCancel = FALSE;
//STRIP001 /*N*/ 	}
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 	// Soll abgebrochen werden ?
//STRIP001 /*N*/ 	if ( !bCancel )
//STRIP001 /*N*/ 		ToolBox::MouseButtonDown( rMEvt );
/*N*/ }

//-------------------------------------------------------------------------

/*?*/ void SfxToolbox::MouseButtonUp( const MouseEvent& rMEvt )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	bMod1 = bMod2 = bShift = FALSE;
//STRIP001 	if ( pImp->pPopup )
//STRIP001 	{
//STRIP001 		Rectangle aRect( pImp->pPopup->GetPosPixel(), pImp->pPopup->GetSizePixel() );
//STRIP001 		USHORT nId = pImp->pControl->GetId();
//STRIP001 		Point aPos = rMEvt.GetPosPixel();
//STRIP001 		Point aScrPos = OutputToScreenPixel( aPos );
//STRIP001 
//STRIP001 		// Die Berechnung f"ur den kaskadierten Modus beruht darauf, da\s das
//STRIP001 		// Popupwindow keine Titlebar hat; im MouseButtonUp ist das aber nicht
//STRIP001 		// gew"ahrleistet; daher Position korrigieren ( f"uhrt zu einem
//STRIP001 		// Fehler der Gr"o\se des Borders des FloatingWindows ).
//STRIP001 		pImp->EndPopupMode();
//STRIP001 
//STRIP001 		// Den Vater-Kontroller von der ausgef"uhrten Id unterrichten, sofern
//STRIP001 		// die Funktion auch tats"achlich ausgef"uhrt wird
//STRIP001 		if( aRect.IsInside( aScrPos ) )
//STRIP001 		{
//STRIP001 			USHORT nControllerId = ((SfxPopupWindow*)GetParent())->GetId();
//STRIP001 			SfxUInt16Item aItem( nControllerId, nId );
//STRIP001 			pMgr->GetBindings().GetDispatcher_Impl()->Execute(
//STRIP001 					nControllerId, SFX_CALLMODE_SYNCHRON, &aItem, 0L );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	ToolBox::MouseButtonUp( rMEvt );
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxToolbox::Click()
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	// Wenn die ToolBox zum Deleten vorgemerkt ist, soll nichts mehr
//STRIP001 	// selektiert werden koennen.
//STRIP001 /*N*/ 	if (bDeleteToolBox)
//STRIP001 /*N*/ 		return;
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 	pControl = pMgr->FindControl_Impl( GetCurItemId() );
//STRIP001 /*N*/ 	if ( pControl )
//STRIP001 /*N*/ 	{
//STRIP001 /*N*/ 		pControl->Click();
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 		SfxPopupWindowType eType = pControl->GetPopupWindowType();
//STRIP001 /*N*/ 		if ( SFX_POPUPWINDOW_ONTIMEOUT == eType ||
//STRIP001 /*N*/ 			 SFX_POPUPWINDOW_ONTIMEOUTANDMOVE == eType )
//STRIP001 /*N*/ 		{
//STRIP001 /*?*/             if( IsKeyEvent() )
//STRIP001 /*?*/             {
//STRIP001 /*?*/                 if( IsShift() )
//STRIP001 /*?*/                 {
//STRIP001 /*?*/ 		            pMgr->GetBindings().ENTERREGISTRATIONS();
//STRIP001 /*?*/ 			        Window *pWin = pControl->CreatePopupWindow();
//STRIP001 /*?*/                     if( pWin )
//STRIP001 /*?*/                     {
//STRIP001 /*?*/                         // enable dialog key handling for popup when activated through keyboard
//STRIP001 /*?*/                         pWin->SetStyle( (pWin->GetStyle() | WB_DIALOGCONTROL) & ~(WB_NODIALOGCONTROL|WB_TABSTOP) );
//STRIP001 /*?*/                         pWin->GrabFocus();
//STRIP001 /*?*/                     }
//STRIP001 /*?*/ 		            pMgr->GetBindings().LEAVEREGISTRATIONS();
//STRIP001 /*?*/                 }
//STRIP001 /*?*/             }
//STRIP001 /*?*/             else if ( bShift )
//STRIP001 /*?*/             {
//STRIP001 /*?*/ 		        pMgr->GetBindings().ENTERREGISTRATIONS();
//STRIP001 /*?*/ 				pControl->CreatePopupWindow();
//STRIP001 /*?*/ 		        pMgr->GetBindings().LEAVEREGISTRATIONS();
//STRIP001 /*?*/             }
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 				aTimer.Start();
//STRIP001 /*?*/ 		}
//STRIP001 /*N*/ 		else if ( SFX_POPUPWINDOW_ONCLICK == eType ||
//STRIP001 /*N*/ 				 SFX_POPUPWINDOW_ONCLICKANDMOVE == eType )
//STRIP001 /*N*/             {
//STRIP001 /*?*/ 		        pMgr->GetBindings().ENTERREGISTRATIONS();
//STRIP001 /*?*/ 			    Window *pWin = pControl->CreatePopupWindow();
//STRIP001 /*?*/                 if( IsKeyEvent() && pWin )
//STRIP001 /*?*/                 {
//STRIP001 /*?*/                     // enable dialog key handling for popup when activated through keyboard
//STRIP001 /*?*/                     pWin->SetStyle( (pWin->GetStyle() | WB_DIALOGCONTROL) & ~(WB_NODIALOGCONTROL|WB_TABSTOP) );
//STRIP001 /*?*/                     pWin->GrabFocus();
//STRIP001 /*?*/                 }
//STRIP001 /*?*/ 		        pMgr->GetBindings().LEAVEREGISTRATIONS();
//STRIP001 /*?*/             }
//STRIP001 /*N*/ 	}
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 	ToolBox::Click();
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxToolbox::Deactivate()
/*N*/ {
/*N*/ 	aTimer.Stop();
/*N*/ 	ToolBox::Deactivate();
/*N*/ }


//-------------------------------------------------------------------------

/*?*/ IMPL_LINK_INLINE_START( SfxToolbox, TimeHdl, Timer *, pTimer )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     pMgr->GetBindings().ENTERREGISTRATIONS();
//STRIP001 
//STRIP001 	if ( pTimer )
//STRIP001 		aLink.Call( 0 );
//STRIP001 	else
//STRIP001 		pControl->CreatePopupWindow();
//STRIP001 
//STRIP001     pMgr->GetBindings().LEAVEREGISTRATIONS();
/*?*/ 	return 0;
/*?*/ }
/*?*/ IMPL_LINK_INLINE_END( SfxToolbox, TimeHdl, Timer *, pTimer )


/*?*/ IMPL_LINK( SfxToolbox, AsyncStoreCfgHdl, Timer *, pTimer )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/       pMgr->GetBindings().GetToolBoxConfig()->Configure_Impl( pMgr );
/*?*/       return 0;
/*?*/ }

//-------------------------------------------------------------------------

/*?*/ void SfxToolbox::Command ( const CommandEvent& rCEvt )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     if ( bDeleteToolBox )
//STRIP001         return;
//STRIP001 
//STRIP001 	if ( rCEvt.GetCommand() != COMMAND_CONTEXTMENU )
//STRIP001 	{
//STRIP001 		ToolBox::Command( rCEvt );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT nId = GetItemAt (rCEvt);
//STRIP001 
//STRIP001     if ( IsInCustomizeMode() && nId )
//STRIP001 	{
//STRIP001 		// Wenn gerade das "Toolbox bearbeiten"-Fenster aktiv ist, kann durch
//STRIP001 		// Click mit der rechten Maustaste auf einen Button das Image des
//STRIP001 		// Buttons ausgetauscht werden
//STRIP001 		String aText = GetItemText(nId);
//STRIP001         SfxChildWindow *pChild = pMgr->GetBindings().GetDispatcher()->GetFrame()->GetChildWindow( SfxToolboxCustomWindow::GetChildWindowId());
//STRIP001 		DBG_ASSERT(pChild,"Wo ist der ToolboxCustomizer ??");
//STRIP001 
//STRIP001         if ( pChild )
//STRIP001         {
//STRIP001             SfxToolboxCustomizer *pCust =
//STRIP001                 (SfxToolboxCustomizer*) pChild->GetWindow();
//STRIP001             SfxUserBitmapDialog_Impl *pDlg =
//STRIP001                 pCust->ConnectUserBitmapDialog_Impl( nId, *this, pMgr );
//STRIP001             if (pDlg && pDlg->Execute())
//STRIP001             {
//STRIP001                 if ( aText != GetItemText(nId) )
//STRIP001                     pMgr->SetDefault(FALSE);
//STRIP001             }
//STRIP001         }
//STRIP001 
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	// No context menu if slots/commands SID_CONFIG/SID_TOOLBOXOPTIONS//ConfigureDialog are not enabled
//STRIP001 	SfxDispatcher *pDispat = pMgr->GetBindings().GetDispatcher();
//STRIP001     Reference< XFrame > xFrame = pDispat->GetFrame()->GetFrame()->GetFrameInterface();
//STRIP001     if ( xFrame.is() )
//STRIP001     {
//STRIP001         Reference< XDispatchProvider > xProv( xFrame, UNO_QUERY );
//STRIP001         Reference< XURLTransformer > xTrans( ::legacy_binfilters::getLegacyProcessServiceFactory()->createInstance( 
//STRIP001                                                 OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.util.URLTransformer" ))), UNO_QUERY );
//STRIP001         ::com::sun::star::util::URL aURL;
//STRIP001         aURL.Complete = OUString( RTL_CONSTASCII_USTRINGPARAM( ".uno:ConfigureDialog" ));
//STRIP001         xTrans->parseStrict( aURL );
//STRIP001         Reference< XDispatch > xDisp = xProv->queryDispatch( aURL, ::rtl::OUString(), 0 );
//STRIP001         
//STRIP001         if ( !xDisp.is() )
//STRIP001             return;
//STRIP001     }
//STRIP001     
//STRIP001     // Check also with QueryState to support the old slots.cfg file
//STRIP001     const SfxPoolItem* pDummy = NULL;
//STRIP001     SfxItemState eState1 = pDispat->QueryState( SID_CONFIG, pDummy );
//STRIP001 	SfxItemState eState2 = pDispat->QueryState( SID_TOOLBOXOPTIONS, pDummy );
//STRIP001 	if (( SFX_ITEM_DISABLED == eState1 ) || ( SFX_ITEM_DISABLED == eState2 ))
//STRIP001 		return;
//STRIP001 
//STRIP001 	if ( pMgr->GetBindings().GetDispatcher_Impl()->IsLocked())
//STRIP001 		return;
//STRIP001 
//STRIP001 	// Gegen Zerst"orung sch"utzen
//STRIP001 	bActivated = 2;
//STRIP001     if ( !pMgr->IsInternal() && pMgr->GetBindings().GetDispatcher_Impl() )
//STRIP001 	{
//STRIP001 		SfxDispatcher *pDispat = pMgr->GetBindings().GetDispatcher_Impl();
//STRIP001 		SfxViewFrame *pFrame  = pDispat->GetFrame();
//STRIP001 		SfxObjectShell* pSh = pFrame->GetObjectShell();
//STRIP001 		SFX_ITEMSET_ARG( pSh->GetMedium()->GetItemSet(), pEditItem, SfxBoolItem, SID_VIEWONLY, sal_False );
//STRIP001 		BOOL bIsViewer = pEditItem && pEditItem->GetValue();
//STRIP001 		if ( bIsViewer )
//STRIP001 			return;
//STRIP001 
//STRIP001 		// Nur bei konfigurierbaren Toolboxen wird auch das Context-Menu
//STRIP001 		// angeboten
//STRIP001 		SfxPopupMenuManager aPop(SfxResId(RID_SFX_TOOLBOX_POPUP), pMgr->GetBindings());
//STRIP001 		aPop.Initialize();
//STRIP001 		Menu *pMenu 	= aPop.GetMenu()->GetSVMenu();
//STRIP001 
//STRIP001 		// Alle nicht belegten Positionen rauswerfen
//STRIP001 		SfxWorkWindow *pWorkWin = SFX_APP()->GetWorkWindow_Impl(pFrame);
//STRIP001 		if ( !pWorkWin->KnowsObjectBar_Impl(SFX_OBJECTBAR_APPLICATION) )
//STRIP001 			pMenu->RemoveItem(pMenu->GetItemPos(SID_TOGGLEFUNCTIONBAR));
//STRIP001 		if ( !pWorkWin->KnowsObjectBar_Impl(SFX_OBJECTBAR_OBJECT) )
//STRIP001 			pMenu->RemoveItem(pMenu->GetItemPos(SID_TOGGLEOBJECTBAR));
//STRIP001 		if ( !pWorkWin->KnowsObjectBar_Impl(SFX_OBJECTBAR_TOOLS) )
//STRIP001 			pMenu->RemoveItem(pMenu->GetItemPos(SID_TOGGLETOOLBAR));
//STRIP001 		if ( !pWorkWin->KnowsObjectBar_Impl(SFX_OBJECTBAR_OPTIONS) )
//STRIP001 			pMenu->RemoveItem(pMenu->GetItemPos(SID_TOGGLEOPTIONBAR));
//STRIP001 		if ( !pWorkWin->KnowsObjectBar_Impl(SFX_OBJECTBAR_COMMONTASK) )
//STRIP001 			pMenu->RemoveItem(pMenu->GetItemPos(SID_TOGGLECOMMONTASKBAR));
//STRIP001 		if ( !pWorkWin->KnowsObjectBar_Impl(SFX_OBJECTBAR_MACRO) )
//STRIP001 			pMenu->RemoveItem(pMenu->GetItemPos(SID_TOGGLEMACROBAR));
//STRIP001 		if ( !pWorkWin->KnowsObjectBar_Impl(SFX_OBJECTBAR_NAVIGATION) )
//STRIP001 			pMenu->RemoveItem(pMenu->GetItemPos(SID_TOGGLENAVBAR));
//STRIP001 
//STRIP001 		// Position dieser Toolbox holen
//STRIP001 		USHORT nPos=0xFFFF;
//STRIP001 		SfxShell *pShell=0;
//STRIP001 		USHORT nIdx;
//STRIP001 		for (nIdx=0; (pShell=pDispat->GetShell(nIdx)); nIdx++)
//STRIP001 		{
//STRIP001 			const SfxInterface *pIFace = pShell->GetInterface();
//STRIP001 
//STRIP001 			for (USHORT nNo=0; nNo<pIFace->GetObjectBarCount(); nNo++)
//STRIP001 			{
//STRIP001 				USHORT nID = pIFace->GetObjectBarResId(nNo).GetId();
//STRIP001 				USHORT nId = pMgr->GetType();
//STRIP001 				if (pIFace->GetObjectBarResId(nNo).GetId() == pMgr->GetType())
//STRIP001 				{
//STRIP001 					nPos = pIFace->GetObjectBarPos(nNo);
//STRIP001 					break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			if (nPos != 0xFFFF) break;
//STRIP001 		}
//STRIP001 
//STRIP001 		USHORT nItems=0;
//STRIP001 		SvUShorts aIds;
//STRIP001 		if ( nPos != 0xFFFF )
//STRIP001 		{
//STRIP001 			// Alle im Kontext moeglichen Toolboxen einsammeln
//STRIP001 			ResMgr *pResMgr=0;
//STRIP001 			for (nIdx=0; (pShell=pDispat->GetShell(nIdx)); nIdx++)
//STRIP001 			{
//STRIP001 				const SfxInterface *pIFace = pShell->GetInterface();
//STRIP001 
//STRIP001 				for ( USHORT nNo = 0; pIFace && nNo<pIFace->GetObjectBarCount(); ++nNo )
//STRIP001 				{
//STRIP001 /*
//STRIP001 					// Test ...
//STRIP001 					USHORT nPos1 = pIFace->GetObjectBarPos(nNo) & SFX_POSITION_MASK;
//STRIP001 					USHORT nPos2 = nPos & SFX_POSITION_MASK;
//STRIP001 					USHORT nItemPos =
//STRIP001 						pMenu->GetItemPos( pIFace->GetObjectBarResId(nNo).GetId() );
//STRIP001 					BOOL bVisible = pIFace->IsObjectBarVisible(nNo);
//STRIP001 */
//STRIP001 					USHORT nActPos = pIFace->GetObjectBarPos(nNo);
//STRIP001 					if ( (nActPos & SFX_POSITION_MASK) == (nPos & SFX_POSITION_MASK) &&
//STRIP001 						 pMenu->GetItemPos(pIFace->GetObjectBarResId(nNo).GetId()) == MENU_ITEM_NOTFOUND &&
//STRIP001 						 pIFace->IsObjectBarVisible(nNo) )
//STRIP001 					{
//STRIP001 						USHORT nId = pIFace->GetObjectBarResId(nNo).GetId();
//STRIP001 						ULONG nFeature = pIFace->GetObjectBarFeature( nNo );
//STRIP001 						if ( nFeature && !pShell->HasUIFeature( nFeature ) )
//STRIP001 							continue;
//STRIP001 						BOOL bViewerTbx = SFX_VISIBILITY_VIEWER == ( nActPos & SFX_VISIBILITY_VIEWER );
//STRIP001 						if ( bIsViewer != bViewerTbx )
//STRIP001 							continue;
//STRIP001 
//STRIP001 						USHORT n;
//STRIP001 						for (n=0; n<aIds.Count(); n++)
//STRIP001 						{
//STRIP001 							if ( aIds[n] == nId )
//STRIP001 								break;
//STRIP001 						}
//STRIP001 
//STRIP001 						if ( n == aIds.Count() )
//STRIP001 						{
//STRIP001 							aIds.Insert( nId, aIds.Count() );
//STRIP001 							pMenu->InsertItem( aIds.Count(), *(pIFace->GetObjectBarName(nNo)),
//STRIP001 								MIB_CHECKABLE|MIB_RADIOCHECK, nItems++);
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			if (nItems == 1)
//STRIP001 				pMenu->RemoveItem(--nItems);
//STRIP001 			else
//STRIP001 			{
//STRIP001 				pMenu->InsertSeparator(nItems);
//STRIP001 				for ( USHORT n=0; n<aIds.Count(); n++ )
//STRIP001 					if ( aIds[n] == pMgr->GetType() )
//STRIP001 						pMenu->CheckItem( n+1 );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// SubMenu f"ur erweiterte Konfigurierbarkeit
//STRIP001 		PopupMenu *pItemMenu = pMenu->GetPopupMenu( ITEM_ID_VISIBLE_ITEMS );
//STRIP001 		if ( IsCustomize() )
//STRIP001 		{
//STRIP001 			for ( nPos = 0; nPos < GetItemCount(); ++nPos )
//STRIP001 			{
//STRIP001 				if ( GetItemType(nPos) == TOOLBOXITEM_BUTTON )
//STRIP001 				{
//STRIP001 					USHORT nId = GetItemId(nPos);
//STRIP001 					if ( !pMgr->IsRuntimeItem( nId ))
//STRIP001 					{
//STRIP001 					    pItemMenu->InsertItem( nPos+nItems+1, GetItemText( nId ), MIB_CHECKABLE );
//STRIP001 					    pItemMenu->CheckItem( nPos+nItems+1, IsItemVisible( nId ) );
//STRIP001 					    pItemMenu->SetItemImage( nPos+nItems+1, GetItemImage( nId ) );
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					pItemMenu->InsertSeparator();
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pMenu->RemoveItem( pMenu->GetItemPos( ITEM_ID_VISIBLE_ITEMS ) );
//STRIP001 		}
//STRIP001 
//STRIP001 		SfxUInt16Item aConfigItem ( SID_CONFIGITEMID, pMgr->GetType() );
//STRIP001 		SfxUInt16Item *pItem = &aConfigItem;
//STRIP001 
//STRIP001         Point aPoint( rCEvt.GetMousePosPixel() );
//STRIP001         USHORT nId = aPop.Execute( aPoint, this, (const SfxPoolItem*)pItem, 0L );
//STRIP001 
//STRIP001 		if ( nId && pMenu->GetItemPos(nId) < nItems )
//STRIP001 			pDispat->ShowObjectBar(aIds[nId-1]);
//STRIP001 		else if ( nId == ITEM_ID_RESET_ITEMS )
//STRIP001 		{
//STRIP001 			SfxConfigManager* pCfg = pMgr->GetConfigManager();
//STRIP001 			USHORT nType = pMgr->GetType();
//STRIP001 			pCfg->ResetConfigItem( nType );
//STRIP001 			pCfg->ReInitialize( nType );
//STRIP001 		}
//STRIP001 		else if ( pMenu->GetItemPos(nId) == TOOLBOX_ITEM_NOTFOUND )
//STRIP001 		{
//STRIP001 			// Item aus dem SubMenu
//STRIP001 			USHORT nItemId = GetItemId( nId-nItems-1 );
//STRIP001 			if ( IsItemVisible( nItemId ) )
//STRIP001 				HideItem( nItemId );
//STRIP001 			else
//STRIP001 				ShowItem( nItemId );
//STRIP001 			pMgr->SetDefault( FALSE );
//STRIP001             pMgr->StoreConfig();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// ggf. Kontext-Menu-Event an den Controller weiterleiten
//STRIP001 	if ( nId && 0 != ( pControl = pMgr->FindControl_Impl( nId ) ) )
//STRIP001 	{
//STRIP001 		SfxPopupWindowType eType = pControl->GetPopupWindowType();
//STRIP001 		if ( SFX_POPUPWINDOW_CONTEXTMENU == eType )
//STRIP001 			pControl->CreatePopupWindow();
//STRIP001 	}
//STRIP001 
//STRIP001 	bActivated = FALSE;
/*?*/ }

/*?*/ void SfxToolbox::NextToolBox()
/*?*/ {
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pMgr->NextToolBox();
/*?*/ }

//-------------------------------------------------------------------------

//STRIP001 void SfxToolbox::DoubleClick()
//STRIP001 {
//STRIP001 	if ( !GetCurItemId() )
//STRIP001 	{
//STRIP001 		ToolBox::DoubleClick();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SfxToolBoxControl *pControl = pMgr->FindControl_Impl( GetCurItemId() );
//STRIP001 		if ( pControl )
//STRIP001 			pControl->DoubleClick();
//STRIP001 	}
//STRIP001 }


//--------------------------------------------------------------------

//  Ueberlagert den entsprechenden ToolBoxHandler; die Docking rectangles
//	werden gesetzt, die alten Attribute zu Vergleichszwecken aufgehoben.

//STRIP001 void SfxToolbox::StartDocking()
//STRIP001 {
//STRIP001 	nLines = GetLineCount();            // alte Werte merken wg. SetModified()
//STRIP001 	nFloatLines = GetFloatingLines();
//STRIP001     aFloatPos = GetFloatingPosition();
//STRIP001 	eAlign = GetAlign();
//STRIP001 
//STRIP001 	SfxDispatcher* pDisp = pMgr->GetBindings().GetDispatcher_Impl();
//STRIP001 	if ( bConstructed && pDisp )
//STRIP001 	{
//STRIP001 		SfxViewFrame  *pFrame  = pDisp ->GetFrame();
//STRIP001 		SfxWorkWindow *pWorkWin = SFX_APP()->GetWorkWindow_Impl(pFrame);
//STRIP001 		pWorkWin->ConfigChild_Impl
//STRIP001 			( SFX_CHILDWIN_OBJECTBAR, SFX_SETDOCKINGRECTS, pMgr->GetType() );
//STRIP001 	}
//STRIP001 
//STRIP001 	ToolBox::StartDocking();
//STRIP001 }

//STRIP001 BOOL SfxToolbox::Docking( const Point& rPos, Rectangle& rRect )
//STRIP001 {
//STRIP001 	SfxDispatcher* pDisp = pMgr->GetBindings().GetDispatcher_Impl();
//STRIP001 	if ( !pDisp )
//STRIP001 		return IsFloatingMode();
//STRIP001 
//STRIP001 	Rectangle aRect( rRect );
//STRIP001 	BOOL bRet = ToolBox::Docking( rPos, aRect );
//STRIP001 
//STRIP001 	if ( !bRet )
//STRIP001 	{
//STRIP001 		SfxViewFrame  *pFrame  = pDisp->GetFrame();
//STRIP001 		SfxWorkWindow *pWorkWin = SFX_APP()->GetWorkWindow_Impl(pFrame);
//STRIP001 		if ( !pWorkWin->IsDockingAllowed() )
//STRIP001 			return TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	rRect = aRect;
//STRIP001 	return bRet;
//STRIP001 }

//--------------------------------------------------------------------

//  Ueberlagert den entsprechenden ToolBoxHander. Ueber den Dispatcher
//  wird das parent window benachrichtigt und die Funktion ausgefuehrt.
//	Die neuen Attribute werden mit den alten verglichen und ggf. eine
//	Veraenderung registriert.

//STRIP001 void SfxToolbox::EndDocking(const Rectangle& rRect, BOOL bFloatMode)
//STRIP001 {
//STRIP001 	ToolBox::EndDocking(rRect, bFloatMode);
//STRIP001 	BOOL bChange = FALSE;
//STRIP001 
//STRIP001 	SfxDispatcher* pDisp = pMgr->GetBindings().GetDispatcher_Impl();
//STRIP001 	if ( !bConstructed || !pDisp )
//STRIP001 		return;
//STRIP001 
//STRIP001 	if ( bConstructed && !IsDockingCanceled() )
//STRIP001 	{
//STRIP001         if (aFloatPos != GetFloatingPosition())
//STRIP001 		{
//STRIP001 			bChange = TRUE;
//STRIP001             aFloatPos = GetFloatingPosition();
//STRIP001 		}
//STRIP001 
//STRIP001 		if (nLines != GetLineCount())
//STRIP001 		{
//STRIP001 			bChange = TRUE;
//STRIP001 			nLines = GetLineCount();
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( eAlign != GetAlign() )
//STRIP001 		{
//STRIP001 			bChange = TRUE;
//STRIP001 			eAlign = GetAlign() ;
//STRIP001 
//STRIP001 			// Das SV-Toolbox-Alignment in einen SFX-enum umsetzen
//STRIP001 			if ( !IsFloatingMode() )
//STRIP001 				SetChildAlignment_Impl( GetAlign() );
//STRIP001 		}
//STRIP001 
//STRIP001 		if (nFloatLines != GetFloatingLines())
//STRIP001 		{
//STRIP001 			bChange = TRUE;
//STRIP001 			nFloatLines = GetFloatingLines();
//STRIP001 		}
//STRIP001 
//STRIP001 		if (bChange)
//STRIP001 			pMgr->GetBindings().GetToolBoxConfig()->Configure_Impl( pMgr );
//STRIP001 
//STRIP001 		SfxViewFrame  *pFrame  = pMgr->GetBindings().GetDispatcher_Impl()->GetFrame();
//STRIP001 		SfxWorkWindow *pWorkWin = SFX_APP()->GetWorkWindow_Impl(pFrame);
//STRIP001 		pWorkWin->ConfigChild_Impl
//STRIP001 			( SFX_CHILDWIN_OBJECTBAR, SFX_ALIGNDOCKINGWINDOW, pMgr->GetType() );
//STRIP001 	}
//STRIP001 }


//--------------------------------------------------------------------

//  Ueberlagert den entsprechenden ToolBoxHander. Die Daten des floating
//  window werden gemerkt. Wenn in den floating mode umgeschaltet werden
//	soll und aktuell noch keine FloatingMode-Daten gesetzt waren, werden
//	defaults ausgerechnet.

//STRIP001 BOOL SfxToolbox::PrepareToggleFloatingMode()
//STRIP001 {
//STRIP001 	SfxDispatcher* pDisp = pMgr->GetBindings().GetDispatcher_Impl();
//STRIP001 	if ( !bConstructed || !pDisp )
//STRIP001 		return ToolBox::PrepareToggleFloatingMode();
//STRIP001 
//STRIP001 	if (!IsFloatingMode() && bConstructed)
//STRIP001 	{
//STRIP001 		if ( GetFloatingLines() == 0 ) // noch keine Daten gesetzt
//STRIP001 		{
//STRIP001             Point aFloatPos = GetPosPixel();
//STRIP001 			long nWidth  = GetSizePixel().Width();
//STRIP001 			long nHeight = GetSizePixel().Height();
//STRIP001 			switch (GetAlign())
//STRIP001 			{
//STRIP001 				case WINDOWALIGN_LEFT:
//STRIP001 					nHeight =   nWidth;
//STRIP001 					break;
//STRIP001 				case WINDOWALIGN_RIGHT:
//STRIP001 					nHeight =   nWidth;
//STRIP001 					nWidth  = - nWidth;
//STRIP001 					break;
//STRIP001 				case WINDOWALIGN_TOP:
//STRIP001 					nWidth  =   nHeight;
//STRIP001 					break;
//STRIP001 				case WINDOWALIGN_BOTTOM:
//STRIP001 					nWidth  =   nHeight;
//STRIP001 					nHeight = - nHeight;
//STRIP001 					break;
//STRIP001 			}
//STRIP001 
//STRIP001 			aFloatPos.X() += 2 * nWidth;
//STRIP001 			aFloatPos.Y() += 2 * nHeight;
//STRIP001             nFloatLines = GetLineCount() * 2U;
//STRIP001 			aFloatPos = GetParent()->OutputToScreenPixel(aFloatPos);
//STRIP001 
//STRIP001 			SetFloatingLines(nFloatLines);
//STRIP001             SetFloatingPosition(aFloatPos);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( IsFloatingMode() )
//STRIP001 	{
//STRIP001 		SfxViewFrame  *pFrame  = pMgr->GetBindings().GetDispatcher_Impl()->GetFrame();
//STRIP001 		SfxWorkWindow *pWorkWin = SFX_APP()->GetWorkWindow_Impl(pFrame);
//STRIP001 		if ( !pWorkWin->IsDockingAllowed() )
//STRIP001 			return FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return ToolBox::PrepareToggleFloatingMode();
//STRIP001 }


//--------------------------------------------------------------------

//  Ueberlagert den entsprechenden ToolBoxHander. Ueber den Dispatcher
//  wird das parent window benachrichtigt und die Funktion ausgefuehrt.

//STRIP001 void SfxToolbox::ToggleFloatingMode()
//STRIP001 {
//STRIP001 	SfxDispatcher* pDisp = pMgr->GetBindings().GetDispatcher_Impl();
//STRIP001 	if ( !bConstructed || !pDisp )
//STRIP001 	{
//STRIP001 		ToolBox::ToggleFloatingMode();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bWasConstructed = bConstructed;
//STRIP001 	bConstructed = FALSE;               // Resize-Handler abklemmen
//STRIP001 	ToolBox::ToggleFloatingMode();
//STRIP001 	bConstructed = bWasConstructed;
//STRIP001 
//STRIP001 	if (bConstructed)
//STRIP001 	{
//STRIP001 		pMgr->Align();
//STRIP001 
//STRIP001 		// Das SV-Toolbox-Alignment in einen SFX-enum umsetzen
//STRIP001 		if ( !IsFloatingMode() )
//STRIP001 			SetChildAlignment_Impl( GetAlign() );
//STRIP001 
//STRIP001 		if (IsConstructed())
//STRIP001 			pMgr->GetBindings().GetToolBoxConfig()->Configure_Impl( pMgr );
//STRIP001 
//STRIP001 		SfxViewFrame  *pFrame  = pMgr->GetBindings().GetDispatcher_Impl()->GetFrame();
//STRIP001 		SfxWorkWindow *pWorkWin = SFX_APP()->GetWorkWindow_Impl(pFrame);
//STRIP001 		pWorkWin->ConfigChild_Impl
//STRIP001 			( SFX_CHILDWIN_OBJECTBAR, SFX_TOGGLEFLOATMODE, pMgr->GetType() );
//STRIP001 	}
//STRIP001 }

//-------------------------------------------------------------------------


/*N*/ void SfxToolbox::Highlight()
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 	USHORT nId = GetCurItemId();
/*N*/ 	if ( nId && !GetHelpText(nId).Len() )
/*N*/ 	{
/*?*/ 		SfxSlotPool &rSlotPool = SFX_SLOTPOOL();
/*?*/ 		SetHelpText( nId, rSlotPool.GetSlotHelpText_Impl(nId) );
/*N*/ 	}
/*N*/ 
/*N*/ 	ToolBox::Highlight();
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxToolbox::RequestHelp( const HelpEvent& rHEvt )
/*N*/ {
/*N*/ 	if ( !bHelpInitialized )
/*N*/ 	{
/*N*/ 		// Hilfetexte aus dem SlotPool (IDL-Slot-Ressourcen) laden
/*N*/ 		bHelpInitialized = TRUE;
/*N*/ 		SfxSlotPool &rSlotPool = SFX_SLOTPOOL();
/*N*/ 		for ( USHORT nPos = 0; nPos < GetItemCount(); ++nPos )
/*N*/ 		{
/*N*/ 			USHORT nId = GetItemId(nPos);
/*N*/ 			if ( nId )
/*N*/ 			{
/*N*/ #if 0
/*N*/ //! (pb) what about help?
/*N*/ 				if ( nHelpMode & HELPTEXTMODE_EXTERN )
/*N*/ 				{
/*N*/ 					ULONG nHelpId = GetHelpId( nId );
/*N*/ 					if( nHelpId )
/*N*/ 						SetHelpText( nId, String() );
/*N*/ 				}
/*N*/ 				else if ( nHelpMode & HELPTEXTMODE_NORESHELPTEXT )
/*N*/ 				{
/*N*/ 					SetHelpText( nId, String() );
/*N*/ 				}
/*N*/ 				else
/*N*/ #endif
/*N*/ 					SetHelpText( nId, rSlotPool.GetSlotHelpText_Impl( nId ) );
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	ToolBox::RequestHelp(rHEvt);
/*N*/ }

//--------------------------------------------------------------------

//  Ueberlagert den entsprechenden ToolBoxHander (leitet an Mgr weiter)

//STRIP001 void SfxToolbox::Customize( const ToolBoxCustomizeEvent& rCEvt )
//STRIP001 {
//STRIP001 	if (! (GetStyle() & WB_DOCKABLE) )
//STRIP001 		return;
//STRIP001 	pMgr->Customize(rCEvt);
//STRIP001 }

//--------------------------------------------------------------------

//  Ueberlagert den entsprechenden ToolBoxHander. Die Toolbox wird nicht
//  entfernt, sondern nur der Mode umgeschaltet.

/*?*/ BOOL SfxToolbox::Close()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001 	USHORT nPos=0xFFFF;
//STRIP001 	SfxShell *pShell=0;
//STRIP001 	SfxInterface *pIFace=0;
//STRIP001 	SfxBindings& rBindings = pMgr->GetBindings();
//STRIP001 	SfxDispatcher *pDispat = rBindings.GetDispatcher_Impl();
//STRIP001 	if ( !pDispat )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	for (USHORT nIdx=0; (pShell=pDispat->GetShell(nIdx)); nIdx++)
//STRIP001 	{
//STRIP001 		pIFace = pShell->GetInterface();
//STRIP001 		for (USHORT nNo=0; nNo<pIFace->GetObjectBarCount(); nNo++)
//STRIP001 		{
//STRIP001 			if (pIFace->GetObjectBarResId(nNo).GetId() == pMgr->GetType())
//STRIP001 			{
//STRIP001 				nPos = pIFace->GetObjectBarPos(nNo) & SFX_POSITION_MASK;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if (nPos != 0xFFFF)
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	SfxApplication *pSfxApp = SFX_APP();
//STRIP001 	if (nPos != 0xFFFF)
//STRIP001 	{
//STRIP001 		pMgr->GetBindings().GetToolBoxConfig()->SetToolBoxPositionVisible(nPos, FALSE);
//STRIP001 		if (nPos == SFX_OBJECTBAR_APPLICATION)
//STRIP001 			rBindings.Invalidate(SID_TOGGLEFUNCTIONBAR);
//STRIP001 		else if (nPos == SFX_OBJECTBAR_OBJECT)
//STRIP001 			rBindings.Invalidate(SID_TOGGLEOBJECTBAR);
//STRIP001 		else if (nPos == SFX_OBJECTBAR_TOOLS)
//STRIP001 			rBindings.Invalidate(SID_TOGGLETOOLBAR);
//STRIP001 		else if (nPos == SFX_OBJECTBAR_OPTIONS)
//STRIP001 			rBindings.Invalidate(SID_TOGGLEOPTIONBAR);
//STRIP001 		else if (nPos == SFX_OBJECTBAR_COMMONTASK)
//STRIP001 			rBindings.Invalidate(SID_TOGGLECOMMONTASKBAR);
//STRIP001 		else if (nPos == SFX_OBJECTBAR_MACRO)
//STRIP001 			rBindings.Invalidate(SID_TOGGLEMACROBAR);
//STRIP001 		else if (nPos == SFX_OBJECTBAR_NAVIGATION)
//STRIP001 			rBindings.Invalidate(SID_TOGGLENAVBAR);
//STRIP001 
//STRIP001 		bActivated = 2;
//STRIP001 		pMgr->GetBindings().GetDispatcher_Impl()->Update_Impl(TRUE);
//STRIP001 		bActivated = FALSE;
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return FALSE;
/*?*/ }

//--------------------------------------------------------------------

//  Ueberlagert den entsprechenden ToolBoxHander. Die Groesse des floating
//  windows wird gemerkt.
//	Behandelte events : floating window wurde umgegroessert.

/*N*/ void SfxToolbox::Resize()
/*N*/ {
/*N*/ 	ToolBox::Resize();
/*N*/ 	if (IsFloatingMode() && bConstructed)
/*N*/ 	{
/*N*/         if (!IsVisible())
/*N*/             return;
/*N*/ 
/*N*/         USHORT nActLines = GetFloatingLines();
/*N*/         if ( nActLines == nFloatLines )
/*N*/             return;
/*N*/ 
/*N*/         // if VCL does not return real line count for line count 0xFFFF
/*N*/         USHORT nLines = nFloatLines;
/*N*/         if ( nLines == 0xFFFF )
/*N*/         {
/*N*/             // every item takes on line
/*N*/             nLines = GetItemCount();
/*N*/             for ( USHORT nPos=0; nPos<GetItemCount(); ++nPos )
/*N*/             {
/*N*/                 USHORT nId = GetItemId(nPos);
/*N*/                 if ( !IsItemVisible( nId ) )
/*N*/                     nLines--;
/*N*/             }
/*N*/         }
/*N*/ 
/*N*/         if ( nLines != nActLines )
/*N*/ 		{
/*N*/             nFloatLines = nActLines;
/*N*/ 			pMgr->GetBindings().GetToolBoxConfig()->Configure_Impl( pMgr );
/*N*/ 		}
/*N*/ 	}
/*N*/ }

/*?*/ void SfxToolbox::FillInfo(SfxChildWinInfo&) const
/*?*/ {
/*?*/ }

/*N*/ void SfxToolbox::SetToolBoxAlignment_Impl( SfxChildAlignment eTbxAlign )
/*N*/ {
/*N*/ 	eAlignment = eTbxAlign;
/*N*/ 	if ( eTbxAlign != SFX_ALIGN_NOALIGNMENT )
/*N*/ 		SetAlign( ConvertAlign_Impl( eAlignment ) );
/*N*/ }


/*?*/ void SfxToolbox::SetChildAlignment_Impl( WindowAlign eTbxAlign )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	eAlign = eTbxAlign;
//STRIP001 
//STRIP001 	// doll ausserhalb von Childwins angedockt werden?
//STRIP001 	if ( eAlign != SFX_ALIGN_NOALIGNMENT && nPos == SFX_OBJECTBAR_APPLICATION )
//STRIP001 	{
//STRIP001 		eAlignment =
//STRIP001 		(SfxChildAlignment)
//STRIP001 			( eTbxAlign == WINDOWALIGN_TOP ? SFX_ALIGN_HIGHESTTOP :
//STRIP001 			eTbxAlign == WINDOWALIGN_LEFT ? SFX_ALIGN_LEFT :
//STRIP001 			eTbxAlign == WINDOWALIGN_RIGHT ? SFX_ALIGN_RIGHT :
//STRIP001 			SFX_ALIGN_BOTTOM );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		eAlignment =
//STRIP001 		(SfxChildAlignment)
//STRIP001 			( eTbxAlign == WINDOWALIGN_TOP ? SFX_ALIGN_TOOLBOXTOP :
//STRIP001 			eTbxAlign == WINDOWALIGN_LEFT ? SFX_ALIGN_TOOLBOXLEFT :
//STRIP001 			eTbxAlign == WINDOWALIGN_RIGHT ? SFX_ALIGN_TOOLBOXRIGHT :
//STRIP001 			SFX_ALIGN_TOOLBOXBOTTOM );
//STRIP001 	}
/*?*/ }

/*N*/ void SfxToolbox::ClearItemText_Impl()
/*N*/ {
/*N*/ 	aItems.Remove( 0, aItems.Count() );
/*N*/ }

/*N*/ void SfxToolbox::SetItemText_Impl( USHORT nId, BOOL bSet )
/*N*/ {
/*N*/ 	USHORT nCount = aItems.Count();
/*N*/ 	USHORT n;
/*N*/ 	for ( n=0; n<nCount; n++ )
/*N*/ 	{
/*N*/ 		if ( aItems[n] > nId )
/*N*/ 		{
/*N*/ 			break;
/*N*/ 		}
/*N*/ 		else if ( aItems[n] == nId )
/*N*/ 		{
/*N*/ 			aItems.Remove( n );
/*N*/ 			break;
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( bSet )
/*N*/ 		aItems.Insert( nId, n );
/*N*/ }

/*?*/ BOOL SfxToolbox::HasItemText_Impl( USHORT nId )
/*?*/ {DBG_BF_ASSERT(0, "STRIP");return FALSE; //STRIP001 
//STRIP001 	USHORT nCount = aItems.Count();
//STRIP001 	for ( USHORT n=0; n<nCount; n++ )
//STRIP001 		if ( aItems[n] == nId )
//STRIP001 			return TRUE;
//STRIP001 	return FALSE;
/*?*/ }

/*N*/ void SfxToolbox::SetFloatingPosition( const Point& rPos )
/*N*/ {
/*N*/     aFloatPos = rPos;
/*N*/     SetFloatingPos( rPos );
/*N*/ }

/*N*/ Point SfxToolbox::GetFloatingPosition() const
{
/*
    if ( IsFloatingMode() )
    {
		SfxDispatcher *pDispat = pMgr->GetBindings().GetDispatcher_Impl();
		SfxViewFrame  *pFrame  = pDispat->GetFrame();

		// Alle nicht belegten Positionen rauswerfen
		SfxWorkWindow *pWorkWin = SFX_APP()->GetWorkWindow_Impl(pFrame);
        Rectangle aRect = ((SfxToolbox*)this)->GetWindowExtentsRelative( pWorkWin->GetWindow() );
        return aRect.TopLeft();
    }
    else
    {
        return GetFloatingPos();
    }
*/
/*N*/     return aFloatPos;
/*N*/ }

/*N*/ void SfxToolbox::Move()
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*N*/     if ( IsFloatingMode() && IsReallyVisible() )
//STRIP001 /*N*/     {
/*
		SfxDispatcher *pDispat = pMgr->GetBindings().GetDispatcher_Impl();
		SfxViewFrame  *pFrame  = pDispat->GetFrame();

        SfxWorkWindow *pWorkWin = SFX_APP()->GetWorkWindow_Impl(pFrame);
        Window *pWindow = pWorkWin->GetWindow();
        while ( !pWindow->IsSystemWindow() )
            pWindow = pWindow->GetParent();

        Rectangle aRect = ((SfxToolbox*)this)->GetWindowExtentsRelative( pWindow );
        aFloatPos = aRect.TopLeft();
*/
//STRIP001 /*?*/ 		aFloatPos = GetFloatingPos();
//STRIP001 /*?*/ 		aAsyncStoreCfgTimer.Start();

//        pMgr->GetBindings().GetToolBoxConfig()->Configure_Impl( pMgr );
        //pWorkWin->ConfigChild_Impl( SFX_CHILDWIN_OBJECTBAR, SFX_ALIGNDOCKINGWINDOW, pMgr->GetType() );
///STRIP001 *N*/     }
/*N*/ }
}
