/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_fsetvwsh.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:51:26 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _SV_SPLITWIN_HXX //autogen wg. SplitWindow
// auto strip #include <vcl/splitwin.hxx>
// auto strip #endif
// auto strip #ifndef _UNDO_HXX //autogen wg. SfxUndoAction
// auto strip #include <svtools/undo.hxx>
// auto strip #endif
// auto strip #ifndef _SFXENUMITEM_HXX //autogen wg. SfxBoolItem
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif
#ifndef _SV_MSGBOX_HXX //autogen wg. QueryBox
#include <vcl/msgbox.hxx>
#endif

// auto strip #include <svtools/urihelper.hxx>
// auto strip #include <svtools/asynclink.hxx>

#pragma hdrstop

// auto strip #include "sfxresid.hxx"
// auto strip #include "fsetobsh.hxx"
// auto strip #include "shell.hxx"
// auto strip #include "msg.hxx"
// auto strip #include "msgpool.hxx"
#include "view.hrc"
// auto strip #include "mnumgr.hxx"
#include "objface.hxx"
// auto strip #include "hintpost.hxx"
// auto strip #include "request.hxx"
// auto strip #include "urlframe.hxx"
// auto strip #include "genlink.hxx"
// auto strip #include "framedlg.hxx"
// auto strip #include "dispatch.hxx"
// auto strip #include "docfile.hxx"
#include "fsetvwsh.hxx"
// auto strip #include "topfrm.hxx"
// auto strip #include "sfxtypes.hxx"
// auto strip #include "sfxbasecontroller.hxx"

//=========================================================================

DBG_NAME(SfxFrameSetViewShell)

#define SfxFrameSetViewShell
#include "so3/staticbaseurl.hxx"
namespace binfilter {
#include "sfxslots.hxx"

//=========================================================================

/*N*/ TYPEINIT1(SfxFrameSetViewShell, SfxViewShell);

//STRIP001 SFX_IMPL_INTERFACE(SfxFrameSetViewShell,SfxViewShell,SfxResId(0))
//STRIP001 {
//STRIP001 //	SFX_POPUPMENU_REGISTRATION( SfxResId( RID_FRAMESET_MENU ) );
//STRIP001 }

//=========================================================================
//STRIP001 class SfxFrameSetWindow_Impl : public SplitWindow
//STRIP001 {
//STRIP001 friend class SfxFrameSetViewShell;
//STRIP001 
//STRIP001 private:
//STRIP001 	SfxFrameSetViewShell*	pShell;
//STRIP001 	long					nDefaultSplitSize;
//STRIP001 	sal_Bool				bFirstResize;
//STRIP001 
//STRIP001 public:
//STRIP001 							SfxFrameSetWindow_Impl( SfxFrameSetViewShell* pSh,
//STRIP001 									Window *pParent, WinBits nBits = WB_3DLOOK ) :
//STRIP001 								SplitWindow( pParent, nBits | WB_NOSPLITDRAW ),
//STRIP001 								pShell( pSh ), bFirstResize( sal_True )
//STRIP001 							{
//STRIP001 								nDefaultSplitSize = GetSplitSize( 0 );
//STRIP001 							}
//STRIP001 
//STRIP001 	void					UpdateFrameSize( SfxFrameSetDescriptor* );
//STRIP001 	void					UpdateFrameSpacing( SfxFrameSetDescriptor* );
//STRIP001 	virtual void			::com::mand( const CommandEvent& rCEvt );
//STRIP001 	void					Resize();
//STRIP001 	void					DeleteEmptySets( sal_uInt16 nSet=0 );
//STRIP001 	virtual void 			KeyInput( const KeyEvent& rKeyEvent );
//STRIP001 };

//STRIP001 void SfxFrameSetWindow_Impl::KeyInput( const KeyEvent& rKeyEvent )
//STRIP001 {
//STRIP001 	if ( !pShell || !pShell->KeyInput( rKeyEvent ) )
//STRIP001 		SplitWindow::KeyInput( rKeyEvent );
//STRIP001 }

//STRIP001 struct SfxFrameSet_Impl
//STRIP001 {
//STRIP001 	sal_Bool                    bInit;
//STRIP001 	sal_Bool                    bLoading;
//STRIP001 	SfxURLFrame*                pActiveFrame;
//STRIP001     svtools::AsynchronLink      aLink;
//STRIP001 	SfxFrameSetWindow_Impl*     pWindow;
//STRIP001 	sal_uInt16                  nLoadingFrames;
//STRIP001 };

//=========================================================================

//STRIP001 class UndoAction_Impl : public SfxUndoAction
//STRIP001 {
//STRIP001 friend class SfxFrameSetViewShell;
//STRIP001 
//STRIP001 	SfxFrameSetDescriptor*	pUndo;
//STRIP001 	SfxFrameSetDescriptor*	pRedo;
//STRIP001 	SfxFrameSetViewShell*	pShell;
//STRIP001 	sal_Bool					bCloseChildren;
//STRIP001 	XubString 					aComment;
//STRIP001 
//STRIP001 public:
//STRIP001 							UndoAction_Impl( SfxFrameSetViewShell *pSh,
//STRIP001 									SfxFrameSetDescriptor *pD1,
//STRIP001 									SfxFrameSetDescriptor *pD2,
//STRIP001 									const XubString& rComment,
//STRIP001 									sal_Bool bClose = sal_False ) :
//STRIP001 								pShell( pSh ),
//STRIP001 								pUndo( pD1 ),
//STRIP001 								pRedo( pD2 ),
//STRIP001 								aComment( rComment ),
//STRIP001 								bCloseChildren( bClose )
//STRIP001 							{}
//STRIP001 
//STRIP001 							~UndoAction_Impl()
//STRIP001 							{
//STRIP001 								delete pUndo;
//STRIP001 								delete pRedo;
//STRIP001 							}
//STRIP001 
//STRIP001 	virtual void			Undo();
//STRIP001 	virtual void			Redo();
//STRIP001 	virtual UniString		GetComment() const;
//STRIP001 };

//STRIP001 UniString	UndoAction_Impl::GetComment() const
//STRIP001 {
//STRIP001 	return aComment;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void UndoAction_Impl::Undo()
//STRIP001 {
//STRIP001 	DBG_ASSERT( pUndo, "Keine Undo-Information!");
//STRIP001 	SfxViewFrame *pViewFrame = pShell->GetViewFrame();
//STRIP001 	pShell->GetSplitWindow()->SetUpdateMode( sal_False );
//STRIP001 	if ( bCloseChildren )
//STRIP001 		pViewFrame->GetFrame()->CloseChildFrames();
//STRIP001 	if ( pUndo )
//STRIP001 		pShell->ReFill( pUndo );
//STRIP001 	pShell->GetSplitWindow()->SetUpdateMode( sal_True );
//STRIP001 
//STRIP001 	SfxFrameSetObjectShell *pDoc =
//STRIP001 		PTR_CAST( SfxFrameSetObjectShell, pViewFrame->GetObjectShell() );
//STRIP001 	pShell->EndListening( *pDoc );
//STRIP001 	pDoc->TakeDescriptor( pShell->GetDescriptor_Impl() );
//STRIP001 	pShell->StartListening( *pDoc );
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void UndoAction_Impl::Redo()
//STRIP001 {
//STRIP001 	DBG_ASSERT( pRedo, "Keine Redo-Information!");
//STRIP001 	SfxViewFrame *pViewFrame = pShell->GetViewFrame();
//STRIP001 	pShell->GetSplitWindow()->SetUpdateMode( sal_False );
//STRIP001 	if ( bCloseChildren )
//STRIP001 		pViewFrame->GetFrame()->CloseChildFrames();
//STRIP001 	if ( pRedo )
//STRIP001 		pShell->ReFill( pRedo );
//STRIP001 	pShell->GetSplitWindow()->SetUpdateMode( sal_True );
//STRIP001 
//STRIP001 	SfxFrameSetObjectShell *pDoc =
//STRIP001 		PTR_CAST( SfxFrameSetObjectShell, pViewFrame->GetObjectShell() );
//STRIP001 	pShell->EndListening( *pDoc );
//STRIP001 	pDoc->TakeDescriptor( pShell->GetDescriptor_Impl() );
//STRIP001 	pShell->StartListening( *pDoc );
//STRIP001 }

//STRIP001 void SfxFrameSetWindow_Impl::DeleteEmptySets( sal_uInt16 nSet )
//STRIP001 {
//STRIP001 	for ( sal_uInt16 n=0; n<GetItemCount(nSet); )
//STRIP001 	{
//STRIP001 		sal_uInt16 nId = GetItemId( n, nSet );
//STRIP001 		if ( !GetItemWindow( nId ) )
//STRIP001 		{
//STRIP001 			if ( GetItemCount( nId ) )
//STRIP001 				DeleteEmptySets( nId );
//STRIP001 			if ( !GetItemCount( nId ) )
//STRIP001 				RemoveItem( nId );
//STRIP001 			else
//STRIP001 				n++;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			n++;
//STRIP001 	}
//STRIP001 }


//STRIP001 void SfxFrameSetWindow_Impl::Command ( const CommandEvent& rCEvt )
/* [Beschreibung]
 */
//STRIP001 {
//STRIP001 	// Nur ContextMenu
//STRIP001 	if ( rCEvt.GetCommand() != COMMAND_CONTEXTMENU )
//STRIP001 		return;
//STRIP001 
//STRIP001 	// Die ItemId des Sets holen, zu dem der Zwischenraum geh"ort, auf den
//STRIP001 	// geclickt wurde
//STRIP001 	sal_uInt16 nId = GetItemId( rCEvt.GetMousePosPixel() );
//STRIP001 	sal_uInt16 nSet = GetSet( nId );
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void SfxFrameSetWindow_Impl::UpdateFrameSize( SfxFrameSetDescriptor* pSet )
//STRIP001 {
//STRIP001 	for ( sal_uInt16 n=0; n<pSet->GetFrameCount(); n++ )
//STRIP001 	{
//STRIP001 		SfxFrameDescriptor *pD = pSet->GetFrame( n );
//STRIP001 		sal_uInt16 nItemId = pD->GetItemId();
//STRIP001 		if ( IsItemValid( nItemId ) )
//STRIP001 		{
//STRIP001 			long nSize = GetItemSize( nItemId );
//STRIP001 			pD->SetWidth( nSize );
//STRIP001 		}
//STRIP001 		if ( pD->GetFrameSet() )
//STRIP001 			UpdateFrameSize( pD->GetFrameSet() );
//STRIP001 	}
//STRIP001 }

//STRIP001 void SfxFrameSetWindow_Impl::Resize()
//STRIP001 {
//STRIP001 	SplitWindow::Resize();
//STRIP001 	if ( bFirstResize )
//STRIP001 		bFirstResize = sal_False;
//STRIP001 }


//-------------------------------------------------------------------------

//STRIP001 void SfxFrameSetWindow_Impl::UpdateFrameSpacing( SfxFrameSetDescriptor* pSet )
//STRIP001 {
//STRIP001 	sal_uInt16 nSet = 0;
//STRIP001 	if ( pSet->GetParentFrame() )
//STRIP001 		nSet = pSet->GetParentFrame()->GetItemId();
//STRIP001 
//STRIP001 	if ( nSet && !IsItemValid( nSet ) )
//STRIP001 		return;
//STRIP001 
//STRIP001 	if ( pSet->IsFrameSpacingSet() )
//STRIP001 	{
//STRIP001 		// Wenn explizit ein FrameSpacing gesetzt ist, wird es in das
//STRIP001 		// Splitwindow "ubernommen, sonst bleibt es SV "uberlassen
//STRIP001 		SetSplitSize( nSet, pSet->GetFrameSpacing(), sal_True );
//STRIP001 	}
//STRIP001 
//STRIP001 	for ( sal_uInt16 n=0; n<pSet->GetFrameCount(); n++ )
//STRIP001 	{
//STRIP001 		SfxFrameDescriptor *pD = pSet->GetFrame( n );
//STRIP001 		if ( pD->GetFrameSet() )
//STRIP001 			UpdateFrameSpacing( pD->GetFrameSet() );
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------
//STRIP001 IMPL_LINK( SfxFrameSetViewShell, SplitHdl_Impl, SfxFrameSetWindow_Impl*, pWindow )
//STRIP001 {
//STRIP001 	SfxFrameSetDescriptor *pSet = GetDescriptor_Impl();
//STRIP001 	if ( IsInEditMode() )
//STRIP001 	{
//STRIP001 		// F"ur das Undo eine Kopie des alten Descriptors ziehen
//STRIP001 		SfxFrameSetDescriptor *pUndo = pSet->Clone();
//STRIP001 
//STRIP001 		// Die Descriptoren updaten
//STRIP001 		pImp->pWindow->UpdateFrameSize( pSet );
//STRIP001 
//STRIP001 		// Die "Anderungen an das Dokument weitergeben
//STRIP001 		SfxFrameSetObjectShell *pDoc =
//STRIP001 			PTR_CAST( SfxFrameSetObjectShell, GetViewFrame()->GetObjectShell() );
//STRIP001 		EndListening( *pDoc );
//STRIP001 		pDoc->TakeDescriptor( pSet );
//STRIP001 		StartListening( *pDoc );
//STRIP001 
//STRIP001 		// F"ur das Redo eine Kopie des neuen Descriptors ziehen
//STRIP001 		GetUndoManager()->AddUndoAction( new UndoAction_Impl( this,
//STRIP001 					pUndo, pSet->Clone(), String( SfxResId( STR_FRAMESIZE ) ) ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pImp->pWindow->UpdateFrameSize( pSet );
//STRIP001 
//STRIP001 	return 1L;
//STRIP001 }

//STRIP001 void SfxFrameSetViewShell::UpdateFrameBorder( SfxFrameSetDescriptor* pSet )
//STRIP001 {
//STRIP001 	sal_uInt16 nSet = 0;
//STRIP001 	if ( pSet->GetParentFrame() )
//STRIP001 		nSet = pSet->GetParentFrame()->GetItemId();
//STRIP001 
//STRIP001 	if ( nSet && !pImp->pWindow->IsItemValid( nSet ) )
//STRIP001 		return;
//STRIP001 
//STRIP001 	for ( sal_uInt16 n=0; n<pSet->GetFrameCount(); n++ )
//STRIP001 	{
//STRIP001 		SfxFrameDescriptor *pD = pSet->GetFrame( n );
//STRIP001 		SfxFrameSetDescriptor *pSubSet = pD->GetFrameSet();
//STRIP001 
//STRIP001 		if ( !pSubSet || pSubSet->IsRootFrameSet() )
//STRIP001 		{
//STRIP001 			SfxURLFrame* pURL = PTR_CAST( SfxURLFrame,
//STRIP001 				GetViewFrame()->GetFrame()->SearchFrame_Impl( pD->GetItemId(), sal_True ) );
//STRIP001 			pURL->Update();
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( pD->GetFrameSet() )
//STRIP001 			UpdateFrameBorder( pD->GetFrameSet() );
//STRIP001 	}
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void SfxFrameSetViewShell::Construct()
//STRIP001 {
//STRIP001 	StartListening( *SFX_APP() );
//STRIP001 	SfxViewFrame *pViewFrame = GetViewFrame();
//STRIP001 	SfxFrame *pFrame = pViewFrame->GetFrame();
//STRIP001 
//STRIP001 	pViewFrame->UpdateTitle( );
//STRIP001 	DBG_ASSERT( !pViewFrame->GetActiveChildFrame_Impl(), "Constructing FrameSetView in Frame with active child!" );
//STRIP001 
//STRIP001 	// Am FrameSetDokument horchen
//STRIP001 	SfxFrameSetObjectShell *pObj = PTR_CAST( SfxFrameSetObjectShell,
//STRIP001 									pViewFrame->GetObjectShell());
//STRIP001 	DBG_ASSERT( pObj, "Falsche ObjectShell!");
//STRIP001 	StartListening( *pObj );
//STRIP001 
//STRIP001 	SFX_ITEMSET_ARG( pObj->GetMedium()->GetItemSet(), pDescrItem,
//STRIP001 					 SfxFrameDescriptorItem, SID_FRAMEDESCRIPTOR, sal_False);
//STRIP001 
//STRIP001 	if ( IsImplementedAsFrameset_Impl() ) pDescrItem = 0;
//STRIP001 
//STRIP001 	// Das SplitWindow als EditWindow erzeugen bzw. vom Parent holen
//STRIP001 	pImp = new SfxFrameSet_Impl;
//STRIP001 	pImp->pActiveFrame = NULL;
//STRIP001 
//STRIP001 	pImp->nLoadingFrames = 0;
//STRIP001 	pImp->bInit = sal_False;
//STRIP001 	pImp->bLoading = sal_True;
//STRIP001 
//STRIP001 	if ( pFrame->IsTop() || !GetParentFrameSet() )
//STRIP001 	{
//STRIP001 		// TopFrame oder FloatingFrame
//STRIP001 		pImp->pWindow = new SfxFrameSetWindow_Impl( this, &pViewFrame->GetWindow() );
//STRIP001 		SetWindow( pImp->pWindow );
//STRIP001 		pImp->pWindow->SetSplitHdl( LINK( this, SfxFrameSetViewShell, SplitHdl_Impl ) );
//STRIP001 
//STRIP001 		// Event anmelden zum asynchronen Nachladen der Dokumente in den Frames
//STRIP001 		// ( Zuerst mu\s die ::com::sun::star::sdbcx::View vollst"andig konstruiert werden )
//STRIP001 		pImp->aLink = LINK( this, SfxFrameSetViewShell, EventHdl_Impl );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Parent des ViewFrames mu\s ein ::com::sun::star::util::URL-Frame sein
//STRIP001 		SfxFrameSetViewShell *pShell = GetParentFrameSet();
//STRIP001 		while ( !pShell->GetWindow() )
//STRIP001 			pShell = pShell->GetParentFrameSet();
//STRIP001 		pImp->pWindow = pShell->pImp->pWindow;
//STRIP001 		pImp->aLink = LINK( this, SfxFrameSetViewShell, EventHdl_Impl );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Zuerst nachsehen, ob der FrameSetDescriptor des Dokuments oder ein
//STRIP001 	// anderer genommen werden soll, der in BrowseForward/Backward gesetzt wurde
//STRIP001 	SfxFrameDescriptor *pFrm = NULL;
//STRIP001 	if( pDescrItem )
//STRIP001 		pFrm = pDescrItem->GetProperties().pFrame;
//STRIP001 	sal_Bool bReFill = ( pFrm != NULL && pFrm->GetFrameSet() != NULL );
//STRIP001 
//STRIP001 	// Eventuell ist ein Reload mit ReFill angefordert worden. Der kann nur genommen
//STRIP001 	// werden, sofern sich die Struktur der Seite nicht ge"andert hat
//STRIP001 	SfxFrame *pTopFrame = pFrame->GetTopFrame();
//STRIP001 	sal_Bool bReload = pTopFrame->GetCurrentDocument()->IsReloading();
//STRIP001 
//STRIP001 	// Anmerkung: wenn die FrameSetObjectShell auch auf FrameDescriptor statt
//STRIP001 	// FrameSetDescriptor umgestellt ist, kann das in CompareOriginal einbezogen
//STRIP001 	// werden
//STRIP001 	if ( bReload && bReFill && pFrame == pTopFrame &&
//STRIP001 		pTopFrame->GetDescriptor()->GetURL() != pFrm->GetURL() )
//STRIP001 		// AutoReload mit neuer ::com::sun::star::util::URL
//STRIP001 		bReFill = sal_False;
//STRIP001 
//STRIP001 	if ( bReFill &&
//STRIP001 		!pObj->GetFrameSetDescriptor()->CompareOriginal(*pFrm->GetFrameSet() ) )
//STRIP001 		// Struktur ver"andert
//STRIP001 		bReFill = sal_False;
//STRIP001 
//STRIP001 	if( !bReFill )
//STRIP001 	{
//STRIP001 		// Kein gesetzter oder nicht mehr g"ultiger Descriptor; Description
//STRIP001 		// von der DocShell abkopieren
//STRIP001 		if ( pFrm && pFrm->GetFrameSet() )
//STRIP001 			delete pFrm->GetFrameSet();
//STRIP001 		pFrm = pFrame->GetDescriptor();
//STRIP001 		pObj->GetFrameSetDescriptor()->Clone( pFrm );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		DBG_ASSERT( pFrm->GetFrameSet(), "Descriptor ohne Framset !" );
//STRIP001 		pFrm = pFrm->Clone();
//STRIP001 
//STRIP001 		// Den Frame mit dem richtigen Descriptor versehen
//STRIP001 		pFrame->SetDescriptor( pFrm );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Eigenen Pointer zum schnellen Zugriff merken
//STRIP001 	pDescriptor = pFrm->GetFrameSet();
//STRIP001 
//STRIP001 	// Das FrameSet asynchron aufbauen; sonst funzt die ExplorerViewShell nicht
//STRIP001 	pImp->aLink.Call( this );
//STRIP001 	SetUndoManager( new SfxUndoManager() );
//STRIP001 	pObj->GetMedium()->GetItemSet()->ClearItem( SID_FRAMEDESCRIPTOR );
//STRIP001 
//STRIP001 	SFX_ITEMSET_ARG( pObj->GetMedium()->GetItemSet(),
//STRIP001 				pItem, SfxBoolItem, SID_TEMPLATE, sal_False );
//STRIP001 	if ( pItem && pItem->GetValue() && GetWindow() && !IsImplementedAsFrameset_Impl() )
//STRIP001 		SetEditMode( sal_True );
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SfxFrameSetViewShell, EventHdl_Impl, void*, pVoid )
/*	[Beschreibung]
	Event-Handler, "uber den das FrameSet im SplitWindow initial erzeugt
	wird.
*/
//STRIP001 {
//STRIP001 	// Vor dem ersten Resize Frameset nicht aufbauen, da sonst der gr"o\ste
//STRIP001 	// Frame nicht ermittelt werden kann
//STRIP001 	if ( pImp->pWindow->bFirstResize &&
//STRIP001 		 GetViewFrame()->GetFrame()->GetTopFrame()->
//STRIP001 		 GetCurrentViewFrame()->IsVisible() )
//STRIP001 	{
//STRIP001 		pImp->aLink.Call( this,sal_False,sal_True );
//STRIP001 		return 0L;
//STRIP001 	}
//STRIP001 
//STRIP001 	pImp->bInit = sal_True;
//STRIP001 	Fill( pDescriptor );
//STRIP001 
//STRIP001 	if ( !pImp->nLoadingFrames )
//STRIP001 	{
//STRIP001 		pImp->bLoading = sal_False;
//STRIP001 		GetObjectShell()->FinishedLoading();
//STRIP001 		GetViewFrame()->GetDispatcher()->Execute( SID_EDIT_FRAMESET );
//STRIP001 
//STRIP001 		// Wenn ich selbst in einem Frameset sitze, wurde dort das LoadFinished bisher
//STRIP001 		// unterdr"uckt; also jetzt erneut senden
//STRIP001 		SfxURLFrame *pURL = PTR_CAST( SfxURLFrame, GetViewFrame()->GetFrame()->GetParentFrame() );
//STRIP001 		if ( pURL )
//STRIP001 			pURL->LoadFinished_Impl();
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void SfxFrameSetViewShell::ReFill( const SfxFrameSetDescriptor *pSet )
/*	[Beschreibung]
	Diese Methode baut das FrameSet im SplitWindow anhand des
	"ubergebenen FrameSetDescriptors neu auf, indem es das SplitWindow
	leert und dann wieder neu f"ullt.
	Aus Performance-Gr"unden wird nur das Splitwindow geleert, die Frames
	aber nicht sofort geclosed, um sie gleich wieder ins Splitwindow einf"ugen
	zu k"onnen, ohne die Dokumente neu laden zu m"ussen.
*/
//STRIP001 {
//STRIP001 	SfxFrame *pFrame = GetViewFrame()->GetFrame();
//STRIP001 	SfxFrameDescriptor *pFrm = pFrame->GetDescriptor();
//STRIP001 
//STRIP001 	// Den FrameSet-Descriptor bis zum Ende retten
//STRIP001 	SfxFrameSetDescriptor *pOld = pDescriptor;
//STRIP001 	if ( pOld != pSet )
//STRIP001 	{
//STRIP001 		pFrm->SetFrameSet( NULL );
//STRIP001 		pDescriptor = pSet->Clone( pFrm );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Alle Frames erst einmal invalidieren
//STRIP001 	SfxFrameIterator aIter( *pFrame, sal_True );
//STRIP001 	SfxFrame *pChild = aIter.FirstFrame();
//STRIP001 	while ( pChild )
//STRIP001 	{
//STRIP001 		SfxFrame *pNext = aIter.NextFrame( *pChild );
//STRIP001 		((SfxURLFrame*)pChild)->SetValidItem_Impl( sal_False );
//STRIP001 		pChild = pNext;
//STRIP001 	}
//STRIP001 
//STRIP001 	Fill( pDescriptor );
//STRIP001 
//STRIP001 	// Alle URLFrames, die nicht mehr im Frameset vertreten sind, k"onnen
//STRIP001 	// jetzt abger"aumt werden
//STRIP001 	pChild = aIter.FirstFrame();
//STRIP001 	while ( pChild )
//STRIP001 	{
//STRIP001 		SfxFrame *pNext = aIter.NextFrame( *pChild );
//STRIP001 		if ( !((SfxURLFrame*)pChild)->IsValidItem_Impl() )
//STRIP001 		{
//STRIP001 			// Vorsicht: wenn pNext ein Kind von pChild ist, mu\s erst
//STRIP001 			// das nachfolgende Geschwister von pChild als pNext geholt werden
//STRIP001 			while ( pNext && pNext->IsParent( pChild ) )
//STRIP001 				pNext = aIter.NextFrame( *pNext );
//STRIP001 			pChild->DoClose();
//STRIP001 		}
//STRIP001 		pChild = pNext;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Jetzt noch eventuell vorhandene leere Framesets abr"aumen
//STRIP001 	pImp->pWindow->DeleteEmptySets();
//STRIP001 
//STRIP001 	// Jetzt pOld l"oschen, alle Frames sind jetzt frei
//STRIP001 	if ( pOld != pDescriptor )
//STRIP001 		delete pOld;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void SfxFrameSetViewShell::Fill( const SfxFrameSetDescriptor* pSet )
/*	[Beschreibung]
	Mit dieser Methode wird das FrameSet im SplitWindow anhand des
	"ubergebenen FrameSetDescriptors gef"ullt.
*/
//STRIP001 {
//STRIP001 	// kein Event mehr empfangen
//STRIP001 	pImp->aLink.ClearPendingCall();
//STRIP001 	SfxFrameSetWindow_Impl *pWindow = pImp->pWindow;
//STRIP001 	pWindow->SetUpdateMode( sal_False );
//STRIP001 
//STRIP001 	// Das FrameSet aufbauen
//STRIP001 	SfxFrame *pFrame = GetViewFrame()->GetFrame();
//STRIP001 	sal_uInt16 nId = pSet->GetParentFrame() ? pSet->GetParentFrame()->GetItemId() : 0;
//STRIP001 
//STRIP001 	DBG_ASSERT( !nId || pWindow->IsItemValid( nId ), "SplitwindowItem existiert nicht!" );
//STRIP001 
//STRIP001 	DockingWindow* pDock = (DockingWindow*)pWindow->GetItemWindow( nId );
//STRIP001 	if ( nId )
//STRIP001 	{
//STRIP001 		if ( pWindow->IsItemValid( nId ) )
//STRIP001 			//Es gibt noch ein Item, das durch das neue Set ersetzt werden soll
//STRIP001 			UpdateFrame_Impl( PTR_CAST( SfxURLFrame, pFrame ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		WindowAlign eAlign = WINDOWALIGN_LEFT;
//STRIP001 		if ( !pDescriptor->IsColSet() )
//STRIP001 			eAlign = WINDOWALIGN_TOP;
//STRIP001 		pWindow->SetAlign( eAlign );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pSet->GetWallpaper() )
//STRIP001 		pWindow->SetItemBackground( nId, *pSet->GetWallpaper() );
//STRIP001 
//STRIP001 	MakeWindows( pSet, pFrame, nId );
//STRIP001 	pWindow->SetUpdateMode( sal_True );
//STRIP001 	if ( pDock )
//STRIP001 		pDock->Hide();
//STRIP001 
//STRIP001 	SfxFrameSetViewShell *pFrameSet = this;
//STRIP001 	while ( !pFrameSet->GetWindow() )
//STRIP001 		pFrameSet = pFrameSet->GetParentFrameSet();
//STRIP001 	if ( !pFrameSet->IsInEditMode() )
//STRIP001 	{
//STRIP001 		if ( !pFrameSet->GetActiveFrame() || pFrameSet->GetActiveFrame() == pFrame )
//STRIP001 		{
//STRIP001 			SfxFrameIterator aIter( *pFrame, sal_False );
//STRIP001 			SfxFrame *pChild = aIter.FirstFrame();
//STRIP001 			SfxFrame *pAktFrame = NULL;
//STRIP001 			long aMaxArea=0L;
//STRIP001 			Size aSize( pWindow->GetOutputSizePixel() );
//STRIP001 			long nSplitHeight = pWindow->GetAlign() == WINDOWALIGN_LEFT ? aSize.Height() : aSize.Width();
//STRIP001 			while ( pChild )
//STRIP001 			{
//STRIP001 				SfxFrame *pNext = aIter.NextFrame( *pChild );
//STRIP001 				sal_uInt16 nItemId = pChild->GetFrameId_Impl();
//STRIP001 				long nWidth = pWindow->GetItemSize( nItemId, 0 );
//STRIP001 				sal_uInt16 nSet = pWindow->GetSet( nItemId );
//STRIP001 				long nHeight = nSet ? pWindow->GetItemSize( nSet, 0 ) : nSplitHeight;
//STRIP001 				long aArea = nWidth * nHeight;
//STRIP001 				if ( aArea > aMaxArea )
//STRIP001 				{
//STRIP001 					aMaxArea = aArea;
//STRIP001 					pAktFrame = pChild;
//STRIP001 				}
//STRIP001 
//STRIP001 				pChild = pNext;
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( pAktFrame )
//STRIP001 				pFrameSet->SetActiveFrame( (SfxURLFrame*) pAktFrame );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Alle neuen Mitglieder begr"us\sen ...
//STRIP001 	SfxFrameIterator aIter( *pFrame, sal_False );
//STRIP001 	SfxFrame *pChild = aIter.FirstFrame();
//STRIP001 	while ( pChild )
//STRIP001 	{
//STRIP001 		SfxFrame *pNext = aIter.NextFrame( *pChild );
//STRIP001 		if ( pImp->pWindow->IsItemValid( pChild->GetFrameId_Impl() ) )
//STRIP001 			pChild->GetWindow().Update();
//STRIP001 		pChild = pNext;
//STRIP001 	}
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void SfxFrameSetViewShell::MakeWindows( const SfxFrameSetDescriptor *pSet,
//STRIP001 					SfxFrame *pParent,
//STRIP001 					sal_uInt16 nSet )
//STRIP001 
/*	[Beschreibung]

	Mit dieser Methode wird aus einem FrameSetDescriptor ein ItemSet in
	einem SplitWindow gef"ullt ( nSet = 0 ist das RootSet ).
	F"ur jeden FrameDescriptor im FrameSetDescriptor wird ein SfxURLFrame
	mit gleicher ItemId erzeugt, sofern ein SfxURLFrame der gleichen ItemId
	nicht schon vorhanden ist, weil MakeWindows nicht zum Neuaufbau des
	FrameSets, sondern zum Update mit einem ver"anderten FrameSetDescriptor
	aufgerufen wurde.
	SfxURLFrames mit Descriptoren, die wieder ein FrameSet enthalten, f"ugen
	ein ItemSet in das SplitWindow ein, solche ohne FrameSet ein ItemWindow.
*/
//STRIP001 {
//STRIP001 	DBG_CHKTHIS(SfxFrameSetViewShell,0);
//STRIP001 	sal_uInt16 nActSet = nSet;
//STRIP001 	SfxFrame *pFrame = GetViewFrame()->GetFrame();
//STRIP001 	SfxFrameSetWindow_Impl *pWindow = pImp->pWindow;
//STRIP001 	SfxFrameSetViewShell *pFrameSet = this;
//STRIP001 	while ( !pFrameSet->GetWindow() )
//STRIP001 		pFrameSet = pFrameSet->GetParentFrameSet();
//STRIP001 
//STRIP001 	if ( pSet->IsFrameSpacingSet() )
//STRIP001 	{
//STRIP001 		// Wenn explizit ein FrameSpacing gesetzt ist, wird es in das
//STRIP001 		// Splitwindow "ubernommen, sonst bleibt es SV "uberlassen
//STRIP001 		pWindow->SetSplitSize( nSet, pSet->GetFrameSpacing(), sal_True );
//STRIP001 	}
//STRIP001 
//STRIP001 	// F"ur jeden SfxFrameSetDescriptor wird im Splitwindow ein neues
//STRIP001 	// ItemSet angelegt (Ausnahme: das Root-ItemSet existiert schon).
//STRIP001 	for ( sal_uInt16 nWindowPos=0, nFrame=0; nFrame<pSet->GetFrameCount(); nFrame++ )
//STRIP001 	{
//STRIP001 		SfxFrameDescriptor* pFD = pSet->GetFrame( nFrame );
//STRIP001 		long nWidth = pFD->GetSize();
//STRIP001 
//STRIP001 		SfxURLFrame *pURLFrame = NULL;
//STRIP001 		sal_uInt16 n = pFD->GetItemId();
//STRIP001 		if ( !n )
//STRIP001 		{
//STRIP001 			n = pDescriptor->MakeItemId();
//STRIP001 			pFD->SetItemId( n );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// Der Descriptor hat schon eine ID; wenn es einen Frame
//STRIP001 			// mit dieser ID gibt, soll der genommen werden
//STRIP001 			pURLFrame = (SfxURLFrame*) pParent->SearchFrame_Impl( n );
//STRIP001 			if ( pURLFrame )
//STRIP001 				pURLFrame->SetValidItem_Impl( sal_True );
//STRIP001 		}
//STRIP001 /*
//STRIP001 		if ( !nWidth && pWindow->IsItemValid( n ) )
//STRIP001 		{
//STRIP001 			// Frames mit Breite 0 werden nicht eingef"ugt, auch wenn es
//STRIP001 			// den URLFrame daf"ur geben mu\s ( wg. ::com::sun::star::script::JavaScript )
//STRIP001 			pWindow->RemoveItem( n );
//STRIP001 		}
//STRIP001 */
//STRIP001 		// ItemBits; im Editmode ist Gr"o\sen"anderung immer erlaubt
//STRIP001 		sal_uInt16 nBits = pFD->GetWinBits();
//STRIP001 		if ( IsInEditMode() )
//STRIP001 			nBits = nBits & ~SWIB_FIXED;
//STRIP001 
//STRIP001 		if ( pFD->GetFrameSet() && !pFD->GetFrameSet()->IsRootFrameSet() )
//STRIP001 		{
//STRIP001 			// Es wird ein Sub-FrameSet eingef"ugt (direkte Rekursion)
//STRIP001 			// ItemSet einf"ugen und mit dem ChildFrameSet weitermachen
//STRIP001 			if ( pURLFrame )
//STRIP001 			{
//STRIP001 				// Zuletzt war dieses Item kein Set, sondern ein Window
//STRIP001 				// eines Frames. Der Frame wird anschlie\end bseitigt.
//STRIP001 				pWindow->RemoveItem( n );
//STRIP001 				pURLFrame->SetValidItem_Impl( sal_False );
//STRIP001 				pURLFrame->SetFrameId_Impl( USHRT_MAX );
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( pWindow->IsItemValid( n ) )
//STRIP001 			{
//STRIP001 				if ( pWindow->GetSet( n ) != nActSet ||
//STRIP001 						pWindow->GetItemPos( n, nActSet ) != nWindowPos )
//STRIP001 				{
//STRIP001 					// Es gibt schon ein ItemSet mit dieser Id im SplitWindow;
//STRIP001 					// allerdings ist das ParentSet ein anderes, oder die
//STRIP001 					// Position im Set hat sich ge"andert
//STRIP001 					pWindow->MoveItem( n, nWindowPos, nActSet );
//STRIP001 				}
//STRIP001 
//STRIP001 				pWindow->SetItemBits( n, nBits );
//STRIP001 				pWindow->SetItemSize( n, nWidth );
//STRIP001 				nWindowPos++;
//STRIP001 			}
//STRIP001 			else // if ( nWidth )
//STRIP001 			{
//STRIP001 				// Item neu einf"ugen
//STRIP001 				pWindow->InsertItem( n, nWidth, nWindowPos++,
//STRIP001 					nActSet, nBits );
//STRIP001 			}
//STRIP001 
//STRIP001 //			if ( nWidth )
//STRIP001 			{
//STRIP001 				if ( pFD->GetFrameSet()->GetWallpaper() )
//STRIP001 					pWindow->SetItemBackground( n, *pFD->GetFrameSet()->GetWallpaper() );
//STRIP001 				MakeWindows( pFD->GetFrameSet(), pParent, n );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if ( !pURLFrame || pURLFrame->GetParentFrame() != pParent )
//STRIP001 		{
//STRIP001 			// Der gesuchte Frame existiert noch nicht; es wird daher
//STRIP001 			// zun"achst ein Item neu erzeugt; falls es sich dabei um
//STRIP001 			// ein FrameSetDocument handelt, baut der URLFrame beim
//STRIP001 			// Laden den Rest des FrameSets auf (->UpdateFrame).
//STRIP001 			if ( pWindow->IsItemValid( n ) )
//STRIP001 				pWindow->RemoveItem( n );
//STRIP001 			if ( pURLFrame )
//STRIP001 			{
//STRIP001 				pURLFrame->SetValidItem_Impl( sal_False );
//STRIP001 				pURLFrame->SetFrameId_Impl( USHRT_MAX );
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( pImp->bLoading && pFD->GetActualURL().GetMainURL( INetURLObject::NO_DECODE ).Len() )
//STRIP001 				pImp->nLoadingFrames++;
//STRIP001 
//STRIP001 //            pURLFrame = new SfxURLFrame( pFD, pFrameSet, pParent );
//STRIP001 //			if ( nWidth )
//STRIP001 			{
//STRIP001 				if( !pWindow->IsItemValid( n ) )
//STRIP001 					pWindow->InsertItem( n, pURLFrame->GetDockingWindow(),
//STRIP001 						nWidth, nWindowPos, nActSet, nBits );
//STRIP001 				nWindowPos++;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// Den gesuchten Frame gibt es schon, aktuelle
//STRIP001 			// Properties "ubernehmen
//STRIP001 			if ( pWindow->IsItemValid( n ) )
//STRIP001 			{
//STRIP001 				// Es gibt schon ein ItemSet mit dieser Id im SplitWindow;
//STRIP001 				// allerdings ist das ParentSet ein anderes, oder die
//STRIP001 				// Position im Set hat sich ge"andert
//STRIP001 				if ( pWindow->GetSet( n ) != nActSet ||
//STRIP001 						pWindow->GetItemPos( n, nActSet ) != nWindowPos )
//STRIP001 						pWindow->MoveItem( n, nWindowPos, nActSet);
//STRIP001 			}
//STRIP001 
//STRIP001 			// Parameter "ubernehmen
//STRIP001 			pURLFrame->Update( pFD );
//STRIP001 			if ( pURLFrame->GetCurrentViewFrame() )
//STRIP001 			{
//STRIP001 				// Da ist schon ein Dokument geladen!
//STRIP001 				SfxFrameSetViewShell *pFrameSet =
//STRIP001 					PTR_CAST( SfxFrameSetViewShell,
//STRIP001 					pURLFrame->GetCurrentViewFrame()->GetViewShell() );
//STRIP001 
//STRIP001 				// Der FrameSetDescriptor-Pointer an der FrameSetViewShell mu\s
//STRIP001 				// gepflegt werden!
//STRIP001 				if ( pFrameSet )
//STRIP001 					pFrameSet->pDescriptor = pFD->GetFrameSet();
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( pFD->GetFrameSet() && pURLFrame->GetChildFrameCount() )
//STRIP001 			{
//STRIP001 				// Es ist ein Root-FrameSet, also ein FrameSetDocument,
//STRIP001 				// und es ist schon geladen. Also mu\s nur das ItemSet
//STRIP001 				// eingef"ugt und mit dem ChildFrameSet weiter gemacht
//STRIP001 				// werden.
//STRIP001 				if ( !pWindow->IsItemValid( n ) )
//STRIP001 				{
//STRIP001 //					if ( nWidth )
//STRIP001 						pWindow->InsertItem( n, nWidth, nWindowPos++,
//STRIP001 							nActSet, nBits );
//STRIP001 				}
//STRIP001 				else
//STRIP001 					nWindowPos++;
//STRIP001 
//STRIP001 				if ( pFD->GetFrameSet()->GetWallpaper() )
//STRIP001 					pWindow->SetItemBackground( n, *pFD->GetFrameSet()->GetWallpaper() );
//STRIP001 //				if ( nWidth )
//STRIP001 					MakeWindows( pFD->GetFrameSet(), pURLFrame, n );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// Descriptor enth"alt kein FrameSet oder ein noch nicht
//STRIP001 				// geladenes FrameSetDocument; erst mal ein neues Item
//STRIP001 				// einf"ugem; falls es ein FrameSetDocument ist, baut der
//STRIP001 				// URLFrame beim Laden den Rest des FrameSets auf.
//STRIP001 				if ( pWindow->IsItemValid( n ) && !pWindow->GetItemWindow( n ) )
//STRIP001 					pWindow->RemoveItem( n );
//STRIP001 
//STRIP001 				if ( !pWindow->IsItemValid( n ) )
//STRIP001 				{
//STRIP001 //					if ( nWidth )
//STRIP001 						pWindow->InsertItem( n, pURLFrame->GetDockingWindow(),
//STRIP001 							nWidth, nWindowPos++, nActSet, nBits );
//STRIP001 				}
//STRIP001 				else
//STRIP001 					nWindowPos++;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------

//STRIP001 void SfxFrameSetViewShell::SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
//STRIP001 					   const SfxHint& rHint, const TypeId& rHintType )
//STRIP001 {
//STRIP001 }

//------------------------------------------------------------------

/*N*/ SfxFrameSetViewShell::SfxFrameSetViewShell(
/*N*/ 	SfxViewFrame *pFrame, const SfxFrameSetViewShell& rWin, sal_uInt16 nFlags ):
/*N*/ 	SfxViewShell( pFrame, nFlags ),
/*N*/ 	bEditMode( sal_False ),
/*N*/ 	pImp( NULL ),
/*N*/ 	pDescriptor( NULL )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	DBG_CTOR(SfxFrameSetViewShell, 0);
//STRIP001 	Construct();
/*N*/ }

//------------------------------------------------------------------

/*N*/ SfxFrameSetViewShell::SfxFrameSetViewShell(
/*N*/ 	SfxViewFrame *pFrame, SfxViewShell*, sal_uInt16 nFlags ):
/*N*/ 	SfxViewShell( pFrame, nFlags ),
/*N*/ 	bEditMode( sal_False ),
/*N*/ 	pDescriptor( NULL )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	DBG_CTOR(SfxFrameSetViewShell, 0);
//STRIP001 	Construct();
/*N*/ }
//------------------------------------------------------------------

/*N*/ SfxFrameSetViewShell::~SfxFrameSetViewShell()
/*N*/ {
/*N*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 DBG_DTOR(SfxFrameSetViewShell, 0);
//STRIP001 
//STRIP001 	// kein Event mehr empfangen
//STRIP001 	pImp->aLink.ClearPendingCall();
//STRIP001 	Window *pWindow = GetWindow();
//STRIP001 	if ( pWindow )
//STRIP001 		pWindow->Hide();
//STRIP001 
//STRIP001 	// Sofern nicht der ViewFrame selbst geclosed wurde, m"ussen noch die
//STRIP001 	// ChildFrames abger"aumt werden
//STRIP001 	SfxFrame *pFrame = GetViewFrame()->GetFrame();
//STRIP001 	pFrame->CloseChildFrames();
//STRIP001 	SetWindow( NULL );
//STRIP001 
//STRIP001 	delete pWindow;
//STRIP001 	delete pDescriptor;
//STRIP001 	delete GetUndoManager();
//STRIP001 	delete pImp;
/*N*/ }

//------------------------------------------------------------------

//STRIP001 void SfxFrameSetViewShell::OuterResizePixel( const Point &rOfs, const Size &rSize )
//STRIP001 {
//STRIP001 	// Das FrameSet ist das Fenster
//STRIP001 	SetBorderPixel( SvBorder() );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void SfxFrameSetViewShell::InnerResizePixel( const Point &rOfs, const Size &rSize )
//STRIP001 {
//STRIP001 	// Das FrameSet ist das Fenster
//STRIP001 	SetBorderPixel( SvBorder() );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void SfxFrameSetViewShell::Activate( sal_Bool bMDI )
//STRIP001 {
//STRIP001 	SfxViewShell::Activate( bMDI );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 SplitWindow* SfxFrameSetViewShell::GetSplitWindow() const
//STRIP001 {
//STRIP001 	DBG_CHKTHIS(SfxFrameSetViewShell,0);
//STRIP001 	return GetWindow() ? pImp->pWindow : NULL;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void SfxFrameSetViewShell::UpdateFrame_Impl( SfxURLFrame *pURLFrame )
/*	[Beschreibung]

	Diese Methode ersetzt ein ItemWindow oder ItemSet durch ein
	anderes ItemWindow oder ItemSet, wenn sich der Inhalt eines URLFrames
	entsprechend ge"andert hat.
 */
//STRIP001 {
//STRIP001 	DBG_CHKTHIS(SfxFrameSetViewShell,0);
//STRIP001 
//STRIP001 	SfxFrameSetWindow_Impl *pWindow = pImp->pWindow;
//STRIP001 	sal_uInt16 nId = pURLFrame->GetFrameId_Impl();
//STRIP001 	DockingWindow *pDockWin = (DockingWindow*)pWindow->GetItemWindow( nId );
//STRIP001 	SfxFrameDescriptor *pFD = pURLFrame->GetDescriptor();
//STRIP001 
//STRIP001 	// Erst mal das alte Item rausholen; die Id bleibt erhalten
//STRIP001 	sal_Bool bUpdateMode = pWindow->IsUpdateMode();
//STRIP001 	if ( bUpdateMode )
//STRIP001 		pWindow->SetUpdateMode( sal_False );
//STRIP001 
//STRIP001 	// Daten abholen; Width mu\s vom Descriptor kommen, da GetItemSize nur den
//STRIP001 	// momentanen absoluten Wert liefert
//STRIP001 	DBG_ASSERT( pWindow->IsItemValid ( nId ), "Update auf ungueltiges Item");
//STRIP001 
//STRIP001 	// Attribute
//STRIP001 	sal_uInt16 nActSet = pWindow->GetSet( nId );
//STRIP001 	sal_uInt16 nPos = pWindow->GetItemPos( nId, nActSet );
//STRIP001 	long nWidth = pFD->GetSize();
//STRIP001 	sal_uInt16 nBits = pWindow->GetItemBits( nId );
//STRIP001 	nBits &= (~SWIB_COLSET);
//STRIP001 
//STRIP001 	// Altes evtl. Item entfernen, Window ( falls vorhanden ) noch nicht hiden
//STRIP001 	sal_Bool bWasFrameSet = !pWindow->GetItemWindow( nId );
//STRIP001 	sal_Bool bIsFrameSet = pFD->GetFrameSet() != NULL;
//STRIP001 
//STRIP001 	if ( bWasFrameSet != bIsFrameSet )
//STRIP001 		pWindow->RemoveItem( nId, sal_False );
//STRIP001 
//STRIP001 	DBG_ASSERT( !pFD->GetItemId() || pFD->GetItemId() == nId, "Falsche Id!" );
//STRIP001 	if ( pFD->GetFrameSet() )
//STRIP001 	{
//STRIP001 		// Das neue Item wird ein Set; es wird sp"ater aufgebaut
//STRIP001 		if ( pFD->GetFrameSet()->IsColSet() )
//STRIP001 			nBits |= SWIB_COLSET;
//STRIP001 		if ( pWindow->IsItemValid( nId ) )
//STRIP001 		{
//STRIP001 			pWindow->SetItemBits( nId, nBits );
//STRIP001 			pWindow->SetItemSize( nId, nWidth );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pWindow->InsertItem( nId, nWidth, nPos,	nActSet, nBits );
//STRIP001 
//STRIP001 		if ( pFD->GetFrameSet()->GetWallpaper() )
//STRIP001 			pWindow->SetItemBackground( nId, *pFD->GetFrameSet()->GetWallpaper() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Das neue Item ist kein Set
//STRIP001 		if ( pWindow->IsItemValid( nId ) )
//STRIP001 		{
//STRIP001 			pWindow->SetItemBits( nId, nBits );
//STRIP001 			pWindow->SetItemSize( nId, nWidth );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pWindow->InsertItem( nId, pURLFrame->GetDockingWindow(), nWidth,
//STRIP001 					nPos, nActSet, nBits );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pDockWin )
//STRIP001 	{
//STRIP001 		DockingWindow* pDock = (DockingWindow*)pWindow->GetItemWindow( nId );
//STRIP001 		if ( pDockWin != pDock )
//STRIP001 		{
//STRIP001 			// Jetzt ggf. altes ItemWindow hiden
//STRIP001 //			if ( bUpdateMode && pDockWin )
//STRIP001 //				pDockWin->Hide();
//STRIP001 #ifndef MAC
//STRIP001 			if ( pDock )
//STRIP001 				pDock->Update();
//STRIP001 #endif
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 //	if ( !nWidth )
//STRIP001 //		pWindow->RemoveItem( nId );
//STRIP001 
//STRIP001 	if ( bUpdateMode )
//STRIP001 		pWindow->SetUpdateMode( sal_True );
//STRIP001 }

//STRIP001 void SfxFrameSetViewShell::SetActiveFrame( SfxFrame *p )
//STRIP001 {
//STRIP001 	SfxURLFrame *pFrame = PTR_CAST(SfxURLFrame, p );
//STRIP001 	SfxURLFrame*& rpFrame = pImp->pActiveFrame;
//STRIP001 	if ( rpFrame != pFrame )
//STRIP001 	{
//STRIP001 		if ( rpFrame )
//STRIP001 			rpFrame->SetActive( sal_False );
//STRIP001 		if ( pFrame )
//STRIP001 			pFrame->SetActive( sal_True );
//STRIP001 		rpFrame = pFrame;
//STRIP001 	}
//STRIP001 
//STRIP001 	SfxBindings& rBindings = GetViewFrame()->GetBindings();
//STRIP001 	rBindings.Invalidate( SID_FRAME_NAME );
//STRIP001 	rBindings.Invalidate( SID_FRAME_CONTENT );
//STRIP001 	rBindings.Invalidate( SID_SPLIT_HORIZONTAL );
//STRIP001 	rBindings.Invalidate( SID_SPLIT_VERTICAL );
//STRIP001 	rBindings.Invalidate( SID_SPLIT_PARENT_HORIZONTAL );
//STRIP001 	rBindings.Invalidate( SID_SPLIT_PARENT_VERTICAL );
//STRIP001 	rBindings.Invalidate( SID_SOURCEVIEW );
//STRIP001 	rBindings.Invalidate( SID_MODIFY_FRAME );
//STRIP001 	rBindings.Invalidate( SID_DELETE_FRAME );
//STRIP001 }

//STRIP001 SfxFrame* SfxFrameSetViewShell::GetActiveFrame() const
//STRIP001 {
//STRIP001 	return pImp->pActiveFrame;
//STRIP001 }

//STRIP001 void SfxFrameSetViewShell::SaveUndo( SfxFrameSetDescriptor *pUndo,
//STRIP001 	 SfxFrameSetDescriptor *pRedo, const String& aComment, sal_Bool bClose )
//STRIP001 {
//STRIP001 	GetUndoManager()->AddUndoAction(
//STRIP001 		new UndoAction_Impl( this, pUndo, pRedo, aComment, bClose ) );
//STRIP001 }

//STRIP001 long SfxFrameSetViewShell::GetDefaultSplitSize() const
//STRIP001 {
//STRIP001 	return pImp->pWindow->nDefaultSplitSize;
//STRIP001 }

//STRIP001 SfxFrameSetViewShell* SfxFrameSetViewShell::GetParentFrameSet() const
//STRIP001 {
//STRIP001 	SfxFrame *pFrame = GetViewFrame()->GetFrame()->GetParentFrame();
//STRIP001 /*
//STRIP001 	while ( pFrame && !( pFrame->GetFrameType() & SFXFRAME_FRAMESET ) )
//STRIP001 		pFrame = pFrame->GetParentFrame();
//STRIP001 */
//STRIP001 	return pFrame ? PTR_CAST( SfxFrameSetViewShell, pFrame->GetCurrentViewFrame()->GetViewShell() ) : NULL;
//STRIP001 }


//STRIP001 sal_Bool SfxFrameSetViewShell::StartEditing()
//STRIP001 {
//STRIP001 	SetEditMode( sal_True );
//STRIP001 	SfxViewFrame *pViewFrame = GetViewFrame();
//STRIP001 	SplitWindow* pWindow = GetSplitWindow();
//STRIP001 	if ( pDescriptor->CheckContent() )
//STRIP001 	{
//STRIP001 		// Wenn der Inhalt einiger Frames durch Browsen ver"andert
//STRIP001 		// worden ist, mu\s durch R"uckfrage beim Benutzer ein
//STRIP001 		// Abgleich von urspr"unglichem und aktuellemInhalt in der
//STRIP001 		// einen oder anderen Richtung erreicht werden.
//STRIP001 		String aMsg( SfxResId(STR_URL_CHANGED) );
//STRIP001 		QueryBox aBox( NULL, WinBits( WB_YES_NO_CANCEL | WB_DEF_YES ), aMsg );
//STRIP001 		sal_uInt16 nRet = aBox.Execute();
//STRIP001 		switch ( nRet )
//STRIP001 		{
//STRIP001 			case RET_NO:
//STRIP001 				// Die aktuell angezeigten Dokumente sollen auch
//STRIP001 				// die gespeicherten werden
//STRIP001 				pDescriptor->UnifyContent( sal_True );
//STRIP001 				break;
//STRIP001 			case RET_YES:
//STRIP001 			{
//STRIP001 				// Vor dem Editieren sollen die urpr"unglichen
//STRIP001 				// Inhalte wiedergeholt und angezeigt werden
//STRIP001 				pDescriptor->UnifyContent( sal_False );
//STRIP001 				pWindow->SetUpdateMode( sal_False );
//STRIP001 				pWindow->Clear();
//STRIP001 				Fill ( pDescriptor );
//STRIP001 				pWindow->SetUpdateMode( sal_True );
//STRIP001 				break;
//STRIP001 			}
//STRIP001 			default:
//STRIP001 				// Editieren abbrechen
//STRIP001 				SetEditMode( sal_False );
//STRIP001 				return sal_False;;
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Aktives Child am MDIFrame resetten
//STRIP001     BOOL bSetFocus = pViewFrame->GetWindow().HasChildPathFocus( TRUE );
//STRIP001 	SfxURLFrame *pURL = PTR_CAST(SfxURLFrame, GetActiveFrame() );
//STRIP001 	pViewFrame->GetFrame()->LockFocus_Impl( sal_True );
//STRIP001 	pViewFrame->SetActiveChildFrame_Impl( NULL );
//STRIP001 
//STRIP001 	// Das FrameSet-Dokument aktivieren
//STRIP001     pViewFrame->MakeActive_Impl( bSetFocus );
//STRIP001     if ( bSetFocus )
//STRIP001         GetWindow()->GrabFocus();
//STRIP001     if ( pURL )
//STRIP001         SetActiveFrame( pURL->GetEditFrame_Impl() );
//STRIP001 	return sal_True;
//STRIP001 }

//STRIP001 sal_Bool SfxFrameSetViewShell::EndEditing()
//STRIP001 {
//STRIP001 	SfxViewFrame *pViewFrame = GetViewFrame();
//STRIP001     BOOL bSetFocus = pViewFrame->GetFrame()->GetWindow().HasChildPathFocus( TRUE );
//STRIP001 	if ( GetObjectShell()->IsModified() )
//STRIP001 	{
//STRIP001 		// A"nderungen sofort speichern
//STRIP001 		// Document braucht auf jeden Fall einen Namen, sonst gibt es
//STRIP001 		// Probleme beim Browsen
//STRIP001 		String aText( SfxResId( STR_QUERY_SAVE_DOCUMENT ) );
//STRIP001 		aText.SearchAndReplace( DEFINE_CONST_UNICODE( "$(DOC)" ),
//STRIP001 								GetObjectShell()->GetTitle( SFX_TITLE_PICKLIST ) );
//STRIP001 		QueryBox aQBox( &pViewFrame->GetWindow(),
//STRIP001 						WB_OK_CANCEL | WB_DEF_OK, aText );
//STRIP001 		short nRet = aQBox.Execute();
//STRIP001 		switch ( nRet )
//STRIP001 		{
//STRIP001 			case RET_OK :
//STRIP001 			{
//STRIP001 				pViewFrame->GetDispatcher()->Execute( SID_SAVEDOC, SFX_CALLMODE_SYNCHRON );
//STRIP001 				if ( !GetObjectShell()->IsModified() )
//STRIP001 				{
//STRIP001 					// Nur EditMode beenden, wenn gespeichert
//STRIP001 					break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			case RET_CANCEL:
//STRIP001 			{
//STRIP001 				// Editieren nicht beenden
//STRIP001 				return sal_False;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	SetEditMode( sal_False );
//STRIP001 
//STRIP001 	// Versuchen, einen ChildFrame zu aktivieren
//STRIP001 	pViewFrame->GetFrame()->LockFocus_Impl( sal_False );
//STRIP001 	SfxViewFrame *pFrm=NULL;
//STRIP001 	sal_Bool bReadOnly = pViewFrame->GetObjectShell()->IsReadOnly();
//STRIP001 
//STRIP001 	// Zun"achst an dem gerade selektierten URLFrame
//STRIP001 	SfxURLFrame *pURL = PTR_CAST(SfxURLFrame, GetActiveFrame() );
//STRIP001 	if ( pURL && pURL->GetCurrentDocument() )
//STRIP001 		pFrm = pURL->ActivateChildFrame_Impl();
//STRIP001 
//STRIP001 	// Ansonsten an irgendeinem anderen
//STRIP001 	if ( !pFrm )
//STRIP001 		pFrm = pViewFrame->GetFrame()->ActivateChildFrame_Impl();
//STRIP001 
//STRIP001 	// Aktives Child am MDIFrame setzen; dabei wird auch das
//STRIP001 	// UI wieder entlocked
//STRIP001 	if ( pFrm )
//STRIP001         pFrm->MakeActive_Impl( bSetFocus );
//STRIP001 
//STRIP001 	return sal_True;
//STRIP001 }

//STRIP001 SfxFrame* SfxFrameSetViewShell::Split( sal_uInt16 nItemId, sal_uInt16 nId )
//STRIP001 {
//STRIP001 	SfxURLFrame *pURL = PTR_CAST(SfxURLFrame, GetViewFrame()->GetFrame()->SearchFrame_Impl( nItemId ) );
//STRIP001 	sal_Bool bParent = sal_False;
//STRIP001 	// Aus dem "ubergebenen Item sollen zwei werden mit je der halben ::com::sun::star::awt::Size
//STRIP001 	if ( pURL )
//STRIP001 	{
//STRIP001 		SplitWindow* pWindow = pImp->pWindow;
//STRIP001 
//STRIP001 		// Den alten Descriptor f"ur Undo merken
//STRIP001 		SfxFrameSetDescriptor *pUndo = pDescriptor->Clone();
//STRIP001 
//STRIP001 		// FrameDescriptor zur ItemId suchen
//STRIP001 		SfxFrameDescriptor *pOldFrame = pDescriptor->SearchFrame( nItemId );
//STRIP001 		DBG_ASSERT( pOldFrame, "Frame nicht gefunden!" );
//STRIP001 
//STRIP001 		// Parameter aufbereiten
//STRIP001 		sal_Bool bParentSplit = sal_False;
//STRIP001 		sal_Bool bHorizontalSplit = ( nId == SID_SPLIT_HORIZONTAL );
//STRIP001 		if ( nId == SID_SPLIT_PARENT_HORIZONTAL || nId == SID_SPLIT_PARENT_VERTICAL )
//STRIP001 		{
//STRIP001 			bParentSplit = sal_True;
//STRIP001 			bHorizontalSplit = ( nId == SID_SPLIT_PARENT_HORIZONTAL );
//STRIP001 		}
//STRIP001 
//STRIP001 		// Split ausf"uhren
//STRIP001 		SfxFrameDescriptor *pSplit =
//STRIP001 			pOldFrame->Split( bHorizontalSplit, bParentSplit );
//STRIP001 		if ( !pSplit )
//STRIP001 		{
//STRIP001 			pWindow->SetUpdateMode( sal_True );
//STRIP001 			delete pUndo;
//STRIP001 			return NULL;
//STRIP001 		}
//STRIP001 
//STRIP001 //!		SfxFrameSetViewShell *pFrameSet = GetParentFrameSet();
//STRIP001 //!		if ( !pFrameSet )
//STRIP001 //!			pFrameSet = this;
//STRIP001 //!		pFrameSet->ReFill( pFrameSet->pDescriptor );
//STRIP001 		ReFill( pDescriptor );
//STRIP001 
//STRIP001 		// "Anderungen an das Dokument weitergeben
//STRIP001 		SfxFrameSetObjectShell *pDoc =
//STRIP001 			PTR_CAST( SfxFrameSetObjectShell, GetViewFrame()->GetObjectShell() );
//STRIP001 
//STRIP001 		EndListening( *pDoc );
//STRIP001 		pDoc->TakeDescriptor( pDescriptor );
//STRIP001 		StartListening( *pDoc );
//STRIP001 
//STRIP001 		// F"ur das Redo eine Kopie des neuen Descriptors ziehen
//STRIP001 		SaveUndo( pUndo, pDescriptor->Clone(), SFX_SLOTPOOL().GetSlotName_Impl( nId ) );
//STRIP001 
//STRIP001 		return GetViewFrame()->GetFrame()->SearchFrame_Impl( pSplit->GetItemId() );;
//STRIP001 	}
//STRIP001 
//STRIP001 	return NULL;
//STRIP001 }

//STRIP001 void SfxFrameSetViewShell::SetFrameContent( sal_uInt16 nItemId, const String& rContent )
//STRIP001 {
//STRIP001 	SfxURLFrame *pURL = PTR_CAST(SfxURLFrame, GetViewFrame()->GetFrame()->SearchFrame_Impl( nItemId ) );
//STRIP001 	if ( pURL )
//STRIP001 	{
//STRIP001 		SplitWindow* pWindow = pImp->pWindow;
//STRIP001 
//STRIP001 		// Den alten Descriptor f"ur Undo merken
//STRIP001 		SfxFrameSetDescriptor *pUndo = pDescriptor->Clone();
//STRIP001 
//STRIP001 		// FrameDescriptor zur ItemId suchen
//STRIP001 		SfxFrameDescriptor *pD = pDescriptor->SearchFrame( nItemId );
//STRIP001         pD->SetURL( rContent.Len() ? so3::StaticBaseUrl::SmartRelToAbs( rContent ) : String() );
//STRIP001 
//STRIP001 		pWindow->SetUpdateMode( sal_False );
//STRIP001 		pURL->Update();
//STRIP001 		pWindow->SetUpdateMode( sal_True );
//STRIP001 
//STRIP001 		SfxFrameSetObjectShell *pDoc =
//STRIP001 			PTR_CAST( SfxFrameSetObjectShell, GetViewFrame()->GetObjectShell() );
//STRIP001 		EndListening( *pDoc );
//STRIP001 		pDoc->TakeDescriptor( pDescriptor );
//STRIP001 		StartListening( *pDoc );
//STRIP001 
//STRIP001 		// F"ur das Redo eine Kopie des neuen Descriptors ziehen
//STRIP001 		if ( IsInEditMode() )
//STRIP001 			SaveUndo( pUndo, pDescriptor->Clone(), SFX_SLOTPOOL().GetSlotName_Impl( SID_FRAME_CONTENT ) );
//STRIP001 		else
//STRIP001 			delete pUndo;
//STRIP001 	}
//STRIP001 }

//STRIP001 void SfxFrameSetViewShell::SetFrameName( sal_uInt16 nItemId, const String& rName )
//STRIP001 {
//STRIP001 	SfxURLFrame *pURL = PTR_CAST(SfxURLFrame, GetViewFrame()->GetFrame()->SearchFrame_Impl( nItemId ) );
//STRIP001 	if ( pURL )
//STRIP001 	{
//STRIP001 		SplitWindow* pWindow = pImp->pWindow;
//STRIP001 
//STRIP001 		// Den alten Descriptor f"ur Undo merken
//STRIP001 		SfxFrameSetDescriptor *pUndo = pDescriptor->Clone();
//STRIP001 
//STRIP001 		// FrameDescriptor zur ItemId suchen
//STRIP001 		SfxFrameDescriptor *pD = pDescriptor->SearchFrame( nItemId );
//STRIP001 		pD->SetName( rName );
//STRIP001 		pURL->Update();
//STRIP001 
//STRIP001 		SfxFrameSetObjectShell *pDoc =
//STRIP001 			PTR_CAST( SfxFrameSetObjectShell, GetViewFrame()->GetObjectShell() );
//STRIP001 		EndListening( *pDoc );
//STRIP001 		pDoc->TakeDescriptor( pDescriptor );
//STRIP001 		StartListening( *pDoc );
//STRIP001 
//STRIP001 		// F"ur das Redo eine Kopie des neuen Descriptors ziehen
//STRIP001 		if ( IsInEditMode() )
//STRIP001 			SaveUndo( pUndo, pDescriptor->Clone(), SFX_SLOTPOOL().GetSlotName_Impl( SID_FRAME_NAME ) );
//STRIP001 		else
//STRIP001 			delete pUndo;
//STRIP001 	}
//STRIP001 }

//STRIP001 void SfxFrameSetViewShell::SetFrameSpacing( long nValue )
//STRIP001 {
//STRIP001 	if ( pDescriptor->GetFrameSpacing() != nValue )
//STRIP001 	{
//STRIP001 		SfxFrameSetWindow_Impl* pWindow = pImp->pWindow;
//STRIP001 
//STRIP001 		// Die tats"achlichen Werte berechnen
//STRIP001 		long nSpacing = pWindow->GetSplitSize( 0 );
//STRIP001 		long nNewSpacing = ( nValue == SPACING_NOT_SET ) ?
//STRIP001 			GetDefaultSplitSize() : nValue;
//STRIP001 
//STRIP001 		// Den alten Descriptor f"ur Undo merken
//STRIP001 		SfxFrameSetDescriptor *pUndo = pDescriptor->Clone();
//STRIP001 		pWindow->SetUpdateMode( sal_False );
//STRIP001 
//STRIP001 		// Es hat sich was ge"andert; ggf. default
//STRIP001 		// restaurieren, dann Update
//STRIP001 		pDescriptor->SetFrameSpacing( nValue );
//STRIP001 		if ( !pDescriptor->IsFrameSpacingSet() )
//STRIP001 			pWindow->SetSplitSize( 0, nNewSpacing, sal_True );
//STRIP001 		pWindow->UpdateFrameSpacing( pDescriptor );
//STRIP001 		UpdateFrameBorder( pDescriptor );
//STRIP001 
//STRIP001 		pWindow->SetUpdateMode( sal_True );
//STRIP001 
//STRIP001 		SfxFrameSetObjectShell *pDoc =
//STRIP001 			PTR_CAST( SfxFrameSetObjectShell, GetViewFrame()->GetObjectShell() );
//STRIP001 		EndListening( *pDoc );
//STRIP001 		pDoc->TakeDescriptor( pDescriptor );
//STRIP001 		StartListening( *pDoc );
//STRIP001 
//STRIP001 		// F"ur das Redo eine Kopie des neuen Descriptors ziehen
//STRIP001 		SaveUndo( pUndo, pDescriptor->Clone(), SFX_SLOTPOOL().GetSlotName_Impl( SID_FRAMESPACING ) );
//STRIP001 	}
//STRIP001 }

//STRIP001 void SfxFrameSetViewShell::ModifyFrame( sal_uInt16 nItemId, const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	SfxURLFrame *pURL = PTR_CAST(SfxURLFrame, GetViewFrame()->GetFrame()->SearchFrame_Impl( nItemId ) );
//STRIP001 	if ( pURL )
//STRIP001 	{
//STRIP001 		SfxFrameSetWindow_Impl* pWindow = pImp->pWindow;
//STRIP001 
//STRIP001 		// Item auswerten
//STRIP001 		const SfxPoolItem *pItem;
//STRIP001 		SfxItemState eState = rSet.GetItemState( SID_FRAMEDESCRIPTOR, sal_False, &pItem );
//STRIP001 		if ( eState != SFX_ITEM_SET )
//STRIP001 			// Nichts ver"andert
//STRIP001 			return;
//STRIP001 
//STRIP001 		// Den alten Descriptor f"ur Undo merken
//STRIP001 		SfxFrameSetDescriptor *pUndo = pDescriptor->Clone();
//STRIP001 		pWindow->SetUpdateMode( sal_False );
//STRIP001 
//STRIP001 		// FrameBorder vom Set merken, um "Anderungen mitzubekommen
//STRIP001 		SfxFrameDescriptor *pD = pDescriptor->SearchFrame( nItemId );
//STRIP001 		SfxFrameSetDescriptor *pSet = pD->GetParent();
//STRIP001 		sal_Bool bHasBorder = pSet->HasFrameBorder();
//STRIP001 
//STRIP001 		// "Anderungen vornehmen
//STRIP001 		pD->TakeProperties( ((SfxFrameDescriptorItem*)pItem)->GetProperties() );
//STRIP001 
//STRIP001 		// FrameBorder vergleichen
//STRIP001 		if ( bHasBorder != pSet->HasFrameBorder() )
//STRIP001 			UpdateFrameBorder( pDescriptor );
//STRIP001 
//STRIP001 		// Dann Frame properties updaten
//STRIP001 		DBG_ASSERT( pURL->GetDescriptor() == pD, "Falscher Frame!" );
//STRIP001 		pURL->Update();
//STRIP001 
//STRIP001 		// Zuletzt FrameSet properties updaten
//STRIP001 		sal_uInt16 nSet = pWindow->GetSet( nItemId );
//STRIP001 		if ( nSet )
//STRIP001 		{
//STRIP001 			long nSize = pSet->GetParentFrame()->GetSize();
//STRIP001 
//STRIP001 			// Das ParentSet ist nicht das RootSet, also k"onnen
//STRIP001 			// sich ItemSize oder ItemBits ge"andert haben.
//STRIP001 //			if ( nSize )
//STRIP001 			{
//STRIP001 				pWindow->SetItemSize( nSet,
//STRIP001 					pSet->GetParentFrame()->GetSize() );
//STRIP001 
//STRIP001 				// ItemBits; im Editmode ist Gr"o\sen"anderung immer erlaubt
//STRIP001 				sal_uInt16 nBits = pSet->GetParentFrame()->GetWinBits();
//STRIP001 				if ( IsInEditMode() )
//STRIP001 					nBits = nBits & ~SWIB_FIXED;
//STRIP001 				pWindow->SetItemBits( nSet, nBits );
//STRIP001 			}
//STRIP001 /*
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// ItemSet ohne ::com::sun::star::awt::Size rausnehmen
//STRIP001 				pWindow->RemoveItem( nSet );
//STRIP001 
//STRIP001 				// Alle URLFrames, die nicht mehr im Frameset vertreten sind, k"onnen
//STRIP001 				// jetzt abger"aumt werden
//STRIP001 				SfxFrameIterator aIter( *GetViewFrame()->GetFrame(), sal_False );
//STRIP001 				SfxFrame *pChild = aIter.FirstFrame();
//STRIP001 				while ( pChild )
//STRIP001 				{
//STRIP001 					SfxFrame *pNext = aIter.NextFrame( *pChild );
//STRIP001 					if ( !pWindow->IsItemValid( pChild->GetFrameId_Impl() ) )
//STRIP001 						pChild->DoClose();
//STRIP001 					pChild = pNext;
//STRIP001 				}
//STRIP001 			}
//STRIP001 */
//STRIP001 		}
//STRIP001 
//STRIP001 		pWindow->SetUpdateMode( sal_True );
//STRIP001 
//STRIP001 		SfxFrameSetObjectShell *pDoc =
//STRIP001 			PTR_CAST( SfxFrameSetObjectShell, GetViewFrame()->GetObjectShell() );
//STRIP001 		EndListening( *pDoc );
//STRIP001 		pDoc->TakeDescriptor( pDescriptor );
//STRIP001 		StartListening( *pDoc );
//STRIP001 
//STRIP001 		// F"ur das Redo eine Kopie des neuen Descriptors ziehen
//STRIP001 		SaveUndo( pUndo, pDescriptor->Clone(), SFX_SLOTPOOL().GetSlotName_Impl( SID_MODIFY_FRAME ) );
//STRIP001 	}
//STRIP001 }

//STRIP001 void SfxFrameSetViewShell::DeleteFrame( sal_uInt16 nItemId )
//STRIP001 {
//STRIP001 	SfxURLFrame *pURL = PTR_CAST(SfxURLFrame, GetViewFrame()->GetFrame()->SearchFrame_Impl( nItemId ) );
//STRIP001 	if ( pURL )
//STRIP001 	{
//STRIP001 		SfxFrame *pFrame = pURL;
//STRIP001 		SplitWindow* pWindow = pImp->pWindow;
//STRIP001 
//STRIP001 		// Den alten Descriptor f"ur Undo merken
//STRIP001 		SfxFrameSetDescriptor *pUndo = pDescriptor->Clone();
//STRIP001 
//STRIP001 		// FrameDescriptor und URLFrame f"ur den zu l"oschenden Frame holen
//STRIP001 		SfxFrameDescriptor *pD = pDescriptor->SearchFrame( nItemId );
//STRIP001 
//STRIP001 		// Vielleicht soll der letzte Frame eines Sets gel"oscht werden ?
//STRIP001 		sal_uInt16 nSet = pWindow->GetSet( nItemId );
//STRIP001 		while ( nSet && pWindow->GetItemCount( nSet ) == 1 )
//STRIP001 		{
//STRIP001 			// Wenn der jeweilige Parent ein FrameSetDocument ist, diesen Frame l"oschen
//STRIP001 			SfxFrame *pParent = GetViewFrame()->GetFrame()->GetParentFrame();
//STRIP001 			if ( pParent )
//STRIP001 				pParent = pParent->SearchFrame_Impl( nSet );
//STRIP001 			if ( pParent )
//STRIP001 				pFrame = pParent;
//STRIP001 
//STRIP001 			// Auf jeden Fall leere Sets aus dem Descriptor entfernen
//STRIP001 			pD = pDescriptor->SearchFrame( nSet );
//STRIP001 			nSet = pWindow->GetSet( nSet );
//STRIP001 		}
//STRIP001 
//STRIP001 		// Frame closen; dabei werden neben dem ItemWindow auch die leeren Itemsets oberhalb pFrame entfernt
//STRIP001 		pFrame->DoClose();
//STRIP001 		pD->GetParent()->RemoveFrame( pD );
//STRIP001 		delete pD;
//STRIP001 
//STRIP001 		// Einen Frame brauche ich immer zum Editieren...
//STRIP001 		if ( !pDescriptor->GetFrameCount() )
//STRIP001 		{
//STRIP001 			pDescriptor->SetColSet( sal_True );
//STRIP001 			pD = new SfxFrameDescriptor( pDescriptor );
//STRIP001 			pD->SetWidthPercent( 100 );
//STRIP001 			ReFill( pDescriptor );
//STRIP001 		}
//STRIP001 
//STRIP001 		SfxFrameSetObjectShell *pDoc =
//STRIP001 			PTR_CAST( SfxFrameSetObjectShell, GetViewFrame()->GetObjectShell() );
//STRIP001 		EndListening( *pDoc );
//STRIP001 		pDoc->TakeDescriptor( pDescriptor );
//STRIP001 		StartListening( *pDoc );
//STRIP001 
//STRIP001 		// F"ur das Redo eine Kopie des neuen Descriptors ziehen
//STRIP001 		SaveUndo( pUndo, pDescriptor->Clone(), SFX_SLOTPOOL().GetSlotName_Impl( SID_DELETE_FRAME ) );
//STRIP001 	}
//STRIP001 }

//STRIP001 sal_uInt16 SfxFrameSetViewShell::GetCurItemId()
//STRIP001 {
//STRIP001 	SfxURLFrame *pURL = PTR_CAST(SfxURLFrame, GetActiveFrame() );
//STRIP001 	if ( !pURL )
//STRIP001 	{
//STRIP001 		SfxFrame *pFrame = GetViewFrame()->GetFrame();
//STRIP001 		if ( pFrame->GetChildFrameCount() )
//STRIP001 		{
//STRIP001 			SetActiveFrame( (SfxURLFrame*) pFrame->GetChildFrame(0) );
//STRIP001 			pURL = PTR_CAST(SfxURLFrame, GetActiveFrame() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return pURL ? pURL->GetFrameId_Impl() : 0;
//STRIP001 }

//STRIP001 void SfxFrameSetViewShell::ForceInit( sal_Bool bWithFrames )
//STRIP001 {
//STRIP001 	if ( !pImp->bInit )
//STRIP001 	{
//STRIP001 		pImp->bInit = sal_True;
//STRIP001 		Fill( pDescriptor );
//STRIP001 
//STRIP001 		if ( bWithFrames )
//STRIP001 		{
//STRIP001 			SfxFrame *pFrame = GetViewFrame()->GetFrame();
//STRIP001 			SfxFrameIterator aIter( *pFrame, sal_False );
//STRIP001 			SfxFrame *pChild = aIter.FirstFrame();
//STRIP001 			while ( pChild )
//STRIP001 			{
//STRIP001 				((SfxURLFrame*)pChild)->ForceInit_Impl();
//STRIP001 				pChild = aIter.NextFrame( *pChild );
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( !pImp->nLoadingFrames )
//STRIP001 			{
//STRIP001 				GetObjectShell()->FinishedLoading();
//STRIP001 				pImp->bLoading = sal_False;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void SfxFrameSetViewShell::FrameFinishedLoading_Impl( SfxFrame *pFrame )
//STRIP001 {
//STRIP001 	// Die Benachrichtigun mu\s unterdr"uckt werden, wenn am "ubergebenen Frame selbst noch
//STRIP001 	// Child-Ladevorg"ange laufen
//STRIP001 	SfxViewFrame *pView = pFrame->GetCurrentViewFrame();
//STRIP001 	if (!pView)
//STRIP001 		return;
//STRIP001 
//STRIP001 	SfxFrameSetViewShell *pSet = PTR_CAST( SfxFrameSetViewShell, pView->GetViewShell() );
//STRIP001 	if ( pImp->bLoading && ( !pSet || pSet->pImp->bInit && !pSet->pImp->nLoadingFrames ) )
//STRIP001 	{
//STRIP001 		if ( !--pImp->nLoadingFrames )
//STRIP001 		{
//STRIP001 			pImp->bLoading = sal_False;
//STRIP001 			GetObjectShell()->FinishedLoading();
//STRIP001 
//STRIP001 			// Wenn ich selbst in einem Frameset sitze, wurde dort das LoadFinished bisher
//STRIP001 			// unterdr"uckt; also jetzt erneut senden
//STRIP001 			SfxURLFrame *pURL = PTR_CAST( SfxURLFrame, pFrame->GetParentFrame() );
//STRIP001 			if ( pURL )
//STRIP001 				pURL->LoadFinished_Impl();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


}
