/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: xmloff_xmlscripte.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 09:21:14 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #include <tools/debug.hxx>
// auto strip #include <tools/inetdef.hxx>
// auto strip #include <tools/isolang.hxx>

#include "xmlscripte.hxx"
// auto strip #include "xmlnmspe.hxx"
// auto strip #include "xmltoken.hxx"
#include "xmlexp.hxx"
// auto strip #include "attrlist.hxx"
// auto strip #include "nmspmap.hxx"

// auto strip #include <rtl/ustrbuf.hxx>
// auto strip #include <tools/time.hxx>

// auto strip #include <com/sun/star/document/XDocumentInfoSupplier.hpp>
// auto strip #include <com/sun/star/container/XNameContainer.hpp>
// auto strip #include <com/sun/star/script/XStarBasicAccess.hpp>
// auto strip #include <com/sun/star/script/XStarBasicModuleInfo.hpp>
// auto strip #include <com/sun/star/script/XStarBasicDialogInfo.hpp>
// auto strip #include <com/sun/star/script/XStarBasicLibraryInfo.hpp>
namespace binfilter {


using namespace ::com::sun::star::xml::sax;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::frame;
using namespace ::com::sun::star::script;
using namespace ::com::sun::star::container;
using namespace rtl;
using namespace ::binfilter::xmloff::token;

//-------------------------------------------------------------------------

XMLBasicExport::XMLBasicExport( SvXMLExport& rExp )
	: mrExp( rExp )
{
}

XMLBasicExport::~XMLBasicExport()
{
}

void XMLBasicExport::implWriteModules( Reference< XStarBasicLibraryInfo > xLibInfo )
{
	// #85257 Basic libs now are exported outside content.xml
#if 0
    Reference< XNameContainer > xModuleContainer = xLibInfo->getModuleContainer();
    Sequence< OUString > aNames = xModuleContainer->getElementNames();
	const OUString* pNames = aNames.getConstArray();
	sal_Int32 nCount = aNames.getLength();

	OUString sElem, sSubElem, sAttrName, sValue;
	for( sal_Int32 i = 0 ; i < nCount ; i++ )
	{
		Any aElem = xModuleContainer->getByName( pNames[i] );
		Reference< XStarBasicModuleInfo > xModuleInfo;
		aElem >>= xModuleInfo;
		if( xModuleInfo.is() ) 
		{
            // Attributes
            OUString sName = xModuleInfo->getName();
            mrExp.AddAttribute( XML_NAMESPACE_SCRIPT, XML_NAME, sName );

            OUString sLanguage = xModuleInfo->getLanguage();
            if( sLanguage.len() )
            {
                mrExp.AddAttribute( XML_NAMESPACE_SCRIPT, XML_LANGUAGE, 
                                    sLanguage );
            }

            // Library
            SvXMLElementExport aElem( rExp, XML_NAMESPACE_SCRIPT, XML_MODULE, 
                                      sal_True, sal_False );
            rExport.Characters( xModuleInfo->getSource() );
		} // if xModuleInfo.is()
	}
#endif
}


void XMLBasicExport::Export()
{
	// #85257 Basic libs now are exported outside content.xml
#if 0

	// Get Basic data
	const Reference< XModel >& xModel = mrExp.GetModel();
	Reference< XStarBasicAccess > xBasic ( xModel, UNO_QUERY );
	if( !xBasic.is() )
		return;

    Reference< XNameContainer > xLibContainer = xBasic->getLibraryContainer();
    Sequence< OUString > aNames = xLibContainer->getElementNames();
	const OUString* pNames = aNames.getConstArray();
	sal_Int32 nCount = aNames.getLength();

	OUString sElem, sSubElem, sAttrName, sValue;
	for( sal_Int32 i = 0 ; i < nCount ; i++ )
	{
		Any aElem = xLibContainer->getByName( pNames[i] );
		Reference< XStarBasicLibraryInfo > xLibInfo;
		aElem >>= xLibInfo;
		if( xLibInfo.is() )
		{
		OUString LinkTargetURL = xLibInfo->getLinkTargetURL();
		if( LinkTargetURL.len() )
		{
			sElem = mrNamespaceMap.GetQNameByKey( XML_NAMESPACE_SCRIPT, 
                                              GetXMLToken(XML_LIBRARY_LINKED);

			// Attributes
			mrAttrList.Clear();
			OUString sName = xLibInfo->getName();
			sAttrName = mrNamespaceMap.GetQNameByKey( XML_NAMESPACE_SCRIPT, 
                                                      GetXMLToken(XML_NAME) );
			mrAttrList.AddAttribute( sAttrName, msCDATA, sName );

			/* ??? Password for linked Libs? -> Should be in target
			OUString sPassword = xLibInfo->getPassword();
			if( sPassword.len() )
			{
				sAttrName = mrNamespaceMap.GetQNameByKey( XML_NAMESPACE_SCRIPT, 
                GetXMLToken(XML_PASSWORD) );
				mrAttrList.AddAttribute( sAttrName, msCDATA, sPassword );
			}
			*/

			sAttrName = mrNamespaceMap.GetQNameByKey( XML_NAMESPACE_XLINK, 
                                                      GetXMLToken(XML_HREF) );
			mrAttrList.AddAttribute( sAttrName, msCDATA, LinkTargetURL );

			sAttrName = mrNamespaceMap.GetQNameByKey( XML_NAMESPACE_XLINK, 
                                                      GetXMLToken(XML_TYPE) );
			mrAttrList.AddAttribute( sAttrName, msCDATA, GetXMLToken(XML_SIMPLE) );

			// Library
			mxHandler->ignorableWhitespace( msWS );
			mxHandler->startElement( sElem, mxAttrList );
			mxHandler->endElement( sElem );
		}
		else
		{
			sElem = mrNamespaceMap.GetQNameByKey( XML_NAMESPACE_SCRIPT, 
                                           GetXMLToken(XML_LIBRARY_EMBEDDED) );

			// Attributes
			mrAttrList.Clear();
			OUString sName = xLibInfo->getName();
			sAttrName = mrNamespaceMap.GetQNameByKey( XML_NAMESPACE_SCRIPT, 
                                                      GetXMLToken(XML_NAME) );
			mrAttrList.AddAttribute( sAttrName, msCDATA, sName );

			OUString sPassword = xLibInfo->getPassword();
			if( sPassword.len() )
			{
				sAttrName = mrNamespaceMap.GetQNameByKey( XML_NAMESPACE_SCRIPT, 
                                                   GetXMLToken(XML_PASSWORD) );
				mrAttrList.AddAttribute( sAttrName, msCDATA, sPassword );
			}

			// Library
			mxHandler->ignorableWhitespace( msWS );
			mxHandler->startElement( sElem, mxAttrList );

			// Modules
			implWriteModules( xLibInfo );

			// Dialogs
			//implWriteDialogs( xLibInfo );

			//mxHandler->characters( sValue );
			mxHandler->endElement( sElem );
		}
		} // if xLibInfo.is()
	}
	mrAttrList.Clear();
#endif
}

}//end of namespace binfilter
