/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dbfileob.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 10:46:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SBA_DBFILEOB_HXX
#define _SBA_DBFILEOB_HXX

#include "dbdefobj.hxx"
namespace binfilter {

class SdbDocument;

//==================================================================
// SbaFileDef
//==================================================================
class SbaFileDef : public SbaDBDef
{
	friend class SbaXdbDocument;

protected:
	SdbDocument* pDocument;

public:
	TYPEINFO();
	SbaFileDef (SbaDatabase* pDB,
				const String& rName,
				DBObject edbObj,
				BOOL bNew,
				BOOL bShow);

	virtual BOOL Update(const String& rFile);

	BOOL Update(SvStream& rFile);
	String  CreateTempFile();

protected:
	virtual ~SbaFileDef();
	virtual BOOL Open();
	virtual BOOL DropImpl();
	virtual BOOL RenameImpl(const String& rNewName);
	virtual BOOL DoRefresh();

	SdbDocument* GetDocument() const {return pDocument;};
};

SV_DECL_IMPL_REF(SbaFileDef);

//==================================================================
// SbaReportDef
//==================================================================
class SbaReportDef : public SbaFileDef
{
	friend class SbaDatabase;

public:
	TYPEINFO();

protected:
	SbaReportDef(SbaDatabase* pDB,
				 const String& rName,
				 BOOL bNew = TRUE,
				 BOOL bShow = TRUE)
				 :SbaFileDef(pDB,rName,dbReport,bNew,bShow){}
};
SV_DECL_IMPL_REF(SbaReportDef);

//==================================================================
// SbaFormDef
//==================================================================
class SbaFormDef : public SbaFileDef
{
	friend class SbaDatabase;
public:
	TYPEINFO();

protected:
	SbaFormDef(SbaDatabase *pDB,
			   const String& rName,
			   BOOL bNew = TRUE,
			   BOOL bShow = TRUE)
			   :SbaFileDef(pDB,rName,dbForm,bNew,bShow){}
};

SV_DECL_IMPL_REF(SbaFormDef);

} //namespace binfilter
#endif


