/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: hangulhanja.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 13:36:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SVX_HANGUL_HANJA_CONVERSION_HXX
#define SVX_HANGUL_HANJA_CONVERSION_HXX

#ifndef _SV_WINDOW_HXX 
#include <vcl/window.hxx>
#endif
// auto strip #ifndef _SVX_SVXENUM_HXX 
// auto strip #include <bf_svx/svxenum.hxx>
// auto strip #endif

#include <memory>

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
// auto strip #ifndef _COM_SUN_STAR_LANG_LOCALE_HPP_
// auto strip #include <com/sun/star/lang/Locale.hpp>
// auto strip #endif
namespace binfilter {

//.............................................................................
namespace svx
{
//.............................................................................

	class HangulHanjaConversion_Impl;

	//=========================================================================
	//= HangulHanjaConversion
	//=========================================================================
	/** encapsulates Hangul-Hanja conversion functionality

		<p>terminology:
			<ul><li>A <b>text <em>portion</em></b> is some (potentially large) piece of text
				which is to be analyzed for convertible sub-strings.</li>
				<li>A <b>text <em>unit</em></b> is a sub string in a text portion, which is
				to be converted as a whole.</li>
			</ul>
			For instance, you could have two independent selections within your document, which are then
			two text portions. A text unit would be single Hangul/Hanja words within a portion, or even
			single Hangul syllabills when "replace by character" is enabled.
		</p>
	*/
	class HangulHanjaConversion
	{
		friend class HangulHanjaConversion_Impl;

	private:
		::std::auto_ptr< HangulHanjaConversion_Impl >	m_pImpl;

	public:
		HangulHanjaConversion(
			Window* _pUIParent,
			const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxORB,
			const ::com::sun::star::lang::Locale& _rLocale
		);

        virtual ~HangulHanjaConversion( );

		// converts the whole document
		void	ConvertDocument();

	public:
		enum ReplacementAction
		{
			eExchange,				// simply exchange one text with another
			eReplacementBracketed,	// keep the original, and put the replacement in brackets after it
			eOriginalBracketed,		// replace the original text, but put it in brackeds after the replacement
			eReplacementAbove,		// keep the original, and put the replacement text as ruby text above it
			eOriginalAbove,			// replace the original text, but put it as ruby text above it
			eReplacementBelow,		// keep the original, and put the replacement text as ruby text below it
			eOriginalBelow			// replace the original text, but put it as ruby text below it
		};

		enum ConversionDirection
		{
			eHangulToHanja,
			eHanjaToHangul
		};

		enum ConversionFormat
		{
			eSimpleConversion,
			eHangulBracketed,
			eHanjaBracketed,
			eRubyHanjaAbove,
			eRubyHanjaBelow,
			eRubyHangulAbove,
			eRubyHangulBelow
		};

	protected:
		/** retrieves the next text portion which is to be analyzed

			<p>pseudo-abstract, needs to be overridden</p>

			@param _rNextPortion
				upon return, this must contain the next text portion
		*/
		virtual	void	GetNextPortion( ::rtl::OUString& /* [out] */ _rNextPortion );

		/** announces a new "current unit"

			<p>This will be called whenever it is necessary to interactively ask the user for
			a conversion. In such a case, a range within the current portion (see <member>GetNextPortion</member>)
			is presented to the user for chosing a substitution. Additionally, this method is called,
			so that derived classes can e.g. highlight this text range in a document view.</p>

			<p>Note that the indexes are relative to the most recent replace action. See
			<member>ReplaceUnit</member> for details.</p>

			@param _nUnitStart
				the start index of the unit

			@param _nUnitEnd
				the start index (exclusively!) of the unit.

			@see GetNextPortion
		*/
		virtual void	HandleNewUnit( const sal_Int32 _nUnitStart, const sal_Int32 _nUnitEnd );

		/** replaces a text unit within a text portion with a new text

			<p>pseudo-abstract, needs to be overridden</p>

			<p>Note an important thing about the indicies: They are always relative to the <em>previous
			call</em> of ReplaceUnit. This means whe you get a call to ReplaceUnit, and replace some text
			in your document, than you have to remember the document position immediately <em>behind</em>
			the changed text. In a next call to ReplaceUnit, an index of <em>0</em> will denote exactly
			this position behind the previous replacement<br/>
			The reaons for this is that this class here does not know anything about your document structure,
			so after a replacement took place, it's impossible to address anything in the range from the
			beginning of the portion up to the replaced text.<br/>
			In the very first call to ReplaceUnit, an index of <em>0</em> denotes the very first position of
			the current portion.</p>

			@param _nUnitStart
				the start index of the range to replace

			@param _nUnitEnd
				the end index (exclusively!) of the range to replace. E.g., an index
				pair (4,5) indicates a range of length 1.

			@param _rReplaceWith
				The replacement text

			@param _eAction
				replacement action to take
		*/
		virtual void	ReplaceUnit(
							const sal_Int32 _nUnitStart, const sal_Int32 _nUnitEnd,
							const ::rtl::OUString& _rReplaceWith, ReplacementAction _eAction
						);
	};

//.............................................................................
}	// namespace svx
//.............................................................................

}//end of namespace binfilter
#endif // SVX_HANGUL_HANJA_CONVERSION_HXX
