// cmdline_update.cc
//
//  Copyright 2004 Daniel Burrows

#include "../download.h"

#include <aptitude.h>

#include <generic/apt.h>

#include <apt-pkg/error.h>
#include <apt-pkg/progress.h>

int cmdline_update(int argc, char *argv[])
{
  _error->DumpErrors();

  if(argc!=1)
    {
      fprintf(stderr, _("E: The update command takes no arguments\n"));
      return -1;
    }

  OpTextProgress progress;

  apt_init(&progress, false);

  if(_error->PendingError())
    {
      _error->DumpErrors();
      return -1;
    }

  int rval=do_pkglist_update(&progress, true)?0:-1;

  if(_error->PendingError())
    rval=-1;

  _error->DumpErrors();

  return rval;
}

