/***************************************************************************
*	Brutal Chess Pre-Alpha Build
*	- randomplayer.h
*
*	Authors: Maxwell Lazaroff, Michael Cook, and Joe Flint
*	Date Created : November 5th, 2005
*	Last Modified: November 5th, 2005
*
*	- description - Implements the RandomPlayer ChessPlayer.
***************************************************************************/

#ifndef _RANDOMPLAYER_H
#define _RANDOMPLAYER_H

#include "chessplayer.h"
#include "board.h"
#include "boardmove.h"

class
RandomPlayer : public ChessPlayer
/**************************************************************************
*   RandomPlayer implementation
*
*   - This is a player that will select a random piece and move it to a
*     random location
**************************************************************************/
{
public :

	//******** CONSTRUCTOR ********
	
	RandomPlayer() : ChessPlayer("expert") {}

	virtual bool requiresInput() { return false; }

	virtual ChessPlayer* dup() const { return new RandomPlayer(); }

	virtual BoardMove decide_move(const Board & board, bool & player);

};

#endif // _RANDOMPLAYER_H

// End of file randomplayer.h
