/*
 * Copyright 2008 Sebastian Gabmeyer
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.exolab.castor.jdo.util;

/**
 * Empty class to test resolving of a {@link ClassDescriptor} from a package
 * which contains a .jdo.castor.cdr file.
 * 
 * This class should not be resolved as it is not associated with a
 * {@link org.exolab.castor.mapping.ClassDescriptor} in the
 * <em>.jdo.castor.cdr</em> file.
 * 
 * @see org.castor.cpa.util.classresolution.command.ClassResolutionByCDR
 * 
 * @author Sebastian Gabmeyer
 * @since 1.2.1
 */
public class ClassNotToBeResolved {

}
