/*
                           Endeavour Mount Bar
 */

#ifndef EDV_MOUNT_BAR_H
#define EDV_MOUNT_BAR_H

#include <gtk/gtk.h>
#include "edv_types.h"
#include "edv_device.h"


typedef struct _edv_mount_bar_struct	edv_mount_bar_struct;
#define EDV_MOUNT_BAR(p)		((edv_mount_bar_struct *)(p))


/*
 *	Mount Bar:
 */
struct _edv_mount_bar_struct {

	GtkWidget	*toplevel;
	GdkGC		*gc;
	gint		busy_count,
			freeze_count;
	edv_core_struct *core;

	GtkWidget	*dev_da,	/* Selected device GtkDrawingArea */
			*map_btn,	/* Map devices Popup List GtkButton */
			*mount_btn,	/* Mount/Unmount GtkButton */
			*eject_btn,	/* Eject GtkButton */
			*refresh_btn,	/* Refresh GtkButton */
			*goto_btn,	/* GoTo Mount Path GtkButton */
			*properties_btn,	/* Mount Path Properties GtkButton */
			*fsck_btn,	/* FSCK GtkButton */
			*tools_btn,	/* Tools GtkButton */
			*format_btn,	/* Format GtkButton */
			*devices_list_btn,	/* Devices List GtkButton */
			*stats_da;	/* Stats GtkDrawingArea */

	/* Selected device index or -1 for none */
	gint		selected_dev_num;

	/* Selected device values */
	gchar		*dev_text;
	GdkPixmap	*dev_pixmap;
	GdkBitmap	*dev_mask;

	/* Selected device stats values */
	gint		dev_stats_page;
	gfloat		dev_stats_used_coeff;
	gchar		*dev_stats_label;

	/* Mount/Unmount callback */
	void	(*mount_cb)(
		edv_mount_bar_struct *,	/* Mount Bar */
		gint,			/* Device Number */
		edv_device_struct *,	/* Device */
		gpointer		/* Data */
	);
	/* Eject callback */
	void	(*eject_cb)(
		edv_mount_bar_struct *,	/* Mount Bar */
		gint,			/* Device Number */
		edv_device_struct *,	/* Device */
		gpointer		/* Data */
	);
	/* Goto mount path callback */
	void	(*goto_cb)(
		edv_mount_bar_struct *,	/* Mount Bar */
		gint,			/* Device Number */
		edv_device_struct *,	/* Device */
		gpointer		/* Data */
	);
	/* Status message callback */
	void	(*status_message_cb)(
		const gchar *,		/* Message */
		gpointer		/* Data */
	);
	gpointer	data;

};


extern edv_mount_bar_struct *EDVMountBarNew(
	edv_core_struct *core,
	GtkWidget *parent,
	void (*mount_cb)(
		edv_mount_bar_struct *, gint, edv_device_struct *,
		gpointer
	),
	void (*eject_cb)(
		edv_mount_bar_struct *, gint, edv_device_struct *,
		gpointer
	),
	void (*goto_cb)(
		edv_mount_bar_struct *, gint, edv_device_struct *,
		gpointer
	),
	void (*status_message_cb)(const gchar *, gpointer),
	gpointer data
);
extern void EDVMountBarUpdateMenus(edv_mount_bar_struct *mb);
extern void EDVMountBarMap(edv_mount_bar_struct *mb);
extern void EDVMountBarUnmap(edv_mount_bar_struct *mb);
extern void EDVMountBarDelete(edv_mount_bar_struct *mb);


#endif	/* EDV_MOUNT_BAR_H */
