package GCUtils;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

sub round 
{
    my $number = shift;
    return int($number + .5);
}

sub urlDecode
{
    my $text = shift;
    $text =~ tr/+/ /;
    $text =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    return $text;
}

sub extractYear
{
    my $date = shift;
    
    return 0 if $date !~ /[0-9]{4}/;
    (my $year = $date) =~ s/.*?(([0-9]{4})).*?/$1/;
    
    return $year;
}

sub scaleMaxPixbuf
{
    my ($pixbuf, $maxWidth, $maxHeight, $forceScale, $quick) = @_;

    my $algorithm = $quick ? 'nearest' : 'bilinear';

    if ($forceScale)
    {
        $pixbuf = $pixbuf->scale_simple($maxWidth, $maxHeight, $algorithm);
    }
    else
    {
        my ($width, $height) = ($pixbuf->get_width, $pixbuf->get_height);
        if (($height > $maxHeight) || ($width > $maxWidth))
        {
            my ($newWidth, $newHeight);
            my $ratio = $height / $width;
            if (($width) * ($maxHeight / $height) < $maxWidth)
            {
                $newHeight = $maxHeight;
                $newWidth = $newHeight / $ratio;
            }
            else
            {
                $newWidth = $maxWidth;
                $newHeight = $newWidth * $ratio;
            }

    		$pixbuf = $pixbuf->scale_simple($newWidth, $newHeight, $algorithm);
        }
	}

	return $pixbuf;
}

sub mySimpleListSplice
{
    my ($sl, $idx, $length, @new) = @_;

    my $data = $sl->{data};

    if ($^O =~ /win32/i)
    {
        my @newData;
        my $i = 0;
        my $pushed = 0;
        foreach (@$data)
        {
            push @newData, [$_->[0]] if ($i < $idx) || ($i >= $idx + $length);
            push @newData, @new if ($i == $idx);
            $pushed = 1 if ($i == $idx);
            $i++;
        }
        push @newData, @new if !$pushed;
        @{$data} = @newData;
    }
    else
    {
        splice @$data, $idx, $length, @new;
    }    
}

sub mySplice
{
    my ($data, $idx, $length, @new) = @_;

    if ($^O =~ /win32/i)
    {
        my @newData;
        my $i = 0;
        my $pushed = 0;
        foreach (@$data)
        {
            push @newData, $_ if ($i < $idx) || ($i >= $idx + $length);
            push @newData, @new if ($i == $idx);
            $pushed = 1 if ($i == $idx);
            $i++;
        }
        push @newData, @new if !$pushed;
        @{$data} = @newData;
    }
    else
    {
        splice @$data, $idx, $length, @new;
    }    
}

sub findPosition
{
    use locale;
    my ($label, $menu) = @_;
    
    my @children = $menu->get_children;
    my $i = 0;
    my $child;
    foreach $child(@children)
    {
        return $i if (($i !=0) && ($child->child->get_label() gt $label));
        $i++;
    }
    return $i;
}

sub inArray
{
    my $val = shift;
 
    my $i = 0;
    my $elem;
    foreach $elem(@_)
    {
        if($val eq $elem)
        {
            return $i;
        }
        $i++;
    }
    return undef;
}

sub inArrayTest
{
    my $val = shift;
    my $elem;
    foreach $elem(@_)
    {
        return 1 if($val eq $elem);
    }
    return 0;
}

my $rc_style = Gtk2::RcStyle->new;

sub setWidgetPixmap
{
    my ($widget, $image) = @_;
    #my $rc_style = Gtk2::RcStyle->new;
    $rc_style->bg_pixmap_name('normal', $image);
    $rc_style->bg_pixmap_name('insensitive', $image);
    $widget->modify_style($rc_style);
}

use File::Basename;

sub getDisplayedImage
{
    my ($displayedImage, $default, $file) = @_;
#    if (File::Spec->file_name_is_absolute($displayedImage))
#    {
#        $displayedImage = $default; # if (! -e $displayedImage);
#    }
    if (!File::Spec->file_name_is_absolute($displayedImage))
    {
        my $dir;
        $dir = '.';
        $dir = dirname($file)
            if $file;
        if (-f $dir.'/'.$displayedImage)
        {
            $displayedImage = $dir.'/'.$displayedImage;
        }
        else
        {
            $displayedImage = $default unless (-e $displayedImage);
        }
        $displayedImage = $default if ! -f $displayedImage;
    }
    $displayedImage = $default if ! -f $displayedImage;
    
    return $displayedImage;
}

sub printStack
{
    my ($package, $filename, $line, $subroutine) = caller(1);
    my $current = "$package::$subroutine";
    ($package, $filename, $line, $subroutine) = caller(2);
    my $caller = "$package::$subroutine";
    print "$current from $caller\n";
}

sub sensitive
{
    my ($widget, $value) = @_;
    
    $widget->set_sensitive($value);
}

1;
