dnl CHECK_WINSOCK([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
AC_DEFUN([CHECK_WINSOCK],
[AC_MSG_CHECKING([for winsock])
LIBS="$LIBS -lwsock32"
AC_LINK_IFELSE([AC_LANG_PROGRAM([[#include <winsock.h>]],
			[[SOCKET sock = socket(AF_INET, SOCK_STREAM, 0)]])],
	[AC_MSG_RESULT([yes]); $1], [AC_MSG_RESULT([no]);  $2])])

dnl CHECK_SOCKETS
AC_DEFUN([CHECK_SOCKETS],
[AC_ARG_WITH([sockets], AS_HELP_STRING([--with-sockets],
	[choose which socket library to use (default = auto)]),,
	[with_sockets=auto])
case "$with_sockets" in
"bsd" )
  AC_SEARCH_LIBS([socket], [socket], [],
		AC_MSG_ERROR([cannot find BSD socket library])) ;;
"winsock" )
  CHECK_WINSOCK([], AC_MSG_ERROR([cannot find Winsock])) ;;
"auto" )
  AC_SEARCH_LIBS([socket], [socket], [with_sockets=bsd],
  CHECK_WINSOCK([with_sockets=winsock],
  AC_MSG_ERROR([cannot find a socket library]))) ;;
* )
  AC_MSG_ERROR([unknown option --with-sockets=$with_sockets]) ;;
esac
if test "$with_sockets" = "winsock"; then
  AC_DEFINE([USE_WINSOCK], [1], [Define to 1 to enable use of Winsock])
fi
])


dnl CHECK_SOCKET_FUNC(FUNCTION, ARGS, [ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
AC_DEFUN([CHECK_SOCKET_FUNC],
[AX_CHECK_FUNC_ARGS(["$srcdir/src/autosocket.h"], [$1], [$2], AC_DEFINE(AS_TR_CPP(HAVE_$1), [1], [Define to 1 if you have the `]$1[' function.]) [$3], [$4])])

dnl REPLACE_SOCKET_FUNC(FUNCTION, ARGS)
AC_DEFUN([REPLACE_SOCKET_FUNC],
[CHECK_SOCKET_FUNC([$1], [$2], [], [AC_LIBOBJ([$1])])])
