/*
 * misc.h - miscellanous simple algorithms as inline-functions
 *
 * iTALC
 * Copyright (c) 2004-2005 Tobias Doerffel <tobias@doerffel.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

#ifndef _MISC_H
#define _MISC_H

namespace misc
{

template<class T>
inline T abs( const T & x )
{
	return( x < static_cast<T>( 0 ) ? -x : x );
}




template<class T>
inline T min( const T & x1, const T & x2 )
{
	if( x1 < x2 )
		return( x1 );
	return( x2 );
}




template<class T>
inline T max( const T & x1, const T & x2 )
{
	if( x1 > x2 )
		return( x1 );
	return( x2 );
}




template<class T>
inline T limit( const T & x, const T & x1, const T & x2 )
{
	return( min<T>( max<T>( x, min<T>( x1, x2 ) ), max<T>( x1, x2 ) ) );
	
}




template<class T>
inline void swap( T & x1, T & x2 )
{
	T t = x1;
	x1 = x2;
	x2 = t;
}

}

#endif
