/***************************************************************************
                          initialview.h  -  description
                             -------------------
    begin                : Sun Jan 12 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INITIALVIEW_H
#define INITIALVIEW_H

#include <qptrlist.h>
#include <qwidget.h>

#include "initialviewinterface.h"

// Forward declarations
class Account;
class KConfig;

/**The login widget.
  *@author Mike K. Bennett
  */

class InitialView : public InitialViewInterface
{
  Q_OBJECT

  public:
    // The constructor
  	                     InitialView(QWidget *parent=0, const char *name=0);
    // The destructor
  	                    ~InitialView();
    // Add an account to the list of displayed accounts from which the user can choose
    void                 addAccount(Account *account);

  private: // Private methods

  private: // Private slots
    // The "connect" button was pressed.
    void                 connectToMsn();
    // The profile with the given index was selected from the drop-down list.
    void                 profileSelected(int index);


  private: // Private attributes
    // The list of accounts to choose from
    QPtrList<Account>    accounts_;
    // The application's configuration file
    KConfig             *config_;

  signals: // Public signals
    // Connect with the given account
    void                 connectWithAccount(Account *account);
    // Connect with the given account and possibly save it
    void                 connectWithAndSaveAccount(Account *account, bool doSave);

};

#endif
