/**
 * ===========================================
 * LibBase : a free Java utility library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libbase
 *
 * (C) Copyright 2007,2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * Empty
 * ------------
 * (C) Copyright 2006, by Pentaho Corporation.
 */

package org.pentaho.reporting.libraries.base.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * Class which holds a static reference to a set of empty objects. This is created for performance
 * reasons. Using this class will prevent creating duplicated "empty" object.
 *
 * @author David Kincade
 */
public final class Empty {

  /**
   * No reason to create an instance of this class.
   */
  private Empty() {
  }

  /**
   * The empty string.
   */
  public static final String STRING = "";

  /**
   * An empty array of Strings.
   */
  public static final String[] STRING_ARRAY = new String[0];

  /**
   * An empty Map. (Collections.EMPTY_MAP is not available until JDK 1.4)
   */
  public static final Map MAP = Collections.unmodifiableMap(new HashMap());

  /**
   * An empty List.
   */
  public static final List LIST = Collections.EMPTY_LIST;
}