/* OpenCP Module Player
 * copyright (c) '94-'98 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * GMIPlay Initialisiation (reads GUS patches etc)
 *
 * revision history: (please note changes here)
 *  -nb980510   Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *    -first release
 *  -kbwhenever Tammo Hinrichs <opencp@gmx.net>
 *    -changed path searching for ULTRASND.INI and patch files
 *    -corrected some obviously wrong allocations
 *  -sss050411 Stian Skjelstad <stian@nixia.no>
 *    -splitet up sourcecode to it's logical pieces
 */

#include "config.h"
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "types.h"
#include "gmiplay.h"
#include "binfile/binfpak.h"
#include "dev/mcp.h"
#include "boot/psetting.h"
#include "stuff/compat.h"

void (*_midClose)(void) = 0;

void midClose(void)
{
	int i;
	for (i=0; i<256; i++)
		midInstrumentNames[i][0]=0;
	if (_midClose)
	{
		_midClose();
		_midClose=0;
	}
}

int midInit(void)
{
	const char *midUsePref=cfGetProfileString("midi", "use", 0);
	if (midUsePref)
	{
		if ((!strcmp(midUsePref, "ultradir"))||(!strcmp(midUsePref, "ultrasnd"))||(!strcmp(midUsePref, "ultra")))
			return midInitUltra();
		if (!strcmp(midUsePref, "fff"))
			return midInitFFF();
		if (!strcmp(midUsePref, "freepats"))
			return midInitFreePats();
		if (!strcmp(midUsePref, "timidity"))
			return midInitTimidity();
		fprintf(stderr, "Invalid use= in [midi] section of ocp.ini\n");
		return 0;
	}
	if (midInitFreePats())
		return 1;
	if (midInitFFF())
		return 1;
	if (midInitUltra())
		return 1;
	if (midInitTimidity())
		return 1;
	fprintf(stderr, "No midi font loaded\n");
	return 0;
}
