/* $Cambridge: hermes/src/prayer/cmd/cmd_create.c,v 1.2 2008/05/19 15:55:54 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

void cmd_create(struct session *session)
{
    struct config *config = session->config;
    struct request *request = session->request;
    char *mailbox, *type, *parent;
    char *path, *ml_path;

    if (request->argc < 2) {
        session_redirect(session, request, "error");
        return;
    }

    request_decode_form(request);

    mailbox = utf8_to_imaputf7(request->pool,
                               assoc_lookup(request->form, "name"));

    if (!mailbox) {
        session_redirect(session, request, "error");
        return;
    }

    type   = assoc_lookup(request->form, "type");
    if (!type)
        type = "mailbox";

    if ((parent = assoc_lookup(request->form, "parent")))
        string_canon_decode(parent);

    if (parent && parent[0])
        mailbox = pool_strcat3(request->pool, parent,
                               session->hiersep, mailbox);

    if (!string_filename_valid(mailbox)) {
        session_message(session, "Name contained illegal characters");
        /* Redirect back to previous command */
        session_redirect(session, request, request->argv[1]);
        return;
    }

    path = mailbox;

    if (type && !strcmp(type, "directory"))
        ml_path = pool_strcat(request->pool, path, session->hiersep);
    else
        ml_path = path;

    ml_clear_error();
    ml_have_close();
    if (!ml_create(session, session->stream,
                   session_mailbox(session, request->pool, ml_path))) {
        if (ml_have_close()) {
            session_redirect(session, request, "restart");
            return;
        }
    }

    if (type && !strcmp(type, "directory")) {
        if (ml_have_error()) {
            session_message(session,
                            "Failed to create directory: %s - %s",
                            utf8_from_imaputf7(request->pool, path),
                            ml_errmsg());
            session_log(session,
                        "[cmd_create] Failed to create directory: %s",
                        path);
        } else {
            session_message(session, "Created directory: %s",
                            utf8_from_imaputf7(request->pool, path));
            session_log(session,
                        "[cmd_create] Created directory: %s", path);
            if (config->dualuse)
                folderlist_add(session->folderlist, path, NIL, NIL);
            else
                folderlist_add(session->folderlist, path, T, NIL);
        }
    } else if (ml_have_error()) {
        session_message(session,
                        "Failed to create mailbox: %s - %s",
                        utf8_from_imaputf7(request->pool, path), ml_errmsg());
        session_log(session,
                    "[cmd_create] Failed to create mailbox: %s",
                    path);
    } else {
        session_message(session, "Created mailbox: %s",
                        utf8_from_imaputf7(request->pool, path));
        session_log(session, "[cmd_create] Created mailbox: %s",
                    path);
        if (config->dualuse)
            folderlist_add(session->folderlist, path, NIL, NIL);
        else
            folderlist_add(session->folderlist, path, NIL, T);
    }

    /* Redirect back to previous command */
    session_redirect(session, request, request->argv[1]);
}
