/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_viewshe3.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:47:08 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

// auto strip #ifndef _COM_SUN_STAR_LANG_LOCALE_HPP_
// auto strip #include <com/sun/star/lang/Locale.hpp>
// auto strip #endif

#include <utility>
#include <vector>

#include "app.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"

// auto strip #ifndef _SV_PRINTDLG_HXX
// auto strip #include <svtools/printdlg.hxx>
// auto strip #endif

#ifndef _SFXDISPATCH_HXX
#include <bf_sfx2/dispatch.hxx>
#endif

// auto strip #ifndef _SVX_PRTQRY_HXX
// auto strip #include <bf_svx/prtqry.hxx>
// auto strip #endif

// auto strip #ifndef _SVDOPAGE_HXX //autogen
// auto strip #include <bf_svx/svdopage.hxx>
// auto strip #endif

// auto strip #ifndef _SFX_PROGRESS_HXX //autogen
// auto strip #include <bf_sfx2/progress.hxx>
// auto strip #endif
#
// auto strip #ifndef _SVDOBJ_HXX //autogen
// auto strip #include <bf_svx/svdobj.hxx>
// auto strip #endif

// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif

// auto strip #ifndef _SFX_PRINTER_HXX //autogen
// auto strip #include <bf_sfx2/printer.hxx>
// auto strip #endif

// auto strip #ifndef _SFX_BINDINGS_HXX //autogen
// auto strip #include <bf_sfx2/bindings.hxx>
// auto strip #endif

// auto strip #ifndef _SVDPAGV_HXX //autogen
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #endif
// auto strip #ifndef _SVDETC_HXX //autogen
// auto strip #include <bf_svx/svdetc.hxx>
// auto strip #endif

// auto strip #ifndef _OUTLINER_HXX //autogen
// auto strip #include <bf_svx/outliner.hxx>
// auto strip #endif

// auto strip #ifndef _SFX_MISCCFG_HXX
// auto strip #include <bf_sfx2/misccfg.hxx>
// auto strip #endif

// auto strip #ifndef _EDITSTAT_HXX //autogen
// auto strip #include <bf_svx/editstat.hxx>
// auto strip #endif

// auto strip #ifndef _OFF_APP_HXX //autogen
// auto strip #include <bf_offmgr/app.hxx>
// auto strip #endif

// auto strip #ifndef _SV_MULTISEL_HXX //autogen
// auto strip #include <tools/multisel.hxx>
// auto strip #endif

// auto strip #ifndef _SFXINTITEM_HXX
// auto strip #include <svtools/intitem.hxx>
// auto strip #endif

// auto strip #ifndef _SFXSTYLE_HXX //autogen
// auto strip #include <svtools/style.hxx>
// auto strip #endif

// auto strip #ifndef _UNOTOOLS_LOCALEDATAWRAPPER_HXX
// auto strip #include <unotools/localedatawrapper.hxx>
// auto strip #endif
// auto strip #ifndef _COMPHELPER_PROCESSFACTORY_HXX_
// auto strip #include <comphelper/processfactory.hxx>
// auto strip #endif
// auto strip #ifndef _ISOLANG_HXX
// auto strip #include <tools/isolang.hxx>
// auto strip #endif

// auto strip #ifndef _RTL_USTRBUF_HXX_
// auto strip #include <rtl/ustrbuf.hxx>
// auto strip #endif

// auto strip #ifndef _SD_STLSHEET_HXX
// auto strip #include "stlsheet.hxx"
// auto strip #endif
// auto strip #ifndef SD_WINDOW_UPDATER_HXX
// auto strip #include "WindowUpdater.hxx"
// auto strip #endif

// auto strip #include "sdattr.hxx"
// auto strip #include "viewshel.hxx"
// auto strip #include "drawdoc.hxx"
// auto strip #include "drawview.hxx"
// auto strip #include "sdpage.hxx"
// auto strip #include "unslprms.hxx"

// auto strip #include "slidchld.hxx"
#include "slidechg.hxx"

// auto strip #include "unoaprms.hxx"                 // Undo-Action
// auto strip #include "sdundogr.hxx"                 // Undo Gruppe
#include "prevchld.hxx"
//STRIP001 #include "preview.hxx"

#include "sdwindow.hxx"
// auto strip #include "docshell.hxx"
// auto strip #include "drviewsh.hxx"
#include "outlnvsh.hxx"
#include "frmview.hxx"
// auto strip #include "prntopts.hxx"
// auto strip #include "printdlg.hxx"
// auto strip #include "optsitem.hxx"

// auto strip #include "slidvish.hxx"
// auto strip #include "sdoutl.hxx"

// #96090#
#ifndef _SVXIDS_HXX
#include <bf_svx/svxids.hrc>
#endif

// auto strip #ifndef _B3D_BASE3D_HXX
// auto strip #include "goodies/base3d.hxx"
// auto strip #endif
namespace binfilter {

using namespace ::com::sun::star;
using namespace ::rtl;

/*************************************************************************
|*
|* EffekteWindow updaten
|*
\************************************************************************/

/*N*/ void SdViewShell::UpdateSlideChangeWindow()
/*N*/ {
/*N*/ 	USHORT nId = SdSlideChangeChildWindow::GetChildWindowId();
/*N*/ 	SfxChildWindow* pWindow = GetViewFrame()->GetChildWindow( nId );
/*N*/ 	if( pWindow )
/*N*/ 	{
		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 		SdSlideChangeWin* pSlideChangeWin = (SdSlideChangeWin*) pWindow->GetWindow();
//STRIP001 /*?*/ 		if( pSlideChangeWin && pSlideChangeWin->IsUpdateMode() )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			SdPage* pPage	   = NULL;
//STRIP001 /*?*/ 			USHORT	nNoOfPages = pDoc->GetSdPageCount(PK_STANDARD);
//STRIP001 /*?*/ 			USHORT	nPage;
//STRIP001 /*?*/ 			BOOL	bPageSelected = FALSE;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			// falls nichts selektiert ist, machen wir das schnell selbst
//STRIP001 /*?*/ 			for (USHORT i = 0; i < nNoOfPages; i++)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				pPage = pDoc->GetSdPage(i, PK_STANDARD);
//STRIP001 /*?*/ 				if (pPage->IsSelected())
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					bPageSelected = TRUE;
//STRIP001 /*?*/ 					break;
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			// ItemSet fuer Dialog (jetzt Window) fuellen
//STRIP001 /*?*/ 			SfxItemSet aSet(pDoc->GetPool(), ATTR_DIA_START, ATTR_DIA_END);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if( bPageSelected )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				// jetzt werden die Seitenattribute "per Hand" gemerged
//STRIP001 /*?*/ 				BOOL bSameEffect  = TRUE;		  // Annahme: alle Seiten haben die
//STRIP001 /*?*/ 				BOOL bSameSpeed   = TRUE;		  // gleichen Attribute
//STRIP001 /*?*/ 				BOOL bSameTime	  = TRUE;
//STRIP001 /*?*/ 				BOOL bSameChange  = TRUE;
//STRIP001 /*?*/ 				BOOL bSameSoundOn = TRUE;
//STRIP001 /*?*/ 				BOOL bSameSound   = TRUE;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				presentation::FadeEffect eLastEffect;
//STRIP001 /*?*/ 				FadeSpeed  eLastSpeed;
//STRIP001 /*?*/ 				ULONG	   nLastTime;
//STRIP001 /*?*/ 				PresChange eLastChange;
//STRIP001 /*?*/ 				BOOL	   bLastSoundOn;
//STRIP001 /*?*/ 				String	   aLastSound;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				// Attribute der ersten selektierten Seite
//STRIP001 /*?*/ 				for (nPage = 0; nPage < nNoOfPages; nPage++)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					pPage = pDoc->GetSdPage(nPage, PK_STANDARD);
//STRIP001 /*?*/ 					if (pPage->IsSelected())
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						eLastEffect  = pPage->GetFadeEffect();
//STRIP001 /*?*/ 						eLastSpeed	 = pPage->GetFadeSpeed();
//STRIP001 /*?*/ 						nLastTime	 = pPage->GetTime();
//STRIP001 /*?*/ 						eLastChange  = pPage->GetPresChange();
//STRIP001 /*?*/ 						bLastSoundOn = pPage->IsSoundOn();
//STRIP001 /*?*/ 						aLastSound	 = pPage->GetSoundFile();
//STRIP001 /*?*/ 						break;
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				// mit den anderen selektierten Seiten vergleichen
//STRIP001 /*?*/ 				for (; nPage < nNoOfPages; nPage++)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					pPage = pDoc->GetSdPage(nPage, PK_STANDARD);
//STRIP001 /*?*/ 					if (pPage->IsSelected())
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						if (eLastEffect  != pPage->GetFadeEffect()) bSameEffect  = FALSE;
//STRIP001 /*?*/ 						if (eLastSpeed	 != pPage->GetFadeSpeed())	bSameSpeed	 = FALSE;
//STRIP001 /*?*/ 						if (nLastTime	 != pPage->GetTime())		bSameTime	 = FALSE;
//STRIP001 /*?*/ 						if (eLastChange  != pPage->GetPresChange())	bSameChange  = FALSE;
//STRIP001 /*?*/ 						if (bLastSoundOn != pPage->IsSoundOn()) 	bSameSoundOn = FALSE;
//STRIP001 /*?*/ 						if (aLastSound	 != pPage->GetSoundFile())	bSameSound	 = FALSE;
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				// das Set besetzen
//STRIP001 /*?*/ 				if (bSameEffect)  {DBG_BF_ASSERT(0, "STRIP"); }//STRIP001 aSet.Put( DiaEffectItem( eLastEffect ) );
//STRIP001 /*?*/ 				else			  aSet.InvalidateItem( ATTR_DIA_EFFECT );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if (bSameSpeed)   {DBG_BF_ASSERT(0, "STRIP"); }//STRIP001 aSet.Put( DiaSpeedItem( eLastSpeed ) );
//STRIP001 /*?*/ 				else			  aSet.InvalidateItem( ATTR_DIA_SPEED );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if (bSameChange)  {DBG_BF_ASSERT(0, "STRIP"); }//STRIP001 aSet.Put( DiaAutoItem( eLastChange ) );
//STRIP001 /*?*/ 				else			  aSet.InvalidateItem( ATTR_DIA_AUTO );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if (bSameTime)	  {DBG_BF_ASSERT(0, "STRIP"); }//STRIP001 aSet.Put( DiaTimeItem( nLastTime ) );
//STRIP001 /*?*/ 				else			  aSet.InvalidateItem( ATTR_DIA_TIME );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if (bSameSoundOn) aSet.Put(SfxBoolItem(ATTR_DIA_SOUND, bLastSoundOn));
//STRIP001 /*?*/ 				else			  aSet.InvalidateItem(ATTR_DIA_SOUND);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if (bSameSound && aLastSound.Len() > 0)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					aSet.Put(SfxStringItem(ATTR_DIA_SOUNDFILE, aLastSound));
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 				else
//STRIP001 /*?*/ 					aSet.InvalidateItem(ATTR_DIA_SOUNDFILE);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				pSlideChangeWin->EnableAssignButton();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else // keine selektierte Seite
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				aSet.InvalidateItem( ATTR_DIA_EFFECT );
//STRIP001 /*?*/ 				aSet.InvalidateItem( ATTR_DIA_SPEED );
//STRIP001 /*?*/ 				aSet.InvalidateItem( ATTR_DIA_AUTO );
//STRIP001 /*?*/ 				aSet.InvalidateItem( ATTR_DIA_TIME );
//STRIP001 /*?*/ 				aSet.InvalidateItem( ATTR_DIA_SOUND );
//STRIP001 /*?*/ 				aSet.InvalidateItem( ATTR_DIA_SOUNDFILE );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				pSlideChangeWin->EnableAssignButton( FALSE );
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			pSlideChangeWin->Update( aSet );
//STRIP001 /*?*/ 		}
/*?*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Vom EffekteWindow zuweisen
|*
\************************************************************************/

//STRIP001 void SdViewShell::AssignFromSlideChangeWindow()
//STRIP001 {
//STRIP001 	USHORT nId = SdSlideChangeChildWindow::GetChildWindowId();
//STRIP001 	SfxChildWindow* pWindow = GetViewFrame()->GetChildWindow( nId );
//STRIP001 	if( pWindow )
//STRIP001 	{
//STRIP001 		SdSlideChangeWin* pSlideChangeWin = (SdSlideChangeWin*) pWindow->GetWindow();
//STRIP001 		if( pSlideChangeWin )
//STRIP001 		{
//STRIP001 			SdPage* pPage	   = NULL;
//STRIP001 			USHORT	nNoOfPages = pDoc->GetSdPageCount(PK_STANDARD);
//STRIP001 			USHORT	nPage;
//STRIP001 
//STRIP001 
//STRIP001 			SfxItemSet aSet(pDoc->GetPool(), ATTR_DIA_START, ATTR_DIA_END );
//STRIP001 			pSlideChangeWin->GetAttr( aSet );
//STRIP001 
//STRIP001 			// Auswertung des ItemSets
//STRIP001 
//STRIP001 			// Undo Gruppe erzeugen
//STRIP001 			SdUndoGroup* pUndoGroup = new SdUndoGroup(pDoc);
//STRIP001 			String aComment(SdResId(STR_UNDO_SLIDE_PARAMS));
//STRIP001 			pUndoGroup->SetComment(aComment);
//STRIP001 
//STRIP001 			for (nPage = 0; nPage < nNoOfPages; nPage++)
//STRIP001 			{
//STRIP001 				pPage = pDoc->GetSdPage(nPage, PK_STANDARD);
//STRIP001 				if (pPage->IsSelected())
//STRIP001 				{
//STRIP001 					// alte Attribute fuer UndoAction merken
//STRIP001 					FadeSpeed  eOldFadeSpeed  = pPage->GetFadeSpeed();
//STRIP001 					presentation::FadeEffect eOldFadeEffect = pPage->GetFadeEffect();
//STRIP001 					PresChange eOldChange	  = pPage->GetPresChange();
//STRIP001 					UINT32	   nOldTime 	  = pPage->GetTime();
//STRIP001 					BOOL	   bOldSoundOn	  = pPage->IsSoundOn();
//STRIP001 					String	   aOldSoundFile  = pPage->GetSoundFile();
//STRIP001 
//STRIP001 					if (aSet.GetItemState(ATTR_DIA_EFFECT) == SFX_ITEM_SET)
//STRIP001 					{
//STRIP001 					   presentation::FadeEffect eOldEffect = pPage->GetFadeEffect();
//STRIP001 					   presentation::FadeEffect eNewEffect = (presentation::FadeEffect)((const DiaEffectItem&)
//STRIP001 												   aSet.Get(ATTR_DIA_EFFECT)).
//STRIP001 													   GetValue();
//STRIP001 
//STRIP001 						pPage->SetFadeEffect((presentation::FadeEffect)((const DiaEffectItem&)
//STRIP001 								aSet.Get(ATTR_DIA_EFFECT)).GetValue());
//STRIP001 
//STRIP001 						// ist es eine Aenderung und kann man sie sehen?
//STRIP001 						if (((eOldEffect != presentation::FadeEffect_NONE &&
//STRIP001 							  eNewEffect == presentation::FadeEffect_NONE)	  ||
//STRIP001 							 (eOldEffect == presentation::FadeEffect_NONE &&
//STRIP001 							  eNewEffect != presentation::FadeEffect_NONE))	 &&
//STRIP001 							(this->ISA(SdSlideViewShell)))
//STRIP001 						{
//STRIP001 							pView->InvalidateAllWin(((SdSlideView*)pView)->
//STRIP001 														  GetFadeIconArea(nPage));
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 					if (aSet.GetItemState(ATTR_DIA_SPEED) == SFX_ITEM_SET)
//STRIP001 						pPage->SetFadeSpeed((FadeSpeed)((const DiaSpeedItem&)
//STRIP001 								aSet.Get(ATTR_DIA_SPEED)).GetValue());
//STRIP001 
//STRIP001 					if (aSet.GetItemState(ATTR_DIA_TIME) == SFX_ITEM_SET)
//STRIP001 						pPage->SetTime(((DiaTimeItem&)
//STRIP001 								aSet.Get(ATTR_DIA_TIME)).GetValue());
//STRIP001 
//STRIP001 					if (aSet.GetItemState(ATTR_DIA_AUTO) == SFX_ITEM_SET)
//STRIP001 						pPage->SetPresChange(((DiaAutoItem&)
//STRIP001 								aSet.Get(ATTR_DIA_AUTO)).GetValue());
//STRIP001 
//STRIP001 					if (aSet.GetItemState(ATTR_DIA_SOUND) == SFX_ITEM_SET)
//STRIP001 						pPage->SetSound(((SfxBoolItem&)
//STRIP001 								aSet.Get(ATTR_DIA_SOUND)).GetValue());
//STRIP001 
//STRIP001 					if (aSet.GetItemState(ATTR_DIA_SOUNDFILE) == SFX_ITEM_SET)
//STRIP001 					{
//STRIP001 						String aTemp(((SfxStringItem&)aSet.Get(ATTR_DIA_SOUNDFILE)).GetValue());
//STRIP001 						pPage->SetSoundFile(aTemp);
//STRIP001 					}
//STRIP001 
//STRIP001 					// Undo-Action erzeugen und in Gruppe stellen
//STRIP001 					SdUndoAction* pUndoAction = new SlideParametersUndoAction
//STRIP001 									(pDoc, pPage,
//STRIP001 									 eOldFadeSpeed,  pPage->GetFadeSpeed(),
//STRIP001 									 eOldFadeEffect, pPage->GetFadeEffect(),
//STRIP001 									 eOldChange,	 pPage->GetPresChange(),
//STRIP001 									 nOldTime,		 pPage->GetTime(),
//STRIP001 									 bOldSoundOn,	 pPage->IsSoundOn(),
//STRIP001 									 aOldSoundFile,  pPage->GetSoundFile());
//STRIP001 					pUndoGroup->AddAction(pUndoAction);
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			// Undo Gruppe dem Undo Manager uebergeben
//STRIP001 			GetViewFrame()->GetObjectShell()->GetUndoManager()->
//STRIP001 						AddUndoAction(pUndoGroup);

			/***************************************************************
			|* ggfs. in Preview anzeigen
			\**************************************************************/
//STRIP001 			SfxChildWindow* pPreviewChildWindow =
//STRIP001 				GetViewFrame()->GetChildWindow(SdPreviewChildWindow::GetChildWindowId());
//STRIP001 			if (pPreviewChildWindow)
//STRIP001 			{
//STRIP001 				SdPreviewWin* pPreviewWin =
//STRIP001 					(SdPreviewWin*)pPreviewChildWindow->GetWindow();
//STRIP001 				if (pPreviewWin && pPreviewWin->GetDoc() == pDoc)
//STRIP001 				{
//STRIP001 					pPreviewWin->AnimatePage();
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 
//STRIP001 			static USHORT SidArray[] = {
//STRIP001 							SID_DIA_EFFECT,
//STRIP001 							SID_DIA_SPEED,
//STRIP001 							SID_DIA_AUTO,
//STRIP001 							SID_DIA_TIME,
//STRIP001 							0 };
//STRIP001 
//STRIP001 			GetViewFrame()->GetBindings().Invalidate( SidArray );
//STRIP001 
//STRIP001 			// Model geaendert
//STRIP001 			pDoc->SetChanged();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* aktuellen Drucker des Dokuments zurueckgeben
|*
\************************************************************************/
/*N*/ SfxPrinter* SdViewShell::GetPrinter(BOOL bCreate)
/*N*/ {
/*N*/ 	return ( pDocSh->GetPrinter(bCreate) );
/*N*/ }

/*************************************************************************
|*
|* neuen Drucker fuer die Applikation setzen
|*
\************************************************************************/
//STRIP001 USHORT  SdViewShell::SetPrinter(SfxPrinter* pNewPrinter,
//STRIP001 				USHORT nDiffFlags)
//STRIP001 {
//STRIP001 	return SetPrinterOptDlg(pNewPrinter,nDiffFlags);
//STRIP001 }

//STRIP001 USHORT SdViewShell::SetPrinterOptDlg(SfxPrinter* pNewPrinter,
//STRIP001 				 USHORT nDiffFlags,
//STRIP001 				BOOL _bShowDialog )
//STRIP001 {
//STRIP001 	pDocSh->SetPrinter(pNewPrinter);
//STRIP001 
//STRIP001 	if ( (nDiffFlags & SFX_PRINTER_CHG_ORIENTATION ||
//STRIP001 		  nDiffFlags & SFX_PRINTER_CHG_SIZE) && pNewPrinter  )
//STRIP001 	{
//STRIP001 		MapMode aMap = pNewPrinter->GetMapMode();
//STRIP001 		aMap.SetMapUnit(MAP_100TH_MM);
//STRIP001 		MapMode aOldMap = pNewPrinter->GetMapMode();
//STRIP001 		pNewPrinter->SetMapMode(aMap);
//STRIP001 		Size aNewSize = pNewPrinter->GetOutputSize();
//STRIP001 
//STRIP001 		BOOL bScaleAll = FALSE;
//STRIP001 		if ( _bShowDialog )
//STRIP001 		{
//STRIP001 			WarningBox aWarnBox(pWindow, (WinBits)(WB_YES_NO | WB_DEF_YES),
//STRIP001 							String(SdResId(STR_SCALE_OBJS_TO_PAGE)));
//STRIP001 			bScaleAll = (aWarnBox.Execute() == RET_YES);
//STRIP001 		}
//STRIP001 
//STRIP001 		if( this->ISA( SdDrawViewShell ) )
//STRIP001 		{
//STRIP001 			SdPage* pPage = pDoc->GetSdPage( 0, PK_STANDARD );
//STRIP001 			SetPageSizeAndBorder( ( (SdDrawViewShell*)this )->GetPageKind(),
//STRIP001 						aNewSize, -1,-1,-1,-1, bScaleAll,
//STRIP001 						pNewPrinter->GetOrientation(), pPage->GetPaperBin(), pPage->IsBackgroundFullSize() );
//STRIP001 		}
//STRIP001 
//STRIP001 		pNewPrinter->SetMapMode(aOldMap);
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

/*************************************************************************
|*
|* Druckdialog erzeugen; virtuell, wird vom SFX aufgerufen
|*
\************************************************************************/
//STRIP001 PrintDialog*  SdViewShell::CreatePrintDialog(Window *pParent)
//STRIP001 {
//STRIP001 	PrintDialog* pDlg;
//STRIP001 
//STRIP001 	pDlg = new PrintDialog(pParent );
//STRIP001 
//STRIP001 	if( !this->ISA( SdOutlineViewShell ) )
//STRIP001 	{
//STRIP001 
//STRIP001 		if( this->ISA( SdDrawViewShell ) )
//STRIP001 		{
//STRIP001 			pDlg->SetRangeText( UniString::CreateFromInt32(( (SdDrawViewShell*)this )->GetCurPageId() ));
//STRIP001 		}
//STRIP001 		else //if( this->ISA( SdSlideViewShell ) )
//STRIP001 		{
//STRIP001 			String aStrRange( ( (SdSlideViewShell*)this )->GetPageRangeString() );
//STRIP001 			if( aStrRange.Len() )
//STRIP001 			{
//STRIP001 				pDlg->SetRangeText( aStrRange );
//STRIP001 				// According #79749 always check PRINTDIALOG_ALL
//STRIP001 				// pDlg->CheckRange( PRINTDIALOG_RANGE );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		String aStrRange( ( (SdOutlineViewShell*)this)->GetPageRangeString() );
//STRIP001 		if( aStrRange.Len() )
//STRIP001 		{
//STRIP001 			pDlg->SetRangeText( aStrRange );
//STRIP001 			// According #79749 always check PRINTDIALOG_ALL
//STRIP001 			// pDlg->CheckRange( PRINTDIALOG_RANGE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	pDlg->EnableRange( PRINTDIALOG_RANGE );
//STRIP001 	pDlg->EnableRange( PRINTDIALOG_ALL );
//STRIP001 	pDlg->EnableCollate();
//STRIP001 
//STRIP001 	if( this->ISA( SdDrawViewShell ) && pView->HasMarkedObj() )
//STRIP001 	{
//STRIP001 		pDlg->EnableRange( PRINTDIALOG_SELECTION );
//STRIP001 		// According #79749 always check PRINTDIALOG_ALL
//STRIP001 		// pDlg->CheckRange( PRINTDIALOG_SELECTION );
//STRIP001 	}
//STRIP001 
//STRIP001 	return pDlg;
//STRIP001 }

/*************************************************************************
|*
|* Factory Methode Tabpage Zusaetze (vom Druckdialog)
|*
\************************************************************************/
//STRIP001 SfxTabPage*  SdViewShell::CreatePrintOptionsPage( Window *pParent,
//STRIP001 												 const SfxItemSet &rOptions )
//STRIP001 {
//STRIP001     DocumentType eDocType = pDoc->GetDocumentType();
//STRIP001     SdPrintOptions* pPage = new SdPrintOptions( pParent, rOptions );
//STRIP001     if( eDocType == DOCUMENT_TYPE_DRAW )
//STRIP001         pPage->SetDrawMode();
//STRIP001 	return( pPage );
//STRIP001 }


/*************************************************************************
|*
|* Vorbereitung fuers Drucken; virtuell, wird vom SFX aufgerufen
|*
\************************************************************************/
//STRIP001 void SdViewShell::PreparePrint(PrintDialog* pPrintDialog)
//STRIP001 {
//STRIP001 	SfxPrinter* pPrinter = GetPrinter(TRUE);
//STRIP001 
//STRIP001 	if (!pPrinter)
//STRIP001 		return;
//STRIP001 
//STRIP001 	const SfxItemSet& rOptions = pPrinter->GetOptions();
//STRIP001 	SdOptionsPrintItem* pPrintOpts = NULL;
//STRIP001 
//STRIP001 	if (rOptions.GetItemState( ATTR_OPTIONS_PRINT, FALSE,
//STRIP001 		(const SfxPoolItem**) &pPrintOpts) != SFX_ITEM_SET)
//STRIP001 	{
//STRIP001 		pPrintOpts = NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Einstellungen der ersten zu druckenden Seite setzen
//STRIP001 
//STRIP001 	if (pPrintOpts)
//STRIP001 	{
//STRIP001 		if ( pPrintOpts->IsHandout() )
//STRIP001 		{
//STRIP001 			// Handzettel
//STRIP001 			SdPage* pPage = pDoc->GetSdPage(0, PK_HANDOUT);
//STRIP001 
//STRIP001 			// Papierschacht
//STRIP001 			if (!pPrintOpts->IsPaperbin()) // Drucken NICHT aus Druckereinstellung
//STRIP001 			{
//STRIP001 				pPrinter->SetPaperBin(pPage->GetPaperBin());
//STRIP001 			}
//STRIP001 
//STRIP001 			SdPage* pMaster = (SdPage*) pPage->GetMasterPage(0);
//STRIP001 			pPrinter->SetOrientation(pMaster->GetOrientation());
//STRIP001 		}
//STRIP001 		else if ( pPrintOpts->IsDraw() || pPrintOpts->IsNotes() )
//STRIP001 		{
//STRIP001 			// Standard- oder Notizseiten
//STRIP001 			if( !pPrintOpts->IsPaperbin() ) // Drucken NICHT aus Druckereinstellung
//STRIP001 			{
//STRIP001 				PageKind ePageKind = PK_NOTES;
//STRIP001 
//STRIP001 				if (pPrintOpts->IsDraw())
//STRIP001 				{
//STRIP001 					ePageKind = PK_STANDARD;
//STRIP001 				}
//STRIP001 
//STRIP001 				SdPage* pPage = pDoc->GetSdPage(0, ePageKind);
//STRIP001 				pPrinter->SetPaperBin(pPage->GetPaperBin());
//STRIP001 
//STRIP001 				Orientation eOrientation = ORIENTATION_PORTRAIT;
//STRIP001 
//STRIP001 				if ( !pPrintOpts->IsBooklet() )
//STRIP001 				{
//STRIP001 					eOrientation = pPage->GetOrientation();
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					Size aPageSize(pPage->GetSize());
//STRIP001 
//STRIP001 					if( aPageSize.Width() < aPageSize.Height() )
//STRIP001 						eOrientation = ORIENTATION_LANDSCAPE;
//STRIP001 				}
//STRIP001 
//STRIP001 				pPrinter->SetOrientation(eOrientation);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


/*************************************************************************
|*
|* Drucken; virtuell, wird vom SFX aufgerufen
|*
\************************************************************************/

//STRIP001 ErrCode SdViewShell::DoPrint( SfxPrinter *pPrinter, PrintDialog *pPrintDialog, BOOL bSilent )
//STRIP001 {
//STRIP001 	const SdrMarkList& rMarkList = pView->GetMarkList();
//STRIP001 
//STRIP001 	// retrieve range of marked pages if we are in the slideview
//STRIP001 	String sNewPageRange;
//STRIP001 	if( ISA( SdSlideViewShell ) )
//STRIP001 		sNewPageRange = ((SdSlideViewShell*)this)->GetPageRangeString();
//STRIP001 
//STRIP001 	// retrieve range of marked pages if we are in the outlineview
//STRIP001 	if( ISA( SdOutlineViewShell ) )
//STRIP001 		sNewPageRange = ((SdOutlineViewShell*)this)->GetPageRangeString();
//STRIP001 
//STRIP001 	bPrintDirectSelected = FALSE;
//STRIP001 
//STRIP001     // #105477# Don't show query dialog if print dialog has been shown
//STRIP001 	if ( !pPrintDialog && !bSilent && 
//STRIP001          (rMarkList.GetMarkCount() || sNewPageRange.Len()) )
//STRIP001 	{
//STRIP001 		SvxPrtQryBox aQuery( pWindow );
//STRIP001 		short nBtn = aQuery.Execute();
//STRIP001 
//STRIP001 		if ( nBtn == RET_CANCEL )
//STRIP001 			return ERRCODE_IO_ABORT;
//STRIP001 
//STRIP001 		if ( nBtn == RET_OK )
//STRIP001 		{
//STRIP001 			bPrintDirectSelected = TRUE;
//STRIP001 
//STRIP001 			sPageRange.Erase();
//STRIP001 			if( sNewPageRange.Len() )
//STRIP001 				sPageRange = sNewPageRange;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	FuSlideShow *pShow = pFuSlideShow;
//STRIP001 
//STRIP001     // Tell the printer which digit language to use.
//STRIP001     if (mpWindowUpdater.get() != NULL)
//STRIP001         mpWindowUpdater->Update (pPrinter, pDoc);
//STRIP001 
//STRIP001 	//	SfxViewShell::DoPrint calls Print (after StartJob etc.)
//STRIP001 	ErrCode nRet = SfxViewShell::DoPrint( pPrinter, pPrintDialog, bSilent );
//STRIP001 
//STRIP001 	bPrintDirectSelected = FALSE;
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }

//STRIP001 USHORT  SdViewShell::Print(SfxProgress& rProgress, PrintDialog* pDlg)
//STRIP001 {
//STRIP001 	SfxPrinter* pPrinter = GetPrinter(TRUE);
//STRIP001 
//STRIP001 	if( pPrinter )
//STRIP001     {
//STRIP001 	    const PrinterOptions    aOldPrinterOptions( pPrinter->GetPrinterOptions() );
//STRIP001         MapMode                 aMap( pPrinter->GetMapMode() );
//STRIP001 	    const MapMode           aOldMap( aMap );
//STRIP001 	    USHORT                  nOldPaperBin = pPrinter->GetPaperBin();
//STRIP001 
//STRIP001         aMap.SetMapUnit(MAP_100TH_MM);
//STRIP001 	    pPrinter->SetMapMode(aMap);
//STRIP001 
//STRIP001 	    Outliner& rOutliner = pDoc->GetDrawOutliner();
//STRIP001 	    ULONG nOldCntrl = rOutliner.GetControlWord();
//STRIP001 	    ULONG nCntrl = nOldCntrl;
//STRIP001 	    nCntrl |= EE_CNTRL_NOREDLINES;
//STRIP001 	    nCntrl &= ~EE_CNTRL_MARKFIELDS;
//STRIP001 	    nCntrl &= ~EE_CNTRL_ONLINESPELLING;
//STRIP001 	    rOutliner.SetControlWord( nCntrl );
//STRIP001 
//STRIP001 	    // Pruefen des Seitenformates und ggfs. Dialog hochbringen
//STRIP001 	    const SfxItemSet&	rOptions = pPrinter->GetOptions();
//STRIP001 	    SdOptionsPrintItem* pPrintOpts = NULL;
//STRIP001 	    BOOL                bScalePage = TRUE;
//STRIP001 	    BOOL                bTilePage = FALSE;
//STRIP001 	    BOOL                bPrintBooklet = FALSE;
//STRIP001 
//STRIP001 	    if( rOptions.GetItemState( ATTR_OPTIONS_PRINT, FALSE, (const SfxPoolItem**) &pPrintOpts ) == SFX_ITEM_SET )
//STRIP001 	    {
//STRIP001 		    bScalePage = pPrintOpts->IsPagesize();
//STRIP001 		    bPrintBooklet = pPrintOpts->IsBooklet();
//STRIP001 		    pPrintOpts->SetCutPage( FALSE );
//STRIP001 	    }
//STRIP001 	    else
//STRIP001 		    pPrintOpts = NULL;
//STRIP001 
//STRIP001 	    SdPage* pPage = pDoc->GetSdPage( 0, PK_STANDARD );
//STRIP001 	    Size    aPageSize( pPage->GetSize() );
//STRIP001 	    Size    aPrintSize( pPrinter->GetOutputSize() );
//STRIP001 	    long    nPageWidth = aPageSize.Width() - pPage->GetLftBorder() - pPage->GetRgtBorder();
//STRIP001 	    long    nPageHeight = aPageSize.Height() - pPage->GetUppBorder() - pPage->GetLwrBorder();
//STRIP001 	    long    nPrintWidth = aPrintSize.Width();
//STRIP001 	    long    nPrintHeight = aPrintSize.Height();
//STRIP001 	    USHORT  nRet = RET_OK;
//STRIP001 
//STRIP001         if( !bScalePage && !bTilePage && !bPrintBooklet &&
//STRIP001 		    ( ( nPageWidth > nPrintWidth || nPageHeight > nPrintHeight ) &&
//STRIP001               ( nPageWidth > nPrintHeight || nPageHeight > nPrintWidth ) ) )
//STRIP001 	    {
//STRIP001 		    SdPrintDlg aDlg( pWindow );
//STRIP001 		    nRet = aDlg.Execute();
//STRIP001 		    if( nRet == RET_OK )
//STRIP001 		    {
//STRIP001 			    USHORT nOption = aDlg.GetAttr();
//STRIP001 
//STRIP001 			    if( nOption == 1 )
//STRIP001 				    pPrintOpts->SetPagesize();
//STRIP001 
//STRIP001 			    // ( nOption == 2 ) ist der Default
//STRIP001 
//STRIP001 			    if( nOption == 3 )
//STRIP001 				    pPrintOpts->SetCutPage();
//STRIP001 		    }
//STRIP001 	    }
//STRIP001 
//STRIP001         if( nRet == RET_CANCEL )
//STRIP001 	    {
//STRIP001             pPrinter->SetPrinterOptions( aOldPrinterOptions );
//STRIP001 		    pPrinter->SetMapMode( aOldMap );
//STRIP001 		    return 0;
//STRIP001 	    }
//STRIP001 
//STRIP001 	    // Wenn wir im Gliederungsmodus sind, muss das Model auf Stand gebracht werden
//STRIP001 	    if( this->ISA( SdOutlineViewShell ) )
//STRIP001 		    ( (SdOutlineViewShell*)this )->PrepareClose(FALSE, FALSE);
//STRIP001 
//STRIP001 	    // Basisklasse rufen, um Basic anzusprechen
//STRIP001 	    SfxViewShell::Print( rProgress, pDlg );
//STRIP001 
//STRIP001 	    // Setzen des Textes des Druckmonitors
//STRIP001 	    rProgress.SetText( String( SdResId( STR_STATSTR_PRINT ) ) );
//STRIP001 
//STRIP001 	    PrintDialogRange	eOption;
//STRIP001 	    MultiSelection		aPrintSelection;
//STRIP001 	    String		        aTimeDateStr;
//STRIP001 	    Font		        aTimeDateFont(FAMILY_SWISS, Size(0, 423));
//STRIP001 	    PageKind	        ePageKind = PK_STANDARD;
//STRIP001 	    USHORT		        nPage, nPageMax;
//STRIP001 	    USHORT		        nTotal, nCopies;
//STRIP001 	    USHORT		        nPrintCount = 0;
//STRIP001 	    USHORT		        nProgressOffset = 0;
//STRIP001 	    USHORT		        nCollateCopies = 1;
//STRIP001 	    BOOL		        bPrintMarkedOnly = FALSE;
//STRIP001 	    BOOL		        bPrintOutline = FALSE;
//STRIP001 	    BOOL		        bPrintHandout = FALSE;
//STRIP001 	    BOOL		        bPrintDraw = FALSE;
//STRIP001 	    BOOL		        bPrintNotes = FALSE;
//STRIP001 
//STRIP001 	    Orientation eOldOrientation = pPrinter->GetOrientation();
//STRIP001 
//STRIP001 	    if( pPrintOpts )
//STRIP001 	    {
//STRIP001             SfxMiscCfg* pMisc = SFX_APP()->GetMiscConfig();
//STRIP001 
//STRIP001 		    if( pPrintOpts->IsDate() )
//STRIP001 		    {
//STRIP001 			    aTimeDateStr += GetSdrGlobalData().pLocaleData->getDate( Date() );
//STRIP001 			    aTimeDateStr += (sal_Unicode)' ';
//STRIP001 		    }
//STRIP001 
//STRIP001 		    if( pPrintOpts->IsTime() )
//STRIP001 			    aTimeDateStr += GetSdrGlobalData().pLocaleData->getTime( Time(), FALSE, FALSE );
//STRIP001 
//STRIP001 		    if( pPrintOpts->IsOutline() )
//STRIP001 			    bPrintOutline = TRUE;
//STRIP001 
//STRIP001             if( pPrintOpts->IsHandout() )
//STRIP001 			    bPrintHandout = TRUE;
//STRIP001 
//STRIP001             if( pPrintOpts->IsDraw() )
//STRIP001 			    bPrintDraw = TRUE;
//STRIP001 
//STRIP001             if( pPrintOpts->IsNotes() )
//STRIP001 		    {
//STRIP001 			    bPrintNotes = TRUE;
//STRIP001 			    ePageKind = PK_NOTES;
//STRIP001 		    }
//STRIP001 
//STRIP001 		    pPrintOpts->SetWarningPrinter( pMisc->IsNotFoundWarning() );
//STRIP001 		    pPrintOpts->SetWarningSize( pMisc->IsPaperSizeWarning() );
//STRIP001             pPrintOpts->SetWarningOrientation( pMisc->IsPaperOrientationWarning() );
//STRIP001 
//STRIP001 		    UINT16  nQuality = pPrintOpts->GetOutputQuality();
//STRIP001 		    ULONG   nMode = DRAWMODE_DEFAULT;
//STRIP001 
//STRIP001 		    if( nQuality == 1 )
//STRIP001 			    nMode = DRAWMODE_GRAYLINE | DRAWMODE_GRAYFILL | DRAWMODE_BLACKTEXT | DRAWMODE_GRAYBITMAP | DRAWMODE_GRAYGRADIENT;
//STRIP001 		    else if( nQuality == 2 )
//STRIP001 			    nMode = DRAWMODE_BLACKLINE | DRAWMODE_BLACKTEXT | DRAWMODE_WHITEFILL | DRAWMODE_GRAYBITMAP | DRAWMODE_WHITEGRADIENT;
//STRIP001 
//STRIP001 		    pPrinter->SetDrawMode( nMode );
//STRIP001 	    }
//STRIP001 	    else
//STRIP001 		    bPrintDraw = TRUE;
//STRIP001 
//STRIP001 	    if( pDlg )
//STRIP001 	    {
//STRIP001 		    eOption = pDlg->GetCheckedRange();
//STRIP001 
//STRIP001             if( eOption == PRINTDIALOG_SELECTION )
//STRIP001 			    bPrintMarkedOnly = TRUE;
//STRIP001 	    }
//STRIP001 	    else
//STRIP001 		    // Bei PrintDirect wird gesamtes Dokument gedruckt
//STRIP001 		    eOption = PRINTDIALOG_ALL;
//STRIP001 
//STRIP001 	    // #72527 If we are in PrintDirect and any objects
//STRIP001 	    // are selected, then a dialog (see SdViewShell::DoPrint)
//STRIP001 	    // ask whether the total document should be printed
//STRIP001 	    // or only the selected objects. If only the selected
//STRIP001 	    // object, then the flag bPrintDirectSelected is TRUE
//STRIP001 	    if( bPrintDirectSelected )
//STRIP001 	    {
//STRIP001 		    eOption = PRINTDIALOG_SELECTION;
//STRIP001 		    bPrintMarkedOnly = TRUE;
//STRIP001 	    }
//STRIP001 
//STRIP001 	    nPageMax = pDoc->GetSdPageCount( ePageKind );
//STRIP001 	    aPrintSelection.SetTotalRange( Range( 1, nPageMax ) );
//STRIP001 
//STRIP001 	    switch( eOption )
//STRIP001 	    {
//STRIP001 		    case PRINTDIALOG_ALL:
//STRIP001 			    aPrintSelection.Select(Range(1, nPageMax));
//STRIP001 		    break;
//STRIP001 
//STRIP001 		    case PRINTDIALOG_RANGE:
//STRIP001 			    aPrintSelection = MultiSelection(pDlg->GetRangeText());
//STRIP001 		    break;
//STRIP001 
//STRIP001 		    default:
//STRIP001             {
//STRIP001 			    if( this->ISA( SdDrawViewShell ) )
//STRIP001 				    aPrintSelection.Select( ( (SdDrawViewShell*)this )->GetCurPageId() );
//STRIP001 			    else
//STRIP001 			    {
//STRIP001 				    if( sPageRange.Len() )
//STRIP001 					    aPrintSelection = MultiSelection( sPageRange );
//STRIP001 				    else
//STRIP001 					    aPrintSelection.Select(Range(1, nPageMax));
//STRIP001 			    }
//STRIP001             }
//STRIP001 		    break;
//STRIP001 	    }
//STRIP001 
//STRIP001         nPage = Min(nPageMax, (USHORT) aPrintSelection.FirstSelected());
//STRIP001 
//STRIP001         if ( nPage > 0 )
//STRIP001 		    nPage--;
//STRIP001 
//STRIP001         nPageMax = Min(nPageMax, (USHORT) aPrintSelection.LastSelected());
//STRIP001 
//STRIP001 	    if( bPrintOutline )
//STRIP001 		    nPrintCount++;
//STRIP001 
//STRIP001         if( bPrintHandout )
//STRIP001 		    nPrintCount++;
//STRIP001 
//STRIP001         if( bPrintDraw )
//STRIP001 		    nPrintCount++;
//STRIP001 
//STRIP001         if( bPrintNotes )
//STRIP001 		    nPrintCount++;
//STRIP001 
//STRIP001 	    nCopies = (pDlg ? pDlg->GetCopyCount() : 1);
//STRIP001 
//STRIP001 	    USHORT nSelectCount = (USHORT) aPrintSelection.GetSelectCount();
//STRIP001 	    nTotal = nSelectCount * nCopies * nPrintCount;
//STRIP001 
//STRIP001 	    if( pDlg && pDlg->IsCollateEnabled() && pDlg->IsCollateChecked() )
//STRIP001 		    nCollateCopies = nCopies;
//STRIP001 
//STRIP001 	    // check if selected range of pages contains transparent objects
//STRIP001 	    BOOL bContainsTransparency = FALSE;
//STRIP001 	    BOOL bPrintExcluded = TRUE;
//STRIP001 
//STRIP001 	    if( bPrintNotes || bPrintDraw || bPrintHandout )
//STRIP001 	    {
//STRIP001 		    if( pPrintOpts )
//STRIP001 			    bPrintExcluded = pPrintOpts->IsHiddenPages();
//STRIP001 
//STRIP001 		    for( USHORT j = nPage; ( j < nPageMax && !bContainsTransparency ); j++ )
//STRIP001 		    {
//STRIP001 			    if( aPrintSelection.IsSelected( j + 1 ) )
//STRIP001 			    {
//STRIP001 				    SdPage* pPage = pDoc->GetSdPage( j, PK_STANDARD );
//STRIP001 
//STRIP001 				    if( pPage && ( !pPage->IsExcluded() || bPrintExcluded ) )
//STRIP001 				    {
//STRIP001 					    if( !( bContainsTransparency = pPage->HasTransparentObjects() ) )
//STRIP001 					    {
//STRIP001 						    SdPage* pMaster = (SdPage*) pPage->GetMasterPage( 0 );
//STRIP001 
//STRIP001 						    if( pMaster )
//STRIP001 							    bContainsTransparency = pMaster->HasTransparentObjects();
//STRIP001 					    }
//STRIP001 				    }
//STRIP001 			    }
//STRIP001 		    }
//STRIP001 	    }
//STRIP001 
//STRIP001         if( pPrinter->InitJob( pWindow, bContainsTransparency ) )
//STRIP001         {
//STRIP001 	        for( USHORT n = 1; n <= nCollateCopies; n++ )
//STRIP001 	        {
//STRIP001 		        if ( bPrintOutline )
//STRIP001 		        {
//STRIP001 			        // siehe unten in PrintOutline()
//STRIP001 			        pPrinter->SetPaperBin( nOldPaperBin );
//STRIP001 
//STRIP001 			        PrintOutline(*pPrinter, rProgress, aPrintSelection,
//STRIP001 						          aTimeDateStr, aTimeDateFont, pPrintOpts,
//STRIP001 						          nPage, nPageMax,
//STRIP001 						          nCollateCopies > 1 ? 1 : nCopies,
//STRIP001 						          nProgressOffset, nTotal );
//STRIP001 			        nProgressOffset += ( nSelectCount * ( nCollateCopies > 1 ? 1 : nCopies) );
//STRIP001 		        }
//STRIP001 
//STRIP001 		        if ( bPrintHandout )
//STRIP001 		        {
//STRIP001 			        PrintHandout(*pPrinter, rProgress, aPrintSelection,
//STRIP001 						          aTimeDateStr, aTimeDateFont, pPrintOpts,
//STRIP001 						          nPage, nPageMax,
//STRIP001 						          nCollateCopies > 1 ? 1 : nCopies,
//STRIP001 						          nProgressOffset, nTotal );
//STRIP001 			        nProgressOffset += ( nSelectCount * ( nCollateCopies > 1 ? 1 : nCopies) );
//STRIP001 		        }
//STRIP001 		        if( bPrintDraw )
//STRIP001 		        {
//STRIP001 			        PrintStdOrNotes(*pPrinter, rProgress, aPrintSelection,
//STRIP001 							         aTimeDateStr, aTimeDateFont, pPrintOpts,
//STRIP001 							         nPage, nPageMax,
//STRIP001 							         nCollateCopies > 1 ? 1 : nCopies,
//STRIP001 							         nProgressOffset, nTotal,
//STRIP001 							         PK_STANDARD, bPrintMarkedOnly);
//STRIP001 			        nProgressOffset += ( nSelectCount * ( nCollateCopies > 1 ? 1 : nCopies) );
//STRIP001 		        }
//STRIP001 		        if( bPrintNotes )
//STRIP001 		        {
//STRIP001 			        PrintStdOrNotes(*pPrinter, rProgress, aPrintSelection,
//STRIP001 							         aTimeDateStr, aTimeDateFont, pPrintOpts,
//STRIP001 							         nPage, nPageMax,
//STRIP001 							         nCollateCopies > 1 ? 1 : nCopies,
//STRIP001 							         nProgressOffset, nTotal,
//STRIP001 							         PK_NOTES, FALSE);
//STRIP001 			        nProgressOffset += ( nSelectCount * ( nCollateCopies > 1 ? 1 : nCopies) );
//STRIP001 		        }
//STRIP001 	        }
//STRIP001         }
//STRIP001 
//STRIP001 	    pPrinter->SetOrientation( eOldOrientation );
//STRIP001         pPrinter->SetPrinterOptions( aOldPrinterOptions );
//STRIP001 	    pPrinter->SetMapMode( aOldMap );
//STRIP001 
//STRIP001 	    rOutliner.SetControlWord(nOldCntrl);
//STRIP001 
//STRIP001 	    // Druckerschach wieder zuruecksetzen
//STRIP001 	    pPrinter->SetPaperBin( nOldPaperBin );
//STRIP001 
//STRIP001 	    // 3D-Kontext wieder zerstoeren
//STRIP001 	    Base3D *pBase3D = (Base3D*) pPrinter->Get3DContext();
//STRIP001 
//STRIP001         if( pBase3D )
//STRIP001 		    pBase3D->Destroy( pPrinter );
//STRIP001     }
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

/*************************************************************************
|*
|* Drucken der Outlinerdaten
|*
\************************************************************************/
//STRIP001 void SdViewShell::PrintOutline(SfxPrinter& rPrinter,
//STRIP001 							   SfxProgress& rProgress,
//STRIP001 							   const MultiSelection& rSelPages,
//STRIP001 							   const String& rTimeDateStr,
//STRIP001 							   const Font& rTimeDateFont,
//STRIP001 							   const SdOptionsPrintItem* pPrintOpts,
//STRIP001 							   USHORT nPage, USHORT nPageMax,
//STRIP001 							   USHORT nCopies, USHORT nProgressOffset, USHORT nTotal )
//STRIP001 {
//STRIP001 	// Papierschacht
//STRIP001 	// Seiteneinstellungen koennen nicht fuer die Gliederung gemacht werden
//STRIP001 	// (also auch nicht der Druckerschacht), deswegen wird der Druckerschacht
//STRIP001 	// von der Seite PK_STANDARD genommen.
	/*
	if( pPrintOpts && !pPrintOpts->IsPaperbin() ) // Drucken NICHT aus Druckereinstellung
	{
		USHORT nPaperBin = pDoc->GetSdPage(nPage, PK_STANDARD)->GetPaperBin();
		rPrinter.SetPaperBin( nPaperBin );
	} */
//STRIP001 	// Es wird jetzt (vorlaeufig ?) der Druckerschacht vom Drucker genommen
//STRIP001 
//STRIP001     const MapMode       aOldMap( rPrinter.GetMapMode() );
//STRIP001 	MapMode             aMap( aOldMap );
//STRIP001 	const Orientation   eOldOrient = rPrinter.GetOrientation();
//STRIP001 	Point               aPageOfs( rPrinter.GetPageOffset() );
//STRIP001 	Fraction            aScale(1, 2);
//STRIP001 	BOOL                bPrintExcluded = TRUE;
//STRIP001 
//STRIP001     aMap.SetOrigin(Point() - aPageOfs);
//STRIP001 	aMap.SetScaleX(aScale);
//STRIP001 	aMap.SetScaleY(aScale);
//STRIP001 	rPrinter.SetMapMode(aMap);
//STRIP001 	rPrinter.SetOrientation(ORIENTATION_PORTRAIT);
//STRIP001 
//STRIP001 	if ( pPrintOpts )
//STRIP001 		bPrintExcluded = pPrintOpts->IsHiddenPages();
//STRIP001 
//STRIP001 	Rectangle aOutRect(aPageOfs, rPrinter.GetOutputSize());
//STRIP001 
//STRIP001 	Link aOldLink;
//STRIP001 	Outliner* pOutliner = pDoc->GetInternalOutliner();
//STRIP001 	pOutliner->Init( OUTLINERMODE_OUTLINEVIEW );
//STRIP001 	USHORT nOutlMode = pOutliner->GetMode();
//STRIP001 	BOOL bOldUpdateMode = pOutliner->GetUpdateMode();
//STRIP001 
//STRIP001 	if ( this->ISA( SdOutlineViewShell ) )
//STRIP001 		pOutliner->SetMinDepth(0);
//STRIP001 
//STRIP001 	Size aPaperSize = pOutliner->GetPaperSize();
//STRIP001 	pOutliner->SetPaperSize(aOutRect.GetSize());
//STRIP001 	pOutliner->SetUpdateMode(TRUE);
//STRIP001 
//STRIP001 	long nPageH = aOutRect.GetHeight();
//STRIP001 
//STRIP001 	USHORT nPageCount = nProgressOffset;
//STRIP001 
//STRIP001 	while ( nPage < nPageMax )
//STRIP001 	{
//STRIP001 		Paragraph* pPara = NULL;
//STRIP001 		long nH = 0;
//STRIP001 
//STRIP001 		pOutliner->Clear();
//STRIP001 		pOutliner->SetFirstPageNumber(nPage+1);
//STRIP001 
//STRIP001 		while ( nH < nPageH && nPage < nPageMax )
//STRIP001 		{
//STRIP001 			if ( rSelPages.IsSelected(nPage+1) )
//STRIP001 			{
//STRIP001 				//rProgress.SetState( nPageCount, nTotal );
//STRIP001 				//rProgress.SetStateText( nPageCount, nPage+1, nTotal );
//STRIP001 
//STRIP001 				String aTmp = UniString::CreateFromInt32( nPage+1 );
//STRIP001 				aTmp += String( SdResId( STR_PRINT_OUTLINE ) );
//STRIP001 				rProgress.SetStateText( nPageCount, aTmp, nTotal );
//STRIP001 
//STRIP001 				nPageCount += nCopies;
//STRIP001 
//STRIP001 				SdPage* pPage = (SdPage*)
//STRIP001 							pDoc->GetSdPage(nPage, PK_STANDARD);
//STRIP001 				SdrTextObj* pTextObj = NULL;
//STRIP001 				ULONG nObj = 0;
//STRIP001 
//STRIP001 				if ( !pPage->IsExcluded() || bPrintExcluded )
//STRIP001 				{
//STRIP001 					while ( !pTextObj && nObj < pPage->GetObjCount() )
//STRIP001 					{
//STRIP001 						SdrObject* pObj = pPage->GetObj(nObj++);
//STRIP001 						if ( pObj->GetObjInventor() == SdrInventor &&
//STRIP001 							 pObj->GetObjIdentifier() == OBJ_TITLETEXT )
//STRIP001 							pTextObj = (SdrTextObj*) pObj;
//STRIP001 					}
//STRIP001 
//STRIP001 					pPara = pOutliner->GetParagraph( pOutliner->GetParagraphCount() - 1 );
//STRIP001 
//STRIP001 					if ( pTextObj && !pTextObj->IsEmptyPresObj() &&
//STRIP001 							pTextObj->GetOutlinerParaObject() )
//STRIP001 						pOutliner->AddText( *(pTextObj->GetOutlinerParaObject()) );
//STRIP001 					else
//STRIP001 						pOutliner->Insert(String());
//STRIP001 
//STRIP001 					pTextObj = NULL;
//STRIP001 					nObj = 0;
//STRIP001 
//STRIP001 					while ( !pTextObj && nObj < pPage->GetObjCount() )
//STRIP001 					{
//STRIP001 						SdrObject* pObj = pPage->GetObj(nObj++);
//STRIP001 						if ( pObj->GetObjInventor() == SdrInventor &&
//STRIP001 							 pObj->GetObjIdentifier() == OBJ_OUTLINETEXT )
//STRIP001 							pTextObj = (SdrTextObj*) pObj;
//STRIP001 					}
//STRIP001 
//STRIP001 					BOOL bSubTitle = FALSE;
//STRIP001 					if (!pTextObj)
//STRIP001 					{
//STRIP001 						bSubTitle = TRUE;
//STRIP001 						pTextObj = (SdrTextObj*) pPage->GetPresObj(PRESOBJ_TEXT);  // Untertitel vorhanden?
//STRIP001 					}
//STRIP001 
//STRIP001 					ULONG nParaCount1 = pOutliner->GetParagraphCount();
//STRIP001 
//STRIP001 					if ( pTextObj && !pTextObj->IsEmptyPresObj() &&
//STRIP001 							pTextObj->GetOutlinerParaObject() )
//STRIP001 						pOutliner->AddText( *(pTextObj->GetOutlinerParaObject()) );
//STRIP001 
//STRIP001 					if ( bSubTitle )
//STRIP001 					{
//STRIP001 						ULONG nParaCount2 = pOutliner->GetParagraphCount();
//STRIP001 						Paragraph* pPara = NULL;
//STRIP001 						for (ULONG nPara = nParaCount1; nPara < nParaCount2; nPara++)
//STRIP001 						{
//STRIP001 							pPara = pOutliner->GetParagraph(nPara);
//STRIP001 							if(pPara && pOutliner->GetDepth( (USHORT) nPara ) !=1 )
//STRIP001 								pOutliner->SetDepth(pPara, 1);
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 					nH = pOutliner->GetTextHeight();
//STRIP001 				}
//STRIP001 			}
//STRIP001 			nPage++;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( nH > nPageH && pPara )
//STRIP001 		{
//STRIP001 			ULONG nCnt = pOutliner->GetAbsPos( pOutliner->GetParagraph( pOutliner->GetParagraphCount() - 1 ) );
//STRIP001 			ULONG nParaPos = pOutliner->GetAbsPos( pPara );
//STRIP001 			nCnt -= nParaPos;
//STRIP001 			pPara = pOutliner->GetParagraph( ++nParaPos );
//STRIP001 			if ( nCnt && pPara )
//STRIP001 			{
//STRIP001 				pOutliner->Remove(pPara, nCnt);
//STRIP001 				nPage--;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		rPrinter.StartPage();
//STRIP001 		pOutliner->Draw(&rPrinter, aOutRect);
//STRIP001 
//STRIP001 		if ( rTimeDateStr.Len() )
//STRIP001 		{
//STRIP001 			Font aOldFont = rPrinter.OutputDevice::GetFont();
//STRIP001 			rPrinter.SetFont(rTimeDateFont);
//STRIP001 			rPrinter.DrawText(aPageOfs, rTimeDateStr);
//STRIP001 			rPrinter.SetFont(aOldFont);
//STRIP001 		}
//STRIP001 		rPrinter.EndPage();
//STRIP001 	}
//STRIP001 	pOutliner->SetUpdateMode(bOldUpdateMode);
//STRIP001 	pOutliner->SetPaperSize(aPaperSize);
//STRIP001 	pOutliner->Init( nOutlMode );
//STRIP001 
//STRIP001     rPrinter.SetOrientation(eOldOrient);
//STRIP001     rPrinter.SetMapMode( aOldMap );
//STRIP001 }

/*************************************************************************
|*
|* Drucken der Handouts
|*
\************************************************************************/
//STRIP001 void SdViewShell::PrintHandout(SfxPrinter& rPrinter,
//STRIP001 								   SfxProgress& rProgress,
//STRIP001 								   const MultiSelection& rSelPages,
//STRIP001 								   const String& rTimeDateStr,
//STRIP001 								   const Font& rTimeDateFont,
//STRIP001 								   const SdOptionsPrintItem* pPrintOpts,
//STRIP001 								   USHORT nPage, USHORT nPageMax,
//STRIP001 								   USHORT nCopies, USHORT nProgressOffset, USHORT nTotal )
//STRIP001 {
//STRIP001 	SdrObject* pObj;
//STRIP001 	SdPage* pPage = pDoc->GetSdPage(0, PK_HANDOUT);
//STRIP001 	SdPage* pMaster = (SdPage*) pPage->GetMasterPage(0);
//STRIP001 
//STRIP001 	// Papierschacht
//STRIP001 	if( pPrintOpts && !pPrintOpts->IsPaperbin() ) // Drucken NICHT aus Druckereinstellung
//STRIP001 	{
//STRIP001 		USHORT nPaperBin = pPage->GetPaperBin();
//STRIP001 		rPrinter.SetPaperBin( nPaperBin );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Hoch/Querformat aendern?
//STRIP001 	Orientation eOrientation = pMaster->GetOrientation();
//STRIP001 
//STRIP001 	short nDlgResult = RET_OK;
//STRIP001 
//STRIP001 	if ( !rPrinter.SetOrientation(eOrientation) &&
//STRIP001 		(!pPrintOpts || pPrintOpts->IsWarningOrientation()) )
//STRIP001 	{
//STRIP001 		// eine Warnung anzeigen
//STRIP001 		WarningBox aWarnBox(pWindow,(WinBits)(WB_OK_CANCEL | WB_DEF_CANCEL),
//STRIP001 							String(SdResId(STR_WARN_PRINTFORMAT_FAILURE)));
//STRIP001 		nDlgResult = aWarnBox.Execute();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( nDlgResult == RET_OK )
//STRIP001 	{
//STRIP001 		const MapMode   aOldMap( rPrinter.GetMapMode() );
//STRIP001 		MapMode         aMap( aOldMap );
//STRIP001 		Point           aPageOfs( rPrinter.GetPageOffset() );
//STRIP001 		SdDrawView*     pPrintView;
//STRIP001 		BOOL            bPrintExcluded = TRUE;
//STRIP001 
//STRIP001         aMap.SetOrigin(Point() - aPageOfs);
//STRIP001 		rPrinter.SetMapMode(aMap);
//STRIP001 
//STRIP001 		if( this->ISA( SdDrawViewShell ) )
//STRIP001 			pPrintView = new SdDrawView( pDocSh, &rPrinter, (SdDrawViewShell*)this );
//STRIP001 		else
//STRIP001 			pPrintView = new SdDrawView( pDocSh, &rPrinter, NULL );
//STRIP001 
//STRIP001 		List*	pList = pMaster->GetPresObjList();
//STRIP001 		USHORT  nPageCount = nProgressOffset;
//STRIP001 
//STRIP001 		WriteFrameViewData();
//STRIP001 
//STRIP001 		nPrintedHandoutPageNum = 0;
//STRIP001 
//STRIP001         if ( pPrintOpts )
//STRIP001 			bPrintExcluded = pPrintOpts->IsHiddenPages();
//STRIP001 
//STRIP001 		while ( nPage < nPageMax )
//STRIP001 		{
//STRIP001 			pObj = (SdrObject*) pList->First();
//STRIP001 
//STRIP001 			// Anzahl ALLER Seiten im Dokument:
//STRIP001 			USHORT nAbsPageCnt = pDoc->GetPageCount();
//STRIP001 
//STRIP001 			while ( pObj && nPage < nPageMax )
//STRIP001 			{
//STRIP001 				if ( rSelPages.IsSelected(nPage+1) )
//STRIP001 				{
//STRIP001 					//rProgress.SetState( nPageCount, nTotal );
//STRIP001 					//rProgress.SetStateText( nPageCount, nPage+1, nTotal );
//STRIP001 
//STRIP001 					String aTmp = UniString::CreateFromInt32( nPage+1 );
//STRIP001 					aTmp += String( SdResId( STR_PRINT_HANDOUT ) );
//STRIP001 					rProgress.SetStateText( nPageCount, aTmp, nTotal );
//STRIP001 
//STRIP001 					nPageCount += nCopies;
//STRIP001 
//STRIP001 					SdPage* pPg = pDoc->GetSdPage(nPage, PK_STANDARD);
//STRIP001 					USHORT nRealPage = pPg->GetPageNum();
//STRIP001 
//STRIP001 					if ( !pPg->IsExcluded() || bPrintExcluded )
//STRIP001 					{
//STRIP001 						if ( pObj->ISA(SdrPageObj) )
//STRIP001 						{
//STRIP001 							((SdrPageObj*) pObj)->NbcSetPageNum(nRealPage);
//STRIP001 							pObj = (SdrObject*) pList->Next();
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 				nPage++;
//STRIP001 			}
//STRIP001 
//STRIP001 			while ( pObj )
//STRIP001 			{	// restliche SdrPageObjs durch Angabe einer
//STRIP001 				// ungueltigen Seitennummer ausblenden
//STRIP001 				if ( pObj->ISA(SdrPageObj) )
//STRIP001 					((SdrPageObj*) pObj)->NbcSetPageNum(nAbsPageCnt);
//STRIP001 				pObj = (SdrObject*) pList->Next();
//STRIP001 			}
//STRIP001 
//STRIP001 			nPrintedHandoutPageNum++;
//STRIP001 
//STRIP001 			rPrinter.StartPage();
//STRIP001 			pPrintView->ShowPage(pPage, Point());
//STRIP001 
//STRIP001 			SdrPageView* pPageView = pPrintView->GetPageView(pPage);
//STRIP001 			pPageView->SetVisibleLayers( pFrameView->GetVisibleLayers() );
//STRIP001 			pPageView->SetPrintableLayers( pFrameView->GetPrintableLayers() );
//STRIP001 
//STRIP001 			pPrintView->InitRedraw(&rPrinter, Rectangle(Point(0,0),
//STRIP001 								pPage->GetSize()));
//STRIP001 
//STRIP001 			if ( rTimeDateStr.Len() )
//STRIP001 			{
//STRIP001 				Font aOldFont = rPrinter.OutputDevice::GetFont();
//STRIP001 				rPrinter.SetFont(rTimeDateFont);
//STRIP001 				rPrinter.DrawText(aPageOfs, rTimeDateStr);
//STRIP001 				rPrinter.SetFont(aOldFont);
//STRIP001 			}
//STRIP001 			rPrinter.EndPage();
//STRIP001 			pPrintView->HidePage(pPrintView->GetPageView(pPage));
//STRIP001 		}
//STRIP001 
//STRIP001 		USHORT nRealPage = pDoc->GetSdPage(0, PK_STANDARD)->GetPageNum();
//STRIP001 		pObj = (SdrObject*) pList->First();
//STRIP001 
//STRIP001 		while ( pObj )
//STRIP001 		{	// Seitenobjekte wieder auf erste Seite setzen
//STRIP001 			if ( pObj->ISA(SdrPageObj) )
//STRIP001 			{
//STRIP001 				((SdrPageObj*) pObj)->NbcSetPageNum(nRealPage);
//STRIP001 				nRealPage += 2;
//STRIP001 			}
//STRIP001 
//STRIP001 			pObj = (SdrObject*) pList->Next();
//STRIP001 		}
//STRIP001 
//STRIP001 		nPrintedHandoutPageNum = 1;
//STRIP001 		delete pPrintView;
//STRIP001 		rPrinter.SetMapMode(aOldMap);
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Drucken der normalen Seiten oder der Notizseiten
|*
\************************************************************************/
//STRIP001 void SdViewShell::PrintStdOrNotes(SfxPrinter& rPrinter,
//STRIP001 									  SfxProgress& rProgress,
//STRIP001 									  const MultiSelection& rSelPages,
//STRIP001 									  const String& rTimeDateStr,
//STRIP001 									  const Font& rTimeDateFont,
//STRIP001 									  const SdOptionsPrintItem* pPrintOpts,
//STRIP001 									  USHORT nPage, USHORT nPageMax,
//STRIP001 									  USHORT nCopies, USHORT nProgressOffset, USHORT nTotal,
//STRIP001 									  PageKind ePageKind, BOOL bPrintMarkedOnly)
//STRIP001 {
//STRIP001 	Fraction	aFract;
//STRIP001 	BOOL		bScalePage = TRUE;
//STRIP001 	BOOL		bTilePage = FALSE;
//STRIP001 	BOOL		bPrintExcluded = TRUE;
//STRIP001 	BOOL		bPrintPageName = TRUE;
//STRIP001 	BOOL		bPrintBooklet  = FALSE;
//STRIP001 	BOOL		bPrintFrontPage = FALSE;
//STRIP001 	BOOL		bPrintBackPage = FALSE;
//STRIP001 
//STRIP001 	SdPage* pPage = pDoc->GetSdPage(nPage, ePageKind);
//STRIP001 
//STRIP001 	if ( pPrintOpts )
//STRIP001 	{
//STRIP001 		bScalePage = pPrintOpts->IsPagesize();
//STRIP001 		bTilePage = pPrintOpts->IsPagetile();
//STRIP001 		bPrintPageName = pPrintOpts->IsPagename();
//STRIP001 		bPrintExcluded = pPrintOpts->IsHiddenPages();
//STRIP001 		bPrintBooklet = pPrintOpts->IsBooklet();
//STRIP001 		bPrintFrontPage = pPrintOpts->IsFrontPage();
//STRIP001 		bPrintBackPage = pPrintOpts->IsBackPage();
//STRIP001 
//STRIP001 		// Papierschacht
//STRIP001 		if( !pPrintOpts->IsPaperbin() ) // Drucken NICHT aus Druckereinstellung
//STRIP001 		{
//STRIP001 			USHORT nPaperBin = pDoc->GetSdPage(nPage, ePageKind)->GetPaperBin();
//STRIP001 			rPrinter.SetPaperBin( nPaperBin );
//STRIP001 		}
//STRIP001 
//STRIP001 	}
//STRIP001 
//STRIP001 	// Hoch/Querformat aendern?
//STRIP001 	Size aPageSize(pPage->GetSize());
//STRIP001 	Orientation eOrientation = ORIENTATION_PORTRAIT;
//STRIP001 
//STRIP001 	short nDlgResult = RET_OK;
//STRIP001 
//STRIP001 	if( !bPrintBooklet )
//STRIP001 	{
//STRIP001 		eOrientation = pPage->GetOrientation();
//STRIP001 	}
//STRIP001 	else if( aPageSize.Width() < aPageSize.Height() )
//STRIP001         eOrientation = ORIENTATION_LANDSCAPE;
//STRIP001 
//STRIP001 	if ( !rPrinter.SetOrientation(eOrientation) &&
//STRIP001 		(!pPrintOpts || pPrintOpts->IsWarningOrientation()) )
//STRIP001 	{
//STRIP001 		// eine Warnung anzeigen
//STRIP001 		WarningBox aWarnBox(pWindow,(WinBits)(WB_OK_CANCEL | WB_DEF_CANCEL),
//STRIP001 							String(SdResId(STR_WARN_PRINTFORMAT_FAILURE)));
//STRIP001 		nDlgResult = aWarnBox.Execute();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( nDlgResult == RET_OK )
//STRIP001 	{
//STRIP001 		const MapMode   aOldMap( rPrinter.GetMapMode() );
//STRIP001 		MapMode         aMap( aOldMap );
//STRIP001 		Point           aPageOfs( rPrinter.GetPageOffset() );
//STRIP001 		SdDrawView*     pPrintView;
//STRIP001 
//STRIP001         aMap.SetOrigin(Point() - aPageOfs);
//STRIP001 		rPrinter.SetMapMode(aMap);
//STRIP001 		Size aPrintSize( rPrinter.GetOutputSize() );
//STRIP001 
//STRIP001 		if( this->ISA( SdDrawViewShell ) )
//STRIP001 			pPrintView = new SdDrawView( pDocSh, &rPrinter, (SdDrawViewShell*)this );
//STRIP001 		else
//STRIP001 			pPrintView = new SdDrawView( pDocSh, &rPrinter, NULL );
//STRIP001 
//STRIP001 		USHORT nPageCount = nProgressOffset;
//STRIP001 
//STRIP001 		// Als Broschuere drucken ?
//STRIP001 		if( bPrintBooklet )
//STRIP001 		{
//STRIP001 			SdPage*											pPage;
//STRIP001 			MapMode											aStdMap( rPrinter.GetMapMode() );
//STRIP001 			::std::vector< USHORT >							aPageVector;
//STRIP001 			::std::vector< ::std::pair< USHORT, USHORT > >	aPairVector;
//STRIP001             Point                                           aOffset;
//STRIP001             Size                                            aPrintSize_2( aPrintSize );
//STRIP001             Size                                            aPageSize_2( aPageSize );
//STRIP001 
//STRIP001 			if( eOrientation == ORIENTATION_LANDSCAPE )
//STRIP001                 aPrintSize_2.Width() >>= 1;
//STRIP001             else
//STRIP001                 aPrintSize_2.Height() >>= 1;
//STRIP001 
//STRIP001 		    const double fPageWH = (double) aPageSize_2.Width() / aPageSize_2.Height();
//STRIP001 		    const double fPrintWH = (double) aPrintSize_2.Width() / aPrintSize_2.Height();
//STRIP001 
//STRIP001     		if( fPageWH < fPrintWH )
//STRIP001 		    {
//STRIP001     			aPageSize_2.Width() = (long) ( aPrintSize_2.Height() * fPageWH );
//STRIP001 	    		aPageSize_2.Height()= aPrintSize_2.Height();
//STRIP001     		}
//STRIP001 		    else
//STRIP001 		    {
//STRIP001 			    aPageSize_2.Width() = aPrintSize_2.Width();
//STRIP001 			    aPageSize_2.Height() = (long) ( aPrintSize_2.Width() / fPageWH );
//STRIP001             }
//STRIP001 
//STRIP001 			aMap.SetScaleX( Fraction( aPageSize_2.Width(), aPageSize.Width() ) );
//STRIP001 			aMap.SetScaleY( Fraction( aPageSize_2.Height(), aPageSize.Height() ) );
//STRIP001 
//STRIP001             // calculate adjusted print size
//STRIP001             aPrintSize = OutputDevice::LogicToLogic( aPrintSize, aStdMap, aMap );
//STRIP001 
//STRIP001 			if( eOrientation == ORIENTATION_LANDSCAPE )
//STRIP001             {
//STRIP001                 aOffset.X() = ( ( aPrintSize.Width() >> 1 ) - aPageSize.Width() ) >> 1;
//STRIP001                 aOffset.Y() = ( aPrintSize.Height() - aPageSize.Height() ) >> 1;
//STRIP001             }
//STRIP001 			else
//STRIP001             {
//STRIP001                 aOffset.X() = ( aPrintSize.Width() - aPageSize.Width() ) >> 1;
//STRIP001                 aOffset.Y() = ( ( aPrintSize.Height() >> 1 ) - aPageSize.Height() ) >> 1;
//STRIP001             }
//STRIP001                 
//STRIP001 			// create vector of pages to print
//STRIP001 			while( nPage < nPageMax )
//STRIP001 			{
//STRIP001 				if( rSelPages.IsSelected( nPage + 1 )  )
//STRIP001 				{
//STRIP001 					SdPage* pPage = pDoc->GetSdPage( nPage, ePageKind );
//STRIP001 
//STRIP001 					if( pPage && ( !pPage->IsExcluded() || bPrintExcluded ) )
//STRIP001 						aPageVector.push_back( nPage );
//STRIP001 				}
//STRIP001 
//STRIP001 				nPage++;
//STRIP001 			}
//STRIP001 
//STRIP001 			// create pairs of pages to print on each page
//STRIP001 			if( aPageVector.size() )
//STRIP001 			{
//STRIP001 				sal_uInt32 nFirstIndex = 0, nLastIndex = aPageVector.size() - 1;
//STRIP001 
//STRIP001 				if( aPageVector.size() & 1 )
//STRIP001 					aPairVector.push_back( ::std::make_pair( (USHORT) 65535, aPageVector[ nFirstIndex++ ] ) );
//STRIP001 				else
//STRIP001 					aPairVector.push_back( ::std::make_pair( aPageVector[ nLastIndex-- ], aPageVector[ nFirstIndex++ ] ) );
//STRIP001 
//STRIP001 				while( nFirstIndex < nLastIndex )
//STRIP001 				{
//STRIP001 					if( nFirstIndex & 1 )
//STRIP001 						aPairVector.push_back( ::std::make_pair( aPageVector[ nFirstIndex++ ], aPageVector[ nLastIndex-- ] ) );
//STRIP001 					else
//STRIP001 						aPairVector.push_back( ::std::make_pair( aPageVector[ nLastIndex-- ], aPageVector[ nFirstIndex++ ] ) );
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			for( sal_uInt32 i = 0; i < aPairVector.size(); i++ )
//STRIP001 			{
//STRIP001 				if( ( !( i & 1 ) && bPrintFrontPage ) || ( ( i & 1 ) && bPrintBackPage ) )
//STRIP001 				{
//STRIP001 					const ::std::pair< USHORT, USHORT >	aPair( aPairVector[ i ] );
//STRIP001 
//STRIP001 					rPrinter.StartPage();
//STRIP001 
//STRIP001 					pPage = pDoc->GetSdPage( aPair.first, ePageKind );
//STRIP001 
//STRIP001 					if( pPage )
//STRIP001 					{
//STRIP001 						aMap.SetOrigin( aOffset );
//STRIP001 						rPrinter.SetMapMode( aMap );
//STRIP001 						PrintPage( rPrinter, pPrintView, pPage, bPrintMarkedOnly );
//STRIP001 					}
//STRIP001 
//STRIP001 					pPage = pDoc->GetSdPage( aPair.second, ePageKind );
//STRIP001 
//STRIP001 					if( pPage )
//STRIP001 					{
//STRIP001                         Point aSecondOffset( aOffset );
//STRIP001 
//STRIP001 						if( eOrientation == ORIENTATION_LANDSCAPE )
//STRIP001                             aSecondOffset.X() += ( aPrintSize.Width() >> 1 );
//STRIP001                         else
//STRIP001                             aSecondOffset.Y() += ( aPrintSize.Height() >> 1 );
//STRIP001 
//STRIP001 						aMap.SetOrigin( aSecondOffset );
//STRIP001 						rPrinter.SetMapMode( aMap );
//STRIP001 						PrintPage( rPrinter, pPrintView, pPage, bPrintMarkedOnly );
//STRIP001 					}
//STRIP001 
//STRIP001 					rPrinter.EndPage();
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			rPrinter.SetMapMode( aStdMap );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			WriteFrameViewData();
//STRIP001 
//STRIP001 			Point aPtZero;
//STRIP001 
//STRIP001 			while ( nPage < nPageMax )
//STRIP001 			{
//STRIP001 				if ( rSelPages.IsSelected(nPage+1) )
//STRIP001 				{
//STRIP001 					SdPage* pPage = pDoc->GetSdPage(nPage, ePageKind);
//STRIP001 					// Kann sich die Seitengroesse geaendert haben?
//STRIP001 					aPageSize = pPage->GetSize();
//STRIP001 
//STRIP001 					rProgress.SetState( nPageCount, nTotal );
//STRIP001 					nPageCount += nCopies;
//STRIP001 
//STRIP001 					if ( bScalePage )
//STRIP001 					{
//STRIP001 						double fHorz = (double) aPrintSize.Width()	/ aPageSize.Width();
//STRIP001 						double fVert = (double) aPrintSize.Height() / aPageSize.Height();
//STRIP001 
//STRIP001 						if ( fHorz < fVert )
//STRIP001 							aFract = Fraction(aPrintSize.Width(), aPageSize.Width());
//STRIP001 						else
//STRIP001 							aFract = Fraction(aPrintSize.Height(), aPageSize.Height());
//STRIP001 
//STRIP001 						aMap.SetScaleX(aFract);
//STRIP001 						aMap.SetScaleY(aFract);
//STRIP001 						aMap.SetOrigin(Point());
//STRIP001 					}
//STRIP001 
//STRIP001 					if ( !pPage->IsExcluded() || bPrintExcluded )
//STRIP001 					{
//STRIP001 						String aTmp = UniString::CreateFromInt32( nPage+1 );
//STRIP001 
//STRIP001 						if(ePageKind == PK_NOTES)
//STRIP001 							aTmp += String( SdResId( STR_PRINT_NOTES ) );
//STRIP001 						else
//STRIP001 							aTmp += String( SdResId( STR_PRINT_DRAWING ) );
//STRIP001 						rProgress.SetStateText( nPageCount, aTmp, nTotal );
//STRIP001 
//STRIP001 						String aPageStr;
//STRIP001 						if ( bPrintPageName )
//STRIP001 						{
//STRIP001 							aPageStr = pPage->GetName();
//STRIP001 							aPageStr += (sal_Unicode)' ';
//STRIP001 						}
//STRIP001 						aPageStr += rTimeDateStr;
//STRIP001 
//STRIP001 						MapMode aStdMap = rPrinter.GetMapMode();
//STRIP001 						rPrinter.SetMapMode(aMap);
//STRIP001 
//STRIP001 						//
//STRIP001 						BOOL    bPrint = TRUE;
//STRIP001 						Point   aPageOrigin;
//STRIP001 						long    aPageWidth   = aPageSize.Width() - pPage->GetLftBorder() - pPage->GetRgtBorder();
//STRIP001 						long    aPageHeight  = aPageSize.Height() - pPage->GetUppBorder() - pPage->GetLwrBorder();
//STRIP001 						long    aPrintWidth  = aPrintSize.Width();
//STRIP001 						long    aPrintHeight = aPrintSize.Height();
//STRIP001 
//STRIP001 						// Bugfix zu 44530:
//STRIP001 						// Falls implizit umgestellt wurde (Landscape/Portrait)
//STRIP001 						// wird dies beim Kacheln, bzw. aufteilen (Poster) beruecksichtigt
//STRIP001 						BOOL bSwitchPageSize = FALSE;
//STRIP001 						if( ( aPrintWidth > aPrintHeight && aPageWidth < aPageHeight ) ||
//STRIP001 							( aPrintWidth < aPrintHeight && aPageWidth > aPageHeight ) )
//STRIP001 						{
//STRIP001 							bSwitchPageSize = TRUE;
//STRIP001 							aPrintWidth  = aPrintSize.Height();
//STRIP001 							aPrintHeight = aPrintSize.Width();
//STRIP001 						}
//STRIP001 
//STRIP001 						// Eine (kleine) Seite, die gekachelt ausgegeben werden soll
//STRIP001 						if( bTilePage &&
//STRIP001 							aPageWidth < aPrintWidth &&
//STRIP001 							aPageHeight < aPrintHeight )
//STRIP001 						{
//STRIP001 							aPageWidth	+= 500;
//STRIP001 							aPageHeight += 500;
//STRIP001 							Point aPrintOrigin;
//STRIP001 
//STRIP001 							rPrinter.StartPage();
//STRIP001 							pPrintView->ShowPage( pPage, aPtZero );
//STRIP001 
//STRIP001 							SdrPageView* pPageView = pPrintView->GetPageView(pPage);
//STRIP001 							pPageView->SetVisibleLayers( pFrameView->GetVisibleLayers() );
//STRIP001 							pPageView->SetPrintableLayers( pFrameView->GetPrintableLayers() );
//STRIP001 
//STRIP001 							long nPagesPrinted = 0; // Fuer Bedingung s.u.
//STRIP001 							BOOL bPrintPage;		// Fuer Bedingung s.u.
//STRIP001 
//STRIP001 							while( bPrint )
//STRIP001 							{
//STRIP001 								BOOL bWidth = aPageWidth < aPrintWidth;
//STRIP001 								BOOL bHeight = aPageHeight < aPrintHeight;
//STRIP001 								if( !bWidth && !bHeight )
//STRIP001 									bPrint = FALSE;
//STRIP001 
//STRIP001 								// Etwas umstaendliche Abfrage, die ausdrueckt, ob eine Seite
//STRIP001 								// beim Kacheln abgeschnitten oder gar nicht dargestellt werden
//STRIP001 								// soll. Die Bedingung ist, dass eine 2. Seite (horz. oder vert.)
//STRIP001 								// immer gedruck wird, waehrend eine dritte Seite (oder hoeher)
//STRIP001 								// nur noch gedruckt wird, wenn diese auch noch vollstaendig
//STRIP001 								// aufs Papier passt.
//STRIP001 								if( nPagesPrinted < 4 && !( !bWidth && nPagesPrinted == 2 ) )
//STRIP001 									bPrintPage = TRUE;
//STRIP001 								else
//STRIP001 									bPrintPage = FALSE;
//STRIP001 								nPagesPrinted++;
//STRIP001 
//STRIP001 								if( ( bWidth && bHeight ) || bPrintPage )
//STRIP001 								{
//STRIP001 									aStdMap.SetOrigin( aPrintOrigin );
//STRIP001 									rPrinter.SetMapMode( aStdMap );
//STRIP001 
//STRIP001 									if( this->ISA( SdDrawViewShell ) && bPrintMarkedOnly )
//STRIP001 									{
//STRIP001 										pView->DrawAllMarked( rPrinter, aPtZero );
//STRIP001 									}
//STRIP001 									else
//STRIP001 										pPrintView->InitRedraw( &rPrinter, Rectangle( aPtZero,
//STRIP001 																aPageSize ) );
//STRIP001 								}
//STRIP001 								if( bWidth )
//STRIP001 								{
//STRIP001 									aPrintOrigin.X() += aPageWidth;
//STRIP001 									aPrintWidth 	 -= aPageWidth;
//STRIP001 								}
//STRIP001 								else if( bHeight )
//STRIP001 								{
//STRIP001 									aPrintOrigin.X()  = 0;
//STRIP001 									aPrintWidth 	  = bSwitchPageSize ? aPrintSize.Height() : aPrintSize.Width();
//STRIP001 									aPrintOrigin.Y() += aPageHeight;
//STRIP001 									aPrintHeight	 -= aPageHeight;
//STRIP001 								}
//STRIP001 							}
//STRIP001 
//STRIP001 							if ( aPageStr.Len() )
//STRIP001 							{
//STRIP001 								Font aOldFont = rPrinter.OutputDevice::GetFont();
//STRIP001 								rPrinter.SetFont(rTimeDateFont);
//STRIP001 								rPrinter.DrawText(aPageOfs, aPageStr);
//STRIP001 								rPrinter.SetFont(aOldFont);
//STRIP001 							}
//STRIP001 							rPrinter.EndPage();
//STRIP001 							pPrintView->HidePage(pPrintView->GetPageView(pPage));
//STRIP001 
//STRIP001 							bPrint = FALSE;
//STRIP001 						}
//STRIP001 
//STRIP001 						// Damit ein groessere Seite auch auf einem kleineren Drucker (Format)
//STRIP001 						// ausgegeben werden kann, wird folgende while-Schleife durchlaufen.
//STRIP001 						// Beim "Abschneiden" wird nur eine Seite gedruckt!
//STRIP001 						while( bPrint )
//STRIP001 						{
//STRIP001 							BOOL bWidth = aPageWidth > aPrintWidth;
//STRIP001 							BOOL bHeight = aPageHeight > aPrintHeight;
//STRIP001 							if( bScalePage ||
//STRIP001 								( !bWidth && !bHeight ) ||
//STRIP001 								( pPrintOpts && pPrintOpts->IsCutPage() ) )
//STRIP001 								bPrint = FALSE;
//STRIP001 
//STRIP001 							rPrinter.StartPage();
//STRIP001 							pPrintView->ShowPage(pPage, aPageOrigin);
//STRIP001 
//STRIP001 							if( bWidth )
//STRIP001 							{
//STRIP001 								aPageOrigin.X() -= aPrintWidth;
//STRIP001 								aPageWidth		-= aPrintWidth;
//STRIP001 							}
//STRIP001 							else if( bHeight )
//STRIP001 							{
//STRIP001 								aPageOrigin.X()  = 0;
//STRIP001 								aPageWidth		 = aPageSize.Width() - pPage->GetUppBorder() - pPage->GetLwrBorder();
//STRIP001 								aPageOrigin.Y() -= aPrintHeight;
//STRIP001 								aPageHeight 	-= aPrintHeight;
//STRIP001 							}
//STRIP001 
//STRIP001 							SdrPageView* pPageView = pPrintView->GetPageView(pPage);
//STRIP001 							pPageView->SetVisibleLayers( pFrameView->GetVisibleLayers() );
//STRIP001 							pPageView->SetPrintableLayers( pFrameView->GetPrintableLayers() );
//STRIP001 
//STRIP001 							if( this->ISA( SdDrawViewShell ) && bPrintMarkedOnly )
//STRIP001 								pView->DrawAllMarked( rPrinter, aPtZero );
//STRIP001 							else
//STRIP001 								pPrintView->InitRedraw(&rPrinter, Rectangle(Point(0,0),
//STRIP001 														pPage->GetSize()));
//STRIP001 							rPrinter.SetMapMode(aStdMap);
//STRIP001 
//STRIP001 							if ( aPageStr.Len() )
//STRIP001 							{
//STRIP001 								Font aOldFont = rPrinter.OutputDevice::GetFont();
//STRIP001 								rPrinter.SetFont(rTimeDateFont);
//STRIP001 								rPrinter.DrawText(aPageOfs, aPageStr);
//STRIP001 								rPrinter.SetFont(aOldFont);
//STRIP001 							}
//STRIP001 							rPrinter.EndPage();
//STRIP001 							pPrintView->HidePage(pPrintView->GetPageView(pPage));
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 				nPage++;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		delete pPrintView;
//STRIP001 		rPrinter.SetMapMode( aOldMap );
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Seite drucken
|*
\************************************************************************/
//STRIP001 void SdViewShell::PrintPage( SfxPrinter& rPrinter, SdView* pPrintView,
//STRIP001 								 SdPage* pPage, BOOL bPrintMarkedOnly )
//STRIP001 {
//STRIP001 	Point aPtZero;
//STRIP001 	pPrintView->ShowPage( pPage, aPtZero );
//STRIP001 
//STRIP001 	SdrPageView* pPageView = pPrintView->GetPageView( pPage );
//STRIP001 	pPageView->SetVisibleLayers( pFrameView->GetVisibleLayers() );
//STRIP001 	pPageView->SetPrintableLayers( pFrameView->GetPrintableLayers() );
//STRIP001 
//STRIP001 	if( this->ISA( SdDrawViewShell ) && bPrintMarkedOnly )
//STRIP001 		pView->DrawAllMarked( rPrinter, aPtZero );
//STRIP001 	else
//STRIP001 		pPrintView->InitRedraw( &rPrinter, Rectangle( aPtZero,
//STRIP001 								pPage->GetSize() ) );
//STRIP001 
//STRIP001 	pPrintView->HidePage( pPrintView->GetPageView( pPage ) );
//STRIP001 	/*
//STRIP001 	if ( aPageStr.Len() )
//STRIP001 	{
//STRIP001 		Font aOldFont = rPrinter.OutputDevice::GetFont();
//STRIP001 		rPrinter.SetFont( rTimeDateFont );
//STRIP001 		rPrinter.DrawText( aPageOfs, aPageStr );
//STRIP001 		rPrinter.SetFont( aOldFont );
//STRIP001 	}
//STRIP001 	*/
//STRIP001 }

/*************************************************************************
|*
|* Status (Enabled/Disabled) von Menue-SfxSlots setzen
|*
\************************************************************************/

/*N*/ void  SdViewShell::GetMenuState( SfxItemSet &rSet )
/*N*/ {
/*N*/ 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_STYLE_FAMILY ) )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 UINT16 nFamily = (SfxStyleFamily)pDocSh->GetStyleFamily();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		SdrView* pDrView = GetDrawView();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if( pDrView->HasMarkedObj() )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			SfxStyleSheet* pStyleSheet = pDrView->GetStyleSheet();
//STRIP001 /*?*/ 			if( pStyleSheet )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				if (pStyleSheet->GetFamily() == SD_LT_FAMILY)
//STRIP001 /*?*/ 					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pStyleSheet = ((SdStyleSheet*)pStyleSheet)->GetPseudoStyleSheet();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if( pStyleSheet )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					SfxStyleFamily eFamily = pStyleSheet->GetFamily();
//STRIP001 /*?*/ 					if(eFamily == SFX_STYLE_FAMILY_PARA)
//STRIP001 /*?*/ 						nFamily = 2;
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/ 						nFamily = 5;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					pDocSh->SetStyleFamily(nFamily);
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		rSet.Put(SfxUInt16Item(SID_STYLE_FAMILY, nFamily ));
/*N*/ 	}

	// #96090#
/*N*/     if(SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_GETUNDOSTRINGS))
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 ImpGetUndoStrings(rSet);
/*?*/ 	}
/*N*/ 
/*N*/ 	// #96090#
/*N*/     if(SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_GETREDOSTRINGS))
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 ImpGetRedoStrings(rSet);
/*?*/ 	}
/*N*/ 
/*N*/ 	// #96090#
/*N*/     if(SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_UNDO))
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SfxUndoManager* pUndoManager = ImpGetUndoManager();
//STRIP001 /*?*/ 		sal_Bool bActivate(FALSE);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if(pUndoManager)
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			if(pUndoManager->GetUndoActionCount() != 0)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				bActivate = TRUE;
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if(bActivate)
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			// #87229# Set the necessary string like in 
//STRIP001 /*?*/ 			// bf_sfx2/source/view/viewfrm.cxx ver 1.23 ln 1072 ff.
//STRIP001 /*?*/ 			String aTmp(ResId(STR_UNDO, SFX_APP()->GetSfxResManager()));
//STRIP001 /*?*/ 			aTmp += pUndoManager->GetUndoActionComment(0);
//STRIP001 /*?*/ 			rSet.Put(SfxStringItem(SID_UNDO, aTmp));
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		else
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			rSet.DisableItem(SID_UNDO);
//STRIP001 /*?*/ 		}
/*?*/ 	}

	// #96090#
/*N*/     if(SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_REDO))
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SfxUndoManager* pUndoManager = ImpGetUndoManager();
//STRIP001 /*?*/ 		sal_Bool bActivate(FALSE);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if(pUndoManager)
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			if(pUndoManager->GetRedoActionCount() != 0)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				bActivate = TRUE;
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if(bActivate)
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			// #87229# Set the necessary string like in 
//STRIP001 /*?*/ 			// bf_sfx2/source/view/viewfrm.cxx ver 1.23 ln 1081 ff.
//STRIP001 /*?*/ 			String aTmp(ResId(STR_REDO, SFX_APP()->GetSfxResManager()));
//STRIP001 /*?*/ 			aTmp += pUndoManager->GetRedoActionComment(0);
//STRIP001 /*?*/ 			rSet.Put(SfxStringItem(SID_REDO, aTmp));
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		else
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			rSet.DisableItem(SID_REDO);
//STRIP001 /*?*/ 		}
/*?*/ 	}
/*N*/ }


/*N*/ void SdViewShell::SetPreview( bool bVisible )
/*N*/ {
/*N*/ 	DBG_ASSERT( GetViewFrame(), "FATAL: no viewframe?" );
/*N*/ 	DBG_ASSERT( pWindow, "FATAL: no window?" );
/*N*/ 
/*N*/ 	if( GetViewFrame() && pWindow )
/*N*/ 	{
/*N*/         if ( ! bVisible)
/*?*/         {DBG_BF_ASSERT(0, "STRIP");} //STRIP001     mpWindowUpdater->UnregisterPreview ();
/*N*/ 		GetViewFrame()->SetChildWindow(SdPreviewChildWindow::GetChildWindowId(), bVisible,false);
/*N*/         if (bVisible)
/*?*/         {DBG_BF_ASSERT(0, "STRIP");} //STRIP001     mpWindowUpdater->RegisterPreview ();
/*N*/ 
/*N*/ 		const StyleSettings& rStyleSettings = pWindow->GetSettings().GetStyleSettings();
/*N*/ 
/*N*/ 		sal_uInt16 nPreviewSlot;
/*N*/         
/*N*/ 		SvtAccessibilityOptions aAccOptions;
/*N*/ 
/*N*/ 		if( GetViewFrame()->GetDispatcher() )
/*N*/ 		{
/*N*/ 			if( rStyleSettings.GetHighContrastMode() && aAccOptions.GetIsForPagePreviews() )
/*N*/ 			{
/*N*/ 				nPreviewSlot = SID_PREVIEW_QUALITY_CONTRAST;
/*N*/ 			}
/*N*/ 			else
/*N*/ 			{
/*N*/ 				nPreviewSlot = SID_PREVIEW_QUALITY_COLOR;
/*N*/ 			}
/*N*/ 
/*N*/ 			GetViewFrame()->GetDispatcher()->Execute( nPreviewSlot, SFX_CALLMODE_ASYNCHRON );
/*N*/ 		}
/*N*/ 
/*N*/ 		SfxBindings& rBindings = GetViewFrame()->GetBindings();
/*N*/ 		rBindings.Invalidate(SID_PREVIEW_WIN);
/*N*/ 		rBindings.Invalidate(SID_PREVIEW_QUALITY_COLOR);
/*N*/ 		rBindings.Invalidate(SID_PREVIEW_QUALITY_GRAYSCALE);
/*N*/ 		rBindings.Invalidate(SID_PREVIEW_QUALITY_BLACKWHITE);
/*N*/ 		rBindings.Invalidate(SID_PREVIEW_QUALITY_CONTRAST);
/*N*/ 
/*N*/ 	}
/*N*/ }

}
