/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_spldlg.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:03:14 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#pragma hdrstop

// include ---------------------------------------------------------------
#include <tools/ref.hxx>

#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif
#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif
//#ifndef _SV_SYSTEM_HXX
//#include <vcl/system.hxx>
//#endif
#ifndef _SV_MENU_HXX
#include <vcl/menu.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif

#ifndef _UNO_LINGU_HXX
#include <unolingu.hxx>
#endif

#ifndef _LINGUISTIC_LNGPROPS_HHX_
#include <bf_linguistic/lngprops.hxx>
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_SPELLFAILURE_HPP_
#include <com/sun/star/linguistic2/SpellFailure.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XSTORABLE_HPP_
#include <com/sun/star/frame/XStorable.hpp>
#endif

#ifndef _SFXAPP_HXX //autogen
#include <bf_sfx2/app.hxx>
#endif


#define _SVX_SPLDLG_CXX

#include "dialogs.hrc"
#include <helpid.hrc>
#include "spldlg.hrc"

#define ITEMID_SPELLCHECK	SID_ATTR_SPELL

#include "optitems.hxx"
#include "svxenum.hxx"
#include "spldlg.hxx"       // Der Dialog
#include "splwrap.hxx"      // Der Wrapper
#include "thesdlg.hxx"      // ThesaurusDlg
#include "dlgutil.hxx"		// language
#include "optlingu.hxx"
#include "dialmgr.hxx"
#include "svxerr.hxx"

#ifndef SVX_COMMON_LINGUI_HXX
#include "commonlingui.hxx"
#endif
namespace binfilter {

//STRIP001 using namespace ::rtl;
//STRIP001 using namespace ::com::sun::star;
//STRIP001 using namespace ::com::sun::star::uno;
//STRIP001 using namespace ::com::sun::star::beans;
//STRIP001 using namespace ::com::sun::star::linguistic2;
//STRIP001 
//STRIP001 #define C2U(cChar) 					OUString::createFromAscii(cChar)
//STRIP001 // struct SpellCheckDlg_Impl ---------------------------------------------
//STRIP001 
//STRIP001 struct SpellCheckDlg_Impl
//STRIP001 {
//STRIP001 	Sequence< Reference< XDictionary >  >	aDics;
//STRIP001 	SvxSpellWrapper*			pSpellWrapper;
//STRIP001 	FASTBOOL					bBtnLock;
//STRIP001 
//STRIP001 	SpellCheckDlg_Impl() :
//STRIP001 		pSpellWrapper	(NULL),
//STRIP001 		bBtnLock		(sal_False)
//STRIP001 	{
//STRIP001 	}
//STRIP001 };
//STRIP001 
//STRIP001 static Window* pOldDefDialogParent;
//STRIP001 
//STRIP001 // define ----------------------------------------------------------------
//STRIP001 
//STRIP001 #define WRAPPER					pImpl->pSpellWrapper
//STRIP001 #define BTN_LOCK				pImpl->bBtnLock
//STRIP001 #define BTN_LOCKING( bLock )									\
//STRIP001 	if ( bLock )												\
//STRIP001 	{															\
//STRIP001 		EnterWait();											\
//STRIP001 		pOldDefDialogParent=Application::GetDefDialogParent();	\
//STRIP001 		Application::SetDefDialogParent(this);					\
//STRIP001 	}															\
//STRIP001 	else														\
//STRIP001 	{															\
//STRIP001 		LeaveWait();											\
//STRIP001 		Application::SetDefDialogParent(pOldDefDialogParent);	\
//STRIP001 	}															\
//STRIP001 	BTN_LOCK = bLock
//STRIP001 
//STRIP001 
//STRIP001 	static void 				SetDefDialogParent( Window* pWindow );
//STRIP001 	static Window*				GetDefDialogParent();
//STRIP001 
//STRIP001 // statics ---------------------------------------------------------------
//STRIP001 
//STRIP001 static const short NOACTDICT = -1;
//STRIP001 
//STRIP001 /*
//STRIP001 static SfxItemInfo __READONLY_DATA aItemInfos[] =
//STRIP001 {
//STRIP001 	{ 0, 0 }
//STRIP001 };
//STRIP001 */
//STRIP001 static sal_uInt16 pSpellInfos[] =
//STRIP001 {
//STRIP001 	SID_ATTR_SPELL,SID_ATTR_SPELL,
//STRIP001 	0
//STRIP001 };
//STRIP001 
//STRIP001 // class SvxSpellCheckDialog ---------------------------------------------
//STRIP001 
//STRIP001 SvxSpellCheckDialog::SvxSpellCheckDialog
//STRIP001 (
//STRIP001 	Window* 			pParent,
//STRIP001 	Reference< XSpellChecker1 >  &	xChecker,
//STRIP001 	SvxSpellWrapper* 	pWrapper
//STRIP001 ) :
//STRIP001 
//STRIP001 	SfxModalDialog( pParent, SVX_RES( RID_SVXDLG_SPELLCHECK ) ),
//STRIP001 
//STRIP001 	m_aPlayground( new SvxCommonLinguisticControl( this ) ),
//STRIP001 
//STRIP001 	aStateImage		( m_aPlayground.get(),	ResId( FI_STATE) ),
//STRIP001 	aTestBtn		( m_aPlayground.get(),	ResId( IB_TEST ) ),
//STRIP001 	aNewWordLB		( m_aPlayground.get(),	ResId( LB_NEWWORD ) ),
//STRIP001 	aLanguageText	( m_aPlayground.get(),	ResId( FT_LANGUAGE ) ),
//STRIP001 	aLangLB			( m_aPlayground.get(),	ResId( LB_LANGUAGE ) ),
//STRIP001 
//STRIP001 	aAutoCorrBtn	( m_aPlayground.get(),	ResId( BTN_AUTOCORR ) ),
//STRIP001 	aThesBtn		( m_aPlayground.get(),	ResId( BTN_THES ) ),
//STRIP001 	aOptionsBtn		( m_aPlayground.get(),	ResId( BTN_OPTIONS ) ),
//STRIP001 	aBookText		( m_aPlayground.get(),	ResId( FT_BOOK ) ),
//STRIP001 	aBookDLB		( m_aPlayground.get(),	ResId( LB_BOOK ) ),
//STRIP001 	aAddBtn			( m_aPlayground.get(),	ResId( BTN_ADD ) ),
//STRIP001 	aBackWdBox		( m_aPlayground.get(), ResId( CB_BACKWD ) ),
//STRIP001 
//STRIP001 	aErrorStr		( ResId( STR_ERROR) ),
//STRIP001 	aFalseStateIm	( ResId( IM_FALSE) ),
//STRIP001 	aTrueStateIm	( ResId( IM_OK) ),
//STRIP001 	xSpell			( xChecker ),
//STRIP001 	nOldLang		( LANGUAGE_NONE ),
//STRIP001 	nActDict		( NOACTDICT ),
//STRIP001 	aStateStr		( aStateImage.GetQuickHelpText() ),
//STRIP001 	bModified		( sal_False )
//STRIP001 {
//STRIP001 	pImpl = new SpellCheckDlg_Impl;
//STRIP001 	//pImpl->xSpellAlt = WRAPPER->GetLast(), UNO_QUERY);
//STRIP001 	WRAPPER = pWrapper;
//STRIP001 	BTN_LOCK = sal_False;
//STRIP001 
//STRIP001 	aStateImage.SetImage(aFalseStateIm);
//STRIP001 
//STRIP001 	// we have to correct the z-order of our controls (some are part of the SvxCommonLinguisticControl,
//STRIP001 	// and some aren't)
//STRIP001 	m_aPlayground->InsertControlGroup( aStateImage, aTestBtn, SvxCommonLinguisticControl::eLeftRightWords );
//STRIP001 	m_aPlayground->InsertControlGroup( aNewWordLB, aAddBtn, SvxCommonLinguisticControl::eSuggestionLabel );
//STRIP001 	m_aPlayground->InsertControlGroup( aAutoCorrBtn, aBackWdBox, SvxCommonLinguisticControl::eActionButtons );
//STRIP001     m_aPlayground->GetButton(SvxCommonLinguisticControl::eClose     )->SetHelpId(HID_SPLDLG_BUTTON_CLOSE    );
//STRIP001     m_aPlayground->GetButton(SvxCommonLinguisticControl::eIgnore    )->SetHelpId(HID_SPLDLG_BUTTON_IGNORE   );
//STRIP001     m_aPlayground->GetButton(SvxCommonLinguisticControl::eIgnoreAll )->SetHelpId(HID_SPLDLG_BUTTON_IGNOREALL);
//STRIP001     m_aPlayground->GetButton(SvxCommonLinguisticControl::eChange    )->SetHelpId(HID_SPLDLG_BUTTON_CHANGE   );
//STRIP001     m_aPlayground->GetButton(SvxCommonLinguisticControl::eChangeAll )->SetHelpId(HID_SPLDLG_BUTTON_CHANGEALL);
//STRIP001     m_aPlayground->GetWordInputControl().SetHelpId(HID_SPLDLG_EDIT_NEWWORD);
//STRIP001 
//STRIP001 	Init_Impl();
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	// disable controls if service is missing
//STRIP001 	if (!xSpell.is())
//STRIP001 		Enable( sal_False );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxSpellCheckDialog::~SvxSpellCheckDialog()
//STRIP001 {
//STRIP001     //!! needs to be reseted, otherwise it may crash upon closing
//STRIP001     //!! under Solaris and Linux since a already non-existing control
//STRIP001     //!! will get the foxus
//STRIP001     m_aPlayground->SetResetWordHdl( Link() );
//STRIP001     
//STRIP001     delete pImpl;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxSpellCheckDialog::Init_Impl()
//STRIP001 {
//STRIP001 	// Handler initialisieren
//STRIP001 	m_aPlayground->SetButtonHandler( SvxCommonLinguisticControl::eClose,		LINK( this, SvxSpellCheckDialog, CancelHdl ) );
//STRIP001 	m_aPlayground->SetButtonHandler( SvxCommonLinguisticControl::eChange,		LINK( this, SvxSpellCheckDialog, ChgHdl ) );
//STRIP001 	m_aPlayground->SetButtonHandler( SvxCommonLinguisticControl::eChangeAll,	LINK( this, SvxSpellCheckDialog, ChgAllHdl ) );
//STRIP001 	m_aPlayground->SetButtonHandler( SvxCommonLinguisticControl::eIgnore,		LINK( this, SvxSpellCheckDialog, IgnHdl ) );
//STRIP001 	m_aPlayground->SetButtonHandler( SvxCommonLinguisticControl::eIgnoreAll,	LINK( this, SvxSpellCheckDialog, IgnAllHdl ) );
//STRIP001 	aAddBtn		 .SetClickHdl( LINK( this, SvxSpellCheckDialog, AddHdl ) );
//STRIP001 
//STRIP001 	aAutoCorrBtn.SetClickHdl( LINK( this, SvxSpellCheckDialog, ExtClickHdl ) );
//STRIP001 	aThesBtn	.SetClickHdl( LINK( this, SvxSpellCheckDialog, ExtClickHdl ) );
//STRIP001 	aOptionsBtn .SetClickHdl( LINK( this, SvxSpellCheckDialog, ExtClickHdl ) );
//STRIP001 
//STRIP001 	aBookDLB.SetSelectHdl( LINK( this, SvxSpellCheckDialog, SelectHdl ) );
//STRIP001 	aLangLB		 .SetSelectHdl( LINK( this, SvxSpellCheckDialog, SelectHdl ) );
//STRIP001 
//STRIP001 	aNewWordLB.SetGetFocusHdl( LINK( this, SvxSpellCheckDialog, WordSelectHdl ) );
//STRIP001 	aNewWordLB.SetSelectHdl( LINK( this, SvxSpellCheckDialog, WordSelectHdl ) );
//STRIP001 	aNewWordLB.SetDoubleClickHdl( LINK( this, SvxSpellCheckDialog, ChgHdl ) );
//STRIP001 
//STRIP001 	aBackWdBox.SetClickHdl(LINK ( this, SvxSpellCheckDialog, DirectionHdl ) );
//STRIP001 	aTestBtn  .SetClickHdl(LINK ( this, SvxSpellCheckDialog, AuditHdl) );
//STRIP001     aTestBtn.SetModeImage( Image( ResId( IMG_TEST_HC) ), BMP_COLOR_HIGHCONTRAST );
//STRIP001 	m_aPlayground->GetWordInputControl().SetModifyHdl(LINK ( this, SvxSpellCheckDialog, ModifyHdl) );
//STRIP001 	m_aPlayground->SetResetWordHdl( LINK ( this, SvxSpellCheckDialog, ClickHdl) );
//STRIP001 
//STRIP001 	// "Uberschrift merken
//STRIP001 	aTitel = GetText();
//STRIP001 
//STRIP001 	// initialisieren der Sprachen-Listbox
//STRIP001     aLangLB.SetLanguageList( LANG_LIST_SPELL_USED, FALSE, FALSE, TRUE );
//STRIP001 
//STRIP001 	Reference< XSpellAlternatives >  xAlt( WRAPPER->GetLast(), UNO_QUERY );
//STRIP001 	if (xAlt.is())
//STRIP001 	{
//STRIP001 		nOldLang = SvxLocaleToLanguage( xAlt->getLocale() );
//STRIP001 		aOldWord = String( xAlt->getWord() );
//STRIP001 		WRAPPER->SetOldLang( nOldLang );
//STRIP001 	}
//STRIP001 
//STRIP001 	// aktuelle Sprache ermitteln
//STRIP001 	UpdateBoxes_Impl();
//STRIP001 
//STRIP001 	// Benutzerbuecher anzeigen
//STRIP001 	InitUserDicts();
//STRIP001 
//STRIP001 	Reference< XPropertySet >  xProp( SvxGetLinguPropertySet() );
//STRIP001 	sal_Bool bWrapReverse = xProp.is() ?
//STRIP001 		*(sal_Bool*)xProp->getPropertyValue( C2U(UPN_IS_WRAP_REVERSE) ).getValue() : sal_False;
//STRIP001 	aBackWdBox.Check(0 != bWrapReverse);
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxSpellCheckDialog::UpdateBoxes_Impl()
//STRIP001 {
//STRIP001 	sal_Int32 i;
//STRIP001 	aNewWordLB.Clear();
//STRIP001 
//STRIP001 	Reference< XSpellAlternatives >  xAlt( WRAPPER->GetLast(), UNO_QUERY );
//STRIP001 
//STRIP001 	LanguageType nAltLanguage = LANGUAGE_NONE;
//STRIP001 	String		 aAltWord;
//STRIP001 	Sequence< OUString >	aNewWords;
//STRIP001 	if (xAlt.is())
//STRIP001 	{
//STRIP001 		nAltLanguage	= SvxLocaleToLanguage( xAlt->getLocale() );
//STRIP001 		aAltWord 		= String( xAlt->getWord() );
//STRIP001 		aNewWords 		= xAlt->getAlternatives();
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	String aStr( aTitel );
//STRIP001 	aStr.Append( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( " (" ) ) );
//STRIP001 	if (xAlt.is())
//STRIP001 		aStr.Append( ::GetLanguageString( nAltLanguage ) );
//STRIP001 	aStr.Append( sal_Unicode( ')' ) );
//STRIP001 	SetText( aStr );
//STRIP001 
//STRIP001 	SetSelectedLang_Impl( nAltLanguage );
//STRIP001 
//STRIP001 	// Das Wort Anzeigen und seine Alternativen
//STRIP001 	m_aPlayground->SetCurrentText( aAltWord );
//STRIP001 
//STRIP001 	SetAddBtnHelp(m_aPlayground->GetCurrentText());
//STRIP001 	m_aPlayground->UpdateIgnoreHelp( );
//STRIP001 
//STRIP001 	// 1. Alternative in das Edit stellen
//STRIP001 	m_aPlayground->GetWordInputControl().SetText( m_aPlayground->GetCurrentText() );
//STRIP001 	aAutoCorrBtn.Enable( m_aPlayground->GetWordInputControl().GetText() != m_aPlayground->GetCurrentText() );
//STRIP001 
//STRIP001 	// Alternativen eintragen
//STRIP001 	const OUString *pNewWords = aNewWords.getConstArray();
//STRIP001 	const sal_Int32 nSize = aNewWords.getLength();
//STRIP001 	for ( i = 0; i < nSize; ++i )
//STRIP001 	{
//STRIP001 		String aTmp( pNewWords[i] );
//STRIP001 		if ( LISTBOX_ENTRY_NOTFOUND == aNewWordLB.GetEntryPos( aTmp ) )
//STRIP001 			aNewWordLB.InsertEntry( aTmp );
//STRIP001 	}
//STRIP001 	m_aPlayground->GetWordInputControl().GrabFocus();
//STRIP001 
//STRIP001 	// display status message
//STRIP001 	String aTmpText;
//STRIP001 	if (xAlt.is())
//STRIP001 	{
//STRIP001 		int nRID;
//STRIP001 		switch (xAlt->getFailureType())
//STRIP001 		{
//STRIP001 			case SpellFailure::IS_NEGATIVE_WORD : nRID = RID_SVXSTR_HMSTATUS_DONTUSE; break;
//STRIP001 			case SpellFailure::CAPTION_ERROR : 	 nRID = RID_SVXSTR_HMSTATUS_CAPERROR; break;
//STRIP001 			case SpellFailure::SPELLING_ERROR : 	 nRID = RID_SVXSTR_HMSTATUS_WRONG; break;
//STRIP001 			default :
//STRIP001 				DBG_ERROR("undefined SpellFailure type");
//STRIP001 		}
//STRIP001 		aTmpText = SVX_RESSTR( nRID );
//STRIP001 	}
//STRIP001 	m_aPlayground->SetStatusText( aTmpText );
//STRIP001 
//STRIP001 	if (aNewWordLB.GetEntryCount())
//STRIP001 	{
//STRIP001 		aNewWordLB.Enable();
//STRIP001 		aNewWordLB.SelectEntryPos(0);
//STRIP001 		//aNewWordLB.Select();	// Select-Handler rufen
//STRIP001 		long nPos= m_aPlayground->GetWordInputControl().GetText().Len();
//STRIP001 		Selection aSel(nPos, nPos);
//STRIP001 		m_aPlayground->GetWordInputControl().SetSelection(aSel);	// Alles selektieren
//STRIP001 		m_aPlayground->UpdateChangesHelp( aNewWordLB.GetSelectEntry() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		m_aPlayground->UpdateChangesHelp( );
//STRIP001 	}
//STRIP001 	aStateImage.SetImage(aFalseStateIm);
//STRIP001 	UniString aStrTmp( aStateStr );
//STRIP001 	aStrTmp.Append(m_aPlayground->GetStatusText());
//STRIP001 	aStateImage.SetQuickHelpText( aStrTmp );
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 String SvxSpellCheckDialog::GetNewEditWord()
//STRIP001 {
//STRIP001 	return m_aPlayground->GetNewEditWord();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 void SvxSpellCheckDialog::SetNewEditWord( const String& _rNew )
//STRIP001 {
//STRIP001 	m_aPlayground->SetNewEditWord( _rNew );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxSpellCheckDialog::SpellContinue_Impl()
//STRIP001 {
//STRIP001 	WRAPPER->FindSpellError();
//STRIP001 	Reference< XSpellAlternatives >  xAlt( WRAPPER->GetLast(), UNO_QUERY );
//STRIP001 
//STRIP001 	if (xAlt.is())
//STRIP001 	{
//STRIP001 		UpdateBoxes_Impl();
//STRIP001 		nOldLang = GetSelectedLang_Impl();
//STRIP001 		aOldWord = m_aPlayground->GetCurrentText();
//STRIP001 //		aOldWord = m_aPlayground->GetWordInputControl().GetText();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		EndDialog( RET_OK );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxSpellCheckDialog, ExtClickHdl, Button *, pBtn )
//STRIP001 {
//STRIP001 	if (&aOptionsBtn == pBtn)
//STRIP001 		StartSpellOptDlg_Impl();
//STRIP001 	else if (&aAutoCorrBtn == pBtn)
//STRIP001 	{
//STRIP001 		String aOldWord( m_aPlayground->GetCurrentText() ),
//STRIP001 			   aNewWord( m_aPlayground->GetWordInputControl().GetText() );
//STRIP001 		SvxPrepareAutoCorrect( aOldWord, aNewWord );
//STRIP001 		WRAPPER->AutoCorrect( aOldWord, aNewWord );
//STRIP001 	}
//STRIP001 	else if (&aThesBtn == pBtn)
//STRIP001 		StartThesaurus_Impl( sal_True );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxSpellCheckDialog::StartSpellOptDlg_Impl()
//STRIP001 {
//STRIP001 
//STRIP001 	SfxItemSet aSet( SFX_APP()->GetPool(), pSpellInfos);
//STRIP001 	aSet.Put(SfxSpellCheckItem( xSpell ),SID_ATTR_SPELL );
//STRIP001 	SfxSingleTabDialog* pDlg =
//STRIP001 		new SfxSingleTabDialog( this, aSet, RID_SFXPAGE_LINGU );
//STRIP001 	SfxTabPage* pPage = SvxLinguTabPage::Create( pDlg, aSet );
//STRIP001 	( (SvxLinguTabPage*)pPage )->HideGroups( GROUP_MODULES );
//STRIP001 	pDlg->SetTabPage( pPage );
//STRIP001 	pDlg->Execute();
//STRIP001 	delete pDlg;
//STRIP001 
//STRIP001 	// Benutzerb"ucher anzeigen
//STRIP001 	aBookDLB.Clear();
//STRIP001 	InitUserDicts();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxSpellCheckDialog::StartThesaurus_Impl( sal_Bool bInter )
//STRIP001 {
//STRIP001 	if ( !bInter )
//STRIP001 	{
//STRIP001 		QueryBox aBox( this, SVX_RES( RID_SVXQB_THESAURUS ) );
//STRIP001 
//STRIP001 		if ( aBox.Execute() == RET_NO )
//STRIP001 			return;
//STRIP001 	}
//STRIP001 	WRAPPER->StartThesaurus( GetNewEditWord(), GetSelectedLang_Impl() );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxSpellCheckDialog, ChgHdl, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	if ( BTN_LOCK )
//STRIP001 		return 0;
//STRIP001 	BTN_LOCKING( sal_True );
//STRIP001 
//STRIP001 	String aString=m_aPlayground->GetWordInputControl().GetText();
//STRIP001 	if(aNewWordLB.IsEnabled() && aNewWordLB.GetSelectEntryCount()>0)
//STRIP001 		aString=aNewWordLB.GetSelectEntry();
//STRIP001 
//STRIP001 	WRAPPER->ChangeWord( aString, GetSelectedLang_Impl() );
//STRIP001 	SpellContinue_Impl();
//STRIP001 	BTN_LOCKING( sal_False );
//STRIP001 	bModified=sal_False;
//STRIP001 	return 1;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxSpellCheckDialog, ChgAllHdl, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	if ( BTN_LOCK )
//STRIP001 		return 0;
//STRIP001 	BTN_LOCKING( sal_True );
//STRIP001 
//STRIP001 	// zuerst das aktuelle Wort "andern
//STRIP001 
//STRIP001 	String aString=m_aPlayground->GetWordInputControl().GetText();
//STRIP001 	if(aNewWordLB.IsEnabled() && aNewWordLB.GetSelectEntryCount()>0)
//STRIP001 		aString=aNewWordLB.GetSelectEntry();
//STRIP001 
//STRIP001 	LanguageType nLang = GetSelectedLang_Impl();
//STRIP001 
//STRIP001 	// add new word to ChangeAll list
//STRIP001 	String  aOldWord( m_aPlayground->GetCurrentText() );
//STRIP001 	SvxPrepareAutoCorrect( aOldWord, aString );
//STRIP001     Reference<XDictionary> aXDictionary( SvxGetChangeAllList(), UNO_QUERY );
//STRIP001 	SvxAddEntryToDic( aXDictionary,
//STRIP001 		::rtl::OUString( aOldWord ), sal_True,
//STRIP001 			aString, nLang );
//STRIP001 
//STRIP001 	WRAPPER->ChangeWord( aString, nLang );
//STRIP001 	SpellContinue_Impl();
//STRIP001 	BTN_LOCKING( sal_False );
//STRIP001 	bModified=sal_False;
//STRIP001 	return 1;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxSpellCheckDialog, IgnAllHdl, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	if ( BTN_LOCK )
//STRIP001 		return 0;
//STRIP001 	BTN_LOCKING( sal_True );
//STRIP001 
//STRIP001 	// add word to IgnoreAll list
//STRIP001     Reference< XDictionary > aXDictionary( SvxGetIgnoreAllList(), UNO_QUERY );
//STRIP001     SvxAddEntryToDic( aXDictionary,
//STRIP001 		::rtl::OUString( m_aPlayground->GetCurrentText() ), sal_False,
//STRIP001 		::rtl::OUString(), LANGUAGE_NONE );
//STRIP001 
//STRIP001 	SpellContinue_Impl();
//STRIP001 	BTN_LOCKING( sal_False );
//STRIP001 	bModified=sal_False;
//STRIP001 	return 1;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxSpellCheckDialog, IgnHdl, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	if ( BTN_LOCK )
//STRIP001 		return 0;
//STRIP001 	BTN_LOCKING( sal_True );
//STRIP001 	// Das Wort wird einfach ignoriert
//STRIP001 	SpellContinue_Impl();
//STRIP001 	BTN_LOCKING( sal_False );
//STRIP001 	bModified=sal_False;
//STRIP001 	return 1;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxSpellCheckDialog, AddHdl, Button *, pButton )
//STRIP001 {
//STRIP001 	const sal_uInt16 nPos = aBookDLB.GetSelectEntryPos();
//STRIP001 
//STRIP001 	String aNewWord;
//STRIP001 
//STRIP001 	if(bModified)
//STRIP001 		aNewWord= m_aPlayground->GetWordInputControl().GetText();
//STRIP001 	else
//STRIP001 		aNewWord= m_aPlayground->GetCurrentText();
//STRIP001 
//STRIP001 	if ( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		sal_uInt16 nPos = aBookDLB.GetSelectEntry().nId;
//STRIP001 
//STRIP001         Reference< XDictionary >  xDic( pImpl->aDics.getConstArray()[ nPos ], UNO_QUERY );
//STRIP001         sal_Int16 nAddRes = DIC_ERR_UNKNOWN;
//STRIP001         if (xDic.is())
//STRIP001         {
//STRIP001             String aTmpTxt( aNewWord );
//STRIP001             sal_Bool bNegEntry = xDic->getDictionaryType() == DictionaryType_NEGATIVE;
//STRIP001             nAddRes = SvxAddEntryToDic( xDic, aTmpTxt, bNegEntry,
//STRIP001                     OUString(), LANGUAGE_NONE );
//STRIP001 
//STRIP001             // failed because there is already an entry?
//STRIP001             if (DIC_ERR_NONE != nAddRes && xDic->getEntry( aTmpTxt ).is())
//STRIP001                 nAddRes = DIC_ERR_NONE;
//STRIP001         }
//STRIP001         if (DIC_ERR_NONE != nAddRes)
//STRIP001         {
//STRIP001             SvxDicError( this, nAddRes );
//STRIP001             return 0;   // Nicht weitermachen
//STRIP001         }
//STRIP001 	}
//STRIP001 	// nach dem Aufnehmen ggf. '='-Zeichen entfernen
//STRIP001 	aNewWord.EraseAllChars( sal_Unicode( '=' ) );
//STRIP001 	m_aPlayground->GetWordInputControl().SetText( aNewWord );
//STRIP001 	aAutoCorrBtn.Enable( m_aPlayground->GetWordInputControl().GetText() != m_aPlayground->GetCurrentText() );
//STRIP001 
//STRIP001 	// Bei Bedarf Sprache "andern
//STRIP001     WRAPPER->SetLanguage( GetSelectedLang_Impl() );
//STRIP001 
//STRIP001 	// und weiter...
//STRIP001 	if ( m_aPlayground->GetWordInputControl().GetText() == m_aPlayground->GetCurrentText() )
//STRIP001 	{
//STRIP001 		SpellContinue_Impl();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		ChgHdl(pButton);
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxSpellCheckDialog, SelectHdl, ListBox *, pBox )
//STRIP001 {
//STRIP001 	LanguageType  nSelectedLang = GetSelectedLang_Impl();
//STRIP001 
//STRIP001 	if (&aLangLB == pBox)
//STRIP001 	{
//STRIP001 		BOOL bEnableThes = FALSE;
//STRIP001 		Reference< XThesaurus > xThes( SvxGetThesaurus() );
//STRIP001 		if (xThes.is())
//STRIP001 			bEnableThes = xThes->hasLocale( SvxCreateLocale( nSelectedLang ) );
//STRIP001 		aThesBtn.Enable( bEnableThes );
//STRIP001 
//STRIP001 		Reference< XSpellAlternatives >  xAlt( WRAPPER->GetLast(), UNO_QUERY );
//STRIP001 		if( &aLangLB == pBox && xAlt.is() )
//STRIP001 			Audit_Impl();
//STRIP001 	}
//STRIP001 	else if (&aBookDLB == pBox)
//STRIP001 	{
//STRIP001 		sal_Bool bEnable = sal_False;
//STRIP001 		if ( aBookDLB.GetSelectEntryPos() != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 		{
//STRIP001 			nActDict = aBookDLB.GetSelectEntryPos();
//STRIP001 
//STRIP001 			// Stimmt die Sprache "uberein, dann enable
//STRIP001 			sal_uInt16 nPos = aBookDLB.GetEntry( nActDict ).nId;
//STRIP001             const sal_uInt16 nLang = SvxLocaleToLanguage(
//STRIP001                             pImpl->aDics.getConstArray()[ nPos ]->getLocale() );
//STRIP001 
//STRIP001             if ( nLang == nSelectedLang ||
//STRIP001                 nLang == LANGUAGE_NONE ) // LANGUAGE_DONTKNOW
//STRIP001                 bEnable = sal_True;
//STRIP001 		}
//STRIP001 		aAddBtn.Enable( bEnable );
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool SvxSpellCheckDialog::Close()
//STRIP001 {
//STRIP001 	if ( BTN_LOCK )
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	BTN_LOCKING( sal_True );
//STRIP001 	WRAPPER->SpellEnd();
//STRIP001 	BTN_LOCKING( sal_False );
//STRIP001 	return SfxModalDialog::Close();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxSpellCheckDialog::Audit_Impl()
//STRIP001 {
//STRIP001 	Reference< XSpellAlternatives >  xSpellAlt( WRAPPER->GetLast(), UNO_QUERY );
//STRIP001 
//STRIP001 	DBG_ASSERT(xSpell.is() && xSpellAlt.is(), "unexpected behaviour");
//STRIP001 	if (!(xSpell.is() && xSpellAlt.is()))
//STRIP001 		return;
//STRIP001 
//STRIP001 	// Fehlerkontext aufspannen
//STRIP001 	SfxErrorContext aContext( ERRCTX_SVX_LINGU_SPELLING, String(), this,
//STRIP001 							  RID_SVXERRCTX, DIALOG_MGR() );
//STRIP001 
//STRIP001 	// Wort Direct pr"ufen
//STRIP001 	String aTmp( m_aPlayground->GetWordInputControl().GetText() );
//STRIP001 //	String aTmp2( U2S(xSpellAlt->getWord()) );
//STRIP001 	String aTmp2( aOldWord );
//STRIP001 
//STRIP001 	// Bitte warten ...
//STRIP001 	EnterWait();
//STRIP001 
//STRIP001 //	const sal_uInt16 nOld = xSpellAlt->getLanguage();
//STRIP001 	const sal_uInt16 nOld = nOldLang;
//STRIP001 	sal_uInt16 nLang = GetSelectedLang_Impl();
//STRIP001 
//STRIP001 	// zeitweise die Sprache umschalten
//STRIP001 	//
//STRIP001 	FASTBOOL bAll = sal_False;
//STRIP001 	sal_Int16	 nErr = -1;
//STRIP001 
//STRIP001 	Reference< XSpellAlternatives >  xTmpSpellAlt;
//STRIP001 	sal_Bool bTestOk=sal_True;
//STRIP001 	sal_Bool bInvalidLang = sal_False;
//STRIP001 
//STRIP001 	if ( ( nOld != nLang || aTmp != aTmp2 ) &&
//STRIP001 		 nLang != LANGUAGE_DONTKNOW)
//STRIP001 	{
//STRIP001 		if (xSpell->hasLanguage( nLang ))
//STRIP001 		{
//STRIP001 			xTmpSpellAlt = xSpell->spell( aTmp, nLang,
//STRIP001 										  Sequence< PropertyValue >() );
//STRIP001 			if(!xTmpSpellAlt.is())
//STRIP001 				bTestOk = sal_False;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			bInvalidLang = sal_True;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		bAll = sal_True;
//STRIP001 
//STRIP001 	nOldLang = nLang;
//STRIP001 	aOldWord = aTmp;
//STRIP001 
//STRIP001 	sal_Bool bIsSpellError 	= sal_False;
//STRIP001 	sal_Int16 nAltCount 	= 0;
//STRIP001 	if (xTmpSpellAlt.is())
//STRIP001 	{
//STRIP001 		bIsSpellError = sal_True;	//xTmpSpellAlt->getFailureType() == SpellFailure::SPELLING_ERROR;
//STRIP001 		nAltCount 	  = xTmpSpellAlt->getAlternativesCount();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bAll /*|| (bIsSpellError  &&  nAltCount == 0)*/ )
//STRIP001 	{
//STRIP001 		// ErrorLink ausschalten
//STRIP001 		//Link aOldLnk( pSpell->ChgErrorLink( Link() ) );
//STRIP001 
//STRIP001 		// andere Sprachen automatisch pr"ufen
//STRIP001 		// auch wenn beliebiger Schwachsinn rauskommt
//STRIP001 		// NUR: wenn Sprache KEINE oder die neue die Alte ist oder die Sprache
//STRIP001 		// nicht vorhanden ist
//STRIP001 		sal_uInt16 nMaxAlt	  	= 0;
//STRIP001 		sal_uInt16 nMaxAltLang	= LANGUAGE_NONE;
//STRIP001 
//STRIP001         Sequence< INT16 > aLang;
//STRIP001         if (xSpell.is())
//STRIP001             aLang = xSpell->getLanguages();
//STRIP001         sal_Int32 nLangCount = aLang.getLength();
//STRIP001         const INT16 *pLang = aLang.getConstArray();
//STRIP001         for (INT32 i = 0;  i < nLangCount;  ++i)
//STRIP001 		{
//STRIP001             INT16 nNewLang = pLang[i];
//STRIP001 			if ( xSpell->hasLanguage( nNewLang ) )
//STRIP001 			{
//STRIP001 				xTmpSpellAlt = xSpell->spell( aTmp, nNewLang,
//STRIP001 											  Sequence< PropertyValue >() );
//STRIP001 
//STRIP001 				if ( !xTmpSpellAlt.is() )	// correct spelling?
//STRIP001 				{
//STRIP001 					aLangLB.SelectLanguage( nNewLang );
//STRIP001                     break;
//STRIP001 				}
//STRIP001 				else if ( xTmpSpellAlt->getAlternativesCount() > nMaxAlt )
//STRIP001 				{
//STRIP001 					nMaxAlt = xTmpSpellAlt->getAlternativesCount();
//STRIP001 					nMaxAltLang = nNewLang;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// was the spelling of the word wrong in all the languages
//STRIP001 		// checked above?
//STRIP001 		if ( xTmpSpellAlt.is() )
//STRIP001 		{
//STRIP001 			if ( nMaxAlt > 0 )
//STRIP001 			{
//STRIP001 				// Die Sprache mit den meisten Alternativen anzeigen
//STRIP001 				// den richtigen Eintrag finden, da sortiert
//STRIP001 				aLangLB.SelectLanguage( nMaxAltLang );
//STRIP001 				LanguageType nSelLang = aLangLB.GetSelectLanguage();
//STRIP001 				DBG_ASSERT( nSelLang != LANGUAGE_DONTKNOW,
//STRIP001 						"correct language not found" );
//STRIP001 				if (nSelLang != LANGUAGE_DONTKNOW)
//STRIP001 				{
//STRIP001 					nOldLang = nSelLang;
//STRIP001 					xTmpSpellAlt = xSpell->spell( aTmp, nSelLang,
//STRIP001 											  	Sequence< PropertyValue >() );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			//else
//STRIP001 			//	pSpell->SetActualLanguage( nLang );
//STRIP001 		}
//STRIP001 		// ErrorHandler wieder installieren
//STRIP001 		//pSpell->ChgErrorLink(aOldLnk);
//STRIP001 	}
//STRIP001 
//STRIP001 	// Alternativen eintragen
//STRIP001 	aNewWordLB.Clear();
//STRIP001 	if(xTmpSpellAlt.is())
//STRIP001 	{
//STRIP001 		sal_uInt16 nCount = xTmpSpellAlt->getAlternativesCount();;
//STRIP001 		Sequence< OUString > aAlt = xTmpSpellAlt->getAlternatives();
//STRIP001 		const OUString *pStr = aAlt.getConstArray();
//STRIP001 		for( sal_uInt16 i=0; i < nCount; ++i )
//STRIP001 		{
//STRIP001 			String aTmp( pStr[i] );
//STRIP001 			if ( LISTBOX_ENTRY_NOTFOUND == aNewWordLB.GetEntryPos( aTmp ) )
//STRIP001 				aNewWordLB.InsertEntry( aTmp );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	m_aPlayground->GetWordInputControl().GrabFocus();
//STRIP001 
//STRIP001 	if (aNewWordLB.GetEntryCount())
//STRIP001 	{
//STRIP001 		aNewWordLB.Enable();
//STRIP001 
//STRIP001 		long nPos= m_aPlayground->GetWordInputControl().GetText().Len();
//STRIP001 		Selection aSel(nPos, nPos);
//STRIP001 		m_aPlayground->GetWordInputControl().SetSelection(aSel);	// Alles selektieren
//STRIP001 	}
//STRIP001 
//STRIP001 	// Status anzeigen
//STRIP001 
//STRIP001 	if (bInvalidLang)
//STRIP001 	{
//STRIP001 		m_aPlayground->SetStatusText( SVX_RESSTR( RID_SVXSTR_HMSTATUS_INVALID_LANG ) );
//STRIP001 		aStateImage.Hide();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		String aTxt;
//STRIP001 		aStateImage.Show();
//STRIP001 
//STRIP001 		if(!xTmpSpellAlt.is())
//STRIP001 		{
//STRIP001 			aTxt = SVX_RESSTR( RID_SVXSTR_HMSTATUS_OK );
//STRIP001 			aStateImage.SetImage(aTrueStateIm);
//STRIP001 			m_aPlayground->UpdateChangesHelp();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			int nRID = RID_SVXSTR_HMSTATUS_OK;
//STRIP001 			switch (xTmpSpellAlt->getFailureType())
//STRIP001 			{
//STRIP001 				case SpellFailure::IS_NEGATIVE_WORD : nRID = RID_SVXSTR_HMSTATUS_DONTUSE; break;
//STRIP001 				case SpellFailure::CAPTION_ERROR : 	 nRID = RID_SVXSTR_HMSTATUS_CAPERROR; break;
//STRIP001 				case SpellFailure::SPELLING_ERROR :	 nRID = RID_SVXSTR_HMSTATUS_WRONG; break;
//STRIP001 				default :
//STRIP001 					DBG_ERROR("unexpected SpellFailure type");
//STRIP001 			}
//STRIP001 
//STRIP001 			aTxt = SVX_RESSTR( nRID );
//STRIP001 			aStateImage.SetImage(aFalseStateIm);
//STRIP001 		}
//STRIP001 		m_aPlayground->SetStatusText( aTxt );
//STRIP001 		UniString aStrTmp( aStateStr );
//STRIP001 		aStrTmp.Append( aTxt );
//STRIP001 		aStateImage.SetQuickHelpText( aStrTmp );
//STRIP001 	}
//STRIP001 
//STRIP001 	LeaveWait();
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 String SvxSpellCheckDialog::AddPreAndPost_Impl( const String& rStr )
//STRIP001 {
//STRIP001 	return rStr;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxSpellCheckDialog, WordSelectHdl, ListBox *, EMPTYARG )
//STRIP001 {
//STRIP001 	if(aNewWordLB.GetEntryCount()>0)
//STRIP001 	{
//STRIP001 		String aString=aNewWordLB.GetSelectEntry();
//STRIP001 		m_aPlayground->GetWordInputControl().SetText(aString);
//STRIP001 		bModified=sal_False;
//STRIP001 		SetAddBtnHelp(m_aPlayground->GetCurrentText());
//STRIP001 		m_aPlayground->UpdateChangesHelp( aString );
//STRIP001 		aStateImage.SetImage(aTrueStateIm);
//STRIP001 		String aStr = aStateStr;
//STRIP001 		aStr += SVX_RESSTR( RID_SVXSTR_HMSTATUS_OK );
//STRIP001 		aStateImage.SetQuickHelpText(aStr);
//STRIP001 
//STRIP001 		aStateImage.Show();
//STRIP001 
//STRIP001 		aAutoCorrBtn.Enable( m_aPlayground->GetWordInputControl().GetText() != m_aPlayground->GetCurrentText() );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxSpellCheckDialog::HideAutoCorrect()
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Applikationen, die keine Autokorrektur unterst"utzen,
//STRIP001 	k"onnen mit dieser Methode diesen Eintrag aus dem Men"u entfernen
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	aAutoCorrBtn.Hide();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxSpellCheckDialog::SetSelectedLang_Impl( LanguageType nLang )
//STRIP001 {
//STRIP001 	aLangLB.SelectLanguage( nLang );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 LanguageType SvxSpellCheckDialog::GetSelectedLang_Impl() const
//STRIP001 {
//STRIP001 	INT16 nLang = aLangLB.GetSelectLanguage();
//STRIP001 	return nLang;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxSpellCheckDialog::SetLanguage( sal_uInt16 nLang )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	wenn die Sprache im Thesaurus umgestellt wurde,
//STRIP001 	muss auch hier die Sprache umgestellt werden.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	String aStr( aTitel );
//STRIP001 	aStr.Append( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( " (" ) ) );
//STRIP001 	aStr.Append( ::GetLanguageString( (LanguageType)nLang ) );
//STRIP001 	aStr.Append( sal_Unicode( ')' ) );;
//STRIP001 	SetText( aStr );
//STRIP001 
//STRIP001 	// den richtigen Eintrag finden, da sortiert
//STRIP001 	aLangLB.SelectLanguage( nLang );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK(SvxSpellCheckDialog, DirectionHdl, CheckBox*, pBox)
//STRIP001 {
//STRIP001 	Reference< XPropertySet >  xProp( SvxGetLinguPropertySet() );
//STRIP001 	if (xProp.is())
//STRIP001 	{
//STRIP001 		BOOL bVal = pBox->IsChecked();
//STRIP001 		Any aBool(&bVal, ::getBooleanCppuType());
//STRIP001 		xProp->setPropertyValue( C2U(UPN_IS_WRAP_REVERSE), aBool );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 };
//STRIP001 
//STRIP001 void SvxSpellCheckDialog::SetAddBtnHelp(const String& rString)
//STRIP001 {
//STRIP001 	String aString = GetNonMnemonicString( aAddBtn.GetText() );
//STRIP001 	aString.Append( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) ) );
//STRIP001 	aString.Append( rString );
//STRIP001 	aAddBtn.SetQuickHelpText(aString);
//STRIP001 }
//STRIP001 
//STRIP001 void SvxSpellCheckDialog::InitUserDicts()
//STRIP001 {
//STRIP001 	sal_uInt16 nLang = aLangLB.GetSelectLanguage();
//STRIP001 
//STRIP001 	const Reference< XDictionary >  *pDic = 0;
//STRIP001 
//STRIP001     // get list of dictionaries
//STRIP001     Reference< XDictionaryList >  xDicList( SvxGetDictionaryList() );
//STRIP001     if (xDicList.is())
//STRIP001     {
//STRIP001         // add active, positive dictionary to dic-list (if not already done).
//STRIP001         // This is to ensure that there is at least on dictionary to which
//STRIP001         // words could be added.
//STRIP001         Reference< XDictionary1 >  xDic( SvxGetOrCreatePosDic( xDicList ) );
//STRIP001         if (xDic.is())
//STRIP001             xDic->setActive( sal_True );
//STRIP001 
//STRIP001         pImpl->aDics = xDicList->getDictionaries();
//STRIP001     }
//STRIP001 
//STRIP001     // Benutzerbuecher anzeigen
//STRIP001     const sal_Int32 nSize = pImpl->aDics.getLength();
//STRIP001     pDic = pImpl->aDics.getConstArray();
//STRIP001     sal_Int32 i;
//STRIP001     for (i = 0; i < nSize; ++i )
//STRIP001     {
//STRIP001         Reference< XDictionary1 >  xDic( pDic[i], UNO_QUERY );
//STRIP001         if (!xDic.is() || SvxGetIgnoreAllList() == xDic)
//STRIP001             continue;
//STRIP001 
//STRIP001         // add only active and not read-only dictionaries to list
//STRIP001         // from which to choose from
//STRIP001         Reference< frame::XStorable > xStor( xDic, UNO_QUERY );
//STRIP001         if ( xDic->isActive()  &&  (!xStor.is() || !xStor->isReadonly()) )
//STRIP001         {
//STRIP001             sal_Bool bNegativ = xDic->getDictionaryType() == DictionaryType_NEGATIVE;
//STRIP001             aBookDLB.InsertEntry( SvxBoxEntry(
//STRIP001                 ::GetDicInfoStr( xDic->getName(),
//STRIP001                                 xDic->getLanguage(), bNegativ ), i ) );
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001 	aAddBtn.Disable();
//STRIP001 
//STRIP001     sal_uInt16 k;
//STRIP001     for ( k = 0; k < aBookDLB.GetEntryCount(); ++k )
//STRIP001 	{
//STRIP001         sal_uInt16 nId = aBookDLB.GetEntry(k).nId;
//STRIP001 		sal_Bool bFound = sal_False;
//STRIP001 
//STRIP001         const sal_uInt16 nDicLang  = SvxLocaleToLanguage( pDic[nId]->getLocale() );
//STRIP001         const sal_Bool bDicNegativ =
//STRIP001             pDic[nId]->getDictionaryType() == DictionaryType_NEGATIVE;
//STRIP001         // Stimmt die Sprache "uberein, dann enable
//STRIP001         if ((nDicLang == nLang || nDicLang == LANGUAGE_NONE) && !bDicNegativ)
//STRIP001             bFound = sal_True;
//STRIP001 
//STRIP001 		if (bFound)
//STRIP001 		{
//STRIP001             aBookDLB.SelectEntryPos(k);
//STRIP001 			aAddBtn.Enable();
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK(SvxSpellCheckDialog, ModifyHdl, Edit *, pEd)
//STRIP001 {
//STRIP001 	if (&m_aPlayground->GetWordInputControl() == pEd)
//STRIP001 	{
//STRIP001 		bModified=sal_True;
//STRIP001 		aStateImage.Hide();
//STRIP001 		m_aPlayground->SetStatusText( String() );
//STRIP001 		aNewWordLB.SetNoSelection();
//STRIP001         aNewWordLB.Disable();
//STRIP001 		aTestBtn.Enable();
//STRIP001 		String sNewText( m_aPlayground->GetWordInputControl().GetText() );
//STRIP001 		SetAddBtnHelp( sNewText );
//STRIP001 		m_aPlayground->UpdateChangesHelp( );
//STRIP001 
//STRIP001 		aAutoCorrBtn.Enable( sNewText != m_aPlayground->GetCurrentText() );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 };
//STRIP001 
//STRIP001 IMPL_LINK(SvxSpellCheckDialog, AuditHdl, Button *, pButton )
//STRIP001 {
//STRIP001 	if(pButton!=NULL)
//STRIP001 	{
//STRIP001 		Audit_Impl();
//STRIP001 
//STRIP001 		// ggf. wurde die aktuelle Sprache ge"andert,
//STRIP001 		// dann mu/s vielleicht ein anderes W"orterbuch selektiert werden
//STRIP001 		sal_uInt16 nLang = aLangLB.GetSelectLanguage();
//STRIP001 		aAddBtn.Disable();
//STRIP001 
//STRIP001 		for ( sal_uInt16 i = 0; i < aBookDLB.GetEntryCount(); ++i )
//STRIP001 		{
//STRIP001 			sal_uInt16 nDicPos = aBookDLB.GetEntry(i).nId;
//STRIP001 			const sal_uInt16 nDicLang = SvxLocaleToLanguage(
//STRIP001 					pImpl->aDics.getConstArray()[ nDicPos ]->getLocale() );
//STRIP001 
//STRIP001 			// Stimmt die Sprache "uberein, dann enable
//STRIP001 			if ( nDicLang == nLang || nDicLang == LANGUAGE_NONE )
//STRIP001 			{
//STRIP001 				// den ersten selektieren
//STRIP001 				aBookDLB.SelectEntryPos(i);
//STRIP001 				aAddBtn.Enable();
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 };
//STRIP001 
//STRIP001 IMPL_LINK(SvxSpellCheckDialog, CancelHdl, Button *, pButton )
//STRIP001 {
//STRIP001 	Close();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( SvxSpellCheckDialog, ClickHdl, Control*, pCtr )
//STRIP001 {
//STRIP001 	if(pCtr!=NULL)
//STRIP001 	{
//STRIP001 		bModified=sal_True;
//STRIP001 		m_aPlayground->GetWordInputControl().SetText(pCtr->GetText());
//STRIP001 		aStateImage.SetImage(aFalseStateIm);
//STRIP001 		aStateImage.Show();
//STRIP001 		String aStr = aStateStr;
//STRIP001 		aStr += SVX_RESSTR( RID_SVXSTR_HMSTATUS_WRONG );
//STRIP001 		aStateImage.SetQuickHelpText(aStr);
//STRIP001 
//STRIP001 		SetAddBtnHelp(pCtr->GetText());
//STRIP001 		m_aPlayground->UpdateChangesHelp( );
//STRIP001 		m_aPlayground->GetWordInputControl().GrabFocus();
//STRIP001 		long nPos= m_aPlayground->GetWordInputControl().GetText().Len();
//STRIP001 		Selection aSel(0, nPos);
//STRIP001 		m_aPlayground->GetWordInputControl().SetSelection(aSel);
//STRIP001 
//STRIP001 //        aNewWordLB.SetNoSelection();
//STRIP001 //        aNewWordLB.Disable();
//STRIP001 
//STRIP001 		aAutoCorrBtn.Enable( m_aPlayground->GetWordInputControl().GetText() != m_aPlayground->GetCurrentText() );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 };
//STRIP001 
//STRIP001 IMPL_LINK(SvxSpellCheckDialog, ErrorHdl, void*, pDontKnow)
//STRIP001 {
//STRIP001 	aStateImage.SetImage(aFalseStateIm);
//STRIP001 	aStateImage.Show();
//STRIP001 	String aStr = aStateStr;
//STRIP001 	aStr += SVX_RESSTR( RID_SVXSTR_HMSTATUS_WRONG );
//STRIP001 	aStateImage.SetQuickHelpText(aStr);
//STRIP001 
//STRIP001 	m_aPlayground->SetStatusText(aErrorStr);
//STRIP001 	return 0;
//STRIP001 };


}
