/*
 * GProFTPD - A GTK+ frontend for the ProFTPD standalone server.
 * Copyright (C) 2001 - 2006 Magnus Loef (Magnus-swe) <magnus-swe@telia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
 */



#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "gettext.h"
#include "widgets.h"
#include "allocate.h"
#include "chars_are_digits.h"
#include "populate_server_settings.h"


extern char global_server_address[1024];
extern char global_server_port[1024];
extern char global_server_type[1024];

extern int use_tls;



void populate_server_settings(struct w *widgets)
{
    /* Lists the values for the selected server in the server tab */
    FILE *fp;
    int x = 0, val = 0, found = 0;
    long conf_size;
    char *old_buffer, *port_buffer, *translate, *new_buffer, *address_buffer, *gprotls_conf;
    gchar *utf8 = NULL;

    if((fp=fopen(PROFTPD_CONF, "r"))==NULL)
    {
	/* We just show this popup here too many windows looks bad */
//	sprintf(info_buffer, "%s %s", _("List server: Cant open proftpd.conf here:\n"), PROFTPD_CONF);
//        info_window = create_info_window ();
//        gtk_widget_show (info_window);
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    old_buffer = allocate(conf_size);
    new_buffer = allocate(conf_size);               
    address_buffer = allocate(8192+15);
    translate = allocate(1024);

    if( strstr(global_server_type, "Virtualhost") )
    {
       sprintf(address_buffer, "<VirtualHost %s>", global_server_address);
    }
    else
       sprintf(address_buffer, global_server_address);
     
      port_buffer = allocate(8192+3);               

      sprintf(port_buffer, "Port %s", global_server_port);

      if( ! strstr((char *)global_server_type, "Virtualhost") )
        found=1;

    if( conf_size > 1 )
    while(fgets(old_buffer, conf_size, fp)!=NULL)
    {                                 
	if( strlen(old_buffer) > 8000 )
	{
//	    sprintf(info_buffer, _("A line with over 8000 chars is not valid in: %s\n"), PROFTPD_CONF);
//    	    info_window=create_info_window();
//    	    gtk_widget_show(info_window);
	    fclose(fp);
	    free(old_buffer);
	    free(new_buffer);
            free(address_buffer);
	    free(port_buffer);
	    free(translate);
	    return;
	}

	
	/* We have all the values for the selected default server */
	if( strstr(old_buffer, "<Anonymous") && strstr((char *)global_server_type, "Default server") )
	  break;           


        /* We have a virtualhost with the same address as the selected server */
        if( strstr("Virtualhost", (char *)global_server_type) && ! found
	&&  strstr(old_buffer, address_buffer) )
	{
	    /* Lets see if its the same port as the selected one */

	    /* If this server has the same port its the correct server .. the end. */
	    while(fgets(old_buffer, conf_size, fp)!=NULL)
	    {
		if( strlen(old_buffer) > 8000 )
		  continue;
	    
		/* This will expect the servers port on the second line ! 
		 * else itll miss some vaules .. */
		if( strstr(old_buffer, "Port") && strstr(old_buffer, port_buffer) )
		{
		    found=1;
		    break;
		}
		
		if( strstr(old_buffer, "</Virtualhost>") )
		  break;
	    }    
	}

	

	/* Continue until we find the selected server */
	if( ! found )
	  continue;


	/* Read and insert the selected servers values in the servers tab */

	/* If its the default server we stop listing the values when a vhost or anonymous is found */
	if( ! strstr("Virtualhost", (char *)global_server_type)
	&& ( strstr(old_buffer, "<Anonymous") || strstr(old_buffer, "<VirtualHost") ) )
	   break;

	/* In any case after listing the correct vhost and anon user we break */
	if( strstr(old_buffer, "<Anonymous") && found )
	   break;

	/* In any case after listing the correct vhost we break */
	if( strstr(old_buffer, "</VirtualHost") && found )
	   break;

	/* The name of the server */	
   	if( strstr(old_buffer, "ServerName") )
	{   
	    for(x=0; old_buffer[x]!='\0'; x++)
	    {
	        if( old_buffer[x]=='"' )
		  break;
	    }
	    x++;
	    if( old_buffer[x]!='\0' )
	      sprintf(new_buffer, &old_buffer[x]);
	    for(x=0; new_buffer[x]!='\0'; x++)
	    {
	        if( new_buffer[x]=='"' )
	        {
		    new_buffer[x]='\0';
		    break;
		}
	    }

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[0]), utf8);
	}

	if( strstr(old_buffer, "ServerIdent") )
	{
	    for(x=0; old_buffer[x]!='\0'; x++)
	    {
	        if( old_buffer[x]=='"' )
		  break;
	    }
	    x++;
	    if( old_buffer[x]!='\0' )
	      sprintf(new_buffer, &old_buffer[x]);
	    for(x=0; new_buffer[x]!='\0'; x++)
	    {
	        if( new_buffer[x]=='"' || new_buffer[x]=='\n' )
	        {
		    new_buffer[x]='\0';
		    break;
		}
	    }
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[1]), utf8);

	    if( strstr(old_buffer, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[0]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[0]), 1);
	}

	if( strstr(old_buffer, "MasqueradeAddress") )
	{
	    new_buffer[0]='\0';
	    sscanf(old_buffer, "%*s %s", new_buffer);
	    if( strlen(new_buffer) > 3 )
	    {
		if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	          new_buffer[strlen(new_buffer)-1]='\0';
        	utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
		gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[2]), utf8);
	    }

	    if( ! strstr(old_buffer, "#") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[1]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[1]), 1);
	}

   	if( strstr(old_buffer, "ServerAdmin") )
	{   
	    sprintf(new_buffer, &old_buffer[12]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[3]), utf8);
	}

	if( strstr(old_buffer, "IdentLookups") )
	{
	    if( strstr(old_buffer, "IdentLookups on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[2]), 0);

	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[2]), 1);
	}

        if( strstr(old_buffer, "UseReverseDNS") )
	{
	    if( strstr(old_buffer, "UseReverseDNS on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[3]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[3]), 1);
	}

	/* Off is local time */
	if( strstr(old_buffer, "TimesGMT") )
	{
	    if( strstr(old_buffer, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[4]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[4]), 1);
	}

	/* Dont match passiveports */
  	if( strstr(old_buffer, "Port") && old_buffer[4]==' ' && ! strstr(old_buffer, "PassivePorts") )
	{
	    sscanf(old_buffer, "%*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[0]), val);
	    }
	}

  	if( strstr(old_buffer, "PassivePorts")  )
        {
	    new_buffer[0]='\0';
	    sscanf(old_buffer, "%*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    if( chars_are_digits(new_buffer) )
	    {
               val = atoi(new_buffer);
               gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[1]), val);
	    }

	    new_buffer[0]='\0';
    	    sscanf(old_buffer, "%*s %*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    if( chars_are_digits(new_buffer))
	    {
               val=atoi(new_buffer);
               gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[2]), val);
	    }
	}

	/* Maximum simoultaneous connections */
	if( strstr(old_buffer, "MaxInstances") )
	{
	    new_buffer[0]='\0';
	    sscanf(old_buffer, "%*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[3]), val);
	    }

	}

	/* Max login attempts */
	if( strstr(old_buffer, "MaxLoginAttempts") )
	{
	    new_buffer[0]='\0';
	    sscanf(old_buffer, "%*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[4]), val);
	    }
	}

	/* Login timeout */
	if( strstr(old_buffer, "TimeoutLogin") )
	{
	    new_buffer[0]='\0';
	    sscanf(old_buffer, "%*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[5]), val);
	    }
	}
	
	/* Idle timeout */
	if( strstr(old_buffer, "TimeoutNoTransfer") )
	{
	    new_buffer[0]='\0';
	    sscanf(old_buffer, "%*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
// IdleTimeout
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[6]), val);
	    }
	}

	/* Upload speed */
	if( strstr(old_buffer, "TransferRate STOR") )
	{
	    new_buffer[0]='\0';
	    sscanf(old_buffer, "%*s %*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[9]), val);
	    }
	}

	/* Dowonload speed */
	if( strstr(old_buffer, "TransferRate RETR") )
	{
	    new_buffer[0]='\0';
	    sscanf(old_buffer, "%*s %*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[10]), val);
	    }
	}
	
	/* Transfer mode */	
	if( strstr(old_buffer, "DefaultTransferMode") )
	{
	    if( strstr(old_buffer, "binary") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[5]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[5]), 1);
	}

	/* FXP transfers */
	if( strstr(old_buffer, "AllowForeignAddress") )
	{
	    if( strstr(old_buffer, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[6]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[6]), 1);
	}

	/* Server user */
	if( strstr(old_buffer, "User") && old_buffer[4]==' ' )
	{
	    sscanf(old_buffer, "%*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[9]), utf8);
	}

	/* Server group */
	if( strstr(old_buffer, "Group") && old_buffer[5]==' ' )
	{
	    sscanf(old_buffer, "%*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[10]), utf8);
	}

	if( strstr(old_buffer, "DirFakeUser") )
	{
	    /* Show the fake username */
	    sscanf(old_buffer, "%*s %*s %s", new_buffer); 
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[11]), utf8);

	    /* Show fake user on - off */
	    sscanf(old_buffer, "%*s %s", new_buffer); 
	    if( strstr(new_buffer, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[8]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[8]), 1);
	}

	if( strstr(old_buffer, "DirFakeGroup") )
	{
	    /* Show the fake groupname */
	    sscanf(old_buffer, "%*s %*s %s", new_buffer); 
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[12]), utf8);

	    /* Show fake group on - off */
	    sscanf(old_buffer, "%*s %s", new_buffer); 
	    if( strstr(new_buffer, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[9]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[9]), 1);
	}

	if( strstr(old_buffer, "AllowStoreRestart") )
	{
	    sscanf(old_buffer, "%*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    if( strstr(old_buffer, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[10]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[10]), 1);
	}

	if( strstr(old_buffer, "AllowRetrieveRestart") )
	{
	    sscanf(old_buffer, "%*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    if( strstr(old_buffer, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[11]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[11]), 1);
	}

	if( strstr(old_buffer, "DeleteAbortedStores") )
	{
	    if( strstr(old_buffer, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[12]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[12]), 1);
	}

	if( strstr(old_buffer, "SystemLog") )
	{
	    sprintf(new_buffer, &old_buffer[10]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[8]), utf8);
	}
	if( strstr(old_buffer, "gp_random_username_length") )
	{
	    sscanf(old_buffer, "%*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[7]), val);
	    }
	}
	if( strstr(old_buffer, "gp_random_password_length") )
	{
	    sscanf(old_buffer, "%*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[8]), val);
	    }
	}
	if( strstr(old_buffer, "gp_randomize_case") )
	{
	    if( strstr(old_buffer, "upper") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[7]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[7]), 1);
	}

	/* This will be deprecated in a few years, the default conf adds gp_useradd_homedir_path (changed 2005-08-24) */
	if( strstr(old_buffer, "gp_useradd_root_path") )
	{
	    sprintf(new_buffer, &old_buffer[22]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[4]), utf8);
	}

	if( strstr(old_buffer, "gp_useradd_homedir_path") )
	{
	    sprintf(new_buffer, &old_buffer[25]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[4]), utf8);
	}

	if( strstr(old_buffer, "gp_useradd_upload_path") )
	{
	    sprintf(new_buffer, &old_buffer[24]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[5]), utf8);
	}
	if( strstr(old_buffer, "gp_html_path") )
	{
	    sprintf(new_buffer, &old_buffer[14]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[6]), utf8);
	}


	if( use_tls )
	{
	    if( strstr(old_buffer, "TLSEngine") )
	    {
		if( strstr(old_buffer, "on") )
	          gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[13]), 0);
		else
	          gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[13]), 1);
	    }

	    /* On(Both), Off, Data, Control, */
	    if( strstr(old_buffer, "TLSRequired") )
	    {
		if( strstr(old_buffer, "on") )
	          gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[14]), 0);
		if( strstr(old_buffer, "off") )
	          gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[14]), 1);
		if( strstr(old_buffer, "data") )
	          gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[14]), 2);
		if( strstr(old_buffer, "ctrl") )
	          gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[14]), 3);
	    }

	    if( strstr(old_buffer, "TLSVerifyClient") )
	    {
		if( strstr(old_buffer, "on") )
	          gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[15]), 0);
		else
	          gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[15]), 1);
	    }

	    if( strstr(old_buffer, "TLSProtocol") )
	    {
		sprintf(new_buffer, "%s", &old_buffer[12]);
		if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	    	  new_buffer[strlen(new_buffer)-1]='\0';

		utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
        	gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[13]), utf8);
	    }
	    if( strstr(old_buffer, "TLSLog") )
	    {
		sprintf(new_buffer, &old_buffer[7]); 
		if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	    	  new_buffer[strlen(new_buffer)-1]='\0';

		utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
        	gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[14]), utf8);
	    }
	    if( strstr(old_buffer, "TLSRSACertificateFile") )
	    {
		sprintf(new_buffer, &old_buffer[22]); 
		if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	    	  new_buffer[strlen(new_buffer)-1]='\0';

		utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
        	gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[15]), utf8);
	    }
	}  /* If use_tls (proftpd.conf values) */
    }
    fclose(fp);
    free(old_buffer);
    free(new_buffer);
    free(address_buffer);
    free(port_buffer);


    /* If we have the TLS module then list the values for it from gprotls.conf. */
    if( use_tls )
    {
	/* If we have a gprotls.conf then list the certificate values */
	gprotls_conf = allocate(strlen(GP_APPCONFDIR)+14);
	sprintf(gprotls_conf, "%s%s", GP_APPCONFDIR, "/gprotls.conf");
	if((fp=fopen(gprotls_conf, "r"))==NULL)
	{
	}
	else
	    {
	        fseek(fp, 0, SEEK_END);
	        conf_size = ftell(fp);
	        rewind(fp);
	        old_buffer = allocate(conf_size);
	        new_buffer = allocate(conf_size);

		if( conf_size > 1 )
	        while(fgets(old_buffer, conf_size, fp)!=NULL)
	        {
		    /* Server address */
		    if( strstr(old_buffer, "CN ") )
		    {
			for(x=0; old_buffer[x]; x++)
			{
			    if( old_buffer[x-2]=='=' )
			    {
				snprintf(new_buffer, old_buffer[x]+x, old_buffer+x);
				new_buffer[strlen(new_buffer)-1]='\0';
				utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
				gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[16]), utf8);
			    }
			}
		    }
		    /* Email address */
		    if( strstr(old_buffer, "emailAddress ") )
		    {
			for(x=0; old_buffer[x]; x++)
			{
			    if( old_buffer[x-2]=='=' )
			    {
				snprintf(new_buffer, old_buffer[x]+x, old_buffer+x);
				new_buffer[strlen(new_buffer)-1]='\0';
				utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
				gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[17]), utf8);
			    }
			}
		    }
		    /* State or province */
		    if( strstr(old_buffer, "ST ") )
		    {
			for(x=0; old_buffer[x]; x++)
			{
			    if( old_buffer[x-2]=='=' )
			    {
				snprintf(new_buffer, old_buffer[x]+x, old_buffer+x);
				new_buffer[strlen(new_buffer)-1]='\0';
				utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
				gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[18]), utf8);
			    }
			}
		    }
		    /* City or town */
		    if( strstr(old_buffer, "L ") )
		    {
			for(x=0; old_buffer[x]; x++)
			{
			    if( old_buffer[x-2]=='=' )
			    {
				snprintf(new_buffer, old_buffer[x]+x, old_buffer+x);
				new_buffer[strlen(new_buffer)-1]='\0';
				utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
				gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[19]), utf8);
			    }
			}
		    }
		    /* Organization */
		    if( strstr(old_buffer, "O ") )
		    {
			for(x=0; old_buffer[x]; x++)
			{
			    if( old_buffer[x-2]=='=' )
			    {
				snprintf(new_buffer, old_buffer[x]+x, old_buffer+x);
				new_buffer[strlen(new_buffer)-1]='\0';
				utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
				gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[20]), utf8);
			    }
			}
		    }
		    /* Organizational unit */
		    if( strstr(old_buffer, "OU ") )
		    {
			for(x=0; old_buffer[x]; x++)
			{
			    if( old_buffer[x-2]=='=' )
			    {
				snprintf(new_buffer, old_buffer[x]+x, old_buffer+x);
				new_buffer[strlen(new_buffer)-1]='\0';
				utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
				gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[21]), utf8);
			    }
			}
		    }
		    /* Default certificate bits */
		    if( strstr(old_buffer, "default_bits") )
		    {
			for(x=0; old_buffer[x]; x++)
			{
    			    if( old_buffer[x-2]=='=' )
			    {
				snprintf(new_buffer, old_buffer[x]+x, old_buffer+x);
				new_buffer[strlen(new_buffer)-1]='\0';
				if( chars_are_digits(new_buffer) )
				{
        			    val = atoi(new_buffer);
        			    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[11]), val);
				}
			    }
			}
        	    }
		    /* Default days valid */
    		    if( strstr(old_buffer, "default_days") )
		    {
			for(x=0; old_buffer[x]; x++)
			{
			    if( old_buffer[x-2]=='=' )
			    {
				snprintf(new_buffer, old_buffer[x]+x, old_buffer+x);
				new_buffer[strlen(new_buffer)-1]='\0';
				if( chars_are_digits(new_buffer) )
				{
        			    val = atoi(new_buffer);
        			    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[12]), val);
				}
			    }
			}
        	    }
		    /* Country code */
		    if( strstr(old_buffer, "C ") )
		    {
			for(x=0; old_buffer[x]; x++)
			{
			    if( old_buffer[x-2]=='=' )
			    {
				snprintf(new_buffer, old_buffer[x]+x, old_buffer+x);
				new_buffer[strlen(new_buffer)-1]='\0';
				utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
				gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[24]), utf8);
			    }
			}
		    }

		}
		free(gprotls_conf);
		free(new_buffer);
		free(old_buffer);
		fclose(fp);
	    }
    }

    free(translate);

    if( utf8!=NULL )
    g_free(utf8);

    gtk_widget_show_all(widgets->main_window);
}
