/* GSAMBAD, an easy to use GTK+ frontend for the SAMBA file and print server.
 * Copyright (C) 2006 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/



#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "commands.h"
#include "allocate.h"
//#include "populate_domain_treeview.h"
//#include "populate_resource_treeview.h"
//#include "populate_resolvers.h"
//#include "populate_root_servers_tab.h"
//#include "populate_log_tab.h"
#include "dialog_if_files_missing.h"
#include "save_settings.h"


//extern char CHROOT_PATH_BUF[1024];
//extern char SYSLOG_PATH_BUF[1024];
//extern char RESOLV_PATH_BUF[1024];



void save_settings(struct w *widgets)
{
    FILE *fp;
    long conf_size;
    char *line, *new_conf;
    gchar *settings_file, *setting;
    G_CONST_RETURN gchar *set_chroot;
    G_CONST_RETURN gchar *set_resolv;
    G_CONST_RETURN gchar *set_syslog;

printf("Not completed, returning\n");
return;

    /* APPCONFDIR is defined at compiletime */
    settings_file = g_strdup_printf("%s/settings.conf", APPCONFDIR);
	    
    if((fp=fopen(settings_file, "r"))==NULL)
    {
        printf("Couldnt open the settings file, remove this printf : %s\n", settings_file);
	g_free(settings_file);
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);
					    
    line = allocate(conf_size+1);
    new_conf = allocate(conf_size+1);

    /* Remove the old settings */
    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( strlen(line) > 1000 )
	  continue;
	
	if( strstr(line, "chroot_directory:") )
	  continue;
	  
	if( strstr(line, "syslog_file_path:") )
	  continue;

	if( strstr(line, "resolv_conf_path:") )
	  continue;

	strcat(new_conf, line);
    }
    fclose(fp);
    free(line);


    set_chroot = gtk_entry_get_text(GTK_ENTRY(widgets->settings_entry[0]));
    set_resolv = gtk_entry_get_text(GTK_ENTRY(widgets->settings_entry[1]));
    set_syslog = gtk_entry_get_text(GTK_ENTRY(widgets->settings_entry[2]));

    /* Update the global paths */
    snprintf(SYSCONFDIR, 1000, "%s", set_chroot);
    snprintf(APPCONFDIR, 1000, "%s", set_resolv);
    snprintf(SECURE_LOG, 1000, "%s", set_syslog);

    /* Write the new settings */
    if((fp=fopen(settings_file, "w+"))==NULL)
    {
        printf("Couldnt open the settings file here:\n%s\n", settings_file);
	g_free(settings_file);
        return;
    }
    fputs(new_conf, fp);

    if( strlen(set_chroot) > 5 )
    {
	setting = g_strdup_printf("\nchroot_directory: %s\n", set_chroot);
	fputs(setting, fp);
	g_free(setting);
    }

    if( strlen(set_chroot) > 5 )
    {
	setting = g_strdup_printf("syslog_file_path: %s\n", set_syslog);
	fputs(setting, fp);
	g_free(setting);
    }
    
    if( strlen(set_chroot) > 5 )
    {
	setting = g_strdup_printf("resolv_conf_path: %s\n", set_resolv);
        fputs(setting, fp);
	g_free(setting);
    }
    
    fclose(fp);
    g_free(settings_file);
    free(new_conf);

    /* Reread the entire gui */
//    populate_domain_treeview(widgets);

//    populate_resource_treeview(widgets);

//    populate_resolvers(widgets);
    
//    populate_root_servers_tab(widgets);
    
//    populate_log_tab(widgets);

    /* If theres no valid chroot in the new 
       location we ask to create one */
    dialog_if_files_missing(widgets);
}
