/************************************************************************************\

  tables.h - HP SANE backend for multi-function peripherals (libsane-hpaio)

  (c) 2001-2004 Copyright Hewlett-Packard Development Company, LP

  Permission is hereby granted, free of charge, to any person obtaining a copy 
  of this software and associated documentation files (the "Software"), to deal 
  in the Software without restriction, including without limitation the rights 
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies 
  of the Software, and to permit persons to whom the Software is furnished to do 
  so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in all
  copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS 
  FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR 
  COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER 
  IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION 
  WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Current Author: Don Welch
  Original Author: David Paschal 

\************************************************************************************/

/* This file contains various color-correction tables needed for specific
 * models. */

#if !defined( __TABLES_H__ )
#define __TABLES_H__

static const char hpTSeriesToneMap[] =
{
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x01,
  0x02,
  0x02,
  0x04,
  0x05,
  0x06,
  0x07,
  0x07,
  0x08,
  0x09,
  0x0A,
  0x0B,
  0x0C,
  0x0D,
  0x0E,
  0x0F,
  0x10,
  0x11,
  0x11,
  0x12,
  0x13,
  0x14,
  0x15,
  0x17,
  0x18,
  0x1A,
  0x1B,
  0x1C,
  0x1C,
  0x1D,
  0x1E,
  0x1F,
  0x20,
  0x21,
  0x22,
  0x23,
  0x24,
  0x25,
  0x26,
  0x27,
  0x28,
  0x29,
  0x2A,
  0x2B,
  0x2C,
  0x2D,
  0x2E,
  0x2F,
  0x30,
  0x31,
  0x32,
  0x33,
  0x34,
  0x35,
  0x36,
  0x37,
  0x38,
  0x39,
  0x3A,
  0x3B,
  0x3C,
  0x3D,
  0x3E,
  0x3F,
  0x40,
  0x41,
  0x42,
  0x43,
  0x44,
  0x45,
  0x46,
  0x46,
  0x47,
  0x48,
  0x49,
  0x4A,
  0x4B,
  0x4C,
  0x4D,
  0x4E,
  0x4F,
  0x50,
  0x51,
  0x52,
  0x53,
  0x54,
  0x55,
  0x56,
  0x57,
  0x58,
  0x5A,
  0x5B,
  0x5C,
  0x5D,
  0x5E,
  0x5F,
  0x60,
  0x61,
  0x62,
  0x63,
  0x64,
  0x65,
  0x66,
  0x67,
  0x69,
  0x6A,
  0x6A,
  0x6B,
  0x6C,
  0x6D,
  0x6E,
  0x6F,
  0x70,
  0x71,
  0x72,
  0x73,
  0x74,
  0x75,
  0x76,
  0x77,
  0x78,
  0x78,
  0x79,
  0x7A,
  0x7B,
  0x7C,
  0x7D,
  0x7E,
  0x7F,
  0x80,
  0x81,
  0x82,
  0x83,
  0x84,
  0x85,
  0x86,
  0x87,
  0x88,
  0x89,
  0x8A,
  0x8A,
  0x8B,
  0x8C,
  0x8D,
  0x8E,
  0x8F,
  0x90,
  0x91,
  0x92,
  0x92,
  0x93,
  0x94,
  0x95,
  0x96,
  0x97,
  0x98,
  0x99,
  0x99,
  0x9A,
  0x9B,
  0x9C,
  0x9D,
  0x9E,
  0x9F,
  0xA0,
  0xA1,
  0xA2,
  0xA3,
  0xA4,
  0xA5,
  0xA6,
  0xA7,
  0xA8,
  0xA9,
  0xAA,
  0xAB,
  0xAB,
  0xAC,
  0xAD,
  0xAE,
  0xAF,
  0xB0,
  0xB1,
  0xB2,
  0xB3,
  0xB4,
  0xB5,
  0xB6,
  0xB7,
  0xB8,
  0xB9,
  0xBA,
  0xBB,
  0xBC,
  0xBD,
  0xBE,
  0xBF,
  0xC0,
  0xC0,
  0xC1,
  0xC2,
  0xC3,
  0xC4,
  0xC5,
  0xC6,
  0xC7,
  0xC8,
  0xC9,
  0xCA,
  0xCB,
  0xCC,
  0xCD,
  0xCE,
  0xD0,
  0xD1,
  0xD2,
  0xD4,
  0xD5,
  0xD6,
  0xD8,
  0xD9,
  0xDA,
  0xDC,
  0xDD,
  0xDE,
  0xE0,
  0xE1,
  0xE2,
  0xE4,
  0xE5,
  0xE7,
  0xE8,
  0xE9,
  0xEB,
  0xEC,
  0xEE,
  0xEF,
  0xF0,
  0xF2,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x01,
  0x02,
  0x03,
  0x04,
  0x05,
  0x06,
  0x07,
  0x09,
  0x0A,
  0x0B,
  0x0C,
  0x0D,
  0x0E,
  0x0F,
  0x10,
  0x11,
  0x12,
  0x13,
  0x14,
  0x15,
  0x16,
  0x17,
  0x18,
  0x1A,
  0x1B,
  0x1C,
  0x1D,
  0x1E,
  0x1F,
  0x21,
  0x22,
  0x23,
  0x24,
  0x25,
  0x26,
  0x27,
  0x28,
  0x29,
  0x2A,
  0x2B,
  0x2C,
  0x2E,
  0x2F,
  0x30,
  0x31,
  0x32,
  0x33,
  0x34,
  0x35,
  0x36,
  0x37,
  0x38,
  0x39,
  0x3A,
  0x3B,
  0x3C,
  0x3D,
  0x3E,
  0x3F,
  0x41,
  0x42,
  0x43,
  0x44,
  0x45,
  0x46,
  0x47,
  0x48,
  0x49,
  0x4A,
  0x4B,
  0x4C,
  0x4D,
  0x4D,
  0x4E,
  0x4F,
  0x50,
  0x51,
  0x52,
  0x53,
  0x54,
  0x55,
  0x56,
  0x57,
  0x58,
  0x59,
  0x5A,
  0x5B,
  0x5D,
  0x5E,
  0x5F,
  0x60,
  0x61,
  0x62,
  0x63,
  0x65,
  0x66,
  0x67,
  0x68,
  0x69,
  0x6A,
  0x6B,
  0x6C,
  0x6D,
  0x6E,
  0x6F,
  0x70,
  0x71,
  0x72,
  0x73,
  0x74,
  0x75,
  0x76,
  0x77,
  0x78,
  0x79,
  0x7A,
  0x7B,
  0x7C,
  0x7C,
  0x7D,
  0x7E,
  0x7F,
  0x80,
  0x81,
  0x82,
  0x83,
  0x84,
  0x85,
  0x86,
  0x86,
  0x87,
  0x88,
  0x89,
  0x8A,
  0x8B,
  0x8C,
  0x8D,
  0x8E,
  0x8F,
  0x90,
  0x91,
  0x92,
  0x93,
  0x94,
  0x95,
  0x96,
  0x97,
  0x98,
  0x99,
  0x9A,
  0x9B,
  0x9C,
  0x9D,
  0x9E,
  0x9F,
  0xA0,
  0xA1,
  0xA2,
  0xA2,
  0xA3,
  0xA4,
  0xA5,
  0xA6,
  0xA7,
  0xA8,
  0xA9,
  0xAA,
  0xAB,
  0xAC,
  0xAD,
  0xAE,
  0xAF,
  0xB0,
  0xB1,
  0xB2,
  0xB3,
  0xB3,
  0xB4,
  0xB5,
  0xB6,
  0xB7,
  0xB8,
  0xB9,
  0xBA,
  0xBB,
  0xBC,
  0xBD,
  0xBD,
  0xBE,
  0xBF,
  0xC0,
  0xC1,
  0xC2,
  0xC3,
  0xC4,
  0xC5,
  0xC6,
  0xC6,
  0xC7,
  0xC8,
  0xC9,
  0xCA,
  0xCC,
  0xCD,
  0xCE,
  0xCF,
  0xD0,
  0xD1,
  0xD2,
  0xD3,
  0xD4,
  0xD5,
  0xD6,
  0xD7,
  0xD8,
  0xD9,
  0xDA,
  0xDC,
  0xDD,
  0xDE,
  0xDF,
  0xE0,
  0xE1,
  0xE2,
  0xE3,
  0xE4,
  0xE5,
  0xE6,
  0xE7,
  0xE8,
  0xEA,
  0xEB,
  0xEC,
  0xED,
  0xEE,
  0xEF,
  0xF0,
  0xF1,
  0xF2,
  0xF3,
  0xF4,
  0xF6,
  0xF7,
  0xF8,
  0xF9,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x01,
  0x02,
  0x03,
  0x04,
  0x05,
  0x06,
  0x07,
  0x08,
  0x09,
  0x0A,
  0x0C,
  0x0D,
  0x0E,
  0x0F,
  0x10,
  0x11,
  0x11,
  0x12,
  0x14,
  0x15,
  0x16,
  0x17,
  0x18,
  0x19,
  0x1A,
  0x1B,
  0x1D,
  0x1E,
  0x1F,
  0x20,
  0x21,
  0x22,
  0x23,
  0x24,
  0x25,
  0x26,
  0x27,
  0x28,
  0x2A,
  0x2B,
  0x2C,
  0x2D,
  0x2E,
  0x2F,
  0x30,
  0x31,
  0x32,
  0x33,
  0x35,
  0x36,
  0x37,
  0x38,
  0x39,
  0x3A,
  0x3C,
  0x3D,
  0x3E,
  0x3F,
  0x40,
  0x41,
  0x42,
  0x44,
  0x45,
  0x46,
  0x47,
  0x48,
  0x49,
  0x4A,
  0x4B,
  0x4C,
  0x4D,
  0x4E,
  0x4F,
  0x50,
  0x51,
  0x51,
  0x52,
  0x54,
  0x55,
  0x56,
  0x57,
  0x58,
  0x59,
  0x5A,
  0x5B,
  0x5C,
  0x5D,
  0x5F,
  0x60,
  0x61,
  0x63,
  0x64,
  0x65,
  0x66,
  0x68,
  0x69,
  0x6A,
  0x6B,
  0x6C,
  0x6D,
  0x6E,
  0x6F,
  0x70,
  0x71,
  0x72,
  0x73,
  0x74,
  0x75,
  0x76,
  0x77,
  0x78,
  0x79,
  0x7A,
  0x7B,
  0x7C,
  0x7D,
  0x7E,
  0x7F,
  0x80,
  0x81,
  0x82,
  0x83,
  0x84,
  0x85,
  0x86,
  0x87,
  0x88,
  0x89,
  0x8A,
  0x8B,
  0x8C,
  0x8D,
  0x8E,
  0x8F,
  0x90,
  0x92,
  0x93,
  0x94,
  0x95,
  0x96,
  0x97,
  0x98,
  0x99,
  0x9A,
  0x9B,
  0x9C,
  0x9E,
  0x9F,
  0xA0,
  0xA1,
  0xA2,
  0xA3,
  0xA4,
  0xA5,
  0xA6,
  0xA7,
  0xA8,
  0xA9,
  0xAB,
  0xAC,
  0xAD,
  0xAE,
  0xAF,
  0xB0,
  0xB1,
  0xB2,
  0xB3,
  0xB4,
  0xB6,
  0xB7,
  0xB7,
  0xB8,
  0xB8,
  0xB8,
  0xB9,
  0xBA,
  0xBB,
  0xBC,
  0xBD,
  0xBE,
  0xBF,
  0xC0,
  0xC1,
  0xC2,
  0xC3,
  0xC4,
  0xC5,
  0xC6,
  0xC7,
  0xC8,
  0xC9,
  0xCA,
  0xCB,
  0xCC,
  0xCD,
  0xCE,
  0xCF,
  0xD0,
  0xD1,
  0xD2,
  0xD3,
  0xD4,
  0xD5,
  0xD6,
  0xD7,
  0xD8,
  0xD9,
  0xDA,
  0xDB,
  0xDC,
  0xDD,
  0xDE,
  0xDF,
  0xE0,
  0xE1,
  0xE2,
  0xE3,
  0xE4,
  0xE5,
  0xE6,
  0xE7,
  0xE8,
  0xE9,
  0xEA,
  0xEB,
  0xEC,
  0xED,
  0xEE,
  0xEF,
  0xF0,
  0xF1,
  0xF2,
  0xF3,
  0xF4,
  0xF5,
  0xF6,
  0xF7,
  0xF8,
  0xF9,
  0xFA,
  0xFB,
  0xFC,
  0xFD,
  0xFE,
  0xFF
};

static const unsigned char hp11xxSeriesGammaTable[256] =
{
  0,
  6,
  12,
  17,
  21,
  25,
  29,
  33,
  36,
  39,
  44,
  47,
  50,
  53,
  56,
  59,
  61,
  64,
  67,
  70,
  72,
  75,
  77,
  80,
  82,
  85,
  87,
  89,
  92,
  94,
  96,
  99,
  101,
  102,
  104,
  105,
  106,
  108,
  109,
  110,
  111,
  113,
  114,
  115,
  116,
  117,
  118,
  120,
  121,
  122,
  123,
  124,
  125,
  126,
  127,
  129,
  130,
  131,
  132,
  133,
  134,
  135,
  136,
  137,
  138,
  139,
  140,
  141,
  142,
  143,
  144,
  144,
  145,
  146,
  147,
  148,
  149,
  149,
  150,
  151,
  152,
  153,
  153,
  154,
  155,
  156,
  156,
  157,
  158,
  159,
  159,
  160,
  161,
  162,
  162,
  163,
  164,
  165,
  165,
  166,
  167,
  167,
  168,
  169,
  170,
  170,
  171,
  172,
  172,
  173,
  174,
  174,
  175,
  176,
  176,
  177,
  178,
  178,
  179,
  180,
  180,
  181,
  182,
  182,
  183,
  183,
  184,
  185,
  185,
  186,
  187,
  187,
  188,
  189,
  189,
  190,
  191,
  191,
  192,
  192,
  193,
  194,
  194,
  195,
  196,
  196,
  197,
  197,
  198,
  199,
  199,
  200,
  200,
  201,
  202,
  202,
  203,
  203,
  204,
  205,
  205,
  206,
  206,
  207,
  208,
  208,
  209,
  209,
  210,
  210,
  211,
  212,
  212,
  214,
  214,
  215,
  215,
  216,
  217,
  217,
  218,
  218,
  219,
  219,
  220,
  220,
  221,
  221,
  222,
  222,
  223,
  224,
  224,
  225,
  225,
  226,
  226,
  227,
  227,
  228,
  228,
  229,
  229,
  230,
  230,
  231,
  231,
  232,
  232,
  233,
  233,
  234,
  234,
  235,
  235,
  236,
  236,
  237,
  237,
  238,
  238,
  239,
  239,
  240,
  240,
  241,
  241,
  242,
  242,
  243,
  243,
  244,
  244,
  245,
  245,
  246,
  246,
  247,
  247,
  248,
  248,
  249,
  249,
  249,
  250,
  250,
  251,
  251,
  252,
  252,
  253,
  253,
  254,
  254,
  255,
  255
};

static const char hp11xxSeriesColorMap[] =
{
  0,
  0,
  0,
  1,
  1,
  1,
  3,
  3,
  3,
  7,
  7,
  7,
  11,
  11,
  11,
  19,
  19,
  19,
  29,
  29,
  29,
  40,
  40,
  40,
  57,
  57,
  57,
  84,
  84,
  84,
  110,
  110,
  110,
  132,
  132,
  132,
  155,
  155,
  155,
  195,
  195,
  195,
  225,
  225,
  225,
  255,
  255,
  255,
  255,
  255,
  255,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  1,
  2,
  0,
  1,
  2,
  0,
  1,
  3,
  0,
  2,
  5,
  0,
  2,
  8,
  0,
  3,
  15,
  0,
  5,
  25,
  0,
  8,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  2,
  0,
  0,
  3,
  0,
  1,
  4,
  0,
  1,
  6,
  0,
  1,
  9,
  0,
  1,
  17,
  0,
  1,
  29,
  0,
  2,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  2,
  0,
  0,
  2,
  0,
  0,
  3,
  0,
  0,
  4,
  0,
  0,
  6,
  0,
  0,
  9,
  0,
  0,
  18,
  0,
  0,
  30,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  2,
  0,
  0,
  2,
  0,
  0,
  3,
  0,
  0,
  4,
  0,
  0,
  7,
  0,
  0,
  9,
  0,
  0,
  17,
  0,
  0,
  28,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  2,
  0,
  0,
  2,
  0,
  0,
  3,
  0,
  0,
  4,
  0,
  0,
  6,
  0,
  0,
  8,
  0,
  0,
  14,
  0,
  0,
  22,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  2,
  0,
  0,
  3,
  0,
  0,
  4,
  0,
  0,
  5,
  0,
  0,
  7,
  0,
  0,
  11,
  0,
  0,
  15,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  2,
  0,
  0,
  2,
  0,
  0,
  3,
  0,
  0,
  5,
  0,
  0,
  6,
  0,
  0,
  9,
  0,
  0,
  12,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  2,
  0,
  0,
  3,
  0,
  0,
  4,
  0,
  0,
  5,
  0,
  0,
  8,
  0,
  0,
  10,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  2,
  0,
  0,
  3,
  0,
  0,
  4,
  0,
  0,
  6,
  0,
  0,
  8,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  1,
  0,
  1,
  1,
  0,
  2,
  1,
  0,
  3,
  1,
  0,
  5,
  1,
  0,
  6,
  1,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  1,
  1,
  0,
  1,
  1,
  0,
  3,
  2,
  0,
  4,
  2,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  2,
  0,
  0,
  2,
  0,
  0,
  3,
  0,
  1,
  4,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  2,
  0,
  0,
  2,
  0,
  0,
  3,
  0,
  0,
  4,
  0,
  0,
  5,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  2,
  0,
  0,
  3,
  0,
  0,
  3,
  0,
  0,
  5,
  0,
  0,
  7,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  2,
  0,
  0,
  3,
  0,
  0,
  4,
  0,
  0,
  6,
  0,
  0,
  8,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  2,
  0,
  0,
  2,
  0,
  0,
  3,
  0,
  0,
  4,
  0,
  0,
  6,
  0,
  0,
  8,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  2,
  0,
  0,
  2,
  0,
  0,
  3,
  0,
  0,
  4,
  0,
  0,
  6,
  0,
  0,
  8,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  1,
  1,
  0,
  2,
  1,
  0,
  3,
  1,
  0,
  4,
  1,
  0,
  6,
  1,
  0,
  8,
  1,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  1,
  1,
  0,
  1,
  2,
  0,
  1,
  2,
  0,
  2,
  3,
  0,
  2,
  5,
  0,
  3,
  5,
  0,
  5,
  8,
  0,
  7,
  12,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  2,
  0,
  0,
  2,
  0,
  1,
  3,
  0,
  1,
  5,
  0,
  2,
  8,
  0,
  3,
  10,
  0,
  5,
  17,
  0,
  6,
  27,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  2,
  0,
  0,
  3,
  0,
  0,
  4,
  0,
  1,
  6,
  0,
  1,
  12,
  0,
  2,
  19,
  0,
  3,
  37,
  0,
  3,
  63,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  2,
  0,
  0,
  3,
  0,
  0,
  5,
  0,
  0,
  7,
  0,
  0,
  14,
  0,
  0,
  24,
  0,
  0,
  56,
  0,
  0,
  106,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  2,
  0,
  0,
  3,
  0,
  0,
  5,
  0,
  0,
  7,
  0,
  0,
  14,
  0,
  0,
  26,
  0,
  0,
  64,
  0,
  0,
  126,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  2,
  0,
  0,
  3,
  0,
  0,
  4,
  0,
  0,
  7,
  0,
  0,
  13,
  0,
  0,
  24,
  0,
  0,
  60,
  0,
  0,
  121,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  2,
  0,
  0,
  2,
  0,
  0,
  4,
  0,
  0,
  6,
  0,
  0,
  12,
  0,
  0,
  21,
  0,
  0,
  50,
  0,
  0,
  98,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  0,
  2,
  1,
  0,
  2,
  1,
  0,
  3,
  1,
  0,
  5,
  1,
  0,
  10,
  0,
  0,
  16,
  0,
  0,
  39,
  0,
  0,
  70,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  1,
  0,
  1,
  1,
  0,
  2,
  1,
  0,
  3,
  1,
  0,
  4,
  2,
  0,
  8,
  2,
  0,
  13,
  1,
  0,
  28,
  0,
  0,
  53,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  1,
  0,
  1,
  1,
  0,
  1,
  1,
  0,
  2,
  1,
  0,
  3,
  2,
  0,
  4,
  3,
  0,
  6,
  3,
  0,
  10,
  5,
  0,
  21,
  7,
  0,
  39,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  1,
  1,
  0,
  1,
  1,
  0,
  1,
  2,
  0,
  2,
  2,
  0,
  3,
  3,
  0,
  5,
  5,
  0,
  8,
  8,
  0,
  16,
  14,
  0,
  27,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  0,
  1,
  1,
  0,
  1,
  1,
  0,
  1,
  2,
  0,
  2,
  3,
  0,
  2,
  4,
  0,
  4,
  6,
  0,
  5,
  12,
  0,
  10,
  20,
  0,
  17,
  1,
  1,
  1,
  2,
  2,
  2,
  2,
  1,
  2,
  3,
  1,
  2,
  3,
  1,
  2,
  3,
  1,
  3,
  4,
  0,
  3,
  6,
  0,
  3,
  9,
  0,
  4,
  12,
  0,
  6,
  22,
  0,
  9,
  35,
  0,
  14,
  1,
  1,
  1,
  2,
  2,
  2,
  2,
  1,
  2,
  3,
  1,
  2,
  3,
  1,
  2,
  4,
  1,
  2,
  5,
  0,
  2,
  6,
  0,
  2,
  10,
  0,
  2,
  14,
  0,
  3,
  25,
  0,
  3,
  41,
  0,
  4,
  1,
  1,
  1,
  2,
  2,
  2,
  3,
  1,
  2,
  3,
  1,
  2,
  3,
  1,
  2,
  4,
  1,
  2,
  5,
  0,
  2,
  7,
  0,
  1,
  10,
  0,
  1,
  14,
  0,
  0,
  26,
  0,
  0,
  42,
  0,
  0,
  1,
  1,
  1,
  2,
  2,
  1,
  3,
  1,
  1,
  3,
  1,
  1,
  3,
  1,
  1,
  4,
  1,
  1,
  5,
  0,
  0,
  7,
  0,
  0,
  10,
  0,
  0,
  14,
  0,
  0,
  24,
  0,
  0,
  38,
  0,
  0,
  1,
  1,
  1,
  2,
  2,
  1,
  3,
  2,
  1,
  3,
  1,
  1,
  3,
  1,
  1,
  4,
  1,
  0,
  5,
  1,
  0,
  6,
  0,
  0,
  9,
  0,
  0,
  12,
  0,
  0,
  20,
  0,
  0,
  30,
  0,
  0,
  1,
  1,
  1,
  2,
  2,
  1,
  2,
  2,
  1,
  3,
  2,
  1,
  3,
  1,
  0,
  4,
  1,
  0,
  5,
  1,
  0,
  6,
  1,
  0,
  8,
  0,
  0,
  10,
  0,
  0,
  15,
  0,
  0,
  20,
  0,
  0,
  1,
  1,
  1,
  2,
  2,
  1,
  2,
  2,
  1,
  2,
  2,
  0,
  3,
  2,
  0,
  3,
  1,
  0,
  4,
  1,
  0,
  5,
  1,
  0,
  7,
  1,
  0,
  8,
  1,
  0,
  11,
  0,
  0,
  15,
  0,
  0,
  1,
  1,
  1,
  2,
  2,
  1,
  2,
  2,
  1,
  2,
  2,
  0,
  3,
  2,
  0,
  3,
  2,
  0,
  4,
  2,
  0,
  4,
  1,
  0,
  6,
  1,
  0,
  7,
  1,
  0,
  9,
  1,
  0,
  12,
  1,
  0,
  1,
  1,
  1,
  2,
  2,
  1,
  2,
  2,
  1,
  2,
  2,
  0,
  2,
  2,
  0,
  2,
  2,
  0,
  3,
  2,
  0,
  4,
  2,
  0,
  5,
  2,
  0,
  6,
  2,
  0,
  8,
  2,
  0,
  10,
  2,
  0,
  1,
  1,
  1,
  2,
  2,
  1,
  2,
  2,
  1,
  2,
  2,
  0,
  2,
  2,
  0,
  2,
  2,
  0,
  2,
  2,
  0,
  3,
  2,
  0,
  4,
  2,
  0,
  5,
  2,
  0,
  6,
  3,
  0,
  8,
  3,
  0,
  1,
  1,
  1,
  2,
  2,
  1,
  2,
  2,
  1,
  2,
  2,
  1,
  2,
  2,
  0,
  2,
  2,
  0,
  2,
  3,
  0,
  2,
  3,
  0,
  2,
  3,
  0,
  3,
  3,
  0,
  4,
  4,
  0,
  6,
  4,
  0,
  1,
  1,
  1,
  2,
  2,
  1,
  2,
  2,
  1,
  2,
  2,
  1,
  1,
  2,
  0,
  1,
  2,
  0,
  1,
  3,
  0,
  1,
  3,
  0,
  1,
  4,
  0,
  2,
  4,
  0,
  2,
  5,
  0,
  3,
  5,
  0,
  1,
  1,
  1,
  2,
  2,
  1,
  1,
  2,
  1,
  1,
  2,
  1,
  1,
  2,
  0,
  1,
  3,
  0,
  1,
  3,
  0,
  0,
  3,
  0,
  0,
  4,
  0,
  0,
  5,
  0,
  0,
  6,
  0,
  0,
  7,
  0,
  1,
  1,
  1,
  1,
  2,
  1,
  1,
  2,
  1,
  1,
  2,
  1,
  1,
  2,
  1,
  1,
  3,
  0,
  0,
  3,
  0,
  0,
  4,
  0,
  0,
  4,
  0,
  0,
  5,
  0,
  0,
  7,
  0,
  0,
  9,
  0,
  1,
  1,
  1,
  1,
  2,
  1,
  1,
  2,
  1,
  1,
  2,
  1,
  1,
  2,
  1,
  0,
  3,
  0,
  0,
  3,
  0,
  0,
  4,
  0,
  0,
  5,
  0,
  0,
  6,
  0,
  0,
  7,
  0,
  0,
  9,
  0,
  1,
  1,
  1,
  1,
  2,
  2,
  1,
  2,
  1,
  1,
  2,
  1,
  0,
  3,
  1,
  0,
  3,
  1,
  0,
  3,
  1,
  0,
  4,
  1,
  0,
  5,
  0,
  0,
  6,
  0,
  0,
  8,
  0,
  0,
  10,
  0,
  1,
  1,
  1,
  1,
  2,
  2,
  1,
  2,
  2,
  1,
  2,
  2,
  0,
  3,
  2,
  0,
  3,
  2,
  0,
  3,
  2,
  0,
  4,
  1,
  0,
  5,
  1,
  0,
  6,
  1,
  0,
  8,
  0,
  0,
  10,
  0,
  1,
  1,
  1,
  1,
  2,
  2,
  1,
  2,
  2,
  1,
  2,
  2,
  0,
  3,
  2,
  0,
  3,
  2,
  0,
  3,
  2,
  0,
  4,
  2,
  0,
  5,
  2,
  0,
  6,
  2,
  0,
  8,
  2,
  0,
  10,
  3,
  1,
  1,
  1,
  1,
  2,
  2,
  1,
  2,
  2,
  1,
  2,
  3,
  0,
  2,
  3,
  0,
  2,
  4,
  0,
  3,
  5,
  0,
  3,
  6,
  0,
  4,
  7,
  0,
  5,
  8,
  0,
  7,
  13,
  0,
  9,
  19,
  1,
  1,
  1,
  1,
  2,
  2,
  1,
  2,
  3,
  1,
  2,
  3,
  0,
  2,
  4,
  0,
  2,
  4,
  0,
  3,
  6,
  0,
  3,
  8,
  0,
  4,
  11,
  0,
  5,
  14,
  0,
  6,
  24,
  0,
  8,
  38,
  1,
  1,
  1,
  1,
  2,
  2,
  1,
  2,
  3,
  1,
  2,
  3,
  1,
  2,
  4,
  0,
  2,
  5,
  0,
  2,
  7,
  0,
  2,
  10,
  0,
  3,
  18,
  0,
  3,
  25,
  0,
  4,
  48,
  0,
  5,
  79,
  1,
  1,
  1,
  2,
  2,
  2,
  1,
  2,
  3,
  1,
  2,
  3,
  1,
  2,
  4,
  1,
  2,
  5,
  0,
  2,
  8,
  0,
  2,
  12,
  0,
  2,
  21,
  0,
  2,
  34,
  0,
  2,
  72,
  0,
  1,
  130,
  1,
  1,
  1,
  2,
  2,
  2,
  2,
  2,
  3,
  2,
  2,
  3,
  1,
  2,
  4,
  1,
  1,
  5,
  0,
  1,
  8,
  0,
  1,
  12,
  0,
  1,
  22,
  0,
  1,
  36,
  0,
  0,
  82,
  0,
  0,
  154,
  1,
  1,
  1,
  2,
  2,
  2,
  2,
  2,
  3,
  2,
  2,
  3,
  2,
  1,
  4,
  2,
  1,
  5,
  1,
  1,
  8,
  0,
  1,
  11,
  0,
  0,
  20,
  0,
  0,
  34,
  0,
  0,
  78,
  0,
  0,
  149,
  1,
  1,
  1,
  2,
  2,
  2,
  2,
  2,
  3,
  2,
  1,
  3,
  2,
  1,
  4,
  2,
  1,
  5,
  2,
  1,
  7,
  1,
  1,
  10,
  0,
  0,
  18,
  0,
  0,
  29,
  0,
  0,
  67,
  0,
  0,
  136,
  1,
  1,
  1,
  2,
  2,
  2,
  2,
  1,
  3,
  2,
  1,
  3,
  2,
  1,
  4,
  2,
  1,
  4,
  2,
  1,
  6,
  2,
  0,
  9,
  2,
  0,
  15,
  1,
  0,
  24,
  0,
  0,
  50,
  0,
  0,
  90,
  1,
  1,
  1,
  2,
  2,
  2,
  2,
  1,
  2,
  2,
  1,
  3,
  2,
  1,
  3,
  2,
  1,
  4,
  3,
  1,
  6,
  3,
  0,
  8,
  4,
  0,
  13,
  4,
  0,
  19,
  4,
  0,
  39,
  3,
  0,
  69,
  1,
  1,
  1,
  2,
  2,
  2,
  2,
  1,
  2,
  2,
  1,
  3,
  3,
  1,
  3,
  3,
  1,
  4,
  3,
  0,
  5,
  4,
  0,
  7,
  5,
  0,
  11,
  6,
  0,
  16,
  9,
  0,
  30,
  13,
  0,
  52,
  1,
  1,
  1,
  2,
  2,
  2,
  2,
  1,
  2,
  2,
  1,
  2,
  3,
  1,
  3,
  3,
  1,
  3,
  4,
  0,
  5,
  4,
  0,
  6,
  6,
  0,
  9,
  8,
  0,
  12,
  14,
  0,
  23,
  21,
  0,
  37,
  1,
  1,
  1,
  2,
  2,
  2,
  2,
  1,
  2,
  3,
  1,
  2,
  3,
  1,
  3,
  3,
  1,
  3,
  4,
  0,
  4,
  5,
  0,
  5,
  7,
  0,
  7,
  10,
  0,
  9,
  18,
  0,
  16,
  29,
  0,
  24,
  3,
  3,
  3,
  4,
  3,
  4,
  5,
  3,
  4,
  9,
  5,
  7,
  4,
  1,
  3,
  4,
  1,
  3,
  8,
  1,
  6,
  10,
  0,
  6,
  14,
  0,
  8,
  19,
  0,
  9,
  32,
  0,
  14,
  50,
  0,
  20,
  3,
  3,
  3,
  4,
  3,
  4,
  5,
  3,
  4,
  5,
  3,
  4,
  5,
  2,
  3,
  5,
  1,
  3,
  9,
  1,
  5,
  11,
  0,
  5,
  16,
  0,
  5,
  21,
  0,
  5,
  36,
  0,
  6,
  56,
  0,
  8,
  3,
  3,
  3,
  5,
  3,
  4,
  5,
  3,
  4,
  9,
  6,
  6,
  7,
  3,
  5,
  9,
  3,
  5,
  9,
  1,
  3,
  11,
  0,
  3,
  16,
  0,
  3,
  22,
  0,
  2,
  37,
  0,
  2,
  57,
  0,
  2,
  3,
  3,
  3,
  5,
  3,
  3,
  5,
  3,
  3,
  5,
  3,
  3,
  6,
  3,
  3,
  7,
  2,
  3,
  9,
  2,
  2,
  11,
  1,
  1,
  15,
  0,
  0,
  21,
  0,
  0,
  35,
  0,
  0,
  53,
  0,
  0,
  3,
  3,
  3,
  5,
  4,
  3,
  5,
  3,
  3,
  5,
  3,
  3,
  6,
  3,
  2,
  7,
  3,
  2,
  8,
  2,
  1,
  10,
  1,
  0,
  13,
  0,
  0,
  18,
  0,
  0,
  28,
  0,
  0,
  41,
  0,
  0,
  3,
  3,
  3,
  4,
  4,
  3,
  5,
  4,
  3,
  5,
  3,
  2,
  6,
  3,
  2,
  6,
  3,
  2,
  8,
  3,
  0,
  9,
  2,
  0,
  11,
  1,
  0,
  14,
  0,
  0,
  20,
  0,
  0,
  28,
  0,
  0,
  3,
  3,
  3,
  4,
  4,
  3,
  4,
  4,
  3,
  5,
  4,
  2,
  5,
  4,
  2,
  6,
  3,
  1,
  7,
  3,
  0,
  8,
  3,
  0,
  10,
  2,
  0,
  12,
  2,
  0,
  16,
  1,
  0,
  20,
  0,
  0,
  3,
  3,
  3,
  4,
  4,
  3,
  4,
  4,
  2,
  4,
  4,
  2,
  5,
  4,
  2,
  5,
  4,
  1,
  6,
  3,
  0,
  7,
  3,
  0,
  8,
  3,
  0,
  10,
  3,
  0,
  13,
  2,
  0,
  16,
  2,
  0,
  3,
  3,
  3,
  4,
  4,
  3,
  4,
  4,
  3,
  4,
  4,
  2,
  4,
  4,
  2,
  4,
  4,
  1,
  5,
  4,
  0,
  6,
  4,
  0,
  7,
  4,
  0,
  8,
  4,
  0,
  10,
  4,
  0,
  13,
  4,
  0,
  3,
  3,
  3,
  4,
  4,
  3,
  4,
  4,
  3,
  4,
  4,
  2,
  4,
  4,
  2,
  4,
  4,
  1,
  4,
  4,
  0,
  5,
  4,
  0,
  6,
  5,
  0,
  7,
  5,
  0,
  8,
  5,
  0,
  10,
  5,
  0,
  3,
  3,
  3,
  4,
  4,
  3,
  4,
  4,
  3,
  4,
  4,
  2,
  3,
  4,
  2,
  3,
  4,
  1,
  3,
  5,
  0,
  4,
  5,
  0,
  4,
  5,
  0,
  5,
  5,
  0,
  7,
  6,
  0,
  8,
  6,
  0,
  3,
  3,
  3,
  4,
  4,
  3,
  3,
  4,
  3,
  3,
  4,
  2,
  3,
  4,
  2,
  3,
  5,
  2,
  3,
  5,
  0,
  3,
  5,
  0,
  3,
  5,
  0,
  4,
  6,
  0,
  4,
  7,
  0,
  5,
  7,
  0,
  3,
  3,
  3,
  3,
  4,
  3,
  3,
  4,
  3,
  3,
  4,
  3,
  3,
  5,
  2,
  3,
  5,
  2,
  2,
  5,
  1,
  2,
  5,
  0,
  2,
  6,
  0,
  2,
  7,
  0,
  1,
  8,
  0,
  0,
  9,
  0,
  3,
  3,
  3,
  3,
  4,
  3,
  3,
  4,
  3,
  3,
  4,
  3,
  3,
  5,
  2,
  2,
  5,
  2,
  2,
  5,
  1,
  2,
  6,
  0,
  1,
  6,
  0,
  0,
  7,
  0,
  0,
  9,
  0,
  0,
  11,
  0,
  3,
  3,
  3,
  3,
  4,
  3,
  3,
  4,
  3,
  3,
  4,
  3,
  3,
  5,
  3,
  2,
  5,
  2,
  2,
  5,
  2,
  1,
  6,
  1,
  0,
  7,
  0,
  0,
  8,
  0,
  0,
  10,
  0,
  0,
  11,
  0,
  3,
  3,
  3,
  3,
  4,
  4,
  3,
  4,
  3,
  3,
  4,
  3,
  2,
  5,
  3,
  2,
  5,
  3,
  1,
  5,
  3,
  0,
  6,
  2,
  0,
  7,
  2,
  0,
  8,
  1,
  0,
  10,
  0,
  0,
  12,
  0,
  3,
  3,
  3,
  3,
  4,
  4,
  3,
  4,
  4,
  3,
  4,
  4,
  2,
  5,
  4,
  1,
  5,
  4,
  1,
  5,
  4,
  0,
  6,
  3,
  0,
  7,
  3,
  0,
  8,
  3,
  0,
  10,
  2,
  0,
  12,
  2,
  3,
  3,
  3,
  3,
  4,
  4,
  3,
  4,
  4,
  2,
  4,
  4,
  2,
  5,
  4,
  1,
  5,
  4,
  1,
  5,
  5,
  0,
  6,
  5,
  0,
  7,
  5,
  0,
  8,
  5,
  0,
  10,
  5,
  0,
  12,
  5,
  3,
  3,
  3,
  3,
  4,
  4,
  3,
  4,
  5,
  2,
  4,
  5,
  2,
  4,
  6,
  1,
  5,
  7,
  0,
  5,
  8,
  0,
  5,
  9,
  0,
  6,
  11,
  0,
  7,
  13,
  0,
  9,
  19,
  0,
  11,
  27,
  3,
  3,
  3,
  3,
  4,
  5,
  3,
  4,
  5,
  3,
  4,
  6,
  2,
  4,
  7,
  1,
  4,
  8,
  0,
  5,
  10,
  0,
  5,
  12,
  0,
  6,
  17,
  0,
  7,
  21,
  0,
  8,
  33,
  0,
  9,
  50,
  3,
  3,
  3,
  3,
  4,
  5,
  3,
  4,
  5,
  3,
  4,
  6,
  2,
  4,
  7,
  1,
  4,
  9,
  0,
  4,
  12,
  0,
  4,
  16,
  0,
  5,
  25,
  0,
  5,
  34,
  0,
  6,
  60,
  0,
  6,
  97,
  3,
  3,
  3,
  4,
  4,
  5,
  3,
  4,
  5,
  3,
  4,
  6,
  3,
  4,
  8,
  2,
  4,
  9,
  1,
  4,
  13,
  0,
  4,
  18,
  0,
  4,
  30,
  0,
  4,
  45,
  0,
  3,
  90,
  0,
  2,
  157,
  3,
  3,
  3,
  4,
  4,
  5,
  4,
  4,
  5,
  3,
  4,
  6,
  3,
  3,
  7,
  3,
  3,
  9,
  2,
  3,
  13,
  0,
  3,
  18,
  0,
  3,
  31,
  0,
  3,
  49,
  0,
  1,
  103,
  0,
  0,
  186,
  3,
  3,
  3,
  4,
  4,
  5,
  4,
  4,
  5,
  4,
  3,
  6,
  4,
  3,
  7,
  3,
  3,
  9,
  3,
  3,
  12,
  1,
  2,
  17,
  0,
  2,
  29,
  0,
  1,
  47,
  0,
  0,
  99,
  0,
  0,
  180,
  3,
  3,
  3,
  4,
  4,
  5,
  4,
  3,
  5,
  4,
  3,
  6,
  4,
  3,
  7,
  4,
  3,
  8,
  4,
  2,
  11,
  3,
  2,
  16,
  1,
  1,
  26,
  0,
  0,
  41,
  0,
  0,
  83,
  0,
  0,
  140,
  3,
  3,
  3,
  4,
  4,
  5,
  4,
  3,
  5,
  4,
  3,
  5,
  4,
  3,
  7,
  4,
  3,
  8,
  4,
  2,
  11,
  5,
  1,
  14,
  4,
  0,
  22,
  4,
  0,
  33,
  0,
  0,
  65,
  0,
  0,
  112,
  3,
  3,
  3,
  4,
  4,
  4,
  4,
  3,
  5,
  4,
  3,
  5,
  5,
  3,
  6,
  5,
  3,
  7,
  5,
  2,
  10,
  6,
  1,
  12,
  7,
  0,
  19,
  8,
  0,
  28,
  9,
  0,
  52,
  8,
  0,
  88,
  3,
  3,
  3,
  4,
  3,
  4,
  4,
  3,
  5,
  5,
  3,
  5,
  5,
  3,
  6,
  5,
  2,
  7,
  6,
  2,
  9,
  7,
  1,
  11,
  9,
  0,
  16,
  11,
  0,
  23,
  15,
  0,
  41,
  20,
  0,
  68,
  3,
  3,
  3,
  4,
  3,
  4,
  5,
  3,
  5,
  5,
  3,
  5,
  5,
  3,
  6,
  5,
  1,
  6,
  5,
  0,
  6,
  8,
  1,
  10,
  10,
  0,
  14,
  14,
  0,
  19,
  21,
  0,
  32,
  32,
  0,
  49,
  3,
  3,
  3,
  4,
  3,
  4,
  5,
  3,
  4,
  5,
  3,
  5,
  7,
  3,
  7,
  4,
  1,
  4,
  7,
  1,
  7,
  9,
  0,
  8,
  12,
  0,
  11,
  16,
  0,
  14,
  27,
  0,
  23,
  41,
  0,
  33,
  7,
  7,
  7,
  8,
  7,
  8,
  9,
  6,
  8,
  9,
  4,
  7,
  8,
  3,
  6,
  13,
  3,
  9,
  14,
  1,
  9,
  16,
  2,
  10,
  21,
  0,
  12,
  28,
  0,
  15,
  45,
  0,
  21,
  67,
  0,
  27,
  7,
  7,
  7,
  8,
  7,
  7,
  9,
  6,
  7,
  9,
  5,
  7,
  12,
  5,
  8,
  6,
  1,
  3,
  14,
  1,
  7,
  21,
  1,
  9,
  23,
  0,
  8,
  31,
  0,
  9,
  50,
  0,
  10,
  75,
  0,
  13,
  7,
  7,
  7,
  8,
  7,
  7,
  9,
  6,
  7,
  10,
  6,
  6,
  11,
  5,
  6,
  13,
  4,
  5,
  13,
  2,
  5,
  19,
  1,
  6,
  24,
  0,
  5,
  32,
  0,
  4,
  51,
  0,
  4,
  76,
  0,
  5,
  7,
  7,
  7,
  8,
  7,
  7,
  9,
  7,
  6,
  10,
  6,
  6,
  12,
  6,
  5,
  12,
  4,
  4,
  18,
  5,
  5,
  23,
  4,
  5,
  23,
  0,
  4,
  30,
  0,
  3,
  48,
  0,
  1,
  70,
  0,
  0,
  7,
  7,
  7,
  9,
  7,
  7,
  10,
  7,
  6,
  10,
  7,
  6,
  11,
  6,
  5,
  14,
  7,
  5,
  20,
  9,
  6,
  15,
  4,
  3,
  20,
  1,
  1,
  25,
  0,
  0,
  39,
  0,
  0,
  55,
  0,
  0,
  7,
  7,
  7,
  9,
  8,
  7,
  10,
  8,
  6,
  11,
  8,
  6,
  12,
  7,
  5,
  16,
  9,
  6,
  12,
  5,
  4,
  13,
  5,
  2,
  17,
  3,
  0,
  20,
  2,
  0,
  28,
  0,
  0,
  37,
  0,
  0,
  7,
  7,
  7,
  9,
  8,
  7,
  10,
  9,
  7,
  10,
  8,
  5,
  13,
  9,
  5,
  10,
  6,
  3,
  11,
  6,
  3,
  12,
  5,
  2,
  14,
  5,
  0,
  17,
  4,
  0,
  22,
  2,
  0,
  28,
  0,
  0,
  7,
  7,
  7,
  9,
  9,
  7,
  11,
  10,
  7,
  11,
  10,
  6,
  13,
  11,
  6,
  9,
  7,
  3,
  10,
  6,
  3,
  10,
  6,
  2,
  12,
  6,
  0,
  14,
  5,
  0,
  17,
  5,
  0,
  21,
  4,
  0,
  7,
  7,
  7,
  9,
  9,
  8,
  11,
  11,
  8,
  11,
  11,
  6,
  8,
  7,
  3,
  8,
  7,
  2,
  8,
  7,
  3,
  9,
  7,
  1,
  10,
  7,
  0,
  12,
  7,
  0,
  14,
  7,
  0,
  16,
  6,
  0,
  7,
  7,
  7,
  10,
  10,
  8,
  12,
  12,
  8,
  12,
  13,
  7,
  7,
  7,
  3,
  7,
  8,
  3,
  7,
  8,
  3,
  8,
  8,
  1,
  8,
  8,
  0,
  9,
  8,
  0,
  11,
  8,
  0,
  12,
  8,
  0,
  7,
  7,
  7,
  10,
  10,
  8,
  12,
  13,
  9,
  7,
  7,
  5,
  7,
  8,
  4,
  7,
  8,
  3,
  6,
  8,
  3,
  6,
  8,
  2,
  6,
  9,
  0,
  7,
  9,
  0,
  8,
  10,
  0,
  8,
  10,
  0,
  7,
  7,
  7,
  7,
  7,
  6,
  6,
  7,
  5,
  6,
  8,
  5,
  6,
  8,
  4,
  6,
  8,
  3,
  5,
  9,
  3,
  5,
  9,
  2,
  4,
  10,
  0,
  4,
  10,
  0,
  4,
  11,
  0,
  8,
  11,
  0,
  7,
  7,
  7,
  7,
  8,
  6,
  6,
  8,
  5,
  6,
  8,
  5,
  6,
  8,
  4,
  5,
  8,
  3,
  4,
  9,
  2,
  3,
  10,
  3,
  2,
  11,
  0,
  2,
  11,
  0,
  4,
  11,
  0,
  3,
  12,
  0,
  7,
  7,
  7,
  7,
  8,
  7,
  6,
  8,
  6,
  6,
  8,
  5,
  5,
  8,
  5,
  5,
  9,
  4,
  4,
  9,
  3,
  3,
  10,
  2,
  1,
  11,
  2,
  3,
  10,
  0,
  0,
  12,
  0,
  0,
  14,
  0,
  7,
  7,
  7,
  7,
  8,
  7,
  6,
  8,
  6,
  6,
  8,
  6,
  5,
  8,
  5,
  4,
  9,
  4,
  3,
  9,
  3,
  2,
  10,
  3,
  0,
  11,
  3,
  1,
  11,
  2,
  0,
  13,
  0,
  0,
  15,
  0,
  7,
  7,
  7,
  7,
  8,
  7,
  6,
  8,
  6,
  5,
  8,
  6,
  4,
  8,
  6,
  4,
  9,
  6,
  2,
  10,
  5,
  1,
  10,
  5,
  2,
  10,
  4,
  0,
  11,
  3,
  0,
  13,
  2,
  0,
  15,
  2,
  7,
  7,
  7,
  6,
  8,
  7,
  5,
  8,
  7,
  5,
  8,
  7,
  4,
  8,
  7,
  3,
  9,
  7,
  2,
  10,
  6,
  0,
  10,
  6,
  1,
  10,
  6,
  0,
  11,
  5,
  0,
  13,
  4,
  0,
  15,
  3,
  7,
  7,
  7,
  6,
  8,
  7,
  5,
  8,
  7,
  5,
  8,
  7,
  4,
  8,
  7,
  3,
  9,
  8,
  1,
  10,
  8,
  0,
  10,
  8,
  1,
  10,
  8,
  0,
  11,
  8,
  0,
  13,
  9,
  0,
  15,
  9,
  7,
  7,
  7,
  6,
  7,
  8,
  5,
  7,
  8,
  5,
  8,
  9,
  4,
  8,
  10,
  3,
  8,
  11,
  0,
  9,
  13,
  0,
  10,
  14,
  0,
  11,
  16,
  0,
  10,
  19,
  0,
  12,
  27,
  0,
  14,
  37,
  7,
  7,
  7,
  6,
  7,
  8,
  5,
  7,
  9,
  5,
  7,
  10,
  4,
  8,
  11,
  3,
  8,
  12,
  0,
  9,
  15,
  0,
  9,
  18,
  0,
  10,
  23,
  0,
  10,
  28,
  0,
  11,
  44,
  0,
  12,
  65,
  7,
  7,
  7,
  7,
  7,
  8,
  6,
  7,
  9,
  5,
  7,
  10,
  4,
  7,
  12,
  3,
  7,
  14,
  1,
  8,
  18,
  0,
  8,
  23,
  0,
  9,
  34,
  0,
  10,
  45,
  0,
  9,
  76,
  0,
  9,
  118,
  7,
  7,
  7,
  7,
  7,
  8,
  6,
  7,
  9,
  6,
  7,
  10,
  5,
  7,
  12,
  4,
  7,
  14,
  2,
  7,
  20,
  0,
  7,
  25,
  0,
  7,
  40,
  0,
  8,
  58,
  0,
  7,
  111,
  0,
  4,
  188,
  7,
  7,
  7,
  7,
  7,
  8,
  7,
  7,
  9,
  6,
  7,
  10,
  6,
  6,
  12,
  5,
  6,
  14,
  4,
  6,
  19,
  1,
  6,
  26,
  0,
  6,
  42,
  0,
  6,
  64,
  0,
  4,
  127,
  0,
  2,
  221,
  7,
  7,
  7,
  10,
  10,
  12,
  12,
  12,
  16,
  7,
  6,
  10,
  7,
  6,
  12,
  6,
  6,
  14,
  5,
  5,
  19,
  4,
  5,
  25,
  0,
  4,
  41,
  0,
  3,
  62,
  0,
  1,
  125,
  0,
  0,
  224,
  7,
  7,
  7,
  10,
  9,
  11,
  12,
  11,
  15,
  7,
  6,
  10,
  7,
  6,
  11,
  7,
  6,
  13,
  7,
  5,
  18,
  6,
  4,
  23,
  4,
  3,
  36,
  1,
  1,
  54,
  0,
  0,
  101,
  0,
  0,
  170,
  7,
  7,
  7,
  9,
  9,
  11,
  11,
  10,
  14,
  11,
  9,
  14,
  11,
  8,
  16,
  10,
  6,
  18,
  8,
  4,
  16,
  8,
  4,
  21,
  8,
  1,
  31,
  8,
  0,
  45,
  5,
  0,
  83,
  0,
  0,
  139,
  7,
  7,
  7,
  9,
  8,
  10,
  11,
  9,
  12,
  10,
  7,
  13,
  10,
  6,
  14,
  9,
  4,
  15,
  9,
  2,
  18,
  10,
  3,
  19,
  11,
  1,
  27,
  13,
  0,
  38,
  15,
  0,
  68,
  15,
  0,
  111,
  7,
  7,
  7,
  9,
  8,
  9,
  10,
  8,
  11,
  10,
  6,
  11,
  9,
  4,
  11,
  4,
  1,
  7,
  5,
  0,
  9,
  6,
  0,
  13,
  14,
  0,
  24,
  17,
  0,
  32,
  23,
  0,
  55,
  31,
  0,
  87,
  7,
  7,
  7,
  9,
  7,
  9,
  10,
  7,
  10,
  9,
  5,
  9,
  8,
  3,
  9,
  5,
  0,
  6,
  5,
  0,
  7,
  13,
  2,
  15,
  16,
  0,
  21,
  21,
  0,
  27,
  31,
  0,
  43,
  44,
  0,
  64,
  7,
  7,
  7,
  8,
  7,
  8,
  9,
  6,
  9,
  9,
  5,
  8,
  4,
  1,
  4,
  5,
  0,
  5,
  6,
  0,
  6,
  10,
  0,
  9,
  19,
  0,
  17,
  24,
  0,
  21,
  38,
  0,
  32,
  56,
  0,
  44,
  11,
  11,
  11,
  15,
  11,
  13,
  18,
  11,
  14,
  21,
  11,
  16,
  21,
  9,
  16,
  21,
  5,
  15,
  17,
  1,
  11,
  24,
  0,
  14,
  31,
  0,
  19,
  39,
  0,
  23,
  60,
  0,
  30,
  87,
  0,
  37,
  11,
  11,
  11,
  15,
  12,
  13,
  19,
  12,
  14,
  22,
  12,
  16,
  23,
  10,
  15,
  23,
  6,
  13,
  21,
  1,
  9,
  29,
  0,
  12,
  33,
  0,
  13,
  43,
  0,
  14,
  67,
  0,
  17,
  96,
  0,
  21,
  11,
  11,
  11,
  15,
  12,
  13,
  19,
  13,
  14,
  22,
  12,
  14,
  22,
  10,
  12,
  23,
  7,
  10,
  22,
  3,
  7,
  27,
  1,
  7,
  34,
  0,
  8,
  45,
  0,
  8,
  69,
  0,
  7,
  99,
  0,
  7,
  11,
  11,
  11,
  15,
  12,
  12,
  19,
  13,
  13,
  21,
  12,
  12,
  20,
  10,
  10,
  22,
  8,
  7,
  24,
  6,
  6,
  25,
  2,
  4,
  34,
  1,
  5,
  43,
  0,
  3,
  64,
  0,
  6,
  91,
  0,
  5,
  11,
  11,
  11,
  15,
  12,
  11,
  19,
  13,
  11,
  19,
  12,
  10,
  21,
  12,
  9,
  21,
  10,
  7,
  23,
  9,
  6,
  31,
  10,
  5,
  28,
  4,
  6,
  35,
  0,
  4,
  52,
  0,
  1,
  73,
  0,
  0,
  11,
  11,
  11,
  15,
  13,
  11,
  18,
  14,
  10,
  18,
  13,
  8,
  21,
  13,
  8,
  22,
  12,
  7,
  27,
  13,
  6,
  21,
  8,
  2,
  24,
  6,
  5,
  29,
  4,
  2,
  39,
  0,
  0,
  50,
  0,
  0,
  11,
  11,
  11,
  14,
  13,
  10,
  16,
  14,
  9,
  17,
  13,
  8,
  18,
  13,
  7,
  22,
  14,
  7,
  18,
  10,
  3,
  18,
  9,
  6,
  21,
  8,
  4,
  24,
  7,
  1,
  30,
  5,
  0,
  37,
  2,
  0,
  11,
  11,
  11,
  13,
  13,
  10,
  15,
  14,
  9,
  17,
  14,
  8,
  18,
  14,
  7,
  21,
  15,
  6,
  16,
  10,
  3,
  16,
  10,
  6,
  18,
  10,
  3,
  20,
  9,
  1,
  24,
  8,
  0,
  29,
  7,
  0,
  11,
  11,
  11,
  13,
  13,
  10,
  15,
  15,
  9,
  16,
  15,
  8,
  17,
  15,
  6,
  20,
  16,
  6,
  15,
  11,
  3,
  14,
  11,
  6,
  15,
  11,
  3,
  17,
  11,
  0,
  19,
  10,
  0,
  22,
  10,
  0,
  11,
  11,
  11,
  13,
  13,
  10,
  14,
  15,
  9,
  14,
  16,
  7,
  15,
  16,
  6,
  18,
  17,
  6,
  13,
  12,
  3,
  12,
  12,
  6,
  13,
  12,
  3,
  14,
  12,
  0,
  15,
  13,
  0,
  16,
  13,
  0,
  11,
  11,
  11,
  12,
  14,
  10,
  13,
  16,
  9,
  13,
  16,
  7,
  14,
  17,
  7,
  16,
  18,
  6,
  11,
  13,
  3,
  10,
  13,
  6,
  10,
  14,
  3,
  10,
  14,
  0,
  11,
  15,
  0,
  11,
  16,
  0,
  11,
  11,
  11,
  12,
  14,
  10,
  13,
  16,
  9,
  13,
  16,
  8,
  13,
  18,
  8,
  14,
  20,
  7,
  10,
  14,
  4,
  9,
  14,
  2,
  7,
  15,
  4,
  7,
  16,
  1,
  6,
  17,
  0,
  5,
  19,
  0,
  11,
  11,
  11,
  12,
  14,
  11,
  13,
  16,
  10,
  13,
  17,
  9,
  13,
  19,
  9,
  13,
  21,
  8,
  8,
  14,
  4,
  7,
  15,
  3,
  4,
  16,
  5,
  3,
  17,
  2,
  1,
  19,
  0,
  8,
  17,
  0,
  11,
  11,
  11,
  12,
  14,
  11,
  13,
  17,
  11,
  13,
  18,
  11,
  13,
  20,
  11,
  8,
  14,
  7,
  7,
  15,
  5,
  6,
  16,
  4,
  3,
  17,
  2,
  0,
  19,
  4,
  5,
  17,
  1,
  3,
  18,
  0,
  11,
  11,
  11,
  12,
  14,
  12,
  13,
  17,
  13,
  13,
  18,
  13,
  9,
  13,
  9,
  8,
  14,
  8,
  6,
  15,
  6,
  4,
  16,
  5,
  2,
  18,
  3,
  0,
  19,
  2,
  3,
  17,
  4,
  0,
  19,
  2,
  11,
  11,
  11,
  12,
  14,
  13,
  13,
  17,
  14,
  13,
  19,
  16,
  8,
  13,
  10,
  7,
  14,
  10,
  5,
  15,
  9,
  3,
  16,
  8,
  0,
  18,
  7,
  0,
  20,
  6,
  2,
  18,
  4,
  0,
  20,
  2,
  11,
  11,
  11,
  12,
  14,
  14,
  13,
  17,
  16,
  12,
  19,
  17,
  7,
  13,
  11,
  6,
  14,
  11,
  4,
  15,
  11,
  2,
  16,
  10,
  0,
  18,
  10,
  0,
  20,
  9,
  1,
  18,
  8,
  0,
  20,
  7,
  11,
  11,
  11,
  12,
  14,
  14,
  13,
  17,
  17,
  13,
  19,
  18,
  7,
  13,
  12,
  6,
  14,
  13,
  3,
  15,
  13,
  1,
  16,
  13,
  0,
  18,
  13,
  0,
  19,
  13,
  0,
  17,
  14,
  0,
  19,
  15,
  11,
  11,
  11,
  12,
  14,
  15,
  13,
  16,
  18,
  13,
  17,
  20,
  7,
  13,
  16,
  5,
  13,
  17,
  2,
  14,
  19,
  0,
  15,
  21,
  0,
  17,
  24,
  0,
  19,
  27,
  0,
  16,
  39,
  0,
  18,
  53,
  11,
  11,
  11,
  12,
  13,
  15,
  13,
  15,
  18,
  13,
  17,
  21,
  7,
  12,
  17,
  6,
  13,
  19,
  2,
  14,
  23,
  0,
  15,
  26,
  0,
  16,
  32,
  0,
  18,
  39,
  0,
  15,
  60,
  0,
  16,
  87,
  11,
  11,
  11,
  12,
  13,
  15,
  13,
  15,
  18,
  13,
  16,
  21,
  8,
  12,
  18,
  6,
  12,
  21,
  3,
  12,
  27,
  0,
  13,
  32,
  0,
  15,
  45,
  0,
  16,
  58,
  0,
  17,
  97,
  0,
  13,
  148,
  11,
  11,
  11,
  12,
  13,
  15,
  13,
  14,
  19,
  13,
  15,
  21,
  13,
  16,
  25,
  8,
  11,
  21,
  5,
  11,
  28,
  2,
  12,
  36,
  0,
  12,
  54,
  0,
  13,
  76,
  0,
  13,
  138,
  0,
  12,
  226,
  11,
  11,
  11,
  12,
  12,
  15,
  13,
  13,
  18,
  13,
  14,
  21,
  13,
  14,
  24,
  14,
  15,
  30,
  7,
  10,
  28,
  4,
  10,
  36,
  0,
  10,
  56,
  0,
  10,
  82,
  0,
  8,
  155,
  0,
  6,
  255,
  11,
  11,
  11,
  12,
  12,
  15,
  13,
  12,
  18,
  13,
  12,
  20,
  13,
  13,
  24,
  13,
  12,
  28,
  9,
  9,
  27,
  7,
  9,
  35,
  2,
  8,
  54,
  0,
  6,
  79,
  0,
  4,
  152,
  0,
  2,
  255,
  11,
  11,
  11,
  12,
  11,
  15,
  13,
  11,
  18,
  13,
  10,
  19,
  13,
  10,
  22,
  11,
  8,
  24,
  13,
  9,
  35,
  11,
  8,
  32,
  8,
  6,
  49,
  5,
  3,
  70,
  0,
  0,
  125,
  0,
  0,
  202,
  11,
  11,
  11,
  13,
  11,
  14,
  14,
  11,
  17,
  12,
  9,
  17,
  10,
  7,
  18,
  10,
  5,
  22,
  11,
  4,
  28,
  11,
  3,
  37,
  13,
  4,
  44,
  13,
  1,
  61,
  12,
  0,
  104,
  6,
  0,
  168,
  11,
  11,
  11,
  13,
  11,
  14,
  14,
  11,
  16,
  13,
  9,
  17,
  10,
  5,
  16,
  8,
  2,
  15,
  9,
  1,
  20,
  13,
  0,
  31,
  18,
  3,
  38,
  20,
  0,
  51,
  24,
  0,
  87,
  26,
  0,
  136,
  11,
  11,
  11,
  13,
  11,
  14,
  15,
  11,
  16,
  17,
  10,
  20,
  8,
  3,
  11,
  8,
  1,
  14,
  6,
  0,
  11,
  17,
  0,
  28,
  22,
  2,
  33,
  25,
  0,
  44,
  34,
  0,
  71,
  43,
  0,
  109,
  11,
  11,
  11,
  13,
  11,
  13,
  15,
  11,
  15,
  15,
  8,
  15,
  13,
  5,
  15,
  13,
  2,
  15,
  6,
  0,
  8,
  17,
  0,
  22,
  25,
  1,
  29,
  30,
  0,
  37,
  44,
  0,
  57,
  60,
  0,
  82,
  11,
  11,
  11,
  14,
  11,
  13,
  17,
  11,
  15,
  17,
  9,
  15,
  20,
  8,
  18,
  15,
  3,
  14,
  7,
  0,
  7,
  13,
  0,
  13,
  27,
  1,
  25,
  35,
  0,
  30,
  52,
  0,
  43,
  75,
  0,
  58,
  19,
  19,
  19,
  23,
  19,
  22,
  27,
  19,
  24,
  28,
  18,
  24,
  30,
  16,
  24,
  32,
  13,
  24,
  33,
  6,
  22,
  30,
  0,
  18,
  42,
  3,
  28,
  52,
  0,
  33,
  77,
  0,
  42,
  109,
  0,
  52,
  19,
  19,
  19,
  24,
  20,
  21,
  28,
  20,
  23,
  28,
  17,
  22,
  29,
  16,
  21,
  34,
  14,
  21,
  33,
  6,
  16,
  36,
  1,
  14,
  51,
  0,
  21,
  57,
  0,
  22,
  85,
  0,
  27,
  121,
  0,
  30,
  19,
  19,
  19,
  23,
  20,
  20,
  27,
  20,
  21,
  29,
  19,
  21,
  30,
  17,
  19,
  34,
  15,
  18,
  35,
  8,
  13,
  35,
  2,
  9,
  50,
  1,
  12,
  60,
  0,
  13,
  90,
  0,
  12,
  126,
  0,
  11,
  19,
  19,
  19,
  23,
  20,
  19,
  26,
  20,
  19,
  27,
  18,
  17,
  29,
  17,
  16,
  33,
  15,
  14,
  32,
  9,
  8,
  36,
  4,
  5,
  45,
  3,
  5,
  58,
  0,
  6,
  85,
  0,
  4,
  115,
  0,
  12,
  19,
  19,
  19,
  23,
  20,
  19,
  26,
  20,
  18,
  26,
  19,
  15,
  28,
  18,
  14,
  31,
  16,
  10,
  33,
  12,
  6,
  38,
  11,
  5,
  46,
  10,
  4,
  47,
  3,
  11,
  68,
  0,
  7,
  92,
  0,
  5,
  19,
  19,
  19,
  22,
  20,
  18,
  25,
  21,
  17,
  25,
  19,
  14,
  29,
  20,
  12,
  30,
  18,
  9,
  32,
  16,
  6,
  36,
  16,
  5,
  32,
  11,
  10,
  38,
  9,
  8,
  50,
  3,
  4,
  63,
  0,
  0,
  19,
  19,
  19,
  22,
  20,
  18,
  25,
  21,
  17,
  25,
  20,
  14,
  28,
  20,
  12,
  29,
  19,
  8,
  31,
  19,
  6,
  27,
  15,
  4,
  28,
  14,
  10,
  31,
  12,
  7,
  39,
  9,
  2,
  47,
  6,
  0,
  19,
  19,
  19,
  22,
  21,
  18,
  25,
  22,
  16,
  25,
  22,
  14,
  26,
  21,
  10,
  28,
  21,
  7,
  31,
  22,
  6,
  24,
  17,
  3,
  24,
  16,
  9,
  26,
  15,
  7,
  31,
  14,
  1,
  36,
  12,
  0,
  19,
  19,
  19,
  22,
  21,
  18,
  24,
  22,
  16,
  24,
  22,
  13,
  23,
  21,
  8,
  25,
  22,
  7,
  29,
  24,
  6,
  22,
  18,
  3,
  21,
  17,
  9,
  22,
  17,
  6,
  25,
  17,
  1,
  28,
  17,
  0,
  19,
  19,
  19,
  21,
  21,
  17,
  22,
  23,
  15,
  21,
  22,
  11,
  19,
  21,
  7,
  21,
  23,
  6,
  25,
  25,
  6,
  20,
  19,
  3,
  17,
  19,
  9,
  18,
  19,
  6,
  19,
  20,
  1,
  20,
  20,
  0,
  19,
  19,
  19,
  19,
  21,
  17,
  19,
  22,
  14,
  18,
  22,
  10,
  16,
  22,
  7,
  18,
  24,
  6,
  21,
  26,
  6,
  17,
  20,
  3,
  14,
  21,
  9,
  14,
  21,
  6,
  13,
  23,
  1,
  13,
  24,
  0,
  19,
  19,
  19,
  18,
  21,
  16,
  16,
  22,
  13,
  14,
  22,
  10,
  15,
  23,
  8,
  15,
  24,
  6,
  16,
  27,
  6,
  14,
  22,
  4,
  10,
  23,
  10,
  9,
  24,
  7,
  7,
  26,
  2,
  5,
  28,
  0,
  19,
  19,
  19,
  17,
  21,
  16,
  14,
  22,
  12,
  13,
  22,
  10,
  12,
  23,
  9,
  12,
  24,
  7,
  13,
  28,
  7,
  11,
  23,
  6,
  9,
  25,
  2,
  4,
  26,
  8,
  1,
  29,
  4,
  0,
  31,
  0,
  19,
  19,
  19,
  16,
  21,
  16,
  13,
  22,
  12,
  12,
  22,
  11,
  11,
  23,
  10,
  11,
  25,
  9,
  10,
  29,
  9,
  9,
  23,
  8,
  6,
  26,
  4,
  3,
  28,
  2,
  0,
  31,
  7,
  8,
  24,
  4,
  19,
  19,
  19,
  16,
  21,
  17,
  12,
  22,
  14,
  11,
  22,
  12,
  11,
  24,
  12,
  10,
  26,
  11,
  10,
  22,
  11,
  8,
  24,
  10,
  4,
  26,
  7,
  1,
  28,
  4,
  0,
  32,
  1,
  6,
  25,
  8,
  19,
  19,
  19,
  16,
  21,
  18,
  12,
  22,
  16,
  11,
  22,
  16,
  10,
  25,
  17,
  9,
  28,
  19,
  8,
  23,
  15,
  5,
  24,
  14,
  1,
  27,
  12,
  0,
  29,
  11,
  0,
  32,
  8,
  5,
  26,
  6,
  19,
  19,
  19,
  16,
  20,
  19,
  12,
  21,
  18,
  11,
  22,
  18,
  10,
  25,
  20,
  10,
  21,
  17,
  7,
  23,
  17,
  4,
  24,
  16,
  0,
  27,
  16,
  0,
  29,
  15,
  0,
  32,
  14,
  3,
  26,
  13,
  19,
  19,
  19,
  16,
  20,
  20,
  12,
  21,
  20,
  11,
  22,
  20,
  11,
  25,
  23,
  10,
  21,
  19,
  6,
  23,
  20,
  4,
  24,
  19,
  0,
  27,
  20,
  0,
  29,
  20,
  0,
  31,
  22,
  0,
  25,
  24,
  19,
  19,
  19,
  16,
  20,
  21,
  12,
  21,
  22,
  11,
  21,
  24,
  11,
  23,
  27,
  9,
  20,
  24,
  5,
  22,
  26,
  2,
  23,
  28,
  0,
  26,
  32,
  0,
  28,
  37,
  0,
  30,
  51,
  0,
  23,
  68,
  19,
  19,
  19,
  16,
  20,
  21,
  13,
  20,
  23,
  12,
  20,
  25,
  11,
  22,
  29,
  10,
  24,
  33,
  5,
  21,
  31,
  1,
  22,
  34,
  0,
  25,
  41,
  0,
  27,
  50,
  0,
  29,
  74,
  0,
  22,
  105,
  19,
  19,
  19,
  16,
  19,
  22,
  13,
  19,
  24,
  12,
  19,
  26,
  12,
  21,
  31,
  11,
  22,
  36,
  6,
  19,
  35,
  2,
  21,
  42,
  0,
  23,
  55,
  0,
  24,
  70,
  0,
  26,
  112,
  0,
  27,
  167,
  19,
  19,
  19,
  17,
  19,
  22,
  14,
  19,
  25,
  13,
  19,
  28,
  12,
  18,
  31,
  12,
  20,
  37,
  8,
  18,
  38,
  4,
  19,
  47,
  0,
  20,
  67,
  0,
  21,
  92,
  0,
  21,
  160,
  0,
  21,
  253,
  19,
  19,
  19,
  18,
  19,
  23,
  16,
  19,
  26,
  14,
  17,
  29,
  12,
  15,
  30,
  12,
  17,
  37,
  11,
  17,
  39,
  7,
  17,
  48,
  0,
  17,
  72,
  0,
  17,
  102,
  0,
  15,
  185,
  0,
  13,
  255,
  19,
  19,
  19,
  19,
  19,
  23,
  18,
  19,
  27,
  15,
  16,
  29,
  11,
  12,
  28,
  11,
  11,
  33,
  12,
  14,
  46,
  11,
  15,
  48,
  4,
  14,
  72,
  0,
  13,
  102,
  0,
  9,
  186,
  0,
  0,
  255,
  19,
  19,
  19,
  20,
  19,
  23,
  20,
  19,
  27,
  16,
  15,
  28,
  13,
  11,
  28,
  14,
  11,
  35,
  12,
  8,
  39,
  14,
  11,
  58,
  12,
  11,
  66,
  9,
  7,
  91,
  0,
  0,
  158,
  0,
  0,
  254,
  19,
  19,
  19,
  21,
  19,
  23,
  22,
  19,
  27,
  19,
  15,
  27,
  18,
  14,
  31,
  18,
  11,
  35,
  17,
  8,
  40,
  19,
  8,
  53,
  20,
  8,
  58,
  19,
  4,
  80,
  14,
  0,
  137,
  5,
  0,
  215,
  19,
  19,
  19,
  21,
  19,
  23,
  23,
  18,
  26,
  21,
  16,
  27,
  23,
  15,
  32,
  22,
  12,
  34,
  25,
  11,
  44,
  25,
  8,
  51,
  25,
  7,
  53,
  27,
  2,
  70,
  29,
  0,
  116,
  29,
  0,
  179,
  19,
  19,
  19,
  22,
  19,
  22,
  24,
  18,
  25,
  24,
  17,
  27,
  25,
  15,
  30,
  26,
  14,
  35,
  26,
  9,
  38,
  30,
  7,
  48,
  29,
  6,
  47,
  34,
  1,
  61,
  43,
  0,
  97,
  52,
  0,
  145,
  19,
  19,
  19,
  22,
  19,
  22,
  25,
  18,
  24,
  26,
  17,
  26,
  27,
  16,
  28,
  29,
  13,
  31,
  29,
  9,
  34,
  32,
  5,
  39,
  34,
  4,
  41,
  40,
  0,
  51,
  55,
  0,
  78,
  73,
  0,
  112,
  19,
  19,
  19,
  23,
  19,
  22,
  26,
  19,
  24,
  27,
  18,
  24,
  31,
  18,
  28,
  29,
  12,
  27,
  28,
  6,
  25,
  33,
  2,
  29,
  38,
  4,
  35,
  47,
  0,
  42,
  67,
  0,
  59,
  93,
  0,
  80,
  29,
  29,
  29,
  31,
  28,
  29,
  32,
  26,
  29,
  34,
  25,
  30,
  36,
  24,
  31,
  39,
  20,
  32,
  41,
  14,
  31,
  50,
  10,
  35,
  53,
  4,
  36,
  68,
  0,
  44,
  98,
  0,
  57,
  135,
  0,
  70,
  29,
  29,
  29,
  31,
  28,
  29,
  33,
  26,
  28,
  34,
  25,
  28,
  36,
  23,
  27,
  41,
  22,
  28,
  45,
  18,
  27,
  51,
  10,
  25,
  55,
  2,
  23,
  74,
  0,
  32,
  108,
  0,
  37,
  150,
  0,
  41,
  29,
  29,
  29,
  31,
  28,
  28,
  33,
  27,
  27,
  34,
  25,
  26,
  37,
  25,
  26,
  40,
  22,
  24,
  45,
  19,
  23,
  50,
  12,
  18,
  56,
  4,
  14,
  78,
  0,
  18,
  114,
  0,
  18,
  157,
  0,
  17,
  29,
  29,
  29,
  31,
  28,
  28,
  33,
  27,
  26,
  34,
  26,
  24,
  36,
  25,
  23,
  38,
  23,
  20,
  43,
  20,
  17,
  49,
  14,
  12,
  54,
  7,
  8,
  68,
  3,
  8,
  109,
  0,
  6,
  148,
  0,
  4,
  29,
  29,
  29,
  31,
  28,
  27,
  33,
  27,
  25,
  33,
  26,
  23,
  35,
  26,
  20,
  38,
  24,
  16,
  43,
  20,
  11,
  44,
  13,
  5,
  54,
  11,
  4,
  66,
  9,
  3,
  85,
  0,
  15,
  113,
  0,
  12,
  29,
  29,
  29,
  31,
  28,
  27,
  32,
  27,
  24,
  33,
  27,
  21,
  34,
  26,
  18,
  37,
  24,
  12,
  38,
  20,
  6,
  43,
  20,
  4,
  52,
  21,
  3,
  48,
  15,
  16,
  62,
  9,
  11,
  76,
  3,
  7,
  29,
  29,
  29,
  31,
  29,
  27,
  32,
  28,
  24,
  32,
  28,
  20,
  34,
  28,
  16,
  35,
  26,
  10,
  38,
  25,
  6,
  41,
  25,
  4,
  40,
  22,
  2,
  40,
  20,
  15,
  48,
  17,
  10,
  56,
  13,
  5,
  29,
  29,
  29,
  30,
  29,
  26,
  31,
  29,
  23,
  31,
  28,
  20,
  34,
  29,
  15,
  34,
  28,
  9,
  35,
  28,
  6,
  39,
  29,
  4,
  36,
  25,
  2,
  33,
  23,
  14,
  38,
  22,
  9,
  43,
  20,
  3,
  29,
  29,
  29,
  30,
  30,
  26,
  31,
  30,
  23,
  31,
  30,
  19,
  31,
  30,
  13,
  31,
  30,
  8,
  34,
  31,
  6,
  37,
  33,
  4,
  32,
  27,
  1,
  28,
  26,
  14,
  31,
  26,
  9,
  33,
  26,
  3,
  29,
  29,
  29,
  30,
  30,
  26,
  30,
  30,
  23,
  30,
  31,
  19,
  28,
  31,
  13,
  27,
  31,
  8,
  29,
  32,
  6,
  33,
  35,
  4,
  28,
  29,
  1,
  23,
  28,
  14,
  24,
  29,
  8,
  24,
  30,
  3,
  29,
  29,
  29,
  29,
  30,
  26,
  28,
  31,
  22,
  27,
  31,
  19,
  26,
  32,
  14,
  24,
  31,
  8,
  24,
  33,
  6,
  27,
  36,
  4,
  24,
  31,
  2,
  18,
  31,
  14,
  16,
  33,
  9,
  14,
  35,
  3,
  29,
  29,
  29,
  28,
  30,
  26,
  27,
  31,
  22,
  26,
  32,
  20,
  24,
  33,
  15,
  19,
  31,
  8,
  19,
  33,
  5,
  21,
  37,
  4,
  19,
  33,
  3,
  12,
  34,
  15,
  8,
  37,
  10,
  5,
  40,
  4,
  29,
  29,
  29,
  28,
  30,
  26,
  26,
  31,
  23,
  24,
  32,
  20,
  22,
  34,
  17,
  15,
  31,
  9,
  13,
  33,
  6,
  13,
  37,
  4,
  14,
  35,
  4,
  11,
  37,
  1,
  1,
  40,
  12,
  0,
  44,
  7,
  29,
  29,
  29,
  27,
  30,
  26,
  25,
  31,
  23,
  23,
  32,
  21,
  18,
  32,
  17,
  13,
  32,
  12,
  10,
  33,
  8,
  8,
  39,
  6,
  10,
  37,
  8,
  6,
  39,
  4,
  0,
  43,
  15,
  0,
  46,
  12,
  29,
  29,
  29,
  27,
  30,
  27,
  24,
  31,
  24,
  22,
  33,
  22,
  15,
  31,
  17,
  11,
  32,
  13,
  8,
  35,
  11,
  12,
  34,
  15,
  7,
  37,
  12,
  2,
  40,
  9,
  0,
  45,
  4,
  0,
  48,
  0,
  29,
  29,
  29,
  26,
  30,
  28,
  23,
  31,
  26,
  18,
  32,
  25,
  12,
  30,
  21,
  7,
  31,
  19,
  13,
  32,
  22,
  9,
  34,
  21,
  3,
  38,
  19,
  0,
  41,
  17,
  0,
  45,
  14,
  0,
  48,
  11,
  29,
  29,
  29,
  26,
  30,
  29,
  22,
  31,
  28,
  18,
  32,
  27,
  12,
  31,
  24,
  7,
  32,
  23,
  12,
  32,
  24,
  8,
  34,
  24,
  2,
  38,
  23,
  0,
  40,
  22,
  0,
  45,
  21,
  11,
  33,
  21,
  29,
  29,
  29,
  26,
  30,
  30,
  22,
  31,
  30,
  18,
  31,
  29,
  12,
  30,
  27,
  7,
  32,
  27,
  11,
  32,
  27,
  7,
  34,
  27,
  0,
  37,
  28,
  0,
  40,
  29,
  0,
  44,
  31,
  0,
  47,
  34,
  29,
  29,
  29,
  26,
  30,
  31,
  23,
  31,
  32,
  20,
  31,
  34,
  12,
  28,
  33,
  8,
  30,
  35,
  10,
  31,
  35,
  5,
  33,
  36,
  0,
  36,
  42,
  0,
  39,
  48,
  0,
  43,
  63,
  0,
  45,
  82,
  29,
  29,
  29,
  27,
  30,
  32,
  24,
  30,
  34,
  21,
  30,
  36,
  14,
  28,
  37,
  9,
  28,
  39,
  10,
  30,
  39,
  5,
  32,
  42,
  0,
  35,
  51,
  0,
  38,
  61,
  0,
  41,
  87,
  0,
  43,
  119,
  29,
  29,
  29,
  27,
  29,
  32,
  25,
  29,
  34,
  22,
  30,
  38,
  16,
  27,
  39,
  11,
  26,
  43,
  9,
  31,
  53,
  5,
  30,
  52,
  0,
  33,
  66,
  0,
  36,
  82,
  0,
  39,
  125,
  0,
  40,
  181,
  29,
  29,
  29,
  28,
  29,
  32,
  26,
  29,
  35,
  24,
  29,
  38,
  18,
  26,
  40,
  14,
  24,
  46,
  10,
  25,
  53,
  7,
  28,
  60,
  0,
  30,
  82,
  0,
  31,
  108,
  0,
  33,
  179,
  0,
  33,
  255,
  29,
  29,
  29,
  28,
  29,
  32,
  27,
  29,
  35,
  24,
  27,
  38,
  22,
  26,
  42,
  18,
  25,
  49,
  12,
  21,
  54,
  11,
  25,
  63,
  0,
  26,
  90,
  0,
  26,
  124,
  0,
  26,
  215,
  0,
  23,
  255,
  29,
  29,
  29,
  29,
  29,
  32,
  28,
  28,
  35,
  27,
  28,
  39,
  24,
  26,
  43,
  22,
  25,
  50,
  18,
  22,
  59,
  14,
  22,
  73,
  8,
  21,
  91,
  0,
  19,
  126,
  0,
  13,
  219,
  0,
  7,
  255,
  29,
  29,
  29,
  29,
  29,
  32,
  29,
  28,
  35,
  28,
  27,
  38,
  27,
  26,
  43,
  26,
  25,
  51,
  22,
  20,
  58,
  20,
  18,
  68,
  18,
  17,
  85,
  13,
  14,
  117,
  0,
  6,
  200,
  0,
  0,
  255,
  29,
  29,
  29,
  30,
  28,
  32,
  30,
  27,
  35,
  29,
  26,
  38,
  28,
  25,
  42,
  28,
  22,
  47,
  28,
  20,
  58,
  26,
  19,
  57,
  25,
  15,
  79,
  23,
  10,
  106,
  15,
  1,
  177,
  1,
  0,
  255,
  29,
  29,
  29,
  30,
  28,
  32,
  30,
  27,
  34,
  30,
  25,
  37,
  31,
  24,
  41,
  31,
  22,
  46,
  32,
  20,
  55,
  33,
  16,
  64,
  32,
  13,
  72,
  34,
  8,
  94,
  34,
  0,
  153,
  31,
  0,
  231,
  29,
  29,
  29,
  30,
  28,
  31,
  31,
  26,
  33,
  32,
  26,
  36,
  33,
  24,
  39,
  34,
  22,
  43,
  36,
  19,
  50,
  38,
  15,
  59,
  38,
  11,
  64,
  43,
  5,
  82,
  52,
  0,
  129,
  60,
  0,
  189,
  29,
  29,
  29,
  31,
  28,
  31,
  32,
  26,
  32,
  33,
  26,
  34,
  35,
  24,
  37,
  36,
  22,
  40,
  39,
  19,
  46,
  41,
  13,
  51,
  44,
  9,
  56,
  52,
  3,
  70,
  68,
  0,
  105,
  87,
  0,
  148,
  29,
  29,
  29,
  31,
  27,
  30,
  32,
  25,
  30,
  31,
  23,
  29,
  35,
  24,
  34,
  39,
  23,
  37,
  42,
  18,
  39,
  47,
  11,
  43,
  51,
  8,
  47,
  61,
  1,
  57,
  84,
  0,
  80,
  112,
  0,
  108,
  40,
  40,
  40,
  41,
  38,
  40,
  42,
  35,
  40,
  44,
  34,
  40,
  45,
  32,
  41,
  49,
  29,
  42,
  53,
  25,
  43,
  62,
  19,
  47,
  64,
  9,
  45,
  87,
  4,
  59,
  122,
  0,
  75,
  164,
  0,
  93,
  40,
  40,
  40,
  41,
  38,
  39,
  42,
  36,
  38,
  44,
  35,
  38,
  46,
  33,
  37,
  49,
  30,
  37,
  54,
  26,
  36,
  63,
  20,
  36,
  71,
  9,
  35,
  95,
  3,
  43,
  135,
  0,
  50,
  183,
  0,
  56,
  40,
  40,
  40,
  41,
  38,
  39,
  42,
  36,
  37,
  44,
  35,
  36,
  47,
  34,
  35,
  49,
  31,
  33,
  53,
  27,
  30,
  62,
  23,
  28,
  72,
  13,
  25,
  81,
  3,
  21,
  142,
  0,
  26,
  193,
  0,
  25,
  40,
  40,
  40,
  41,
  39,
  38,
  42,
  37,
  35,
  44,
  36,
  34,
  45,
  34,
  31,
  47,
  31,
  28,
  52,
  29,
  24,
  59,
  24,
  20,
  71,
  18,
  16,
  79,
  8,
  12,
  137,
  0,
  10,
  183,
  0,
  7,
  40,
  40,
  40,
  41,
  39,
  37,
  42,
  37,
  34,
  43,
  36,
  31,
  44,
  34,
  28,
  48,
  34,
  25,
  52,
  31,
  21,
  58,
  27,
  15,
  62,
  18,
  7,
  74,
  11,
  4,
  106,
  1,
  25,
  139,
  0,
  23,
  40,
  40,
  40,
  41,
  39,
  36,
  41,
  37,
  32,
  43,
  37,
  30,
  43,
  35,
  26,
  46,
  34,
  21,
  50,
  31,
  14,
  52,
  25,
  7,
  59,
  24,
  3,
  70,
  24,
  2,
  77,
  16,
  21,
  94,
  9,
  17,
  40,
  40,
  40,
  40,
  39,
  36,
  40,
  37,
  31,
  41,
  37,
  29,
  42,
  36,
  25,
  46,
  36,
  19,
  46,
  31,
  8,
  50,
  30,
  4,
  54,
  32,
  4,
  51,
  29,
  25,
  60,
  25,
  20,
  70,
  22,
  14,
  40,
  40,
  40,
  40,
  39,
  36,
  40,
  38,
  31,
  41,
  38,
  28,
  42,
  38,
  24,
  44,
  37,
  16,
  43,
  34,
  7,
  47,
  34,
  4,
  48,
  35,
  4,
  43,
  33,
  24,
  48,
  32,
  19,
  53,
  30,
  13,
  40,
  40,
  40,
  40,
  40,
  36,
  39,
  39,
  31,
  40,
  39,
  27,
  40,
  39,
  23,
  42,
  40,
  15,
  42,
  39,
  7,
  45,
  41,
  4,
  43,
  37,
  4,
  37,
  36,
  24,
  39,
  36,
  18,
  41,
  37,
  13,
  40,
  40,
  40,
  40,
  40,
  36,
  39,
  40,
  31,
  39,
  41,
  28,
  39,
  41,
  23,
  39,
  41,
  16,
  36,
  39,
  7,
  38,
  42,
  4,
  38,
  40,
  4,
  31,
  40,
  24,
  30,
  41,
  18,
  30,
  42,
  13,
  40,
  40,
  40,
  40,
  41,
  36,
  39,
  41,
  32,
  38,
  41,
  28,
  37,
  42,
  24,
  36,
  44,
  17,
  31,
  41,
  8,
  31,
  43,
  4,
  33,
  42,
  4,
  32,
  44,
  0,
  21,
  46,
  19,
  18,
  48,
  13,
  40,
  40,
  40,
  39,
  41,
  37,
  38,
  42,
  33,
  36,
  42,
  30,
  35,
  43,
  25,
  33,
  45,
  18,
  26,
  42,
  9,
  23,
  43,
  4,
  27,
  45,
  5,
  25,
  47,
  1,
  11,
  50,
  19,
  6,
  54,
  14,
  40,
  40,
  40,
  38,
  41,
  37,
  36,
  42,
  33,
  34,
  42,
  30,
  32,
  43,
  26,
  28,
  45,
  20,
  21,
  44,
  12,
  15,
  44,
  6,
  21,
  48,
  9,
  17,
  51,
  3,
  2,
  55,
  21,
  0,
  59,
  17,
  40,
  40,
  40,
  38,
  41,
  37,
  35,
  42,
  33,
  32,
  42,
  31,
  30,
  44,
  28,
  26,
  46,
  23,
  20,
  46,
  16,
  13,
  49,
  10,
  15,
  50,
  13,
  10,
  53,
  8,
  1,
  59,
  1,
  0,
  63,
  22,
  40,
  40,
  40,
  37,
  41,
  38,
  33,
  42,
  35,
  32,
  43,
  33,
  29,
  44,
  31,
  25,
  46,
  27,
  19,
  49,
  22,
  11,
  51,
  16,
  12,
  50,
  18,
  6,
  54,
  14,
  0,
  60,
  7,
  0,
  65,
  2,
  40,
  40,
  40,
  36,
  41,
  39,
  32,
  42,
  37,
  30,
  43,
  36,
  26,
  44,
  35,
  20,
  47,
  34,
  9,
  46,
  27,
  15,
  46,
  30,
  7,
  51,
  28,
  0,
  55,
  26,
  0,
  61,
  22,
  0,
  65,
  18,
  40,
  40,
  40,
  36,
  41,
  40,
  32,
  41,
  39,
  29,
  42,
  39,
  24,
  43,
  39,
  18,
  45,
  38,
  18,
  44,
  35,
  14,
  46,
  34,
  5,
  51,
  33,
  0,
  55,
  33,
  0,
  61,
  32,
  0,
  65,
  31,
  40,
  40,
  40,
  36,
  41,
  41,
  32,
  41,
  41,
  29,
  42,
  41,
  24,
  42,
  41,
  16,
  44,
  40,
  17,
  44,
  38,
  12,
  46,
  38,
  3,
  51,
  39,
  0,
  54,
  41,
  0,
  60,
  45,
  0,
  64,
  49,
  40,
  40,
  40,
  36,
  40,
  42,
  32,
  40,
  43,
  29,
  41,
  45,
  24,
  41,
  47,
  18,
  43,
  52,
  8,
  43,
  52,
  10,
  45,
  49,
  0,
  49,
  55,
  0,
  53,
  63,
  0,
  58,
  83,
  0,
  62,
  106,
  40,
  40,
  40,
  37,
  40,
  42,
  33,
  40,
  44,
  30,
  40,
  47,
  26,
  40,
  50,
  20,
  41,
  55,
  8,
  40,
  56,
  10,
  44,
  56,
  0,
  48,
  65,
  0,
  52,
  78,
  0,
  56,
  108,
  0,
  59,
  146,
  40,
  40,
  40,
  37,
  40,
  43,
  34,
  39,
  45,
  30,
  37,
  46,
  27,
  38,
  51,
  22,
  39,
  59,
  12,
  38,
  63,
  10,
  42,
  66,
  0,
  46,
  81,
  0,
  49,
  99,
  0,
  53,
  147,
  0,
  56,
  209,
  40,
  40,
  40,
  37,
  39,
  43,
  34,
  38,
  45,
  31,
  37,
  48,
  29,
  38,
  53,
  25,
  38,
  61,
  17,
  38,
  71,
  8,
  37,
  79,
  0,
  42,
  101,
  0,
  44,
  129,
  0,
  46,
  207,
  0,
  47,
  255,
  40,
  40,
  40,
  37,
  39,
  43,
  34,
  37,
  45,
  33,
  37,
  49,
  31,
  37,
  55,
  27,
  36,
  62,
  20,
  34,
  72,
  13,
  34,
  86,
  2,
  37,
  112,
  0,
  39,
  146,
  0,
  41,
  239,
  0,
  28,
  255,
  40,
  40,
  40,
  38,
  38,
  43,
  35,
  36,
  45,
  34,
  36,
  49,
  32,
  36,
  55,
  30,
  36,
  64,
  24,
  32,
  74,
  23,
  32,
  81,
  15,
  30,
  114,
  4,
  28,
  154,
  0,
  22,
  255,
  0,
  16,
  255,
  40,
  40,
  40,
  38,
  38,
  43,
  35,
  36,
  45,
  35,
  36,
  49,
  34,
  34,
  55,
  33,
  32,
  63,
  30,
  29,
  72,
  30,
  29,
  78,
  25,
  26,
  109,
  17,
  23,
  146,
  0,
  14,
  244,
  0,
  5,
  255,
  40,
  40,
  40,
  38,
  38,
  43,
  36,
  35,
  45,
  36,
  35,
  49,
  36,
  33,
  54,
  36,
  31,
  61,
  35,
  28,
  71,
  35,
  28,
  75,
  33,
  23,
  102,
  30,
  18,
  135,
  19,
  7,
  220,
  0,
  0,
  255,
  40,
  40,
  40,
  39,
  38,
  42,
  38,
  35,
  44,
  38,
  34,
  47,
  38,
  32,
  51,
  40,
  32,
  60,
  40,
  28,
  68,
  40,
  26,
  71,
  41,
  20,
  94,
  42,
  15,
  122,
  41,
  1,
  193,
  36,
  0,
  255,
  40,
  40,
  40,
  40,
  38,
  42,
  39,
  35,
  43,
  40,
  34,
  46,
  41,
  32,
  50,
  43,
  30,
  55,
  45,
  27,
  63,
  45,
  24,
  65,
  50,
  18,
  85,
  54,
  11,
  108,
  63,
  0,
  165,
  70,
  0,
  238,
  40,
  40,
  40,
  40,
  38,
  42,
  40,
  35,
  43,
  42,
  35,
  45,
  42,
  32,
  47,
  44,
  29,
  51,
  47,
  26,
  57,
  50,
  20,
  64,
  57,
  16,
  75,
  66,
  8,
  92,
  83,
  0,
  136,
  103,
  0,
  190,
  40,
  40,
  40,
  41,
  38,
  41,
  41,
  36,
  41,
  42,
  34,
  43,
  44,
  32,
  44,
  47,
  29,
  46,
  51,
  24,
  49,
  56,
  19,
  54,
  65,
  14,
  63,
  77,
  6,
  76,
  104,
  0,
  105,
  135,
  0,
  141,
  57,
  57,
  57,
  57,
  53,
  55,
  56,
  48,
  53,
  58,
  46,
  54,
  61,
  44,
  54,
  65,
  41,
  56,
  72,
  37,
  58,
  79,
  29,
  59,
  93,
  21,
  66,
  110,
  10,
  75,
  151,
  0,
  94,
  199,
  0,
  115,
  57,
  57,
  57,
  57,
  53,
  54,
  56,
  48,
  50,
  59,
  47,
  51,
  61,
  45,
  50,
  65,
  41,
  49,
  72,
  37,
  48,
  79,
  29,
  47,
  91,
  18,
  47,
  119,
  9,
  55,
  166,
  0,
  62,
  222,
  0,
  70,
  57,
  57,
  57,
  58,
  54,
  53,
  58,
  50,
  49,
  61,
  50,
  50,
  63,
  47,
  47,
  67,
  44,
  45,
  72,
  40,
  42,
  81,
  34,
  39,
  91,
  23,
  34,
  100,
  9,
  29,
  174,
  0,
  34,
  232,
  0,
  33,
  57,
  57,
  57,
  58,
  54,
  53,
  59,
  51,
  48,
  61,
  50,
  47,
  64,
  49,
  44,
  61,
  42,
  36,
  68,
  39,
  33,
  77,
  35,
  28,
  86,
  27,
  22,
  102,
  16,
  18,
  168,
  0,
  14,
  222,
  0,
  11,
  57,
  57,
  57,
  58,
  54,
  52,
  58,
  51,
  46,
  60,
  51,
  44,
  62,
  50,
  40,
  66,
  48,
  36,
  71,
  45,
  30,
  72,
  36,
  21,
  79,
  28,
  13,
  90,
  18,
  6,
  144,
  7,
  3,
  176,
  0,
  37,
  57,
  57,
  57,
  57,
  54,
  51,
  56,
  50,
  44,
  57,
  49,
  40,
  58,
  48,
  36,
  61,
  47,
  31,
  65,
  46,
  25,
  73,
  41,
  16,
  68,
  27,
  5,
  86,
  30,
  3,
  97,
  25,
  34,
  116,
  16,
  29,
  57,
  57,
  57,
  56,
  54,
  50,
  55,
  51,
  43,
  57,
  51,
  40,
  58,
  50,
  35,
  61,
  50,
  29,
  64,
  48,
  20,
  66,
  42,
  10,
  73,
  40,
  4,
  77,
  41,
  2,
  76,
  36,
  32,
  87,
  31,
  27,
  57,
  57,
  57,
  56,
  55,
  50,
  55,
  52,
  42,
  54,
  50,
  38,
  56,
  51,
  34,
  58,
  51,
  28,
  62,
  51,
  18,
  59,
  44,
  6,
  69,
  48,
  3,
  68,
  46,
  2,
  62,
  43,
  31,
  68,
  41,
  26,
  57,
  57,
  57,
  56,
  55,
  50,
  54,
  53,
  42,
  55,
  53,
  39,
  56,
  53,
  34,
  58,
  54,
  27,
  59,
  54,
  16,
  58,
  51,
  6,
  58,
  50,
  7,
  60,
  50,
  1,
  51,
  49,
  31,
  53,
  49,
  25,
  57,
  57,
  57,
  55,
  55,
  50,
  52,
  53,
  42,
  53,
  54,
  39,
  55,
  55,
  34,
  55,
  56,
  27,
  54,
  56,
  15,
  51,
  54,
  5,
  52,
  53,
  7,
  53,
  54,
  1,
  40,
  54,
  30,
  39,
  56,
  25,
  57,
  57,
  57,
  54,
  55,
  50,
  51,
  53,
  42,
  51,
  54,
  39,
  51,
  56,
  34,
  51,
  57,
  28,
  50,
  59,
  18,
  43,
  55,
  7,
  46,
  56,
  8,
  45,
  58,
  2,
  29,
  60,
  31,
  24,
  64,
  25,
  57,
  57,
  57,
  54,
  56,
  50,
  50,
  54,
  43,
  49,
  55,
  40,
  48,
  56,
  35,
  47,
  58,
  29,
  45,
  61,
  21,
  37,
  60,
  10,
  35,
  63,
  4,
  36,
  62,
  3,
  17,
  66,
  31,
  10,
  71,
  26,
  57,
  57,
  57,
  53,
  56,
  51,
  49,
  55,
  44,
  48,
  56,
  41,
  46,
  58,
  37,
  43,
  60,
  32,
  40,
  64,
  25,
  34,
  66,
  15,
  25,
  66,
  6,
  26,
  66,
  6,
  16,
  73,
  0,
  0,
  78,
  29,
  57,
  57,
  57,
  53,
  56,
  52,
  48,
  55,
  46,
  46,
  57,
  43,
  44,
  59,
  40,
  41,
  62,
  35,
  36,
  65,
  29,
  27,
  68,
  20,
  24,
  65,
  18,
  17,
  70,
  12,
  5,
  78,
  3,
  0,
  84,
  0,
  57,
  57,
  57,
  52,
  57,
  53,
  47,
  56,
  48,
  45,
  57,
  45,
  42,
  60,
  43,
  37,
  62,
  38,
  31,
  66,
  34,
  21,
  69,
  26,
  19,
  66,
  25,
  12,
  71,
  19,
  0,
  79,
  11,
  0,
  85,
  4,
  57,
  57,
  57,
  52,
  57,
  54,
  46,
  56,
  50,
  43,
  57,
  48,
  39,
  60,
  47,
  33,
  62,
  45,
  25,
  67,
  43,
  23,
  61,
  41,
  12,
  67,
  39,
  3,
  72,
  36,
  0,
  80,
  31,
  0,
  86,
  27,
  57,
  57,
  57,
  51,
  56,
  55,
  45,
  55,
  52,
  41,
  57,
  52,
  37,
  59,
  52,
  31,
  62,
  53,
  20,
  64,
  51,
  20,
  61,
  47,
  10,
  67,
  46,
  0,
  72,
  45,
  0,
  80,
  44,
  0,
  86,
  43,
  57,
  57,
  57,
  51,
  56,
  56,
  45,
  55,
  54,
  41,
  56,
  55,
  37,
  59,
  56,
  31,
  61,
  58,
  18,
  64,
  58,
  19,
  61,
  53,
  7,
  67,
  54,
  0,
  71,
  56,
  0,
  79,
  60,
  0,
  85,
  65,
  57,
  57,
  57,
  51,
  56,
  57,
  45,
  54,
  57,
  41,
  54,
  59,
  38,
  56,
  63,
  31,
  58,
  67,
  19,
  60,
  72,
  17,
  59,
  66,
  3,
  65,
  74,
  0,
  69,
  83,
  0,
  77,
  106,
  0,
  81,
  133,
  57,
  57,
  57,
  52,
  55,
  58,
  46,
  53,
  59,
  41,
  51,
  58,
  38,
  52,
  63,
  31,
  53,
  68,
  22,
  58,
  80,
  16,
  58,
  76,
  1,
  63,
  87,
  0,
  68,
  100,
  0,
  74,
  136,
  0,
  79,
  180,
  57,
  57,
  57,
  52,
  55,
  59,
  46,
  52,
  60,
  44,
  52,
  63,
  41,
  54,
  70,
  36,
  55,
  77,
  26,
  55,
  87,
  14,
  57,
  96,
  0,
  60,
  104,
  0,
  65,
  121,
  0,
  71,
  177,
  0,
  74,
  247,
  57,
  57,
  57,
  52,
  54,
  59,
  47,
  51,
  60,
  47,
  54,
  67,
  43,
  53,
  73,
  38,
  54,
  82,
  30,
  53,
  94,
  17,
  53,
  105,
  2,
  56,
  123,
  0,
  59,
  154,
  0,
  62,
  242,
  0,
  64,
  255,
  57,
  57,
  57,
  52,
  54,
  59,
  47,
  50,
  60,
  45,
  50,
  65,
  42,
  50,
  71,
  39,
  50,
  81,
  33,
  49,
  95,
  27,
  47,
  102,
  14,
  46,
  140,
  0,
  46,
  187,
  0,
  43,
  255,
  0,
  39,
  255,
  57,
  57,
  57,
  53,
  53,
  59,
  48,
  49,
  60,
  46,
  49,
  65,
  45,
  49,
  73,
  42,
  48,
  82,
  35,
  43,
  90,
  34,
  43,
  102,
  24,
  41,
  140,
  11,
  39,
  186,
  0,
  33,
  255,
  0,
  25,
  255,
  57,
  57,
  57,
  53,
  53,
  58,
  49,
  48,
  59,
  48,
  48,
  65,
  46,
  46,
  70,
  44,
  43,
  78,
  41,
  40,
  89,
  41,
  41,
  99,
  35,
  37,
  135,
  27,
  33,
  177,
  3,
  23,
  255,
  0,
  12,
  255,
  57,
  57,
  57,
  54,
  53,
  58,
  50,
  48,
  59,
  50,
  47,
  64,
  49,
  45,
  69,
  48,
  43,
  77,
  49,
  42,
  91,
  47,
  38,
  95,
  45,
  33,
  127,
  42,
  27,
  165,
  30,
  15,
  255,
  10,
  0,
  255,
  57,
  57,
  57,
  55,
  53,
  58,
  52,
  48,
  58,
  52,
  47,
  63,
  51,
  44,
  67,
  54,
  43,
  76,
  53,
  39,
  84,
  53,
  36,
  90,
  55,
  30,
  117,
  56,
  23,
  150,
  56,
  7,
  231,
  51,
  0,
  255,
  57,
  57,
  57,
  55,
  53,
  58,
  53,
  48,
  58,
  55,
  48,
  62,
  55,
  45,
  65,
  55,
  41,
  70,
  59,
  38,
  80,
  59,
  34,
  84,
  65,
  27,
  107,
  70,
  19,
  134,
  81,
  1,
  199,
  90,
  0,
  255,
  57,
  57,
  57,
  56,
  53,
  57,
  55,
  49,
  57,
  56,
  47,
  59,
  58,
  45,
  63,
  57,
  40,
  65,
  61,
  36,
  72,
  64,
  33,
  78,
  74,
  25,
  95,
  84,
  15,
  115,
  105,
  0,
  165,
  128,
  0,
  227,
  57,
  57,
  57,
  57,
  53,
  57,
  56,
  49,
  56,
  56,
  46,
  56,
  58,
  44,
  58,
  60,
  39,
  59,
  67,
  35,
  64,
  71,
  28,
  67,
  84,
  22,
  81,
  98,
  12,
  96,
  129,
  0,
  130,
  165,
  0,
  171,
  84,
  84,
  84,
  79,
  74,
  77,
  74,
  64,
  70,
  77,
  62,
  71,
  80,
  60,
  72,
  81,
  53,
  71,
  90,
  49,
  74,
  98,
  41,
  76,
  116,
  31,
  84,
  136,
  18,
  94,
  183,
  0,
  116,
  237,
  0,
  142,
  84,
  84,
  84,
  79,
  74,
  76,
  74,
  63,
  67,
  76,
  62,
  66,
  81,
  61,
  66,
  86,
  58,
  66,
  92,
  51,
  64,
  102,
  42,
  63,
  116,
  31,
  63,
  147,
  17,
  70,
  201,
  0,
  78,
  255,
  0,
  88,
  84,
  84,
  84,
  79,
  74,
  74,
  74,
  64,
  64,
  79,
  65,
  65,
  82,
  63,
  63,
  87,
  59,
  60,
  91,
  53,
  56,
  101,
  46,
  52,
  114,
  35,
  46,
  153,
  19,
  45,
  210,
  0,
  44,
  255,
  0,
  43,
  84,
  84,
  84,
  79,
  75,
  74,
  74,
  65,
  63,
  74,
  63,
  59,
  81,
  63,
  58,
  86,
  60,
  54,
  90,
  55,
  47,
  98,
  49,
  40,
  111,
  40,
  33,
  124,
  27,
  25,
  201,
  0,
  18,
  255,
  0,
  13,
  84,
  84,
  84,
  79,
  75,
  73,
  74,
  66,
  61,
  75,
  65,
  57,
  80,
  65,
  54,
  82,
  61,
  47,
  87,
  57,
  40,
  94,
  52,
  32,
  105,
  45,
  23,
  119,
  33,
  13,
  174,
  17,
  5,
  205,
  0,
  51,
  84,
  84,
  84,
  79,
  76,
  72,
  74,
  67,
  59,
  75,
  66,
  55,
  77,
  65,
  50,
  80,
  63,
  44,
  85,
  61,
  36,
  93,
  59,
  27,
  96,
  48,
  13,
  106,
  43,
  5,
  119,
  36,
  48,
  141,
  25,
  44,
  84,
  84,
  84,
  79,
  76,
  71,
  73,
  68,
  58,
  74,
  67,
  53,
  75,
  66,
  47,
  79,
  66,
  41,
  85,
  66,
  33,
  89,
  62,
  20,
  92,
  55,
  8,
  99,
  55,
  5,
  95,
  48,
  47,
  107,
  43,
  42,
  84,
  84,
  84,
  78,
  76,
  71,
  72,
  68,
  57,
  73,
  68,
  52,
  74,
  67,
  46,
  76,
  67,
  39,
  80,
  67,
  30,
  83,
  65,
  17,
  85,
  60,
  5,
  88,
  60,
  4,
  78,
  57,
  46,
  84,
  55,
  40,
  84,
  84,
  84,
  78,
  76,
  70,
  71,
  68,
  56,
  72,
  69,
  52,
  73,
  69,
  45,
  77,
  72,
  39,
  77,
  70,
  27,
  79,
  70,
  14,
  82,
  70,
  5,
  79,
  65,
  4,
  65,
  64,
  45,
  67,
  64,
  40,
  84,
  84,
  84,
  77,
  77,
  70,
  69,
  69,
  56,
  69,
  69,
  51,
  71,
  71,
  46,
  75,
  75,
  39,
  73,
  75,
  27,
  73,
  76,
  14,
  74,
  77,
  5,
  70,
  70,
  4,
  52,
  71,
  45,
  50,
  73,
  39,
  84,
  84,
  84,
  76,
  78,
  71,
  68,
  71,
  57,
  68,
  72,
  53,
  68,
  73,
  47,
  68,
  75,
  39,
  66,
  76,
  30,
  65,
  79,
  17,
  62,
  79,
  6,
  60,
  75,
  4,
  38,
  78,
  45,
  32,
  82,
  40,
  84,
  84,
  84,
  76,
  78,
  71,
  67,
  72,
  58,
  67,
  74,
  54,
  66,
  75,
  49,
  64,
  77,
  41,
  61,
  79,
  32,
  58,
  83,
  21,
  49,
  81,
  8,
  49,
  80,
  6,
  24,
  85,
  46,
  14,
  91,
  41,
  84,
  84,
  84,
  75,
  79,
  72,
  66,
  73,
  60,
  64,
  74,
  56,
  62,
  76,
  50,
  60,
  79,
  44,
  56,
  81,
  36,
  50,
  86,
  25,
  40,
  89,
  12,
  37,
  85,
  11,
  24,
  94,
  0,
  0,
  99,
  43,
  84,
  84,
  84,
  75,
  79,
  73,
  65,
  73,
  61,
  63,
  75,
  58,
  59,
  76,
  53,
  55,
  79,
  47,
  50,
  83,
  41,
  41,
  88,
  30,
  35,
  83,
  26,
  26,
  89,
  18,
  11,
  99,
  6,
  0,
  107,
  0,
  84,
  84,
  84,
  74,
  79,
  74,
  63,
  73,
  63,
  60,
  75,
  60,
  55,
  76,
  56,
  51,
  79,
  51,
  45,
  85,
  47,
  35,
  91,
  39,
  29,
  85,
  33,
  19,
  91,
  27,
  3,
  101,
  16,
  0,
  109,
  8,
  84,
  84,
  84,
  73,
  79,
  75,
  61,
  73,
  65,
  56,
  73,
  63,
  52,
  76,
  62,
  47,
  81,
  61,
  37,
  86,
  58,
  33,
  79,
  53,
  20,
  86,
  51,
  8,
  92,
  48,
  0,
  103,
  43,
  0,
  110,
  38,
  84,
  84,
  84,
  72,
  79,
  76,
  60,
  73,
  67,
  56,
  74,
  68,
  52,
  77,
  69,
  45,
  81,
  70,
  34,
  85,
  70,
  29,
  79,
  63,
  16,
  86,
  62,
  4,
  92,
  61,
  0,
  102,
  60,
  0,
  110,
  59,
  84,
  84,
  84,
  72,
  78,
  78,
  60,
  72,
  71,
  57,
  75,
  73,
  52,
  78,
  75,
  44,
  80,
  77,
  32,
  83,
  78,
  27,
  78,
  71,
  13,
  85,
  74,
  0,
  91,
  75,
  0,
  101,
  81,
  0,
  109,
  86,
  84,
  84,
  84,
  73,
  78,
  79,
  61,
  72,
  74,
  58,
  73,
  78,
  51,
  72,
  80,
  44,
  75,
  88,
  32,
  78,
  95,
  25,
  76,
  91,
  8,
  83,
  101,
  0,
  89,
  110,
  0,
  98,
  136,
  0,
  105,
  166,
  84,
  84,
  84,
  73,
  77,
  80,
  61,
  70,
  75,
  58,
  71,
  80,
  53,
  72,
  85,
  46,
  73,
  93,
  36,
  75,
  103,
  23,
  80,
  114,
  6,
  80,
  116,
  0,
  86,
  130,
  0,
  95,
  172,
  0,
  101,
  221,
  84,
  84,
  84,
  73,
  77,
  80,
  62,
  69,
  76,
  60,
  70,
  81,
  54,
  69,
  86,
  48,
  70,
  95,
  38,
  72,
  109,
  25,
  75,
  125,
  6,
  76,
  138,
  0,
  82,
  161,
  0,
  90,
  223,
  0,
  95,
  255,
  84,
  84,
  84,
  73,
  76,
  81,
  62,
  68,
  78,
  61,
  69,
  84,
  56,
  68,
  90,
  51,
  69,
  100,
  41,
  67,
  112,
  32,
  66,
  123,
  12,
  68,
  161,
  0,
  72,
  202,
  0,
  78,
  255,
  0,
  82,
  255,
  84,
  84,
  84,
  74,
  76,
  82,
  63,
  67,
  79,
  62,
  68,
  85,
  58,
  68,
  92,
  54,
  68,
  104,
  47,
  66,
  117,
  39,
  62,
  126,
  23,
  61,
  170,
  4,
  61,
  223,
  0,
  58,
  255,
  0,
  54,
  255,
  84,
  84,
  84,
  74,
  75,
  82,
  64,
  66,
  79,
  62,
  65,
  85,
  59,
  64,
  91,
  55,
  61,
  100,
  51,
  59,
  107,
  46,
  58,
  126,
  35,
  55,
  170,
  20,
  52,
  222,
  0,
  46,
  255,
  0,
  38,
  255,
  84,
  84,
  84,
  75,
  75,
  82,
  66,
  65,
  79,
  65,
  65,
  85,
  61,
  61,
  89,
  60,
  60,
  101,
  56,
  57,
  105,
  54,
  55,
  123,
  47,
  50,
  164,
  38,
  45,
  213,
  11,
  34,
  255,
  0,
  22,
  255,
  84,
  84,
  84,
  76,
  75,
  81,
  67,
  65,
  78,
  67,
  63,
  83,
  64,
  60,
  88,
  66,
  61,
  101,
  61,
  55,
  103,
  61,
  52,
  119,
  59,
  46,
  156,
  55,
  39,
  199,
  41,
  25,
  255,
  19,
  8,
  255,
  84,
  84,
  84,
  77,
  74,
  81,
  69,
  64,
  77,
  69,
  63,
  82,
  68,
  60,
  86,
  70,
  59,
  97,
  67,
  53,
  99,
  68,
  49,
  113,
  70,
  42,
  145,
  72,
  34,
  183,
  71,
  16,
  255,
  66,
  0,
  255,
  84,
  84,
  84,
  78,
  75,
  80,
  71,
  65,
  76,
  72,
  63,
  80,
  72,
  60,
  83,
  74,
  57,
  91,
  72,
  51,
  94,
  75,
  47,
  106,
  82,
  38,
  133,
  88,
  29,
  164,
  100,
  8,
  240,
  110,
  0,
  255,
  84,
  84,
  84,
  78,
  75,
  80,
  72,
  65,
  75,
  73,
  62,
  76,
  73,
  58,
  78,
  75,
  54,
  84,
  77,
  49,
  90,
  82,
  45,
  98,
  94,
  35,
  119,
  105,
  25,
  143,
  129,
  1,
  201,
  155,
  0,
  255,
  84,
  84,
  84,
  79,
  74,
  79,
  73,
  64,
  73,
  73,
  61,
  73,
  75,
  58,
  75,
  78,
  53,
  77,
  84,
  48,
  82,
  91,
  41,
  88,
  105,
  32,
  102,
  121,
  21,
  119,
  157,
  0,
  159,
  198,
  0,
  207,
  110,
  110,
  110,
  101,
  96,
  99,
  92,
  82,
  87,
  93,
  77,
  87,
  96,
  75,
  89,
  99,
  68,
  88,
  106,
  61,
  89,
  116,
  53,
  92,
  142,
  43,
  106,
  166,
  29,
  118,
  219,
  0,
  143,
  255,
  0,
  173,
  110,
  110,
  110,
  102,
  97,
  98,
  94,
  83,
  86,
  92,
  77,
  81,
  99,
  77,
  83,
  105,
  72,
  82,
  111,
  65,
  80,
  123,
  56,
  79,
  138,
  43,
  78,
  179,
  27,
  88,
  241,
  0,
  98,
  255,
  0,
  109,
  110,
  110,
  110,
  102,
  97,
  97,
  94,
  83,
  83,
  97,
  82,
  82,
  100,
  78,
  78,
  104,
  74,
  75,
  109,
  67,
  69,
  121,
  59,
  65,
  137,
  48,
  60,
  186,
  30,
  58,
  251,
  0,
  55,
  255,
  0,
  54,
  110,
  110,
  110,
  101,
  97,
  95,
  92,
  83,
  79,
  94,
  80,
  75,
  99,
  79,
  73,
  104,
  76,
  68,
  107,
  68,
  59,
  120,
  63,
  52,
  135,
  55,
  44,
  179,
  38,
  33,
  239,
  10,
  23,
  255,
  0,
  17,
  110,
  110,
  110,
  101,
  97,
  93,
  91,
  83,
  76,
  93,
  81,
  71,
  96,
  79,
  67,
  99,
  75,
  59,
  105,
  71,
  51,
  115,
  67,
  42,
  128,
  59,
  30,
  144,
  48,
  20,
  207,
  29,
  8,
  255,
  4,
  3,
  110,
  110,
  110,
  101,
  97,
  92,
  91,
  83,
  74,
  92,
  82,
  69,
  94,
  80,
  63,
  97,
  78,
  55,
  103,
  77,
  47,
  110,
  72,
  35,
  120,
  66,
  22,
  131,
  56,
  10,
  166,
  51,
  1,
  170,
  37,
  62,
  110,
  110,
  110,
  100,
  97,
  91,
  90,
  84,
  72,
  91,
  83,
  66,
  93,
  82,
  60,
  97,
  82,
  52,
  100,
  80,
  42,
  106,
  77,
  29,
  116,
  74,
  16,
  125,
  70,
  5,
  138,
  66,
  0,
  131,
  58,
  59,
  110,
  110,
  110,
  100,
  98,
  91,
  89,
  85,
  71,
  90,
  84,
  65,
  91,
  83,
  59,
  94,
  83,
  50,
  98,
  84,
  39,
  102,
  83,
  25,
  108,
  80,
  11,
  111,
  78,
  8,
  98,
  74,
  63,
  104,
  71,
  58,
  110,
  110,
  110,
  99,
  98,
  91,
  88,
  86,
  71,
  89,
  86,
  65,
  90,
  86,
  58,
  92,
  86,
  49,
  93,
  86,
  37,
  99,
  88,
  23,
  99,
  84,
  8,
  100,
  83,
  8,
  82,
  82,
  63,
  84,
  82,
  57,
  110,
  110,
  110,
  98,
  98,
  91,
  86,
  86,
  71,
  87,
  87,
  65,
  88,
  87,
  58,
  89,
  89,
  49,
  90,
  91,
  38,
  89,
  91,
  22,
  92,
  94,
  8,
  90,
  89,
  8,
  67,
  90,
  63,
  64,
  93,
  57,
  110,
  110,
  110,
  97,
  99,
  91,
  84,
  87,
  71,
  84,
  88,
  66,
  84,
  89,
  60,
  83,
  90,
  50,
  82,
  93,
  39,
  82,
  96,
  25,
  79,
  98,
  10,
  78,
  95,
  9,
  72,
  100,
  0,
  42,
  103,
  57,
  110,
  110,
  110,
  97,
  99,
  91,
  83,
  88,
  72,
  81,
  88,
  67,
  81,
  91,
  61,
  79,
  93,
  53,
  76,
  95,
  42,
  73,
  100,
  29,
  66,
  103,
  13,
  65,
  101,
  11,
  55,
  109,
  0,
  21,
  114,
  58,
  110,
  110,
  110,
  96,
  99,
  92,
  81,
  88,
  74,
  80,
  90,
  70,
  76,
  91,
  63,
  74,
  94,
  55,
  70,
  98,
  46,
  64,
  104,
  34,
  55,
  108,
  19,
  52,
  107,
  16,
  36,
  117,
  1,
  0,
  125,
  60,
  110,
  110,
  110,
  95,
  100,
  93,
  80,
  89,
  76,
  77,
  90,
  72,
  73,
  92,
  66,
  68,
  95,
  59,
  63,
  101,
  52,
  55,
  106,
  40,
  49,
  104,
  35,
  38,
  112,
  25,
  19,
  124,
  11,
  3,
  134,
  1,
  110,
  110,
  110,
  94,
  100,
  94,
  78,
  89,
  78,
  75,
  91,
  75,
  69,
  92,
  70,
  64,
  96,
  65,
  58,
  102,
  59,
  53,
  99,
  54,
  40,
  107,
  44,
  29,
  114,
  37,
  8,
  127,
  23,
  0,
  137,
  13,
  110,
  110,
  110,
  94,
  100,
  96,
  77,
  90,
  81,
  72,
  91,
  80,
  67,
  94,
  79,
  61,
  99,
  77,
  51,
  104,
  73,
  45,
  100,
  70,
  29,
  108,
  67,
  15,
  116,
  64,
  0,
  129,
  57,
  0,
  139,
  51,
  110,
  110,
  110,
  93,
  100,
  98,
  76,
  90,
  85,
  72,
  91,
  86,
  66,
  94,
  87,
  59,
  98,
  87,
  47,
  102,
  85,
  41,
  100,
  81,
  24,
  108,
  81,
  9,
  116,
  80,
  0,
  128,
  79,
  0,
  138,
  78,
  110,
  110,
  110,
  93,
  100,
  99,
  76,
  89,
  88,
  72,
  91,
  90,
  66,
  94,
  92,
  58,
  98,
  94,
  45,
  100,
  95,
  38,
  99,
  92,
  20,
  107,
  96,
  4,
  115,
  98,
  0,
  127,
  105,
  0,
  137,
  112,
  110,
  110,
  110,
  93,
  99,
  101,
  76,
  88,
  91,
  71,
  88,
  95,
  66,
  90,
  100,
  57,
  92,
  106,
  45,
  95,
  115,
  35,
  96,
  116,
  14,
  103,
  130,
  0,
  111,
  142,
  0,
  122,
  173,
  0,
  131,
  206,
  110,
  110,
  110,
  94,
  98,
  102,
  77,
  86,
  93,
  73,
  88,
  98,
  66,
  87,
  102,
  59,
  88,
  110,
  48,
  91,
  122,
  36,
  93,
  129,
  13,
  100,
  151,
  0,
  107,
  169,
  0,
  118,
  216,
  0,
  127,
  255,
  110,
  110,
  110,
  94,
  98,
  102,
  78,
  85,
  94,
  74,
  85,
  97,
  69,
  86,
  104,
  62,
  88,
  116,
  51,
  88,
  130,
  37,
  91,
  149,
  15,
  94,
  175,
  0,
  100,
  207,
  0,
  111,
  255,
  0,
  119,
  255,
  110,
  110,
  110,
  95,
  98,
  103,
  79,
  85,
  95,
  77,
  85,
  102,
  71,
  84,
  108,
  65,
  85,
  120,
  55,
  83,
  133,
  45,
  84,
  150,
  23,
  86,
  196,
  0,
  89,
  247,
  0,
  95,
  255,
  0,
  102,
  255,
  110,
  110,
  110,
  95,
  97,
  104,
  80,
  84,
  97,
  76,
  83,
  102,
  73,
  83,
  111,
  67,
  82,
  122,
  61,
  79,
  133,
  53,
  79,
  154,
  34,
  79,
  204,
  13,
  78,
  255,
  0,
  76,
  255,
  0,
  72,
  255,
  110,
  110,
  110,
  96,
  97,
  104,
  81,
  83,
  97,
  79,
  82,
  103,
  74,
  79,
  110,
  70,
  76,
  119,
  67,
  76,
  132,
  61,
  75,
  154,
  48,
  72,
  204,
  31,
  69,
  255,
  0,
  62,
  255,
  0,
  53,
  255,
  110,
  110,
  110,
  96,
  96,
  103,
  82,
  81,
  96,
  81,
  80,
  102,
  78,
  78,
  109,
  76,
  76,
  119,
  73,
  73,
  130,
  69,
  71,
  151,
  61,
  66,
  198,
  51,
  61,
  253,
  22,
  48,
  255,
  0,
  35,
  255,
  110,
  110,
  110,
  97,
  96,
  103,
  84,
  81,
  96,
  83,
  80,
  101,
  82,
  78,
  109,
  82,
  76,
  119,
  79,
  71,
  127,
  78,
  68,
  146,
  75,
  61,
  189,
  71,
  53,
  238,
  56,
  37,
  255,
  32,
  18,
  255,
  110,
  110,
  110,
  98,
  96,
  103,
  86,
  81,
  95,
  86,
  80,
  100,
  86,
  76,
  106,
  86,
  73,
  114,
  85,
  69,
  123,
  86,
  65,
  140,
  88,
  56,
  177,
  90,
  47,
  220,
  90,
  27,
  255,
  84,
  4,
  255,
  110,
  110,
  110,
  99,
  96,
  102,
  88,
  81,
  94,
  89,
  79,
  98,
  89,
  76,
  102,
  90,
  72,
  110,
  91,
  67,
  117,
  95,
  62,
  131,
  102,
  52,
  163,
  109,
  42,
  199,
  123,
  18,
  255,
  134,
  0,
  255,
  110,
  110,
  110,
  100,
  96,
  101,
  89,
  81,
  92,
  90,
  78,
  94,
  91,
  75,
  98,
  92,
  70,
  103,
  96,
  65,
  111,
  103,
  60,
  122,
  116,
  48,
  146,
  129,
  36,
  175,
  156,
  10,
  241,
  185,
  0,
  255,
  110,
  110,
  110,
  100,
  96,
  100,
  90,
  81,
  89,
  90,
  77,
  90,
  93,
  74,
  93,
  96,
  67,
  94,
  103,
  62,
  99,
  112,
  58,
  109,
  130,
  45,
  127,
  148,
  32,
  147,
  189,
  2,
  193,
  234,
  0,
  248,
  132,
  132,
  132,
  122,
  117,
  120,
  112,
  101,
  107,
  116,
  98,
  109,
  118,
  93,
  108,
  122,
  87,
  108,
  127,
  77,
  108,
  147,
  73,
  119,
  172,
  58,
  131,
  199,
  42,
  145,
  255,
  5,
  174,
  255,
  0,
  209,
  132,
  132,
  132,
  123,
  117,
  118,
  113,
  101,
  104,
  116,
  99,
  104,
  120,
  95,
  103,
  127,
  90,
  102,
  134,
  82,
  99,
  147,
  73,
  98,
  184,
  57,
  103,
  215,
  40,
  109,
  255,
  2,
  120,
  255,
  0,
  134,
  132,
  132,
  132,
  123,
  118,
  117,
  114,
  103,
  102,
  117,
  101,
  100,
  120,
  97,
  97,
  126,
  92,
  93,
  133,
  85,
  88,
  144,
  75,
  80,
  189,
  60,
  76,
  223,
  43,
  73,
  255,
  6,
  68,
  255,
  0,
  67,
  132,
  132,
  132,
  123,
  118,
  116,
  114,
  103,
  99,
  117,
  102,
  97,
  120,
  99,
  92,
  126,
  95,
  86,
  132,
  87,
  76,
  145,
  81,
  68,
  183,
  68,
  53,
  215,
  53,
  44,
  255,
  21,
  30,
  255,
  0,
  22,
  132,
  132,
  132,
  123,
  118,
  114,
  113,
  103,
  96,
  115,
  101,
  92,
  117,
  99,
  86,
  124,
  96,
  78,
  128,
  89,
  66,
  141,
  86,
  56,
  169,
  77,
  38,
  194,
  67,
  27,
  246,
  44,
  11,
  255,
  16,
  4,
  132,
  132,
  132,
  122,
  118,
  113,
  112,
  104,
  94,
  113,
  102,
  88,
  115,
  100,
  81,
  118,
  97,
  71,
  125,
  95,
  60,
  134,
  91,
  47,
  144,
  83,
  30,
  169,
  81,
  18,
  200,
  68,
  3,
  206,
  50,
  83,
  132,
  132,
  132,
  122,
  119,
  112,
  112,
  105,
  92,
  112,
  104,
  86,
  113,
  102,
  77,
  116,
  100,
  67,
  120,
  99,
  55,
  130,
  98,
  41,
  139,
  92,
  23,
  151,
  88,
  10,
  169,
  85,
  0,
  158,
  75,
  80,
  132,
  132,
  132,
  122,
  119,
  112,
  111,
  106,
  91,
  111,
  105,
  85,
  113,
  105,
  76,
  115,
  104,
  65,
  119,
  104,
  53,
  126,
  104,
  37,
  133,
  100,
  18,
  137,
  95,
  6,
  148,
  96,
  0,
  127,
  91,
  79,
  132,
  132,
  132,
  121,
  120,
  112,
  109,
  107,
  91,
  110,
  106,
  84,
  110,
  106,
  75,
  111,
  105,
  63,
  114,
  106,
  50,
  118,
  107,
  33,
  122,
  106,
  15,
  129,
  108,
  4,
  129,
  106,
  0,
  103,
  103,
  78,
  132,
  132,
  132,
  120,
  120,
  111,
  107,
  107,
  90,
  108,
  108,
  84,
  108,
  107,
  75,
  109,
  109,
  64,
  111,
  111,
  51,
  112,
  114,
  34,
  112,
  115,
  15,
  114,
  117,
  4,
  111,
  115,
  0,
  80,
  115,
  77,
  132,
  132,
  132,
  119,
  120,
  111,
  105,
  107,
  90,
  105,
  108,
  85,
  105,
  110,
  77,
  105,
  112,
  67,
  104,
  114,
  53,
  104,
  119,
  37,
  102,
  122,
  17,
  98,
  124,
  5,
  93,
  124,
  0,
  55,
  128,
  77,
  132,
  132,
  132,
  117,
  120,
  112,
  102,
  108,
  91,
  101,
  109,
  85,
  100,
  110,
  78,
  99,
  113,
  68,
  97,
  117,
  56,
  93,
  122,
  40,
  86,
  127,
  21,
  85,
  125,
  17,
  72,
  134,
  0,
  30,
  141,
  78,
  132,
  132,
  132,
  117,
  121,
  113,
  101,
  109,
  93,
  99,
  110,
  88,
  97,
  112,
  81,
  94,
  116,
  72,
  89,
  120,
  61,
  82,
  126,
  46,
  76,
  125,
  37,
  68,
  132,
  23,
  50,
  145,
  5,
  32,
  156,
  0,
  132,
  132,
  132,
  116,
  121,
  114,
  100,
  110,
  96,
  97,
  112,
  91,
  93,
  114,
  85,
  88,
  118,
  77,
  81,
  123,
  68,
  76,
  120,
  62,
  64,
  129,
  47,
  52,
  138,
  35,
  29,
  153,
  17,
  9,
  166,
  5,
  132,
  132,
  132,
  116,
  122,
  116,
  99,
  111,
  99,
  95,
  113,
  95,
  88,
  114,
  89,
  83,
  119,
  83,
  77,
  117,
  77,
  69,
  122,
  70,
  55,
  132,
  58,
  40,
  141,
  49,
  16,
  157,
  33,
  0,
  170,
  20,
  132,
  132,
  132,
  115,
  122,
  118,
  98,
  112,
  103,
  93,
  115,
  101,
  86,
  116,
  98,
  78,
  121,
  96,
  69,
  118,
  91,
  59,
  124,
  90,
  40,
  134,
  86,
  23,
  143,
  83,
  0,
  159,
  75,
  0,
  171,
  68,
  132,
  132,
  132,
  115,
  122,
  120,
  97,
  112,
  107,
  92,
  114,
  107,
  84,
  116,
  106,
  75,
  120,
  106,
  65,
  118,
  102,
  54,
  124,
  103,
  34,
  134,
  103,
  17,
  143,
  102,
  0,
  158,
  101,
  0,
  171,
  100,
  132,
  132,
  132,
  115,
  122,
  122,
  97,
  112,
  111,
  91,
  114,
  111,
  83,
  115,
  112,
  73,
  118,
  114,
  62,
  117,
  112,
  51,
  123,
  116,
  29,
  132,
  121,
  10,
  142,
  125,
  0,
  157,
  134,
  0,
  169,
  142,
  132,
  132,
  132,
  115,
  121,
  123,
  97,
  110,
  114,
  90,
  110,
  117,
  83,
  111,
  121,
  74,
  114,
  129,
  61,
  114,
  134,
  48,
  118,
  144,
  23,
  127,
  163,
  0,
  136,
  179,
  0,
  151,
  216,
  0,
  162,
  253,
  132,
  132,
  132,
  115,
  120,
  124,
  97,
  108,
  115,
  93,
  108,
  119,
  85,
  108,
  125,
  77,
  111,
  135,
  65,
  115,
  151,
  50,
  115,
  160,
  23,
  123,
  188,
  0,
  131,
  212,
  0,
  145,
  255,
  0,
  156,
  255,
  132,
  132,
  132,
  115,
  119,
  124,
  98,
  106,
  116,
  95,
  107,
  121,
  88,
  107,
  129,
  79,
  108,
  140,
  67,
  107,
  153,
  54,
  110,
  172,
  27,
  116,
  214,
  0,
  123,
  254,
  0,
  134,
  255,
  0,
  145,
  255,
  132,
  132,
  132,
  116,
  119,
  125,
  99,
  106,
  118,
  96,
  106,
  125,
  88,
  104,
  131,
  82,
  104,
  142,
  72,
  103,
  159,
  61,
  105,
  182,
  36,
  108,
  233,
  8,
  110,
  255,
  0,
  115,
  255,
  0,
  120,
  255,
  132,
  132,
  132,
  116,
  118,
  126,
  99,
  104,
  119,
  96,
  104,
  126,
  91,
  102,
  134,
  86,
  101,
  144,
  78,
  100,
  161,
  69,
  100,
  186,
  48,
  99,
  242,
  24,
  99,
  255,
  0,
  97,
  255,
  0,
  93,
  255,
  132,
  132,
  132,
  116,
  117,
  126,
  100,
  101,
  119,
  94,
  96,
  122,
  92,
  97,
  132,
  91,
  98,
  139,
  85,
  96,
  161,
  78,
  95,
  186,
  63,
  92,
  242,
  45,
  88,
  255,
  0,
  80,
  255,
  0,
  71,
  255,
  132,
  132,
  132,
  117,
  117,
  126,
  102,
  101,
  119,
  101,
  101,
  126,
  97,
  97,
  132,
  95,
  96,
  137,
  92,
  93,
  159,
  88,
  91,
  183,
  78,
  85,
  236,
  67,
  79,
  255,
  35,
  65,
  255,
  0,
  50,
  255,
  132,
  132,
  132,
  119,
  117,
  126,
  105,
  102,
  119,
  104,
  101,
  125,
  103,
  98,
  133,
  100,
  94,
  135,
  99,
  91,
  155,
  97,
  87,
  177,
  94,
  79,
  226,
  89,
  71,
  255,
  73,
  52,
  255,
  46,
  32,
  255,
  132,
  132,
  132,
  120,
  118,
  126,
  108,
  103,
  119,
  109,
  101,
  125,
  106,
  96,
  129,
  104,
  92,
  132,
  105,
  88,
  150,
  107,
  84,
  170,
  109,
  74,
  213,
  111,
  63,
  255,
  111,
  41,
  255,
  104,
  15,
  255,
  132,
  132,
  132,
  121,
  118,
  125,
  110,
  103,
  117,
  110,
  100,
  121,
  110,
  96,
  126,
  109,
  91,
  128,
  113,
  86,
  144,
  117,
  80,
  161,
  125,
  69,
  198,
  133,
  57,
  238,
  148,
  30,
  255,
  161,
  0,
  255,
  132,
  132,
  132,
  122,
  117,
  123,
  111,
  102,
  114,
  112,
  100,
  118,
  113,
  94,
  121,
  113,
  88,
  125,
  120,
  84,
  136,
  127,
  77,
  149,
  141,
  64,
  178,
  156,
  51,
  211,
  186,
  20,
  255,
  219,
  0,
  255,
  132,
  132,
  132,
  122,
  117,
  122,
  111,
  101,
  111,
  112,
  98,
  113,
  109,
  89,
  110,
  115,
  85,
  116,
  127,
  82,
  127,
  137,
  75,
  136,
  157,
  61,
  156,
  178,
  45,
  179,
  224,
  12,
  231,
  255,
  0,
  255,
  155,
  155,
  155,
  146,
  140,
  144,
  137,
  124,
  132,
  140,
  121,
  133,
  143,
  115,
  133,
  147,
  108,
  133,
  164,
  101,
  140,
  178,
  93,
  145,
  207,
  76,
  159,
  237,
  57,
  174,
  255,
  16,
  208,
  255,
  0,
  246,
  155,
  155,
  155,
  147,
  140,
  142,
  139,
  125,
  129,
  140,
  121,
  127,
  147,
  118,
  126,
  153,
  112,
  125,
  150,
  95,
  114,
  186,
  93,
  125,
  220,
  75,
  127,
  255,
  56,
  132,
  255,
  13,
  145,
  255,
  0,
  161,
  155,
  155,
  155,
  148,
  142,
  141,
  140,
  128,
  127,
  131,
  113,
  112,
  146,
  118,
  118,
  154,
  115,
  116,
  161,
  107,
  109,
  190,
  95,
  102,
  226,
  78,
  94,
  255,
  60,
  90,
  255,
  18,
  84,
  255,
  0,
  81,
  155,
  155,
  155,
  148,
  142,
  140,
  140,
  129,
  124,
  145,
  128,
  122,
  148,
  123,
  115,
  154,
  119,
  108,
  161,
  111,
  97,
  186,
  101,
  82,
  219,
  87,
  67,
  254,
  71,
  56,
  255,
  36,
  39,
  255,
  0,
  28,
  155,
  155,
  155,
  147,
  142,
  137,
  138,
  128,
  119,
  139,
  124,
  112,
  146,
  124,
  108,
  152,
  120,
  99,
  157,
  113,
  86,
  176,
  108,
  70,
  203,
  99,
  51,
  231,
  87,
  36,
  255,
  61,
  17,
  255,
  30,
  7,
  155,
  155,
  155,
  146,
  142,
  136,
  137,
  128,
  116,
  139,
  126,
  110,
  143,
  124,
  102,
  148,
  122,
  91,
  152,
  116,
  76,
  163,
  113,
  61,
  184,
  110,
  42,
  203,
  104,
  26,
  238,
  89,
  6,
  238,
  70,
  107,
  155,
  155,
  155,
  146,
  143,
  135,
  137,
  130,
  115,
  138,
  128,
  108,
  140,
  126,
  97,
  142,
  123,
  85,
  148,
  121,
  71,
  157,
  119,
  54,
  169,
  119,
  38,
  182,
  115,
  22,
  205,
  107,
  2,
  188,
  96,
  104,
  155,
  155,
  155,
  146,
  143,
  135,
  136,
  131,
  114,
  137,
  131,
  107,
  139,
  130,
  97,
  142,
  129,
  84,
  147,
  128,
  69,
  154,
  128,
  49,
  162,
  125,
  27,
  169,
  121,
  11,
  180,
  120,
  1,
  154,
  114,
  103,
  155,
  155,
  155,
  145,
  144,
  135,
  135,
  132,
  114,
  134,
  130,
  105,
  136,
  130,
  95,
  138,
  130,
  82,
  142,
  131,
  67,
  145,
  131,
  46,
  149,
  130,
  24,
  160,
  134,
  9,
  160,
  131,
  0,
  126,
  128,
  102,
  155,
  155,
  155,
  144,
  144,
  135,
  133,
  132,
  114,
  133,
  132,
  106,
  134,
  133,
  96,
  135,
  134,
  83,
  138,
  137,
  68,
  136,
  136,
  46,
  143,
  144,
  25,
  144,
  146,
  9,
  139,
  141,
  0,
  99,
  142,
  101,
  155,
  155,
  155,
  143,
  144,
  135,
  130,
  133,
  114,
  130,
  133,
  107,
  128,
  133,
  96,
  130,
  137,
  86,
  129,
  140,
  70,
  128,
  144,
  49,
  126,
  148,
  27,
  124,
  144,
  22,
  117,
  152,
  1,
  71,
  156,
  101,
  155,
  155,
  155,
  141,
  144,
  135,
  127,
  133,
  114,
  125,
  133,
  107,
  123,
  134,
  98,
  123,
  139,
  87,
  120,
  143,
  72,
  116,
  140,
  65,
  111,
  147,
  43,
  107,
  153,
  25,
  93,
  164,
  3,
  77,
  174,
  0,
  155,
  155,
  155,
  141,
  145,
  136,
  126,
  134,
  116,
  123,
  136,
  110,
  121,
  139,
  103,
  117,
  142,
  92,
  113,
  147,
  79,
  106,
  144,
  71,
  97,
  153,
  50,
  87,
  161,
  33,
  67,
  176,
  10,
  46,
  189,
  0,
  155,
  155,
  155,
  140,
  146,
  137,
  125,
  136,
  119,
  122,
  138,
  114,
  117,
  140,
  107,
  111,
  144,
  98,
  104,
  142,
  89,
  97,
  147,
  79,
  83,
  158,
  61,
  68,
  168,
  47,
  42,
  186,
  25,
  18,
  201,
  9,
  155,
  155,
  155,
  139,
  146,
  138,
  123,
  137,
  121,
  119,
  138,
  117,
  114,
  142,
  112,
  107,
  146,
  105,
  97,
  144,
  96,
  89,
  150,
  88,
  71,
  161,
  75,
  55,
  172,
  63,
  26,
  190,
  44,
  1,
  206,
  28,
  155,
  155,
  155,
  138,
  146,
  140,
  121,
  137,
  125,
  116,
  139,
  123,
  109,
  143,
  121,
  100,
  139,
  116,
  88,
  145,
  114,
  76,
  152,
  112,
  54,
  163,
  108,
  34,
  174,
  104,
  1,
  193,
  95,
  0,
  208,
  86,
  155,
  155,
  155,
  137,
  146,
  142,
  119,
  136,
  129,
  113,
  138,
  128,
  106,
  141,
  129,
  97,
  138,
  125,
  83,
  145,
  125,
  71,
  151,
  126,
  47,
  163,
  128,
  26,
  174,
  128,
  0,
  192,
  127,
  0,
  207,
  125,
  155,
  155,
  155,
  137,
  146,
  144,
  119,
  136,
  133,
  113,
  138,
  133,
  105,
  140,
  136,
  95,
  138,
  133,
  81,
  144,
  138,
  67,
  150,
  142,
  42,
  162,
  150,
  19,
  172,
  155,
  0,
  190,
  166,
  0,
  205,
  175,
  155,
  155,
  155,
  137,
  145,
  146,
  119,
  134,
  137,
  114,
  136,
  142,
  105,
  136,
  146,
  94,
  137,
  153,
  79,
  140,
  163,
  64,
  145,
  176,
  35,
  155,
  199,
  8,
  165,
  219,
  0,
  183,
  255,
  0,
  197,
  255,
  155,
  155,
  155,
  138,
  144,
  148,
  120,
  132,
  140,
  114,
  131,
  143,
  109,
  135,
  153,
  99,
  136,
  162,
  81,
  136,
  175,
  66,
  141,
  193,
  35,
  149,
  228,
  5,
  159,
  255,
  0,
  175,
  255,
  0,
  190,
  255,
  155,
  155,
  155,
  138,
  143,
  148,
  120,
  130,
  141,
  116,
  131,
  148,
  109,
  131,
  155,
  102,
  132,
  166,
  86,
  132,
  185,
  71,
  135,
  207,
  40,
  142,
  255,
  7,
  149,
  255,
  0,
  162,
  255,
  0,
  174,
  255,
  155,
  155,
  155,
  138,
  142,
  149,
  120,
  128,
  143,
  116,
  128,
  149,
  109,
  126,
  155,
  104,
  126,
  167,
  92,
  128,
  191,
  79,
  129,
  217,
  51,
  132,
  255,
  19,
  136,
  255,
  0,
  141,
  255,
  0,
  144,
  255,
  155,
  155,
  155,
  138,
  141,
  150,
  121,
  127,
  144,
  120,
  128,
  152,
  115,
  125,
  159,
  109,
  124,
  168,
  99,
  124,
  194,
  89,
  124,
  221,
  65,
  123,
  255,
  38,
  123,
  255,
  0,
  121,
  255,
  0,
  117,
  255,
  155,
  155,
  155,
  138,
  139,
  147,
  121,
  123,
  139,
  123,
  125,
  152,
  117,
  122,
  156,
  114,
  121,
  168,
  107,
  120,
  193,
  99,
  118,
  221,
  82,
  115,
  255,
  61,
  111,
  255,
  9,
  102,
  255,
  0,
  92,
  255,
  155,
  155,
  155,
  141,
  141,
  150,
  127,
  126,
  145,
  127,
  125,
  152,
  121,
  120,
  155,
  119,
  119,
  167,
  114,
  116,
  191,
  109,
  114,
  218,
  99,
  108,
  255,
  86,
  100,
  255,
  51,
  85,
  255,
  1,
  68,
  255,
  155,
  155,
  155,
  143,
  141,
  150,
  130,
  126,
  145,
  130,
  125,
  152,
  124,
  119,
  153,
  124,
  117,
  164,
  122,
  113,
  187,
  120,
  109,
  212,
  116,
  101,
  255,
  111,
  91,
  255,
  93,
  70,
  255,
  65,
  47,
  255,
  155,
  155,
  155,
  144,
  141,
  150,
  132,
  126,
  144,
  134,
  126,
  151,
  128,
  117,
  151,
  128,
  115,
  161,
  130,
  110,
  182,
  131,
  105,
  204,
  133,
  95,
  254,
  136,
  83,
  255,
  136,
  57,
  255,
  130,
  28,
  255,
  155,
  155,
  155,
  145,
  141,
  149,
  134,
  126,
  142,
  136,
  125,
  148,
  131,
  116,
  148,
  134,
  113,
  157,
  138,
  108,
  175,
  143,
  101,
  194,
  152,
  89,
  236,
  161,
  75,
  255,
  178,
  45,
  255,
  193,
  11,
  255,
  155,
  155,
  155,
  145,
  140,
  147,
  135,
  125,
  139,
  137,
  123,
  143,
  139,
  118,
  146,
  139,
  112,
  151,
  147,
  105,
  165,
  154,
  98,
  181,
  171,
  83,
  214,
  187,
  68,
  250,
  222,
  34,
  255,
  255,
  0,
  255,
  155,
  155,
  155,
  146,
  140,
  146,
  136,
  125,
  136,
  135,
  120,
  137,
  140,
  116,
  139,
  147,
  112,
  144,
  156,
  103,
  153,
  166,
  95,
  164,
  189,
  79,
  188,
  213,
  62,
  214,
  255,
  24,
  255,
  255,
  0,
  255,
  195,
  195,
  195,
  180,
  173,
  178,
  165,
  151,
  160,
  166,
  146,
  160,
  168,
  141,
  160,
  180,
  135,
  165,
  195,
  126,
  171,
  211,
  116,
  178,
  244,
  97,
  193,
  255,
  76,
  210,
  255,
  30,
  248,
  255,
  0,
  255,
  195,
  195,
  195,
  180,
  172,
  175,
  164,
  149,
  155,
  167,
  145,
  153,
  173,
  142,
  152,
  186,
  135,
  151,
  204,
  125,
  151,
  222,
  116,
  152,
  255,
  96,
  155,
  255,
  74,
  162,
  255,
  27,
  176,
  255,
  0,
  194,
  195,
  195,
  195,
  180,
  173,
  173,
  164,
  150,
  150,
  170,
  149,
  149,
  174,
  145,
  145,
  188,
  136,
  138,
  207,
  128,
  131,
  226,
  119,
  126,
  255,
  100,
  117,
  255,
  79,
  112,
  255,
  32,
  104,
  255,
  0,
  99,
  195,
  195,
  195,
  181,
  174,
  172,
  166,
  153,
  149,
  172,
  153,
  147,
  175,
  149,
  140,
  187,
  139,
  126,
  204,
  132,
  115,
  223,
  125,
  104,
  255,
  110,
  86,
  255,
  92,
  73,
  255,
  52,
  52,
  255,
  7,
  38,
  195,
  195,
  195,
  181,
  175,
  171,
  166,
  154,
  146,
  170,
  153,
  141,
  174,
  150,
  134,
  181,
  147,
  125,
  197,
  138,
  103,
  212,
  133,
  89,
  241,
  123,
  66,
  255,
  110,
  48,
  255,
  81,
  24,
  255,
  47,
  11,
  195,
  195,
  195,
  180,
  175,
  168,
  165,
  154,
  141,
  167,
  152,
  134,
  170,
  149,
  125,
  176,
  148,
  114,
  187,
  145,
  96,
  199,
  142,
  81,
  220,
  136,
  56,
  242,
  128,
  36,
  255,
  113,
  11,
  255,
  95,
  0,
  195,
  195,
  195,
  179,
  175,
  167,
  163,
  155,
  138,
  165,
  153,
  130,
  166,
  150,
  120,
  170,
  148,
  107,
  177,
  147,
  90,
  187,
  148,
  77,
  203,
  145,
  51,
  217,
  142,
  31,
  244,
  133,
  6,
  255,
  123,
  0,
  195,
  195,
  195,
  179,
  176,
  166,
  162,
  156,
  137,
  163,
  155,
  128,
  164,
  153,
  117,
  168,
  152,
  103,
  174,
  153,
  86,
  182,
  153,
  65,
  189,
  153,
  50,
  201,
  151,
  29,
  217,
  147,
  4,
  184,
  140,
  130,
  195,
  195,
  195,
  178,
  176,
  166,
  161,
  157,
  136,
  161,
  156,
  127,
  163,
  156,
  117,
  164,
  155,
  102,
  168,
  156,
  84,
  172,
  156,
  61,
  178,
  156,
  35,
  219,
  183,
  10,
  255,
  208,
  0,
  235,
  255,
  0,
  195,
  195,
  195,
  177,
  177,
  166,
  159,
  158,
  136,
  158,
  158,
  127,
  160,
  159,
  117,
  161,
  160,
  103,
  182,
  181,
  109,
  181,
  180,
  83,
  187,
  187,
  39,
  186,
  186,
  10,
  222,
  222,
  0,
  211,
  224,
  0,
  195,
  195,
  195,
  176,
  178,
  166,
  156,
  160,
  137,
  156,
  160,
  129,
  154,
  160,
  117,
  153,
  161,
  103,
  159,
  168,
  102,
  156,
  171,
  80,
  164,
  184,
  54,
  152,
  175,
  31,
  145,
  184,
  4,
  133,
  193,
  0,
  195,
  195,
  195,
  175,
  178,
  167,
  154,
  161,
  139,
  152,
  161,
  131,
  150,
  162,
  121,
  148,
  165,
  108,
  145,
  166,
  98,
  142,
  170,
  83,
  137,
  178,
  57,
  131,
  185,
  36,
  116,
  198,
  8,
  99,
  210,
  0,
  195,
  195,
  195,
  174,
  179,
  169,
  152,
  162,
  142,
  149,
  163,
  135,
  146,
  165,
  126,
  142,
  163,
  118,
  137,
  169,
  103,
  131,
  174,
  90,
  120,
  185,
  66,
  109,
  194,
  46,
  86,
  212,
  16,
  62,
  228,
  0,
  195,
  195,
  195,
  173,
  179,
  170,
  151,
  163,
  145,
  148,
  165,
  139,
  140,
  162,
  130,
  136,
  165,
  123,
  128,
  172,
  111,
  120,
  178,
  99,
  104,
  190,
  79,
  87,
  202,
  62,
  57,
  223,
  35,
  29,
  241,
  16,
  195,
  195,
  195,
  172,
  180,
  172,
  149,
  164,
  148,
  142,
  159,
  139,
  136,
  163,
  134,
  131,
  167,
  129,
  121,
  174,
  119,
  111,
  181,
  111,
  91,
  194,
  95,
  71,
  206,
  81,
  37,
  228,
  58,
  8,
  247,
  40,
  195,
  195,
  195,
  171,
  180,
  173,
  147,
  164,
  151,
  138,
  160,
  145,
  131,
  164,
  143,
  123,
  168,
  143,
  109,
  176,
  140,
  96,
  183,
  138,
  70,
  197,
  134,
  47,
  209,
  130,
  7,
  232,
  120,
  0,
  250,
  111,
  195,
  195,
  195,
  170,
  179,
  175,
  144,
  163,
  155,
  140,
  166,
  156,
  128,
  164,
  151,
  120,
  168,
  152,
  105,
  175,
  153,
  90,
  183,
  155,
  62,
  196,
  157,
  37,
  209,
  158,
  0,
  231,
  159,
  0,
  249,
  158,
  195,
  195,
  195,
  169,
  179,
  177,
  143,
  162,
  159,
  138,
  165,
  161,
  126,
  163,
  159,
  118,
  167,
  162,
  101,
  174,
  168,
  86,
  181,
  173,
  56,
  194,
  184,
  29,
  207,
  191,
  0,
  228,
  205,
  0,
  246,
  217,
  195,
  195,
  195,
  169,
  178,
  180,
  143,
  160,
  164,
  137,
  161,
  171,
  126,
  160,
  175,
  118,
  163,
  183,
  100,
  169,
  198,
  83,
  175,
  213,
  49,
  186,
  242,
  17,
  198,
  255,
  0,
  218,
  255,
  0,
  235,
  255,
  195,
  195,
  195,
  170,
  177,
  182,
  145,
  159,
  168,
  140,
  159,
  172,
  128,
  158,
  180,
  120,
  161,
  190,
  103,
  165,
  211,
  86,
  170,
  232,
  51,
  179,
  255,
  15,
  190,
  255,
  0,
  209,
  255,
  0,
  226,
  255,
  195,
  195,
  195,
  171,
  176,
  183,
  146,
  157,
  170,
  140,
  155,
  172,
  131,
  156,
  185,
  124,
  157,
  196,
  108,
  160,
  221,
  92,
  164,
  246,
  58,
  171,
  255,
  20,
  179,
  255,
  0,
  193,
  255,
  0,
  207,
  255,
  195,
  195,
  195,
  172,
  176,
  184,
  148,
  157,
  172,
  145,
  158,
  180,
  135,
  153,
  187,
  129,
  154,
  200,
  116,
  155,
  228,
  101,
  157,
  255,
  70,
  161,
  255,
  34,
  165,
  255,
  0,
  170,
  255,
  0,
  174,
  255,
  195,
  195,
  195,
  173,
  176,
  185,
  151,
  157,
  175,
  144,
  151,
  175,
  140,
  151,
  188,
  134,
  151,
  202,
  124,
  151,
  230,
  112,
  151,
  255,
  85,
  151,
  255,
  55,
  151,
  255,
  0,
  148,
  255,
  0,
  145,
  255,
  195,
  195,
  195,
  172,
  173,
  182,
  149,
  150,
  169,
  147,
  150,
  175,
  143,
  149,
  188,
  140,
  148,
  201,
  132,
  147,
  230,
  123,
  145,
  255,
  103,
  142,
  255,
  81,
  137,
  255,
  24,
  128,
  255,
  0,
  116,
  255,
  195,
  195,
  195,
  176,
  175,
  185,
  156,
  155,
  175,
  149,
  149,
  174,
  147,
  147,
  187,
  145,
  146,
  200,
  140,
  143,
  228,
  134,
  140,
  255,
  121,
  133,
  255,
  107,
  126,
  255,
  69,
  109,
  255,
  16,
  90,
  255,
  195,
  195,
  195,
  177,
  175,
  185,
  158,
  154,
  174,
  151,
  148,
  173,
  151,
  146,
  185,
  150,
  144,
  197,
  148,
  140,
  224,
  146,
  135,
  252,
  140,
  126,
  255,
  135,
  115,
  255,
  116,
  92,
  255,
  86,
  66,
  255,
  195,
  195,
  195,
  179,
  176,
  185,
  162,
  157,
  175,
  154,
  147,
  172,
  155,
  144,
  183,
  155,
  142,
  194,
  157,
  136,
  218,
  158,
  131,
  244,
  160,
  119,
  255,
  163,
  106,
  255,
  163,
  77,
  255,
  157,
  45,
  255,
  195,
  195,
  195,
  181,
  177,
  185,
  166,
  158,
  174,
  154,
  143,
  167,
  159,
  143,
  180,
  161,
  140,
  190,
  114,
  96,
  138,
  171,
  126,
  232,
  180,
  112,
  255,
  191,
  97,
  255,
  210,
  63,
  255,
  227,
  26,
  255,
  195,
  195,
  195,
  180,
  175,
  183,
  165,
  155,
  170,
  165,
  152,
  173,
  163,
  141,
  175,
  167,
  138,
  183,
  175,
  130,
  200,
  184,
  122,
  218,
  202,
  106,
  255,
  221,
  88,
  255,
  255,
  50,
  255,
  255,
  8,
  255,
  195,
  195,
  195,
  180,
  174,
  180,
  164,
  153,
  165,
  166,
  150,
  168,
  167,
  140,
  170,
  173,
  136,
  175,
  185,
  128,
  188,
  198,
  119,
  200,
  224,
  100,
  226,
  251,
  81,
  255,
  255,
  39,
  255,
  255,
  0,
  255,
  225,
  225,
  225,
  210,
  201,
  208,
  194,
  176,
  190,
  197,
  174,
  192,
  206,
  169,
  196,
  214,
  164,
  199,
  232,
  154,
  206,
  250,
  143,
  213,
  255,
  121,
  230,
  255,
  98,
  249,
  255,
  47,
  255,
  255,
  0,
  255,
  225,
  225,
  225,
  211,
  201,
  204,
  197,
  176,
  182,
  202,
  174,
  183,
  211,
  169,
  182,
  222,
  164,
  181,
  242,
  153,
  182,
  255,
  143,
  183,
  255,
  120,
  185,
  255,
  96,
  193,
  255,
  43,
  209,
  255,
  0,
  228,
  225,
  225,
  225,
  212,
  201,
  200,
  198,
  177,
  175,
  203,
  175,
  172,
  214,
  170,
  169,
  224,
  165,
  165,
  245,
  156,
  158,
  255,
  146,
  152,
  255,
  125,
  142,
  255,
  101,
  136,
  255,
  50,
  126,
  255,
  0,
  120,
  225,
  225,
  225,
  211,
  202,
  198,
  197,
  178,
  171,
  202,
  176,
  166,
  212,
  173,
  159,
  222,
  169,
  153,
  242,
  161,
  140,
  255,
  153,
  128,
  255,
  136,
  106,
  255,
  116,
  90,
  255,
  73,
  65,
  255,
  23,
  48,
  225,
  225,
  225,
  211,
  202,
  196,
  196,
  179,
  167,
  200,
  178,
  162,
  208,
  176,
  153,
  217,
  173,
  144,
  234,
  168,
  127,
  251,
  163,
  111,
  255,
  151,
  84,
  255,
  137,
  62,
  255,
  106,
  32,
  255,
  68,
  15,
  225,
  225,
  225,
  210,
  203,
  195,
  194,
  181,
  165,
  197,
  180,
  160,
  204,
  179,
  149,
  211,
  177,
  139,
  224,
  175,
  119,
  236,
  172,
  102,
  255,
  165,
  72,
  255,
  158,
  48,
  255,
  140,
  17,
  255,
  121,
  1,
  225,
  225,
  225,
  208,
  204,
  195,
  191,
  183,
  164,
  193,
  183,
  158,
  199,
  182,
  147,
  204,
  181,
  136,
  214,
  180,
  116,
  223,
  179,
  97,
  240,
  177,
  67,
  255,
  173,
  43,
  255,
  164,
  11,
  255,
  153,
  0,
  225,
  225,
  225,
  213,
  210,
  200,
  200,
  195,
  175,
  190,
  184,
  158,
  194,
  185,
  146,
  198,
  185,
  135,
  205,
  185,
  115,
  212,
  185,
  96,
  225,
  185,
  65,
  237,
  183,
  41,
  255,
  179,
  9,
  255,
  175,
  0,
  225,
  225,
  225,
  211,
  211,
  208,
  196,
  196,
  191,
  197,
  196,
  191,
  209,
  205,
  174,
  234,
  224,
  149,
  240,
  225,
  125,
  249,
  229,
  103,
  255,
  227,
  65,
  255,
  218,
  35,
  255,
  206,
  0,
  255,
  208,
  0,
  225,
  225,
  225,
  211,
  211,
  208,
  196,
  196,
  191,
  197,
  197,
  190,
  197,
  196,
  171,
  211,
  210,
  169,
  212,
  210,
  133,
  225,
  221,
  104,
  231,
  227,
  67,
  240,
  234,
  36,
  255,
  250,
  0,
  244,
  255,
  0,
  225,
  225,
  225,
  205,
  206,
  195,
  184,
  186,
  165,
  184,
  187,
  159,
  184,
  189,
  148,
  185,
  191,
  137,
  202,
  213,
  129,
  201,
  215,
  108,
  195,
  219,
  71,
  183,
  210,
  43,
  176,
  220,
  9,
  164,
  230,
  0,
  225,
  225,
  225,
  204,
  206,
  196,
  182,
  187,
  166,
  181,
  188,
  160,
  180,
  191,
  150,
  178,
  194,
  140,
  175,
  199,
  122,
  172,
  204,
  105,
  165,
  213,
  75,
  159,
  221,
  49,
  142,
  237,
  14,
  123,
  250,
  0,
  225,
  225,
  225,
  202,
  207,
  196,
  179,
  188,
  167,
  178,
  190,
  163,
  175,
  193,
  154,
  171,
  196,
  145,
  165,
  203,
  128,
  159,
  209,
  113,
  147,
  221,
  85,
  134,
  232,
  61,
  108,
  252,
  25,
  81,
  255,
  3,
  225,
  225,
  225,
  201,
  207,
  197,
  177,
  189,
  169,
  175,
  191,
  165,
  170,
  195,
  158,
  165,
  198,
  151,
  156,
  206,
  136,
  147,
  213,
  123,
  129,
  227,
  100,
  110,
  240,
  80,
  75,
  255,
  48,
  42,
  255,
  24,
  225,
  225,
  225,
  200,
  207,
  199,
  175,
  189,
  172,
  172,
  192,
  169,
  166,
  196,
  163,
  159,
  200,
  157,
  148,
  208,
  146,
  136,
  216,
  136,
  113,
  231,
  118,
  91,
  245,
  102,
  52,
  255,
  74,
  18,
  255,
  53,
  225,
  225,
  225,
  199,
  208,
  201,
  172,
  190,
  176,
  167,
  192,
  176,
  159,
  197,
  174,
  151,
  201,
  173,
  135,
  210,
  170,
  119,
  219,
  167,
  90,
  234,
  162,
  63,
  249,
  158,
  17,
  255,
  147,
  0,
  255,
  137,
  225,
  225,
  225,
  198,
  208,
  203,
  170,
  190,
  180,
  165,
  193,
  180,
  156,
  197,
  181,
  147,
  201,
  182,
  130,
  210,
  184,
  113,
  218,
  186,
  81,
  234,
  189,
  52,
  248,
  191,
  2,
  255,
  192,
  0,
  255,
  191,
  225,
  225,
  225,
  197,
  208,
  205,
  168,
  190,
  185,
  164,
  192,
  185,
  154,
  197,
  189,
  144,
  201,
  193,
  126,
  209,
  200,
  108,
  217,
  207,
  74,
  232,
  219,
  43,
  246,
  228,
  0,
  255,
  245,
  0,
  255,
  255,
  225,
  225,
  225,
  197,
  207,
  209,
  168,
  189,
  192,
  163,
  190,
  198,
  154,
  193,
  207,
  144,
  196,
  216,
  125,
  203,
  235,
  105,
  209,
  252,
  67,
  222,
  255,
  30,
  235,
  255,
  0,
  255,
  255,
  0,
  255,
  255,
  225,
  225,
  225,
  197,
  206,
  212,
  169,
  187,
  198,
  165,
  188,
  204,
  156,
  190,
  215,
  147,
  193,
  226,
  128,
  198,
  249,
  109,
  203,
  255,
  69,
  214,
  255,
  29,
  226,
  255,
  0,
  248,
  255,
  0,
  255,
  255,
  225,
  225,
  225,
  199,
  205,
  213,
  172,
  185,
  201,
  168,
  186,
  208,
  160,
  188,
  220,
  151,
  190,
  233,
  134,
  193,
  255,
  115,
  197,
  255,
  77,
  204,
  255,
  35,
  213,
  255,
  0,
  230,
  255,
  0,
  245,
  255,
  225,
  225,
  225,
  200,
  204,
  214,
  175,
  183,
  202,
  171,
  184,
  209,
  164,
  185,
  223,
  157,
  186,
  237,
  142,
  187,
  255,
  126,
  189,
  255,
  90,
  193,
  255,
  51,
  198,
  255,
  0,
  205,
  255,
  0,
  210,
  255,
  225,
  225,
  225,
  201,
  204,
  214,
  177,
  182,
  203,
  174,
  182,
  210,
  169,
  182,
  224,
  163,
  182,
  239,
  150,
  182,
  255,
  137,
  183,
  255,
  108,
  182,
  255,
  74,
  182,
  255,
  0,
  181,
  255,
  0,
  177,
  255,
  225,
  225,
  225,
  202,
  203,
  214,
  179,
  181,
  202,
  177,
  181,
  209,
  173,
  180,
  224,
  168,
  180,
  239,
  159,
  178,
  255,
  149,
  176,
  255,
  127,
  172,
  255,
  102,
  168,
  255,
  39,
  158,
  255,
  0,
  146,
  255,
  225,
  225,
  225,
  203,
  203,
  214,
  180,
  181,
  202,
  179,
  180,
  209,
  177,
  178,
  223,
  174,
  177,
  238,
  168,
  174,
  255,
  161,
  171,
  255,
  147,
  164,
  255,
  131,
  155,
  255,
  90,
  136,
  255,
  32,
  116,
  255,
  225,
  225,
  225,
  204,
  203,
  213,
  182,
  180,
  201,
  182,
  179,
  208,
  181,
  177,
  221,
  180,
  174,
  235,
  178,
  170,
  255,
  174,
  165,
  255,
  167,
  155,
  255,
  161,
  143,
  255,
  141,
  117,
  255,
  109,
  89,
  255,
  225,
  225,
  225,
  205,
  202,
  213,
  184,
  179,
  200,
  184,
  178,
  206,
  185,
  175,
  219,
  186,
  172,
  232,
  187,
  166,
  255,
  188,
  160,
  255,
  190,
  147,
  255,
  193,
  132,
  255,
  194,
  100,
  255,
  188,
  65,
  255,
  225,
  225,
  225,
  206,
  202,
  212,
  186,
  178,
  199,
  187,
  177,
  204,
  190,
  173,
  215,
  192,
  170,
  227,
  197,
  163,
  250,
  203,
  155,
  255,
  213,
  139,
  255,
  225,
  122,
  255,
  246,
  85,
  255,
  255,
  44,
  255,
  225,
  225,
  225,
  207,
  202,
  211,
  188,
  178,
  197,
  190,
  176,
  201,
  195,
  172,
  211,
  199,
  168,
  220,
  208,
  159,
  239,
  218,
  150,
  255,
  238,
  132,
  255,
  255,
  112,
  255,
  255,
  70,
  255,
  255,
  23,
  255,
  225,
  225,
  225,
  208,
  201,
  210,
  191,
  177,
  194,
  193,
  175,
  198,
  200,
  170,
  205,
  207,
  165,
  211,
  220,
  156,
  225,
  234,
  146,
  238,
  255,
  125,
  255,
  255,
  104,
  255,
  255,
  57,
  255,
  255,
  5,
  255,
  255,
  255,
  255,
  225,
  213,
  224,
  230,
  211,
  227,
  234,
  208,
  229,
  243,
  203,
  233,
  253,
  197,
  237,
  255,
  185,
  244,
  255,
  174,
  252,
  255,
  149,
  255,
  255,
  123,
  255,
  255,
  67,
  255,
  255,
  4,
  255,
  255,
  255,
  255,
  227,
  213,
  220,
  233,
  210,
  220,
  239,
  208,
  219,
  250,
  202,
  218,
  255,
  196,
  217,
  255,
  185,
  217,
  255,
  173,
  217,
  255,
  148,
  220,
  255,
  121,
  228,
  255,
  63,
  245,
  255,
  0,
  255,
  255,
  255,
  255,
  229,
  213,
  215,
  235,
  211,
  211,
  241,
  209,
  207,
  253,
  204,
  202,
  255,
  199,
  198,
  255,
  188,
  190,
  255,
  177,
  183,
  255,
  153,
  171,
  255,
  127,
  164,
  255,
  71,
  152,
  255,
  7,
  145,
  255,
  255,
  255,
  229,
  214,
  210,
  235,
  212,
  205,
  240,
  211,
  200,
  251,
  207,
  192,
  255,
  202,
  184,
  255,
  194,
  169,
  255,
  185,
  156,
  255,
  166,
  131,
  255,
  144,
  112,
  255,
  96,
  82,
  255,
  41,
  62,
  255,
  255,
  255,
  228,
  216,
  206,
  233,
  214,
  200,
  238,
  213,
  195,
  247,
  210,
  184,
  255,
  207,
  174,
  255,
  201,
  155,
  255,
  195,
  137,
  255,
  182,
  105,
  255,
  168,
  80,
  255,
  133,
  43,
  255,
  91,
  22,
  255,
  255,
  255,
  226,
  217,
  204,
  230,
  216,
  198,
  234,
  215,
  192,
  242,
  213,
  180,
  250,
  212,
  168,
  255,
  209,
  146,
  255,
  206,
  126,
  255,
  199,
  91,
  255,
  190,
  64,
  255,
  171,
  25,
  255,
  149,
  4,
  255,
  255,
  255,
  225,
  218,
  204,
  228,
  217,
  197,
  231,
  217,
  190,
  238,
  216,
  178,
  243,
  216,
  165,
  254,
  215,
  142,
  255,
  214,
  121,
  255,
  211,
  85,
  255,
  207,
  57,
  255,
  198,
  18,
  255,
  186,
  0,
  255,
  255,
  255,
  223,
  219,
  203,
  226,
  219,
  196,
  228,
  219,
  190,
  233,
  219,
  177,
  237,
  219,
  164,
  245,
  220,
  141,
  252,
  220,
  119,
  255,
  220,
  83,
  255,
  219,
  54,
  255,
  215,
  15,
  255,
  208,
  0,
  255,
  255,
  255,
  222,
  219,
  203,
  249,
  246,
  227,
  255,
  250,
  223,
  255,
  246,
  187,
  255,
  244,
  172,
  255,
  240,
  145,
  255,
  236,
  121,
  255,
  229,
  79,
  255,
  227,
  45,
  255,
  227,
  0,
  255,
  229,
  0,
  255,
  255,
  255,
  220,
  220,
  203,
  255,
  254,
  223,
  255,
  252,
  207,
  246,
  243,
  186,
  247,
  243,
  172,
  248,
  245,
  147,
  255,
  251,
  122,
  255,
  250,
  80,
  255,
  248,
  46,
  255,
  251,
  0,
  251,
  255,
  0,
  255,
  255,
  255,
  219,
  221,
  204,
  219,
  222,
  197,
  220,
  223,
  191,
  220,
  225,
  178,
  221,
  227,
  166,
  230,
  240,
  149,
  227,
  244,
  127,
  225,
  250,
  86,
  218,
  250,
  58,
  212,
  255,
  17,
  200,
  255,
  0,
  255,
  255,
  255,
  217,
  221,
  205,
  216,
  223,
  199,
  216,
  224,
  193,
  215,
  227,
  181,
  213,
  230,
  170,
  210,
  236,
  149,
  206,
  242,
  129,
  198,
  252,
  95,
  191,
  255,
  65,
  173,
  255,
  23,
  152,
  255,
  0,
  255,
  255,
  255,
  215,
  222,
  206,
  214,
  224,
  201,
  212,
  226,
  195,
  209,
  229,
  185,
  205,
  233,
  175,
  199,
  240,
  156,
  192,
  247,
  138,
  177,
  255,
  106,
  163,
  255,
  79,
  134,
  255,
  36,
  104,
  255,
  8,
  255,
  255,
  255,
  214,
  223,
  208,
  211,
  225,
  203,
  209,
  227,
  198,
  204,
  231,
  190,
  198,
  236,
  182,
  188,
  244,
  165,
  178,
  252,
  150,
  157,
  255,
  123,
  136,
  255,
  100,
  96,
  255,
  62,
  59,
  255,
  34,
  255,
  255,
  255,
  212,
  223,
  210,
  209,
  225,
  206,
  206,
  228,
  202,
  199,
  233,
  195,
  192,
  237,
  189,
  179,
  246,
  176,
  166,
  255,
  165,
  140,
  255,
  143,
  115,
  255,
  126,
  70,
  255,
  94,
  30,
  255,
  68,
  255,
  255,
  255,
  210,
  224,
  212,
  206,
  226,
  210,
  201,
  229,
  209,
  191,
  234,
  207,
  182,
  239,
  206,
  164,
  249,
  202,
  146,
  255,
  200,
  113,
  255,
  194,
  82,
  255,
  190,
  28,
  255,
  178,
  0,
  255,
  166,
  255,
  255,
  255,
  208,
  224,
  215,
  204,
  226,
  215,
  199,
  229,
  214,
  188,
  234,
  215,
  178,
  239,
  217,
  158,
  249,
  218,
  139,
  255,
  221,
  103,
  255,
  225,
  69,
  255,
  228,
  11,
  255,
  231,
  0,
  255,
  229,
  255,
  255,
  255,
  207,
  224,
  219,
  202,
  226,
  221,
  197,
  229,
  220,
  186,
  234,
  224,
  175,
  238,
  229,
  154,
  247,
  237,
  133,
  255,
  245,
  95,
  255,
  255,
  59,
  255,
  255,
  0,
  255,
  255,
  0,
  255,
  255,
  255,
  255,
  255,
  207,
  223,
  225,
  201,
  225,
  230,
  196,
  226,
  236,
  185,
  230,
  245,
  174,
  233,
  255,
  153,
  240,
  255,
  131,
  247,
  255,
  88,
  255,
  255,
  45,
  255,
  255,
  0,
  255,
  255,
  0,
  255,
  255,
  255,
  255,
  255,
  208,
  221,
  229,
  203,
  222,
  236,
  198,
  224,
  242,
  188,
  227,
  254,
  178,
  229,
  255,
  157,
  235,
  255,
  135,
  241,
  255,
  91,
  252,
  255,
  45,
  255,
  255,
  0,
  255,
  255,
  0,
  255,
  255,
  255,
  255,
  255,
  210,
  220,
  232,
  206,
  220,
  239,
  202,
  221,
  246,
  193,
  223,
  255,
  183,
  225,
  255,
  163,
  229,
  255,
  143,
  233,
  255,
  100,
  242,
  255,
  54,
  251,
  255,
  0,
  255,
  255,
  0,
  255,
  255,
  255,
  255,
  255,
  212,
  218,
  232,
  209,
  218,
  240,
  206,
  219,
  248,
  198,
  220,
  255,
  190,
  221,
  255,
  173,
  223,
  255,
  155,
  225,
  255,
  116,
  229,
  255,
  73,
  234,
  255,
  0,
  242,
  255,
  0,
  248,
  255,
  255,
  255,
  255,
  214,
  218,
  232,
  212,
  217,
  240,
  209,
  217,
  248,
  203,
  217,
  255,
  196,
  217,
  255,
  183,
  217,
  255,
  168,
  217,
  255,
  136,
  217,
  255,
  99,
  217,
  255,
  13,
  216,
  255,
  0,
  212,
  255,
  255,
  255,
  255,
  215,
  217,
  232,
  214,
  216,
  240,
  211,
  216,
  248,
  207,
  215,
  255,
  202,
  214,
  255,
  192,
  212,
  255,
  181,
  210,
  255,
  157,
  206,
  255,
  129,
  201,
  255,
  61,
  190,
  255,
  0,
  177,
  255,
  255,
  255,
  255,
  217,
  216,
  232,
  216,
  215,
  239,
  214,
  215,
  247,
  212,
  213,
  255,
  209,
  211,
  255,
  202,
  208,
  255,
  195,
  204,
  255,
  178,
  196,
  255,
  161,
  187,
  255,
  117,
  166,
  255,
  57,
  143,
  255,
  255,
  255,
  255,
  218,
  216,
  231,
  218,
  215,
  238,
  217,
  213,
  246,
  216,
  211,
  255,
  215,
  208,
  255,
  213,
  203,
  255,
  209,
  198,
  255,
  201,
  187,
  255,
  195,
  174,
  255,
  174,
  145,
  255,
  141,
  114,
  255,
  255,
  255,
  255,
  219,
  215,
  231,
  219,
  214,
  237,
  220,
  212,
  244,
  221,
  209,
  255,
  222,
  206,
  255,
  223,
  199,
  255,
  224,
  192,
  255,
  226,
  178,
  255,
  230,
  161,
  255,
  232,
  126,
  255,
  227,
  87,
  255,
  255,
  255,
  255,
  220,
  215,
  230,
  222,
  213,
  236,
  223,
  211,
  242,
  226,
  207,
  254,
  229,
  203,
  255,
  234,
  195,
  255,
  115,
  98,
  141,
  251,
  169,
  255,
  255,
  150,
  255,
  255,
  109,
  255,
  255,
  63,
  255,
  255,
  255,
  255,
  222,
  214,
  228,
  224,
  212,
  234,
  226,
  210,
  239,
  231,
  206,
  249,
  236,
  201,
  255,
  246,
  191,
  255,
  255,
  182,
  255,
  255,
  161,
  255,
  255,
  139,
  255,
  255,
  92,
  255,
  255,
  41,
  255,
  255,
  255,
  255,
  223,
  214,
  227,
  227,
  211,
  231,
  230,
  209,
  235,
  237,
  204,
  243,
  244,
  199,
  250,
  255,
  188,
  255,
  255,
  177,
  255,
  255,
  154,
  255,
  255,
  130,
  255,
  255,
  78,
  255,
  255,
  20,
  255,
  255,
  255,
  255,
  255,
  250,
  255,
  255,
  247,
  255,
  255,
  244,
  255,
  255,
  238,
  255,
  255,
  232,
  255,
  255,
  219,
  255,
  255,
  206,
  255,
  255,
  179,
  255,
  255,
  150,
  255,
  255,
  89,
  255,
  255,
  21,
  255,
  255,
  255,
  255,
  255,
  249,
  255,
  255,
  246,
  255,
  255,
  243,
  255,
  255,
  237,
  255,
  255,
  231,
  254,
  255,
  218,
  253,
  255,
  205,
  253,
  255,
  177,
  255,
  255,
  148,
  255,
  255,
  84,
  255,
  255,
  13,
  255,
  255,
  255,
  255,
  255,
  249,
  252,
  255,
  247,
  248,
  255,
  245,
  243,
  255,
  239,
  237,
  255,
  234,
  232,
  255,
  222,
  223,
  255,
  209,
  215,
  255,
  184,
  200,
  255,
  155,
  192,
  255,
  93,
  179,
  255,
  24,
  170,
  255,
  255,
  255,
  255,
  250,
  247,
  255,
  249,
  240,
  255,
  247,
  235,
  255,
  242,
  225,
  255,
  238,
  216,
  255,
  228,
  200,
  255,
  218,
  185,
  255,
  198,
  156,
  255,
  174,
  134,
  255,
  122,
  100,
  255,
  62,
  76,
  255,
  255,
  255,
  255,
  252,
  242,
  255,
  251,
  235,
  255,
  249,
  229,
  255,
  246,
  217,
  255,
  243,
  206,
  255,
  236,
  184,
  255,
  230,
  164,
  255,
  216,
  127,
  255,
  200,
  98,
  255,
  163,
  56,
  255,
  117,
  30,
  255,
  255,
  255,
  255,
  254,
  240,
  255,
  253,
  232,
  255,
  252,
  225,
  255,
  250,
  212,
  255,
  248,
  199,
  255,
  245,
  174,
  255,
  241,
  152,
  255,
  234,
  112,
  255,
  225,
  80,
  255,
  204,
  34,
  255,
  180,
  8,
  255,
  255,
  255,
  255,
  255,
  239,
  255,
  254,
  231,
  255,
  254,
  224,
  255,
  253,
  210,
  255,
  253,
  196,
  255,
  252,
  170,
  255,
  251,
  146,
  255,
  248,
  105,
  255,
  243,
  72,
  255,
  233,
  26,
  255,
  221,
  1,
  255,
  255,
  255,
  255,
  255,
  238,
  255,
  255,
  231,
  255,
  255,
  223,
  255,
  255,
  209,
  255,
  255,
  195,
  255,
  255,
  168,
  255,
  255,
  144,
  255,
  255,
  103,
  255,
  255,
  70,
  255,
  253,
  23,
  255,
  247,
  0,
  255,
  255,
  255,
  255,
  255,
  238,
  255,
  255,
  249,
  255,
  255,
  246,
  255,
  255,
  208,
  255,
  255,
  190,
  255,
  255,
  162,
  255,
  255,
  135,
  255,
  255,
  90,
  255,
  255,
  54,
  255,
  255,
  3,
  255,
  255,
  0,
  255,
  255,
  255,
  255,
  255,
  239,
  255,
  255,
  250,
  255,
  255,
  242,
  255,
  255,
  205,
  255,
  255,
  190,
  255,
  255,
  163,
  255,
  255,
  137,
  255,
  255,
  92,
  255,
  255,
  55,
  255,
  255,
  3,
  255,
  255,
  0,
  255,
  255,
  255,
  255,
  255,
  239,
  255,
  255,
  232,
  255,
  255,
  225,
  255,
  255,
  211,
  255,
  255,
  197,
  255,
  255,
  167,
  255,
  255,
  143,
  255,
  255,
  97,
  255,
  255,
  74,
  248,
  255,
  25,
  237,
  255,
  0,
  255,
  255,
  255,
  253,
  255,
  241,
  253,
  255,
  234,
  252,
  255,
  227,
  251,
  255,
  214,
  249,
  255,
  201,
  246,
  255,
  177,
  242,
  255,
  156,
  233,
  255,
  117,
  225,
  255,
  83,
  206,
  255,
  33,
  183,
  255,
  2,
  255,
  255,
  255,
  251,
  255,
  242,
  250,
  255,
  236,
  248,
  255,
  230,
  244,
  255,
  218,
  241,
  255,
  207,
  233,
  255,
  186,
  225,
  255,
  166,
  210,
  255,
  130,
  194,
  255,
  99,
  162,
  255,
  49,
  129,
  255,
  15,
  255,
  255,
  255,
  250,
  255,
  243,
  247,
  255,
  238,
  244,
  255,
  233,
  239,
  255,
  223,
  233,
  255,
  214,
  221,
  255,
  196,
  210,
  255,
  179,
  188,
  255,
  148,
  164,
  255,
  122,
  120,
  255,
  79,
  78,
  255,
  46,
  255,
  255,
  255,
  248,
  255,
  246,
  244,
  255,
  241,
  241,
  255,
  237,
  234,
  255,
  229,
  226,
  255,
  222,
  211,
  255,
  208,
  197,
  255,
  195,
  169,
  255,
  171,
  140,
  255,
  151,
  90,
  255,
  114,
  45,
  255,
  84,
  255,
  255,
  255,
  246,
  255,
  249,
  241,
  255,
  246,
  236,
  255,
  245,
  226,
  255,
  242,
  215,
  255,
  241,
  195,
  255,
  237,
  176,
  255,
  234,
  138,
  255,
  227,
  103,
  255,
  222,
  42,
  255,
  210,
  0,
  255,
  198,
  255,
  255,
  255,
  244,
  255,
  252,
  239,
  255,
  251,
  233,
  255,
  250,
  222,
  255,
  251,
  211,
  255,
  252,
  189,
  255,
  254,
  167,
  255,
  255,
  127,
  255,
  255,
  89,
  255,
  255,
  22,
  255,
  255,
  0,
  255,
  255,
  255,
  255,
  255,
  243,
  255,
  255,
  237,
  255,
  255,
  231,
  255,
  255,
  219,
  255,
  255,
  207,
  255,
  255,
  184,
  255,
  255,
  161,
  255,
  255,
  117,
  255,
  255,
  77,
  255,
  255,
  4,
  255,
  255,
  0,
  255,
  255,
  255,
  255,
  255,
  242,
  255,
  255,
  236,
  255,
  255,
  230,
  255,
  255,
  218,
  255,
  255,
  206,
  255,
  255,
  182,
  255,
  255,
  158,
  255,
  255,
  110,
  255,
  255,
  63,
  255,
  255,
  0,
  255,
  255,
  0,
  255,
  255,
  255,
  255,
  255,
  244,
  255,
  255,
  238,
  255,
  255,
  233,
  255,
  255,
  222,
  255,
  255,
  210,
  255,
  255,
  187,
  255,
  255,
  163,
  255,
  255,
  115,
  255,
  255,
  64,
  255,
  255,
  0,
  255,
  255,
  0,
  255,
  255,
  255,
  255,
  255,
  246,
  255,
  255,
  242,
  255,
  255,
  237,
  255,
  255,
  227,
  255,
  255,
  216,
  255,
  255,
  194,
  255,
  255,
  172,
  255,
  255,
  125,
  255,
  255,
  75,
  255,
  255,
  0,
  255,
  255,
  0,
  255,
  255,
  255,
  255,
  255,
  248,
  255,
  255,
  245,
  255,
  255,
  241,
  255,
  255,
  233,
  255,
  255,
  223,
  255,
  255,
  205,
  255,
  255,
  185,
  255,
  255,
  143,
  255,
  255,
  95,
  255,
  255,
  0,
  255,
  255,
  0,
  255,
  255,
  255,
  255,
  255,
  250,
  255,
  255,
  247,
  254,
  255,
  244,
  254,
  255,
  238,
  254,
  255,
  230,
  254,
  255,
  216,
  254,
  255,
  199,
  254,
  255,
  164,
  254,
  255,
  124,
  254,
  255,
  31,
  253,
  255,
  0,
  249,
  255,
  255,
  255,
  255,
  252,
  254,
  255,
  250,
  253,
  255,
  247,
  253,
  255,
  243,
  252,
  255,
  237,
  251,
  255,
  226,
  249,
  255,
  214,
  247,
  255,
  187,
  242,
  255,
  157,
  237,
  255,
  84,
  225,
  255,
  0,
  210,
  255,
  255,
  255,
  255,
  253,
  253,
  255,
  252,
  252,
  255,
  250,
  251,
  255,
  247,
  249,
  255,
  244,
  247,
  255,
  237,
  244,
  255,
  229,
  240,
  255,
  211,
  231,
  255,
  192,
  221,
  255,
  145,
  198,
  255,
  81,
  174,
  255,
  255,
  255,
  255,
  254,
  253,
  255,
  254,
  251,
  255,
  253,
  250,
  255,
  252,
  247,
  255,
  251,
  244,
  255,
  248,
  239,
  255,
  245,
  233,
  255,
  236,
  221,
  255,
  229,
  207,
  255,
  208,
  175,
  255,
  173,
  141,
  255,
  255,
  255,
  255,
  255,
  252,
  255,
  255,
  250,
  255,
  255,
  249,
  255,
  255,
  245,
  255,
  255,
  242,
  255,
  255,
  234,
  255,
  255,
  227,
  255,
  255,
  211,
  255,
  255,
  193,
  255,
  255,
  154,
  255,
  255,
  112,
  255,
  255,
  255,
  255,
  255,
  252,
  255,
  255,
  250,
  255,
  255,
  247,
  255,
  255,
  243,
  255,
  255,
  239,
  255,
  255,
  230,
  255,
  255,
  221,
  255,
  255,
  202,
  255,
  255,
  180,
  255,
  255,
  135,
  255,
  255,
  86,
  255,
  255,
  255,
  255,
  255,
  251,
  255,
  255,
  249,
  255,
  255,
  246,
  255,
  255,
  241,
  255,
  255,
  236,
  255,
  255,
  226,
  255,
  255,
  215,
  255,
  255,
  192,
  255,
  255,
  168,
  255,
  255,
  117,
  255,
  255,
  61,
  255,
  255,
  255,
  255,
  255,
  250,
  255,
  255,
  248,
  255,
  255,
  245,
  255,
  255,
  239,
  255,
  255,
  234,
  255,
  255,
  222,
  255,
  255,
  210,
  255,
  255,
  184,
  255,
  255,
  158,
  255,
  255,
  100,
  255,
  255,
  38,
  255
};

#endif
