/*
 * italc_rfb_ext.h - this is an extension of the RFB-protocol, used for communicating with clients
 *
 * iTALC
 * Copyright (c) 2004-2005 Tobias Doerffel <tobias@doerffel.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

#ifndef _ITALC_RFB_EXT_H
#define _ITALC_RFB_EXT_H

/* need that for Q_UINT8 and so on*/
/*#include <qglobal.h>*/
typedef signed char             Q_INT8;         /* 8 bit signed */
typedef unsigned char           Q_UINT8;        /* 8 bit unsigned */
typedef short                   Q_INT16;        /* 16 bit signed */
typedef unsigned short          Q_UINT16;       /* 16 bit unsigned */
typedef int                     Q_INT32;        /* 32 bit signed */
typedef unsigned int            Q_UINT32;       /* 32 bit unsigned */



/* ===========================================================================================
 * new stuff for communication in both directions
 * =========================================================================================== */

/* new rfb-command which tells server or client that an italc-request/response is following */
#define RFB_ITALC_TO_SERVER_REQUEST 	10
#define RFB_SERVER_TO_ITALC_RESPONSE	RFB_ITALC_TO_SERVER_REQUEST


/* italc-commands */
#define REQUEST_BASE		0
#define RESPONSE_BASE		64

#define ITALC_GET_USER		(REQUEST_BASE+0)
#define ITALC_EXEC_CMDS		(REQUEST_BASE+1)
#define ITALC_START_DEMO	(REQUEST_BASE+2)
#define ITALC_STOP_DEMO		(REQUEST_BASE+3)
#define ITALC_LOCK_DISPLAY	(REQUEST_BASE+4)
#define ITALC_UNLOCK_DISPLAY	(REQUEST_BASE+5)
#define ITALC_SEND_MSG		(REQUEST_BASE+6)
#define ITALC_POST_FILE_REQ	(REQUEST_BASE+8)
#define ITALC_GET_FILE		(REQUEST_BASE+9)
#define ITALC_INVITE_SUPPORT	(REQUEST_BASE+10)

#define ITALC_POST_USER		(RESPONSE_BASE+0)
#define ITALC_POST_FILE_RESP	(RESPONSE_BASE+1)
#define ITALC_INVITATION_RESULT	(RESPONSE_BASE+2)



/* ===========================================================================================
 * new stuff for communication  italc-app -> italc-vnc-server (IVS)
 * =========================================================================================== */



typedef struct {
	Q_UINT8 cmd;			/* always RFB_ITALC_TO_SERVER_REQUEST */
	Q_UINT8 italc_cmd;		/* always ITALC_GET_USER */
} s_rfb_get_user_msg;



typedef struct {
	Q_UINT8 cmd;			/* always RFB_ITALC_TO_SERVER_REQUEST */
	Q_UINT8 italc_cmd;		/* always ITALC_EXEC_CMDS */
	Q_UINT16 cmd_len;
	/* followed by command-string with length cmd_len */
} s_rfb_exec_cmds_msg;



typedef struct {
	Q_UINT8 cmd;			/* always RFB_ITALC_TO_SERVER_REQUEST */
	Q_UINT8 italc_cmd;		/* always ITALC_STOP_DEMO */
	Q_UINT8 fullscreen;
	Q_UINT16 demo_master_ip_len;
	/* followed by string with IP and display of demo-master with length demo_master_ip_len */
} s_rfb_start_demo_msg;



typedef struct {
	Q_UINT8 cmd;			/* always RFB_ITALC_TO_SERVER_REQUEST */
	Q_UINT8 italc_cmd;		/* always ITALC_STOP_DEMO */
} s_rfb_stop_demo_msg;



typedef struct {
	Q_UINT8 cmd;			/* always RFB_ITALC_TO_SERVER_REQUEST */
	Q_UINT8 italc_cmd;		/* always ITALC_LOCK_DISPLAY */
} s_rfb_lock_display_msg;



typedef struct {
	Q_UINT8 cmd;			/* always RFB_ITALC_TO_SERVER_REQUEST */
	Q_UINT8 italc_cmd;		/* always ITALC_UNLOCK_DISPLAY */
} s_rfb_unlock_display_msg;



typedef struct {
	Q_UINT8 cmd;			/* always RFB_ITALC_TO_SERVER_REQUEST */
	Q_UINT8 italc_cmd;		/* always ITALC_SEND_MSG */
	Q_UINT16 msg_len;
	/* followed by message with length msg_len */
} s_rfb_send_msg_msg;



typedef struct {
	Q_UINT8 cmd;			/* always RFB_ITALC_TO_SERVER_REQUEST */
	Q_UINT8 italc_cmd;		/* always ITALC_POST_FILE */
	Q_UINT16 fname_len;		/* length of file-name */
	Q_UINT32 fsize;			/* file-size */
	/* followed by file-name with length fname_len */
	/* followed by fsize bytes of binary data */
} s_rfb_post_file_msg;



typedef struct {
	Q_UINT8 cmd;			/* always RFB_ITALC_TO_SERVER_REQUEST */
	Q_UINT8 italc_cmd;		/* always ITALC_GET_FILE */
	Q_UINT16 fmask_len;		/* length of file-mask */
	/* followed by file-mask with length fname_len */
} s_rfb_get_file_msg;




typedef struct {
	Q_UINT8 cmd;			/* always RFB_ITALC_TO_SERVER_REQUEST */
	Q_UINT8 italc_cmd;		/* always ITALC_INVITE_SUPPORT */
	Q_UINT16 uname_len;		/* length of user-name */
	/* followed by user-name with length uname_len */
} s_rfb_invite_support_msg;



typedef union {
	Q_UINT8 cmd;			/* alway RFB_ITALC_TO_SERVER_REQUEST */
	Q_UINT8 italc_cmd;
	s_rfb_get_user_msg get_user;
	s_rfb_exec_cmds_msg exec_cmds;
	s_rfb_start_demo_msg start_demo;
	s_rfb_lock_display_msg lock_display;
	s_rfb_lock_display_msg unlock_display;
	s_rfb_send_msg_msg send_msg;
	s_rfb_post_file_msg post_file_msg;
	s_rfb_get_file_msg get_file_msg;
	s_rfb_invite_support_msg invite_support_msg;
} s_rfb_italc_request;





/* ===========================================================================================
 * new stuff for communication  italc-vnc-server (IVS) -> italc-app
 * =========================================================================================== */


typedef struct {
	Q_UINT8 cmd;		/* always RFB_SERVER_TO_ITALC_RESPONSE */
	Q_UINT8 italc_cmd;	/* always ITALC_POST_USER */
	Q_UINT16 user_name_len;
	/* followed by user-name with length cmd_len */
} s_rfb_post_user_msg;



typedef struct {
	Q_UINT8 cmd;		/* always RFB_SERVER_TO_ITALC_RESPONSE */
	Q_UINT8 italc_cmd;	/* always ITALC_INVITATION_RESULT */
	Q_UINT8 inv_accepted;
} s_rfb_invitation_result_msg;



typedef union {
	Q_UINT8 cmd;
	Q_UINT8 italc_cmd;
	s_rfb_post_user_msg post_user_msg;
	s_rfb_post_file_msg post_file_msg;
	s_rfb_invitation_result_msg invitation_result_msg;
} s_rfb_server_response;




/* ===========================================================================================
 * misc stuff
 * =========================================================================================== */

#define RFB_VNC_CHALL_RESP_AUTHENTICATION 3

typedef struct
{
	Q_UINT16 user_name_len;
	/* followed by user-name */
} s_rfb_authentication;



#define DEMO_PORT 	"5919"
#define SUPPORT_PORT	"5920"


#endif
