/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
    Author:
    Micha (Dwiedziu) Niedwiecki
    nkg@poczta.onet.pl
    http://www.kadu.net/~dzwiedziu/ext_info.php

    TODO: 2.0
            - Stworzy osobny tab na informacje o programie, a przycisk "Informacje" wyrzuci
            - Porobi jakie wskazwki dla uytkownika

    ChangeLog:

	[v2.0 beta 9]
	    * Dostosowanie do zmian w Kadu 0.5.0 SVN 2006-10-29

	[v2.0 beta 8]
	    * atka joy'a

	[v2.0 beta 7]
	    * Dostosowanie do zmian w Kadu 0.5.0 SVN 2005-12-19

        [v2.0 beta 6]
            * Dostosowanie do zmian w Kadu 0.5.0 SVN 2005-10-05

        [v2.0 beta 5]
            + Po klikniciu na nr GG w oknie informacji otwiera si okno rozmowy z nim
            + Po klikniciu na adres e-mail otwiera si ustawiony program pocztowy
            * Dostosowanie do zmian w Kadu 0.5.0 SVN 2005-09-30

        [v2.0 beta 4]
            * Kilka drobnych poprawek
            * Dostosowanie do zmian w Kadu 0.5.0 SVN 2005-09-27

        [v2.0 beta 3]
            * Poprawki w podgldzie zdjcia i oknie edycji avataru.
            * Przeniesienie kontrolki woboru sekcji poza zakadki
            * Uspranienie funkcji prztwarzajcej szablon prezentacji
            * Poprawienie domylnego szablonu prezentacji, informacja o rzeczach
              ktre nie zostay wpisane nie jest w ogle wywietlana.

        [v2.0 beta 2]
            * Kolejne podki w kodzie
            * Usprawnienie podgldu zdjcia
            + Okno podgldu zdjcia oraz okno edycji avatara przyjmuj Drag and
              Drop w formacie text/uri odnoszce si do lokalnego pliku.
            + Po klikniciu na link do strony, otwiera si ona w przegldarce
              ustawionej w opcjach Kadu

        [v2.0 beta 1]
            + Dodana zakadka z wypisanymi wszystkimi danymi o kontakcie, wraz
              z wywietleniem zdjcia.
            + Dodany modu tworzenia avatarw (zakadka "Zdjcie"->przycisk
              "Avatar"). Avatary zapisywane s w katalogu $HOME/.kadu/ext_info
            * Due zmiany w kodzie, reorganizacja caej klasy gwnej
            + Powrt do zgodnoci z Kadu 0.4.x
            + Powiadamianie o nowych wersjach
            * Przeniesienie ustawie moduu do katalogu $HOME/.kadu/ext_info

        [v1.5.1 ]
            * Podczas gdy w oknie konfiguracji zostay zaakceptowane zmiany,
              pojawiao si kilka ikon ext_info w oknie rozmowy. Bd ten zosta
              wanie naprawiony.

        [v1.5 ]
            + Dodana ikona ext_info w oknie rozmowy
            - Zerwanie kompatybilnoci z Kadu 0.4.x

        [v1.4.2 ]
            * Dostosowano do zmian w Kadu 0.5.0-svn, jednoczenie zachowano
              zgodno z Kadu 0.4.x

        [v1.4.1 ]
            * Dostosowano do zmian w Kadu 0.5.0, jednoczenie zachowano zgodno
              z Kadu 0.4.x

        [v1.4 ]
            + Jeli w oknie rozszerzonych informacji zostan dokonane zmiany
              i jeli uytkownik kliknie na "Anuluj" lub sprbuje zamkn okno
              klikajc na "X" zostanie zapytany, czy zachowa zmiany.zmodyfikowane
            * Spolszczone nazwy zakadek

        [v1.3.1 ]
            * Poprawiony bd w tumaczeniu (dziki tomee)
            * Poprawiono bd, ktry wystpowa gdy skasowano plik ze zdjciem
            * Jeli osoba ma jutro imieniny (odpowiednio urodziny) to
              wywietlana jest informacja, e "... ma jutro imieniny", a nie
              "... ma imieniny za 1 dni"

        [v1.3 ]
            * Dostosowano do zmian w aktualnej wersji Kadu CVS

        [v1.2 ]
            * Zmieniono nazw na ExtInfo (ext_info)
            * Naniesiono kilka drobnych poprawek

        [v1.1 ]
            + Ikona w menu i w oknie konfiguracji
            + Import i eksport danych do pliku

        [v1.0 ]
            * Nikt nie zgasza adnych problemw wic wydaj finaln wersj :)

        [v1.0 rc1]
            * Naprawiony bd przy skalowaniu zdjcia
            * Przed zaadowaniem obrazka sprawdza czy plik istnieje, eby nie
              dawa komunikatu o bdzie na konsole

        [v1.0 beta2]
            * Naprawiony powany bd przy dodawaniu i usuwaniu kontaktw
              (dziki Smoczyca)

        [v1.0 beta1]
            * Pierwsza publiczna wersja :)
*/

#include "ext_general.h"
#include <qhttp.h>

KaduExtInfo *extinfo;

extern "C" int ext_info_init()
{
    extinfo = new KaduExtInfo(MigrateFromOldVersion());
    return 0;
}

extern "C" void ext_info_close()
{
    delete extinfo;
}

ExtInfo::ExtInfo(const QString &datafile)
    :frmextinfo(NULL), http(NULL),extlist(datafile)
{
}

ExtInfo::~ExtInfo()
{
    if (http)
        delete http;
}

void ExtInfo::showExtInfo()
{
    kdebugf();
    if (getSelectedUser(currentUser))
        showExtInfo(currentUser);
    kdebugf2();
}

void ExtInfo::showExtInfo(const QString& section)
{
    kdebugf();
    if (frmextinfo == NULL)
    {
        frmextinfo = new frmExtInfo();
        connect(frmextinfo,SIGNAL(acceptChanges( const ExtList&)),this,SLOT(acceptChanges( const ExtList&)));
        connect(frmextinfo,SIGNAL(closeWindow()),this,SLOT(closeWindow()));
    }
    frmextinfo->show(extlist,section);
    kdebugf2();
}

void ExtInfo::closeWindow()
{
    kdebugf();
    if (frmextinfo)
    {
        disconnect(frmextinfo,SIGNAL(closeWindow()),this,SLOT(closeWindow()));
        disconnect(frmextinfo,SIGNAL(acceptChanges( const ExtList&)),this,SLOT(acceptChanges( const ExtList&)));
        delete frmextinfo;
        frmextinfo = NULL;
    }
    kdebugf2();
}

void ExtInfo::acceptChanges( const ExtList & data )
{
    kdebugf();
    extlist = data;
    extlist.saveToFile();
    kdebugf2();
}

QString ExtInfo::formatNameDayInfo(const QString& name, int days)
{
    QString str;
    if (days > 1)
    {
        str = name + tr(" has name-day in ") + QString::number(days) + tr(" days");
    }
    else if (days == 1)
    {
        str = name + tr(" has name-day tomorrow");
    }
    else
    {
        str = name + tr(" has name-day");
    }
    return str;
}

QString ExtInfo::formatBirthdayInfo(const QString& name, int days)
{
    QString str;
    if (days > 1)
    {
        str = name + tr(" has birthday in ") + QString::number(days) + tr(" days");
    }
    else if (days == 1)
    {
        str = name + tr(" has birthday tomorrow");
    }
    else
    {
        str = name + tr(" has birthday");
    }
    return str;
}

void ExtInfo::restartTimer()
{
    timer.start(remindFrequency * 60000);
}

void ExtInfo::onExport()
{
    kdebugf();
    if (frmextinfo)
    {
        frmextinfo->setFocus();
        MessageBox::wrn(tr("First you must close ext_info window"));
        kdebugf2();
        return;
    }
    for(;;)
    {
        QString filename = QFileDialog::getSaveFileName(extinfoPath("RExInfo.dat"),
            tr("RExInfo/ext_info 1.x files") + QString(" (RExInfo.dat; rexinfo.dat);;") +
            tr("All files") + QString(" (*)"));
        if (filename.length())
        {
            if (QFile::exists(filename))
            {
                if (!MessageBox::ask(tr("This file are exists. Overwrite this file?")))
                    continue;
            }
            if (!extlist.saveToFile(filename))
                MessageBox::wrn(tr("Error write file"));
        }
        break;
    }
    kdebugf2();
}

void ExtInfo::onImport()
{
    kdebugf();
    if (frmextinfo)
    {
        frmextinfo->setFocus();
        MessageBox::wrn(tr("First you must close ext_info window"));
        kdebugf2();
        return;
    }
    QString filename = QFileDialog::getOpenFileName(extinfoPath("RExInfo.dat"),
        tr("RExInfo/ext_info 1.x files") + QString(" (RExInfo.dat; rexinfo.dat);;") +
        tr("All files") + QString(" (*)"));
    if (filename.length())
    {
        if (!extlist.loadFromFile(filename))
        {
            MessageBox::wrn(tr("Error read file"));
            kdebugf2();
            return;
        }
    }
    extlist.saveToFile();
    kdebugf2();
}

// Slots    -----------------------------------------------------------------------------------------------

void ExtInfo::changeCurrentUser(const QString &newUser)
{
    currentUser = newUser;
}

void ExtInfo::changeUserName(const QString& oldName, const QString& newName)
{
    extlist.renameItem(oldName, newName);
    if (frmextinfo)
        frmextinfo->renameSection(oldName, newName);
}

void ExtInfo::checkAnniversary()
{
    kdebugf();
    if (remindNameday)
    {
        ExtList name_day = extlist.getCommingNameDay(beforeRemind);
        for (ExtList::iterator i = name_day.begin(); i != name_day.end(); i++)
        {
            showRemindAnniversary(formatNameDayInfo(i.key(),(*i).daysToNameDay()),i.key());
        }
    }
    if (remindBirthday)
    {
        ExtList birthday = extlist.getCommingBirthday(beforeRemind);
        for (ExtList::iterator i = birthday.begin(); i != birthday.end(); i++)
        {
            showRemindAnniversary(formatBirthdayInfo(i.key(),(*i).daysToBirthday()),i.key());
        }
    }
    kdebugf2();
}
