#ifndef MAIL_H
#define MAIL_H

/*
 * autor 
 * Micha Podsiadlik
 * michal at gov.one.pl
 *
 * obsluga maildir:
 * Konrad Klimaszewski
 * klimasz at if.pw.edu.pl>
 */

#include <qobject.h>
#include <qsocket.h>
#include <qtimer.h>
#include <qstring.h>
#include <qcombobox.h>
#include <qfontdatabase.h>
#include <qlabel.h>

#include <config_file.h>

#include "pop3.h"

class Mail : public QObject
{
	Q_OBJECT

	public:	
		Mail();
		~Mail();
			
	private:
		QTimer *timer;
		QFont selectedfont;
		QLabel* fontlabel;
		void runmailclient();
		void addHint(const QPixmap& pixmap, const QString& text);
		QString formatmessage(int last, int total, int size, QString name);
		ConfigFile* config;
		QPtrList<Pop3Proto> accounts;
		void updateList();
				
	public slots:
		void checkmail();
		void onCreateConfig();
		void onCloseConfig();
		void onApplyConfig();
		void onFontChange();
		void onSelectMaildir();
		void maildir();
		void maildirtogled(bool);
		void mailclienttoolged(bool);
		void printstat(int last, int total, int size, QString name);
		void onAddButton();
		void onEditButton();
		void onRemoveButton();
};

extern Mail* mail;

#endif
