/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "smsmiastoplusagateway.h"
#include <qmessagebox.h>

#include "config_dialog.h"
#include "config_file.h"
#include "debug.h"
#include "modules.h"

SmsMiastoplusaGateway::SmsMiastoplusaGateway(QObject* parent, const char *name)
	: SmsGateway(parent, name)
{
	modules_manager->moduleIncUsageCount("miastoplusa_sms");
	connect( &timer, SIGNAL(timeout()), this, SLOT(checkIfFinished()) );
	connect( this, SIGNAL(displayInfosSignal()), this, SLOT(displayInfos()) );
}

SmsMiastoplusaGateway::~SmsMiastoplusaGateway()
{
	modules_manager->moduleDecUsageCount("miastoplusa_sms");
}

void SmsMiastoplusaGateway::send(const QString& number, const QString& message, const QString& /*contact*/, const QString&signature)
{
	kdebugf();
	QDialog* p=(QDialog*)(parent()->parent());
	//QWidget* p=(QWidget*)(parent()->parent());
	if(config_file.readEntry("SMS", "MiastoplusaGateway_User") != "" && config_file.readEntry("SMS", "MiastoplusaGateway_Pass") != "")
	{
		sendThread.setMsg(message);
		sendThread.setNr(number);
		sendThread.setDisplayInfos(config_file.readBoolEntry("SMS", "miastoplusa_sms_display_infos", false));
		kdebugm(KDEBUG_INFO, "Starting timer.\n");
		timer.start(500, FALSE);
		sendThread.start();
	}
	else
	{
		QMessageBox::critical(p, "SMS", tr("You mast specify your login name and password to Miasto Plusa in SMS tab in configure dialog!"));
		State = SMS_LOADING_RESULTS;
		emit finished(false);
	}
	//emit finished(true);
	kdebugf2();
}

void SmsMiastoplusaGateway::emitFinished(bool success)
{
	kdebugf();
	emit finished(success);
	kdebugf2();
}

bool SmsMiastoplusaGateway::isNumberCorrect(const QString& number)
{
	kdebugf();
	QString handleType = config_file.readEntry("SMS", "HandleType", "Always");
	if(handleType == "always") 
		return true;
	else if(handleType == "never")
		return (number[0]=='6'&&((QChar(number[2])-'0')%2)!=0);
	// TODO: Dokonczyc!!
	else if(handleType == "check")
		return true;
	// tu kod nigdy nie dochodzi
	return true;
}

void SmsMiastoplusaGateway::httpRedirected(QString link)
{
}

void SmsMiastoplusaGateway::httpFinished()
{
}

void SmsMiastoplusaGateway::displayInfos()
{
	QDialog* p=(QDialog*)(parent()->parent());
	QMessageBox::information(p, "SMS", sendThread.getInfosMsg());
}

void SmsMiastoplusaGateway::checkIfFinished()
{
	QDialog* p=(QDialog*)(parent()->parent());
	kdebugf();
	if(sendThread.isFinished())
	{
		timer.stop();
		bool success = sendThread.isSuccess();
		kdebugm(KDEBUG_INFO, "SUCCESS: %d!\n", success);
		kdebugm(KDEBUG_INFO, "Stopping timer.\n");
		State = SMS_LOADING_RESULTS;
		emit finished(success);
		if(!success)
			QMessageBox::critical(p, "SMS", sendThread.getErrorMsg());
		else 
		{
			if(sendThread.getDisplayInfos())
				emit displayInfosSignal();
		}
	}
	else
		kdebugm(KDEBUG_INFO, "Not finished yet...\n");
}

