/***************************************************************************
 *   Copyright (C) 2005 - 2006 by Christian Muehlhaeuser, Last.fm Ltd.     *
 *   chris@last.fm                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef __STATIONDIALOG_H__
#define __STATIONDIALOG_H__

#include <QtCore>

#include "ui_stationdialog.h"

class Playlist;
class WebserviceConnector;

class StationDialog : public QDialog
{
    Q_OBJECT

    public:
        StationDialog( QWidget *parent = 0 );
        ~StationDialog();

        void updateInformation();

    private:
        void resizeEvent ( QResizeEvent * event );

        Ui::StationDialog ui;

        QMenu *menu;
        QAction *deleteAction;
        QAction *resetAction;
        QAction *clearAction;

        QString resultToken;
        QPair<QStringList, QStringList> playlistData;

    private slots:
        void updateHistory();
        void updatePlaylist();
        void tagsForUserResult( const QStringList &result );

        void changeStationHistory();
        void changeStationTags();

        void websiteSearch();
        void searchModeChanged( int index );
        void search();
        void customStation();

        void changeStationPrepared();
        void changeStationThreaded( QTreeWidgetItem *item, int column );
        void changeStationThreaded( QListWidgetItem *item );

        void personalStation();
        void neighbourStation();
        void lovedStation();

        void playlistRemove();
        void playlistClear();

        void historyMenu( const QPoint & pos );
        void deleteItem();
        void resetItem();
        void clearItems();
};

#endif
