<?xml version="1.0"?> <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:exsl="http://exslt.org/common" xmlns:xi="http://www.w3.org/2001/XInclude" exclude-result-prefixes="exsl xi" extension-element-prefixes="exsl" version="1.0"> <xsl:param name="files"/> <xsl:param name="chunk.size"/> <xsl:template match="/"> <xsl:call-template name="make.file"/> </xsl:template> <xsl:template name="make.file"> <xsl:param name="count" select="1"/> <xsl:param name="current.files" select="concat(normalize-space($files), ' ')"/> <xsl:param name="more.files" select="concat(normalize-space(substring-after($current.files, ' ')),' ')"/> <xsl:param name="file.number" select="1"/> <xsl:param name="filename" select="concat('./build/',$file.number,'.xml')"/> <xsl:choose> <xsl:when test="$more.files = ' '"/> <xsl:when test="$count mod $chunk.size = 0"> <xsl:variable name="fileset" select="concat($current.files, ' ', substring-before($more.files, ' '))"/> <exsl:document href="{$filename}" method="xml" encoding="UTF-8" indent="yes" omit-xml-declaration="yes" media-type="" standalone="no"> <reference> <title>Combined contents</title> <xsl:call-template name="make.xinclude"> <xsl:with-param name="file"> <xsl:choose> <xsl:when test="contains($fileset, ' ')"> <xsl:value-of select="normalize-space(substring-before($fileset, ' '))"/> </xsl:when> <xsl:otherwise> <xsl:value-of select="$fileset"/> </xsl:otherwise> </xsl:choose> </xsl:with-param> <xsl:with-param name="remaining.files" select="concat(normalize-space(substring-after($fileset, ' ')),' ')"/> </xsl:call-template> </reference> </exsl:document> <xsl:call-template name="make.file"> <xsl:with-param name="count" select="1"/> <xsl:with-param name="current.files" select="$more.files"/> <xsl:with-param name="file.number" select="number($file.number) + 1"/> <xsl:with-param name="filename" select="concat('./build/',$file.number,'.xml')"/> </xsl:call-template> </xsl:when> <xsl:otherwise> <xsl:call-template name="make.file"> <xsl:with-param name="count" select="$count + 1"/> <xsl:with-param name="current.files"> <xsl:choose> <xsl:when test="$count = 1 and $file.number = 1"> <xsl:value-of select="concat(substring-before($current.files, ' '), ' ', substring-before($more.files, ' '))"/> </xsl:when> <xsl:when test="$count = 1"> <xsl:value-of select="substring-before($more.files, ' ')"/> </xsl:when> <xsl:otherwise> <xsl:value-of select="concat($current.files, ' ', substring-before($more.files, ' '))"/> </xsl:otherwise> </xsl:choose> </xsl:with-param> <xsl:with-param name="more.files" select="substring-after($more.files, ' ')"/> <xsl:with-param name="file.number" select="$file.number"/> </xsl:call-template> </xsl:otherwise> </xsl:choose> </xsl:template> <xsl:template name="make.xinclude"> <xsl:param name="file"/> <xsl:param name="remaining.files"/> <xsl:param name="count" select="1"/> <xsl:if test="not($file = '')"> <xi:include href="../{$file}"/> <xsl:call-template name="make.xinclude"> <xsl:with-param name="file" select="substring-before($remaining.files, ' ')"/> <xsl:with-param name="remaining.files" select="substring-after($remaining.files, ' ')"/> <xsl:with-param name="count" select="$count + 1"/> </xsl:call-template> </xsl:if> </xsl:template> </xsl:stylesheet>
