/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Point;
import java.awt.event.MouseEvent;
import org.jhotdraw.figures.LineConnection;
import org.jhotdraw.figures.NullConnector;
import org.jhotdraw.figures.NullFigure;
import org.jhotdraw.framework.ConnectionFigure;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.standard.ConnectionTool;
import org.jhotdraw.standard.SingleFigureEnumerator;

public class SplitConnectionTool
extends ConnectionTool {
    public SplitConnectionTool(DrawingEditor drawingEditor, ConnectionFigure connectionFigure) {
        super(drawingEditor, connectionFigure);
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        this.setView((DrawingView)mouseEvent.getSource());
        int n3 = mouseEvent.getX();
        int n4 = mouseEvent.getY();
        if (this.getTargetFigure() == null) {
            this.setTargetFigure(this.findConnectableFigure(n3, n4, this.drawing()));
        } else {
            Figure figure;
            if (this.getAddedFigure() == null) {
                this.setConnection(this.createConnection());
                this.setStartConnector(this.findConnector(n3, n4, this.getTargetFigure()));
                this.getConnection().connectStart(this.getStartConnector());
                this.getConnection().startPoint(n3, n4);
                this.setAddedFigure(this.view().add(this.getConnection()));
            }
            if ((figure = this.findTarget(n3, n4, this.drawing())) != null) {
                this.setEndConnector(this.findConnector(n3, n3, figure));
                this.getConnection().connectEnd(this.getEndConnector());
                this.getConnection().endPoint(n3, n4);
                this.setUndoActivity(this.createUndoActivity());
                this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.getAddedFigure()));
                this.getConnection().updateConnection();
                this.init();
                this.editor().toolDone();
            } else if (this.getEndConnector() == null) {
                NullFigure nullFigure = new NullFigure();
                nullFigure.basicDisplayBox(new Point(n3, n4), new Point(n3, n4));
                this.setEndConnector(new NullConnector(nullFigure));
                this.getConnection().connectEnd(this.getEndConnector());
                this.getConnection().endPoint(n3, n4);
                this.getConnection().updateConnection();
            } else {
                ((LineConnection)this.getConnection()).addPoint(n3, n4);
            }
        }
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        if (mouseEvent.getClickCount() == 2) {
            this.init();
            this.editor().toolDone();
        }
    }

    public void mouseMove(MouseEvent mouseEvent, int n, int n2) {
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
    }

    public void deactivate() {
        if (this.getConnection() != null) {
            this.view().remove(this.getConnection());
        }
        super.deactivate();
        this.init();
    }

    protected void init() {
        this.setConnection(null);
        this.setStartConnector(null);
        this.setEndConnector(null);
        this.setAddedFigure(null);
        this.setTargetFigure(null);
    }
}

