/*******************************************************************************
 * Score Reading Trainer                                                       *
 * Copyright (C) 2004 by Jos Pablo Ezequiel Fernndez <pupeno@pupeno.com>     *
 *                                                                             *
 * This program is free software; you can redistribute it and/or               *
 * modify it under the terms of the GNU General Public License                 *
 * version 2 as published by the Free Software Foundation.                     *
 *                                                                             *
 * This program is distributed in the hope that it will be useful,             *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 * GNU General Public License for more details.                                *
 *                                                                             *
 * You should have received a copy of the GNU General Public License           *
 * along with this program; if not, write to the Free Software                 *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *******************************************************************************/

#include "ScoreReadingTrainer.h"
#include <kapplication.h>
#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static const char description[] = I18N_NOOP("Score Reading Trainer helps you improve your musical score reading skills.");

static const char homepage[] = "http://scret.sf.net";

static const char bugs[] = "http://sourceforge.net/tracker/?group_id=97653&atid=618659";

static KCmdLineOptions options[] = {
//	{ "+[URL]", I18N_NOOP( "Document to open." ), 0 },
	KCmdLineLastOption
};

int main(int argc, char **argv){
	KAboutData about("ScoreReadingTrainer", I18N_NOOP("Score Reading Trainer"), VERSION, description,
	KAboutData::License_GPL, "(C) 2004 José Pablo Ezequiel \"Pupeno\" Fernández", 0, 0, "pupeno@pupeno.com");
	about.addAuthor( "José Pablo Ezequiel \"Pupeno\" Fernández", 0, "pupeno@pupeno.com" );
	about.addCredit( "Sandra Fernández", I18N_NOOP("Musical support"), "sandra@sandrafernandez.com.ar", "http://www.sandrafernandez.com.ar");
	KCmdLineArgs::init(argc, argv, &about);
	KCmdLineArgs::addCmdLineOptions(options);
	KApplication app;

	// register ourselves as a dcop client
	app.dcopClient()->registerAs(app.name(), false);

	// see if we are starting with session management
	if (app.isRestored()){
		RESTORE(ScoreReadingTrainer);
	} else {
		// no session.. just start up normally
		KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
		if (args->count() == 0) {
			ScoreReadingTrainer *widget = new ScoreReadingTrainer;
			widget->show();
		} else {
			int i = 0;
			for (; i < args->count(); i++){
				ScoreReadingTrainer *widget = new ScoreReadingTrainer;
				widget->show();
//				widget->load(args->url(i));
			}
		}
		args->clear();
	}
	return app.exec();
}
