#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
int main(int argc, char *argv[])
{
	char *c;
	int fd;
	FILE *f;
	int res;
	int x;
	unsigned char buf[1024];
	if (argc != 3) {
		fprintf(stderr, "Usage: fw2h <infile> <outfile>");
		exit(1);
	}
	fd = open(argv[1], O_RDONLY);
	if (fd < 0) {
		fprintf(stderr, "Unable to open '%s': %s\n", argv[1], strerror(errno));
		exit(1);
	}
	f = fopen(argv[2], "w+");
	if (!f) {
		fprintf(stderr, "Unable to open '%s' for writing: %s\n", argv[2], strerror(errno));
		exit(1);
	}
	c = strrchr(argv[2], '.');
	if (c) *c = '\0';
	fprintf(f, "static unsigned char %s[] = {\t", argv[2]);
	while ((res = read(fd, buf, sizeof(buf))) > 0) {
		for (x = 0; x < res; x++) {
			if (!(x % 16))
				fprintf(f, "\n\t");
			fprintf(f, "0x%02x, ", buf[x]);
		}
	}
	fprintf(f, "\n};\n");
	if (res < 0) {
		fprintf(stderr, "Error reading file: %s\n", strerror(errno));
		exit(1);
	}
	fclose(f);
	close(fd);
	exit(0);
}
