// ATITVOExtensions.c
//////////////////////////////////////////////////////////////////////////////

//#ifdef FGLRX_USE_XEXTENSIONS
#if 1

// extension protocoll defines
#define XREP_SZ(name)       sizeof(x##name##Reply)
#define XREQ_SZ(name)       sizeof(x##name##Req)


// includes

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xproto.h>
#include <X11/Xlibint.h>
#include <X11/extensions/XTest.h>
#include <X11/extensions/sync.h>
#include <X11/Xproto.h>
#include <X11/extensions/Xdbe.h>
#include <X11/extensions/record.h>
#include <X11/extensions/shape.h>

#include <X11/extensions/xf86misc.h>
#include <X11/extensions/xf86mscstr.h>
#include "extutil.h"

#include <X11/extensions/XInput.h>

#include <X11/Xos.h>
#include <stdio.h>
#include <stdlib.h>

#include "ATITVOExtensions.h"
#include "Radeon_extension_tvout.h"

static XExtensionInfo _atitvo_info_data;
static XExtensionInfo *atitvo_info = &_atitvo_info_data;
static char *atitvo_extension_name = ATITVOUT_EXTENSION_NAME;


//////////////////////////////////////////////////////////////////////////////
// private functions

XExtDisplayInfo *info;

// X shutdown hook function that will cleanup the opened extension
static XEXT_GENERATE_CLOSE_DISPLAY (close_display_atitvo, 
                                    atitvo_info)

// table with X hooks
static /* const */ XExtensionHooks atitvo_extension_hooks = {
    NULL,                   /* create_gc */
    NULL,                   /* copy_gc */
    NULL,                   /* flush_gc */
    NULL,                   /* free_gc */
    NULL,                   /* create_font */
    NULL,                   /* free_font */
    close_display_atitvo,   /* close_display */
    NULL,                   /* wire_to_event */
    NULL,                   /* event_to_wire */
    NULL,                   /* error */
    NULL,                   /* error_string */
};

// find_display_atitvo - get the display info block for atitvo extension
static XEXT_GENERATE_FIND_DISPLAY (find_display_atitvo, 
                                   atitvo_info,
                                   atitvo_extension_name, 
                                   &atitvo_extension_hooks, 
                                   ATITVOUT_NUMBER_EVENTS, 
                                   NULL)



static int 
answerisyes(char *s)
{
    if (s[0] == '\'')   /* For fools that type the ' literally. */
        return tolower(s[1]) == 'y';
    return tolower(s[0]) == 'y';
}


static void 
getstring(char *s)
{
    char *cp;
    fgets(s, 80, stdin);
    cp = strchr(s, '\n');
    if (cp)
        *cp=0;
}



//////////////////////////////////////////////////////////////////////////////
// type defines

typedef unsigned long DWORD;
typedef unsigned long ULONG;
typedef unsigned int HANDLE;
#ifndef ULONG_PTR
typedef ULONG ULONG_PTR;
#endif // ULONG_PTR


//////////////////////////////////////////////////////////////////////////////
// macro defines

// debug

#ifdef DEBUG
#define DEB(s)  s
#else
#define DEB(s)
#endif // DEBUG


#ifdef DEBUG
#define TRACE_XEXT(fmt, arg...)     printf("[FGLRXExtensions] " fmt, ##arg)
#else
#define TRACE_XEXT(fmt, arg...)     do { /* empty */ } while(0)
#endif // DEBUG

// misc

#define FALSE   (1==0)
#define TRUE    (1==1)

/*****************************************************************************/
/*                                                                           */
/* NAME:      ExtATITVOEnableDisable                                         */
/*                                                                           */
/* FUNCTION:                                                                 */
/*                                                                           */
/* INPUT:     Display *dpy                                                   */
/*            int iTVStd                                                     */
/*                                                                           */
/*                                                                           */
/* OUTPUTS:                                                                  */
/*                                                                           */
/* NOTE:                                                                     */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
Bool ExtATITVOEnableDisable(int iOn)
{
    Display *dpy;
    char    *displayname = NULL;
    // [First step] Check whether the extension exists
    XExtDisplayInfo *info;
    Bool RetVal = TRUE;

    dpy = XOpenDisplay (displayname);
    if (!dpy) 
    {
        TRACE_XEXT("unable to open display\n");
        exit (1);
    }

    info = find_display_atitvo(dpy);

    TRACE_XEXT("=== ExtGetDriverData started ===\n");
    // get driver data
    if (XextHasExtension(info))
    {
        xATITVOEnableDisableReq *req;
        xATITVOEnableDisableReply rep;
        int i;

        TRACE_XEXT("=== HasExtension ===\n");
        GetReq(ATITVOEnableDisable, req);

        // Fill in the request structure
        req->reqType = info->codes->major_opcode;
        // calculate size of request structure in 4 byte units 
        req->length = (sizeof(*req)+3) / 4;
        req->fireglReqType = X_ATITVOEnableDisable;
        req->screen = DefaultScreen (dpy);
        req->TVEnable = (CARD32)iOn;

        // Carry out the extension function and wait for reply
        // 3rd parameter, called "extra": number of extra 32 bit words
        // reply structures must be multiple of 4 with a minimum of 32 bytes
        if (!_XReply(dpy, (xReply *)&rep, (sizeof(rep) - 32) / 4, xFalse))
        {
            SyncHandle();
            XCloseDisplay (dpy);
            return FALSE;
        }

        SyncHandle();
    }
    else
    {
        TRACE_XEXT("extension *not* found\n");
        RetVal = FALSE;
    }
    XCloseDisplay (dpy);

    return RetVal;
} // === ExtATITVOEnableDisable ===

/*****************************************************************************/
/*                                                                           */
/* NAME:      ExtATITVOSetTVStd                                              */
/*                                                                           */
/* FUNCTION:                                                                 */
/*                                                                           */
/* INPUT:     Display *dpy                                                   */
/*            int iTVStd                                                     */
/*                                                                           */
/*                                                                           */
/* OUTPUTS:                                                                  */
/*                                                                           */
/* NOTE:                                                                     */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
Bool ExtATITVOSetTVStd(int iTVStd)
{
    Display *dpy;
    char    *displayname = NULL;
    // [First step] Check whether the extension exists
    XExtDisplayInfo *info;
    Bool RetVal = TRUE;

    dpy = XOpenDisplay (displayname);
    if (!dpy) 
    {
        TRACE_XEXT("unable to open display\n");
        exit (1);
    }

    info = find_display_atitvo(dpy);

    TRACE_XEXT("=== ExtGetDriverData started ===\n");
    // get driver data
    if (XextHasExtension(info))
    {
        xATITVOSetStandardReq *req;
        xATITVOSetStandardReply rep;
        int i;

        TRACE_XEXT("=== HasExtension ===\n");
        GetReq(ATITVOSetStandard, req);

        // Fill in the request structure
        req->reqType = info->codes->major_opcode;
        // calculate size of request structure in 4 byte units 
        req->length = (sizeof(*req)+3) / 4;
        req->fireglReqType = X_ATITVOSetStandard;
        req->screen = DefaultScreen (dpy);
        req->TVStandard = (CARD32)iTVStd; 

        // Carry out the extension function and wait for reply
        // 3rd parameter, called "extra": number of extra 32 bit words
        // reply structures must be multiple of 4 with a minimum of 32 bytes
        if (!_XReply(dpy, (xReply *)&rep, (sizeof(rep) - 32) / 4, xFalse))
        {
            SyncHandle();
            XCloseDisplay (dpy);
            return FALSE;
        }

        SyncHandle();
    }
    else
    {
        TRACE_XEXT("extension *not* found\n");
        RetVal = FALSE;
    }
    XCloseDisplay (dpy);

    return RetVal;
} // === ExtATITVOSetTVStd ===

/*****************************************************************************/
/*                                                                           */
/* NAME:      ExtATITVOGetData                                               */
/*                                                                           */
/* FUNCTION:                                                                 */
/*                                                                           */
/* INPUT:                                                                    */
/*            ATITVOGetDataPtr pATITVOGetData                                */
/*                                                                           */
/*                                                                           */
/* OUTPUTS:                                                                  */
/*                                                                           */
/* NOTE:                                                                     */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
Bool ExtATITVOGetData(ATITVOGetDataPtr pATITVOGetData)
{
    Display *dpy;
    char    *displayname = NULL;
    // [First step] Check whether the extension exists
    XExtDisplayInfo *info;

    dpy = XOpenDisplay (displayname);
    if (!dpy) 
    {
        TRACE_XEXT("unable to open display\n");
        exit (1);
    }

    info = find_display_atitvo(dpy);

    TRACE_XEXT("=== ATITVOGetData started ===\n");
    if (XextHasExtension(info))
    {
        xATITVOGetDataReq *req;
        xATITVOGetDataReply rep;
        int i;

        TRACE_XEXT("=== HasExtension ===\n");
        GetReq(ATITVOGetData, req);

        // Fill in the request structure
        req->reqType = info->codes->major_opcode;
        // calculate size of request structure in 4 byte units 
        req->length = (sizeof(*req)+3) / 4;
        req->fireglReqType = X_ATITVOGetData;
        req->screen = DefaultScreen (dpy);

        // Carry out the extension function and wait for reply
        // 3rd parameter, called "extra": number of extra 32 bit words
        // reply structures must be multiple of 4 with a minimum of 32 bytes
        if (!_XReply(dpy, (xReply *)&rep, (sizeof(rep) - 32) / 4, xFalse))
        {
            SyncHandle();
            XCloseDisplay (dpy);
            return FALSE;
        }

        pATITVOGetData->TVConnected = (int)rep.TVConnected;
        pATITVOGetData->TVStd       = (int)rep.TVStd;
        pATITVOGetData->MVMode      = (int)rep.MVMode;
        pATITVOGetData->tvHSizeAdj  = (int)rep.tvHSizeAdj;
        pATITVOGetData->tvVSizeAdj  = (int)rep.tvVSizeAdj;
        pATITVOGetData->tvHPosAdj   = (int)rep.tvHPosAdj;
        pATITVOGetData->tvVPosAdj   = (int)rep.tvVPosAdj;
        pATITVOGetData->tvHStartAdj = (int)rep.tvHStartAdj;
        pATITVOGetData->tvColorAdj  = (int)rep.tvColorAdj;
        pATITVOGetData->error       = (int)rep.error;
        SyncHandle();
    }
    else
    {
        TRACE_XEXT("ATI TVOut extension *not* found\n");
    }
    XCloseDisplay (dpy);
    return TRUE;
} // === ExtATITVOGetData ===


/*****************************************************************************/
/*                                                                           */
/* NAME:      ExtATITVOAdjustSize                                            */
/*                                                                           */
/* FUNCTION:                                                                 */
/*                                                                           */
/* INPUT:                                                                    */
/*                                                                           */
/*                                                                           */
/* OUTPUTS:                                                                  */
/*                                                                           */
/* NOTE:                                                                     */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
Bool ExtATITVOAdjustSize(ATITVOExtAdjustSizePtr pATITVOExtAdjustSize)
{
    Display *dpy;
    char    *displayname = NULL;
    // [First step] Check whether the extension exists
    XExtDisplayInfo *info;

    dpy = XOpenDisplay (displayname);
    if (!dpy) 
    {
        TRACE_XEXT("unable to open display\n");
        exit (1);
    }

    info = find_display_atitvo(dpy);

    TRACE_XEXT("=== ATITVOExtAdjustSize started ===\n");
    // get driver data
    if (XextHasExtension(info))
    {
        xATITVOAdjustSizeReq *req;
        xATITVOAdjustSizeReply rep;
        int i;

        TRACE_XEXT("=== HasExtension ===\n");
        GetReq(ATITVOAdjustSize, req);

        // Fill in the request structure
        req->reqType = info->codes->major_opcode;
        // calculate size of request structure in 4 byte units 
        req->length = (sizeof(*req)+3) / 4;
        req->fireglReqType = X_ATITVOAdjustSize;
        req->screen = DefaultScreen (dpy);
        req->tvHSizeAdj = (CARD32)pATITVOExtAdjustSize->tvHSizeAdj;
        req->tvVSizeAdj = (CARD32)pATITVOExtAdjustSize->tvVSizeAdj;
        // Carry out the extension function and wait for reply
        // 3rd parameter, called "extra": number of extra 32 bit words
        // reply structures must be multiple of 4 with a minimum of 32 bytes
        if (!_XReply(dpy, (xReply *)&rep, (sizeof(rep) - 32) / 4, xFalse))
        {
            SyncHandle();
            XCloseDisplay (dpy);
            return FALSE;
        }

        SyncHandle();
    }
    else
    {
        // TRACE_XEXT(" extension *not* found\n");
    }
    XCloseDisplay (dpy);
    return TRUE;
} // === ExtATITVOAdjustSize ===


/*****************************************************************************/
/*                                                                           */
/* NAME:      ExtATITVOAdjustPosition                                        */
/*                                                                           */
/* FUNCTION:                                                                 */
/*                                                                           */
/* INPUT:                                                                    */
/*                                                                           */
/*                                                                           */
/* OUTPUTS:                                                                  */
/*                                                                           */
/* NOTE:                                                                     */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
Bool ExtATITVOAdjustPosition(ATITVOAdjustPositionPtr pATITVOAdjustPosition)
{
    Display *dpy;
    char    *displayname = NULL;
    // [First step] Check whether the extension exists
    XExtDisplayInfo *info;

    dpy = XOpenDisplay (displayname);
    if (!dpy) 
    {
        TRACE_XEXT("unable to open display\n");
        exit (1);
    }

    info = find_display_atitvo(dpy);

    TRACE_XEXT("=== ATITVOAdjustPosition started ===\n");
    // get driver data
    if (XextHasExtension(info))
    {
        xATITVOAdjustPositionReq *req;
        xATITVOAdjustPositionReply rep;
        int i;

        TRACE_XEXT("=== HasExtension ===\n");
        GetReq(ATITVOAdjustPosition, req);

        // Fill in the request structure
        req->reqType = info->codes->major_opcode;
        // calculate size of request structure in 4 byte units 
        req->length = (sizeof(*req)+3) / 4;
        req->fireglReqType = X_ATITVOAdjustPosition;
        req->screen = DefaultScreen (dpy);
        req->tvHPosAdj  = (CARD32)pATITVOAdjustPosition->tvHPosAdj;
        req->tvVPosAdj  = (CARD32)pATITVOAdjustPosition->tvVPosAdj;
        req->tvHStartAdj = (CARD32)pATITVOAdjustPosition->tvHStartAdj;
        // Carry out the extension function and wait for reply
        // 3rd parameter, called "extra": number of extra 32 bit words
        // reply structures must be multiple of 4 with a minimum of 32 bytes
        if (!_XReply(dpy, (xReply *)&rep, (sizeof(rep) - 32) / 4, xFalse))
        {
            SyncHandle();
            XCloseDisplay (dpy);
            return FALSE;
        }

        SyncHandle();
    }
    else
    {
        // TRACE_XEXT(" extension *not* found\n");
    }
    XCloseDisplay (dpy);
    return TRUE;
} // === ExtATITVOAdjustPosition ===

/*****************************************************************************/
/*                                                                           */
/* NAME:      ExtATITVOAdjustColor                                           */
/*                                                                           */
/* FUNCTION:                                                                 */
/*                                                                           */
/* INPUT:                                                                    */
/*                                                                           */
/*                                                                           */
/* OUTPUTS:                                                                  */
/*                                                                           */
/* NOTE:                                                                     */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
Bool ExtATITVOAdjustColor(int itvColorAdj)
{
    Display *dpy;
    char    *displayname = NULL;
    // [First step] Check whether the extension exists
    XExtDisplayInfo *info;

    dpy = XOpenDisplay (displayname);
    if (!dpy) 
    {
        TRACE_XEXT("unable to open display\n");
        exit (1);
    }

    info = find_display_atitvo(dpy);

    TRACE_XEXT("=== ATITVOAdjustColor started ===\n");
    // get driver data
    if (XextHasExtension(info))
    {
        xATITVOAdjustColorReq *req;
        xATITVOAdjustColorReply rep;
        int i;

        TRACE_XEXT("=== HasExtension ===\n");
        GetReq(ATITVOAdjustColor, req);

        // Fill in the request structure
        req->reqType = info->codes->major_opcode;
        // calculate size of request structure in 4 byte units 
        req->length = (sizeof(*req)+3) / 4;
        req->fireglReqType = X_ATITVOAdjustColor;
        req->screen = DefaultScreen (dpy);
        req->tvColorAdj  = (CARD32)itvColorAdj;
        // Carry out the extension function and wait for reply
        // 3rd parameter, called "extra": number of extra 32 bit words
        // reply structures must be multiple of 4 with a minimum of 32 bytes
        if (!_XReply(dpy, (xReply *)&rep, (sizeof(rep) - 32) / 4, xFalse))
        {
            SyncHandle();
            XCloseDisplay (dpy);
            return FALSE;
        }

        SyncHandle();
    }
    else
    {
        // TRACE_XEXT(" extension *not* found\n");
    }
    XCloseDisplay (dpy);
    return TRUE;
} // === ExtATITVOAdjustColor ===

/*****************************************************************************/
/*                                                                           */
/* NAME:      ExtATITVOSetData                                               */
/*                                                                           */
/* FUNCTION:                                                                 */
/*                                                                           */
/* INPUT:                                                                    */
/*            ATITVOGetDataPtr pATITVOGetData                                */
/*                                                                           */
/*                                                                           */
/* OUTPUTS:                                                                  */
/*                                                                           */
/* NOTE:                                                                     */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
Bool ExtATITVOSetData(ATITVOGetDataPtr pATITVOGetData)
{
    ATITVOExtAdjustSizePtr pATITVOExtAdjustSize;
    ATITVOAdjustPositionPtr pATITVOAdjustPosition;

    ExtATITVOSetTVStd((int)&(pATITVOGetData->TVStd));
 
    ExtATITVOAdjustColor((int)&(pATITVOGetData->tvColorAdj));

    pATITVOExtAdjustSize->tvHSizeAdj = pATITVOGetData->tvHSizeAdj;
    pATITVOExtAdjustSize->tvVSizeAdj = pATITVOGetData->tvVSizeAdj;
    ExtATITVOAdjustSize(pATITVOExtAdjustSize);

    pATITVOAdjustPosition->tvHPosAdj = pATITVOGetData->tvHPosAdj;
    pATITVOAdjustPosition->tvVPosAdj = pATITVOGetData->tvVPosAdj;
    pATITVOAdjustPosition->tvHStartAdj = pATITVOGetData->tvHStartAdj;
    ExtATITVOAdjustPosition(pATITVOAdjustPosition);

    //pATITVOGetData->TVConnected = (int)rep.TVConnected;
    //pATITVOGetData->MVMode      = (int)rep.MVMode;
    //pATITVOGetData->error       = (int)rep.error;
    return TRUE;
} // === ExtATITVOSetData ===




#endif // FGLRX_USE_XEXTENSIONS
