#include "Vlib.h"

void
VCloseViewport(Viewport * v)
{

	v->Close(v);

	VDestroyPolygon(v->clipPoly);
	free(v->aPixel);
	free((char *) v->zpool);
	free((char *) v);
}

void
releaseVResources (void)
{
	VColor   *p = _VDefaultWorkContext->VColorList, *next;
	while (p) {
		free (p->color_name);
		next = p->next;
		free (p);
		p = next;
	}
	_VDefaultWorkContext->VColorList = NULL;
	if (_VDefaultWorkContext->visTable) {
		free(_VDefaultWorkContext->visTable);
		_VDefaultWorkContext->visTable = NULL;
	}
}
