/*
 * Copyright (C) 2017 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>

#include "glue-gui.h"

#include "red_pitaya_gui.h"
#ifdef HAVE_GTK
#include "red_pitaya_gui_gtk.h"
#endif

#define COMP_(x)	red_pitaya_ ## x

void *
COMP_(gui_create)(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_std_logic *port_voltage_1,
	struct sig_std_logic *port_voltage_2,
	struct sig_std_logic *port_voltage_3,
	struct sig_std_logic *port_voltage_4,
	struct sig_std_logic *port_voltage_5,
	struct sig_std_logic *port_voltage_6,
	struct sig_std_logic *port_voltage_7,
	struct sig_std_logic *port_voltage_8,
	struct sig_std_logic *port_voltage_9,
	struct sig_std_logic *port_voltage_10,
	struct sig_std_logic *port_digi_1,
	struct sig_std_logic *port_digi_2,
	struct sig_std_logic *port_digi_3,
	struct sig_std_logic *port_digi_4,
	struct sig_std_logic *port_digi_5,
	struct sig_std_logic *port_digi_6,
	struct sig_std_logic *port_digi_7,
	struct sig_std_logic *port_digi_8,
	struct sig_std_logic *port_digi_9,
	struct sig_std_logic *port_digi_10,
	struct sig_integer *port_sample_rate_gui_sim,
	struct sig_integer *port_sample_rate_sim_gui,
	struct sig_integer *port_sec_div_gui_sim,
	struct sig_integer *port_sec_div_sim_gui,
	struct sig_integer *port_volt_div_gui_sim,
	struct sig_integer *port_volt_div_sim_gui,
	struct sig_integer *port_channel_select,
	struct sig_integer *port_trigger_sim_gui,
	struct sig_integer *port_trigger_gui_sim,
	struct sig_integer *port_vert_offset_sim_gui,
	struct sig_integer *port_vert_offset_gui_sim,
	struct sig_opt_rgb *port_monitor,
	struct sig_std_logic *port_vcc,
	struct sig_std_logic *port_gnd,
	struct sig_std_logic *port_start,
	struct sig_std_logic *port_stop,
	struct sig_std_logic *port_scroll_left,
	struct sig_std_logic *port_scroll_right,
	struct sig_std_logic *port_export,
	struct sig_integer *port_trigger_channel_gui_sim,
	struct sig_integer *port_trigger_channel_sim_gui,
	struct sig_integer *port_trigger_edge_gui_sim,
	struct sig_integer *port_trigger_edge_sim_gui,
	struct sig_integer *port_trigger_level_gui_sim,
	struct sig_integer *port_trigger_level_sim_gui,
	struct sig_integer *port_amp_div_gui_sim,
	struct sig_integer *port_amp_div_sim_gui
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return COMP_(gui_gtk_create)(page, name,
				port_manage,
				port_voltage_1,
				port_voltage_2,
				port_voltage_3,
				port_voltage_4,
				port_voltage_5,
				port_voltage_6,
				port_voltage_7,
				port_voltage_8,
				port_voltage_9,
				port_voltage_10,
				port_digi_1,
				port_digi_2,
				port_digi_3,
				port_digi_4,
				port_digi_5,
				port_digi_6,
				port_digi_7,
				port_digi_8,
				port_digi_9,
				port_digi_10,
				port_sample_rate_gui_sim,
				port_sample_rate_sim_gui,
				port_sec_div_gui_sim,
				port_sec_div_sim_gui,
				port_volt_div_gui_sim,
				port_volt_div_sim_gui,
				port_channel_select,
				port_trigger_sim_gui,
				port_trigger_gui_sim,
				port_vert_offset_sim_gui,
				port_vert_offset_gui_sim,
				port_monitor,
				port_vcc,
				port_gnd,
				port_start,
				port_stop,
				port_scroll_left,
				port_scroll_right,
				port_export,
				port_trigger_channel_gui_sim,
				port_trigger_channel_sim_gui,
				port_trigger_edge_gui_sim,
				port_trigger_edge_sim_gui,
				port_trigger_level_gui_sim,
				port_trigger_level_sim_gui,
				port_amp_div_gui_sim,
				port_amp_div_sim_gui
			);
	break;
#endif
	case GUI_NULL:
		return (void *) 1;
	default:
		assert(0);
	}
	return NULL;
}

void
COMP_(gui_destroy)(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		COMP_(gui_gtk_destroy)(_cpssp);
		break;
#endif
	case GUI_NULL:
		/* Nothing to do... */
	default:
		assert(0);
	}
}

void
COMP_(gui_suspend)(void *_cpssp, FILE *fp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		COMP_(gui_gtk_suspend)(_cpssp, fp);
		break;
#endif
	case GUI_NULL:
		/* Nothing to do... */
		break;
	default:
		assert(0); /* Mustn't happen. */
	}
}

void
COMP_(gui_resume)(void *_cpssp, FILE *fp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		COMP_(gui_gtk_resume)(_cpssp, fp);
		break;
#endif
	case GUI_NULL:
		/* Nothing to do... */
		break;
	default:
		assert(0); /* Mustn't happen. */
	}
}
