/*
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/** Write to file descriptor.
 *  @param fd file descriptor.
 *  @param buf buffer.
 *  @param buflen buffer size.
 */
extern int
io_write(int fd, const void *buf, int buflen);

/** Read from file descriptor.
 *  @param fd file descriptor.
 *  @param buf buffer.
 *  @param buflen buffer size.
 */
extern int
io_read(int fd, void *buf, int buflen);

/** register a file descriptor for IO.
 *  @param fd file descriptor.
 *  @param s object for callback.
 *  @param f callback function that will be called if the file desriptor can
 *         be read from, parameters are the file descriptor and the object
 *         from argument s.
 */
extern void
io_register(int fd, void *s, void (*f)(int, void *));

/** unregister given file descriptor.
 *  @param fd file descriptor.
 */
extern void
io_unregister(int fd);

/** check for io and call registered callbacks. usually, this function is 
 *  called from a SIGIO handler.
 */
extern void
io_do(void);

/** initialize io module. */
extern void
io_init(void);

/** finalize io module. */
extern void
io_exit(void);
