/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.zip.InflaterInputStream;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Variable;
import ucar.nc2.iosp.Indexer;
import ucar.nc2.iosp.hdf5.H5chunkLayout;
import ucar.nc2.iosp.hdf5.H5header;
import ucar.nc2.util.IO;
import ucar.unidata.io.RandomAccessFile;

class H5chunkFilterLayout
extends H5chunkLayout {
    private RandomAccessFile raf;
    private H5header.Filter[] filters;
    private ByteBuffer bb;
    private ShortBuffer sb;
    private IntBuffer ib;
    private LongBuffer longb;
    private FloatBuffer fb;
    private DoubleBuffer db;
    private boolean debug = false;

    H5chunkFilterLayout(Variable v2, Section wantSection, RandomAccessFile raf, H5header.Filter[] filters) throws InvalidRangeException, IOException {
        super(v2, v2.getDataType(), wantSection);
        this.raf = raf;
        this.filters = filters;
    }

    public ByteBuffer getByteBuffer() {
        return this.bb;
    }

    public ShortBuffer getShortBuffer() {
        if (this.sb == null) {
            this.sb = this.bb.asShortBuffer();
        }
        return this.sb;
    }

    public IntBuffer getIntBuffer() {
        if (this.ib == null) {
            this.ib = this.bb.asIntBuffer();
        }
        return this.ib;
    }

    public LongBuffer getLongBuffer() {
        if (this.longb == null) {
            this.longb = this.bb.asLongBuffer();
        }
        return this.longb;
    }

    public FloatBuffer getFloatBuffer() {
        if (this.fb == null) {
            this.fb = this.bb.asFloatBuffer();
        }
        return this.fb;
    }

    public DoubleBuffer getDoubleBuffer() {
        if (this.db == null) {
            this.db = this.bb.asDoubleBuffer();
        }
        return this.db;
    }

    protected Indexer indexFactory(H5header.DataBTree.DataChunk dataChunk, long filePos, int elemSize, Section dataSection, Section want) throws IOException, InvalidRangeException {
        byte[] data = new byte[dataChunk.size];
        this.raf.seek(dataChunk.filePos);
        this.raf.readFully(data);
        for (int i = this.filters.length - 1; i >= 0; --i) {
            H5header.Filter f = this.filters[i];
            if (H5chunkFilterLayout.isBitSet(dataChunk.filterMask, i)) {
                if (!this.debug) continue;
                System.out.println("skip for chunk " + dataChunk);
                continue;
            }
            if (f.id == 1) {
                data = this.inflate(data);
            }
            if (f.id != 2) continue;
            data = this.shuffle(data, f.data[0]);
        }
        this.bb = ByteBuffer.wrap(data);
        this.sb = null;
        this.ib = null;
        this.longb = null;
        this.fb = null;
        this.db = null;
        return super.indexFactory(null, 0L, elemSize, dataSection, want);
    }

    private byte[] inflate(byte[] compressed) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(compressed);
        InflaterInputStream inflater = new InflaterInputStream(in);
        ByteArrayOutputStream out = new ByteArrayOutputStream(8 * compressed.length);
        IO.copy(inflater, out);
        byte[] uncomp = out.toByteArray();
        if (this.debug) {
            System.out.println(" inflate bytes in= " + compressed.length + " bytes out= " + uncomp.length);
        }
        return uncomp;
    }

    private byte[] shuffle(byte[] data, int n) throws IOException {
        if (this.debug) {
            System.out.println(" shuffle bytes in= " + data.length + " n= " + n);
        }
        assert (data.length % n == 0);
        if (n <= 1) {
            return data;
        }
        int seglen = data.length / n;
        int[] count = new int[n];
        for (int k = 0; k < n; ++k) {
            count[k] = k * seglen;
        }
        byte[] result = new byte[data.length];
        for (int i = 0; i < data.length; i += n) {
            for (int k = 0; k < n; ++k) {
                int n2 = k;
                int n3 = count[n2];
                count[n2] = n3 + 1;
                result[n3] = data[i + k];
            }
        }
        return result;
    }

    static boolean isBitSet(int val, int bitno) {
        return (val >>> bitno & 1) != 0;
    }

    public static void main(String[] args) {
        assert (H5chunkFilterLayout.isBitSet(1, 0));
        assert (!H5chunkFilterLayout.isBitSet(1, 1));
        assert (!H5chunkFilterLayout.isBitSet(2, 0));
        assert (H5chunkFilterLayout.isBitSet(2, 1));
        assert (H5chunkFilterLayout.isBitSet(1024, 10));
        assert (!H5chunkFilterLayout.isBitSet(1024, 1));
    }
}

