/* Freebirth
 * Copyright (C) 1999 topher lafata <topher@topher.com>,
 *		      Jake Donham <jake@bitmechanic.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#define __OSC_H

#ifndef __SAMPLE_PRODUCER_H
  #include "sample_producer.h"
#endif



#define SIN  0
#define SQR  1
#define SAW  2

#define MAX_FREQ_OFFSET 32768

typedef struct osc{
  sample *(* get_buffer)(struct osc *);
  void (*next_buffer)(struct osc *);
  sample_producer **(*get_children)(struct osc *);
  char **(*get_header)(struct osc *);
  char **(*get_code)(struct osc *);
  char **(*get_footer)(struct osc *);
  void (* schedule)(sample_producer *sp ,event *e,int offset);
  void (* trigger)(sample_producer *this);
  event **events;  /*table of scheduled events */


  int  freq;
  sample *table;
  sample *buffer;
  int  current_index;  /* current place in table */
  int  phase_offset;
  int  freq_offset;
  int next;

}osc;


void      init_tables();
osc      *osc_new(int freq,int type);
sample   *osc_get_buffer(osc *this);
void      osc_next_buffer(osc *this);
void      osc_set_type(osc *this, int type);
void      osc_trigger(osc* this);
void      osc_set_frequency(osc *this, int freq);
void      osc_set_phase_offset(osc *this, int offset);
void      osc_set_freq_offset(osc *this, int offset);
void      osc_delete(osc *this);




event *event_freq_change_new(int seq_handle,int freq);





/* this probably shouldn't be here, but it's used in oscillator.c */
#define RATE 44100



/*
  Local Variables:
  mode: font-lock
  End:
*/



