/* propertypanel.c generated by valac 0.40.8, the Vala compiler
 * generated from propertypanel.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2013-2016 Red Hat, Inc.
 * Copyright(c) 2013-2015 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2013-2017 Takao Fujiwara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <ibus.h>
#include <string.h>
#include <cairo.h>
#include <gdk/gdkx.h>
#include <stdlib.h>
#include <glib/gi18n-lib.h>


#define TYPE_PANEL_SHOW (panel_show_get_type ())

#define TYPE_PROPERTY_PANEL (property_panel_get_type ())
#define PROPERTY_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_PANEL, PropertyPanel))
#define PROPERTY_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_PANEL, PropertyPanelClass))
#define IS_PROPERTY_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_PANEL))
#define IS_PROPERTY_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_PANEL))
#define PROPERTY_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_PANEL, PropertyPanelClass))

typedef struct _PropertyPanel PropertyPanel;
typedef struct _PropertyPanelClass PropertyPanelClass;
typedef struct _PropertyPanelPrivate PropertyPanelPrivate;

#define TYPE_IPROP_TOOL_ITEM (iprop_tool_item_get_type ())
#define IPROP_TOOL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPROP_TOOL_ITEM, IPropToolItem))
#define IS_IPROP_TOOL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPROP_TOOL_ITEM))
#define IPROP_TOOL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPROP_TOOL_ITEM, IPropToolItemIface))

typedef struct _IPropToolItem IPropToolItem;
typedef struct _IPropToolItemIface IPropToolItemIface;
enum  {
	PROPERTY_PANEL_0_PROPERTY,
	PROPERTY_PANEL_NUM_PROPERTIES
};
static GParamSpec* property_panel_properties[PROPERTY_PANEL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_HANDLE (handle_get_type ())
#define HANDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HANDLE, Handle))
#define HANDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HANDLE, HandleClass))
#define IS_HANDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HANDLE))
#define IS_HANDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HANDLE))
#define HANDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HANDLE, HandleClass))

typedef struct _Handle Handle;
typedef struct _HandleClass HandleClass;

#define TYPE_PROP_TOGGLE_TOOL_BUTTON (prop_toggle_tool_button_get_type ())
#define PROP_TOGGLE_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROP_TOGGLE_TOOL_BUTTON, PropToggleToolButton))
#define PROP_TOGGLE_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROP_TOGGLE_TOOL_BUTTON, PropToggleToolButtonClass))
#define IS_PROP_TOGGLE_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROP_TOGGLE_TOOL_BUTTON))
#define IS_PROP_TOGGLE_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROP_TOGGLE_TOOL_BUTTON))
#define PROP_TOGGLE_TOOL_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROP_TOGGLE_TOOL_BUTTON, PropToggleToolButtonClass))

typedef struct _PropToggleToolButton PropToggleToolButton;
typedef struct _PropToggleToolButtonClass PropToggleToolButtonClass;

#define TYPE_PROP_MENU_TOOL_BUTTON (prop_menu_tool_button_get_type ())
#define PROP_MENU_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROP_MENU_TOOL_BUTTON, PropMenuToolButton))
#define PROP_MENU_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROP_MENU_TOOL_BUTTON, PropMenuToolButtonClass))
#define IS_PROP_MENU_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROP_MENU_TOOL_BUTTON))
#define IS_PROP_MENU_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROP_MENU_TOOL_BUTTON))
#define PROP_MENU_TOOL_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROP_MENU_TOOL_BUTTON, PropMenuToolButtonClass))

typedef struct _PropMenuToolButton PropMenuToolButton;
typedef struct _PropMenuToolButtonClass PropMenuToolButtonClass;

#define TYPE_PROP_TOOL_BUTTON (prop_tool_button_get_type ())
#define PROP_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROP_TOOL_BUTTON, PropToolButton))
#define PROP_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROP_TOOL_BUTTON, PropToolButtonClass))
#define IS_PROP_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROP_TOOL_BUTTON))
#define IS_PROP_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROP_TOOL_BUTTON))
#define PROP_TOOL_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROP_TOOL_BUTTON, PropToolButtonClass))

typedef struct _PropToolButton PropToolButton;
typedef struct _PropToolButtonClass PropToolButtonClass;

#define TYPE_PROP_SEPARATOR_TOOL_ITEM (prop_separator_tool_item_get_type ())
#define PROP_SEPARATOR_TOOL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROP_SEPARATOR_TOOL_ITEM, PropSeparatorToolItem))
#define PROP_SEPARATOR_TOOL_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROP_SEPARATOR_TOOL_ITEM, PropSeparatorToolItemClass))
#define IS_PROP_SEPARATOR_TOOL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROP_SEPARATOR_TOOL_ITEM))
#define IS_PROP_SEPARATOR_TOOL_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROP_SEPARATOR_TOOL_ITEM))
#define PROP_SEPARATOR_TOOL_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROP_SEPARATOR_TOOL_ITEM, PropSeparatorToolItemClass))

typedef struct _PropSeparatorToolItem PropSeparatorToolItem;
typedef struct _PropSeparatorToolItemClass PropSeparatorToolItemClass;
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	PROPERTY_PANEL_PROPERTY_ACTIVATE_SIGNAL,
	PROPERTY_PANEL_NUM_SIGNALS
};
static guint property_panel_signals[PROPERTY_PANEL_NUM_SIGNALS] = {0};
enum  {
	IPROP_TOOL_ITEM_PROPERTY_ACTIVATE_SIGNAL,
	IPROP_TOOL_ITEM_NUM_SIGNALS
};
static guint iprop_tool_item_signals[IPROP_TOOL_ITEM_NUM_SIGNALS] = {0};

#define TYPE_PROP_MENU (prop_menu_get_type ())
#define PROP_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROP_MENU, PropMenu))
#define PROP_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROP_MENU, PropMenuClass))
#define IS_PROP_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROP_MENU))
#define IS_PROP_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROP_MENU))
#define PROP_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROP_MENU, PropMenuClass))

typedef struct _PropMenu PropMenu;
typedef struct _PropMenuClass PropMenuClass;
typedef struct _PropMenuPrivate PropMenuPrivate;

#define TYPE_IPROP_ITEM (iprop_item_get_type ())
#define IPROP_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPROP_ITEM, IPropItem))
#define IS_IPROP_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPROP_ITEM))
#define IPROP_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPROP_ITEM, IPropItemIface))

typedef struct _IPropItem IPropItem;
typedef struct _IPropItemIface IPropItemIface;
enum  {
	PROP_MENU_0_PROPERTY,
	PROP_MENU_NUM_PROPERTIES
};
static GParamSpec* prop_menu_properties[PROP_MENU_NUM_PROPERTIES];

#define TYPE_PROP_RADIO_MENU_ITEM (prop_radio_menu_item_get_type ())
#define PROP_RADIO_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROP_RADIO_MENU_ITEM, PropRadioMenuItem))
#define PROP_RADIO_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROP_RADIO_MENU_ITEM, PropRadioMenuItemClass))
#define IS_PROP_RADIO_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROP_RADIO_MENU_ITEM))
#define IS_PROP_RADIO_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROP_RADIO_MENU_ITEM))
#define PROP_RADIO_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROP_RADIO_MENU_ITEM, PropRadioMenuItemClass))

typedef struct _PropRadioMenuItem PropRadioMenuItem;
typedef struct _PropRadioMenuItemClass PropRadioMenuItemClass;

#define TYPE_PROP_IMAGE_MENU_ITEM (prop_image_menu_item_get_type ())
#define PROP_IMAGE_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROP_IMAGE_MENU_ITEM, PropImageMenuItem))
#define PROP_IMAGE_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROP_IMAGE_MENU_ITEM, PropImageMenuItemClass))
#define IS_PROP_IMAGE_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROP_IMAGE_MENU_ITEM))
#define IS_PROP_IMAGE_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROP_IMAGE_MENU_ITEM))
#define PROP_IMAGE_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROP_IMAGE_MENU_ITEM, PropImageMenuItemClass))

typedef struct _PropImageMenuItem PropImageMenuItem;
typedef struct _PropImageMenuItemClass PropImageMenuItemClass;

#define TYPE_PROP_CHECK_MENU_ITEM (prop_check_menu_item_get_type ())
#define PROP_CHECK_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROP_CHECK_MENU_ITEM, PropCheckMenuItem))
#define PROP_CHECK_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROP_CHECK_MENU_ITEM, PropCheckMenuItemClass))
#define IS_PROP_CHECK_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROP_CHECK_MENU_ITEM))
#define IS_PROP_CHECK_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROP_CHECK_MENU_ITEM))
#define PROP_CHECK_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROP_CHECK_MENU_ITEM, PropCheckMenuItemClass))

typedef struct _PropCheckMenuItem PropCheckMenuItem;
typedef struct _PropCheckMenuItemClass PropCheckMenuItemClass;

#define TYPE_PROP_SEPARATOR_MENU_ITEM (prop_separator_menu_item_get_type ())
#define PROP_SEPARATOR_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROP_SEPARATOR_MENU_ITEM, PropSeparatorMenuItem))
#define PROP_SEPARATOR_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROP_SEPARATOR_MENU_ITEM, PropSeparatorMenuItemClass))
#define IS_PROP_SEPARATOR_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROP_SEPARATOR_MENU_ITEM))
#define IS_PROP_SEPARATOR_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROP_SEPARATOR_MENU_ITEM))
#define PROP_SEPARATOR_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROP_SEPARATOR_MENU_ITEM, PropSeparatorMenuItemClass))

typedef struct _PropSeparatorMenuItem PropSeparatorMenuItem;
typedef struct _PropSeparatorMenuItemClass PropSeparatorMenuItemClass;
typedef struct _PropToolButtonPrivate PropToolButtonPrivate;
enum  {
	PROP_TOOL_BUTTON_0_PROPERTY,
	PROP_TOOL_BUTTON_NUM_PROPERTIES
};
static GParamSpec* prop_tool_button_properties[PROP_TOOL_BUTTON_NUM_PROPERTIES];

#define TYPE_ICON_WIDGET (icon_widget_get_type ())
#define ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ICON_WIDGET, IconWidget))
#define ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ICON_WIDGET, IconWidgetClass))
#define IS_ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ICON_WIDGET))
#define IS_ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ICON_WIDGET))
#define ICON_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ICON_WIDGET, IconWidgetClass))

typedef struct _IconWidget IconWidget;
typedef struct _IconWidgetClass IconWidgetClass;
typedef struct _PropToggleToolButtonPrivate PropToggleToolButtonPrivate;
enum  {
	PROP_TOGGLE_TOOL_BUTTON_0_PROPERTY,
	PROP_TOGGLE_TOOL_BUTTON_NUM_PROPERTIES
};
static GParamSpec* prop_toggle_tool_button_properties[PROP_TOGGLE_TOOL_BUTTON_NUM_PROPERTIES];
typedef struct _PropMenuToolButtonPrivate PropMenuToolButtonPrivate;
enum  {
	PROP_MENU_TOOL_BUTTON_0_PROPERTY,
	PROP_MENU_TOOL_BUTTON_NUM_PROPERTIES
};
static GParamSpec* prop_menu_tool_button_properties[PROP_MENU_TOOL_BUTTON_NUM_PROPERTIES];
typedef struct _PropSeparatorToolItemPrivate PropSeparatorToolItemPrivate;
enum  {
	PROP_SEPARATOR_TOOL_ITEM_0_PROPERTY,
	PROP_SEPARATOR_TOOL_ITEM_NUM_PROPERTIES
};
static GParamSpec* prop_separator_tool_item_properties[PROP_SEPARATOR_TOOL_ITEM_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	PANEL_SHOW_DO_NOT_SHOW,
	PANEL_SHOW_AUTO_HIDE,
	PANEL_SHOW_ALWAYS
} PanelShow;

struct _PropertyPanel {
	GtkBox parent_instance;
	PropertyPanelPrivate * priv;
};

struct _PropertyPanelClass {
	GtkBoxClass parent_class;
};

struct _IPropToolItemIface {
	GTypeInterface parent_iface;
	void (*update_property) (IPropToolItem* self, IBusProperty* prop);
};

struct _PropertyPanelPrivate {
	GdkWindow* m_root_window;
	Display* m_xdisplay;
	GtkWindow* m_toplevel;
	IBusPropList* m_props;
	IPropToolItem** m_items;
	gint m_items_length1;
	gint _m_items_size_;
	GdkRectangle m_cursor_location;
	gint m_show;
	guint m_auto_hide_timeout;
	guint m_auto_hide_timeout_id;
	gboolean m_follow_input_cursor_when_always_shown;
	guint m_remove_filter_id;
};

struct _PropMenu {
	GtkMenu parent_instance;
	PropMenuPrivate * priv;
};

struct _PropMenuClass {
	GtkMenuClass parent_class;
};

struct _IPropItemIface {
	GTypeInterface parent_iface;
	void (*update_property) (IPropItem* self, IBusProperty* prop);
};

struct _PropMenuPrivate {
	GtkWidget* m_parent_button;
	IPropItem** m_items;
	gint m_items_length1;
	gint _m_items_size_;
};

struct _PropToolButton {
	GtkToolButton parent_instance;
	PropToolButtonPrivate * priv;
};

struct _PropToolButtonClass {
	GtkToolButtonClass parent_class;
};

struct _PropToolButtonPrivate {
	IBusProperty* m_prop;
};

struct _PropToggleToolButton {
	GtkToggleToolButton parent_instance;
	PropToggleToolButtonPrivate * priv;
};

struct _PropToggleToolButtonClass {
	GtkToggleToolButtonClass parent_class;
};

struct _PropToggleToolButtonPrivate {
	IBusProperty* m_prop;
};

struct _PropMenuToolButton {
	PropToggleToolButton parent_instance;
	PropMenuToolButtonPrivate * priv;
};

struct _PropMenuToolButtonClass {
	PropToggleToolButtonClass parent_class;
};

struct _PropMenuToolButtonPrivate {
	PropMenu* m_menu;
};

struct _PropSeparatorToolItem {
	GtkSeparatorToolItem parent_instance;
	PropSeparatorToolItemPrivate * priv;
};

struct _PropSeparatorToolItemClass {
	GtkSeparatorToolItemClass parent_class;
};


static gpointer property_panel_parent_class = NULL;
static gpointer prop_menu_parent_class = NULL;
static IPropToolItemIface * prop_menu_iprop_tool_item_parent_iface = NULL;
static gpointer prop_tool_button_parent_class = NULL;
static IPropToolItemIface * prop_tool_button_iprop_tool_item_parent_iface = NULL;
static gpointer prop_toggle_tool_button_parent_class = NULL;
static IPropToolItemIface * prop_toggle_tool_button_iprop_tool_item_parent_iface = NULL;
static gpointer prop_menu_tool_button_parent_class = NULL;
static IPropToolItemIface * prop_menu_tool_button_iprop_tool_item_parent_iface = NULL;
static gpointer prop_separator_tool_item_parent_class = NULL;
static IPropToolItemIface * prop_separator_tool_item_iprop_tool_item_parent_iface = NULL;

GType panel_show_get_type (void) G_GNUC_CONST;
GType property_panel_get_type (void) G_GNUC_CONST;
GType iprop_tool_item_get_type (void) G_GNUC_CONST;
#define PROPERTY_PANEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROPERTY_PANEL, PropertyPanelPrivate))
#define PROPERTY_PANEL_MONITOR_NET_WORKAREA_TIMEOUT ((guint) 300000)
PropertyPanel* property_panel_new (void);
PropertyPanel* property_panel_construct (GType object_type);
GType handle_get_type (void) G_GNUC_CONST;
Handle* handle_new (void);
Handle* handle_construct (GType object_type);
static void __lambda25_ (PropertyPanel* self,
                  GtkWidget* w,
                  GtkAllocation* a);
static void property_panel_set_default_location (PropertyPanel* self);
static void ___lambda25__gtk_widget_size_allocate (GtkWidget* _sender,
                                            GtkAllocation* allocation,
                                            gpointer self);
static void property_panel_monitor_net_workarea_atom (PropertyPanel* self);
void property_panel_set_properties (PropertyPanel* self,
                                    IBusPropList* props);
GType prop_toggle_tool_button_get_type (void) G_GNUC_CONST;
GType prop_menu_tool_button_get_type (void) G_GNUC_CONST;
static void property_panel_create_menu_items (PropertyPanel* self);
static void property_panel_show_with_auto_hide_timer (PropertyPanel* self);
void property_panel_update_property (PropertyPanel* self,
                                     IBusProperty* prop);
void iprop_tool_item_update_property (IPropToolItem* self,
                                      IBusProperty* prop);
void property_panel_set_cursor_location (PropertyPanel* self,
                                         gint x,
                                         gint y,
                                         gint width,
                                         gint height);
static gboolean _cairo_rectangle_int_equal (const cairo_rectangle_int_t * s1,
                                     const cairo_rectangle_int_t * s2);
static void property_panel_hide_if_necessary (PropertyPanel* self);
static void property_panel_adjust_window_position (PropertyPanel* self);
void property_panel_set_preedit_text (PropertyPanel* self,
                                      IBusText* text,
                                      guint cursor);
void property_panel_set_auxiliary_text (PropertyPanel* self,
                                        IBusText* text);
void property_panel_set_lookup_table (PropertyPanel* self,
                                      IBusLookupTable* table);
void property_panel_show (PropertyPanel* self);
void property_panel_hide (PropertyPanel* self);
void property_panel_focus_in (PropertyPanel* self);
void property_panel_set_show (PropertyPanel* self,
                              gint _show);
void property_panel_set_auto_hide_timeout (PropertyPanel* self,
                                           guint timeout);
void property_panel_set_follow_input_cursor_when_always_shown (PropertyPanel* self,
                                                               gboolean is_follow);
PropToolButton* prop_tool_button_new (IBusProperty* prop);
PropToolButton* prop_tool_button_construct (GType object_type,
                                            IBusProperty* prop);
GType prop_tool_button_get_type (void) G_GNUC_CONST;
PropToggleToolButton* prop_toggle_tool_button_new (IBusProperty* prop);
PropToggleToolButton* prop_toggle_tool_button_construct (GType object_type,
                                                         IBusProperty* prop);
PropMenuToolButton* prop_menu_tool_button_new (IBusProperty* prop);
PropMenuToolButton* prop_menu_tool_button_construct (GType object_type,
                                                     IBusProperty* prop);
PropSeparatorToolItem* prop_separator_tool_item_new (IBusProperty* prop);
PropSeparatorToolItem* prop_separator_tool_item_construct (GType object_type,
                                                           IBusProperty* prop);
GType prop_separator_tool_item_get_type (void) G_GNUC_CONST;
static void _vala_array_add23 (IPropToolItem** * array,
                        int* length,
                        int* size,
                        IPropToolItem* value);
static void ____lambda30_ (PropertyPanel* self,
                    IPropToolItem* w,
                    const gchar* k,
                    gint s);
static void _____lambda30__iprop_tool_item_property_activate (IPropToolItem* _sender,
                                                       const gchar* key,
                                                       gint state,
                                                       gpointer self);
static void property_panel_move (PropertyPanel* self,
                          gint x,
                          gint y);
static gboolean property_panel_is_bottom_panel (PropertyPanel* self);
static GdkFilterReturn property_panel_root_window_filter (PropertyPanel* self,
                                                   GdkXEvent* gdkxevent,
                                                   GdkEvent* event);
static GdkFilterReturn _property_panel_root_window_filter_gdk_filter_func (GdkXEvent* xevent,
                                                                    GdkEvent* event,
                                                                    gpointer self);
static gboolean __lambda26_ (PropertyPanel* self);
static gboolean ___lambda26__gsource_func (gpointer self);
static gboolean __lambda31_ (PropertyPanel* self);
static gboolean ___lambda31__gsource_func (gpointer self);
static void g_cclosure_user_marshal_VOID__STRING_INT (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data);
static void property_panel_finalize (GObject * obj);
GType prop_menu_get_type (void) G_GNUC_CONST;
GType iprop_item_get_type (void) G_GNUC_CONST;
#define PROP_MENU_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROP_MENU, PropMenuPrivate))
PropMenu* prop_menu_new (IBusProperty* prop);
PropMenu* prop_menu_construct (GType object_type,
                               IBusProperty* prop);
static void prop_menu_create_items (PropMenu* self,
                             IBusPropList* props);
static void prop_menu_real_update_property (IPropToolItem* base,
                                     IBusProperty* prop);
void iprop_item_update_property (IPropItem* self,
                                 IBusProperty* prop);
void prop_menu_popup (PropMenu* self,
                      guint button,
                      guint32 activate_time,
                      GtkWidget* widget);
static void prop_menu_real_destroy (GtkWidget* base);
GType prop_radio_menu_item_get_type (void) G_GNUC_CONST;
PropImageMenuItem* prop_image_menu_item_new (IBusProperty* property);
PropImageMenuItem* prop_image_menu_item_construct (GType object_type,
                                                   IBusProperty* property);
GType prop_image_menu_item_get_type (void) G_GNUC_CONST;
PropCheckMenuItem* prop_check_menu_item_new (IBusProperty* property);
PropCheckMenuItem* prop_check_menu_item_construct (GType object_type,
                                                   IBusProperty* property);
GType prop_check_menu_item_get_type (void) G_GNUC_CONST;
PropRadioMenuItem* prop_radio_menu_item_new (IBusProperty* property,
                                             PropRadioMenuItem* group_source);
PropRadioMenuItem* prop_radio_menu_item_construct (GType object_type,
                                                   IBusProperty* property,
                                                   PropRadioMenuItem* group_source);
PropSeparatorMenuItem* prop_separator_menu_item_new (IBusProperty* property);
PropSeparatorMenuItem* prop_separator_menu_item_construct (GType object_type,
                                                           IBusProperty* property);
GType prop_separator_menu_item_get_type (void) G_GNUC_CONST;
static void ____lambda27_ (PropMenu* self,
                    IPropItem* w,
                    const gchar* k,
                    gint s);
static void _____lambda27__iprop_item_property_activate (IPropItem* _sender,
                                                  const gchar* key,
                                                  gint state,
                                                  gpointer self);
static void _vala_array_add24 (IPropItem** * array,
                        int* length,
                        int* size,
                        IPropItem* value);
static void prop_menu_finalize (GObject * obj);
#define PROP_TOOL_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROP_TOOL_BUTTON, PropToolButtonPrivate))
static void prop_tool_button_sync (PropToolButton* self);
static void prop_tool_button_real_update_property (IPropToolItem* base,
                                            IBusProperty* prop);
void prop_tool_button_set_icon_name (PropToolButton* self,
                                     const gchar* icon_name);
static void prop_tool_button_real_clicked (GtkToolButton* base);
GType icon_widget_get_type (void) G_GNUC_CONST;
IconWidget* icon_widget_new (const gchar* icon_name_or_path,
                             GtkIconSize size);
IconWidget* icon_widget_construct (GType object_type,
                                   const gchar* icon_name_or_path,
                                   GtkIconSize size);
static void prop_tool_button_finalize (GObject * obj);
#define PROP_TOGGLE_TOOL_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROP_TOGGLE_TOOL_BUTTON, PropToggleToolButtonPrivate))
static void prop_toggle_tool_button_sync (PropToggleToolButton* self);
void prop_toggle_tool_button_set_property (PropToggleToolButton* self,
                                           IBusProperty* prop);
static void prop_toggle_tool_button_real_update_property (IPropToolItem* base,
                                                   IBusProperty* prop);
void prop_toggle_tool_button_set_icon_name (PropToggleToolButton* self,
                                            const gchar* icon_name);
static void prop_toggle_tool_button_real_toggled (GtkToggleToolButton* base);
static void prop_toggle_tool_button_finalize (GObject * obj);
#define PROP_MENU_TOOL_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROP_MENU_TOOL_BUTTON, PropMenuToolButtonPrivate))
static void __lambda28_ (PropMenuToolButton* self,
                  GtkMenuShell* m);
static void ___lambda28__gtk_menu_shell_deactivate (GtkMenuShell* _sender,
                                             gpointer self);
static void __lambda29_ (PropMenuToolButton* self,
                  const gchar* k,
                  gint s);
static void ___lambda29__iprop_tool_item_property_activate (IPropToolItem* _sender,
                                                     const gchar* key,
                                                     gint state,
                                                     gpointer self);
static void prop_menu_tool_button_real_update_property (IPropToolItem* base,
                                                 IBusProperty* prop);
static void prop_menu_tool_button_real_toggled (GtkToggleToolButton* base);
static void prop_menu_tool_button_real_destroy (GtkWidget* base);
static void prop_menu_tool_button_finalize (GObject * obj);
static void prop_separator_tool_item_real_update_property (IPropToolItem* base,
                                                    IBusProperty* prop);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


GType
panel_show_get_type (void)
{
	static volatile gsize panel_show_type_id__volatile = 0;
	if (g_once_init_enter (&panel_show_type_id__volatile)) {
		static const GEnumValue values[] = {{PANEL_SHOW_DO_NOT_SHOW, "PANEL_SHOW_DO_NOT_SHOW", "do-not-show"}, {PANEL_SHOW_AUTO_HIDE, "PANEL_SHOW_AUTO_HIDE", "auto-hide"}, {PANEL_SHOW_ALWAYS, "PANEL_SHOW_ALWAYS", "always"}, {0, NULL, NULL}};
		GType panel_show_type_id;
		panel_show_type_id = g_enum_register_static ("PanelShow", values);
		g_once_init_leave (&panel_show_type_id__volatile, panel_show_type_id);
	}
	return panel_show_type_id__volatile;
}


static void
__lambda25_ (PropertyPanel* self,
             GtkWidget* w,
             GtkAllocation* a)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	g_return_if_fail (w != NULL);
	g_return_if_fail (a != NULL);
	_tmp4_ = self->priv->m_follow_input_cursor_when_always_shown;
	if (!_tmp4_) {
		gint _tmp5_;
		_tmp5_ = self->priv->m_show;
		_tmp3_ = _tmp5_ == ((gint) PANEL_SHOW_ALWAYS);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		IPropToolItem** _tmp6_;
		gint _tmp6__length1;
		_tmp6_ = self->priv->m_items;
		_tmp6__length1 = self->priv->m_items_length1;
		_tmp2_ = _tmp6__length1 > 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GdkRectangle _tmp7_;
		gint _tmp8_;
		_tmp7_ = self->priv->m_cursor_location;
		_tmp8_ = _tmp7_.x;
		_tmp1_ = _tmp8_ == -1;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GdkRectangle _tmp9_;
		gint _tmp10_;
		_tmp9_ = self->priv->m_cursor_location;
		_tmp10_ = _tmp9_.y;
		_tmp0_ = _tmp10_ == -1;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		property_panel_set_default_location (self);
		self->priv->m_cursor_location.x = 0;
		self->priv->m_cursor_location.y = 0;
	}
}


static void
___lambda25__gtk_widget_size_allocate (GtkWidget* _sender,
                                       GtkAllocation* allocation,
                                       gpointer self)
{
	__lambda25_ ((PropertyPanel*) self, _sender, allocation);
}


PropertyPanel*
property_panel_construct (GType object_type)
{
	PropertyPanel * self = NULL;
	GdkWindow* _tmp0_;
	GdkDisplay* display = NULL;
	GdkWindow* _tmp1_;
	GdkDisplay* _tmp2_;
	Display* _tmp3_;
	GtkWindow* _tmp4_;
	GtkWindow* _tmp5_;
	Handle* handle = NULL;
	Handle* _tmp6_;
	GtkWindow* _tmp7_;
	GtkWindow* _tmp8_;
	self = (PropertyPanel*) g_object_new (object_type, "orientation", GTK_ORIENTATION_HORIZONTAL, "spacing", 0, NULL);
	gtk_widget_set_visible ((GtkWidget*) self, TRUE);
	_tmp0_ = gdk_get_default_root_window ();
	self->priv->m_root_window = _tmp0_;
	_tmp1_ = self->priv->m_root_window;
	_tmp2_ = gdk_window_get_display (_tmp1_);
	display = _tmp2_;
	_tmp3_ = gdk_x11_display_get_xdisplay (G_TYPE_CHECK_INSTANCE_TYPE (display, gdk_x11_display_get_type ()) ? ((GdkX11Display*) display) : NULL);
	self->priv->m_xdisplay = _tmp3_;
	_tmp4_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_POPUP);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->m_toplevel);
	self->priv->m_toplevel = _tmp4_;
	_tmp5_ = self->priv->m_toplevel;
	gtk_widget_add_events ((GtkWidget*) _tmp5_, (gint) GDK_BUTTON_PRESS_MASK);
	_tmp6_ = handle_new ();
	g_object_ref_sink (_tmp6_);
	handle = _tmp6_;
	gtk_widget_set_visible ((GtkWidget*) handle, TRUE);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) handle, FALSE, FALSE, (guint) 0);
	_tmp7_ = self->priv->m_toplevel;
	gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) self);
	_tmp8_ = self->priv->m_toplevel;
	g_signal_connect_object ((GtkWidget*) _tmp8_, "size-allocate", (GCallback) ___lambda25__gtk_widget_size_allocate, self, 0);
	property_panel_monitor_net_workarea_atom (self);
	_g_object_unref0 (handle);
	return self;
}


PropertyPanel*
property_panel_new (void)
{
	return property_panel_construct (TYPE_PROPERTY_PANEL);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


void
property_panel_set_properties (PropertyPanel* self,
                               IBusPropList* props)
{
	gboolean has_active = FALSE;
	IPropToolItem** _tmp0_;
	gint _tmp0__length1;
	gboolean _tmp7_;
	IPropToolItem** _tmp8_;
	gint _tmp8__length1;
	IPropToolItem** _tmp11_;
	IBusPropList* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (props != NULL);
	g_debug ("propertypanel.vala:87: set_properties()\n");
	has_active = FALSE;
	_tmp0_ = self->priv->m_items;
	_tmp0__length1 = self->priv->m_items_length1;
	{
		IPropToolItem** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = _tmp0_;
		item_collection_length1 = _tmp0__length1;
		for (item_it = 0; item_it < _tmp0__length1; item_it = item_it + 1) {
			IPropToolItem* _tmp1_;
			IPropToolItem* item = NULL;
			_tmp1_ = _g_object_ref0 (item_collection[item_it]);
			item = _tmp1_;
			{
				GType type = 0UL;
				IPropToolItem* _tmp2_;
				gboolean _tmp3_ = FALSE;
				GType _tmp4_;
				_tmp2_ = item;
				type = G_TYPE_FROM_INSTANCE ((GObject*) _tmp2_);
				_tmp4_ = type;
				if (_tmp4_ == TYPE_PROP_MENU_TOOL_BUTTON) {
					_tmp3_ = TRUE;
				} else {
					GType _tmp5_;
					_tmp5_ = type;
					_tmp3_ = _tmp5_ == TYPE_PROP_TOGGLE_TOOL_BUTTON;
				}
				if (_tmp3_) {
					IPropToolItem* _tmp6_;
					_tmp6_ = item;
					if (gtk_toggle_tool_button_get_active (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gtk_toggle_tool_button_get_type ()) ? ((GtkToggleToolButton*) _tmp6_) : NULL)) {
						has_active = TRUE;
						_g_object_unref0 (item);
						break;
					}
				}
				_g_object_unref0 (item);
			}
		}
	}
	_tmp7_ = has_active;
	if (_tmp7_) {
		return;
	}
	_tmp8_ = self->priv->m_items;
	_tmp8__length1 = self->priv->m_items_length1;
	{
		IPropToolItem** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = _tmp8_;
		item_collection_length1 = _tmp8__length1;
		for (item_it = 0; item_it < _tmp8__length1; item_it = item_it + 1) {
			IPropToolItem* _tmp9_;
			IPropToolItem* item = NULL;
			_tmp9_ = _g_object_ref0 (item_collection[item_it]);
			item = _tmp9_;
			{
				IPropToolItem* _tmp10_;
				_tmp10_ = item;
				gtk_container_remove ((GtkContainer*) self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp10_) : NULL);
				_g_object_unref0 (item);
			}
		}
	}
	_tmp11_ = g_new0 (IPropToolItem*, 0 + 1);
	self->priv->m_items = (_vala_array_free (self->priv->m_items, self->priv->m_items_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_items = _tmp11_;
	self->priv->m_items_length1 = 0;
	self->priv->_m_items_size_ = self->priv->m_items_length1;
	_tmp12_ = _g_object_ref0 (props);
	_g_object_unref0 (self->priv->m_props);
	self->priv->m_props = _tmp12_;
	property_panel_create_menu_items (self);
	property_panel_show_with_auto_hide_timer (self);
}


void
property_panel_update_property (PropertyPanel* self,
                                IBusProperty* prop)
{
	const gchar* _tmp0_;
	IBusPropList* _tmp1_;
	IPropToolItem** _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prop != NULL);
	_vala_assert (prop != NULL, "prop != null");
	_tmp0_ = ibus_property_get_key (prop);
	g_debug ("propertypanel.vala:125: update_property(prop.key = %s)\n", _tmp0_);
	_tmp1_ = self->priv->m_props;
	if (_tmp1_ != NULL) {
		IBusPropList* _tmp2_;
		_tmp2_ = self->priv->m_props;
		ibus_prop_list_update_property (_tmp2_, prop);
	}
	_tmp3_ = self->priv->m_items;
	_tmp3__length1 = self->priv->m_items_length1;
	{
		IPropToolItem** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = _tmp3_;
		item_collection_length1 = _tmp3__length1;
		for (item_it = 0; item_it < _tmp3__length1; item_it = item_it + 1) {
			IPropToolItem* _tmp4_;
			IPropToolItem* item = NULL;
			_tmp4_ = _g_object_ref0 (item_collection[item_it]);
			item = _tmp4_;
			{
				IPropToolItem* _tmp5_;
				_tmp5_ = item;
				iprop_tool_item_update_property (_tmp5_, prop);
				_g_object_unref0 (item);
			}
		}
	}
	property_panel_show_with_auto_hide_timer (self);
}


static gboolean
_cairo_rectangle_int_equal (const cairo_rectangle_int_t * s1,
                            const cairo_rectangle_int_t * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->x != s2->x) {
		return FALSE;
	}
	if (s1->y != s2->y) {
		return FALSE;
	}
	if (s1->width != s2->width) {
		return FALSE;
	}
	if (s1->height != s2->height) {
		return FALSE;
	}
	return TRUE;
}


void
property_panel_set_cursor_location (PropertyPanel* self,
                                    gint x,
                                    gint y,
                                    gint width,
                                    gint height)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GdkRectangle location = {0};
	GdkRectangle _tmp3_ = {0};
	GdkRectangle _tmp4_;
	GdkRectangle _tmp5_;
	gint _tmp6_;
	GdkRectangle _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->m_follow_input_cursor_when_always_shown;
	if (!_tmp1_) {
		gint _tmp2_;
		_tmp2_ = self->priv->m_show;
		_tmp0_ = _tmp2_ == ((gint) PANEL_SHOW_ALWAYS);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	memset (&_tmp3_, 0, sizeof (GdkRectangle));
	_tmp3_.x = x;
	_tmp3_.y = y;
	_tmp3_.width = width;
	_tmp3_.height = height;
	location = _tmp3_;
	_tmp4_ = self->priv->m_cursor_location;
	_tmp5_ = location;
	if (_cairo_rectangle_int_equal (&_tmp4_, &_tmp5_) == TRUE) {
		return;
	}
	g_debug ("propertypanel.vala:166: set_cursor_location(x = %d, y = %d, width = %d" \
", height = %d)\n", x, y, width, height);
	_tmp6_ = self->priv->m_show;
	if (_tmp6_ == ((gint) PANEL_SHOW_AUTO_HIDE)) {
		gboolean _tmp7_ = FALSE;
		GdkRectangle _tmp8_;
		gint _tmp9_;
		_tmp8_ = self->priv->m_cursor_location;
		_tmp9_ = _tmp8_.x;
		if (_tmp9_ != -1) {
			_tmp7_ = TRUE;
		} else {
			GdkRectangle _tmp10_;
			gint _tmp11_;
			_tmp10_ = self->priv->m_cursor_location;
			_tmp11_ = _tmp10_.y;
			_tmp7_ = _tmp11_ != -1;
		}
		if (_tmp7_) {
			GdkRectangle _tmp12_;
			_tmp12_ = location;
			self->priv->m_cursor_location = _tmp12_;
			property_panel_hide_if_necessary (self);
			property_panel_adjust_window_position (self);
			return;
		}
	}
	_tmp13_ = location;
	self->priv->m_cursor_location = _tmp13_;
	property_panel_adjust_window_position (self);
	property_panel_show_with_auto_hide_timer (self);
}


void
property_panel_set_preedit_text (PropertyPanel* self,
                                 IBusText* text,
                                 guint cursor)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (text == NULL) {
		_tmp0_ = cursor == ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	g_debug ("propertypanel.vala:190: set_preedit_text(text, cursor = %u)\n", cursor);
	property_panel_hide_if_necessary (self);
}


void
property_panel_set_auxiliary_text (PropertyPanel* self,
                                   IBusText* text)
{
	g_return_if_fail (self != NULL);
	if (text == NULL) {
		return;
	}
	g_debug ("propertypanel.vala:202: set_auxiliary_text(text)\n");
	property_panel_hide_if_necessary (self);
}


void
property_panel_set_lookup_table (PropertyPanel* self,
                                 IBusLookupTable* table)
{
	g_return_if_fail (self != NULL);
	if (table == NULL) {
		return;
	}
	g_debug ("propertypanel.vala:211: set_lookup_table(table)\n");
	property_panel_hide_if_necessary (self);
}


void
property_panel_show (PropertyPanel* self)
{
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_show;
	if (_tmp0_ == ((gint) PANEL_SHOW_DO_NOT_SHOW)) {
		GtkWindow* _tmp1_;
		_tmp1_ = self->priv->m_toplevel;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
		return;
	} else {
		gint _tmp2_;
		_tmp2_ = self->priv->m_show;
		if (_tmp2_ == ((gint) PANEL_SHOW_ALWAYS)) {
			GtkWindow* _tmp3_;
			_tmp3_ = self->priv->m_toplevel;
			gtk_widget_show_all ((GtkWidget*) _tmp3_);
			return;
		}
	}
}


void
property_panel_hide (PropertyPanel* self)
{
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_toplevel;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}


void
property_panel_focus_in (PropertyPanel* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_debug ("propertypanel.vala:236: focus_in()\n");
	property_panel_hide_if_necessary (self);
	_tmp1_ = self->priv->m_follow_input_cursor_when_always_shown;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp2_;
		_tmp2_ = self->priv->m_show;
		_tmp0_ = _tmp2_ != ((gint) PANEL_SHOW_ALWAYS);
	}
	if (_tmp0_) {
		GdkRectangle _tmp3_ = {0};
		_tmp3_.x = -1;
		_tmp3_.y = -1;
		_tmp3_.width = 0;
		_tmp3_.height = 0;
		self->priv->m_cursor_location = _tmp3_;
	}
}


void
property_panel_set_show (PropertyPanel* self,
                         gint _show)
{
	g_return_if_fail (self != NULL);
	self->priv->m_show = _show;
	property_panel_show (self);
}


void
property_panel_set_auto_hide_timeout (PropertyPanel* self,
                                      guint timeout)
{
	g_return_if_fail (self != NULL);
	self->priv->m_auto_hide_timeout = timeout;
}


void
property_panel_set_follow_input_cursor_when_always_shown (PropertyPanel* self,
                                                          gboolean is_follow)
{
	g_return_if_fail (self != NULL);
	self->priv->m_follow_input_cursor_when_always_shown = is_follow;
}


static void
_vala_array_add23 (IPropToolItem** * array,
                   int* length,
                   int* size,
                   IPropToolItem* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (IPropToolItem*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
____lambda30_ (PropertyPanel* self,
               IPropToolItem* w,
               const gchar* k,
               gint s)
{
	g_return_if_fail (w != NULL);
	g_return_if_fail (k != NULL);
	g_signal_emit (self, property_panel_signals[PROPERTY_PANEL_PROPERTY_ACTIVATE_SIGNAL], 0, k, s);
}


static void
_____lambda30__iprop_tool_item_property_activate (IPropToolItem* _sender,
                                                  const gchar* key,
                                                  gint state,
                                                  gpointer self)
{
	____lambda30_ ((PropertyPanel*) self, _sender, key, state);
}


static void
property_panel_create_menu_items (PropertyPanel* self)
{
	gint i = 0;
	g_return_if_fail (self != NULL);
	i = 0;
	while (TRUE) {
		IBusProperty* prop = NULL;
		IBusPropList* _tmp0_;
		gint _tmp1_;
		IBusProperty* _tmp2_;
		IBusProperty* _tmp3_;
		IBusProperty* _tmp4_;
		gint _tmp5_;
		IPropToolItem* item = NULL;
		IBusProperty* _tmp6_;
		IPropToolItem* _tmp16_;
		_tmp0_ = self->priv->m_props;
		_tmp1_ = i;
		_tmp2_ = ibus_prop_list_get (_tmp0_, (guint) _tmp1_);
		_tmp3_ = _g_object_ref0 (_tmp2_);
		prop = _tmp3_;
		_tmp4_ = prop;
		if (_tmp4_ == NULL) {
			_g_object_unref0 (prop);
			break;
		}
		_tmp5_ = i;
		i = _tmp5_ + 1;
		item = NULL;
		_tmp6_ = prop;
		switch (ibus_property_get_prop_type (_tmp6_)) {
			case PROP_TYPE_NORMAL:
			{
				IBusProperty* _tmp7_;
				PropToolButton* _tmp8_;
				_tmp7_ = prop;
				_tmp8_ = prop_tool_button_new (_tmp7_);
				g_object_ref_sink (_tmp8_);
				_g_object_unref0 (item);
				item = (IPropToolItem*) _tmp8_;
				break;
			}
			case PROP_TYPE_TOGGLE:
			{
				IBusProperty* _tmp9_;
				PropToggleToolButton* _tmp10_;
				_tmp9_ = prop;
				_tmp10_ = prop_toggle_tool_button_new (_tmp9_);
				g_object_ref_sink (_tmp10_);
				_g_object_unref0 (item);
				item = (IPropToolItem*) _tmp10_;
				break;
			}
			case PROP_TYPE_MENU:
			{
				IBusProperty* _tmp11_;
				PropMenuToolButton* _tmp12_;
				_tmp11_ = prop;
				_tmp12_ = prop_menu_tool_button_new (_tmp11_);
				g_object_ref_sink (_tmp12_);
				_g_object_unref0 (item);
				item = (IPropToolItem*) _tmp12_;
				break;
			}
			case PROP_TYPE_SEPARATOR:
			{
				IBusProperty* _tmp13_;
				PropSeparatorToolItem* _tmp14_;
				_tmp13_ = prop;
				_tmp14_ = prop_separator_tool_item_new (_tmp13_);
				g_object_ref_sink (_tmp14_);
				_g_object_unref0 (item);
				item = (IPropToolItem*) _tmp14_;
				break;
			}
			default:
			{
				IBusProperty* _tmp15_;
				_tmp15_ = prop;
				g_warning ("propertypanel.vala:289: unknown property type %d", (gint) ibus_property_get_prop_type (_tmp15_));
				break;
			}
		}
		_tmp16_ = item;
		if (_tmp16_ != NULL) {
			IPropToolItem* _tmp17_;
			IPropToolItem** _tmp18_;
			gint _tmp18__length1;
			IPropToolItem* _tmp19_;
			IPropToolItem* _tmp20_;
			IPropToolItem* _tmp21_;
			_tmp17_ = item;
			gtk_box_pack_start ((GtkBox*) self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp17_) : NULL, FALSE, FALSE, (guint) 0);
			_tmp18_ = self->priv->m_items;
			_tmp18__length1 = self->priv->m_items_length1;
			_tmp19_ = item;
			_tmp20_ = _g_object_ref0 (_tmp19_);
			_vala_array_add23 (&self->priv->m_items, &self->priv->m_items_length1, &self->priv->_m_items_size_, _tmp20_);
			_tmp21_ = item;
			g_signal_connect_object (_tmp21_, "property-activate", (GCallback) _____lambda30__iprop_tool_item_property_activate, self, 0);
		}
		_g_object_unref0 (item);
		_g_object_unref0 (prop);
	}
}


static void
property_panel_move (PropertyPanel* self,
                     gint x,
                     gint y)
{
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_toplevel;
	gtk_window_move (_tmp0_, x, y);
}


static void
property_panel_adjust_window_position (PropertyPanel* self)
{
	GdkPoint cursor_right_bottom = {0};
	GdkRectangle _tmp0_;
	gint _tmp1_;
	GdkRectangle _tmp2_;
	gint _tmp3_;
	GdkRectangle _tmp4_;
	gint _tmp5_;
	GdkRectangle _tmp6_;
	gint _tmp7_;
	GdkPoint _tmp8_ = {0};
	GtkAllocation allocation = {0};
	GtkWindow* _tmp9_;
	GtkAllocation _tmp10_ = {0};
	GdkPoint window_right_bottom = {0};
	GdkPoint _tmp11_;
	gint _tmp12_;
	GtkAllocation _tmp13_;
	gint _tmp14_;
	GdkPoint _tmp15_;
	gint _tmp16_;
	GtkAllocation _tmp17_;
	gint _tmp18_;
	GdkPoint _tmp19_ = {0};
	gint root_width = 0;
	GdkWindow* _tmp20_;
	gint root_height = 0;
	GdkWindow* _tmp21_;
	gint x = 0;
	gint y = 0;
	GdkPoint _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	GdkPoint _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gint _tmp39_;
	gint _tmp40_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_cursor_location;
	_tmp1_ = _tmp0_.x;
	_tmp2_ = self->priv->m_cursor_location;
	_tmp3_ = _tmp2_.width;
	_tmp4_ = self->priv->m_cursor_location;
	_tmp5_ = _tmp4_.y;
	_tmp6_ = self->priv->m_cursor_location;
	_tmp7_ = _tmp6_.height;
	_tmp8_.x = _tmp1_ + _tmp3_;
	_tmp8_.y = _tmp5_ + _tmp7_;
	cursor_right_bottom = _tmp8_;
	_tmp9_ = self->priv->m_toplevel;
	gtk_widget_get_allocation ((GtkWidget*) _tmp9_, &_tmp10_);
	allocation = _tmp10_;
	_tmp11_ = cursor_right_bottom;
	_tmp12_ = _tmp11_.x;
	_tmp13_ = allocation;
	_tmp14_ = _tmp13_.width;
	_tmp15_ = cursor_right_bottom;
	_tmp16_ = _tmp15_.y;
	_tmp17_ = allocation;
	_tmp18_ = _tmp17_.height;
	_tmp19_.x = _tmp12_ + _tmp14_;
	_tmp19_.y = _tmp16_ + _tmp18_;
	window_right_bottom = _tmp19_;
	_tmp20_ = self->priv->m_root_window;
	root_width = gdk_window_get_width (_tmp20_);
	_tmp21_ = self->priv->m_root_window;
	root_height = gdk_window_get_height (_tmp21_);
	_tmp22_ = window_right_bottom;
	_tmp23_ = _tmp22_.x;
	_tmp24_ = root_width;
	if (_tmp23_ > _tmp24_) {
		gint _tmp25_;
		GtkAllocation _tmp26_;
		gint _tmp27_;
		_tmp25_ = root_width;
		_tmp26_ = allocation;
		_tmp27_ = _tmp26_.width;
		x = _tmp25_ - _tmp27_;
	} else {
		GdkPoint _tmp28_;
		gint _tmp29_;
		_tmp28_ = cursor_right_bottom;
		_tmp29_ = _tmp28_.x;
		x = _tmp29_;
	}
	_tmp30_ = window_right_bottom;
	_tmp31_ = _tmp30_.y;
	_tmp32_ = root_height;
	if (_tmp31_ > _tmp32_) {
		GdkRectangle _tmp33_;
		gint _tmp34_;
		GtkAllocation _tmp35_;
		gint _tmp36_;
		_tmp33_ = self->priv->m_cursor_location;
		_tmp34_ = _tmp33_.y;
		_tmp35_ = allocation;
		_tmp36_ = _tmp35_.height;
		y = _tmp34_ - _tmp36_;
	} else {
		GdkPoint _tmp37_;
		gint _tmp38_;
		_tmp37_ = cursor_right_bottom;
		_tmp38_ = _tmp37_.y;
		y = _tmp38_;
	}
	_tmp39_ = x;
	_tmp40_ = y;
	property_panel_move (self, _tmp39_, _tmp40_);
}


static gboolean
property_panel_is_bottom_panel (PropertyPanel* self)
{
	gboolean result = FALSE;
	gchar* desktop = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GQuark _tmp8_ = 0U;
	static GQuark _tmp7_label0 = 0;
	static GQuark _tmp7_label1 = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_getenv ("XDG_CURRENT_DESKTOP");
	_tmp1_ = g_strdup (_tmp0_);
	desktop = _tmp1_;
	_tmp2_ = desktop;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = g_getenv ("XDG_SESSION_DESKTOP");
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (desktop);
		desktop = _tmp4_;
	}
	_tmp5_ = desktop;
	_tmp6_ = _tmp5_;
	_tmp8_ = (NULL == _tmp6_) ? 0 : g_quark_from_string (_tmp6_);
	if (_tmp8_ == ((0 != _tmp7_label0) ? _tmp7_label0 : (_tmp7_label0 = g_quark_from_static_string ("KDE")))) {
		switch (0) {
			default:
			{
				result = TRUE;
				_g_free0 (desktop);
				return result;
			}
		}
	} else if (_tmp8_ == ((0 != _tmp7_label1) ? _tmp7_label1 : (_tmp7_label1 = g_quark_from_static_string ("LXDE")))) {
		switch (0) {
			default:
			{
				result = TRUE;
				_g_free0 (desktop);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = FALSE;
				_g_free0 (desktop);
				return result;
			}
		}
	}
	_g_free0 (desktop);
}


static void
property_panel_set_default_location (PropertyPanel* self)
{
	GtkAllocation allocation = {0};
	GtkWindow* _tmp0_;
	GtkAllocation _tmp1_ = {0};
	GdkRectangle monitor_area = {0};
	GdkMonitor* monitor = NULL;
	GdkDisplay* _tmp2_;
	GdkMonitor* _tmp3_;
	GdkMonitor* _tmp4_;
	GdkMonitor* _tmp5_;
	GdkRectangle _tmp6_ = {0};
	gint monitor_right = 0;
	GdkRectangle _tmp7_;
	gint _tmp8_;
	GdkRectangle _tmp9_;
	gint _tmp10_;
	gint monitor_bottom = 0;
	GdkRectangle _tmp11_;
	gint _tmp12_;
	GdkRectangle _tmp13_;
	gint _tmp14_;
	gint x = 0;
	gint y = 0;
	gint _tmp35_;
	gint _tmp36_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_toplevel;
	gtk_widget_get_allocation ((GtkWidget*) _tmp0_, &_tmp1_);
	allocation = _tmp1_;
	_tmp2_ = gdk_display_get_default ();
	_tmp3_ = gdk_display_get_monitor (_tmp2_, 0);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	monitor = _tmp4_;
	_tmp5_ = monitor;
	gdk_monitor_get_workarea (_tmp5_, &_tmp6_);
	monitor_area = _tmp6_;
	_tmp7_ = monitor_area;
	_tmp8_ = _tmp7_.x;
	_tmp9_ = monitor_area;
	_tmp10_ = _tmp9_.width;
	monitor_right = _tmp8_ + _tmp10_;
	_tmp11_ = monitor_area;
	_tmp12_ = _tmp11_.y;
	_tmp13_ = monitor_area;
	_tmp14_ = _tmp13_.height;
	monitor_bottom = _tmp12_ + _tmp14_;
	if (property_panel_is_bottom_panel (self)) {
		if (g_strcmp0 (_ ("default:LTR"), "default:RTL") != 0) {
			gint _tmp15_;
			GtkAllocation _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			GtkAllocation _tmp19_;
			gint _tmp20_;
			_tmp15_ = monitor_right;
			_tmp16_ = allocation;
			_tmp17_ = _tmp16_.width;
			x = _tmp15_ - _tmp17_;
			_tmp18_ = monitor_bottom;
			_tmp19_ = allocation;
			_tmp20_ = _tmp19_.height;
			y = _tmp18_ - _tmp20_;
		} else {
			GdkRectangle _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			GtkAllocation _tmp24_;
			gint _tmp25_;
			_tmp21_ = monitor_area;
			_tmp22_ = _tmp21_.x;
			x = _tmp22_;
			_tmp23_ = monitor_bottom;
			_tmp24_ = allocation;
			_tmp25_ = _tmp24_.height;
			y = _tmp23_ - _tmp25_;
		}
	} else {
		if (g_strcmp0 (_ ("default:LTR"), "default:RTL") != 0) {
			gint _tmp26_;
			GtkAllocation _tmp27_;
			gint _tmp28_;
			GdkRectangle _tmp29_;
			gint _tmp30_;
			_tmp26_ = monitor_right;
			_tmp27_ = allocation;
			_tmp28_ = _tmp27_.width;
			x = _tmp26_ - _tmp28_;
			_tmp29_ = monitor_area;
			_tmp30_ = _tmp29_.y;
			y = _tmp30_;
		} else {
			GdkRectangle _tmp31_;
			gint _tmp32_;
			GdkRectangle _tmp33_;
			gint _tmp34_;
			_tmp31_ = monitor_area;
			_tmp32_ = _tmp31_.x;
			x = _tmp32_;
			_tmp33_ = monitor_area;
			_tmp34_ = _tmp33_.y;
			y = _tmp34_;
		}
	}
	_tmp35_ = x;
	_tmp36_ = y;
	property_panel_move (self, _tmp35_, _tmp36_);
	_g_object_unref0 (monitor);
}


static GdkFilterReturn
_property_panel_root_window_filter_gdk_filter_func (GdkXEvent* xevent,
                                                    GdkEvent* event,
                                                    gpointer self)
{
	GdkFilterReturn result;
	result = property_panel_root_window_filter ((PropertyPanel*) self, xevent, event);
	return result;
}


static GdkFilterReturn
property_panel_root_window_filter (PropertyPanel* self,
                                   GdkXEvent* gdkxevent,
                                   GdkEvent* event)
{
	GdkFilterReturn result = 0;
	XEvent* xevent = NULL;
	XEvent* _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (gdkxevent != NULL, 0);
	g_return_val_if_fail (event != NULL, 0);
	xevent = (XEvent*) gdkxevent;
	_tmp0_ = xevent;
	_tmp1_ = (*_tmp0_).type;
	if (_tmp1_ == ((gint) PropertyNotify)) {
		gchar* aname = NULL;
		Display* _tmp2_;
		XEvent* _tmp3_;
		XPropertyEvent _tmp4_;
		Atom _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_;
		_tmp2_ = self->priv->m_xdisplay;
		_tmp3_ = xevent;
		_tmp4_ = (*_tmp3_).xproperty;
		_tmp5_ = _tmp4_.atom;
		_tmp6_ = XGetAtomName (_tmp2_, _tmp5_);
		aname = _tmp6_;
		_tmp8_ = aname;
		if (g_strcmp0 (_tmp8_, "_NET_WORKAREA") == 0) {
			XEvent* _tmp9_;
			XPropertyEvent _tmp10_;
			gint _tmp11_;
			_tmp9_ = xevent;
			_tmp10_ = (*_tmp9_).xproperty;
			_tmp11_ = _tmp10_.state;
			_tmp7_ = _tmp11_ == 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			GdkWindow* _tmp12_;
			guint _tmp13_;
			property_panel_set_default_location (self);
			_tmp12_ = self->priv->m_root_window;
			gdk_window_remove_filter (_tmp12_, _property_panel_root_window_filter_gdk_filter_func, self);
			_tmp13_ = self->priv->m_remove_filter_id;
			if (_tmp13_ > ((guint) 0)) {
				guint _tmp14_;
				_tmp14_ = self->priv->m_remove_filter_id;
				g_source_remove (_tmp14_);
				self->priv->m_remove_filter_id = (guint) 0;
			}
			result = GDK_FILTER_CONTINUE;
			_g_free0 (aname);
			return result;
		}
		_g_free0 (aname);
	}
	result = GDK_FILTER_CONTINUE;
	return result;
}


static gboolean
__lambda26_ (PropertyPanel* self)
{
	gboolean result = FALSE;
	GdkWindow* _tmp0_;
	self->priv->m_remove_filter_id = (guint) 0;
	_tmp0_ = self->priv->m_root_window;
	gdk_window_remove_filter (_tmp0_, _property_panel_root_window_filter_gdk_filter_func, self);
	result = FALSE;
	return result;
}


static gboolean
___lambda26__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda26_ ((PropertyPanel*) self);
	return result;
}


static void
property_panel_monitor_net_workarea_atom (PropertyPanel* self)
{
	GdkEventMask events = 0;
	GdkWindow* _tmp0_;
	GdkEventMask _tmp1_;
	GdkWindow* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_root_window;
	events = gdk_window_get_events (_tmp0_);
	_tmp1_ = events;
	if ((_tmp1_ & GDK_PROPERTY_CHANGE_MASK) == 0) {
		GdkWindow* _tmp2_;
		GdkEventMask _tmp3_;
		_tmp2_ = self->priv->m_root_window;
		_tmp3_ = events;
		gdk_window_set_events (_tmp2_, _tmp3_ | GDK_PROPERTY_CHANGE_MASK);
	}
	_tmp4_ = self->priv->m_root_window;
	gdk_window_add_filter (_tmp4_, _property_panel_root_window_filter_gdk_filter_func, self);
	self->priv->m_remove_filter_id = g_timeout_add_full (G_PRIORITY_DEFAULT_IDLE, PROPERTY_PANEL_MONITOR_NET_WORKAREA_TIMEOUT, ___lambda26__gsource_func, g_object_ref (self), g_object_unref);
}


static gboolean
__lambda31_ (PropertyPanel* self)
{
	gboolean result = FALSE;
	GtkWindow* _tmp0_;
	_tmp0_ = self->priv->m_toplevel;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	self->priv->m_auto_hide_timeout_id = (guint) 0;
	result = FALSE;
	return result;
}


static gboolean
___lambda31__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda31_ ((PropertyPanel*) self);
	return result;
}


static void
property_panel_show_with_auto_hide_timer (PropertyPanel* self)
{
	GtkWindow* _tmp0_;
	IPropToolItem** _tmp1_;
	gint _tmp1__length1;
	gint _tmp6_;
	gboolean _tmp7_ = FALSE;
	GdkRectangle _tmp8_;
	gint _tmp9_;
	guint _tmp12_;
	GtkWindow* _tmp14_;
	guint _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_toplevel;
	gtk_window_resize (_tmp0_, 1, 1);
	_tmp1_ = self->priv->m_items;
	_tmp1__length1 = self->priv->m_items_length1;
	if (_tmp1__length1 == 0) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
		_tmp3_ = self->priv->m_follow_input_cursor_when_always_shown;
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			gint _tmp4_;
			_tmp4_ = self->priv->m_show;
			_tmp2_ = _tmp4_ != ((gint) PANEL_SHOW_ALWAYS);
		}
		if (_tmp2_) {
			GtkWindow* _tmp5_;
			_tmp5_ = self->priv->m_toplevel;
			gtk_widget_hide ((GtkWidget*) _tmp5_);
		}
		return;
	}
	_tmp6_ = self->priv->m_show;
	if (_tmp6_ != ((gint) PANEL_SHOW_AUTO_HIDE)) {
		property_panel_show (self);
		return;
	}
	_tmp8_ = self->priv->m_cursor_location;
	_tmp9_ = _tmp8_.x;
	if (_tmp9_ == -1) {
		GdkRectangle _tmp10_;
		gint _tmp11_;
		_tmp10_ = self->priv->m_cursor_location;
		_tmp11_ = _tmp10_.y;
		_tmp7_ = _tmp11_ == -1;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		return;
	}
	_tmp12_ = self->priv->m_auto_hide_timeout_id;
	if (_tmp12_ != ((guint) 0)) {
		guint _tmp13_;
		_tmp13_ = self->priv->m_auto_hide_timeout_id;
		g_source_remove (_tmp13_);
	}
	_tmp14_ = self->priv->m_toplevel;
	gtk_widget_show_all ((GtkWidget*) _tmp14_);
	_tmp15_ = self->priv->m_auto_hide_timeout;
	self->priv->m_auto_hide_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp15_, ___lambda31__gsource_func, g_object_ref (self), g_object_unref);
}


static void
property_panel_hide_if_necessary (PropertyPanel* self)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->m_show;
	if (_tmp1_ == ((gint) PANEL_SHOW_AUTO_HIDE)) {
		guint _tmp2_;
		_tmp2_ = self->priv->m_auto_hide_timeout_id;
		_tmp0_ = _tmp2_ != ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		guint _tmp3_;
		GtkWindow* _tmp4_;
		_tmp3_ = self->priv->m_auto_hide_timeout_id;
		g_source_remove (_tmp3_);
		self->priv->m_auto_hide_timeout_id = (guint) 0;
		_tmp4_ = self->priv->m_toplevel;
		gtk_widget_hide ((GtkWidget*) _tmp4_);
	}
}


static void
g_cclosure_user_marshal_VOID__STRING_INT (GClosure * closure,
                                          GValue * return_value,
                                          guint n_param_values,
                                          const GValue * param_values,
                                          gpointer invocation_hint,
                                          gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_INT) (gpointer data1, const char* arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_int (param_values + 2), data2);
}


static void
property_panel_class_init (PropertyPanelClass * klass)
{
	property_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PropertyPanelPrivate));
	G_OBJECT_CLASS (klass)->finalize = property_panel_finalize;
	property_panel_signals[PROPERTY_PANEL_PROPERTY_ACTIVATE_SIGNAL] = g_signal_new ("property-activate", TYPE_PROPERTY_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_INT, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_INT);
}


static void
property_panel_instance_init (PropertyPanel * self)
{
	GdkRectangle _tmp0_ = {0};
	self->priv = PROPERTY_PANEL_GET_PRIVATE (self);
	memset (&_tmp0_, 0, sizeof (GdkRectangle));
	_tmp0_.x = -1;
	_tmp0_.y = -1;
	_tmp0_.width = 0;
	_tmp0_.height = 0;
	self->priv->m_cursor_location = _tmp0_;
	self->priv->m_show = (gint) PANEL_SHOW_DO_NOT_SHOW;
	self->priv->m_auto_hide_timeout = (guint) 10000;
	self->priv->m_auto_hide_timeout_id = (guint) 0;
	self->priv->m_follow_input_cursor_when_always_shown = FALSE;
}


static void
property_panel_finalize (GObject * obj)
{
	PropertyPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROPERTY_PANEL, PropertyPanel);
	_g_object_unref0 (self->priv->m_toplevel);
	_g_object_unref0 (self->priv->m_props);
	self->priv->m_items = (_vala_array_free (self->priv->m_items, self->priv->m_items_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (property_panel_parent_class)->finalize (obj);
}


GType
property_panel_get_type (void)
{
	static volatile gsize property_panel_type_id__volatile = 0;
	if (g_once_init_enter (&property_panel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PropertyPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) property_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PropertyPanel), 0, (GInstanceInitFunc) property_panel_instance_init, NULL };
		GType property_panel_type_id;
		property_panel_type_id = g_type_register_static (gtk_box_get_type (), "PropertyPanel", &g_define_type_info, 0);
		g_once_init_leave (&property_panel_type_id__volatile, property_panel_type_id);
	}
	return property_panel_type_id__volatile;
}


void
iprop_tool_item_update_property (IPropToolItem* self,
                                 IBusProperty* prop)
{
	g_return_if_fail (self != NULL);
	IPROP_TOOL_ITEM_GET_INTERFACE (self)->update_property (self, prop);
}


static void
iprop_tool_item_default_init (IPropToolItemIface * iface)
{
	iprop_tool_item_signals[IPROP_TOOL_ITEM_PROPERTY_ACTIVATE_SIGNAL] = g_signal_new ("property-activate", TYPE_IPROP_TOOL_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_INT, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_INT);
}


GType
iprop_tool_item_get_type (void)
{
	static volatile gsize iprop_tool_item_type_id__volatile = 0;
	if (g_once_init_enter (&iprop_tool_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IPropToolItemIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) iprop_tool_item_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType iprop_tool_item_type_id;
		iprop_tool_item_type_id = g_type_register_static (G_TYPE_INTERFACE, "IPropToolItem", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (iprop_tool_item_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&iprop_tool_item_type_id__volatile, iprop_tool_item_type_id);
	}
	return iprop_tool_item_type_id__volatile;
}


PropMenu*
prop_menu_construct (GType object_type,
                     IBusProperty* prop)
{
	PropMenu * self = NULL;
	IBusPropList* _tmp0_;
	g_return_val_if_fail (prop != NULL, NULL);
	self = (PropMenu*) g_object_new (object_type, NULL);
	gtk_menu_shell_set_take_focus ((GtkMenuShell*) self, FALSE);
	_tmp0_ = ibus_property_get_sub_props (prop);
	prop_menu_create_items (self, _tmp0_);
	gtk_widget_show_all ((GtkWidget*) self);
	gtk_widget_set_sensitive ((GtkWidget*) self, ibus_property_get_sensitive (prop));
	return self;
}


PropMenu*
prop_menu_new (IBusProperty* prop)
{
	return prop_menu_construct (TYPE_PROP_MENU, prop);
}


static void
prop_menu_real_update_property (IPropToolItem* base,
                                IBusProperty* prop)
{
	PropMenu * self;
	IPropItem** _tmp0_;
	gint _tmp0__length1;
	self = (PropMenu*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->m_items;
	_tmp0__length1 = self->priv->m_items_length1;
	{
		IPropItem** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = _tmp0_;
		item_collection_length1 = _tmp0__length1;
		for (item_it = 0; item_it < _tmp0__length1; item_it = item_it + 1) {
			IPropItem* _tmp1_;
			IPropItem* item = NULL;
			_tmp1_ = _g_object_ref0 (item_collection[item_it]);
			item = _tmp1_;
			{
				IPropItem* _tmp2_;
				_tmp2_ = item;
				iprop_item_update_property (_tmp2_, prop);
				_g_object_unref0 (item);
			}
		}
	}
}


void
prop_menu_popup (PropMenu* self,
                 guint button,
                 guint32 activate_time,
                 GtkWidget* widget)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	gtk_menu_popup_at_widget (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_menu_get_type (), GtkMenu), widget, GDK_GRAVITY_SOUTH_WEST, GDK_GRAVITY_NORTH_WEST, NULL);
}


static void
prop_menu_real_destroy (GtkWidget* base)
{
	PropMenu * self;
	IPropItem** _tmp0_;
	gint _tmp0__length1;
	IPropItem** _tmp3_;
	self = (PropMenu*) base;
	_g_object_unref0 (self->priv->m_parent_button);
	self->priv->m_parent_button = NULL;
	_tmp0_ = self->priv->m_items;
	_tmp0__length1 = self->priv->m_items_length1;
	{
		IPropItem** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = _tmp0_;
		item_collection_length1 = _tmp0__length1;
		for (item_it = 0; item_it < _tmp0__length1; item_it = item_it + 1) {
			IPropItem* _tmp1_;
			IPropItem* item = NULL;
			_tmp1_ = _g_object_ref0 (item_collection[item_it]);
			item = _tmp1_;
			{
				IPropItem* _tmp2_;
				_tmp2_ = item;
				gtk_container_remove ((GtkContainer*) self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp2_) : NULL);
				_g_object_unref0 (item);
			}
		}
	}
	_tmp3_ = g_new0 (IPropItem*, 0 + 1);
	self->priv->m_items = (_vala_array_free (self->priv->m_items, self->priv->m_items_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_items = _tmp3_;
	self->priv->m_items_length1 = 0;
	self->priv->_m_items_size_ = self->priv->m_items_length1;
	GTK_WIDGET_CLASS (prop_menu_parent_class)->destroy ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_menu_get_type (), GtkMenu));
}


static void
____lambda27_ (PropMenu* self,
               IPropItem* w,
               const gchar* k,
               gint s)
{
	g_return_if_fail (w != NULL);
	g_return_if_fail (k != NULL);
	g_signal_emit ((IPropToolItem*) self, iprop_tool_item_signals[IPROP_TOOL_ITEM_PROPERTY_ACTIVATE_SIGNAL], 0, k, s);
}


static void
_____lambda27__iprop_item_property_activate (IPropItem* _sender,
                                             const gchar* key,
                                             gint state,
                                             gpointer self)
{
	____lambda27_ ((PropMenu*) self, _sender, key, state);
}


static void
_vala_array_add24 (IPropItem** * array,
                   int* length,
                   int* size,
                   IPropItem* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (IPropItem*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
prop_menu_create_items (PropMenu* self,
                        IBusPropList* props)
{
	gint i = 0;
	PropRadioMenuItem* last_radio = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (props != NULL);
	i = 0;
	last_radio = NULL;
	while (TRUE) {
		IBusProperty* prop = NULL;
		gint _tmp0_;
		IBusProperty* _tmp1_;
		IBusProperty* _tmp2_;
		IBusProperty* _tmp3_;
		gint _tmp4_;
		IPropItem* item = NULL;
		IBusProperty* _tmp5_;
		IBusProperty* _tmp26_;
		IPropItem* _tmp27_;
		_tmp0_ = i;
		_tmp1_ = ibus_prop_list_get (props, (guint) _tmp0_);
		_tmp2_ = _g_object_ref0 (_tmp1_);
		prop = _tmp2_;
		_tmp3_ = prop;
		if (_tmp3_ == NULL) {
			_g_object_unref0 (prop);
			break;
		}
		_tmp4_ = i;
		i = _tmp4_ + 1;
		item = NULL;
		_tmp5_ = prop;
		switch (ibus_property_get_prop_type (_tmp5_)) {
			case PROP_TYPE_NORMAL:
			{
				IBusProperty* _tmp6_;
				PropImageMenuItem* _tmp7_;
				_tmp6_ = prop;
				_tmp7_ = prop_image_menu_item_new (_tmp6_);
				g_object_ref_sink (_tmp7_);
				_g_object_unref0 (item);
				item = (IPropItem*) _tmp7_;
				break;
			}
			case PROP_TYPE_TOGGLE:
			{
				IBusProperty* _tmp8_;
				PropCheckMenuItem* _tmp9_;
				_tmp8_ = prop;
				_tmp9_ = prop_check_menu_item_new (_tmp8_);
				g_object_ref_sink (_tmp9_);
				_g_object_unref0 (item);
				item = (IPropItem*) _tmp9_;
				break;
			}
			case PROP_TYPE_RADIO:
			{
				IBusProperty* _tmp10_;
				PropRadioMenuItem* _tmp11_;
				PropRadioMenuItem* _tmp12_;
				PropRadioMenuItem* _tmp13_;
				IPropItem* _tmp14_;
				_tmp10_ = prop;
				_tmp11_ = last_radio;
				_tmp12_ = prop_radio_menu_item_new (_tmp10_, _tmp11_);
				g_object_ref_sink (_tmp12_);
				_g_object_unref0 (last_radio);
				last_radio = _tmp12_;
				_tmp13_ = last_radio;
				_tmp14_ = _g_object_ref0 ((IPropItem*) _tmp13_);
				_g_object_unref0 (item);
				item = _tmp14_;
				break;
			}
			case PROP_TYPE_MENU:
			{
				{
					PropImageMenuItem* menuitem = NULL;
					IBusProperty* _tmp15_;
					PropImageMenuItem* _tmp16_;
					PropImageMenuItem* _tmp17_;
					IBusProperty* _tmp18_;
					PropMenu* _tmp19_;
					PropMenu* _tmp20_;
					PropImageMenuItem* _tmp21_;
					IPropItem* _tmp22_;
					_tmp15_ = prop;
					_tmp16_ = prop_image_menu_item_new (_tmp15_);
					g_object_ref_sink (_tmp16_);
					menuitem = _tmp16_;
					_tmp17_ = menuitem;
					_tmp18_ = prop;
					_tmp19_ = prop_menu_new (_tmp18_);
					g_object_ref_sink (_tmp19_);
					_tmp20_ = _tmp19_;
					gtk_menu_item_set_submenu ((GtkMenuItem*) _tmp17_, (GtkMenu*) _tmp20_);
					_g_object_unref0 (_tmp20_);
					_tmp21_ = menuitem;
					_tmp22_ = _g_object_ref0 ((IPropItem*) _tmp21_);
					_g_object_unref0 (item);
					item = _tmp22_;
					_g_object_unref0 (menuitem);
				}
				break;
			}
			case PROP_TYPE_SEPARATOR:
			{
				IBusProperty* _tmp23_;
				PropSeparatorMenuItem* _tmp24_;
				_tmp23_ = prop;
				_tmp24_ = prop_separator_menu_item_new (_tmp23_);
				g_object_ref_sink (_tmp24_);
				_g_object_unref0 (item);
				item = (IPropItem*) _tmp24_;
				break;
			}
			default:
			{
				IBusProperty* _tmp25_;
				_tmp25_ = prop;
				g_warning ("propertypanel.vala:561: Unknown property type: %d", (gint) ibus_property_get_prop_type (_tmp25_));
				break;
			}
		}
		_tmp26_ = prop;
		if (ibus_property_get_prop_type (_tmp26_) != PROP_TYPE_RADIO) {
			_g_object_unref0 (last_radio);
			last_radio = NULL;
		}
		_tmp27_ = item;
		if (_tmp27_ != NULL) {
			IPropItem* _tmp28_;
			IPropItem* _tmp29_;
			IPropItem** _tmp30_;
			gint _tmp30__length1;
			IPropItem* _tmp31_;
			IPropItem* _tmp32_;
			_tmp28_ = item;
			gtk_menu_shell_append ((GtkMenuShell*) self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, gtk_menu_item_get_type ()) ? ((GtkMenuItem*) _tmp28_) : NULL);
			_tmp29_ = item;
			g_signal_connect_object (_tmp29_, "property-activate", (GCallback) _____lambda27__iprop_item_property_activate, self, 0);
			_tmp30_ = self->priv->m_items;
			_tmp30__length1 = self->priv->m_items_length1;
			_tmp31_ = item;
			_tmp32_ = _g_object_ref0 (_tmp31_);
			_vala_array_add24 (&self->priv->m_items, &self->priv->m_items_length1, &self->priv->_m_items_size_, _tmp32_);
		}
		_g_object_unref0 (item);
		_g_object_unref0 (prop);
	}
	_g_object_unref0 (last_radio);
}


static void
prop_menu_class_init (PropMenuClass * klass)
{
	prop_menu_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PropMenuPrivate));
	((GtkWidgetClass *) klass)->destroy = (void (*) (GtkWidget *)) prop_menu_real_destroy;
	G_OBJECT_CLASS (klass)->finalize = prop_menu_finalize;
}


static void
prop_menu_iprop_tool_item_interface_init (IPropToolItemIface * iface)
{
	prop_menu_iprop_tool_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_property = (void (*) (IPropToolItem *, IBusProperty*)) prop_menu_real_update_property;
}


static void
prop_menu_instance_init (PropMenu * self)
{
	self->priv = PROP_MENU_GET_PRIVATE (self);
}


static void
prop_menu_finalize (GObject * obj)
{
	PropMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROP_MENU, PropMenu);
	_g_object_unref0 (self->priv->m_parent_button);
	self->priv->m_items = (_vala_array_free (self->priv->m_items, self->priv->m_items_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (prop_menu_parent_class)->finalize (obj);
}


GType
prop_menu_get_type (void)
{
	static volatile gsize prop_menu_type_id__volatile = 0;
	if (g_once_init_enter (&prop_menu_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PropMenuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) prop_menu_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PropMenu), 0, (GInstanceInitFunc) prop_menu_instance_init, NULL };
		static const GInterfaceInfo iprop_tool_item_info = { (GInterfaceInitFunc) prop_menu_iprop_tool_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType prop_menu_type_id;
		prop_menu_type_id = g_type_register_static (gtk_menu_get_type (), "PropMenu", &g_define_type_info, 0);
		g_type_add_interface_static (prop_menu_type_id, TYPE_IPROP_TOOL_ITEM, &iprop_tool_item_info);
		g_once_init_leave (&prop_menu_type_id__volatile, prop_menu_type_id);
	}
	return prop_menu_type_id__volatile;
}


PropToolButton*
prop_tool_button_construct (GType object_type,
                            IBusProperty* prop)
{
	PropToolButton * self = NULL;
	IBusProperty* _tmp0_;
	g_return_val_if_fail (prop != NULL, NULL);
	self = (PropToolButton*) g_object_new (object_type, "halign", GTK_ALIGN_START, NULL);
	_tmp0_ = _g_object_ref0 (prop);
	_g_object_unref0 (self->priv->m_prop);
	self->priv->m_prop = _tmp0_;
	gtk_tool_item_set_homogeneous ((GtkToolItem*) self, FALSE);
	prop_tool_button_sync (self);
	return self;
}


PropToolButton*
prop_tool_button_new (IBusProperty* prop)
{
	return prop_tool_button_construct (TYPE_PROP_TOOL_BUTTON, prop);
}


static void
prop_tool_button_real_update_property (IPropToolItem* base,
                                       IBusProperty* prop)
{
	PropToolButton * self;
	IBusProperty* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	IBusProperty* _tmp3_;
	IBusText* _tmp4_;
	IBusProperty* _tmp5_;
	IBusText* _tmp6_;
	IBusProperty* _tmp7_;
	IBusProperty* _tmp8_;
	const gchar* _tmp9_;
	IBusProperty* _tmp10_;
	IBusProperty* _tmp11_;
	self = (PropToolButton*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->m_prop;
	_tmp1_ = ibus_property_get_key (_tmp0_);
	_tmp2_ = ibus_property_get_key (prop);
	if (g_strcmp0 (_tmp1_, _tmp2_) != 0) {
		return;
	}
	_tmp3_ = self->priv->m_prop;
	_tmp4_ = ibus_property_get_symbol (prop);
	ibus_property_set_symbol (_tmp3_, _tmp4_);
	_tmp5_ = self->priv->m_prop;
	_tmp6_ = ibus_property_get_tooltip (prop);
	ibus_property_set_tooltip (_tmp5_, _tmp6_);
	_tmp7_ = self->priv->m_prop;
	ibus_property_set_sensitive (_tmp7_, ibus_property_get_sensitive (prop));
	_tmp8_ = self->priv->m_prop;
	_tmp9_ = ibus_property_get_icon (prop);
	ibus_property_set_icon (_tmp8_, _tmp9_);
	_tmp10_ = self->priv->m_prop;
	ibus_property_set_state (_tmp10_, ibus_property_get_state (prop));
	_tmp11_ = self->priv->m_prop;
	ibus_property_set_visible (_tmp11_, ibus_property_get_visible (prop));
	prop_tool_button_sync (self);
}


static void
prop_tool_button_sync (PropToolButton* self)
{
	IBusProperty* _tmp0_;
	IBusText* _tmp1_;
	const gchar* _tmp2_;
	IBusProperty* _tmp3_;
	IBusText* _tmp4_;
	const gchar* _tmp5_;
	IBusProperty* _tmp6_;
	IBusProperty* _tmp7_;
	const gchar* _tmp8_;
	IBusProperty* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_prop;
	_tmp1_ = ibus_property_get_symbol (_tmp0_);
	_tmp2_ = ibus_text_get_text (_tmp1_);
	gtk_tool_button_set_label ((GtkToolButton*) self, _tmp2_);
	_tmp3_ = self->priv->m_prop;
	_tmp4_ = ibus_property_get_tooltip (_tmp3_);
	_tmp5_ = ibus_text_get_text (_tmp4_);
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) self, _tmp5_);
	_tmp6_ = self->priv->m_prop;
	gtk_widget_set_sensitive ((GtkWidget*) self, ibus_property_get_sensitive (_tmp6_));
	_tmp7_ = self->priv->m_prop;
	_tmp8_ = ibus_property_get_icon (_tmp7_);
	prop_tool_button_set_icon_name (self, _tmp8_);
	_tmp9_ = self->priv->m_prop;
	if (ibus_property_get_visible (_tmp9_)) {
		gtk_widget_show ((GtkWidget*) self);
	} else {
		gtk_widget_hide ((GtkWidget*) self);
	}
}


static void
prop_tool_button_real_clicked (GtkToolButton* base)
{
	PropToolButton * self;
	IBusProperty* _tmp0_;
	const gchar* _tmp1_;
	IBusProperty* _tmp2_;
	self = (PropToolButton*) base;
	_tmp0_ = self->priv->m_prop;
	_tmp1_ = ibus_property_get_key (_tmp0_);
	_tmp2_ = self->priv->m_prop;
	g_signal_emit ((IPropToolItem*) self, iprop_tool_item_signals[IPROP_TOOL_ITEM_PROPERTY_ACTIVATE_SIGNAL], 0, _tmp1_, (gint) ibus_property_get_state (_tmp2_));
}


void
prop_tool_button_set_icon_name (PropToolButton* self,
                                const gchar* icon_name)
{
	gchar* label = NULL;
	IBusProperty* _tmp0_;
	IBusText* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	IconWidget* icon_widget = NULL;
	const gchar* _tmp4_;
	IconWidget* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_name != NULL);
	_tmp0_ = self->priv->m_prop;
	_tmp1_ = ibus_property_get_symbol (_tmp0_);
	_tmp2_ = ibus_text_get_text (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	label = _tmp3_;
	icon_widget = NULL;
	_tmp4_ = label;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		IconWidget* _tmp5_;
		_g_free0 (label);
		label = NULL;
		_tmp5_ = icon_widget_new (icon_name, GTK_ICON_SIZE_BUTTON);
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (icon_widget);
		icon_widget = _tmp5_;
		gtk_tool_item_set_is_important ((GtkToolItem*) self, FALSE);
	} else {
		gtk_tool_item_set_is_important ((GtkToolItem*) self, TRUE);
	}
	_tmp6_ = icon_widget;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) self, (GtkWidget*) _tmp6_);
	_g_object_unref0 (icon_widget);
	_g_free0 (label);
}


static void
prop_tool_button_class_init (PropToolButtonClass * klass)
{
	prop_tool_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PropToolButtonPrivate));
	((GtkToolButtonClass *) klass)->clicked = (void (*) (GtkToolButton *)) prop_tool_button_real_clicked;
	G_OBJECT_CLASS (klass)->finalize = prop_tool_button_finalize;
}


static void
prop_tool_button_iprop_tool_item_interface_init (IPropToolItemIface * iface)
{
	prop_tool_button_iprop_tool_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_property = (void (*) (IPropToolItem *, IBusProperty*)) prop_tool_button_real_update_property;
}


static void
prop_tool_button_instance_init (PropToolButton * self)
{
	self->priv = PROP_TOOL_BUTTON_GET_PRIVATE (self);
	self->priv->m_prop = NULL;
}


static void
prop_tool_button_finalize (GObject * obj)
{
	PropToolButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROP_TOOL_BUTTON, PropToolButton);
	_g_object_unref0 (self->priv->m_prop);
	G_OBJECT_CLASS (prop_tool_button_parent_class)->finalize (obj);
}


GType
prop_tool_button_get_type (void)
{
	static volatile gsize prop_tool_button_type_id__volatile = 0;
	if (g_once_init_enter (&prop_tool_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PropToolButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) prop_tool_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PropToolButton), 0, (GInstanceInitFunc) prop_tool_button_instance_init, NULL };
		static const GInterfaceInfo iprop_tool_item_info = { (GInterfaceInitFunc) prop_tool_button_iprop_tool_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType prop_tool_button_type_id;
		prop_tool_button_type_id = g_type_register_static (gtk_tool_button_get_type (), "PropToolButton", &g_define_type_info, 0);
		g_type_add_interface_static (prop_tool_button_type_id, TYPE_IPROP_TOOL_ITEM, &iprop_tool_item_info);
		g_once_init_leave (&prop_tool_button_type_id__volatile, prop_tool_button_type_id);
	}
	return prop_tool_button_type_id__volatile;
}


PropToggleToolButton*
prop_toggle_tool_button_construct (GType object_type,
                                   IBusProperty* prop)
{
	PropToggleToolButton * self = NULL;
	IBusProperty* _tmp0_;
	g_return_val_if_fail (prop != NULL, NULL);
	self = (PropToggleToolButton*) g_object_new (object_type, "halign", GTK_ALIGN_START, NULL);
	_tmp0_ = _g_object_ref0 (prop);
	_g_object_unref0 (self->priv->m_prop);
	self->priv->m_prop = _tmp0_;
	gtk_tool_item_set_homogeneous ((GtkToolItem*) self, FALSE);
	prop_toggle_tool_button_sync (self);
	return self;
}


PropToggleToolButton*
prop_toggle_tool_button_new (IBusProperty* prop)
{
	return prop_toggle_tool_button_construct (TYPE_PROP_TOGGLE_TOOL_BUTTON, prop);
}


void
prop_toggle_tool_button_set_property (PropToggleToolButton* self,
                                      IBusProperty* prop)
{
	IBusProperty* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prop != NULL);
	_tmp0_ = _g_object_ref0 (prop);
	_g_object_unref0 (self->priv->m_prop);
	self->priv->m_prop = _tmp0_;
	prop_toggle_tool_button_sync (self);
}


static void
prop_toggle_tool_button_real_update_property (IPropToolItem* base,
                                              IBusProperty* prop)
{
	PropToggleToolButton * self;
	IBusProperty* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	IBusProperty* _tmp3_;
	IBusText* _tmp4_;
	IBusProperty* _tmp5_;
	IBusText* _tmp6_;
	IBusProperty* _tmp7_;
	IBusProperty* _tmp8_;
	const gchar* _tmp9_;
	IBusProperty* _tmp10_;
	IBusProperty* _tmp11_;
	self = (PropToggleToolButton*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->m_prop;
	_tmp1_ = ibus_property_get_key (_tmp0_);
	_tmp2_ = ibus_property_get_key (prop);
	if (g_strcmp0 (_tmp1_, _tmp2_) != 0) {
		return;
	}
	_tmp3_ = self->priv->m_prop;
	_tmp4_ = ibus_property_get_symbol (prop);
	ibus_property_set_symbol (_tmp3_, _tmp4_);
	_tmp5_ = self->priv->m_prop;
	_tmp6_ = ibus_property_get_tooltip (prop);
	ibus_property_set_tooltip (_tmp5_, _tmp6_);
	_tmp7_ = self->priv->m_prop;
	ibus_property_set_sensitive (_tmp7_, ibus_property_get_sensitive (prop));
	_tmp8_ = self->priv->m_prop;
	_tmp9_ = ibus_property_get_icon (prop);
	ibus_property_set_icon (_tmp8_, _tmp9_);
	_tmp10_ = self->priv->m_prop;
	ibus_property_set_state (_tmp10_, ibus_property_get_state (prop));
	_tmp11_ = self->priv->m_prop;
	ibus_property_set_visible (_tmp11_, ibus_property_get_visible (prop));
	prop_toggle_tool_button_sync (self);
}


static void
prop_toggle_tool_button_sync (PropToggleToolButton* self)
{
	IBusProperty* _tmp0_;
	IBusText* _tmp1_;
	const gchar* _tmp2_;
	IBusProperty* _tmp3_;
	IBusText* _tmp4_;
	const gchar* _tmp5_;
	IBusProperty* _tmp6_;
	IBusProperty* _tmp7_;
	const gchar* _tmp8_;
	IBusProperty* _tmp9_;
	IBusProperty* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_prop;
	_tmp1_ = ibus_property_get_symbol (_tmp0_);
	_tmp2_ = ibus_text_get_text (_tmp1_);
	gtk_tool_button_set_label ((GtkToolButton*) self, _tmp2_);
	_tmp3_ = self->priv->m_prop;
	_tmp4_ = ibus_property_get_tooltip (_tmp3_);
	_tmp5_ = ibus_text_get_text (_tmp4_);
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) self, _tmp5_);
	_tmp6_ = self->priv->m_prop;
	gtk_widget_set_sensitive ((GtkWidget*) self, ibus_property_get_sensitive (_tmp6_));
	_tmp7_ = self->priv->m_prop;
	_tmp8_ = ibus_property_get_icon (_tmp7_);
	prop_toggle_tool_button_set_icon_name (self, _tmp8_);
	_tmp9_ = self->priv->m_prop;
	gtk_toggle_tool_button_set_active ((GtkToggleToolButton*) self, ibus_property_get_state (_tmp9_) == PROP_STATE_CHECKED);
	_tmp10_ = self->priv->m_prop;
	if (ibus_property_get_visible (_tmp10_)) {
		gtk_widget_show ((GtkWidget*) self);
	} else {
		gtk_widget_hide ((GtkWidget*) self);
	}
}


static void
prop_toggle_tool_button_real_toggled (GtkToggleToolButton* base)
{
	PropToggleToolButton * self;
	gboolean do_emit = FALSE;
	gboolean _tmp4_;
	self = (PropToggleToolButton*) base;
	do_emit = FALSE;
	if (gtk_toggle_tool_button_get_active ((GtkToggleToolButton*) self)) {
		IBusProperty* _tmp0_;
		IBusProperty* _tmp1_;
		_tmp0_ = self->priv->m_prop;
		if (ibus_property_get_state (_tmp0_) != PROP_STATE_CHECKED) {
			do_emit = TRUE;
		}
		_tmp1_ = self->priv->m_prop;
		ibus_property_set_state (_tmp1_, PROP_STATE_CHECKED);
	} else {
		IBusProperty* _tmp2_;
		IBusProperty* _tmp3_;
		_tmp2_ = self->priv->m_prop;
		if (ibus_property_get_state (_tmp2_) != PROP_STATE_UNCHECKED) {
			do_emit = TRUE;
		}
		_tmp3_ = self->priv->m_prop;
		ibus_property_set_state (_tmp3_, PROP_STATE_UNCHECKED);
	}
	_tmp4_ = do_emit;
	if (_tmp4_) {
		IBusProperty* _tmp5_;
		const gchar* _tmp6_;
		IBusProperty* _tmp7_;
		_tmp5_ = self->priv->m_prop;
		_tmp6_ = ibus_property_get_key (_tmp5_);
		_tmp7_ = self->priv->m_prop;
		g_signal_emit ((IPropToolItem*) self, iprop_tool_item_signals[IPROP_TOOL_ITEM_PROPERTY_ACTIVATE_SIGNAL], 0, _tmp6_, (gint) ibus_property_get_state (_tmp7_));
	}
}


void
prop_toggle_tool_button_set_icon_name (PropToggleToolButton* self,
                                       const gchar* icon_name)
{
	gchar* label = NULL;
	IBusProperty* _tmp0_;
	IBusText* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	IconWidget* icon_widget = NULL;
	const gchar* _tmp4_;
	IconWidget* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_name != NULL);
	_tmp0_ = self->priv->m_prop;
	_tmp1_ = ibus_property_get_symbol (_tmp0_);
	_tmp2_ = ibus_text_get_text (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	label = _tmp3_;
	icon_widget = NULL;
	_tmp4_ = label;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		IconWidget* _tmp5_;
		_g_free0 (label);
		label = NULL;
		_tmp5_ = icon_widget_new (icon_name, GTK_ICON_SIZE_BUTTON);
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (icon_widget);
		icon_widget = _tmp5_;
		gtk_tool_item_set_is_important ((GtkToolItem*) self, FALSE);
	} else {
		gtk_tool_item_set_is_important ((GtkToolItem*) self, TRUE);
	}
	_tmp6_ = icon_widget;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) self, (GtkWidget*) _tmp6_);
	_g_object_unref0 (icon_widget);
	_g_free0 (label);
}


static void
prop_toggle_tool_button_class_init (PropToggleToolButtonClass * klass)
{
	prop_toggle_tool_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PropToggleToolButtonPrivate));
	((GtkToggleToolButtonClass *) klass)->toggled = (void (*) (GtkToggleToolButton *)) prop_toggle_tool_button_real_toggled;
	G_OBJECT_CLASS (klass)->finalize = prop_toggle_tool_button_finalize;
}


static void
prop_toggle_tool_button_iprop_tool_item_interface_init (IPropToolItemIface * iface)
{
	prop_toggle_tool_button_iprop_tool_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_property = (void (*) (IPropToolItem *, IBusProperty*)) prop_toggle_tool_button_real_update_property;
}


static void
prop_toggle_tool_button_instance_init (PropToggleToolButton * self)
{
	self->priv = PROP_TOGGLE_TOOL_BUTTON_GET_PRIVATE (self);
	self->priv->m_prop = NULL;
}


static void
prop_toggle_tool_button_finalize (GObject * obj)
{
	PropToggleToolButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROP_TOGGLE_TOOL_BUTTON, PropToggleToolButton);
	_g_object_unref0 (self->priv->m_prop);
	G_OBJECT_CLASS (prop_toggle_tool_button_parent_class)->finalize (obj);
}


GType
prop_toggle_tool_button_get_type (void)
{
	static volatile gsize prop_toggle_tool_button_type_id__volatile = 0;
	if (g_once_init_enter (&prop_toggle_tool_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PropToggleToolButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) prop_toggle_tool_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PropToggleToolButton), 0, (GInstanceInitFunc) prop_toggle_tool_button_instance_init, NULL };
		static const GInterfaceInfo iprop_tool_item_info = { (GInterfaceInitFunc) prop_toggle_tool_button_iprop_tool_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType prop_toggle_tool_button_type_id;
		prop_toggle_tool_button_type_id = g_type_register_static (gtk_toggle_tool_button_get_type (), "PropToggleToolButton", &g_define_type_info, 0);
		g_type_add_interface_static (prop_toggle_tool_button_type_id, TYPE_IPROP_TOOL_ITEM, &iprop_tool_item_info);
		g_once_init_leave (&prop_toggle_tool_button_type_id__volatile, prop_toggle_tool_button_type_id);
	}
	return prop_toggle_tool_button_type_id__volatile;
}


static void
__lambda28_ (PropMenuToolButton* self,
             GtkMenuShell* m)
{
	g_return_if_fail (m != NULL);
	gtk_toggle_tool_button_set_active ((GtkToggleToolButton*) self, FALSE);
}


static void
___lambda28__gtk_menu_shell_deactivate (GtkMenuShell* _sender,
                                        gpointer self)
{
	__lambda28_ ((PropMenuToolButton*) self, _sender);
}


static void
__lambda29_ (PropMenuToolButton* self,
             const gchar* k,
             gint s)
{
	g_return_if_fail (k != NULL);
	g_signal_emit ((IPropToolItem*) self, iprop_tool_item_signals[IPROP_TOOL_ITEM_PROPERTY_ACTIVATE_SIGNAL], 0, k, s);
}


static void
___lambda29__iprop_tool_item_property_activate (IPropToolItem* _sender,
                                                const gchar* key,
                                                gint state,
                                                gpointer self)
{
	__lambda29_ ((PropMenuToolButton*) self, key, state);
}


PropMenuToolButton*
prop_menu_tool_button_construct (GType object_type,
                                 IBusProperty* prop)
{
	PropMenuToolButton * self = NULL;
	PropMenu* _tmp0_;
	PropMenu* _tmp1_;
	PropMenu* _tmp2_;
	g_return_val_if_fail (prop != NULL, NULL);
	self = (PropMenuToolButton*) g_object_new (object_type, "halign", GTK_ALIGN_START, NULL);
	_tmp0_ = prop_menu_new (prop);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->m_menu);
	self->priv->m_menu = _tmp0_;
	_tmp1_ = self->priv->m_menu;
	g_signal_connect_object ((GtkMenuShell*) _tmp1_, "deactivate", (GCallback) ___lambda28__gtk_menu_shell_deactivate, self, 0);
	_tmp2_ = self->priv->m_menu;
	g_signal_connect_object ((IPropToolItem*) _tmp2_, "property-activate", (GCallback) ___lambda29__iprop_tool_item_property_activate, self, 0);
	prop_toggle_tool_button_set_property (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROP_TOGGLE_TOOL_BUTTON, PropToggleToolButton), prop);
	return self;
}


PropMenuToolButton*
prop_menu_tool_button_new (IBusProperty* prop)
{
	return prop_menu_tool_button_construct (TYPE_PROP_MENU_TOOL_BUTTON, prop);
}


static void
prop_menu_tool_button_real_update_property (IPropToolItem* base,
                                            IBusProperty* prop)
{
	PropMenuToolButton * self;
	PropMenu* _tmp0_;
	self = (PropMenuToolButton*) base;
	g_return_if_fail (prop != NULL);
	prop_menu_tool_button_iprop_tool_item_parent_iface->update_property ((IPropToolItem*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROP_TOGGLE_TOOL_BUTTON, PropToggleToolButton), prop);
	_tmp0_ = self->priv->m_menu;
	iprop_tool_item_update_property ((IPropToolItem*) _tmp0_, prop);
}


static void
prop_menu_tool_button_real_toggled (GtkToggleToolButton* base)
{
	PropMenuToolButton * self;
	self = (PropMenuToolButton*) base;
	if (gtk_toggle_tool_button_get_active ((GtkToggleToolButton*) self)) {
		PropMenu* _tmp0_;
		_tmp0_ = self->priv->m_menu;
		prop_menu_popup (_tmp0_, (guint) 0, gtk_get_current_event_time (), (GtkWidget*) self);
	}
}


static void
prop_menu_tool_button_real_destroy (GtkWidget* base)
{
	PropMenuToolButton * self;
	self = (PropMenuToolButton*) base;
	_g_object_unref0 (self->priv->m_menu);
	self->priv->m_menu = NULL;
	GTK_WIDGET_CLASS (prop_menu_tool_button_parent_class)->destroy ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROP_TOGGLE_TOOL_BUTTON, PropToggleToolButton));
}


static void
prop_menu_tool_button_class_init (PropMenuToolButtonClass * klass)
{
	prop_menu_tool_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PropMenuToolButtonPrivate));
	((GtkToggleToolButtonClass *) klass)->toggled = (void (*) (GtkToggleToolButton *)) prop_menu_tool_button_real_toggled;
	((GtkWidgetClass *) klass)->destroy = (void (*) (GtkWidget *)) prop_menu_tool_button_real_destroy;
	G_OBJECT_CLASS (klass)->finalize = prop_menu_tool_button_finalize;
}


static void
prop_menu_tool_button_iprop_tool_item_interface_init (IPropToolItemIface * iface)
{
	prop_menu_tool_button_iprop_tool_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_property = (void (*) (IPropToolItem *, IBusProperty*)) prop_menu_tool_button_real_update_property;
}


static void
prop_menu_tool_button_instance_init (PropMenuToolButton * self)
{
	self->priv = PROP_MENU_TOOL_BUTTON_GET_PRIVATE (self);
	self->priv->m_menu = NULL;
}


static void
prop_menu_tool_button_finalize (GObject * obj)
{
	PropMenuToolButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROP_MENU_TOOL_BUTTON, PropMenuToolButton);
	_g_object_unref0 (self->priv->m_menu);
	G_OBJECT_CLASS (prop_menu_tool_button_parent_class)->finalize (obj);
}


GType
prop_menu_tool_button_get_type (void)
{
	static volatile gsize prop_menu_tool_button_type_id__volatile = 0;
	if (g_once_init_enter (&prop_menu_tool_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PropMenuToolButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) prop_menu_tool_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PropMenuToolButton), 0, (GInstanceInitFunc) prop_menu_tool_button_instance_init, NULL };
		static const GInterfaceInfo iprop_tool_item_info = { (GInterfaceInitFunc) prop_menu_tool_button_iprop_tool_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType prop_menu_tool_button_type_id;
		prop_menu_tool_button_type_id = g_type_register_static (TYPE_PROP_TOGGLE_TOOL_BUTTON, "PropMenuToolButton", &g_define_type_info, 0);
		g_type_add_interface_static (prop_menu_tool_button_type_id, TYPE_IPROP_TOOL_ITEM, &iprop_tool_item_info);
		g_once_init_leave (&prop_menu_tool_button_type_id__volatile, prop_menu_tool_button_type_id);
	}
	return prop_menu_tool_button_type_id__volatile;
}


PropSeparatorToolItem*
prop_separator_tool_item_construct (GType object_type,
                                    IBusProperty* prop)
{
	PropSeparatorToolItem * self = NULL;
	g_return_val_if_fail (prop != NULL, NULL);
	self = (PropSeparatorToolItem*) g_object_new (object_type, NULL);
	gtk_tool_item_set_homogeneous ((GtkToolItem*) self, FALSE);
	return self;
}


PropSeparatorToolItem*
prop_separator_tool_item_new (IBusProperty* prop)
{
	return prop_separator_tool_item_construct (TYPE_PROP_SEPARATOR_TOOL_ITEM, prop);
}


static void
prop_separator_tool_item_real_update_property (IPropToolItem* base,
                                               IBusProperty* prop)
{
	PropSeparatorToolItem * self;
	self = (PropSeparatorToolItem*) base;
	g_return_if_fail (prop != NULL);
}


static void
prop_separator_tool_item_class_init (PropSeparatorToolItemClass * klass)
{
	prop_separator_tool_item_parent_class = g_type_class_peek_parent (klass);
}


static void
prop_separator_tool_item_iprop_tool_item_interface_init (IPropToolItemIface * iface)
{
	prop_separator_tool_item_iprop_tool_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_property = (void (*) (IPropToolItem *, IBusProperty*)) prop_separator_tool_item_real_update_property;
}


static void
prop_separator_tool_item_instance_init (PropSeparatorToolItem * self)
{
}


GType
prop_separator_tool_item_get_type (void)
{
	static volatile gsize prop_separator_tool_item_type_id__volatile = 0;
	if (g_once_init_enter (&prop_separator_tool_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PropSeparatorToolItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) prop_separator_tool_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PropSeparatorToolItem), 0, (GInstanceInitFunc) prop_separator_tool_item_instance_init, NULL };
		static const GInterfaceInfo iprop_tool_item_info = { (GInterfaceInitFunc) prop_separator_tool_item_iprop_tool_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType prop_separator_tool_item_type_id;
		prop_separator_tool_item_type_id = g_type_register_static (gtk_separator_tool_item_get_type (), "PropSeparatorToolItem", &g_define_type_info, 0);
		g_type_add_interface_static (prop_separator_tool_item_type_id, TYPE_IPROP_TOOL_ITEM, &iprop_tool_item_info);
		g_once_init_leave (&prop_separator_tool_item_type_id__volatile, prop_separator_tool_item_type_id);
	}
	return prop_separator_tool_item_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



