/*
 * Decompiled with CFR 0.152.
 */
package org.testng.junit;

import java.util.List;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.collections.Lists;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JUnitTestClass
implements ITestClass {
    private static final long serialVersionUID = 405598615794850925L;
    private List<ITestNGMethod> m_testMethods = Lists.newArrayList();
    private List<ITestNGMethod> m_beforeClass = Lists.newArrayList();
    private List<ITestNGMethod> m_afterClass = Lists.newArrayList();
    private List<ITestNGMethod> m_beforeTest = Lists.newArrayList();
    private List<ITestNGMethod> m_afterTest = Lists.newArrayList();
    private Class m_realClass;
    private Object[] m_instances;
    private long[] m_instanceHashes;
    private XmlTest m_xmlTest;
    private XmlClass m_xmlClass;
    private static final ITestNGMethod[] EMPTY_METHODARRAY = new ITestNGMethod[0];

    public JUnitTestClass(Class test) {
        this.m_realClass = test;
        this.m_instances = new Object[]{test};
        this.m_instanceHashes = new long[]{test.hashCode()};
    }

    List<ITestNGMethod> getTestMethodList() {
        return this.m_testMethods;
    }

    @Override
    public void addInstance(Object instance) {
        throw new IllegalStateException("addInstance is not supported for JUnit");
    }

    @Override
    public String getName() {
        return this.m_realClass.getName();
    }

    @Override
    public Class getRealClass() {
        return this.m_realClass;
    }

    @Override
    public String getTestName() {
        return this.m_xmlTest.getName();
    }

    @Override
    public XmlTest getXmlTest() {
        return this.m_xmlTest;
    }

    @Override
    public XmlClass getXmlClass() {
        return this.m_xmlClass;
    }

    @Override
    public int getInstanceCount() {
        return 1;
    }

    @Override
    public long[] getInstanceHashCodes() {
        return this.m_instanceHashes;
    }

    @Override
    public Object[] getInstances(boolean reuse) {
        return this.m_instances;
    }

    @Override
    public ITestNGMethod[] getTestMethods() {
        return this.m_testMethods.toArray(new ITestNGMethod[this.m_testMethods.size()]);
    }

    @Override
    public ITestNGMethod[] getBeforeTestMethods() {
        return this.m_beforeTest.toArray(new ITestNGMethod[this.m_beforeTest.size()]);
    }

    @Override
    public ITestNGMethod[] getAfterTestMethods() {
        return this.m_afterTest.toArray(new ITestNGMethod[this.m_afterTest.size()]);
    }

    @Override
    public ITestNGMethod[] getBeforeClassMethods() {
        return this.m_beforeClass.toArray(new ITestNGMethod[this.m_beforeClass.size()]);
    }

    @Override
    public ITestNGMethod[] getAfterClassMethods() {
        return this.m_afterClass.toArray(new ITestNGMethod[this.m_afterClass.size()]);
    }

    @Override
    public ITestNGMethod[] getBeforeSuiteMethods() {
        return EMPTY_METHODARRAY;
    }

    @Override
    public ITestNGMethod[] getAfterSuiteMethods() {
        return EMPTY_METHODARRAY;
    }

    @Override
    public ITestNGMethod[] getBeforeGroupsMethods() {
        return EMPTY_METHODARRAY;
    }

    @Override
    public ITestNGMethod[] getAfterGroupsMethods() {
        return EMPTY_METHODARRAY;
    }

    @Override
    public ITestNGMethod[] getBeforeTestConfigurationMethods() {
        return EMPTY_METHODARRAY;
    }

    @Override
    public ITestNGMethod[] getAfterTestConfigurationMethods() {
        return EMPTY_METHODARRAY;
    }
}

