dnl This is m4 source.
dnl Process using m4 to produce 'C' language file.
dnl
dnl This file is supposed to be the same as PnetCDF's test_get.m4
dnl
dnl If you see this line, you can ignore the next one.
/* Do not edit this file. It is produced from the corresponding .m4 source */
dnl
/*
 *  Copyright (C) 2003, Northwestern University and Argonne National Laboratory
 *  See COPYRIGHT notice in top-level directory.
 */
/* $Id: test_get.m4 2672 2016-12-03 19:23:53Z wkliao $ */

dnl
dnl The command-line m4 macro "PNETCDF" is to differentiate PnetCDF and netCDF
dnl in terms of function prefix names (ncmpi_ vs. nc_), integer data types
dnl (MPI_Offset vs. size_t), and function name substrings for external data
dnl types.
dnl

#include "tests.h"

ifdef(`PNETCDF',,`dnl
#ifdef USE_PNETCDF
#include <pnetcdf.h>
#ifndef PNETCDF_VERSION_MAJOR
#error("PNETCDF_VERSION_MAJOR is not defined in pnetcdf.h")
#endif
#ifndef PNETCDF_VERSION_MINOR
#error("PNETCDF_VERSION_MAJOR is not defined in pnetcdf.h")
#endif
#endif')

define(`EXPECT_ERR',`error("expecting $1 but got %s",nc_err_code_name($2));')dnl

define(`IntType', `ifdef(`PNETCDF',`MPI_Offset',`size_t')')dnl
define(`PTRDType',`ifdef(`PNETCDF',`MPI_Offset',`ptrdiff_t')')dnl
define(`TestFunc',`ifdef(`PNETCDF',`test_ncmpi_get_$1',`test_nc_get_$1')')dnl
define(`APIFunc',` ifdef(`PNETCDF',`ncmpi_$1',`nc_$1')')dnl

define(`FileOpen', `ifdef(`PNETCDF',`ncmpi_open(comm, $1, $2, info, &ncid)', `file_open($1, $2, &ncid)')')dnl

define(`VarArgs',   `ifdef(`PNETCDF',`int numVars',`void')')dnl
define(`AttVarArgs',`ifdef(`PNETCDF',`int numGatts,int numVars',`void')')dnl

define(`GetVar1',`ifdef(`PNETCDF',`ncmpi_get_var1_$1_all',`nc_get_var1_$1')')dnl
define(`GetVar', `ifdef(`PNETCDF',`ncmpi_get_var_$1_all', `nc_get_var_$1')')dnl
define(`GetVara',`ifdef(`PNETCDF',`ncmpi_get_vara_$1_all',`nc_get_vara_$1')')dnl
define(`GetVars',`ifdef(`PNETCDF',`ncmpi_get_vars_$1_all',`nc_get_vars_$1')')dnl
define(`GetVarm',`ifdef(`PNETCDF',`ncmpi_get_varm_$1_all',`nc_get_varm_$1')')dnl
define(`GetAtt', `ifdef(`PNETCDF',`ncmpi_get_att_$1',`nc_get_att_$1')')dnl

define(`PNETCDF_CHECK_ERANGE',`dnl
ifelse(`$1',`uchar',`ifdef(`PNETCDF',,`
`#'if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=8)')',
       `$1',`schar',`ifdef(`PNETCDF',,`
`#'if defined(USE_PNETCDF) && PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR<7
                    else if (cdf_format < NC_FORMAT_CDF5) {
`#'else')')
                    else {
ifelse(`$1',`schar',`ifdef(`PNETCDF',,``#'endif')')
                        IF (err != NC_ERANGE)
                            EXPECT_ERR(NC_ERANGE, err)
                        ELSE_NOK
                    }
ifelse(`$1',`uchar',`ifdef(`PNETCDF',,``#'endif')')'
)dnl

undefine(`index')dnl
dnl dnl dnl
dnl
dnl Macros
dnl
dnl dnl dnl
dnl
dnl Upcase(str)
dnl
define(`Upcase',dnl
`dnl
translit($1, abcdefghijklmnopqrstuvwxyz, ABCDEFGHIJKLMNOPQRSTUVWXYZ)')dnl
dnl dnl dnl
dnl
dnl NCT_ITYPE(type)
dnl
define(`NCT_ITYPE', ``NCT_'Upcase($1)')dnl
dnl

define(`CheckText', `ifelse(`$1',`text', , `== (NCT_ITYPE($1) == NCT_TEXT)')')dnl
define(`CheckRange',`ifelse(`$1',`text', `1', `($2 >= $1_min && $2 <= $1_max)')')dnl
define(`IfCheckTextChar', `ifelse(`$1',`text', `if ($2 != NC_CHAR)')')dnl
define(`CheckNumRange',`ifelse(`$1',`text', `1',`inRange3(cdf_format, $2,$3,NCT_ITYPE($1)) && ($2 >= $1_min && $2 <= $1_max)')')dnl

dnl TEST_NC_GET_VAR1(TYPE)
dnl
define(`TEST_NC_GET_VAR1',dnl
`dnl
int
TestFunc(var1)_$1(VarArgs)
{
    int i, err, ncid, cdf_format;
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    IntType j, index[MAX_RANK];
    double expect;
    $1 value[1];

    err = FileOpen(testfile, NC_NOWRITE);
    IF (err != NC_NOERR) error("open: %s", APIFunc(strerror)(err));

    err = APIFunc(inq_format)(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s", APIFunc(strerror)(err));

    /* check if can detect a bad file ID */
    err = GetVar1($1)(BAD_ID, 0, NULL, NULL);
    IF (err != NC_EBADID)
        EXPECT_ERR(NC_EBADID, err)
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = GetVar1($1)(ncid, BAD_VARID, NULL, NULL);
    IF (err != NC_ENOTVAR)
        EXPECT_ERR(NC_ENOTVAR, err)
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = GetVar1($1)(BAD_ID, i, NULL, value);
        IF (err != NC_EBADID)
            EXPECT_ERR(NC_EBADID, err)
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) CheckText($1);

ifdef(`PNETCDF',`dnl
        /* for non-scalar variables, argument start cannot be NULL */
        err = GetVar1($1)(ncid, i, NULL, value);
        if (!canConvert) {
            IF (err != NC_ECHAR) EXPECT_ERR(NC_ECHAR, err)
        }
        else if (var_rank[i] == 0) {
            index[0] = 0;
            expect = hash4(cdf_format, var_type[i], 0, index, NCT_ITYPE($1));
            if (inRange3(cdf_format, expect, var_type[i], NCT_ITYPE($1)) &&
                CheckRange($1, expect)) {
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
ifelse(`$1',`uchar',`ifdef(`PNETCDF',,``#'if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>7)')')
            else IF (err != NC_ERANGE) EXPECT_ERR(NC_ERANGE, err)
ifelse(`$1',`uchar',`ifdef(`PNETCDF',,``#'endif')')
        }
        else IF (err != NC_EINVALCOORDS) {
            EXPECT_ERR(NC_EINVALCOORDS, err)
        }
        ELSE_NOK
')dnl

        /* test NC_EINVALCOORDS */
        for (j = 0; j < var_rank[i]; j++) index[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            index[j] = var_shape[i][j];     /* out of boundary check */
            err = GetVar1($1)(ncid, i, index, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
                ELSE_NOK
            } else IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            index[j] = 0;
        }

        /* check if the contents are supposed to be */
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            /* when file is created the variable contents are generated by
             * hash functions */
            expect = hash4(cdf_format, var_type[i], var_rank[i], index,
                           NCT_ITYPE($1));
            err = GetVar1($1)(ncid, i, index, value);
            if (canConvert) {
                if (inRange3(cdf_format, expect,var_type[i], NCT_ITYPE($1))) {
                    if (CheckRange($1, expect)) {
                        IF (err != NC_NOERR) {
                            EXPECT_ERR(NC_NOERR, err)
                        } else {
                            ifelse(`$1', `uchar', `
                            /* in put_vars(), API _put_vara_double() is used to
                             * write the NC_BYTE variables to files. In this
                             * case, NC_BYTE variables are treated as signed
                             * for CDF-1 and 2 formats. Thus, we must skip the
                             * equal test below for uchar.
                             */
                            if (cdf_format < NC_FORMAT_CDF5 && var_type[i] == NC_BYTE && expect > schar_max) continue;')
                            IF (!equal((double)value[0], expect, var_type[i], NCT_ITYPE($1))) {
                                error("expected: %G, got: %G", expect, (double)value[0]);
                            }
                            ELSE_NOK
                        }
                    }
                    PNETCDF_CHECK_ERANGE($1)
                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        EXPECT_ERR(NC_NOERR or NC_ERANGE, err)
                }
            } else {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
                ELSE_NOK
            }
        }
    }
    err = APIFunc(close)(ncid);
    IF (err != NC_NOERR)
        error("close: %s", APIFunc(strerror)(err));
    return nok;
}
')dnl

TEST_NC_GET_VAR1(text)
TEST_NC_GET_VAR1(schar)
TEST_NC_GET_VAR1(uchar)
TEST_NC_GET_VAR1(short)
TEST_NC_GET_VAR1(int)
TEST_NC_GET_VAR1(long)
TEST_NC_GET_VAR1(float)
TEST_NC_GET_VAR1(double)
TEST_NC_GET_VAR1(ushort)
TEST_NC_GET_VAR1(uint)
TEST_NC_GET_VAR1(longlong)
TEST_NC_GET_VAR1(ulonglong)


dnl TEST_NC_GET_VAR(TYPE)
dnl
define(`TEST_NC_GET_VAR',dnl
`dnl
int
TestFunc(var)_$1(VarArgs)
{
    int i, err, ncid, cdf_format;
    int allInExtRange;  /* all values within range of external data type */
    int allInIntRange;  /* all values within range of internal data type */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    IntType j, index[MAX_RANK];
    double expect[MAX_NELS];
    $1 value[MAX_NELS];

    err = FileOpen(testfile, NC_NOWRITE);
    IF (err != NC_NOERR) error("open: %s", APIFunc(strerror)(err));

    err = APIFunc(inq_format)(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s", APIFunc(strerror)(err));

    /* check if can detect a bad file ID */
    err = GetVar($1)(BAD_ID, 0, value);
    IF (err != NC_EBADID)
        EXPECT_ERR(NC_EBADID, err)
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = GetVar($1)(ncid, BAD_VARID, value);
    IF (err != NC_ENOTVAR)
        EXPECT_ERR(NC_ENOTVAR, err)
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = GetVar($1)(BAD_ID, i, value);
        IF (err != NC_EBADID)
            EXPECT_ERR(NC_EBADID, err)
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) CheckText($1);

        allInExtRange = allInIntRange = 1;
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                              NCT_ITYPE($1));
            if (inRange3(cdf_format, expect[j],var_type[i], NCT_ITYPE($1))) {
                IfCheckTextChar($1, var_type[i])
                    allInIntRange &= CheckRange($1,expect[j]);
            } else
                allInExtRange = 0;
        }
        err = GetVar($1)(ncid, i, value);
        if (canConvert) {
            if (allInExtRange) {
                if (allInIntRange) {
                    IF (err != NC_NOERR)
                        EXPECT_ERR(NC_NOERR, err)
                }
                PNETCDF_CHECK_ERANGE($1)
            } else {
                IF (err != NC_NOERR && err != NC_ERANGE)
                    EXPECT_ERR(NC_NOERR or NC_ERANGE, err)
            }
            for (j = 0; j < var_nels[i]; j++) {
                if (CheckNumRange($1, expect[j], var_type[i])) {
                    ifelse(`$1', `uchar', `
                    /* in put_vars(), API _put_vara_double() is used to
                     * write the NC_BYTE variables to files. In this
                     * case, NC_BYTE variables are treated as signed
                     * for CDF-1 and 2 formats. Thus, we must skip the
                     * equal test below for uchar.
                     */
                    if (cdf_format < NC_FORMAT_CDF5 && var_type[i] == NC_BYTE && expect[j] > schar_max) continue;')
                    IF (!equal((double)value[j],expect[j],var_type[i],NCT_ITYPE($1))){
                        error("value read not that expected");
                        if (verbose) {
                            error("\n");
                            error("varid: %d, ", i);
                            error("var_name: %s, ", var_name[i]);
                            error("var_type: %s, ", s_nc_type(var_type[i]));
                            error("element number: %d, ", j);
                            error("expect: %g, ", expect[j]);
                            error("got: %g", (double) value[j]);
                        }
                    }
                    ELSE_NOK
                }
            }
        } else {
            IF (err != NC_ECHAR)
                EXPECT_ERR(NC_ECHAR, err)
            ELSE_NOK
        }
    }
    err = APIFunc(close)(ncid);
    IF (err != NC_NOERR)
        error("close: %s", APIFunc(strerror)(err));
    return nok;
}
')dnl

TEST_NC_GET_VAR(text)
TEST_NC_GET_VAR(uchar)
TEST_NC_GET_VAR(schar)
TEST_NC_GET_VAR(short)
TEST_NC_GET_VAR(int)
TEST_NC_GET_VAR(long)
TEST_NC_GET_VAR(float)
TEST_NC_GET_VAR(double)
TEST_NC_GET_VAR(ushort)
TEST_NC_GET_VAR(uint)
TEST_NC_GET_VAR(longlong)
TEST_NC_GET_VAR(ulonglong)


dnl TEST_NC_GET_VARA(TYPE)
dnl
define(`TEST_NC_GET_VARA',dnl
`dnl
int
TestFunc(vara)_$1(VarArgs)
{
    int i, k, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    IntType j;
    IntType start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK], mid[MAX_RANK];
    double expect[MAX_NELS];
    $1 value[MAX_NELS];

    err = FileOpen(testfile, NC_NOWRITE);
    IF (err != NC_NOERR) error("open: %s", APIFunc(strerror)(err));

    err = APIFunc(inq_format)(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s", APIFunc(strerror)(err));

    err = GetVara($1)(BAD_ID, 0, NULL, NULL, value);
    IF (err != NC_EBADID)
        EXPECT_ERR(NC_EBADID, err)
    ELSE_NOK

    err = GetVara($1)(ncid, BAD_VARID, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        EXPECT_ERR(NC_ENOTVAR, err)
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = GetVara($1)(BAD_ID, i, NULL, NULL, value);
        IF (err != NC_EBADID)
            EXPECT_ERR(NC_EBADID, err)
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) CheckText($1);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
        }

ifdef(`PNETCDF',`dnl
        /* for non-scalar variables, argument start cannot be NULL */
        err = GetVara($1)(ncid, i, NULL, NULL, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                EXPECT_ERR(NC_ECHAR, err)
            ELSE_NOK
        }
        else if (var_rank[i] == 0) {
            index[0] = 0;
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_ITYPE($1));
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_ITYPE($1)) &&
                CheckRange($1, expect[0])) {
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
ifelse(`$1',`uchar',`ifdef(`PNETCDF',,``#'if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>7)')')
            else IF (err != NC_ERANGE) EXPECT_ERR(NC_ERANGE, err)
ifelse(`$1',`uchar',`ifdef(`PNETCDF',,``#'endif')')
        }
        else IF (err != NC_EINVALCOORDS) {
            EXPECT_ERR(NC_EINVALCOORDS, err)
        }
        ELSE_NOK

        /* for non-scalar variables, argument count cannot be NULL */
        err = GetVara($1)(ncid, i, start, NULL, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                EXPECT_ERR(NC_ECHAR, err)
            ELSE_NOK
        }
        else if (var_rank[i] == 0) {
            index[0] = 0;
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_ITYPE($1));
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_ITYPE($1)) &&
                CheckRange($1, expect[0])) {
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
            else IF (err != NC_ERANGE) EXPECT_ERR(NC_ERANGE, err)
        }
        else IF (err != NC_EEDGE)
            EXPECT_ERR(NC_EEDGE, err)
        ELSE_NOK
')dnl

        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j]; /* causes NC_EINVALCOORDS */
            err = GetVara($1)(ncid, i, start, edge, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1; /* causes NC_EEDGE */
            err = GetVara($1)(ncid, i, start, edge, value);
            IF (err != NC_EEDGE)
                EXPECT_ERR(NC_EEDGE, err)
            edge[j] = 1;
        }
        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[*]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_rank[i] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = GetVara($1)(ncid, i, start, edge, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                EXPECT_ERR(NC_NOERR, err)
            start[j] = var_shape[i][j]+1; /* should cause NC_EINVALCOORDS */
            err = GetVara($1)(ncid, i, start, edge, value);
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            start[j] = 0;
        }

        err = GetVara($1)(ncid, i, start, edge, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                EXPECT_ERR(NC_ECHAR, err)
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_ITYPE($1));
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_ITYPE($1)) &&
                CheckRange($1, expect[0])) {
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
ifelse(`$1',`uchar',`ifdef(`PNETCDF',,``#'if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>7)')')
            else IF (err != NC_ERANGE) EXPECT_ERR(NC_ERANGE, err)
ifelse(`$1',`uchar',`ifdef(`PNETCDF',,``#'endif')')
        } else {
            IF (err != NC_NOERR)
                EXPECT_ERR(NC_NOERR, err)
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        for (k = 0; k < nslabs; k++) {
            IntType nels = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                nels *= edge[j];
            }
            allInExtRange = allInIntRange = 1;
            for (j = 0; j < nels; j++) {
                int d;
                err = toMixedBase(j, var_rank[i], edge, index);
                IF (err != 0) error("error in toMixedBase");
                for (d = 0; d < var_rank[i]; d++)
                    index[d] += start[d];
                expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                                  NCT_ITYPE($1));
                if (inRange3(cdf_format, expect[j],var_type[i],NCT_ITYPE($1))) {
		    IfCheckTextChar($1, var_type[i])
                        allInIntRange &= CheckRange($1,expect[j]);
                } else
                    allInExtRange = 0;
            }
            err = GetVara($1)(ncid, i, start, edge, value);
            if (canConvert) {
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (err != NC_NOERR)
                            EXPECT_ERR(NC_NOERR, err)
                    }
                    PNETCDF_CHECK_ERANGE($1)
                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        EXPECT_ERR(NC_NOERR or NC_ERANGE, err)
                }
                for (j = 0; j < nels; j++) {
                    if (CheckNumRange($1, expect[j], var_type[i])) {
                        ifelse(`$1', `uchar', `
                        /* in put_vars(), API _put_vara_double() is used to
                         * write the NC_BYTE variables to files. In this
                         * case, NC_BYTE variables are treated as signed
                         * for CDF-1 and 2 formats. Thus, we must skip the
                         * equal test below for uchar.
                         */
                        if (cdf_format < NC_FORMAT_CDF5 && var_type[i] == NC_BYTE && expect[j] > schar_max) continue;')
                        IF (!equal((double)value[j],expect[j],var_type[i],NCT_ITYPE($1))){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                error("var_name: %s, ", var_name[i]);
                                error("var_type: %s, ", s_nc_type(var_type[i]));
                                error("element number: %d, ", j);
                                error("expect: %g, ", expect[j]);
                                error("got: %g", (double) value[j]);
                            }
                        }
                        ELSE_NOK
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
            }
        }
    }
    err = APIFunc(close)(ncid);
    IF (err != NC_NOERR)
        error("close: %s", APIFunc(strerror)(err));
    return nok;
}
')dnl

TEST_NC_GET_VARA(text)
TEST_NC_GET_VARA(uchar)
TEST_NC_GET_VARA(schar)
TEST_NC_GET_VARA(short)
TEST_NC_GET_VARA(int)
TEST_NC_GET_VARA(long)
TEST_NC_GET_VARA(float)
TEST_NC_GET_VARA(double)
TEST_NC_GET_VARA(ushort)
TEST_NC_GET_VARA(uint)
TEST_NC_GET_VARA(longlong)
TEST_NC_GET_VARA(ulonglong)


dnl TEST_NC_GET_VARS(TYPE)
dnl
define(`TEST_NC_GET_VARS',dnl
`dnl
int
TestFunc(vars)_$1(VarArgs)
{
    int i, k, d, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    PTRDType nstarts;   /* number of different starts */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    IntType j, m, nels;
    IntType start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    IntType index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    IntType sstride[MAX_RANK];
    PTRDType stride[MAX_RANK];
    double expect[MAX_NELS];
    $1 value[MAX_NELS];

    err = FileOpen(testfile, NC_NOWRITE);
    IF (err != NC_NOERR) error("open: %s", APIFunc(strerror)(err));

    err = APIFunc(inq_format)(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s", APIFunc(strerror)(err));

    err = GetVars($1)(BAD_ID, 0, NULL, NULL, NULL, value);
    IF (err != NC_EBADID)
        EXPECT_ERR(NC_EBADID, err)
    ELSE_NOK

    err = GetVars($1)(ncid, BAD_VARID, NULL, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        EXPECT_ERR(NC_ENOTVAR, err)
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = GetVars($1)(BAD_ID, i, NULL, NULL, NULL, value);
        IF (err != NC_EBADID)
            EXPECT_ERR(NC_EBADID, err)
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) CheckText($1);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
        }

ifdef(`PNETCDF',`dnl
        /* for non-scalar variables, argument start cannot be NULL */
        err = GetVars($1)(ncid, i, NULL, NULL, NULL, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                EXPECT_ERR(NC_ECHAR, err)
            ELSE_NOK
        }
        else if (var_rank[i] == 0) {
            index[0] = 0;
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_ITYPE($1));
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_ITYPE($1)) &&
                CheckRange($1, expect[0])) {
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
            else IF (err != NC_ERANGE) EXPECT_ERR(NC_ERANGE, err)
        }
        else IF (err != NC_EINVALCOORDS) {
            EXPECT_ERR(NC_EINVALCOORDS, err)
        }
        ELSE_NOK

        /* for non-scalar variables, argument count cannot be NULL */
        err = GetVars($1)(ncid, i, start, NULL, NULL, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                EXPECT_ERR(NC_ECHAR, err)
            ELSE_NOK
        }
        else if (var_rank[i] == 0) {
            index[0] = 0;
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_ITYPE($1));
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_ITYPE($1)) &&
                CheckRange($1, expect[0])) {
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
            else IF (err != NC_ERANGE) EXPECT_ERR(NC_ERANGE, err)
        }
        else IF (err != NC_EEDGE)
            EXPECT_ERR(NC_EEDGE, err)
        ELSE_NOK
')dnl

        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = GetVars($1)(ncid, i, start, edge, stride, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;
            err = GetVars($1)(ncid, i, start, edge, stride, value);
            IF (err != NC_EEDGE)
                EXPECT_ERR(NC_EEDGE, err)
            edge[j] = 1;
            stride[j] = 0;
            err = GetVars($1)(ncid, i, start, edge, stride, value);
            IF (err != NC_ESTRIDE)
                EXPECT_ERR(NC_ESTRIDE, err)
            stride[j] = 1;
        }

        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = GetVars($1)(ncid, i, start, edge, stride, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                EXPECT_ERR(NC_NOERR, err)
            start[j] = var_shape[i][j]+1;  /* should cause NC_EINVALCOORDS */
            err = GetVars($1)(ncid, i, start, edge, stride, value);
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            start[j] = 0;
ifdef(`PNETCDF',,``#'if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=7)')
            stride[j] = 0;
            err = GetVars($1)(ncid, i, start, edge, stride, value);
            IF (err != NC_ESTRIDE)
                EXPECT_ERR(NC_ESTRIDE, err)
            stride[j] = 1;
ifdef(`PNETCDF',,``#'endif')
        }

        err = GetVars($1)(ncid, i, start, edge, stride, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                EXPECT_ERR(NC_ECHAR, err)
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_ITYPE($1));
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_ITYPE($1)) &&
                CheckRange($1, expect[0])) {
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
ifelse(`$1',`uchar',`ifdef(`PNETCDF',,``#'if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>7)')')
            else IF (err != NC_ERANGE) EXPECT_ERR(NC_ERANGE, err)
ifelse(`$1',`uchar',`ifdef(`PNETCDF',,``#'endif')')
        } else {
            IF (err != NC_NOERR)
                EXPECT_ERR(NC_NOERR, err)
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                stride[j] = (PTRDType)sstride[j];
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j]-index[j]-1) / (IntType)stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * (IntType)stride[j];
                        stride[j] = -stride[j];
                    }
                }
*/
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * (IntType)stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i],
                                      index2, NCT_ITYPE($1));
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_ITYPE($1))) {
		        IfCheckTextChar($1, var_type[i])
                            allInIntRange &= CheckRange($1,expect[j]);
                    } else
                        allInExtRange = 0;
                }
                err = GetVars($1)(ncid, i, index, count, stride, value);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                EXPECT_ERR(NC_NOERR, err)
                        }
                        PNETCDF_CHECK_ERANGE($1)
                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            EXPECT_ERR(NC_NOERR or NC_ERANGE, err)
                    }
                    for (j = 0; j < nels; j++) {
                        if (CheckNumRange($1, expect[j], var_type[i])) {
                            ifelse(`$1', `uchar', `
                            /* in put_vars(), API _put_vara_double() is used to
                             * write the NC_BYTE variables to files. In this
                             * case, NC_BYTE variables are treated as signed
                             * for CDF-1 and 2 formats. Thus, we must skip the
                             * equal test below for uchar.
                             */
                            if (cdf_format < NC_FORMAT_CDF5 && var_type[i] == NC_BYTE && expect[j] > schar_max) continue;')
                            IF (!equal((double)value[j],expect[j],var_type[i], NCT_ITYPE($1))){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("var_type: %s, ", s_nc_type(var_type[i]));
                                    error("element number: %d, ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        EXPECT_ERR(NC_ECHAR, err)
                }
            }
        }

    }
    err = APIFunc(close)(ncid);
    IF (err != NC_NOERR)
        error("close: %s", APIFunc(strerror)(err));
    return nok;
}
')dnl

TEST_NC_GET_VARS(text)
TEST_NC_GET_VARS(uchar)
TEST_NC_GET_VARS(schar)
TEST_NC_GET_VARS(short)
TEST_NC_GET_VARS(int)
TEST_NC_GET_VARS(long)
TEST_NC_GET_VARS(float)
TEST_NC_GET_VARS(double)
TEST_NC_GET_VARS(ushort)
TEST_NC_GET_VARS(uint)
TEST_NC_GET_VARS(longlong)
TEST_NC_GET_VARS(ulonglong)


dnl TEST_NC_GET_VARM(TYPE)
dnl
define(`TEST_NC_GET_VARM',dnl
`dnl
int
TestFunc(varm)_$1(VarArgs)
{
    int i, k, d, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    PTRDType nstarts;   /* number of different starts */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    IntType j, m, nels;
    IntType start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    IntType index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    IntType sstride[MAX_RANK];
    PTRDType stride[MAX_RANK], imap[MAX_RANK];
    double expect[MAX_NELS];
    $1 value[MAX_NELS];

    err = FileOpen(testfile, NC_NOWRITE);
    IF (err != NC_NOERR) error("open: %s", APIFunc(strerror)(err));

    err = APIFunc(inq_format)(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s", APIFunc(strerror)(err));

    err = GetVarm($1)(BAD_ID, 0, NULL, NULL, NULL, NULL, value);
    IF (err != NC_EBADID)
        EXPECT_ERR(NC_EBADID, err)
    ELSE_NOK

    err = GetVarm($1)(ncid, BAD_VARID, NULL, NULL, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        EXPECT_ERR(NC_ENOTVAR, err)
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = GetVars($1)(BAD_ID, i, NULL, NULL, NULL, value);
        IF (err != NC_EBADID)
            EXPECT_ERR(NC_EBADID, err)
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) CheckText($1);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
            imap[j] = 1;
        }

ifdef(`PNETCDF',`dnl
        /* for non-scalar variables, argument start cannot be NULL */
        err = GetVarm($1)(ncid, i, NULL, NULL, NULL, NULL, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                EXPECT_ERR(NC_ECHAR, err)
            ELSE_NOK
        }
        else if (var_rank[i] == 0) {
            index[0] = 0;
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_ITYPE($1));
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_ITYPE($1)) &&
                CheckRange($1, expect[0])) {
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
            else IF (err != NC_ERANGE) EXPECT_ERR(NC_ERANGE, err)
        }
        else IF (err != NC_EINVALCOORDS) {
            EXPECT_ERR(NC_EINVALCOORDS, err)
        }
        ELSE_NOK

        /* for non-scalar variables, argument count cannot be NULL */
        err = GetVarm($1)(ncid, i, start, NULL, NULL, NULL, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                EXPECT_ERR(NC_ECHAR, err)
            ELSE_NOK
        }
        else if (var_rank[i] == 0) {
            index[0] = 0;
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_ITYPE($1));
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_ITYPE($1)) &&
                CheckRange($1, expect[0])) {
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
            else IF (err != NC_ERANGE) EXPECT_ERR(NC_ERANGE, err)
        }
        else IF (err != NC_EEDGE)
            EXPECT_ERR(NC_EEDGE, err)
        ELSE_NOK
')dnl

        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = GetVarm($1)(ncid, i, start, edge, stride, imap, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;
            err = GetVarm($1)(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_EEDGE)
                EXPECT_ERR(NC_EEDGE, err)
            edge[j] = 1;
            stride[j] = 0;
            err = GetVarm($1)(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_ESTRIDE)
                EXPECT_ERR(NC_ESTRIDE, err)
            stride[j] = 1;
        }

        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = GetVarm($1)(ncid, i, start, edge, stride, imap, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                EXPECT_ERR(NC_NOERR, err)
            start[j] = var_shape[i][j]+1;  /* should cause NC_EINVALCOORDS */
            err = GetVarm($1)(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            start[j] = 0;
ifdef(`PNETCDF',,``#'if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=7)')
            stride[j] = 0;
            err = GetVarm($1)(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_ESTRIDE)
                EXPECT_ERR(NC_ESTRIDE, err)
            stride[j] = 1;
ifdef(`PNETCDF',,``#'endif')
        }

        err = GetVarm($1)(ncid, i, start, edge, stride, imap, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                EXPECT_ERR(NC_ECHAR, err)
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_ITYPE($1));
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_ITYPE($1)) &&
                CheckRange($1, expect[0])) {
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
ifelse(`$1',`uchar',`ifdef(`PNETCDF',,``#'if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>7)')')
            else IF (err != NC_ERANGE) EXPECT_ERR(NC_ERANGE, err)
ifelse(`$1',`uchar',`ifdef(`PNETCDF',,``#'endif')')
        } else {
            IF (err != NC_NOERR)
                EXPECT_ERR(NC_NOERR, err)
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                stride[j] = (PTRDType)sstride[j];
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j]-index[j]-1) / (IntType)stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * (IntType)stride[j];
                        stride[j] = -stride[j];
                    }
                }
 */
                if (var_rank[i] > 0) {
                    int jj = var_rank[i] - 1;
                    imap[jj] = 1;
                    for (; jj > 0; jj--)
                        imap[jj-1] = imap[jj] * (PTRDType)count[jj];
                }
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * (IntType)stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i],
                                      index2, NCT_ITYPE($1));
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_ITYPE($1))) {
		        IfCheckTextChar($1, var_type[i])
                            allInIntRange &= CheckRange($1,expect[j]);
                    } else
                        allInExtRange = 0;
                }
                err = GetVarm($1)(ncid,i,index,count,stride,imap,value);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                EXPECT_ERR(NC_NOERR, err)
                        }
                        PNETCDF_CHECK_ERANGE($1)
                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            EXPECT_ERR(NC_NOERR or NC_ERANGE, err)
                    }
                    for (j = 0; j < nels; j++) {
                        if (CheckNumRange($1, expect[j], var_type[i])) {
                            ifelse(`$1', `uchar', `
                            /* in put_vars(), API _put_vara_double() is used to
                             * write the NC_BYTE variables to files. In this
                             * case, NC_BYTE variables are treated as signed
                             * for CDF-1 and 2 formats. Thus, we must skip the
                             * equal test below for uchar.
                             */
                            if (cdf_format < NC_FORMAT_CDF5 && var_type[i] == NC_BYTE && expect[j] > schar_max) continue;')
                            IF (!equal((double)value[j],expect[j],var_type[i], NCT_ITYPE($1))){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("var_type: %s, ", s_nc_type(var_type[i]));
                                    error("element number: %d, ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        EXPECT_ERR(NC_ECHAR, err)
                }
            }
        }
    }
    err = APIFunc(close)(ncid);
    IF (err != NC_NOERR)
        error("close: %s", APIFunc(strerror)(err));
    return nok;
}
')dnl

TEST_NC_GET_VARM(text)
TEST_NC_GET_VARM(uchar)
TEST_NC_GET_VARM(schar)
TEST_NC_GET_VARM(short)
TEST_NC_GET_VARM(int)
TEST_NC_GET_VARM(long)
TEST_NC_GET_VARM(float)
TEST_NC_GET_VARM(double)
TEST_NC_GET_VARM(ushort)
TEST_NC_GET_VARM(uint)
TEST_NC_GET_VARM(longlong)
TEST_NC_GET_VARM(ulonglong)


dnl TEST_NC_GET_ATT(TYPE)
dnl
define(`TEST_NC_GET_ATT',dnl
`dnl
int
TestFunc(att)_$1(AttVarArgs)
{
    int i, j, err, ncid, cdf_format;
    IntType k, ndx[1];
    int allInExtRange;
    int allInIntRange;
    int canConvert;     /* Both text or both numeric */
    int nok = 0;        /* count of valid comparisons */
    double expect[MAX_NELS];
    $1 value[MAX_NELS];

    err = FileOpen(testfile, NC_NOWRITE);
    IF (err != NC_NOERR) error("open: %s", APIFunc(strerror)(err));

    err = APIFunc(inq_format)(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s", APIFunc(strerror)(err));

    err = GetAtt($1)(BAD_ID, 0, NULL, value);
    IF (err != NC_EBADID)
        EXPECT_ERR(NC_EBADID, err)
    ELSE_NOK

    err = GetAtt($1)(ncid, BAD_VARID, NULL, value);
    IF (err != NC_ENOTVAR)
        EXPECT_ERR(NC_ENOTVAR, err)
    ELSE_NOK

    for (i = -1; i < numVars; i++) {
        for (j = 0; j < NATTS(i); j++) {
            canConvert = (ATT_TYPE(i,j) == NC_CHAR) CheckText($1);

            err = GetAtt($1)(ncid, BAD_VARID, ATT_NAME(i,j), value);
            IF (err != NC_ENOTVAR)
                EXPECT_ERR(NC_ENOTVAR, err)
            ELSE_NOK

ifdef(`PNETCDF',,``#'if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>7)')
            /* check if can detect a bad name */
            err = GetAtt($1)(ncid, i, NULL, NULL);
            IF (err != NC_EBADNAME)
                EXPECT_ERR(NC_EBADNAME, err)
            ELSE_NOK
ifdef(`PNETCDF',,``#'endif')

            err = GetAtt($1)(ncid, i, "noSuch", value);
            IF (err != NC_ENOTATT)
                EXPECT_ERR(NC_ENOTATT, err)
            ELSE_NOK

            allInExtRange = allInIntRange = 1;
            for (k = 0; k < ATT_LEN(i,j); k++) {
                ndx[0] = k;
                expect[k] = hash4(cdf_format, ATT_TYPE(i,j), -1, ndx, NCT_ITYPE($1));
                if (inRange3(cdf_format, expect[k],ATT_TYPE(i,j),NCT_ITYPE($1))) {
		    /* netCDF specification make a special case for type
		     * conversion between uchar and scahr: do not check for
		     * range error. See
		     * http://www.unidata.ucar.edu/software/netcdf/docs/data_type.html#type_conversion
                     */
		    IfCheckTextChar($1, ATT_TYPE(i,j))
		    ifelse(`$1',`uchar', `if (cdf_format > NC_FORMAT_64BIT_OFFSET || (cdf_format < NC_FORMAT_CDF5 && ATT_TYPE(i,j) != NC_BYTE))')
                        allInIntRange &= CheckRange($1,expect[k]);
                } else {
                    allInExtRange = 0;
                }
            }
            err = GetAtt($1)(ncid, i, ATT_NAME(i,j), value);
            if (canConvert || ATT_LEN(i,j) == 0) {
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (err != NC_NOERR)
                            EXPECT_ERR(NC_NOERR, err)
ifelse(`$1',`uchar',`ifdef(`PNETCDF',,``#'if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>7)')')
                    } else {
                        IF (err != NC_ERANGE)
                            EXPECT_ERR(NC_ERANGE, err)
ifelse(`$1',`uchar',`ifdef(`PNETCDF',,``#'endif')')
                    }
                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        EXPECT_ERR(NC_NOERR or NC_ERANGE, err)
                }
                for (k = 0; k < ATT_LEN(i,j); k++) {
                    if (CheckNumRange($1, expect[k], ATT_TYPE(i,j))) {
                        ifelse(`$1', `uchar', `
                        /* in put_vars(), API _put_vara_double() is used to
                         * write the NC_BYTE variables to files. In this
                         * case, NC_BYTE variables are treated as signed
                         * for CDF-1 and 2 formats. Thus, we must skip the
                         * equal test below for uchar.
                         */
                        if (cdf_format < NC_FORMAT_CDF5 && ATT_TYPE(i,j) == NC_BYTE && expect[k] > schar_max) continue;')
                        IF (!equal((double)value[k],expect[k],ATT_TYPE(i,j), NCT_ITYPE($1))){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                if (i == -1)
                                    error("var_type: GLOBAL, ");
                                else
                                    error("var_name: %s var_type: %s, ", var_name[i],s_nc_type(var_type[i]));
                                error("att_name: %s, ", ATT_NAME(i,j));
                                error("att_type: %s, ", s_nc_type(ATT_TYPE(i,j)));
                                error("element number: %d, ", k);
                                error("expect: %g, ", expect[k]);
                                error("got: %g", (double) value[k]);
                            }
                        } else {
                            nok++;
                        }
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
            }
        }
    }

    err = APIFunc(close)(ncid);
    IF (err != NC_NOERR)
        error("close: %s", APIFunc(strerror)(err));
    return nok;
}
')dnl

TEST_NC_GET_ATT(text)
TEST_NC_GET_ATT(uchar)
TEST_NC_GET_ATT(schar)
TEST_NC_GET_ATT(short)
TEST_NC_GET_ATT(int)
TEST_NC_GET_ATT(long)
TEST_NC_GET_ATT(float)
TEST_NC_GET_ATT(double)
TEST_NC_GET_ATT(ushort)
TEST_NC_GET_ATT(uint)
TEST_NC_GET_ATT(longlong)
TEST_NC_GET_ATT(ulonglong)

